/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.business.helper.RecBillOverAmountHelper;
import kd.fi.cas.business.helper.RecClaimBillHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.ClaimHandleStatusEnum;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.enums.ClaimTypeEnum;
import kd.fi.cas.enums.MergeStatusEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CodeRuleHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.RecClaimHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.param.ClaimNoticeMesParam;
import kd.fi.cas.result.InvokeResult;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.PropertyEqualChecker;

public class CommonOperationHandler2 {
    private static Log logger = LogFactory.getLog(CommonOperationHandler2.class);
    public static final String CAS_CLAIM_CATEGORY = "cas_claim_category";

    public static InvokeResult mergeClaimAnnounceBill(Object[] ids, boolean isNotComfirm) {
        QFilter claimtypeQf;
        QFilter creatorQf;
        Boolean resultBool;
        InvokeResult ret = new InvokeResult();
        DynamicObject[] recClaimBill = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_claimcenterbill"));
        String businessType = "";
        DynamicObject org = null;
        String oppUnit = "";
        DynamicObject currency = null;
        Boolean isaddfee = Boolean.FALSE;
        BigDecimal fee = BigDecimal.ZERO;
        Date bizdate = null;
        DynamicObject accountbank = null;
        DynamicObject bank = null;
        String settlementtype = "";
        String oppUnitTemp = "";
        Boolean isaddfeeTemp = Boolean.FALSE;
        Date bizdateTemp = null;
        boolean isNotMerge = false;
        boolean infoNotSame = false;
        boolean infoPayNotSame = false;
        boolean oppUnitNotSame = false;
        Boolean isNotSameDate = false;
        DynamicObject recDy = null;
        ArrayList<DynamicObject> unClaims = new ArrayList<DynamicObject>();
        for (int i = 0; i < recClaimBill.length; ++i) {
            recDy = recClaimBill[i];
            if (StringUtils.equals((CharSequence)MergeStatusEnum.MARFED.getValue(), (CharSequence)recDy.getString("mergestatus"))) {
                ret.setErrorMsg(String.format(ResManager.loadKDString((String)"\u901a\u77e5\u5355%1$s\u4e3a\u5df2\u88ab\u5408\u5e76\uff0c\u8bf7\u5237\u65b0\u91cd\u65b0\u64cd\u4f5c\u5408\u5e76\u3002", (String)"CommonOperationHandler_0", (String)"fi-cas-formplugin", (Object[])new Object[0]), recDy.getString("billno")));
                return ret;
            }
            if (recDy.getBoolean("isunclaim")) {
                ret.setErrorMsg(String.format(ResManager.loadKDString((String)"\u901a\u77e5\u5355\u201c%1$s\u201d\u5df2\u672a\u8ba4\u9886\u5165\u8d26\uff0c\u4e0d\u5141\u8bb8\u5408\u5e76\u3002", (String)"CommonOperationHandler_1", (String)"fi-cas-formplugin", (Object[])new Object[0]), recDy.getString("billno")));
                return ret;
            }
            if (!(StringUtils.equals((CharSequence)ClaimStatusEnum.WAIT.getValue(), (CharSequence)recDy.getString("claimstatus")) || StringUtils.equals((CharSequence)ClaimStatusEnum.PART.getValue(), (CharSequence)recDy.getString("claimstatus")) || StringUtils.equals((CharSequence)ClaimStatusEnum.CLAIMED.getValue(), (CharSequence)recDy.getString("claimstatus")))) {
                ret.setErrorMsg(ResManager.loadKDString((String)"\u53ea\u6709\u53ef\u8ba4\u9886\u9875\u7b7e\u7684\u5355\u636e\u624d\u80fd\u5408\u5e76\u3002", (String)"CommonOperationHandler_2", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return ret;
            }
            if (i > 0) {
                if (!(StringUtils.equals((CharSequence)businessType, (CharSequence)"pay") || isaddfee.booleanValue() == recDy.getBoolean("isaddfee") || isaddfee.booleanValue() && recDy.getBigDecimal("fee").compareTo(BigDecimal.ZERO) == 0 || fee.compareTo(BigDecimal.ZERO) == 0 && recDy.getBoolean("isaddfee"))) {
                    infoNotSame = true;
                    break;
                }
                if (!StringUtils.equals((CharSequence)businessType, (CharSequence)"pay") && recDy.getBoolean("isaddfee")) {
                    isaddfeeTemp = recDy.getBoolean("isaddfee");
                }
                if (!StringUtils.equals((CharSequence)oppUnit, (CharSequence)(oppUnitTemp = recDy.getString("oppUnit")))) {
                    oppUnitNotSame = true;
                    break;
                }
                bizdateTemp = recDy.getDate("bizdate");
                if (bizdate == null || bizdateTemp == null) {
                    if (bizdate == null) {
                        bizdate = bizdateTemp;
                    }
                    isNotSameDate = true;
                } else {
                    bizdate = DateUtils.truncateDate(bizdate);
                    if ((bizdateTemp = DateUtils.truncateDate((Date)bizdateTemp)).compareTo(bizdate) != 0) {
                        isNotSameDate = true;
                    }
                    if (bizdateTemp.after(bizdate)) {
                        bizdate = bizdateTemp;
                    }
                }
            } else {
                businessType = recDy.getString("businesstype");
                org = recDy.getDynamicObject("org");
                oppUnit = recDy.getString("oppunit");
                currency = recDy.getDynamicObject("currency");
                isaddfeeTemp = isaddfee = Boolean.valueOf(recDy.getBoolean("isaddfee"));
                fee = recDy.getBigDecimal("fee");
                accountbank = recDy.getDynamicObject("accountbank");
                bank = recDy.getDynamicObject("bank");
                settlementtype = recDy.getString("settlementtype");
                bizdate = recDy.getDate("bizdate");
            }
            if (!StringUtils.equals((CharSequence)recDy.getString("claimstatus"), (CharSequence)ClaimStatusEnum.PART.getValue()) && !StringUtils.equals((CharSequence)recDy.getString("claimstatus"), (CharSequence)ClaimStatusEnum.CLAIMED.getValue())) continue;
            unClaims.add(recDy);
        }
        ArrayList<Function<DynamicObject, Object>> extractors = new ArrayList<Function<DynamicObject, Object>>(10);
        extractors.add(dy -> dy.getString("businesstype"));
        extractors.add(dy -> EmptyUtil.isNoEmpty((DynamicObject)dy.getDynamicObject("org")) ? Long.valueOf(dy.getDynamicObject("org").getLong("id")) : null);
        extractors.add(dy -> EmptyUtil.isNoEmpty((DynamicObject)dy.getDynamicObject("currency")) ? Long.valueOf(dy.getDynamicObject("currency").getLong("id")) : null);
        if (!StringUtils.equals((CharSequence)businessType, (CharSequence)"recticket")) {
            extractors.add(dy -> EmptyUtil.isNoEmpty((DynamicObject)dy.getDynamicObject("accountbank")) ? Long.valueOf(dy.getDynamicObject("accountbank").getLong("id")) : null);
        } else {
            extractors.add(dy -> dy.getString("settlementtype"));
        }
        isNotMerge = !PropertyEqualChecker.areAllPropertiesEqual(Arrays.stream(recClaimBill).collect(Collectors.toList()), extractors);
        boolean payerNotUnique = SystemParameterHelper.getParameterBoolean((long)org.getLong("id"), (String)"payernotcliam");
        boolean payeeNotUnique = SystemParameterHelper.getParameterBoolean((long)org.getLong("id"), (String)"payeenotunique");
        if (StringUtils.equals((CharSequence)businessType, (CharSequence)"rec")) {
            resultBool = CommonOperationHandler2.getResultByParameter(ret, payerNotUnique, isNotMerge, oppUnitNotSame);
            if (resultBool.booleanValue()) {
                return ret;
            }
        } else if (StringUtils.equals((CharSequence)businessType, (CharSequence)"pay")) {
            resultBool = CommonOperationHandler2.getResultByParameter(ret, payeeNotUnique, isNotMerge, oppUnitNotSame);
            if (resultBool.booleanValue()) {
                return ret;
            }
        } else if (isNotMerge || oppUnitNotSame) {
            ret.setErrorMsg(ResManager.loadKDString((String)"\u53ea\u6709\u76f8\u540c\u4e1a\u52a1\u7c7b\u578b\uff08\u7968\u636e\u7684\u8bdd\u8fd8\u8981\u6c42\u662f\u76f8\u540c\u7c7b\u522b\uff09\u3001\u8d44\u91d1\u7ec4\u7ec7\u3001\u94f6\u884c\u8d26\u53f7\u3001\u5bf9\u65b9\u6237\u540d\u3001\u5e01\u79cd\u7684\u901a\u77e5\u5355\u624d\u80fd\u5408\u5e76\u3002", (String)"NoticeListPlugin_18", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return ret;
        }
        if (infoNotSame) {
            ret.setErrorMsg(ResManager.loadKDString((String)"\u6240\u5408\u5e76\u5355\u636e\u7684\u516c\u5171\u4fe1\u606f\uff08\u6536\u6b3e\u7c7b\u578b\u3001\u4ed8\u6b3e\u7c7b\u578b\u3001\u4ed8\u6b3e\u4eba\u3001\u624b\u7eed\u8d39\u4fe1\u606f\uff09\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5408\u5e76\u3002", (String)"NoticeListPlugin_19", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return ret;
        }
        HashMap<String, Object> sameFiled = new HashMap<String, Object>(10);
        DynamicObject unClaim = null;
        if (!unClaims.isEmpty()) {
            unClaim = (DynamicObject)unClaims.get(0);
            Long recpaytype = 0L;
            if (EmptyUtil.isNoEmpty((DynamicObject)unClaim.getDynamicObject("recpaytype"))) {
                recpaytype = unClaim.getDynamicObject("recpaytype").getLong("id");
            }
            Long payType = 0L;
            if (EmptyUtil.isNoEmpty((DynamicObject)unClaim.getDynamicObject("paytype"))) {
                payType = unClaim.getDynamicObject("paytype").getLong("id");
            }
            Long recbasepayee = 0L;
            if (EmptyUtil.isNoEmpty((DynamicObject)unClaim.getDynamicObject("recbasepayee"))) {
                recbasepayee = unClaim.getDynamicObject("recbasepayee").getLong("id");
            }
            String payeetype = unClaim.getString("payeetype");
            String recviewpayer = unClaim.getString("recviewpayer");
            String recpayee = unClaim.getString("recpayee");
            String paymenttype = unClaim.getString("paymenttype");
            String recpayer = unClaim.getString("recpayer");
            String type = unClaim.getString("businesstype");
            if (unClaims.size() > 1) {
                for (int j = 1; j < unClaims.size(); ++j) {
                    unClaim = (DynamicObject)unClaims.get(j);
                    if (!(!"rec".equals(type) || recpaytype.compareTo(unClaim.getDynamicObject("recpaytype").getLong("id")) == 0 && StringUtils.equals((CharSequence)paymenttype, (CharSequence)unClaim.getString("paymenttype")) && StringUtils.equals((CharSequence)recpayer, (CharSequence)unClaim.getString("recpayer")))) {
                        infoNotSame = true;
                        break;
                    }
                    if (!"pay".equals(type) || payType.compareTo(unClaim.getDynamicObject("payType").getLong("id")) == 0 && StringUtils.equals((CharSequence)payeetype, (CharSequence)unClaim.getString("payeetype")) && StringUtils.equals((CharSequence)recviewpayer, (CharSequence)unClaim.getString("recviewpayer"))) continue;
                    infoPayNotSame = true;
                    break;
                }
            }
            sameFiled.put("recpaytype", recpaytype);
            sameFiled.put("paymenttype", paymenttype);
            sameFiled.put("recpayer", recpayer);
            sameFiled.put("paytype", payType);
            sameFiled.put("recbasepayee", recbasepayee);
            sameFiled.put("payeetype", payeetype);
            sameFiled.put("recviewpayer", recviewpayer);
            sameFiled.put("recpayee", recpayee);
        }
        if (infoPayNotSame) {
            ret.setErrorMsg(ResManager.loadKDString((String)"\u6240\u5408\u5e76\u5355\u636e\u7684\u516c\u5171\u4fe1\u606f\uff08\u4ed8\u6b3e\u7c7b\u578b\u3001\u6536\u6b3e\u4eba\u7c7b\u578b\u3001\u6536\u6b3e\u4eba\uff09\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5408\u5e76\u3002", (String)"CommonOperationHandler_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return ret;
        }
        if (infoNotSame) {
            ret.setErrorMsg(ResManager.loadKDString((String)"\u6240\u5408\u5e76\u5355\u636e\u7684\u516c\u5171\u4fe1\u606f\uff08\u6536\u6b3e\u7c7b\u578b\u3001\u4ed8\u6b3e\u4eba\u7c7b\u578b\u3001\u4ed8\u6b3e\u4eba\u3001\u624b\u7eed\u8d39\u4fe1\u606f\uff09\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5408\u5e76\u3002", (String)"CommonOperationHandler_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return ret;
        }
        if (isNotComfirm && isNotSameDate.booleanValue()) {
            ret.setWarningMsg(ResManager.loadKDString((String)"\u60a8\u8981\u5408\u5e76\u7684\u901a\u77e5\u5355\u4e1a\u52a1\u65e5\u671f\u4e0d\u4e00\u81f4\uff0c\u5c06\u4ee5\u6700\u665a\u7684\u65e5\u671f\u4f5c\u4e3a\u7edf\u4e00\u7684\u4e1a\u52a1\u65e5\u671f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CommonOperationHandler_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            ret.put("needUserConfirm", (Object)true);
            return ret;
        }
        List billno = Arrays.stream(recClaimBill).map(o -> o.getString("billno")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("claimno", "in", billno);
        DynamicObject[] claimblls = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id", (QFilter[])new QFilter[]{qFilter, creatorQf = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId())), claimtypeQf = new QFilter("claimtype", "=", (Object)ClaimTypeEnum.CLAIM.getValue())});
        if (CasHelper.isNotEmpty((Object)claimblls) && claimblls.length > 1) {
            ret.setErrorMsg(ResManager.loadKDString((String)"\u6240\u9009\u8ba4\u9886\u901a\u77e5\u5355\u4e2d\uff0c\u5df2\u5b58\u5728\u591a\u7b14\u8ba4\u9886\u5355\uff0c\u4e0d\u5141\u8bb8\u5408\u5e76\u8ba4\u9886\u3002", (String)"NoticeListPlugin_28", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return ret;
        }
        sameFiled.put("businessType", businessType);
        sameFiled.put("org", org.getPkValue());
        sameFiled.put("oppUnit", oppUnit);
        sameFiled.put("currency", currency.getPkValue());
        sameFiled.put("isaddfee", isaddfeeTemp);
        if (EmptyUtil.isNoEmpty((DynamicObject)accountbank)) {
            sameFiled.put("accountbank", accountbank.getPkValue());
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)bank)) {
            sameFiled.put("bank", bank.getPkValue());
        }
        sameFiled.put("settlementtype", settlementtype);
        sameFiled.put("bizdate", bizdate);
        Map claimMergeRet = CommonOperationHandler2.claimMerge(recClaimBill, sameFiled);
        Set entrySet = claimMergeRet.entrySet();
        for (Map.Entry entry : entrySet) {
            ret.put((String)entry.getKey(), entry.getValue());
        }
        ret.setSuccess(true);
        return ret;
    }

    public static Map claimMerge(DynamicObject[] recClaimBills, Map<String, Object> sameFiled) {
        Object[] load;
        DynamicObject mergeClaim = new DynamicObject(recClaimBills[0].getDynamicObjectType());
        mergeClaim.set("org", sameFiled.get("org"));
        Long pkId = DB.genGlobalLongId();
        mergeClaim.set("id", (Object)pkId);
        mergeClaim.set("billstatus", (Object)"A");
        mergeClaim.set("mergestatus", (Object)MergeStatusEnum.ALMARGE.getValue());
        mergeClaim.set("createtime", (Object)new Date());
        mergeClaim.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
        mergeClaim.set("businessType", sameFiled.get("businessType"));
        mergeClaim.set("oppunit", sameFiled.get("oppUnit"));
        if (CommonOperationHandler2.isJudgeSameField(recClaimBills, "oppbanknumber")) {
            mergeClaim.set("oppbanknumber", (Object)recClaimBills[0].getString("oppbanknumber"));
        }
        if (CommonOperationHandler2.isJudgeSameField(recClaimBills, "oppbank")) {
            mergeClaim.set("oppbank", (Object)recClaimBills[0].getString("oppbank"));
        }
        mergeClaim.set("currency", sameFiled.get("currency"));
        mergeClaim.set("isaddfee", sameFiled.get("isaddfee"));
        mergeClaim.set("accountbank", sameFiled.get("accountbank"));
        mergeClaim.set("bank", sameFiled.get("bank"));
        mergeClaim.set("settlementtype", sameFiled.get("settlementtype"));
        mergeClaim.set("bizdate", sameFiled.get("bizdate"));
        mergeClaim.set("recpaytype", sameFiled.get("recpaytype"));
        mergeClaim.set("paymenttype", sameFiled.get("paymenttype"));
        mergeClaim.set("recpayer", sameFiled.get("recpayer"));
        mergeClaim.set("paytype", sameFiled.get("paytype"));
        mergeClaim.set("recbasepayee", sameFiled.get("recbasepayee"));
        mergeClaim.set("payeetype", sameFiled.get("payeetype"));
        mergeClaim.set("recviewpayer", sameFiled.get("recviewpayer"));
        mergeClaim.set("recpayee", sameFiled.get("recpayee"));
        String generateNumber = CodeRuleHelper.generateNumber((String)recClaimBills[0].getDataEntityType().getName(), (DynamicObject)mergeClaim, null, null);
        mergeClaim.set("billno", (Object)generateNumber);
        BigDecimal reamount = BigDecimal.ZERO;
        BigDecimal payamount = BigDecimal.ZERO;
        BigDecimal fee = BigDecimal.ZERO;
        BigDecimal claimedamount = BigDecimal.ZERO;
        BigDecimal unClaimedamount = BigDecimal.ZERO;
        BigDecimal e_discountamt = BigDecimal.ZERO;
        Boolean singleStream = false;
        String claimstatus = ClaimStatusEnum.WAIT.getValue();
        DynamicObjectCollection entry = mergeClaim.getDynamicObjectCollection("entryentity");
        Set claimFields = EntityPropertyHelper.getEntryPropertys((String)"cas_claimcenterbill", (String)"entryentity.");
        DynamicObjectCollection payentity = mergeClaim.getDynamicObjectCollection("payentity");
        Set payClaimFields = EntityPropertyHelper.getEntryPropertys((String)"cas_claimcenterbill", (String)"payentity.");
        DynamicObjectCollection typeEntry = mergeClaim.getDynamicObjectCollection("entryentity1");
        Set typeFields = EntityPropertyHelper.getEntryPropertys((String)"cas_claimcenterbill", (String)"entryentity1.");
        DynamicObject recClaimBill = null;
        HashSet<String> joinclaim = new HashSet<String>(10);
        HashSet<String> joinunit = new HashSet<String>(10);
        HashSet<String> joinrule = new HashSet<String>(10);
        HashMap<String, Set<String>> addUserMap = new HashMap<String, Set<String>>();
        Set<String> adduser = new HashSet();
        for (int i = 0; i < recClaimBills.length; ++i) {
            DynamicObjectCollection claimtypeEntry;
            DynamicObjectCollection payEntry;
            recClaimBill = recClaimBills[i];
            DynamicObjectCollection recEntry = recClaimBill.getDynamicObjectCollection("entryentity");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)recEntry)) {
                for (Object dynamicObject : recEntry) {
                    DynamicObject newEntry = entry.addNew();
                    for (Object chgField : claimFields) {
                        newEntry.set((String)chgField, dynamicObject.get((String)chgField));
                    }
                    e_discountamt = e_discountamt.add(dynamicObject.getBigDecimal("e_discountamt"));
                }
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(payEntry = recClaimBill.getDynamicObjectCollection("payentity")))) {
                Object dynamicObject;
                dynamicObject = payEntry.iterator();
                while (dynamicObject.hasNext()) {
                    Object chgField;
                    DynamicObject dynamicObject2 = (DynamicObject)dynamicObject.next();
                    DynamicObject newEntry = payentity.addNew();
                    chgField = payClaimFields.iterator();
                    while (chgField.hasNext()) {
                        String chgField2 = (String)chgField.next();
                        newEntry.set(chgField2, dynamicObject2.get(chgField2));
                    }
                }
            }
            if (ClaimStatusEnum.PART.getValue().equals(recClaimBill.getString("claimstatus")) || ClaimStatusEnum.CLAIMED.getValue().equals(recClaimBill.getString("claimstatus"))) {
                claimstatus = ClaimStatusEnum.PART.getValue();
            }
            if ((singleStream = Boolean.valueOf(recClaimBill.getBoolean("singlestream"))).booleanValue()) {
                singleStream = true;
            }
            reamount = reamount.add(recClaimBill.getBigDecimal("reamount"));
            payamount = payamount.add(recClaimBill.getBigDecimal("payamount"));
            fee = fee.add(recClaimBill.getBigDecimal("fee"));
            claimedamount = claimedamount.add(recClaimBill.getBigDecimal("claimedamount"));
            unClaimedamount = unClaimedamount.add(recClaimBill.getBigDecimal("unclaimamount"));
            if (EmptyUtil.isNoEmpty((String)recClaimBill.getString("joinclaim"))) {
                joinclaim.addAll(Arrays.asList(recClaimBill.getString("joinclaim").split(",")));
            }
            if (EmptyUtil.isNoEmpty((String)recClaimBill.getString("joinunit"))) {
                joinunit.addAll(Arrays.asList(recClaimBill.getString("joinunit").split(",")));
            }
            if (EmptyUtil.isNoEmpty((String)recClaimBill.getString("joinrule"))) {
                joinrule.addAll(Arrays.asList(recClaimBill.getString("joinrule").split(",")));
            }
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)(claimtypeEntry = recClaimBill.getDynamicObjectCollection("entryentity1")))) continue;
            for (DynamicObject dynamicObject : claimtypeEntry) {
                adduser = (Set)addUserMap.get(dynamicObject.getString("claimtype"));
                if (adduser == null) {
                    adduser = new HashSet();
                }
                if (adduser.contains(dynamicObject.getString("claimtypeid"))) continue;
                adduser.add(dynamicObject.getString("claimtypeid"));
                addUserMap.put(dynamicObject.getString("claimtype"), adduser);
                DynamicObject newEntry = typeEntry.addNew();
                for (String chgField : typeFields) {
                    newEntry.set(chgField, dynamicObject.get(chgField));
                }
            }
        }
        String claimusersStr = "";
        HashSet allUserIds = new HashSet();
        Set adduserTemp = new HashSet();
        for (Map.Entry userType : addUserMap.entrySet()) {
            adduserTemp = (Set)userType.getValue();
            if (!EmptyUtil.isNoEmpty(adduserTemp)) continue;
            if (StringUtils.equals((CharSequence)"1", (CharSequence)((CharSequence)userType.getKey()))) {
                allUserIds.addAll(adduserTemp.stream().map(userid -> Long.valueOf(userid)).collect(Collectors.toSet()));
                continue;
            }
            if (StringUtils.equals((CharSequence)"2", (CharSequence)((CharSequence)userType.getKey()))) {
                Set collect = adduserTemp.stream().map(Long::valueOf).collect(Collectors.toSet());
                DynamicObjectCollection query = QueryServiceHelper.query((String)"fbd_usergroup", (String)"entryentity.userfield", (QFilter[])new QFilter[]{new QFilter("id", "in", collect).and("enable", "=", (Object)"1")}, null);
                allUserIds.addAll(query.stream().map(o -> o.getLong("entryentity.userfield")).collect(Collectors.toList()));
                continue;
            }
            if (StringUtils.equals((CharSequence)"3", (CharSequence)((CharSequence)userType.getKey()))) {
                allUserIds.addAll(UserServiceHelper.getAllUsersOfOrg((int)0, ((Set)userType.getValue()).stream().map(org -> Long.valueOf(org)).collect(Collectors.toList()), (boolean)true, (boolean)false));
                continue;
            }
            if (!StringUtils.equals((CharSequence)"4", (CharSequence)((CharSequence)userType.getKey()))) continue;
            Iterator roleIt = adduserTemp.iterator();
            while (roleIt.hasNext()) {
                allUserIds.addAll(PermissionServiceHelper.getUsersByRoleID((String)String.valueOf(roleIt.next())));
            }
        }
        if (!EmptyUtil.isEmpty(allUserIds)) {
            DynamicObjectCollection userNames = QueryServiceHelper.query((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", allUserIds)});
            claimusersStr = String.join((CharSequence)",", userNames.stream().map(dy -> dy.getString("name")).collect(Collectors.toCollection(HashSet::new)));
        }
        String joinclaimStr = String.join((CharSequence)",", joinclaim);
        String joinunitStr = String.join((CharSequence)",", joinunit);
        String joinruleStr = String.join((CharSequence)",", joinrule);
        mergeClaim.set("claimusers", (Object)(claimusersStr.length() > 1024 ? claimusersStr.substring(0, 1024) : claimusersStr));
        mergeClaim.set("joinclaim", (Object)(joinclaimStr.length() > 1024 ? joinclaimStr.substring(0, 1024) : joinclaimStr));
        mergeClaim.set("joinunit", (Object)(joinunitStr.length() > 1024 ? joinunitStr.substring(0, 1024) : joinunitStr));
        mergeClaim.set("joinrule", (Object)(joinruleStr.length() > 1024 ? joinruleStr.substring(0, 1024) : joinruleStr));
        mergeClaim.set("payamount", (Object)payamount);
        mergeClaim.set("reamount", (Object)reamount);
        mergeClaim.set("fee", (Object)fee);
        mergeClaim.set("singleStream", (Object)singleStream);
        mergeClaim.set("claimedamount", (Object)claimedamount);
        mergeClaim.set("unclaimamount", (Object)unClaimedamount);
        mergeClaim.set("claimstatus", (Object)claimstatus);
        ArrayList<String> claimNos = new ArrayList<String>(10);
        ArrayList<String> bankcheckflagList = new ArrayList<String>(10);
        Object[] childClaim = null;
        ArrayList<Long> sourceClaimId = new ArrayList<Long>(10);
        ArrayList<DynamicObject> updateRec = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> deleteRec = new ArrayList<DynamicObject>(10);
        HashSet<Long> allSingDetailBill = new HashSet<Long>();
        for (int i = 0; i < recClaimBills.length; ++i) {
            recClaimBill = recClaimBills[i];
            if (StringUtils.equals((CharSequence)recClaimBill.getString("mergestatus"), (CharSequence)MergeStatusEnum.ALMARGE.getValue())) {
                sourceClaimId.add(recClaimBill.getLong("id"));
                deleteRec.add(recClaimBill);
            } else {
                allSingDetailBill.add(recClaimBill.getLong("id"));
                recClaimBill.set("mergestatus", (Object)MergeStatusEnum.MARFED.getValue());
                recClaimBill.set("margeid", (Object)pkId);
                recClaimBill.set("entryentity", null);
                recClaimBill.set("claimstatus", (Object)ClaimStatusEnum.WAIT.getValue());
                recClaimBill.set("claimedamount", (Object)BigDecimal.ZERO);
                if ("pay".equals(recClaimBill.getString("businessType"))) {
                    recClaimBill.set("unclaimamount", (Object)recClaimBill.getBigDecimal("payamount"));
                } else {
                    recClaimBill.set("unclaimamount", (Object)recClaimBill.getBigDecimal("reamount"));
                }
                recClaimBill.set("fee", (Object)BigDecimal.ZERO);
                recClaimBill.set("isaddfee", (Object)false);
                DynamicObjectCollection entryEntity = recClaimBill.getDynamicObjectCollection("bankcheckentity");
                for (DynamicObject bankEntry : entryEntity) {
                    bankcheckflagList.add(bankEntry.getString("ebankcheckflag"));
                }
                updateRec.add(recClaimBill);
            }
            claimNos.add(recClaimBill.getString("billno"));
        }
        ArrayList<Object> updateChildRec = new ArrayList<Object>();
        QFilter margeid = new QFilter("margeid", "in", sourceClaimId);
        childClaim = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"billno,margeid,bankcheckentity.ebankcheckflag", (QFilter[])new QFilter[]{margeid});
        if (EmptyUtil.isNoEmpty((Object[])childClaim)) {
            for (Object child : childClaim) {
                allSingDetailBill.add(child.getLong("id"));
                child.set("margeid", (Object)pkId);
                claimNos.add(child.getString("billno"));
                DynamicObjectCollection childEntryEntity = child.getDynamicObjectCollection("bankcheckentity");
                for (DynamicObject bankEntry : childEntryEntity) {
                    bankcheckflagList.add(bankEntry.getString("ebankcheckflag"));
                }
                updateChildRec.add(child);
            }
        }
        if (bankcheckflagList.size() > 0) {
            DynamicObjectCollection bankCheckEntity = mergeClaim.getDynamicObjectCollection("bankcheckentity");
            for (String item : bankcheckflagList) {
                DynamicObject entryEntity = bankCheckEntity.addNew();
                entryEntity.set("ebankcheckflag", (Object)item);
            }
            String bankcheckflag = String.join((CharSequence)",", bankcheckflagList.stream().filter(EmptyUtil::isNoEmpty).collect(Collectors.toList()));
            mergeClaim.set("bankcheckflag", (Object)(bankcheckflag.length() > 1024 ? bankcheckflag.substring(0, 1024) : bankcheckflag));
        }
        if (EmptyUtil.isNoEmpty((Object[])(load = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,claimno,sourceid,claimstatus,billstatus,isnoticemerge,reamount", (QFilter[])new QFilter[]{new QFilter("claimno", "in", claimNos)})))) {
            for (Object dynamicObject : load) {
                dynamicObject.set("claimno", (Object)generateNumber);
                dynamicObject.set("sourceid", (Object)pkId);
                dynamicObject.set("claimstatus", (Object)claimstatus);
                dynamicObject.set("reamount", (Object)reamount);
                if (StringUtils.equals((CharSequence)dynamicObject.getString("billstatus"), (CharSequence)"C")) continue;
                dynamicObject.set("isnoticemerge", (Object)true);
            }
        }
        if (allSingDetailBill.size() > 0) {
            CommonOperationHandler2.getLastestDate(mergeClaim, allSingDetailBill, false);
        }
        DynamicObjectCollection claimBillCategoryRecords = QueryServiceHelper.query((String)CAS_CLAIM_CATEGORY, (String)"id,type", (QFilter[])new QFilter[]{new QFilter("userid", "=", (Object)Long.valueOf(RequestContext.get().getUserId())).and("noticeid", "=", (Object)recClaimBills[0].getLong("id"))});
        DynamicObject categoryRecord = null;
        if (!CollectionUtils.isEmpty((Collection)claimBillCategoryRecords) && claimBillCategoryRecords.get(0) != null) {
            categoryRecord = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)CAS_CLAIM_CATEGORY));
            categoryRecord.set("userid", (Object)Long.valueOf(RequestContext.get().getUserId()));
            categoryRecord.set("noticeid", (Object)mergeClaim.getLong("id"));
            categoryRecord.set("type", (Object)((DynamicObject)claimBillCategoryRecords.get(0)).getLong("type"));
        }
        ArrayList<Object> cmdRecs = new ArrayList<Object>(10);
        ArrayList<Object> cmdSignRecs = new ArrayList<Object>(10);
        if (EmptyUtil.isNoEmpty(claimNos)) {
            Object[] cdmSignBills;
            QFilter qFilter = new QFilter("claimnoticebillno", "in", claimNos);
            Object[] cdmBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"claimnoticebillno", (QFilter[])new QFilter[]{qFilter});
            if (EmptyUtil.isNoEmpty((Object[])cdmBills)) {
                for (Object cdmBill : cdmBills) {
                    cdmBill.set("claimnoticebillno", (Object)generateNumber);
                    cmdRecs.add(cdmBill);
                }
            }
            if (EmptyUtil.isNoEmpty((Object[])(cdmSignBills = BusinessDataServiceHelper.load((String)"cdm_electronic_sign_deal", (String)"signnoticebill", (QFilter[])new QFilter[]{qFilter = new QFilter("signnoticebill", "in", claimNos)})))) {
                for (Object cdmBill : cdmSignBills) {
                    cdmBill.set("signnoticebill", (Object)generateNumber);
                    cmdSignRecs.add(cdmBill);
                }
            }
        }
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mergeClaim});
            SaveServiceHelper.save((DynamicObject[])updateRec.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])updateChildRec.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])load);
            if (categoryRecord != null) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{categoryRecord});
            }
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"cas_claimcenterbill"), (Object[])deleteRec.stream().map(DataEntityBase::getPkValue).toArray());
            DeleteServiceHelper.delete((String)CAS_CLAIM_CATEGORY, (QFilter[])new QFilter[]{new QFilter("userid", "=", (Object)Long.valueOf(RequestContext.get().getUserId())).and("noticeid", "in", deleteRec.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()))});
        }
        tx = TX.requiresNew();
        var46_56 = null;
        try {
            if (EmptyUtil.isNoEmpty(cmdRecs)) {
                SaveServiceHelper.save((DynamicObject[])cmdRecs.toArray(new DynamicObject[0]));
            }
            if (EmptyUtil.isNoEmpty(cmdSignRecs)) {
                SaveServiceHelper.save((DynamicObject[])cmdSignRecs.toArray(new DynamicObject[0]));
            }
        }
        catch (Throwable throwable) {
            var46_56 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var46_56 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var46_56.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("generateNumber", generateNumber);
        ret.put("pkId", pkId);
        return ret;
    }

    private static boolean isJudgeSameField(DynamicObject[] recClaimBills, String field) {
        int sameSize = 1;
        String fieldTemp = "";
        String fieldValue = "";
        for (int i = 0; i < recClaimBills.length; ++i) {
            DynamicObject recClaim = recClaimBills[i];
            if (i > 0) {
                fieldTemp = recClaim.getString(field);
                if (!StringUtils.equals((CharSequence)fieldValue, (CharSequence)fieldTemp)) continue;
                ++sameSize;
                continue;
            }
            fieldValue = recClaim.getString(field);
        }
        return sameSize == recClaimBills.length;
    }

    private static void getLastestDate(DynamicObject mergeClaim, Set<Long> allSingDetailBill, boolean isCancelMerge) {
        QFilter allsingleBillIdsQfilter = new QFilter("id", "in", allSingDetailBill);
        DynamicObject[] valiaDateBills = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"tradetime,drawbilldate,draftbillexpiredate,bizdate,tradedetailno,draftbilltype,drawername,detailid", (QFilter[])new QFilter[]{allsingleBillIdsQfilter}, (String)"tradetime desc", (int)1);
        if (null != valiaDateBills && valiaDateBills.length > 0) {
            DynamicObject valiaDateBill = valiaDateBills[0];
            mergeClaim.set("tradetime", (Object)valiaDateBill.getDate("tradetime"));
            mergeClaim.set("draftbillexpiredate", (Object)valiaDateBill.getDate("draftbillexpiredate"));
            mergeClaim.set("drawbilldate", (Object)valiaDateBill.getDate("drawbilldate"));
            mergeClaim.set("tradedetailno", (Object)valiaDateBill.getString("tradedetailno"));
            mergeClaim.set("draftbilltype", (Object)valiaDateBill.getDynamicObject("draftbilltype"));
            mergeClaim.set("drawername", (Object)valiaDateBill.getString("drawername"));
            mergeClaim.set("detailid", (Object)valiaDateBill.getString("detailid"));
            if (isCancelMerge) {
                mergeClaim.set("bizdate", (Object)valiaDateBill.getDate("bizdate"));
            }
        }
    }

    public static InvokeResult beforeCancleMerge(Object primaryKeyValue) {
        InvokeResult ret = new InvokeResult();
        DynamicObject claimCenterBill = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"cas_claimcenterbill");
        String mergestatus = claimCenterBill.getString("mergestatus");
        if (!MergeStatusEnum.ALMARGE.getValue().equals(mergestatus)) {
            ret.setTipsMsg(ResManager.loadKDString((String)"\u901a\u77e5\u5355\u4e0d\u662f\u5408\u5e76\u751f\u6210\u7684\uff0c\u65e0\u6cd5\u53d6\u6d88\u5408\u5e76\u3002", (String)"ClaimNoticeEditPlugin_25", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return ret;
        }
        String claimstatus = claimCenterBill.getString("claimstatus");
        if (ClaimStatusEnum.SURE.getValue().equals(claimstatus) || ClaimStatusEnum.APPEAL.getValue().equals(claimstatus) || ClaimStatusEnum.CHANGE.getValue().equals(claimstatus)) {
            ret.setTipsMsg(ResManager.loadKDString((String)"\u201c\u5df2\u786e\u8ba4\u201d\u3001\u201c\u7533\u8bc9\u4e2d\u201d\u548c\u201c\u53d8\u66f4\u4e2d\u201d\u72b6\u6001\u7684\u8ba4\u9886\u901a\u77e5\u5355\u4e0d\u80fd\u76f4\u63a5\u505a\u53d6\u6d88\u5408\u5e76\u3002", (String)"ClaimNoticeEditPlugin_26", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return ret;
        }
        ret.put("claimCenterBill", (Object)claimCenterBill);
        ret.setSuccess(true);
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public static InvokeResult doCancelMerge(Collection selectPKs, Object selectId) {
        InvokeResult ret = new InvokeResult();
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cas_claimcenterbill");
        QFilter margeid = new QFilter("margeid", "=", selectId);
        Object[] childClaim = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"reamount,payamount,billno,margeid,mergestatus,bankcheckflag,bankcheckentity.ebankcheckflag", (QFilter[])new QFilter[]{margeid});
        if (EmptyUtil.isEmpty((Object[])childClaim)) {
            ret.setTipsMsg(ResManager.loadKDString((String)"\u9009\u62e9\u64cd\u4f5c\u7684\u6570\u636e\u88ab\u5220\u9664", (String)"ClaimNoticeEditPlugin_27", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return ret;
        }
        List childPk = Arrays.asList(childClaim).stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        Object selectDy = childClaim[0];
        Object[] sourceDys = BusinessDataServiceHelper.load((Object[])new Object[]{selectDy.get("margeid")}, (DynamicObjectType)type);
        if (EmptyUtil.isEmpty((Object[])sourceDys)) {
            ret.setTipsMsg(ResManager.loadKDString((String)"\u5408\u5e76\u7684\u901a\u77e5\u5355\u5df2\u7ecf\u88ab\u5220\u9664", (String)"ClaimNoticeEditPlugin_28", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return ret;
        }
        Object sourceDy = sourceDys[0];
        String mergestatus = sourceDy.getString("mergestatus");
        if (!MergeStatusEnum.ALMARGE.getValue().equals(mergestatus)) {
            ret.setTipsMsg(ResManager.loadKDString((String)"\u901a\u77e5\u5355\u4e0d\u662f\u5408\u5e76\u751f\u6210\u7684\uff0c\u65e0\u6cd5\u53d6\u6d88\u5408\u5e76\u3002", (String)"ClaimNoticeEditPlugin_25", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return ret;
        }
        String claimstatus = sourceDy.getString("claimstatus");
        if (ClaimStatusEnum.SURE.getValue().equals(claimstatus) || ClaimStatusEnum.APPEAL.getValue().equals(claimstatus) || ClaimStatusEnum.CHANGE.getValue().equals(claimstatus)) {
            ret.setTipsMsg(ResManager.loadKDString((String)"\u201c\u5df2\u786e\u8ba4\u201d\u3001\u201c\u7533\u8bc9\u4e2d\u201d\u548c\u201c\u53d8\u66f4\u4e2d\u201d\u72b6\u6001\u7684\u8ba4\u9886\u901a\u77e5\u5355\u4e0d\u80fd\u76f4\u63a5\u505a\u53d6\u6d88\u5408\u5e76\u3002", (String)"ClaimNoticeEditPlugin_26", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return ret;
        }
        Object[] loads = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"payentity.e_payableamt,payentity.e_payactamt,fee,claimstatus,entryentity.e_receivableamt,entryentity.e_discountamt,entryentity.e_fee,reamount,payamount,bankcheckentity.ebankcheckflag", (QFilter[])new QFilter[]{new QFilter("claimno", "=", (Object)sourceDy.getString("billno"))});
        BigDecimal removeReamount = BigDecimal.ZERO;
        BigDecimal payRemoveReamount = BigDecimal.ZERO;
        Long pk = 0L;
        ArrayList<String> bankcheckflagList = new ArrayList<String>();
        HashSet<Long> removeIds = new HashSet<Long>();
        boolean remainOne = false;
        int number = childClaim.length - selectPKs.size();
        if (number == 1) {
            remainOne = true;
        }
        ArrayList<DynamicObject> cdmRecBills = new ArrayList<DynamicObject>(10);
        for (Object dy2 : childClaim) {
            pk = dy2.getLong("id");
            if (selectPKs.contains(pk)) {
                if (!StringUtils.equals((CharSequence)MergeStatusEnum.MARFED.getValue(), (CharSequence)dy2.getString("mergestatus"))) {
                    ret.setTipsMsg(String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u901a\u77e5\u5355%s\u4e0d\u662f\u88ab\u5408\u5e76\u72b6\u6001", (String)"ClaimNoticeEditPlugin_29", (String)"fi-cas-formplugin", (Object[])new Object[0]), dy2.getString("billno")));
                    return ret;
                }
                dy2.set("mergestatus", (Object)MergeStatusEnum.UNMARGE.getValue());
                dy2.set("margeid", null);
                removeReamount = removeReamount.add(dy2.getBigDecimal("reamount"));
                payRemoveReamount = payRemoveReamount.add(dy2.getBigDecimal("payamount"));
                List<DynamicObject> sourceBills = CommonOperationHandler2.findSourceCdmReceivable(pk, dy2.getString("billno"));
                cdmRecBills.addAll(sourceBills);
                childPk.remove(pk);
                removeIds.add(pk);
                continue;
            }
            DynamicObjectCollection entryEntity = dy2.getDynamicObjectCollection("bankcheckentity");
            for (DynamicObject entry : entryEntity) {
                bankcheckflagList.add(entry.getString("ebankcheckflag"));
            }
        }
        boolean isDelete = false;
        if (EmptyUtil.isEmpty((Object[])loads)) {
            if (childPk.isEmpty()) {
                isDelete = true;
            } else if (childPk.size() == 1) {
                isDelete = true;
                for (Object dy3 : childClaim) {
                    dy3.set("mergestatus", (Object)MergeStatusEnum.UNMARGE.getValue());
                    dy3.set("margeid", null);
                    removeIds.add(pk);
                }
            }
        }
        String businesstype = sourceDy.getString("businesstype");
        DynamicObject currency = sourceDy.getDynamicObject("currency");
        int scale = currency.getInt("amtprecision");
        if (!isDelete) {
            void var28_46;
            Object[] bankCheckEntity;
            if ("pay".equals(businesstype)) {
                void var28_38;
                Boolean singleStream = sourceDy.getBoolean("singlestream");
                BigDecimal allunclaimamount = BigDecimal.ZERO;
                BigDecimal payableamt = BigDecimal.ZERO;
                BigDecimal bigDecimal = BigDecimal.ZERO;
                BigDecimal payAmount = sourceDy.getBigDecimal("payamount");
                for (Object load : loads) {
                    DynamicObjectCollection payentity = load.getDynamicObjectCollection("payentity");
                    payableamt = payentity.stream().map(dy -> dy.getBigDecimal("e_payableamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    BigDecimal bigDecimal2 = payentity.stream().map(dy -> dy.getBigDecimal("e_payactamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                }
                allunclaimamount = payAmount.subtract(sourceDy.getBigDecimal("fee")).add(payableamt).subtract((BigDecimal)var28_38).subtract(payableamt);
                if (singleStream.booleanValue()) {
                    allunclaimamount = allunclaimamount.add(sourceDy.getBigDecimal("fee"));
                }
                BigDecimal reamount = sourceDy.getBigDecimal("payamount");
                BigDecimal unclaimamount = sourceDy.getBigDecimal("unclaimamount");
                sourceDy.set("payamount", (Object)reamount.subtract(payRemoveReamount));
                sourceDy.set("unclaimamount", (Object)allunclaimamount.subtract(payRemoveReamount));
                if (payRemoveReamount.compareTo(allunclaimamount) > 0) {
                    if (allunclaimamount.compareTo(BigDecimal.ZERO) < 0) {
                        allunclaimamount = BigDecimal.ZERO;
                    }
                    allunclaimamount = allunclaimamount.setScale(payRemoveReamount.scale());
                    String amt1 = String.valueOf(payRemoveReamount.setScale(scale));
                    String amt2 = String.valueOf(allunclaimamount.setScale(scale));
                    ret.setTipsMsg(String.format(ResManager.loadKDString((String)"\u60a8\u8981\u53d6\u6d88\u5408\u5e76\u7684\u660e\u7ec6\u91d1\u989d\u5408\u8ba1%1$s\u5df2\u8d85\u8fc7\u672a\u88ab\u8ba4\u9886\u7684\u91d1\u989d\u5408\u8ba1%2$s\uff0c\u65e0\u6cd5\u53d6\u6d88\u5408\u5e76\u3002", (String)"ClaimNoticeEditPlugin_30", (String)"fi-cas-formplugin", (Object[])new Object[0]), amt1, amt2));
                    return ret;
                }
                claimstatus = payableamt.compareTo(BigDecimal.ZERO) == 0 ? ClaimStatusEnum.WAIT.getValue() : (payableamt.compareTo(BigDecimal.ZERO) > 0 && unclaimamount.compareTo(BigDecimal.ZERO) <= 0 ? ClaimStatusEnum.CLAIMED.getValue() : ClaimStatusEnum.PART.getValue());
            } else {
                BigDecimal sumclaimedamount = BigDecimal.ZERO;
                BigDecimal sumdiscountamt = BigDecimal.ZERO;
                Object sumfee = BigDecimal.ZERO;
                for (Object load : loads) {
                    DynamicObjectCollection dyColl = load.getDynamicObjectCollection("entryentity");
                    sumclaimedamount = dyColl.stream().map(dy -> dy.getBigDecimal("e_receivableamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).add(sumclaimedamount);
                    sumdiscountamt = dyColl.stream().map(dy -> dy.getBigDecimal("e_discountamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).add(sumdiscountamt);
                    sumfee = dyColl.stream().map(dy -> dy.getBigDecimal("e_fee")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).add((BigDecimal)sumfee);
                }
                if (sourceDy.getBoolean("isaddfee")) {
                    sumfee = sourceDy.getBigDecimal("fee");
                }
                BigDecimal bigDecimal = sourceDy.getBigDecimal("reamount");
                BigDecimal unclaimamount = sourceDy.getBigDecimal("unclaimamount");
                sourceDy.set("reamount", (Object)bigDecimal.subtract(removeReamount));
                sourceDy.set("unclaimamount", (Object)unclaimamount.subtract(removeReamount));
                BigDecimal sumunclaimamount = bigDecimal.add(sumdiscountamt).add((BigDecimal)sumfee).subtract(sumclaimedamount);
                if (removeReamount.compareTo(sumunclaimamount) > 0) {
                    if (sumunclaimamount.compareTo(BigDecimal.ZERO) < 0) {
                        sumunclaimamount = BigDecimal.ZERO;
                    }
                    sumunclaimamount = sumunclaimamount.setScale(removeReamount.scale());
                    String amt1 = String.valueOf(removeReamount.setScale(scale));
                    String amt2 = String.valueOf(sumunclaimamount.setScale(scale));
                    ret.setTipsMsg(String.format(ResManager.loadKDString((String)"\u60a8\u8981\u53d6\u6d88\u5408\u5e76\u7684\u660e\u7ec6\u91d1\u989d\u5408\u8ba1%1$s\u5df2\u8d85\u8fc7\u672a\u88ab\u8ba4\u9886\u7684\u91d1\u989d\u5408\u8ba1%2$s\uff0c\u65e0\u6cd5\u53d6\u6d88\u5408\u5e76\u3002", (String)"ClaimNoticeEditPlugin_30", (String)"fi-cas-formplugin", (Object[])new Object[0]), amt1, amt2));
                    return ret;
                }
                BigDecimal claimedamount = sourceDy.getDynamicObjectCollection("entryentity").stream().map(dy -> dy.getBigDecimal("e_receivableamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal discountamt = sourceDy.getDynamicObjectCollection("entryentity").stream().map(dy -> dy.getBigDecimal("e_discountamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                claimstatus = claimedamount.compareTo(BigDecimal.ZERO) == 0 ? ClaimStatusEnum.WAIT.getValue() : (claimedamount.compareTo(bigDecimal.add(sourceDy.getBigDecimal("fee")).add(discountamt).subtract(removeReamount)) >= 0 ? ClaimStatusEnum.CLAIMED.getValue() : ClaimStatusEnum.PART.getValue());
            }
            String bankcheckflag = String.join((CharSequence)",", bankcheckflagList.stream().filter(EmptyUtil::isNoEmpty).collect(Collectors.toList()));
            sourceDy.set("bankcheckflag", (Object)(bankcheckflag.length() > 1024 ? bankcheckflag.substring(0, 1024) : bankcheckflag));
            if (bankcheckflagList.size() > 0) {
                bankCheckEntity = sourceDy.getDynamicObjectCollection("bankcheckentity");
                bankCheckEntity.clear();
                for (String string : bankcheckflagList) {
                    DynamicObject entryEntity = bankCheckEntity.addNew();
                    entryEntity.set("ebankcheckflag", (Object)string);
                }
            }
            sourceDy.set("claimstatus", (Object)claimstatus);
            bankCheckEntity = loads;
            int sumfee = bankCheckEntity.length;
            boolean bl = false;
            while (var28_46 < sumfee) {
                Object load = bankCheckEntity[var28_46];
                load.set("claimstatus", (Object)claimstatus);
                load.set("reamount", (Object)sourceDy.getBigDecimal("reamount"));
                load.set("payamount", (Object)sourceDy.getBigDecimal("payamount"));
                ++var28_46;
            }
        }
        DynamicObjectCollection sourceClaimBillCategoryRecords = QueryServiceHelper.query((String)CAS_CLAIM_CATEGORY, (String)"id,type", (QFilter[])new QFilter[]{new QFilter("userid", "=", (Object)Long.valueOf(RequestContext.get().getUserId())).and("noticeid", "=", (Object)sourceDy.getLong("id"))});
        DynamicObject[] categoryRecords = new DynamicObject[removeIds.size()];
        if (!CollectionUtils.isEmpty((Collection)sourceClaimBillCategoryRecords) && sourceClaimBillCategoryRecords.get(0) != null) {
            for (int i = 0; i < removeIds.size(); ++i) {
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)CAS_CLAIM_CATEGORY));
                dynamicObject.set("userid", (Object)Long.valueOf(RequestContext.get().getUserId()));
                dynamicObject.set("noticeid", new ArrayList(removeIds).get(i));
                dynamicObject.set("type", (Object)((DynamicObject)sourceClaimBillCategoryRecords.get(0)).getLong("type"));
                categoryRecords[i] = dynamicObject;
            }
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])childClaim);
            if (!CollectionUtils.isEmpty((Collection)sourceClaimBillCategoryRecords) && sourceClaimBillCategoryRecords.get(0) != null) {
                SaveServiceHelper.save((DynamicObject[])categoryRecords);
            } else {
                DeleteServiceHelper.delete((String)CAS_CLAIM_CATEGORY, (QFilter[])new QFilter[]{new QFilter("userid", "=", (Object)Long.valueOf(RequestContext.get().getUserId())).and("noticeid", "in", removeIds)});
            }
            if (isDelete) {
                DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"cas_claimcenterbill"), (Object[])new Object[]{sourceDy.getPkValue()});
                DeleteServiceHelper.delete((String)CAS_CLAIM_CATEGORY, (QFilter[])new QFilter[]{new QFilter("userid", "=", (Object)Long.valueOf(RequestContext.get().getUserId())).and("noticeid", "=", (Object)sourceDy.getLong("id"))});
            } else {
                if (null != childPk && childPk.size() > 0) {
                    HashSet<Long> ids = new HashSet<Long>(childPk);
                    CommonOperationHandler2.getLastestDate((DynamicObject)sourceDys[0], ids, true);
                }
                if (remainOne) {
                    for (Object dy4 : sourceDys) {
                        dy4.set("mergestatus", (Object)MergeStatusEnum.UNMARGE.getValue());
                        dy4.set("margeid", null);
                        List<DynamicObject> sourceBills = CommonOperationHandler2.findSourceCdmReceivable(dy4.getLong("id"), dy4.getString("billno"));
                        cdmRecBills.addAll(sourceBills);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])sourceDys);
                SaveServiceHelper.save((DynamicObject[])loads);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        tx = TX.requiresNew();
        Throwable throwable4 = null;
        try {
            if (EmptyUtil.isNoEmpty(cdmRecBills)) {
                SaveServiceHelper.save((DynamicObject[])cdmRecBills.toArray(new DynamicObject[0]));
            }
        }
        catch (Throwable throwable5) {
            Throwable throwable6 = throwable5;
            throw throwable5;
        }
        finally {
            if (tx != null) {
                if (throwable4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable7) {
                        throwable4.addSuppressed(throwable7);
                    }
                } else {
                    tx.close();
                }
            }
        }
        ret.setSuccess(true);
        return ret;
    }

    private static List<DynamicObject> findSourceCdmReceivable(long pkId, String claimBillNo) {
        ArrayList<DynamicObject> returnList;
        block4: {
            Set sourceBillIds;
            Map sourceBillMap;
            block5: {
                returnList = new ArrayList<DynamicObject>(10);
                sourceBillMap = BFTrackerServiceHelper.findSourceBills((String)"cas_claimcenterbill", (Long[])new Long[]{pkId});
                if (!EmptyUtil.isNoEmpty((Object)sourceBillMap)) break block4;
                logger.info("doCancelMerge findSourceCdmReceivable sourceBillMap:{}", (Object)JSONObject.toJSONString((Object)sourceBillMap));
                sourceBillIds = (Set)sourceBillMap.get("cdm_receivablebill");
                if (!EmptyUtil.isNoEmpty((Object)sourceBillIds)) break block5;
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill");
                Object[] sourceBillArr = BusinessDataServiceHelper.load((Object[])sourceBillIds.toArray(), (DynamicObjectType)type);
                if (!EmptyUtil.isNoEmpty((Object[])sourceBillArr)) break block4;
                for (Object bill : sourceBillArr) {
                    bill.set("claimnoticebillno", (Object)claimBillNo);
                    returnList.add((DynamicObject)bill);
                }
                break block4;
            }
            sourceBillIds = (Set)sourceBillMap.get("cdm_electronic_sign_deal");
            if (EmptyUtil.isNoEmpty((Object)sourceBillIds)) {
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cdm_electronic_sign_deal");
                Object[] sourceBillArr = BusinessDataServiceHelper.load((Object[])sourceBillIds.toArray(), (DynamicObjectType)type);
                if (EmptyUtil.isNoEmpty((Object[])sourceBillArr)) {
                    for (Object bill : sourceBillArr) {
                        bill.set("signnoticebill", (Object)claimBillNo);
                        returnList.add((DynamicObject)bill);
                    }
                }
            }
        }
        return returnList;
    }

    public static InvokeResult beforeClaim(Object claimNoticePk) {
        InvokeResult ret = new InvokeResult();
        if (CommonOperationHandler2.recValidate((Long)claimNoticePk, ret, Boolean.TRUE)) {
            ret.setTipsMsg(ResManager.loadKDString((String)"\u8ba4\u9886\u5931\u8d25\u3002\u539f\u6536\u6b3e\u5355\u5df2\u5339\u914d\u4e1a\u52a1\u5355\u636e\uff0c\u8bf7\u5148\u524d\u5f80\u201c\u5408\u540c\u7ba1\u7406\u201d\u6216\u201c\u9500\u552e\u7ba1\u7406\u201d\u53d6\u6d88\u5339\u914d\u518d\u53d1\u8d77\u8ba4\u9886\u3002", (String)"ClaimNoticeEditPlugin_41", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return ret;
        }
        Object[] loads = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id,claimstatus,billno", (QFilter[])new QFilter[]{new QFilter("id", "=", claimNoticePk)});
        if (!EmptyUtil.isEmpty((Object[])loads)) {
            QFilter claimtypeQf;
            QFilter creatorQf;
            QFilter billstatusQf;
            if (!(StringUtils.equals((CharSequence)loads[0].getString("claimstatus"), (CharSequence)ClaimStatusEnum.WAIT.getValue()) || StringUtils.equals((CharSequence)loads[0].getString("claimstatus"), (CharSequence)ClaimStatusEnum.PART.getValue()) || StringUtils.equals((CharSequence)loads[0].getString("claimstatus"), (CharSequence)ClaimStatusEnum.CLAIMED.getValue()))) {
                ret.setTipsMsg(ResManager.loadKDString((String)"\u53ea\u6709\u53ef\u8ba4\u9886\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u8fdb\u884c\u8ba4\u9886\u64cd\u4f5c\u3002", (String)"ClaimNoticeEditPlugin_31", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return ret;
            }
            QFilter qFilter = new QFilter("claimno", "=", (Object)loads[0].getString("billno"));
            DynamicObject[] claimblls = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id", (QFilter[])new QFilter[]{qFilter, billstatusQf = new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue()), creatorQf = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId())), claimtypeQf = new QFilter("claimtype", "=", (Object)ClaimTypeEnum.CLAIM.getValue())});
            if (claimblls.length > 0) {
                ret.setTipsMsg(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u63d0\u4ea4\u7684\u8ba4\u9886\u5355\uff0c\u8bf7\u64a4\u9500\u63d0\u4ea4\u540e\u4fee\u6539\uff0c\u65e0\u9700\u65b0\u589e\u65b0\u8ba4\u9886\u5355\u3002", (String)"ClaimNoticeEditPlugin_32", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return ret;
            }
            QFilter billstatusQf1 = new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
            DynamicObject[] claimbllsSave = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,createtime", (QFilter[])new QFilter[]{qFilter, billstatusQf1, creatorQf, claimtypeQf});
            if (claimbllsSave.length >= 1) {
                Object recentDateId = null;
                Date recentDate = null;
                for (DynamicObject claimbill : claimbllsSave) {
                    Date createtime = claimbill.getDate("createtime");
                    if (recentDate == null) {
                        recentDate = createtime;
                        recentDateId = claimbill.getPkValue();
                    }
                    recentDateId = createtime.compareTo(recentDate) > 0 ? claimbill.getPkValue() : recentDateId;
                }
                ret.setTipsMsg(ResManager.loadKDString((String)"\u5b58\u5728\u6682\u5b58\u7684\u8ba4\u9886\u5355\uff0c\u5df2\u5e2e\u60a8\u6253\u5f00\uff0c\u65e0\u9700\u65b0\u589e\u65b0\u8ba4\u9886\u5355\u3002", (String)"ClaimNoticeEditPlugin_33", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                ret.put("recentDateId", recentDateId);
                return ret;
            }
        }
        ret.setSuccess(true);
        return ret;
    }

    public static InvokeResult beforeAppeal(Object claimNoticePk) {
        InvokeResult ret = new InvokeResult();
        Object[] loads = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id,claimstatus,billno,payamount,confirmdate,org", (QFilter[])new QFilter[]{new QFilter("id", "=", claimNoticePk)});
        if (!EmptyUtil.isEmpty((Object[])loads)) {
            Date confirmdate;
            QFilter claimtypeQf;
            QFilter creatorQf;
            QFilter billstatusQf;
            if (!StringUtils.equals((CharSequence)loads[0].getString("claimstatus"), (CharSequence)ClaimStatusEnum.SURE.getValue()) && !StringUtils.equals((CharSequence)loads[0].getString("claimstatus"), (CharSequence)ClaimStatusEnum.APPEAL.getValue())) {
                ret.setTipsMsg(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u786e\u8ba4\u548c\u7533\u8bc9\u4e2d\u7684\uff0c\u4e14\u5728\u7533\u8bc9\u671f\u5185\u624d\u53ef\u4ee5\u8fdb\u884c\u7533\u8bc9\u64cd\u4f5c", (String)"ClaimNoticeEditPlugin_34", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return ret;
            }
            if (loads[0].getBigDecimal("payamount").compareTo(BigDecimal.ZERO) > 0) {
                ret.setTipsMsg(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba4\u9886\u4e0d\u652f\u6301\u7533\u8bc9\u3002", (String)"ClaimNoticeEditPlugin_43", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return ret;
            }
            QFilter qFilter = new QFilter("claimno", "=", (Object)loads[0].getString("billno"));
            DynamicObject[] claimblls = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id", (QFilter[])new QFilter[]{qFilter, billstatusQf = new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue()), creatorQf = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()).and(new QFilter("handlestatus", "=", (Object)ClaimHandleStatusEnum.NOTCLAIM.getValue())), claimtypeQf = new QFilter("claimtype", "=", (Object)ClaimTypeEnum.APPEAL.getValue())});
            if (claimblls.length > 0) {
                ret.setTipsMsg(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u63d0\u4ea4\u7684\u7533\u8bc9\u5355\uff0c\u8bf7\u64a4\u9500\u63d0\u4ea4\u540e\u4fee\u6539\uff0c\u65e0\u9700\u65b0\u589e\u65b0\u7533\u8bc9\u5355", (String)"ClaimNoticeEditPlugin_35", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return ret;
            }
            QFilter billstatusQf1 = new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
            DynamicObject[] claimbllsSave = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,createtime", (QFilter[])new QFilter[]{qFilter, billstatusQf1, creatorQf, claimtypeQf});
            if (claimbllsSave.length >= 1) {
                Object recentDateId = null;
                Date recentDate = null;
                for (DynamicObject claimbill : claimbllsSave) {
                    Date createtime = claimbill.getDate("createtime");
                    if (recentDate == null) {
                        recentDate = createtime;
                        recentDateId = claimbill.getPkValue();
                    }
                    recentDateId = createtime.compareTo(recentDate) > 0 ? claimbill.getPkValue() : recentDateId;
                }
                ret.setTipsMsg(ResManager.loadKDString((String)"\u5df2\u6253\u5f00\u6682\u5b58\u7684\u7533\u8bc9\u5355\uff0c\u65e0\u9700\u65b0\u589e\u7533\u8bc9\u5355\u3002", (String)"ClaimNoticeEditPlugin_36", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                ret.put("recentDateId", recentDateId);
                return ret;
            }
            long orgId = loads[0].getDynamicObject("org").getLong("id");
            int number = SystemParameterHelper.getParameterInteger((long)orgId, (String)"cs111");
            long limitTime = 3600000L * (long)number;
            int unit = SystemParameterHelper.getParameterInteger((long)orgId, (String)"cs112");
            if (1 == unit) {
                limitTime *= 24L;
            }
            if ((confirmdate = new Date(loads[0].getDate("confirmdate").getTime() + limitTime)).before(new Date())) {
                ret.setTipsMsg(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u786e\u8ba4\u548c\u7533\u8bc9\u4e2d\u7684\uff0c\u4e14\u5728\u7533\u8bc9\u671f\u5185\u624d\u53ef\u4ee5\u8fdb\u884c\u7533\u8bc9\u64cd\u4f5c", (String)"ClaimNoticeEditPlugin_34", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                return ret;
            }
        }
        ret.setSuccess(true);
        return ret;
    }

    public static InvokeResult beforeChangeClaimBill(Object claimBillPk) {
        QFilter claimtypeQf;
        QFilter creatorQf;
        QFilter billstatusQf;
        InvokeResult ret = new InvokeResult();
        if (CommonOperationHandler2.recValidateByClaimNotice((Long)claimBillPk, ret)) {
            ret.setTipsMsg(ResManager.loadKDString((String)"\u53d8\u66f4\u5931\u8d25\u3002\u539f\u6536\u6b3e\u5355\u5df2\u5339\u914d\u4e1a\u52a1\u5355\u636e\uff0c\u8bf7\u5148\u524d\u5f80\u5408\u540c\u7ba1\u7406/\u9500\u552e\u7ba1\u7406\u53d6\u6d88\u5339\u914d\u518d\u53d1\u8d77\u53d8\u66f4\u3002", (String)"ClaimNoticeEditPlugin_42", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return ret;
        }
        String properties = "billno,claimtype,billstatus,claimstatus,handlestatus";
        DynamicObject claimBillObj = BusinessDataServiceHelper.loadSingle((String)"cas_claimbill", (String)properties, (QFilter[])new QFilter[]{new QFilter("id", "=", claimBillPk)});
        if (!StringUtils.equals((CharSequence)"C", (CharSequence)claimBillObj.getString("billstatus")) || !StringUtils.equals((CharSequence)ClaimStatusEnum.SURE.getValue(), (CharSequence)claimBillObj.getString("claimstatus")) && !StringUtils.equals((CharSequence)ClaimStatusEnum.CHANGE.getValue(), (CharSequence)claimBillObj.getString("claimstatus"))) {
            ret.setTipsMsg(ResManager.loadKDString((String)"\u53d8\u66f4\u7684\u5355\u5fc5\u987b\u6ee1\u8db3\uff1a\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u3001\u8ba4\u9886\u901a\u77e5\u5355\u72b6\u6001\u4e3a\u5df2\u786e\u8ba4\u6216\u53d8\u66f4\u4e2d\u3002", (String)"ClaimHandleListPlugin_1", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return ret;
        }
        if (StringUtils.equals((CharSequence)ClaimHandleStatusEnum.NOTCLAIM.getValue(), (CharSequence)claimBillObj.getString("handlestatus"))) {
            ret.setTipsMsg(ResManager.loadKDString((String)"\u672c\u6b21\u53d8\u66f4\u4e2d\u7684\u5355\u4e0d\u80fd\u53d8\u66f4\uff0c\u5982\u9700\u53d8\u66f4\uff0c\u8bf7\u53cd\u5ba1\u6838\u540e\u4fee\u6539\u6b64\u5355\u4fe1\u606f\u5373\u53ef\u3002", (String)"ClaimHandleListPlugin_7", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return ret;
        }
        QFilter qFilter = new QFilter("sourceclaimid", "=", (Object)claimBillObj.getLong("id"));
        DynamicObject[] claimblls = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id", (QFilter[])new QFilter[]{qFilter, billstatusQf = new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue()), creatorQf = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId())).and(new QFilter("handlestatus", "=", (Object)ClaimHandleStatusEnum.NOTCLAIM.getValue())), claimtypeQf = new QFilter("claimtype", "=", (Object)ClaimTypeEnum.CHANGE.getValue())});
        if (claimblls.length > 0) {
            ret.setTipsMsg(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u63d0\u4ea4\u7684\u53d8\u66f4\u5355\uff0c\u8bf7\u64a4\u9500\u63d0\u4ea4\u540e\u4fee\u6539\uff0c\u65e0\u9700\u65b0\u589e\u65b0\u53d8\u66f4\u5355\u3002", (String)"ClaimHandleListPlugin_3", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return ret;
        }
        QFilter billstatusQf1 = new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
        DynamicObject[] claimbllsSave = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,createtime", (QFilter[])new QFilter[]{qFilter, billstatusQf1, creatorQf, claimtypeQf});
        if (claimbllsSave.length >= 1) {
            Object recentDateId = null;
            Date recentDate = null;
            for (DynamicObject claimbill : claimbllsSave) {
                Date createtime = claimbill.getDate("createtime");
                if (recentDate == null) {
                    recentDate = createtime;
                    recentDateId = claimbill.getPkValue();
                }
                recentDateId = createtime.compareTo(recentDate) > 0 ? claimbill.getPkValue() : recentDateId;
            }
            ret.setTipsMsg(ResManager.loadKDString((String)"\u5df2\u6253\u5f00\u6682\u5b58\u7684\u53d8\u66f4\u5355\uff0c\u65e0\u9700\u65b0\u589e\u65b0\u53d8\u66f4\u5355\u3002", (String)"ClaimHandleListPlugin_4", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            ret.put("recentDateId", recentDateId);
            return ret;
        }
        ret.setSuccess(true);
        return ret;
    }

    public static InvokeResult transpond(Map<Object, String> userIdNames, Object[] selectids) {
        InvokeResult ret = new InvokeResult();
        DynamicObject[] notices = new DynamicObject[selectids.length];
        Object noticeid = null;
        DynamicObject notice = null;
        EntryProp prop = null;
        DynamicObjectType dt = null;
        Set haveUserId = null;
        StringBuilder claimusers = new StringBuilder();
        HashMap claimTypeMap = new HashMap(1);
        HashMap<String, ArrayList<Object>> typeValue = null;
        ArrayList<Object> userList = null;
        for (int i = 0; i < selectids.length; ++i) {
            userList = new ArrayList<Object>();
            typeValue = new HashMap<String, ArrayList<Object>>();
            claimusers.setLength(0);
            noticeid = selectids[i];
            notice = BusinessDataServiceHelper.loadSingle((Object)noticeid, (String)"cas_claimcenterbill");
            claimusers.append(notice.getString("claimusers"));
            haveUserId = notice.getDynamicObjectCollection("entryentity1").stream().filter(dy -> StringUtils.equals((CharSequence)"1", (CharSequence)dy.getString("claimtype"))).map(dy -> dy.getLong("claimtypeid")).collect(Collectors.toCollection(HashSet::new));
            prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)notice.getDataEntityType().getName()).findProperty("entryentity1");
            dt = prop.getDynamicCollectionItemPropertyType();
            for (Map.Entry<Object, String> userIdName : userIdNames.entrySet()) {
                if (haveUserId.contains(userIdName.getKey())) continue;
                DynamicObject entryObject = new DynamicObject(dt);
                entryObject.set("claimtype", (Object)1);
                entryObject.set("claimtypeid", userIdName.getKey());
                userList.add(userIdName.getKey());
                notice.getDynamicObjectCollection("entryentity1").add((Object)entryObject);
                if (claimusers.length() != 0) {
                    claimusers.append(',');
                }
                claimusers.append(userIdName.getValue());
            }
            typeValue.put("userids", userList);
            claimTypeMap.put(noticeid, typeValue);
            notice.set("claimusers", (Object)(claimusers.toString().length() > 1024 ? claimusers.toString().substring(0, 1024) : claimusers.toString()));
            notices[i] = notice;
        }
        SaveServiceHelper.save((DynamicObject[])notices);
        RecClaimHelper.sendClaimNoticeMessage(claimTypeMap, (String)"notice");
        ret.setSuccess(true);
        return ret;
    }

    private static boolean innerAccountBool(DynamicObject[] recBill, DynamicObject innerAccount) {
        if (null != recBill && recBill.length > 0) {
            DynamicObject recInnerAccount = recBill[0].getDynamicObject("inneraccount");
            if (null == innerAccount && null != recInnerAccount) {
                return true;
            }
            if (null != innerAccount && null == recInnerAccount) {
                return true;
            }
            if (null != innerAccount && null != recInnerAccount) {
                Long recInnerAccountId;
                Long innerAccountId = innerAccount.getLong("id");
                return innerAccountId.compareTo(recInnerAccountId = Long.valueOf(recInnerAccount.getLong("id"))) != 0;
            }
            return false;
        }
        return false;
    }

    public static InvokeResult beforeAccount(Object primaryKeyValue) {
        InvokeResult ret = new InvokeResult();
        DynamicObject claimNoticeBill = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"cas_claimcenterbill");
        DynamicObject[] claimDts = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"inneraccount,handlestatus,billstatus,claimtype", (QFilter[])new QFilter[]{new QFilter("sourceid", "=", (Object)primaryKeyValue.toString())}, (String)" auditdate asc ");
        DynamicObject[] recBill = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,inneraccount,billstatus", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)"D").and(new QFilter("sourcebillid", "=", primaryKeyValue))});
        DynamicObject innerAccount = null;
        for (DynamicObject claim : claimDts) {
            if (!StringUtils.equals((CharSequence)ClaimHandleStatusEnum.NOTCLAIM.getValue(), (CharSequence)claim.getString("handlestatus")) || !StringUtils.equals((CharSequence)claim.getString("billstatus"), (CharSequence)BillStatusEnum.AUDIT.getValue())) continue;
            claim.set("handlestatus", (Object)ClaimHandleStatusEnum.CLAIMED.getValue());
            if (!StringUtils.equals((CharSequence)claim.getString("claimtype"), (CharSequence)ClaimTypeEnum.APPEAL.getValue()) && !StringUtils.equals((CharSequence)claim.getString("claimtype"), (CharSequence)ClaimTypeEnum.CHANGE.getValue())) continue;
            innerAccount = claim.getDynamicObject("inneraccount");
            break;
        }
        if (CommonOperationHandler2.innerAccountBool(recBill, innerAccount) && !claimNoticeBill.getBoolean("isunclaim")) {
            ret.setTipsMsg(ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3\u6536\u6b3e\u5df2\u751f\u6210\u6210\u5458\u5355\u4f4d\u4ea4\u6613\u660e\u7ec6\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u2018\u5173\u8054\u5185\u90e8\u8d26\u6237\u2019\u5b57\u6bb5\u3002", (String)"ClaimNoticeEditPlugin_46", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            ret.put("showMessge", (Object)true);
            return ret;
        }
        if (CommonOperationHandler2.recValidate((Long)primaryKeyValue, ret, Boolean.TRUE)) {
            ret.setTipsMsg(ResManager.loadKDString((String)"\u786e\u8ba4\u5931\u8d25\u3002\u539f\u6536\u6b3e\u5355\u5df2\u5339\u914d\u4e1a\u52a1\u5355\u636e\uff0c\u8bf7\u5148\u524d\u5f80\u5408\u540c\u7ba1\u7406/\u9500\u552e\u7ba1\u7406\u53d6\u6d88\u5339\u914d\u518d\u53d1\u8d77\u786e\u8ba4\u3002", (String)"ClaimNoticeEditPlugin_40", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            ret.put("showMessge", (Object)true);
            return ret;
        }
        String claimstatus = claimNoticeBill.getString("claimstatus");
        if (StringUtils.equals((CharSequence)ClaimStatusEnum.APPEAL.getValue(), (CharSequence)claimstatus) || StringUtils.equals((CharSequence)ClaimStatusEnum.CHANGE.getValue(), (CharSequence)claimstatus)) {
            String claimtype = "";
            String typestr = "";
            if (StringUtils.equals((CharSequence)ClaimStatusEnum.APPEAL.getValue(), (CharSequence)claimstatus)) {
                claimtype = ClaimTypeEnum.APPEAL.getValue();
                typestr = ResManager.loadKDString((String)"\u7533\u8bc9", (String)"ClaimNoticeEditPlugin_13", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            } else if (StringUtils.equals((CharSequence)ClaimStatusEnum.CHANGE.getValue(), (CharSequence)claimstatus)) {
                claimtype = ClaimTypeEnum.CHANGE.getValue();
                typestr = ResManager.loadKDString((String)"\u53d8\u66f4", (String)"ClaimNoticeEditPlugin_14", (String)"fi-cas-formplugin", (Object[])new Object[0]);
            }
            QFilter filter = new QFilter("sourceid", "=", (Object)claimNoticeBill.getPkValue().toString()).and(new QFilter("sourcetype", "=", (Object)claimNoticeBill.getDataEntityType().getName())).and(new QFilter("claimtype", "=", (Object)claimtype)).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())).and(new QFilter("handlestatus", "=", (Object)ClaimHandleStatusEnum.NOTCLAIM.getValue()));
            Object[] claims = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,billno,recpaytype,paymenttype,recpayer,bizdate", (QFilter[])new QFilter[]{filter}, (String)" auditdate asc ");
            Object newrecpaytype = null;
            String newpaymenttype = "";
            String newrecpayer = "";
            Date newbizdate = null;
            if (EmptyUtil.isNoEmpty((Object[])claims)) {
                for (Object claim : claims) {
                    newrecpaytype = claim.getDynamicObject("recpaytype").getLong("id");
                    newpaymenttype = claim.getString("paymenttype");
                    newrecpayer = claim.getString("recpayer");
                    newbizdate = claim.getDate("bizdate");
                }
            }
            Long recpaytype = claimNoticeBill.getDynamicObject("recpaytype").getLong("id");
            String paymenttype = claimNoticeBill.getString("paymenttype");
            String recpayer = claimNoticeBill.getString("recpayer");
            Date bizdate = claimNoticeBill.getDate("bizdate");
            if (!(newrecpaytype == null || newbizdate == null || recpaytype.compareTo((Long)newrecpaytype) == 0 && StringUtils.equals((CharSequence)paymenttype, (CharSequence)newpaymenttype) && StringUtils.equals((CharSequence)recpayer, (CharSequence)newrecpayer) && bizdate.compareTo(newbizdate) == 0)) {
                ret.setTipsMsg(String.format(ResManager.loadKDString((String)"%1$s\u4e0e\u539f\u8ba4\u9886\u5355\u7684\u516c\u5171\u4fe1\u606f\uff08\u6536\u6b3e\u7c7b\u578b\u3001\u4ed8\u6b3e\u4eba\u7c7b\u578b\u3001\u4ed8\u6b3e\u4eba\u3001\u4e1a\u52a1\u65e5\u671f\uff09\u4e0d\u4e00\u81f4\uff0c\u5c06\u4ee5\u6700\u540e\u4e00\u6b21\u5df2\u5ba1\u6838%2$s\u7684\u4e3a\u51c6\u786e\u8ba4\u7ed3\u679c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ClaimNoticeEditPlugin_24", (String)"fi-cas-formplugin", (Object[])new Object[0]), typestr, typestr));
                ret.put("showConfirm", (Object)true);
                return ret;
            }
        }
        if (StringUtils.equals((CharSequence)claimNoticeBill.getString("businesstype"), (CharSequence)"rec")) {
            List allChildNoticeBill = RecClaimHelper.getAllChildNoticeBill((Object)primaryKeyValue);
            boolean isNeedUpdate = false;
            BigDecimal totalAmount = BigDecimal.ZERO;
            boolean isMarge = StringUtils.equals((CharSequence)MergeStatusEnum.ALMARGE.getValue(), (CharSequence)claimNoticeBill.getString("mergestatus"));
            for (DynamicObject dy : allChildNoticeBill) {
                DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)dy.getString("sourceid"), (String)"bei_transdetail");
                if (dy.getBigDecimal("reamount").compareTo(loadSingle.getBigDecimal("creditamount")) == 0) continue;
                totalAmount = totalAmount.add(loadSingle.getBigDecimal("creditamount").subtract(dy.getBigDecimal("reamount")));
                isNeedUpdate = true;
                if (!isMarge) continue;
                dy.set("reamount", (Object)loadSingle.getBigDecimal("creditamount"));
            }
            if (isNeedUpdate) {
                claimNoticeBill.set("reamount", (Object)claimNoticeBill.getBigDecimal("reamount").add(totalAmount));
                claimNoticeBill.set("unclaimamount", (Object)claimNoticeBill.getBigDecimal("unclaimamount").add(totalAmount));
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        if (totalAmount.compareTo(BigDecimal.ZERO) > 0) {
                            claimNoticeBill.set("claimstatus", (Object)ClaimStatusEnum.PART.getValue());
                        }
                        QFilter qFilter = new QFilter("claimno", "=", (Object)claimNoticeBill.getString("billno"));
                        DynamicObject[] colls = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,claimstatus,reamount", (QFilter[])new QFilter[]{qFilter});
                        for (DynamicObject dynamicObject : colls) {
                            dynamicObject.set("claimstatus", (Object)claimNoticeBill.getString("claimstatus"));
                            dynamicObject.set("reamount", (Object)claimNoticeBill.getString("reamount"));
                            SaveServiceHelper.save((DynamicObject[])colls);
                        }
                        if (isMarge) {
                            SaveServiceHelper.save((DynamicObject[])allChildNoticeBill.toArray(new DynamicObject[0]));
                        }
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{claimNoticeBill});
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
                ret.setTipsMsg(ResManager.loadKDString((String)"\u94f6\u884c\u4ea4\u6613\u660e\u7ec6\u4fe1\u606f\u5df2\u66f4\u65b0\uff0c\u8ba4\u9886\u901a\u77e5\u5355\u7684\u6536\u6b3e\u91d1\u989d\u5df2\u540c\u6b65\u66f4\u65b0\u3002", (String)"ClaimNoticeEditPlugin_37", (String)"fi-cas-formplugin", (Object[])new Object[0]));
                ret.put("showMessge", (Object)true);
                return ret;
            }
        }
        ret.setSuccess(true);
        return ret;
    }

    public static InvokeResult beforeRejectClaim(String billNo) {
        InvokeResult ret = new InvokeResult();
        ArrayList<Object[]> rejectData = new ArrayList<Object[]>();
        QFilter claimno = new QFilter("billno", "=", (Object)billNo);
        Object[] claimBills = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"claimstatus,payamount,payentity.e_payclaimbill,payentity.e_payclaimperson,payentity.e_paybillstatus,entryentity.e_claimtype,entryentity.e_billstatus,entryentity.e_claimbill,entryentity.e_claimperson", (QFilter[])new QFilter[]{claimno});
        Boolean flag = true;
        if (EmptyUtil.isNoEmpty((Object[])claimBills)) {
            Object dynamicObject = claimBills[0];
            BigDecimal payAmount = dynamicObject.getBigDecimal("payamount");
            if (payAmount.compareTo(BigDecimal.ZERO) == 0) {
                DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entryentity");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
                    for (DynamicObject entry : entrys) {
                        String e_claimperson;
                        String e_claimbill;
                        if (entry.getBoolean("e_billstatus")) continue;
                        if (StringUtils.equals((CharSequence)dynamicObject.getString("claimstatus"), (CharSequence)ClaimStatusEnum.CHANGE.getValue())) {
                            if (!StringUtils.equals((CharSequence)entry.getString("e_claimtype"), (CharSequence)ClaimTypeEnum.CHANGE.getValue())) continue;
                            e_claimbill = entry.getString("e_claimbill");
                            e_claimperson = entry.getDynamicObject("e_claimperson").getString("name");
                            rejectData.add(new Object[]{e_claimbill, e_claimperson});
                            continue;
                        }
                        e_claimbill = entry.getString("e_claimbill");
                        e_claimperson = entry.getDynamicObject("e_claimperson").getString("name");
                        rejectData.add(new Object[]{e_claimbill, e_claimperson});
                    }
                    flag = false;
                }
            } else {
                DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("payentity");
                for (DynamicObject entry : entrys) {
                    if (entry.getBoolean("e_paybillstatus")) continue;
                    String e_claimbill = entry.getString("e_payclaimbill");
                    String e_claimperson = entry.getDynamicObject("e_payclaimperson").getString("name");
                    rejectData.add(new Object[]{e_claimbill, e_claimperson});
                }
            }
            flag = false;
        }
        if (flag.booleanValue()) {
            ret.setTipsMsg(ResManager.loadKDString((String)"\u65e0\u53ef\u9a73\u56de\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ClaimNoticeEditPlugin_23", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return ret;
        }
        ret.put("rejectData", rejectData);
        ret.setSuccess(true);
        return ret;
    }

    public static InvokeResult rejectClaim(Map returnDataMap, Object pkValue) {
        BigDecimal payAmount;
        InvokeResult ret = new InvokeResult();
        QFilter qFilter = new QFilter("biztype", "=", (Object)"110").and(new QFilter("default", "=", (Object)"1")).and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] paymentBillType = BusinessDataServiceHelper.load((String)"cas_paymentbilltype", (String)"id,biztype,ispartpayment", (QFilter[])new QFilter[]{qFilter});
        DynamicObject[] receivingBillType = BusinessDataServiceHelper.load((String)"cas_receivingbilltype", (String)"id,biztype,ispartreceivable", (QFilter[])new QFilter[]{qFilter});
        String rejectbill = (String)returnDataMap.get("rejectbill");
        Set rejestBillNos = Stream.of(rejectbill.split(",")).collect(Collectors.toSet());
        DynamicObject claimcenterbill = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"cas_claimcenterbill");
        String oldclaimstatus = claimcenterbill.getString("claimstatus");
        DynamicObjectCollection entryentity = claimcenterbill.getDynamicObjectCollection("entryentity");
        Iterator iterator = entryentity.iterator();
        ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>();
        boolean isaddfee = claimcenterbill.getBoolean("isaddfee");
        boolean updatefeezero = false;
        while (iterator.hasNext()) {
            DynamicObject entry = (DynamicObject)iterator.next();
            if (!rejestBillNos.contains(entry.getString("e_claimbill"))) continue;
            if (entry.getBoolean("e_handlestatus")) {
                entry.set("e_billstatus", (Object)true);
                dataList.add(entry);
                updatefeezero = true;
            }
            iterator.remove();
        }
        DynamicObjectCollection payentity = claimcenterbill.getDynamicObjectCollection("payentity");
        Iterator iteratorPay = payentity.iterator();
        while (iteratorPay.hasNext()) {
            DynamicObject entry = (DynamicObject)iteratorPay.next();
            if (!rejestBillNos.contains(entry.getString("e_payclaimbill"))) continue;
            if (entry.getBoolean("e_payhandlestatus")) {
                entry.set("e_paybillstatus", (Object)true);
            }
            iteratorPay.remove();
        }
        String claimstatus = oldclaimstatus;
        ClaimNoticeMesParam param = new ClaimNoticeMesParam();
        param.setTag(ResManager.loadKDString((String)"\u6536\u4ed8\u8ba4\u9886", (String)"ClaimRecWorkbenchPlugin_11", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        param.setTitle(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba4\u9886\u7ed3\u679c\u88ab\u9a73\u56de\uff0c\u8bf7\u5c3d\u5feb\u67e5\u770b\u548c\u5904\u7406\u3002", (String)"ClaimNoticeEditPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        param.setContent(String.format(ResManager.loadKDString((String)"\u8ba4\u9886\u5355\uff08\u7f16\u53f7\uff1a%1$s\uff09\u88ab\u9a73\u56de\uff0c\u9a73\u56de\u539f\u56e0\uff1a%2$s\uff0c\u8bf7\u5c3d\u5feb\u67e5\u770b\u548c\u5904\u7406\u3002", (String)"ClaimNoticeEditPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]), claimcenterbill.getString("billno"), returnDataMap.get("rejectreason")));
        param.setNoticeType("reject");
        QFilter billnoQf = new QFilter("claimno", "=", (Object)claimcenterbill.getString("billno"));
        DynamicObject[] claimbills = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,sourceclaimid,billstatus,claimtype,handlestatus,claimstatus,rejectreason,billno,creator,entryentity.claimdimension,entryentity.claimcomtrol,entryentity.e_corebilltype,entryentity.e_corebillid,entryentity.e_corebillentryid,entryentity.e_receivableamt,entryentity,entryentity.e_actamt,entryentity.e_fee", (QFilter[])new QFilter[]{billnoQf});
        ArrayList<Object> relClaimbillIds = new ArrayList<Object>(claimbills.length);
        for (DynamicObject claimbill : claimbills) {
            if (rejestBillNos.contains(claimbill.getString("billno"))) {
                if (StringUtils.equals((CharSequence)ClaimHandleStatusEnum.CLAIMED.getValue(), (CharSequence)claimbill.getString("handlestatus"))) {
                    claimbill.set("billstatus", (Object)BillStatusEnum.DEAD.getValue());
                } else {
                    relClaimbillIds.add(claimbill.getPkValue());
                    claimbill.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
                    if (StringUtils.equals((CharSequence)ClaimTypeEnum.CHANGE.getValue(), (CharSequence)claimbill.getString("claimtype"))) {
                        for (DynamicObject dynamicObject : claimbills) {
                            if (claimbill.getLong("sourceclaimid") != dynamicObject.getLong("id")) continue;
                            dynamicObject.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                            entryentity.forEach(dy -> {
                                if (StringUtils.equals((CharSequence)dy.getString("e_claimbill"), (CharSequence)dynamicObject.getString("billno"))) {
                                    dy.set("e_billstatus", (Object)false);
                                }
                            });
                        }
                    }
                }
                claimbill.set("rejectreason", returnDataMap.get("rejectreason"));
                param.setUserIds(Collections.singleton(claimbill.getDynamicObject("creator").getLong("id")));
                param.setPkId(Long.valueOf(claimbill.getLong("id")));
                RecClaimHelper.sendNoticeMessage((ClaimNoticeMesParam)param);
            }
            if (!isaddfee || !updatefeezero) continue;
            claimbill.getDynamicObjectCollection("entryentity").forEach(dy -> {
                dy.set("e_actamt", (Object)dy.getBigDecimal("e_actamt").add(dy.getBigDecimal("e_fee")));
                dy.set("e_fee", (Object)BigDecimal.ZERO);
            });
        }
        int size = entryentity.size();
        for (DynamicObject dynamicObject : dataList) {
            dynamicObject.set("seq", (Object)size++);
            entryentity.add((Object)dynamicObject);
        }
        RecClaimBillHelper.claimEntryOrder((DynamicObjectCollection)entryentity);
        if (isaddfee && updatefeezero) {
            entryentity.forEach(dy -> {
                dy.set("e_actamt", (Object)dy.getBigDecimal("e_actamt").add(dy.getBigDecimal("e_fee")));
                dy.set("e_fee", (Object)BigDecimal.ZERO);
            });
        }
        if ((payAmount = claimcenterbill.getBigDecimal("payamount")).compareTo(BigDecimal.ZERO) != 0) {
            Boolean singleStream = claimcenterbill.getBoolean("singlestream");
            DynamicObjectCollection claimNoticeEntry = claimcenterbill.getDynamicObjectCollection("payentity");
            BigDecimal payableamt = claimNoticeEntry.stream().filter(dy -> !dy.getBoolean("e_paybillstatus")).map(dy -> dy.getBigDecimal("e_payableamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal payactamt = claimNoticeEntry.stream().filter(dy -> !dy.getBoolean("e_paybillstatus")).map(dy -> dy.getBigDecimal("e_payactamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal unclaimamount = payAmount.subtract(claimcenterbill.getBigDecimal("fee")).add(payableamt).subtract(payactamt).subtract(payableamt);
            if (singleStream.booleanValue()) {
                unclaimamount = unclaimamount.add(claimcenterbill.getBigDecimal("fee"));
            }
            claimcenterbill.set("unclaimamount", (Object)unclaimamount);
            claimcenterbill.set("claimedamount", (Object)payableamt);
            if (payableamt.compareTo(BigDecimal.ZERO) == 0) {
                claimcenterbill.set("paytype", null);
                claimcenterbill.set("payeetype", null);
                claimcenterbill.set("recpayee", null);
                claimcenterbill.set("recbasepayee", null);
                claimcenterbill.set("recbasetype", null);
                claimcenterbill.set("recviewpayer", null);
                claimstatus = ClaimStatusEnum.WAIT.getValue();
            } else {
                claimstatus = payableamt.compareTo(BigDecimal.ZERO) > 0 && unclaimamount.compareTo(BigDecimal.ZERO) <= 0 ? ClaimStatusEnum.CLAIMED.getValue() : ClaimStatusEnum.PART.getValue();
            }
            claimcenterbill.set("claimstatus", (Object)claimstatus);
            DynamicObject[] dynamicObjectArray = claimbills;
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject claimbill = dynamicObjectArray[i];
                claimbill.set("claimstatus", (Object)claimstatus);
            }
            long l = claimNoticeEntry.stream().map(o -> o.getDynamicObject("e_paymenttype")).distinct().count();
            if (l == 1L) {
                claimcenterbill.set("multipaymenttype", (Object)Boolean.FALSE);
                DynamicObject ePaymentType = ((DynamicObject)claimNoticeEntry.get(0)).getDynamicObject("e_paymenttype");
                claimcenterbill.set("paytype", (Object)ePaymentType);
            } else if (l > 1L) {
                claimcenterbill.set("multipaymenttype", (Object)Boolean.TRUE);
                if (paymentBillType != null && paymentBillType.length != 0) {
                    claimcenterbill.set("paytype", (Object)paymentBillType[0]);
                }
            } else if (l == 0L) {
                claimcenterbill.set("multipaymenttype", (Object)Boolean.FALSE);
                claimcenterbill.set("paytype", null);
            }
        } else {
            BigDecimal oldrec = entryentity.stream().filter(dy -> !dy.getBoolean("e_billstatus")).map(dy -> dy.getBigDecimal("e_receivableamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            DynamicObject[] olddis = entryentity.stream().filter(dy -> !dy.getBoolean("e_billstatus")).map(dy -> dy.getBigDecimal("e_discountamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal actAmt = entryentity.stream().filter(dy -> !dy.getBoolean("e_billstatus")).map(dy -> dy.getBigDecimal("e_actamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal oldfee = entryentity.stream().filter(dy -> !dy.getBoolean("e_billstatus")).map(dy -> dy.getBigDecimal("e_fee")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal reamount = claimcenterbill.getBigDecimal("reamount");
            if (!isaddfee) {
                claimcenterbill.set("fee", (Object)oldfee);
            }
            BigDecimal bigDecimal2 = BigDecimal.ZERO;
            bigDecimal2 = bigDecimal2.add(reamount).add(claimcenterbill.getBigDecimal("fee")).subtract(oldfee).add(oldrec).subtract(actAmt).subtract(oldrec);
            reamount = reamount.add(claimcenterbill.getBigDecimal("fee"));
            reamount = reamount.add((BigDecimal)olddis);
            BigDecimal claimedamount = oldrec;
            claimcenterbill.set("claimedamount", (Object)claimedamount);
            claimcenterbill.set("unclaimamount", (Object)bigDecimal2);
            if (StringUtils.equals((CharSequence)ClaimStatusEnum.WAIT.getValue(), (CharSequence)oldclaimstatus) || StringUtils.equals((CharSequence)ClaimStatusEnum.CLAIMED.getValue(), (CharSequence)oldclaimstatus) || StringUtils.equals((CharSequence)ClaimStatusEnum.PART.getValue(), (CharSequence)oldclaimstatus)) {
                if (claimedamount.compareTo(BigDecimal.ZERO) == 0) {
                    claimstatus = ClaimStatusEnum.WAIT.getValue();
                    claimcenterbill.set("recpaytype", null);
                    claimcenterbill.set("paymenttype", null);
                    claimcenterbill.set("recpayer", null);
                } else {
                    claimstatus = claimedamount.compareTo(reamount) >= 0 ? ClaimStatusEnum.CLAIMED.getValue() : ClaimStatusEnum.PART.getValue();
                }
            }
            claimcenterbill.set("claimstatus", (Object)claimstatus);
            for (DynamicObject claimbill : claimbills) {
                claimbill.set("claimstatus", (Object)claimstatus);
            }
            DynamicObjectCollection claimNoticeEntry = claimcenterbill.getDynamicObjectCollection("entryentity");
            long disTypeNum = claimNoticeEntry.stream().map(o -> o.getDynamicObject("e_receivingtype")).distinct().count();
            if (disTypeNum == 1L) {
                claimcenterbill.set("multireceivingtype", (Object)Boolean.FALSE);
                DynamicObject eReceivingType = ((DynamicObject)claimNoticeEntry.get(0)).getDynamicObject("e_receivingtype");
                claimcenterbill.set("recpaytype", (Object)eReceivingType);
            } else if (disTypeNum > 1L) {
                claimcenterbill.set("multireceivingtype", (Object)Boolean.TRUE);
                if (receivingBillType != null && receivingBillType.length != 0) {
                    claimcenterbill.set("recpaytype", (Object)receivingBillType[0]);
                }
            } else if (disTypeNum == 0L) {
                claimcenterbill.set("multireceivingtype", (Object)Boolean.FALSE);
                claimcenterbill.set("recpaytype", null);
            }
        }
        ArrayList claimCoreInfoList = new ArrayList(10);
        for (DynamicObject claimbill : claimbills) {
            if (!rejestBillNos.contains(claimbill.getString("billno")) || !BillStatusEnum.DEAD.getValue().equals(claimbill.get("billstatus"))) continue;
            RecClaimHelper.getDelClaimCoreInfo((DynamicObject)claimbill, claimCoreInfoList);
        }
        RecClaimHelper.writeBackAmt(claimCoreInfoList);
        SaveServiceHelper.save((DynamicObject[])claimbills);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{claimcenterbill});
        if (relClaimbillIds.size() > 0) {
            try (TXHandle tx = TX.requiresNew();){
                DynamicObject[] relClaimbills;
                for (DynamicObject relClaimbill : relClaimbills = BusinessDataServiceHelper.load((Object[])relClaimbillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_claimbill"))) {
                    if (!CommonOperationHandler2.isNeedValidate(relClaimbill)) continue;
                    RecBillOverAmountHelper.getWriteBackVad((DynamicObject)relClaimbill, (WriteBackOperateEnum)WriteBackOperateEnum.UNSUBMIT, (boolean)false);
                }
            }
        }
        ret.setSuccess(true);
        return ret;
    }

    private static boolean isNeedValidate(DynamicObject info) {
        DynamicObjectCollection entrys = info.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            if ("fr_glreim_paybill".equals(entry.getString("e_corebilltype")) || "fr_glreim_recbill".equals(entry.getString("e_corebilltype"))) {
                return true;
            }
            if (!"ar_finarbill".equals(entry.getString("e_corebilltype"))) continue;
            return true;
        }
        return false;
    }

    private static boolean recValidateByClaimNotice(Long id, InvokeResult ret) {
        QFilter qFilter;
        Object[] ids;
        QFilter qFilter1 = new QFilter("id", "=", (Object)id);
        Object[] claimBills = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,claimno", (QFilter[])new QFilter[]{qFilter1});
        return EmptyUtil.isNoEmpty((Object[])claimBills) && EmptyUtil.isNoEmpty((Object[])(ids = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id", (QFilter[])new QFilter[]{qFilter = new QFilter("billno", "=", (Object)claimBills[0].getString("claimno"))}))) && CommonOperationHandler2.recValidate(ids[0].getLong("id"), ret, Boolean.FALSE);
    }

    private static Boolean getResultByParameter(InvokeResult ret, boolean parameter, boolean isNotMerge, boolean oppUnitNotSame) {
        Boolean temp = false;
        if (parameter) {
            if (isNotMerge) {
                temp = true;
                ret.setErrorMsg(ResManager.loadKDString((String)"\u53ea\u6709\u76f8\u540c\u4e1a\u52a1\u7c7b\u578b\uff08\u7968\u636e\u7684\u8bdd\u8fd8\u8981\u6c42\u662f\u76f8\u540c\u7c7b\u522b\uff09\u3001\u8d44\u91d1\u7ec4\u7ec7\u3001\u94f6\u884c\u8d26\u53f7\u3001\u5bf9\u65b9\u6237\u540d\u3001\u5e01\u79cd\u7684\u901a\u77e5\u5355\u624d\u80fd\u5408\u5e76\u3002", (String)"NoticeListPlugin_18", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            }
        } else if (isNotMerge || oppUnitNotSame) {
            temp = true;
            ret.setErrorMsg(ResManager.loadKDString((String)"\u53ea\u6709\u76f8\u540c\u4e1a\u52a1\u7c7b\u578b\uff08\u7968\u636e\u7684\u8bdd\u8fd8\u8981\u6c42\u662f\u76f8\u540c\u7c7b\u522b\uff09\u3001\u8d44\u91d1\u7ec4\u7ec7\u3001\u94f6\u884c\u8d26\u53f7\u3001\u5bf9\u65b9\u6237\u540d\u3001\u5e01\u79cd\u7684\u901a\u77e5\u5355\u624d\u80fd\u5408\u5e76\u3002", (String)"NoticeListPlugin_18", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        return temp;
    }

    private static boolean recValidate(Long id, InvokeResult ret, boolean isStop) {
        Map targetRecBills = BFTrackerServiceHelper.findTargetBills((String)"cas_claimcenterbill", (Long[])new Long[]{id});
        HashSet targetEntityRecIds = (HashSet)targetRecBills.get("cas_recbill");
        if (!CollectionUtils.isEmpty((Collection)targetEntityRecIds)) {
            DynamicObject[] recBills = BusinessDataServiceHelper.load((Object[])targetEntityRecIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_recbill"));
            HashSet<Long> unSetBillId = new HashSet<Long>(10);
            ArrayList<Long> ids = new ArrayList<Long>(recBills.length);
            for (DynamicObject recBill : recBills) {
                if ("1".equals(recBill.getString("hotaccount")) || "2".equals(recBill.getString("hotaccount"))) continue;
                ids.add((Long)recBill.getPkValue());
                DynamicObjectCollection entryCol = recBill.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entryCol) {
                    Boolean matchSellTag = entry.getBoolean("e_matchselltag");
                    if (matchSellTag.booleanValue()) {
                        return true;
                    }
                    BigDecimal SettledAmt = entry.getBigDecimal("e_settledamt");
                    if (BigDecimal.ZERO.compareTo(SettledAmt) == 0 || !ret.isSettleAmtIsZero()) continue;
                    ret.setSettleAmtIsZero(Boolean.FALSE.booleanValue());
                    unSetBillId.add((Long)recBill.getPkValue());
                }
            }
            if (ids.size() > 0) {
                Set settleRecordIds = PayBillHepler.getViewSettle(ids, (String)"cas_recbill", (String)"mainbillid", (String)"entry.billid");
                settleRecordIds.removeIf(o -> EmptyUtil.isEmpty((Long)o));
                logger.info("CommonOperationHandler2 ids:{},viewSettles:{}", ids, (Object)settleRecordIds);
                if (settleRecordIds.size() > 0) {
                    unSetBillId.addAll(settleRecordIds);
                    if (isStop) {
                        return true;
                    }
                }
            }
            ret.setUnSetBillSet(unSetBillId);
        }
        return false;
    }

    public static InvokeResult beforeAdjust(Object claimBillId) {
        QFilter claimtypeQf;
        QFilter creatorQf;
        InvokeResult ret = new InvokeResult();
        QFilter qFilter = new QFilter("sourceclaimid", "=", claimBillId);
        QFilter billstatusQf = new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getValue());
        DynamicObject[] claimblls = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id", (QFilter[])new QFilter[]{qFilter, billstatusQf, creatorQf = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId())).and(new QFilter("handlestatus", "=", (Object)ClaimHandleStatusEnum.NOTCLAIM.getValue())), claimtypeQf = new QFilter("claimtype", "=", (Object)ClaimTypeEnum.ADJUST.getValue())});
        if (claimblls.length > 0) {
            ret.setTipsMsg(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u63d0\u4ea4\u7684\u8c03\u6574\u5355\uff0c\u8bf7\u64a4\u9500\u63d0\u4ea4\u540e\u4fee\u6539\uff0c\u65e0\u9700\u65b0\u589e\u65b0\u8c03\u6574\u5355\u3002", (String)"ClaimHandleListPlugin_5", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            return ret;
        }
        QFilter billstatusQf1 = new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue());
        DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"cas_claimbill", (String)"id,createtime", (QFilter[])new QFilter[]{qFilter, billstatusQf1, creatorQf, claimtypeQf}, (String)"");
        Long recentDateId = null;
        Date recentDate = null;
        while (ds.hasNext()) {
            Row claimbill = ds.next();
            Date createtime = claimbill.getDate("createtime");
            if (recentDate == null) {
                recentDate = createtime;
                recentDateId = claimbill.getLong("id");
            }
            recentDateId = createtime.compareTo(recentDate) > 0 ? claimbill.getLong("id") : recentDateId;
        }
        ds.close();
        if (recentDate != null) {
            ret.setTipsMsg(ResManager.loadKDString((String)"\u5df2\u6253\u5f00\u6682\u5b58\u7684\u8c03\u6574\u5355\uff0c\u65e0\u9700\u65b0\u589e\u8c03\u6574\u5355\u3002", (String)"ClaimHandleListPlugin_6", (String)"fi-cas-formplugin", (Object[])new Object[0]));
            ret.put("recentDateId", (Object)recentDateId);
            return ret;
        }
        ret.setSuccess(true);
        return ret;
    }
}

