/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.writeback.payapply.service;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.base.WriteBackParam;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.business.writeback.payapply.service.AbstractPayWriteBackPayApplyService;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.refund.RefundEntryInfo;
import kd.fi.cas.refund.RefundPayBillInfo;
import kd.fi.cas.refund.RefundRenoteOrCancelParam;
import kd.fi.cas.refund.SourceBillInfo;
import kd.fi.cas.util.EmptyUtil;

public class RefundWriteBackPayApplyService
extends AbstractPayWriteBackPayApplyService {
    private static final Log LOGGER = LogFactory.getLog(RefundWriteBackPayApplyService.class);
    private RefundRenoteOrCancelParam param;
    private String operate;

    public RefundWriteBackPayApplyService(WriteBackParam param) {
        this.operate = param.getOperate();
        this.param = (RefundRenoteOrCancelParam)param;
    }

    public void writeBack() {
        List refundPayInfoList = this.param.getRefundPayInfos();
        LOGGER.info("[writeBack]\u672c\u6b21\u9000\u7968/\u9000\u6b3e\u53cd\u5199\u4ed8\u6b3e\u7533\u8bf7\u5355\u5165\u53c2\uff1a{}", (Object)SerializationUtils.toJsonString((Object)this.param));
        Set payIdSet = refundPayInfoList.stream().map(RefundPayBillInfo::getTargetPk).collect(Collectors.toSet());
        QFilter filter = new QFilter("id", "in", (Object)payIdSet.toArray());
        DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,billstatus", (QFilter[])filter.toArray());
        Map payIdAndDataMap = Arrays.stream(payBills).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
        HashSet ids = new HashSet(16);
        refundPayInfoList.forEach(refundPayBillInfo -> ids.addAll(refundPayBillInfo.getEntryInfos().stream().filter(e -> EmptyUtil.isNoEmpty((Object)e.getSourceInfos())).map(e -> ((SourceBillInfo)e.getSourceInfos().get(0)).getSourcePk()).collect(Collectors.toSet())));
        DynamicObject[] payApplyBills = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_payapplybill"));
        Map payApplyIdAndDataMap = Arrays.stream(payApplyBills).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
        for (RefundPayBillInfo refundPayBillInfo2 : refundPayInfoList) {
            Long payId = refundPayBillInfo2.getTargetPk();
            DynamicObject payBill = (DynamicObject)payIdAndDataMap.get(payId);
            if (EmptyUtil.isEmpty((DynamicObject)payBill)) {
                LOGGER.info("[writeBack]\u9000\u7968/\u9000\u6b3e\uff0c\u67e5\u8be2\u4ed8\u6b3e\u5355\u4fe1\u606f\u5931\u8d25\uff0c\u4ed8\u6b3e\u5355id\uff1a{}", (Object)payId);
                continue;
            }
            String payStatus = payBill.getString("billstatus");
            LOGGER.info("[writeBack]\u9000\u7968/\u9000\u6b3e\uff0c\u5f00\u59cb\u5904\u7406\u4ed8\u6b3e\u5355\u5206\u5f55\uff0c\u4ed8\u6b3e\u5355id\uff1a{}\uff0c\u4ed8\u6b3e\u72b6\u6001\uff1a{}", (Object)payId, (Object)payStatus);
            List entryInfoList = refundPayBillInfo2.getEntryInfos();
            for (RefundEntryInfo entryInfo : entryInfoList) {
                Set sourceEntryIdSet;
                List sourceInfoList = entryInfo.getSourceInfos();
                if (EmptyUtil.isEmpty((Collection)sourceInfoList)) {
                    LOGGER.info("[writeBack]\u9000\u7968/\u9000\u6b3e\uff0c\u6e90\u5355\u4fe1\u606f\u96c6\u5408\u4e3a\u7a7a\uff0c\u4ed8\u6b3e\u5355id\uff1a{}\uff0c\u4ed8\u6b3e\u72b6\u6001\uff1a{}", (Object)payId, (Object)payStatus);
                    continue;
                }
                LOGGER.info("[writeBack]\u9000\u7968/\u9000\u6b3e\uff0c\u4ed8\u6b3e\u5355\u6e90\u5355\uff08\u4ed8\u6b3e\u7533\u8bf7\u5355\uff09\u6570\u91cf\uff1a{}", (Object)sourceInfoList.size());
                SourceBillInfo sourceBillInfo = (SourceBillInfo)sourceInfoList.get(0);
                DynamicObject payApplyBill = (DynamicObject)payApplyIdAndDataMap.get(sourceBillInfo.getSourcePk());
                if (EmptyUtil.isEmpty((DynamicObject)payApplyBill) || EmptyUtil.isEmpty((Collection)(sourceEntryIdSet = sourceBillInfo.getSourceEntryPks()))) continue;
                Long sourceEntryId = (Long)sourceEntryIdSet.iterator().next();
                LOGGER.info("[writeBack]\u9000\u7968/\u9000\u6b3e\uff0c\u4ed8\u6b3e\u7533\u8bf7\u5355\u5206\u5f55id\uff1a{}", (Object)sourceEntryId);
                DynamicObjectCollection payInfoEntries = payApplyBill.getDynamicObjectCollection("cas_payinfo");
                Optional<DynamicObject> payApplyEntryOptional = payInfoEntries.stream().filter(e -> sourceEntryId.equals(e.get("id"))).findFirst();
                if (!payApplyEntryOptional.isPresent()) {
                    LOGGER.info("[writeBack]\u9000\u7968/\u9000\u6b3e\uff0c\u4ed8\u6b3e\u660e\u7ec6\u5206\u5f55\u4e0d\u5b58\u5728\uff0c\u4ed8\u6b3e\u7533\u8bf7\u5355\u5206\u5f55id\uff1a{}", (Object)sourceEntryId);
                    continue;
                }
                DynamicObject currentEntry = payApplyEntryOptional.get();
                BigDecimal refundAmt = entryInfo.getRefundAmt();
                BigDecimal entryRemainRefundAmt = entryInfo.getEntryRemainRefundAmt();
                LOGGER.info("[writeBack]\u9000\u7968/\u9000\u6b3e\uff0c\u672c\u6b21\u9000\u6b3e\u91d1\u989d\uff1a{}\uff0c\u5206\u5f55\u5df2\u9000\u6b3e\u91d1\u989d(\u52a0\u4e0a\u672c\u6b21\u9000\u6b3e\u91d1\u989d)\uff1a{}\uff0c\u672c\u6b21\u5269\u4f59\u53ef\u9000\u91d1\u989d\uff1a{}", new Object[]{refundAmt, entryInfo.getEntryRefundedAmt(), entryRemainRefundAmt});
                BigDecimal refundAmount = currentEntry.getBigDecimal("entry_refundamount");
                if (refundAmount == null) {
                    refundAmount = BigDecimal.ZERO;
                }
                refundAmount = refundAmount.add(refundAmt);
                BigDecimal remainRefundAmount = currentEntry.getBigDecimal("entry_remainrfamount");
                if (remainRefundAmount == null) {
                    remainRefundAmount = BigDecimal.ZERO;
                }
                remainRefundAmount = remainRefundAmount.subtract(refundAmt);
                currentEntry.set("entry_refundamount", (Object)refundAmount);
                currentEntry.set("entry_remainrfamount", (Object)remainRefundAmount);
                currentEntry.set("entry_statusexplain", (Object)entryInfo.getReason());
                boolean refundAndRePay = payApplyBill.getBoolean("refundandrepay");
                if (StringUtils.equals((CharSequence)WriteBackOperateEnum.REFUND.getValue(), (CharSequence)this.operate) || StringUtils.equals((CharSequence)WriteBackOperateEnum.RENOTE.getValue(), (CharSequence)this.operate)) {
                    if (refundAndRePay) {
                        this.copyNewEntry(payInfoEntries, currentEntry, refundAmt);
                    }
                    if (StringUtils.equals((CharSequence)WriteBackOperateEnum.REFUND.getValue(), (CharSequence)this.operate)) {
                        currentEntry.set("entry_refund", (Object)true);
                    } else {
                        currentEntry.set("entry_backbill", (Object)true);
                    }
                } else if (StringUtils.equals((CharSequence)WriteBackOperateEnum.CANCELREFUND.getValue(), (CharSequence)this.operate) || StringUtils.equals((CharSequence)WriteBackOperateEnum.CANCELRENOTE.getValue(), (CharSequence)this.operate)) {
                    boolean rela;
                    if (refundAndRePay) {
                        this.deleteEntryRow(payInfoEntries, currentEntry);
                    }
                    boolean bl = rela = refundAndRePay && payInfoEntries.stream().anyMatch(e -> currentEntry.getPkValue().equals(e.getLong("entry_relaentryid")));
                    if (StringUtils.equals((CharSequence)WriteBackOperateEnum.CANCELREFUND.getValue(), (CharSequence)this.operate)) {
                        currentEntry.set("entry_refund", (Object)rela);
                    } else {
                        currentEntry.set("entry_backbill", (Object)rela);
                    }
                }
                this.setPayApplyInfoEntryPayStatus(currentEntry);
                this.setHeadStatus(payApplyBill);
                try {
                    this.msgNotice(payApplyBill);
                }
                catch (Exception e2) {
                    LOGGER.error("\u6d88\u606f\u901a\u77e5\u5931\u8d25", (Throwable)e2);
                }
                this.setPartPay(payApplyBill);
            }
        }
        Collection<DynamicObject> payApplyBillList = payApplyIdAndDataMap.values();
        if (EmptyUtil.isNoEmpty(payApplyBillList)) {
            SaveServiceHelper.save((DynamicObject[])payApplyBillList.toArray(new DynamicObject[0]));
        }
    }

    private void setPayApplyInfoEntryPayStatus(DynamicObject currentEntry) {
        BigDecimal payeeAmount = currentEntry.getBigDecimal("entry_payeeamount");
        payeeAmount = EmptyUtil.isNoEmpty((BigDecimal)payeeAmount) ? payeeAmount : BigDecimal.ZERO;
        BigDecimal paidAmount = currentEntry.getBigDecimal("entry_paidamount");
        BigDecimal bigDecimal = paidAmount = EmptyUtil.isNoEmpty((BigDecimal)paidAmount) ? paidAmount : BigDecimal.ZERO;
        if (paidAmount.compareTo(payeeAmount) < 0) {
            currentEntry.set("entry_paystatus", (Object)PayStatusEnum.PAYING.getValue());
        } else {
            currentEntry.set("entry_paystatus", (Object)PayStatusEnum.PAYMENTSUCCESS.getValue());
        }
    }

    private void copyNewEntry(DynamicObjectCollection payInfoEntries, DynamicObject sourceEntry, BigDecimal refundAmt) {
        DynamicObject newEntryData = payInfoEntries.addNew();
        Set entryProperties = EntityPropertyHelper.getEntryPropertys((String)"cas_payapplybill", (String)"cas_payinfo");
        for (String entryProperty : entryProperties) {
            newEntryData.set(entryProperty, sourceEntry.get(entryProperty));
        }
        newEntryData.set("id", null);
        newEntryData.set("entry_paystatus", (Object)PayStatusEnum.NOTPAYING.getValue());
        newEntryData.set("entry_paydate", null);
        newEntryData.set("entry_paybillno", null);
        newEntryData.set("entry_statusexplain", null);
        refundAmt = refundAmt.abs();
        newEntryData.set("entry_payamount", (Object)refundAmt);
        newEntryData.set("entry_payeeamount", (Object)refundAmt);
        newEntryData.set("entry_paidamount", (Object)BigDecimal.ZERO);
        newEntryData.set("entry_lockedamount", (Object)BigDecimal.ZERO);
        newEntryData.set("entry_refundamount", (Object)BigDecimal.ZERO);
        newEntryData.set("entry_remainrfamount", (Object)BigDecimal.ZERO);
        newEntryData.set("entry_refund", (Object)false);
        newEntryData.set("entry_backbill", (Object)false);
        newEntryData.set("entry_invalid", (Object)false);
        newEntryData.set("entry_relaentryid", sourceEntry.getPkValue());
        newEntryData.set("entry_relarecbillid", (Object)this.param.getRecId());
    }

    private void deleteEntryRow(DynamicObjectCollection payInfoEntries, DynamicObject currentEntry) {
        payInfoEntries.removeIf(e -> currentEntry.getPkValue().equals(e.getLong("entry_relaentryid")) && this.param.getRecId().equals(e.getLong("entry_relarecbillid")));
    }
}

