/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.report.capitalreport.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.TimeTypeEnum;
import kd.fi.cas.report.CapitalSumListDataRpt;
import kd.fi.cas.report.CapitalSumParam;
import kd.fi.cas.report.capitalreport.enums.QueryTypeEnum;
import kd.fi.cas.report.capitalreport.report.CapitalDataAbstract;
import kd.fi.cas.util.EmptyUtil;

public class CapitalDataSum
extends CapitalDataAbstract {
    @Override
    public DataSet query(ReportQueryParam arg0, Object arg1, boolean isQing) {
        arg0.getFilter().addFilterItem("reporttype", (Object)"0");
        DataSet ds = super.query(arg0, arg1, false);
        log.info("{}CapitalDataSum_query.", (Object)"CapitalReportData:");
        ds = ds.updateField("famtdecimal", "CAST(famtdecimal AS Integer)").updateField("frptamtdecimal", "CAST(frptamtdecimal AS Integer)");
        ds = arg0.getFilter().getInt("timetype") == TimeTypeEnum.BYPERIOD.getValue().intValue() ? ds.select(new String[]{"fbankname as finorginfo", "frptcurrency1 as currencyfield", "frptcurrency1 as calccurrency1", "fcurrencyid as currencyfield1", "fsign as sign", "frptsign", "fperiod as period", "ftype", "fperiodname", "fperiodname as periodname", "forgid as orgid", "forgname as orgname", "forgname", "frptbanktype as rptbanktype", "ftype as capitaltype", "facctid as accountcash", "facctshortname as accountbank", "facctname as acctname", "facctpurpose as acctpurpose", "facctstyle as acctstyle", "faccttype as accttype", "facctnumber as accountnumber", "fcurrencyid as currencyid", "fcurrencyname as currencyname", "fbankname as bankid", "sumlevel", "round(fbalance" + this.unit + ",famtdecimal) as daystart", "round(fbalancerpt" + this.unit + ",frptamtdecimal) as daystartcalc", "round(fdebitamount" + this.unit + ",famtdecimal) as daydebitamount", "round(fdebitamountrpt" + this.unit + ",frptamtdecimal) as daydebitamountcalc", "round(fcreditamount" + this.unit + ",famtdecimal) as daycreditamount", "round(fcreditamountrpt" + this.unit + ",frptamtdecimal) as daycreditamountcalc", "round((fbalance + fdebitamount - fcreditamount)" + this.unit + ",famtdecimal) as daybalance", "round((fbalancerpt + fdebitamountrpt - fcreditamountrpt)" + this.unit + ",frptamtdecimal) as daybalancecalc", "case when sumlevel = 3 then 0 else round(fbalance" + this.unit + ",famtdecimal) end as monthstart", "case when sumlevel = 3 then 0 else round(fbalancerpt" + this.unit + ",frptamtdecimal) end as monthstartcalc", "round(fdebitamount" + this.unit + ",famtdecimal) as debitamount", "round(fdebitamountrpt" + this.unit + ",frptamtdecimal) as debitamountcalc", "round(fcreditamount" + this.unit + ",famtdecimal) as creditamount", "round(fcreditamountrpt" + this.unit + ",frptamtdecimal) as creditamountcalc", "case when sumlevel = 3 then 0 else round((fbalance + fdebitamount - fcreditamount)" + this.unit + ",famtdecimal) end as monthbalance", "case when sumlevel = 3 then 0 else round((fbalancerpt + fdebitamountrpt - fcreditamountrpt)" + this.unit + ",frptamtdecimal) end as monthbalancecalc", "case when sumlevel = 3 then 0 else round(fyearbalance" + this.unit + ",famtdecimal) end as yearstart", "case when sumlevel = 3 then 0 else round(fyearbalancerpt" + this.unit + ",frptamtdecimal) end as yearstartcalc", "case when sumlevel = 3 then 0 else round(fyeardebitamount" + this.unit + ",famtdecimal) end as yeardebit", "case when sumlevel = 3 then 0 else round(fyeardebitamountrpt" + this.unit + ",frptamtdecimal) end as yeardebitcalc", "case when sumlevel = 3 then 0 else round(fyearcreditamount" + this.unit + ",famtdecimal) end as yearcredit", "case when sumlevel = 3 then 0 else round(fyearcreditamountrpt" + this.unit + ",frptamtdecimal) end as yearcreditcalc", "case when sumlevel = 3 then 0 else round((fyearbalance + fyeardebitamount - fyearcreditamount)" + this.unit + ",famtdecimal) end as yearbalance", "case when sumlevel = 3 then 0 else round((fyearbalancerpt + fyeardebitamountrpt - fyearcreditamountrpt)" + this.unit + ",frptamtdecimal) end as yearbalancecalc"}) : ds.select(new String[]{"fbankname as finorginfo", "frptcurrency1 as currencyfield", "frptcurrency1 as calccurrency1", "fcurrencyid as currencyfield1", "fsign as sign", "frptsign", "fperiod as period", "ftype", "fperiodname", "fperiodname as periodname", "forgid as orgid", "forgname as orgname", "forgname", "frptbanktype as rptbanktype", "ftype as capitaltype", "facctid as accountcash", "facctshortname as accountbank", "facctname as acctname", "facctpurpose as acctpurpose", "facctstyle as acctstyle", "faccttype as accttype", "facctnumber as accountnumber", "fcurrencyid as currencyid", "fcurrencyname as currencyname", "fbankname as bankid", "sumlevel", "round(fbalance" + this.unit + ",famtdecimal) as daystart", "round(fbalancerpt" + this.unit + ",frptamtdecimal) as daystartcalc", "round(fdebitamount" + this.unit + ",famtdecimal) as daydebitamount", "round(fdebitamountrpt" + this.unit + ",frptamtdecimal) as daydebitamountcalc", "round(fcreditamount" + this.unit + ",famtdecimal) as daycreditamount", "round(fcreditamountrpt" + this.unit + ",frptamtdecimal) as daycreditamountcalc", "round((fbalance + fdebitamount - fcreditamount)" + this.unit + ",famtdecimal) as daybalance", "round((fbalancerpt + fdebitamountrpt - fcreditamountrpt)" + this.unit + ",frptamtdecimal) as daybalancecalc", "round(fbalance" + this.unit + ",famtdecimal) as monthstart", "round(fbalancerpt" + this.unit + ",frptamtdecimal) as monthstartcalc", "round(fdebitamount" + this.unit + ",famtdecimal) as debitamount", "round(fdebitamountrpt" + this.unit + ",frptamtdecimal) as debitamountcalc", "round(fcreditamount" + this.unit + ",famtdecimal) as creditamount", "round(fcreditamountrpt" + this.unit + ",frptamtdecimal) as creditamountcalc", "round((fbalance + fdebitamount - fcreditamount)" + this.unit + ",famtdecimal) as monthbalance", "round((fbalancerpt + fdebitamountrpt - fcreditamountrpt)" + this.unit + ",frptamtdecimal) as monthbalancecalc", "round(fyearbalance" + this.unit + ",famtdecimal) as yearstart", "round(fyearbalancerpt" + this.unit + ",frptamtdecimal) as yearstartcalc", "round(fyeardebitamount" + this.unit + ",famtdecimal) as yeardebit", "round(fyeardebitamountrpt" + this.unit + ",frptamtdecimal) as yeardebitcalc", "round(fyearcreditamount" + this.unit + ",famtdecimal) as yearcredit", "round(fyearcreditamountrpt" + this.unit + ",frptamtdecimal) as yearcreditcalc", "round((fyearbalance + fyeardebitamount - fyearcreditamount)" + this.unit + ",famtdecimal) as yearbalance", "round((fyearbalancerpt + fyeardebitamountrpt - fyearcreditamountrpt)" + this.unit + ",frptamtdecimal) as yearbalancecalc"});
        return ds.updateField("daystart", "case when sumlevel = 0 then daystart else null end").updateField("daydebitamount", "case when sumlevel = 0 then daydebitamount else null end").updateField("daycreditamount", "case when sumlevel = 0 then daycreditamount else null end").updateField("daybalance", "case when sumlevel = 0 then daybalance else null end").updateField("monthstart", "case when sumlevel = 0 then monthstart else null end").updateField("debitamount", "case when sumlevel = 0 then debitamount else null end").updateField("creditamount", "case when sumlevel = 0 then creditamount else null end").updateField("monthbalance", "case when sumlevel = 0 then monthbalance else null end").updateField("yearstart", "case when sumlevel = 0 then yearstart else null end").updateField("yeardebit", "case when sumlevel = 0 then yeardebit else null end").updateField("yearbalance", "case when sumlevel = 0 then yearbalance else null end");
    }

    @Override
    protected List<String> getGroupFields(CapitalSumParam param) {
        ArrayList<String> groupFields = new ArrayList<String>(16);
        if (TimeTypeEnum.BYPERIOD.getValue().intValue() == param.getTimeType()) {
            groupFields.add("fperiodname");
        }
        switch (param.getSelDimension()) {
            case 1: {
                groupFields.addAll(Arrays.asList("forgname", "ftype"));
                break;
            }
            case 2: {
                groupFields.addAll(Arrays.asList("forgname", "ftype", "fbankname"));
                break;
            }
            case 3: {
                groupFields.addAll(Arrays.asList("forgname", "ftype", "facctpurpose"));
                break;
            }
            case 4: {
                groupFields.addAll(Arrays.asList("forgname", "ftype", "fcurrencyname"));
                break;
            }
            case 5: {
                groupFields.addAll(Arrays.asList("forgname", "ftype", "frptbanktype"));
                break;
            }
            default: {
                groupFields.addAll(Arrays.asList("forgname", "ftype"));
            }
        }
        return groupFields;
    }

    @Override
    protected CapitalSumParam getCapitalSumParam(ReportQueryParam arg0) {
        CapitalSumParam param = CapitalSumListDataRpt.getCapitalSumParam((ReportQueryParam)arg0);
        log.info("{}getCapitalSumParam:{}.", (Object)"CapitalReportData:", (Object)arg0.getFilter().getString("showsubtotal"));
        if (param.getQueryOrgType() == null) {
            param.setQueryOrgType(QueryTypeEnum.ORG.getValue());
        }
        if (param.getPeriodType() != null && EmptyUtil.isNoEmpty((DynamicObjectCollection)param.getOrgs())) {
            QFilter[] qFilters = new QFilter[]{new QFilter("org", "in", param.getOrgs().stream().map(o -> o.getLong("id")).collect(Collectors.toList())), new QFilter("periodtype", "=", param.getPeriodType().getPkValue())};
            DynamicObjectCollection cmis = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"org.id", (QFilter[])qFilters);
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)cmis)) {
                List ids = cmis.stream().map(e -> e.getLong("org.id")).collect(Collectors.toList());
                DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                param.setOrgs(orgs);
            } else {
                param.setOrgs(new DynamicObjectCollection());
            }
        }
        return param;
    }
}

