/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.report.capitalreport.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class TotalRowService {
    private String totalSort_Field;
    private List<String> subsort_fields;
    private static final int iniSize = 16;
    private static final String SUMSORT_PREFIX = "sumsort_";
    private static final Log log = LogFactory.getLog(TotalRowService.class);

    public DataSet addTotalRowAndSort(List<String> groupFields, List<String> sumFields, DataSet ds, String totalGroupField, boolean showSubTotal) {
        log.info("addTotalRowAndSort_begin.");
        List<String> groupFiels_sumSort = this.addSumSortFields(groupFields);
        ds = this.dsAddSumSortFields(groupFields, ds);
        ds = this.doAddTotalRow(groupFiels_sumSort, sumFields, ds, totalGroupField, showSubTotal);
        return this.dsSort(groupFiels_sumSort, ds);
    }

    private DataSet dsSort(List<String> groupFields, DataSet ds) {
        log.info("sortDs_begin.");
        return ds.select(ds.getRowMeta().getFieldNames()).orderBy(this.getSortFields(groupFields).toArray(new String[0]));
    }

    private DataSet dsAddSumSortFields(List<String> groupFields, DataSet ds) {
        log.info("dsAddSumSortFields_begin.");
        ds = ds.addField("'0'", this.totalSort_Field);
        for (String groupField : groupFields) {
            String field = this.totalSort_Field.split(SUMSORT_PREFIX)[1];
            if (field.equals(groupField)) continue;
            String sumsortField = this.getSumSortField(groupField);
            ds = ds.addField(this.getSumSortValue(groupField), sumsortField);
        }
        return ds;
    }

    private List<String> addSumSortFields(List<String> groupFields) {
        ArrayList<String> returns = new ArrayList<String>(groupFields.size());
        this.subsort_fields = new ArrayList<String>(groupFields.size());
        for (String groupField : groupFields) {
            String sumsortField = this.getSumSortField(groupField);
            this.subsort_fields.add(sumsortField);
            returns.add(sumsortField);
            returns.add(groupField);
        }
        this.totalSort_Field = this.getSumSortField(groupFields.get(0));
        this.subsort_fields.remove(this.totalSort_Field);
        return returns;
    }

    private String getSumSortValue(String field) {
        return String.format("case when %1$s = null or %1$s = '' then '%2$s' else %1$s end", field, SUMSORT_PREFIX);
    }

    private String getSumSortField(String field) {
        return SUMSORT_PREFIX + field;
    }

    private DataSet doAddTotalRow(List<String> groupFields, List<String> sumFields, DataSet ds, String totalGroupField, boolean showSubTotal) {
        log.info("doAddTotalRow_begin_showSubTotal:{}.", (Object)(showSubTotal ? 1 : 0));
        DataSet returns = ds;
        if (groupFields == null || groupFields.size() == 0) {
            return ds;
        }
        if (sumFields == null || sumFields.size() == 0) {
            return ds;
        }
        int size = groupFields.size();
        String[] _groupFields = groupFields.toArray(new String[0]);
        for (int i = 0; i < size; ++i) {
            TotalRowEnum totalType;
            TotalRowEnum totalRowEnum = totalType = i == size - this.getSumPos(_groupFields) - 1 ? TotalRowEnum.TOTAL : TotalRowEnum.SUBTOTAL;
            if (!showSubTotal && TotalRowEnum.SUBTOTAL == totalType || _groupFields[size - i - 1].startsWith(SUMSORT_PREFIX)) continue;
            DataSet dsTotal = this.totalDataSet(ds, this.getSubGroupFields(i, _groupFields), sumFields, totalType, _groupFields[size - i - 1]);
            returns = returns.union(dsTotal);
            dsTotal.close();
        }
        DataSet dsTotal = this.totalDataSet(returns, Collections.singletonList(totalGroupField), sumFields, TotalRowEnum.SUM, _groupFields[this.getSumPos(_groupFields)]);
        returns = returns.union(dsTotal);
        dsTotal.close();
        return returns;
    }

    private DataSet totalDataSet(DataSet ds, List<String> groupFields, List<String> sumFields, TotalRowEnum type, String totalField) {
        Field[] fields;
        log.info("TotalRowService.totalDataSet.groupFields:{}---{}", (Object)type.getValue(), (Object)groupFields.toString());
        DataSet dsTemp = ds.copy();
        GroupbyDataSet dsTempG = dsTemp.filter(this.getTotalFilter(type)).groupBy(groupFields.toArray(new String[0]));
        dsTemp.close();
        for (String sumField : sumFields) {
            if (sumField.equalsIgnoreCase("frptamtdecimal") || sumField.equalsIgnoreCase("famtdecimal")) {
                dsTempG.avg(sumField);
                continue;
            }
            dsTempG.sum(sumField);
        }
        DataSet totalDs = dsTempG.finish();
        LinkedList<String> selectField = new LinkedList<String>();
        for (Field field : fields = ds.getRowMeta().getFields()) {
            String fieldName = field.getName();
            if (fieldName.equals(totalField)) {
                selectField.add(this.getTotalTip(type, totalField));
                continue;
            }
            if (fieldName.equals("sumlevel")) {
                selectField.add(this.getTotalLevel(type) + " as sumlevel");
                continue;
            }
            if (sumFields.contains(fieldName) || groupFields.contains(fieldName)) {
                selectField.add(field.getName());
                continue;
            }
            if (fieldName.equalsIgnoreCase(this.totalSort_Field)) {
                selectField.add(groupFields.contains(fieldName) ? fieldName : "NULL as " + fieldName);
                continue;
            }
            if (this.subsort_fields.contains(fieldName)) {
                selectField.add(groupFields.contains(fieldName) ? fieldName : "NULL as " + fieldName);
                continue;
            }
            selectField.add("NULL as " + fieldName);
        }
        log.info("TotalRowService.totalDataSet.selectField:{}", (Object)((Object)selectField).toString());
        return totalDs.select(String.join((CharSequence)",", selectField));
    }

    private int getSumPos(String[] _groupFields) {
        int size = _groupFields.length;
        for (int i = 0; i < size; ++i) {
            if (_groupFields[i].startsWith(SUMSORT_PREFIX)) continue;
            return i;
        }
        return 0;
    }

    private List<String> getSubGroupFields(int pos, String[] _groupFields) {
        ArrayList<String> returns = new ArrayList<String>(16);
        int size = _groupFields.length;
        for (int i = 0; i < size - pos; ++i) {
            returns.add(_groupFields[i]);
        }
        return returns;
    }

    private String getTotalFilter(TotalRowEnum type) {
        switch (type) {
            case SUBTOTAL: 
            case TOTAL: {
                return "sumlevel = 0";
            }
            case SUM: {
                return "sumlevel = 2";
            }
        }
        return "sumlevel = 0";
    }

    private int getTotalLevel(TotalRowEnum type) {
        switch (type) {
            case SUBTOTAL: {
                return 1;
            }
            case TOTAL: {
                return 2;
            }
            case SUM: {
                return 3;
            }
        }
        return 1;
    }

    private String getTotalTip(TotalRowEnum type, String field) {
        switch (type) {
            case SUBTOTAL: {
                return String.format(ResManager.loadKDString((String)"CONCAT(%1$s,'\u5c0f\u8ba1') as %2$s", (String)"TotalRowService_1", (String)"fi-cas-report", (Object[])new Object[0]), field, field);
            }
            case TOTAL: {
                return String.format(ResManager.loadKDString((String)"CONCAT(%1$s,'\u5408\u8ba1') as %2$s", (String)"TotalRowService_2", (String)"fi-cas-report", (Object[])new Object[0]), field, field);
            }
            case SUM: {
                return String.format(ResManager.loadKDString((String)"'\u603b\u8ba1' as %1$s", (String)"TotalRowService_3", (String)"fi-cas-report", (Object[])new Object[0]), field);
            }
        }
        return field;
    }

    private List<String> getSortFields(List<String> groupFiels) {
        LinkedList<String> returns = new LinkedList<String>();
        int size = groupFiels.size();
        for (int i = 0; i < size; ++i) {
            String field = groupFiels.get(i);
            if (this.totalSort_Field.equals(field)) {
                returns.add(field + " desc");
                continue;
            }
            returns.add(field.trim());
        }
        return returns;
    }

    public static enum TotalRowEnum {
        SUBTOTAL(1),
        TOTAL(2),
        SUM(3);

        private Integer value;

        private TotalRowEnum(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }
    }
}

