/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.AgentFillPropHelper;
import kd.fi.cas.business.opservice.factory.AgentPayBillFactory;
import kd.fi.cas.business.opservice.helper.AgentPayServiceHelper;
import kd.fi.cas.business.service.WriteBackServiceImpl;
import kd.fi.cas.business.writeback.AgentWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.FeePayerEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.RefundHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.AgentBillVirtualValidator;
import kd.fi.cas.validator.AgentCrossSubmitValidator;
import kd.fi.cas.validator.AgentPayBillSaveOrSubmitValidator;
import kd.fi.cas.validator.AgentPayBillSubmitValidator;
import kd.fi.cas.validator.AgentPayBillWriteValidator;
import kd.fi.cas.validator.AgentPayDiffEmptyValidator;
import kd.fi.cas.validator.OrgFinishinitValidator;
import kd.fi.cas.validator.PaymentDynamicValidator;
import kd.fi.cas.validator.agent.AgentAccountCashValidator;
import kd.fi.cas.validator.agent.AgentDcepSubmitValidator;
import kd.fi.cas.validator.agent.AgentRepayValidator;
import kd.fi.cas.validator.common.TxLockValidator;

public class AgentPaySubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("payee");
        lst.add("payeracctbank");
        lst.add("settletype");
        lst.add("delegorg");
        lst.add("sourcebilltype");
        lst.add("paymentchannel");
        lst.add("businesstype");
        lst.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_agentpaybill", (String)"entry"));
        lst.addAll(AgentPayServiceHelper.getSelector());
        lst.add("entry.e_encryptamount");
        lst.add("entry.e_refundamt");
        lst.add("entry.e_remainrefundamt");
        lst.add("entry.e_originalagententryid");
        lst.add("entry.seq");
        lst.add("totalrefundedamt");
        lst.add("totalremainrefundamt");
        lst.add("localrefundedamt");
        lst.add("localremainrefundamt");
        lst.add("payquotation");
        lst.add("exchangerate");
        lst.add("isrepay");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        RefundHelper.setSomeRefundAmtFields((DynamicObject[])e.getDataEntities(), (String)"cas_agentpaybill");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] agentPayBillDts;
        super.beginOperationTransaction(e);
        for (DynamicObject info : agentPayBillDts = e.getDataEntities()) {
            AgentPayBillFactory.getSaveService().process(info);
            if (!info.getBoolean("isdiffcur")) {
                DynamicObjectHelper.setValueId((DynamicObject)info, (String)"dpcurrency", (Object)info.get("currency"));
                info.set("dpexchangerate", info.get("exchangerate"));
                info.set("dpamt", info.get("payamount"));
                info.set("dplocalamt", info.get("localamt"));
                info.set("lossamt", (Object)BigDecimal.ZERO);
            }
            if (!FeePayerEnum.REC.getValue().equals(info.getString("feepayer"))) {
                DynamicObjectHelper.setValueIfAbsent((DynamicObject)info, (String)"feeactbank", (Object)info.get("payeracctbank"));
                DynamicObjectHelper.setValueIdIfAbsent((DynamicObject)info, (String)"feecurrency", (Object)info.get("currency"));
            }
            if (BaseDataHelper.isSettleTypeCash((DynamicObject)info.getDynamicObject("settletype"))) {
                info.set("feeactbank", null);
            }
            String billStatus = info.getString("billstatus");
            boolean isDiffCur = info.getBoolean("isdiffcur");
            BigDecimal payAmount = info.getBigDecimal("dpamt");
            BigDecimal fee = info.getBigDecimal("fee");
            BigDecimal matchAmount = info.getBigDecimal("matchamount");
            if ("D".equalsIgnoreCase(billStatus)) {
                if (isDiffCur) {
                    info.set("unmatchamount", (Object)payAmount.add(fee).subtract(matchAmount));
                } else {
                    BigDecimal actPayAmount = info.getBigDecimal("actpayamount");
                    info.set("unmatchamount", (Object)actPayAmount.subtract(matchAmount));
                }
            } else {
                info.set("unmatchamount", (Object)payAmount.subtract(matchAmount));
            }
            DynamicObjectCollection entry = info.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                BigDecimal amount = row.getBigDecimal("e_amount");
                if (BigDecimal.ZERO.compareTo(amount) == 0) continue;
                row.set("entryunmatchamount", (Object)amount);
            }
            AgentFillPropHelper.setDefaultProviceCity((DynamicObject[])e.getDataEntities());
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new AgentPayDiffEmptyValidator());
        e.addValidator((AbstractValidator)new PaymentDynamicValidator());
        e.addValidator((AbstractValidator)new AgentCrossSubmitValidator());
        e.addValidator((AbstractValidator)new AgentPayBillSubmitValidator());
        e.addValidator((AbstractValidator)new AgentBillVirtualValidator());
        e.getValidators().add(new OrgFinishinitValidator());
        e.getValidators().add(new TxLockValidator());
        e.addValidator((AbstractValidator)new AgentPayBillSaveOrSubmitValidator());
        e.addValidator((AbstractValidator)new AgentPayBillWriteValidator(WriteBackOperateEnum.SUBMITVALIDATE));
        e.addValidator((AbstractValidator)new AgentDcepSubmitValidator());
        e.addValidator((AbstractValidator)new AgentAccountCashValidator());
        e.addValidator((AbstractValidator)new AgentRepayValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(10);
        for (DynamicObject info : e.getDataEntities()) {
            DynamicObjectCollection entry;
            String sourceBillType = info.getString("sourcebilltype");
            if ("fr_glreim_paybill".equals(sourceBillType)) {
                WriteBackTaskHelper.addRealtimeTask((DynamicObject)info, (String)sourceBillType, (WriteBackOperateEnum)WriteBackOperateEnum.SUBMIT, AgentWriteBackConsumer.class);
            } else {
                bills.add(info);
            }
            if ("repay".equals(sourceBillType) || (entry = info.getDynamicObjectCollection("entry")) == null || entry.size() <= 0) continue;
            for (DynamicObject row : entry) {
                long eOriginalAgentEntryId = row.getLong("e_originalagententryid");
                if (!EmptyUtil.isEmpty((Long)eOriginalAgentEntryId)) continue;
                row.set("e_originalagententryid", row.get("id"));
            }
        }
        SaveServiceHelper.update((DynamicObject[])e.getDataEntities());
        WriteBackServiceImpl.getInstance().batchWrite(bills, WriteBackOperateEnum.SUBMIT, AgentWriteBackConsumer.class);
    }
}

