/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.business.helper.PaymentFillPropHelper;
import kd.fi.cas.business.helper.VoucherCheckHepler;
import kd.fi.cas.business.journal.IBookJournalBuilder;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.journal.PaymentBillBookJournalBuilder;
import kd.fi.cas.business.opservice.helper.PaymentSaleServiceHelper;
import kd.fi.cas.business.opservice.helper.PaymentServiceHelper;
import kd.fi.cas.business.paysche.bean.DraftAmountLockSubInfo;
import kd.fi.cas.business.paysche.bean.DraftLockInfo;
import kd.fi.cas.business.paysche.bean.DraftTradeInfo;
import kd.fi.cas.business.paysche.serive.DraftLockServiceHelper;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.LogBizTypeEnum;
import kd.fi.cas.enums.LogOperateTypeEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.enums.SysParamCs1046Enum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasBankJournalHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.MultiBaseDataHelper;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.RefundHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.info.WriteBackTaskInfo;
import kd.fi.cas.opplugin.overdraft.PaymentPayJournalServiceValidator;
import kd.fi.cas.opplugin.overdraft.PaymentPayPreValidator;
import kd.fi.cas.opplugin.overdraft.PaymentPayValidator;
import kd.fi.cas.opplugin.overdraft.PaymentPrePayForDraftValidator;
import kd.fi.cas.payment.PaymentPayHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.DraftBillUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.PayBillWriteValidator;
import kd.fi.cas.validator.PaymentBillIsFreezeValidator;
import kd.fi.cas.validator.paymentbill.PaymentLCOpenValidator;
import org.apache.commons.lang3.StringUtils;

public class PaymentPayOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PaymentPayOp.class);
    private Set<String> succLockSet = new HashSet<String>();
    private Set<Long> updateBillLogIdSet = new HashSet<Long>();
    private JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();
    private DraftLockServiceHelper draftLockServiceHelper;
    private Set<Long> updateEndorsedIdSet = new HashSet<Long>();
    private List<Long> batchRecIdList = new ArrayList<Long>(16);
    private Long[] pkIds;
    private Set<Long> orgIds;

    public PaymentPayOp() {
        this.draftLockServiceHelper = new DraftLockServiceHelper();
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.add("billno");
        list.add("id");
        list.add("billstatus");
        list.add("bizdate");
        list.add("billtype");
        list.add("paymenttype");
        list.add("payeetype");
        list.add("description");
        list.add("issingle");
        list.add("org");
        list.add("payeracctcash");
        list.add("payeracctbank");
        list.add("payerbank");
        list.add("payee");
        list.add("payeeformid");
        list.add("payeename");
        list.add("payeeaccformid");
        list.add("payeeacctbank");
        list.add("payeebanknum");
        list.add("payeebank");
        list.add("payeebankname");
        list.add("actpayamt");
        list.add("currency");
        list.add("exchangerate");
        list.add("localamt");
        list.add("settletype");
        list.add("settletnumber");
        list.add("fundflowitem");
        list.add("usage");
        list.add("expectdate");
        list.add("reccountry");
        list.add("recprovince");
        list.add("reccity");
        list.add("recaccbankname");
        list.add("recbanknumber");
        list.add("sourcetype");
        list.add("sourcebilltype");
        list.add("sourcebillid");
        list.add("cashier");
        list.add("paydate");
        list.add("bankcheckflag");
        list.add("bankcheckflag_tag");
        list.add("entrance");
        list.add("entrustorg");
        list.add("applyorg");
        list.add("e_actamt");
        list.add("e_localamt");
        list.add("e_fundflowitem");
        list.add("e_remark");
        list.add("e_payableAmt");
        list.add("e_payablelocamt");
        list.add("e_discountamt");
        list.add("e_discountlocamt");
        list.add("e_sourcebillentryid");
        list.add("e_unsettledamt");
        list.add("e_settledamt");
        list.add("e_unsettledlocalamt");
        list.add("e_unlockamt");
        list.add("e_material");
        list.add("e_expenseitem");
        list.add("e_corebillno");
        list.add("e_corebillentryseq");
        list.add("e_sourcebillid");
        list.add("e_corebillid");
        list.add("e_corebillentryid");
        list.add("e_corebilltype");
        list.add("conbillid");
        list.add("conbillentryid");
        list.add("settleorg");
        list.add("paymentchannel");
        list.add("payeetype");
        list.add("payee");
        list.add("isvoucher");
        list.add("isdiffcur");
        list.add("dpamt");
        list.add("agreedrate");
        list.add("fee");
        list.add("dpcurrency");
        list.add("iscrosspay");
        list.add("dplocalamt");
        list.add("dpexchangerate");
        list.add("feecurrency");
        list.add("feeactbank");
        list.add("lossamt");
        list.add("draftbill");
        list.add("exratetable");
        list.add("exratedate");
        list.add("inneraccount");
        list.add("acttradedate");
        list.add("feepayer");
        list.add("createtime");
        list.add("payeeacctcash");
        list.add("openorg");
        list.add("totalpayamt");
        list.add("payquotation");
        list.add("dppayquotation");
        list.add("agreedquotation");
        list.add("settletype");
        list.add(String.join((CharSequence)".", "settletype", "settlementtype"));
        list.add("settletnumber");
        list.add("singlestream");
        list.add("basecurrency");
        list.add("paymentidentify");
        list.add("feepaydate");
        list.add("feepay");
        list.add("matchamountpay");
        list.add("unmatchamountpay");
        list.add("unmatchamountrec");
        list.add("matchamountrec");
        list.add("matchflag");
        list.add("bizdate");
        list.add("auditdate");
        list.add("sourcebilltype");
        list.add("entry");
        list.add(String.join((CharSequence)".", "entry", "e_sourcebillid"));
        list.add(String.join((CharSequence)".", "cas_draftinfo", "draftbillinfo"));
        list.add(String.join((CharSequence)".", "cas_draftinfo", "transamount"));
        list.add(String.join((CharSequence)".", "cas_draftinfo", "draftbilllogid"));
        list.add(String.join((CharSequence)".", "entry", "e_scheid"));
        list.add(String.join((CharSequence)".", "cas_draftinfo", "srcbillindex"));
        list.add(String.join((CharSequence)".", "cas_draftinfo", "paybillcurrency"));
        list.add("entry.e_dpamt");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        this.getOption().getVariables().put("operateKey", ((AbstractValidator)e.getValidators().get(0)).getOperateKey());
        this.getOption().getVariables().put("operateCNName", ((AbstractValidator)e.getValidators().get(0)).getOperationName());
        e.addValidator((AbstractValidator)new PaymentPrePayForDraftValidator());
        e.addValidator((AbstractValidator)new PaymentPayPreValidator());
        e.addValidator((AbstractValidator)new PaymentLCOpenValidator());
        e.addValidator((AbstractValidator)new PaymentBillIsFreezeValidator());
        e.addValidator((AbstractValidator)new PaymentPayJournalServiceValidator(this.journalServiceAdapter));
        if (!"true".equals(this.getOption().getVariables().get("byfca"))) {
            e.addValidator((AbstractValidator)new PaymentPayValidator());
        }
        e.addValidator((AbstractValidator)new PayBillWriteValidator(WriteBackOperateEnum.PAYVALIDATE));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        Map<String, String> mapOfIdAndbillno = ((Stream)Arrays.stream(e.getDataEntities()).parallel()).filter(Objects::nonNull).collect(Collectors.toMap(item -> "pay" + item.getString("id"), item -> item.getString("billno")));
        Set<String> idSet = mapOfIdAndbillno.keySet();
        StringJoiner errorMsg = new StringJoiner(";");
        ArrayList<String> requestIds = new ArrayList<String>();
        ArrayList<String> requestFailIds = new ArrayList<String>();
        String billType = "paylockcas_paybill";
        try {
            logger.info("billno is that:" + SerializationUtils.toJsonString(mapOfIdAndbillno.values()) + " and billType is: " + billType + " and id is:" + SerializationUtils.toJsonString(idSet));
            ArrayList<String> billids = new ArrayList<String>(idSet);
            Map lockResultMap = MutexServiceHelper.batchRequest(billids, (String)"cas_paybill", (String)billType);
            for (Map.Entry next : lockResultMap.entrySet()) {
                String key = (String)next.getKey();
                if (Boolean.TRUE.equals(next.getValue())) {
                    requestIds.add(key);
                    continue;
                }
                requestFailIds.add(key);
            }
            if (!requestFailIds.isEmpty()) {
                for (String requestFailId : requestFailIds) {
                    String billno = mapOfIdAndbillno.get(requestFailId);
                    errorMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReceivErrorCode_25", (String)"fi-cas-business", (Object[])new Object[0]), billno));
                }
            } else {
                this.succLockSet.addAll(requestIds);
            }
        }
        catch (Exception e1) {
            logger.error("to get lock Exception is:", (Throwable)e1);
            errorMsg.add(ResManager.loadKDString((String)"\u5355\u636e\u52a0\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReceivErrorCode_33", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        if (errorMsg.length() > 0) {
            logger.info("is pay eror is:" + errorMsg.toString());
            throw new KDBizException(errorMsg.toString());
        }
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        this.releaseBizLock();
    }

    private void releaseBizLock() {
        logger.info("pay onReturnOperation-succLockSet:{}", (Object)this.succLockSet.size());
        if (CollectionUtils.isEmpty(this.succLockSet)) {
            return;
        }
        try {
            logger.info("release paylock\uff1a" + JSON.toJSONString(this.succLockSet));
            String billType = "paylockcas_paybill";
            ArrayList<String> listRelease = new ArrayList<String>(this.succLockSet);
            Map releaseResultMap = MutexServiceHelper.batchRelease(listRelease, (String)"cas_paybill", (String)billType);
            logger.info("releaseResultMap is:", (Object)SerializationUtils.toJsonString((Object)releaseResultMap));
        }
        catch (Exception e1) {
            logger.error("pay eror is:", (Throwable)e1);
            throw new KDBizException(ResManager.loadKDString((String)"\u786e\u8ba4\u4ed8\u6b3e\u5931\u8d25\u3002", (String)"ReceivErrorCode_31", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        finally {
            this.succLockSet.clear();
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        logger.info("beginOperationTransaction");
        super.beginOperationTransaction(e);
        Map opParams = this.getOption().getVariables();
        DynamicObject[] payBills = e.getDataEntities();
        this.pkIds = (Long[])((Stream)Arrays.stream(payBills).parallel()).map(d -> d.getLong("id")).toArray(Long[]::new);
        Object batchselect = opParams.get("batchselect");
        if (EmptyUtil.isNoEmpty(batchselect)) {
            List willPayCasBillIdSet;
            this.batchRecIdList = JSON.parseArray((String)batchselect.toString(), Long.class);
            if (EmptyUtil.isNoEmpty(this.batchRecIdList) && EmptyUtil.isNoEmpty((Object[])this.pkIds) && !(willPayCasBillIdSet = Arrays.stream(this.pkIds).collect(Collectors.toList())).containsAll(this.batchRecIdList)) {
                String batchStr = ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u6279\u91cf\u9009\u7968\u4ed8\u6b3e\u5931\u8d25\u3002", (String)"ReceivErrorCode_36", (String)"fi-cas-business", (Object[])new Object[0]);
                ValidateResultCollection validateResults = this.getOperationResult().getValidateResult();
                String errorMsg = DraftHelper.getValidateMsg((String)batchStr, (ValidateResultCollection)validateResults);
                throw new KDBizException(errorMsg);
            }
        }
        Object opDraftIds = opParams.get("draftids");
        List draftIds = new ArrayList(16);
        DynamicObject[] payDraftF7s = null;
        Map<Object, Object> draftBillIdAndTradeMap = new HashMap(8);
        if (opDraftIds != null) {
            draftIds = JSON.parseArray((String)opDraftIds.toString(), Long.class);
            draftBillIdAndTradeMap = this.queryDraftTradeBills(draftIds);
            if (EmptyUtil.isNoEmpty(draftBillIdAndTradeMap) && draftBillIdAndTradeMap.size() > 0) {
                this.updateEndorsedIdSet = draftBillIdAndTradeMap.keySet();
            }
            payDraftF7s = this.queryPayRecDraftF7(draftIds);
        }
        boolean isFromCdm = opParams.containsKey("draftbillno");
        boolean isEndorse = opParams.containsKey("endorse");
        Object draftBillId = opParams.get("draftbillno");
        DynamicObject draftBill = null;
        if (isFromCdm && !isEndorse) {
            draftBill = BusinessDataServiceHelper.loadSingle(draftBillId, (String)"cdm_draftbillf7");
        }
        DynamicObject[] sourceBills = this.querySourceBills(this.pkIds);
        this.orgIds = ((Stream)Arrays.stream(payBills).parallel()).filter(d -> CasHelper.isNotEmpty((Object)d.getDynamicObject("org")) && CasHelper.isNotEmpty((Object)d.getDynamicObject("org").getLong("id"))).map(d -> d.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
        Map pushMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList<Long>(this.orgIds), (String)"cs088");
        if (CasHelper.isNotEmpty(draftIds)) {
            this.batchLockDraftBill(payBills, draftIds, payDraftF7s, draftBillIdAndTradeMap);
        }
        try {
            this.batchPayProcess(sourceBills, draftBill, true);
            this.batchPayProcess(payBills, draftBill, false);
            this.batchPushAp(payBills, pushMap);
        }
        catch (Exception exception) {
            logger.error("\u786e\u8ba4\u4ed8\u6b3e\u5904\u7406\u5931\u8d25", (Object)e);
            if (CasHelper.isNotEmpty(draftIds)) {
                DynamicObject[] draftTradeBills = draftBillIdAndTradeMap.values().toArray(new DynamicObject[0]);
                this.batchDraftBillRollBack(payBills, draftIds, draftTradeBills);
            }
            throw exception;
        }
        DynamicObject[] dbPaybills = BusinessDataServiceHelper.load((Object[])this.pkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_paybill"));
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(dbPaybills.length);
        for (DynamicObject paybill : dbPaybills) {
            if (!"cas_payapplybill".equals(paybill.getString("sourcebilltype")) && !PayBillHepler.isLCSettlement((DynamicObject)paybill)) continue;
            list.add(paybill);
        }
        PayBillHepler.payApplyBillWriteBackArrival(list, (WriteBackOperateEnum)WriteBackOperateEnum.PAY, PaymentDisposeConsumer.class);
        String creditNo = (String)opParams.get("lcBillNo");
        String selectLcNo = (String)opParams.get("paySelectLcNo");
        boolean bizCondition = EmptyUtil.isNotEmpty((String)creditNo) || EmptyUtil.isNotEmpty((String)selectLcNo);
        PayBillHepler.writeBackLetterCredit((String)"pay", (boolean)bizCondition, (OperateOption)this.getOption(), (DynamicObject[])dbPaybills);
    }

    private void batchPayProcess(DynamicObject[] paybills, DynamicObject draftBill, boolean isEntrust) {
        if (CasHelper.isEmpty((DynamicObject[])paybills)) {
            logger.info("=======deal with a batch of draft bill, but pay bills is null");
            return;
        }
        Map params = this.getOption().getVariables();
        String cs1046 = params.get("cs1046") != null ? (String)params.get("cs1046") : "";
        String agreeRateStr = (String)params.get("agreedrate");
        String dpAmtStr = (String)params.get("dpamt");
        String feeStr = (String)params.get("fee");
        String singleStreamStr = (String)params.get("singlestream");
        String feeactbankStr = (String)params.get("feeactbank");
        String feecurrencyStr = (String)params.get("feecurrency");
        String feepaydateStr = (String)params.get("feepaydate");
        String dpchgrate = (String)params.get("dpexchangerate");
        Boolean updateBool = false;
        if (!isEntrust) {
            if (cs1046.contains(SysParamCs1046Enum.FOREIGN.getValue())) {
                this.exChgRatePay(paybills, dpchgrate);
                updateBool = true;
            }
            if (cs1046.contains(SysParamCs1046Enum.DIFF.getValue()) && CasHelper.isNotEmpty((Object)agreeRateStr)) {
                this.diffCurPay(paybills, agreeRateStr, dpAmtStr, feeStr);
                updateBool = true;
            }
            if (cs1046.contains(SysParamCs1046Enum.FEE.getValue())) {
                this.payFeePay(paybills, singleStreamStr, feeStr, feeactbankStr, feecurrencyStr, feepaydateStr);
                updateBool = true;
            }
        }
        this.batchUpdateValue(paybills, draftBill, isEntrust);
        ArrayList<WriteBackTaskInfo> taskInfos = new ArrayList<WriteBackTaskInfo>(paybills.length);
        for (DynamicObject paybill : paybills) {
            DynamicObject[] sourcebilltype = paybill.getString("sourcebilltype");
            if (CasHelper.isNotEmpty((Object)sourcebilltype)) {
                WriteBackTaskInfo taskInfo = new WriteBackTaskInfo();
                taskInfo.setBillId((Long)paybill.getPkValue());
                taskInfo.setDataEntity(paybill.getDataEntityType().getName());
                taskInfo.setSourceEntity((String)sourcebilltype);
                taskInfos.add(taskInfo);
            }
            WriteBackTaskInfo taskInfo2Ap = new WriteBackTaskInfo();
            taskInfo2Ap.setBillId((Long)paybill.getPkValue());
            taskInfo2Ap.setDataEntity(paybill.getDataEntityType().getName());
            taskInfo2Ap.setSourceEntity("ap_settle");
            taskInfos.add(taskInfo2Ap);
        }
        WriteBackTaskHelper.batchAddRealtimeTaskList(taskInfos, (WriteBackOperateEnum)WriteBackOperateEnum.PAY, PaymentDisposeConsumer.class);
        PaymentServiceHelper.genReceivingBill((DynamicObject[])paybills);
        if (updateBool.booleanValue()) {
            ArrayList<DynamicObject> bizBills = new ArrayList<DynamicObject>(10);
            boolean isFromCdm = this.getOption().getVariables().containsKey("draftbillno");
            boolean cdmBook = this.getOption().getVariables().containsKey("cdmbook");
            HashSet<Long> ids = new HashSet<Long>(paybills.length);
            for (DynamicObject paybill : paybills) {
                boolean isNeedBook;
                boolean isPromissory;
                if ("bei".equals(paybill.getString("paymentchannel")) && PaymentBillPluginHelper.paymentIdentify((DynamicObject)paybill)) continue;
                DynamicObject settleType = paybill.getDynamicObject("settletype");
                boolean bl = isPromissory = settleType != null && SettleMentTypeEnum.PROMISSORY.getValue().equals(settleType.getString("settlementtype"));
                if (!isFromCdm && isPromissory) continue;
                boolean bl2 = isNeedBook = CasHelper.isNotEmpty((Object)paybill.getBigDecimal("actpayamt")) && CasHelper.isEmpty((Object)paybill.get("entrustorg")) && (!isFromCdm || cdmBook);
                if (!isNeedBook || !PayBillHepler.isNeedBookJournal((DynamicObject)paybill)) continue;
                bizBills.add(paybill);
                ids.add(paybill.getLong("id"));
            }
            JournalServiceAdapter journalServiceAdapter2 = new JournalServiceAdapter();
            HashMap errorResult = new HashMap();
            PaymentBillBookJournalBuilder builder = new PaymentBillBookJournalBuilder();
            builder.setIsValidata(Boolean.TRUE);
            journalServiceAdapter2.validateBooks((IBookJournalBuilder)builder, bizBills, errorResult);
            journalServiceAdapter2.bookBatch(ids);
        } else {
            String bizFinishDate = this.operateOption.getVariableValue("bizFinishDate", "");
            boolean isSpot = EmptyUtil.isNoEmpty((String)bizFinishDate) && DateUtils.isSameDay((Date)DateUtils.stringToDate((String)bizFinishDate, (String)"yyyy-MM-dd"), (Date)DateUtils.getCurrentDate());
            Set ids = Arrays.stream(paybills).filter(s -> {
                boolean book = CasBankJournalHelper.bookByBizBillSettleType((DynamicObject)s, (boolean)isSpot);
                return book && EmptyUtil.isNoEmpty((BigDecimal)s.getBigDecimal("actpayamt"));
            }).map(e -> e.getLong("id")).collect(Collectors.toSet());
            if (EmptyUtil.isNoEmpty(ids)) {
                this.journalServiceAdapter.bookBatch(ids);
            }
        }
    }

    private void batchPushAp(DynamicObject[] paybills, Map<String, Object> pushMap) {
        ArrayList<DynamicObject> pushBills = new ArrayList<DynamicObject>();
        for (DynamicObject paybill : paybills) {
            boolean isPush;
            long sourceId = paybill.getLong("sourcebillid");
            String orgId = paybill.getDynamicObject("org").getString("id");
            DynamicObject applyOrg = paybill.getDynamicObject("applyorg");
            boolean bl = isPush = !EmptyUtil.isEmpty((String)orgId) && (Boolean)pushMap.get(orgId) != false;
            if (!CasHelper.isNotEmpty((Object)sourceId) || !isPush || !"cas_paybill".equals(paybill.get("sourcebilltype")) || !CasHelper.isNotEmpty((Object)applyOrg)) continue;
            pushBills.add(paybill);
        }
        if (pushBills.size() > 0) {
            OperateServiceHelper.execOperate((String)"paypusharandsave", (String)"cas_paybill", (DynamicObject[])pushBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] feePayBills;
        logger.info("afterExecuteOperationTransaction");
        DynamicObject[] dbPaybills = BusinessDataServiceHelper.load((Object[])this.pkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_paybill"));
        Object[] sourceBillIds = (Long[])((Stream)Arrays.stream(dbPaybills).parallel()).filter(paybill -> BillStatusEnum.PAY.getValue().equals(paybill.getString("billstatus")) && !CasHelper.isEmpty((Object)paybill.get("applyorg")) && "cas_paybill".equals(paybill.get("sourcebilltype")) && !CasHelper.isEmpty((Object)paybill.get("sourcebillid"))).map(paybill -> paybill.get("sourcebillid")).toArray(Long[]::new);
        DynamicObject[] dbSrcPayBills = null;
        if (CasHelper.isNotEmpty((Object)sourceBillIds)) {
            dbSrcPayBills = BusinessDataServiceHelper.load((Object[])sourceBillIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_paybill"));
        }
        int arrayLength = 0;
        arrayLength = dbSrcPayBills == null || dbSrcPayBills.length == 0 ? dbPaybills.length : dbPaybills.length + dbSrcPayBills.length;
        Object[] handleBills = new DynamicObject[arrayLength];
        System.arraycopy(dbPaybills, 0, handleBills, 0, dbPaybills.length);
        if (dbSrcPayBills != null && dbSrcPayBills.length > 0) {
            System.arraycopy(dbSrcPayBills, 0, handleBills, dbPaybills.length, dbSrcPayBills.length);
        }
        try {
            QFilter[] filter;
            DynamicObject[] rules;
            if (EmptyUtil.isNoEmpty((Object[])handleBills) && (rules = BusinessDataServiceHelper.load((String)"botp_crlist", (String)"id,defrule", (QFilter[])(filter = new QFilter[]{new QFilter("sourceentitynumber", "=", (Object)handleBills[0].getDataEntityType().getName()), new QFilter("targetentitynumber", "=", (Object)"pur_pay"), new QFilter("enabled", "=", (Object)"1")}))).length > 0) {
                OperateServiceHelper.execOperate((String)"pregenpurpay", (String)"cas_paybill", (DynamicObject[])handleBills, (OperateOption)OperateOption.create());
            }
        }
        catch (Exception ex) {
            logger.error("paymentpayop pregenpurpay error:{}", (Object)ex.getMessage());
        }
        ArrayList<DynamicObject> batchCheckBills = new ArrayList<DynamicObject>();
        Boolean singleStreamBool = false;
        for (DynamicObject paybill2 : dbPaybills) {
            if (paybill2.getBoolean("singlestream")) {
                singleStreamBool = true;
            }
            if (!BillStatusEnum.PAY.getValue().equals(paybill2.getString("billstatus"))) continue;
            batchCheckBills.add(paybill2);
        }
        VoucherCheckHepler.batchDoVoucherCheck(batchCheckBills);
        Map params = this.getOption().getVariables();
        Boolean generatepay = Boolean.parseBoolean((String)params.get("generatepay"));
        if ((generatepay.booleanValue() || singleStreamBool.booleanValue()) && (feePayBills = (DynamicObject[])((Stream)Arrays.stream((Object[])dbPaybills.clone()).parallel()).filter(paybill -> paybill.getBoolean("singlestream") && paybill.getBigDecimal("fee").compareTo(BigDecimal.ZERO) != 0 && !paybill.getBoolean("feepay")).toArray(DynamicObject[]::new)).length > 0) {
            OperateOption create = OperateOption.create();
            create.setVariableValue("feepaysave", "1");
            OperateServiceHelper.execOperate((String)"pushfeepay", (String)"cas_paybill", (DynamicObject[])feePayBills, (OperateOption)create);
        }
        OperateServiceHelper.execOperate((String)"synctrigger", (String)"cas_paybill", (DynamicObject[])e.getDataEntities(), (OperateOption)OperateOption.create());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        block38: {
            super.endOperationTransaction(e);
            Map opParams = this.getOption().getVariables();
            boolean isfrompaydraft = opParams.containsKey("isfrompaydraft");
            PaymentSaleServiceHelper.convertPur((DynamicObject[])e.getDataEntities(), (boolean)true);
            String batchStr = DBServiceHelper.genStringId();
            if (EmptyUtil.isNoEmpty(this.updateBillLogIdSet) || EmptyUtil.isNoEmpty(this.updateEndorsedIdSet)) {
                try (TXHandle tx = TX.requiresNew();){
                    for (DynamicObject payBill : e.getDataEntities()) {
                        String billTypePay;
                        Set needUpdatePayBillDySet;
                        Set paydraftBillSet;
                        String billType;
                        Set needUpdateDySet;
                        DynamicObject[] draftBillLogs;
                        Set draftIdSet;
                        if (isfrompaydraft) continue;
                        long payBillId = payBill.getLong("id");
                        HashSet<Object> allrecIdSet = new HashSet<Object>(8);
                        if (EmptyUtil.isNoEmpty(this.updateBillLogIdSet) && EmptyUtil.isNoEmpty(draftIdSet = Arrays.stream(draftBillLogs = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,dealamount,lockedamount,availableamount,draftid,sourcebilltype,bizbillno,sourcebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", this.updateBillLogIdSet)})).map(x -> x.getLong("draftid")).collect(Collectors.toSet())) && draftIdSet.size() > 0) {
                            allrecIdSet.addAll(draftIdSet);
                        }
                        if (EmptyUtil.isNoEmpty(this.updateEndorsedIdSet) && this.updateEndorsedIdSet.size() > 0) {
                            allrecIdSet.addAll(this.updateEndorsedIdSet);
                        }
                        String draftBatchStr = "";
                        boolean isBatchSelect = this.batchRecIdList.contains(payBillId);
                        if (isBatchSelect) {
                            draftBatchStr = batchStr;
                        }
                        if (EmptyUtil.isNoEmpty((Object)(needUpdateDySet = DraftHelper.updateDraftCasEntry((DynamicObject)payBill, allrecIdSet, (String)(billType = "cdm_receivablebill"), (String)"add", (String)draftBatchStr))) && needUpdateDySet.size() > 0) {
                            SaveServiceHelper.save((DynamicObject[])needUpdateDySet.toArray(new DynamicObject[0]));
                        }
                        if (!EmptyUtil.isNoEmpty(paydraftBillSet = payBill.getDynamicObjectCollection("draftbill").stream().filter(o -> "paybill".equals(o.getDynamicObject("fbasedataid").getString("rptype"))).map(x -> x.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet())) || !EmptyUtil.isNoEmpty((Object)(needUpdatePayBillDySet = DraftHelper.updateDraftCasEntry((DynamicObject)payBill, paydraftBillSet, (String)(billTypePay = "cdm_payablebill"), (String)"add", (String)draftBatchStr)))) continue;
                        SaveServiceHelper.save((DynamicObject[])needUpdatePayBillDySet.toArray(new DynamicObject[0]));
                    }
                    break block38;
                }
                catch (Exception error) {
                    logger.error("update bill log has error", (Throwable)error);
                    throw error;
                }
            }
            Map<Long, Set<Long>> needUpdatePayDraftBillMap = this.updateCompleteDraftBill(e.getDataEntities());
            if (EmptyUtil.isNoEmpty(needUpdatePayDraftBillMap) && needUpdatePayDraftBillMap.size() > 0 && !isfrompaydraft) {
                HashSet needUpdateDraftSetAll = new HashSet(8);
                for (DynamicObject payBill : e.getDataEntities()) {
                    Set needUpdateDySet;
                    long payBillId = payBill.getLong("id");
                    Set<Long> draftBillSet = needUpdatePayDraftBillMap.get(payBillId);
                    if (!EmptyUtil.isNoEmpty(draftBillSet) || draftBillSet.size() <= 0) continue;
                    String billType = "cdm_payablebill";
                    String draftBatchStr = "";
                    boolean isBatchSelect = this.batchRecIdList.contains(payBillId);
                    if (isBatchSelect) {
                        draftBatchStr = batchStr;
                    }
                    if (!EmptyUtil.isNoEmpty((Object)(needUpdateDySet = DraftHelper.updateDraftCasEntry((DynamicObject)payBill, draftBillSet, (String)billType, (String)"add", (String)draftBatchStr)))) continue;
                    needUpdateDraftSetAll.addAll(needUpdateDySet);
                }
                if (EmptyUtil.isNoEmpty(needUpdateDraftSetAll)) {
                    try (TXHandle tx = TX.requiresNew();){
                        SaveServiceHelper.save((DynamicObject[])needUpdateDraftSetAll.toArray(new DynamicObject[0]));
                    }
                    catch (Exception error) {
                        logger.error("update bill cas entry has error", (Throwable)error);
                    }
                }
            }
        }
    }

    private Map<Long, Set<Long>> updateCompleteDraftBill(DynamicObject[] payBills) {
        logger.info("deal billlog start");
        ArrayList<DraftLockInfo> releaseDraftAmountLockInfos = new ArrayList<DraftLockInfo>(8);
        Map params = this.getOption().getVariables();
        boolean isFromDraw = StringUtils.isNotEmpty((CharSequence)((CharSequence)params.get("fromdraw")));
        HashMap<Long, Set<Long>> needUpdatePayDraftBillMap = new HashMap<Long, Set<Long>>(8);
        for (DynamicObject payBill : payBills) {
            DynamicObject settleType = payBill.getDynamicObject("settletype");
            long payBillId = payBill.getLong("id");
            boolean isDraftSettleType = BaseDataHelper.isSettleTypeDraft((DynamicObject)settleType);
            boolean checkDraft = BaseDataHelper.isSettleTypeCheck((DynamicObject)settleType);
            String sourcebilltype = payBill.getString("sourcebilltype");
            boolean isFromcdm = "cdm_drafttradebill".equals(sourcebilltype);
            if (!isDraftSettleType && !checkDraft || isFromcdm) {
                logger.info("is not draftType or is from cdm" + payBill.getString("billno"));
                continue;
            }
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            draftLockInfo.setSourceBillType(payBill.getDataEntityType().getName());
            draftLockInfo.setBizBillNo(payBill.getString("billno"));
            draftLockInfo.setSourceBillId(Long.valueOf(payBill.getLong("id")));
            Set<Object> needReleaseDraftIds = new HashSet(8);
            HashMap draftIdDealAmountMap = new HashMap(8);
            HashMap draftIdLogIdMap = new HashMap(8);
            DynamicObjectCollection draftInfoEntrys = payBill.getDynamicObjectCollection("cas_draftinfo");
            if (isFromDraw) {
                boolean isGroupPay;
                if (EmptyUtil.isEmpty((DynamicObjectCollection)draftInfoEntrys)) {
                    HashSet needLockDraftIds = new HashSet();
                    DynamicObjectCollection dynamicObjectCollection = payBill.getDynamicObjectCollection("draftbill");
                    boolean bl = isGroupPay = dynamicObjectCollection.stream().filter(o -> o.getDynamicObject("fbasedataid") != null).map(o -> o.getDynamicObject("fbasedataid").getString("rptype")).distinct().count() > 1L;
                    if (!isGroupPay) {
                        logger.info("\u6765\u6e90\u4e0b\u6e38\u4e1a\u52a1\u5904\u7406\u5355\u64cd\u4f5c\uff1a\u5982\u786e\u8ba4\u5b8c\u6210\u7b49\uff0c\u5e76\u4e14\u975e\u7ec4\u5408\u4ed8\u6b3e\uff08\u7ec4\u5408\u4ed8\u6b3e\u5e94\u4ed8\u7968\u636e+\u5e94\u6536\u7968\u636e\uff09");
                        continue;
                    }
                    dynamicObjectCollection.stream().filter(o -> o.getDynamicObject("fbasedataid") != null).filter(o -> DraftBillUtils.isPayBill((String)o.getDynamicObject("fbasedataid").getString("rptype"))).forEach(o -> needLockDraftIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
                    DynamicObject[] draftArr = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,amount", (QFilter[])new QFilter[]{new QFilter("id", "in", needLockDraftIds)});
                    draftIdDealAmountMap = Arrays.stream(draftArr).collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getBigDecimal("amount"), (o1, o2) -> o1, HashMap::new));
                    needReleaseDraftIds = needLockDraftIds;
                } else {
                    boolean bl = isGroupPay = draftInfoEntrys.stream().map(draft -> draft.getDynamicObject("draftbillinfo").getString("rptype")).distinct().count() > 1L;
                    if (!isGroupPay) {
                        logger.info("\u6765\u6e90\u4e0b\u6e38\u4e1a\u52a1\u5904\u7406\u5355\u64cd\u4f5c\uff1a\u5982\u786e\u8ba4\u5b8c\u6210\u7b49\uff0c\u5e76\u4e14\u975e\u7ec4\u5408\u4ed8\u6b3e\uff08\u7ec4\u5408\u4ed8\u6b3e\u5e94\u4ed8\u7968\u636e+\u5e94\u6536\u7968\u636e\uff09");
                        continue;
                    }
                    needReleaseDraftIds = draftInfoEntrys.stream().filter(this::isPayBill).map(v -> v.getDynamicObject("draftbillinfo").getLong("id")).collect(Collectors.toSet());
                    draftIdDealAmountMap = draftInfoEntrys.stream().filter(this::isPayBill).collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
                    draftIdLogIdMap = draftInfoEntrys.stream().filter(this::isPayBill).collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
                }
            } else {
                if (EmptyUtil.isEmpty((DynamicObjectCollection)draftInfoEntrys)) {
                    HashSet needLockDraftIds = new HashSet();
                    DynamicObjectCollection newDrafts = payBill.getDynamicObjectCollection("draftbill");
                    newDrafts.stream().filter(o -> o.getDynamicObject("fbasedataid") != null).forEach(o -> needLockDraftIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
                    DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"id,amount", (QFilter[])new QFilter[]{new QFilter("id", "in", needLockDraftIds)});
                    draftIdDealAmountMap = Arrays.stream(dynamicObjectArray).collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getBigDecimal("amount"), (o1, o2) -> o1, HashMap::new));
                    needReleaseDraftIds = needLockDraftIds;
                } else {
                    needReleaseDraftIds = draftInfoEntrys.stream().map(v -> v.getDynamicObject("draftbillinfo").getLong("id")).collect(Collectors.toSet());
                    draftIdDealAmountMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
                    draftIdLogIdMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
                }
                Map needUpdatePayDraftBillMapPay = DraftHelper.getOnlyUsePayDraftBillMap((DynamicObject)payBill);
                if (EmptyUtil.isNoEmpty((Object)needUpdatePayDraftBillMapPay) && needUpdatePayDraftBillMapPay.size() > 0) {
                    needUpdatePayDraftBillMap.putAll(needUpdatePayDraftBillMapPay);
                }
            }
            logger.info("needReleaseDraftIds\uff1a{}", needReleaseDraftIds);
            ArrayList<DraftAmountLockSubInfo> draftAmountLockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
            for (Long l : needReleaseDraftIds) {
                BigDecimal dealAmount;
                DraftAmountLockSubInfo draftAmountLockInfo = new DraftAmountLockSubInfo();
                draftAmountLockInfo.setBillId(l);
                BigDecimal bigDecimal = dealAmount = draftIdDealAmountMap.get(l) == null ? BigDecimal.ZERO : (BigDecimal)draftIdDealAmountMap.get(l);
                if (this.batchRecIdList.contains(payBillId)) {
                    dealAmount = payBill.getBigDecimal("actpayamt");
                }
                draftAmountLockInfo.setDealAmount(dealAmount);
                Long billLogId = draftIdLogIdMap.get(l) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(l);
                draftAmountLockInfo.setBillLogId(billLogId);
                draftAmountLockInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                draftAmountLockInfo.setOperateType(LogOperateTypeEnum.COMPLETE.getValue());
                draftAmountLockSubInfoList.add(draftAmountLockInfo);
            }
            if (!EmptyUtil.isNoEmpty(draftAmountLockSubInfoList)) continue;
            draftLockInfo.getLockSubInfoList().addAll(draftAmountLockSubInfoList);
            releaseDraftAmountLockInfos.add(draftLockInfo);
        }
        if (!CollectionUtils.isEmpty(releaseDraftAmountLockInfos)) {
            this.draftLockServiceHelper.releaseOrLockDraft(releaseDraftAmountLockInfos);
        }
        logger.info("deal billlog end");
        return needUpdatePayDraftBillMap;
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        this.releaseBizLock();
        this.draftLockServiceHelper.rollback();
    }

    private boolean isPayBill(DynamicObject draft) {
        return DraftBillUtils.isPayBill((String)draft.getDynamicObject("draftbillinfo").getString("rptype"));
    }

    private DynamicObject[] querySourceBills(Long[] ids) {
        if (EmptyUtil.isEmpty((Object[])ids)) {
            return new DynamicObject[0];
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)ids), new QFilter("sourcebilltype", "=", (Object)"cas_paybill"), new QFilter("applyorg", "is not null", null), new QFilter("applyorg", "!=", (Object)0)};
        DynamicObjectCollection srcPayBills = QueryServiceHelper.query((String)"cas_paybill", (String)"sourcebillid", (QFilter[])qFilters);
        if (CasHelper.isNotEmpty((Object)srcPayBills)) {
            Object[] sourceBillIds = (Long[])srcPayBills.parallelStream().map(d -> d.getLong("sourcebillid")).toArray(Long[]::new);
            DynamicObject[] list = BusinessDataServiceHelper.load((Object[])sourceBillIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_paybill"));
            return list;
        }
        return new DynamicObject[0];
    }

    private Map<Long, DynamicObject> queryDraftTradeBills(List<Long> draftIds) {
        if (EmptyUtil.isEmpty(draftIds)) {
            return new HashMap<Long, DynamicObject>();
        }
        HashMap<Long, DynamicObject> draftBillIdAndTradeDyMap = new HashMap<Long, DynamicObject>(8);
        QFilter[] qFilters = new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("tradetype", "=", (Object)"endorse"), new QFilter("entrys.draftbill.id", "in", draftIds)};
        DynamicObjectCollection drafttrans = QueryServiceHelper.query((String)"cdm_drafttradebill", (String)"id", (QFilter[])qFilters);
        if (CasHelper.isNotEmpty((Object)drafttrans)) {
            HashSet<Long> hasMatchIdSet = new HashSet<Long>();
            Object[] drafttranIds = (Long[])drafttrans.parallelStream().map(d -> d.getLong("id")).toArray(Long[]::new);
            DynamicObject[] drafttradfebills = BusinessDataServiceHelper.load((Object[])drafttranIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_drafttradebill"));
            ArrayList<DraftTradeInfo> draftTradeInfos = new ArrayList<DraftTradeInfo>(8);
            for (DynamicObject drafttradfebill : drafttradfebills) {
                long tradeBillId = drafttradfebill.getLong("id");
                Date bizfinishDate = drafttradfebill.getDate("bizfinishdate");
                DynamicObjectCollection entrys = drafttradfebill.getDynamicObjectCollection("entrys");
                for (DynamicObject entry : entrys) {
                    long draftBillId = entry.getDynamicObject("draftbill").getLong("id");
                    hasMatchIdSet.add(draftBillId);
                    DraftTradeInfo draftTradeInfo = new DraftTradeInfo();
                    draftTradeInfo.setTradeBillId(Long.valueOf(tradeBillId));
                    draftTradeInfo.setBillId(Long.valueOf(draftBillId));
                    draftTradeInfo.setFinishDate(bizfinishDate);
                    draftTradeInfos.add(draftTradeInfo);
                }
            }
            if (EmptyUtil.isNoEmpty(draftTradeInfos) && draftTradeInfos.size() > 0) {
                Map<Long, Optional<DraftTradeInfo>> draftBillIdAndTradeMap = draftTradeInfos.stream().collect(Collectors.groupingBy(DraftTradeInfo::getBillId, Collectors.maxBy(Comparator.comparing(DraftTradeInfo::getFinishDate))));
                Map<Long, DynamicObject> draftTradeBillIdAnDyMap = Arrays.stream(drafttradfebills).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
                for (Map.Entry<Long, Optional<DraftTradeInfo>> entry : draftBillIdAndTradeMap.entrySet()) {
                    Long draftBillId = entry.getKey();
                    Optional<DraftTradeInfo> draftTradeInfoOp = entry.getValue();
                    if (!EmptyUtil.isNoEmpty(draftTradeInfoOp) || !draftTradeInfoOp.isPresent()) continue;
                    DraftTradeInfo draftTradeInfo = draftTradeInfoOp.get();
                    Long tradeBillId = draftTradeInfo.getTradeBillId();
                    DynamicObject tradeBillDy = draftTradeBillIdAnDyMap.get(tradeBillId);
                    if (!EmptyUtil.isNoEmpty((Long)tradeBillId)) continue;
                    draftBillIdAndTradeDyMap.put(draftBillId, tradeBillDy);
                }
            }
            HashSet<Long> allDraftIdSet = new HashSet<Long>(draftIds);
            allDraftIdSet.removeAll(hasMatchIdSet);
            this.getSubBillTradeBill(draftBillIdAndTradeDyMap, allDraftIdSet);
            return draftBillIdAndTradeDyMap;
        }
        HashSet<Long> allDraftIdSet = new HashSet<Long>(draftIds);
        this.getSubBillTradeBill(draftBillIdAndTradeDyMap, allDraftIdSet);
        return draftBillIdAndTradeDyMap;
    }

    private void getSubBillTradeBill(Map<Long, DynamicObject> draftBillIdAndTradeDyMap, Set<Long> allDraftIdSet) {
        Set<Object> splitTradeBillIdSet;
        DynamicObjectCollection splitBillIdColl;
        if (EmptyUtil.isNoEmpty(allDraftIdSet) && allDraftIdSet.size() > 0 && EmptyUtil.isNoEmpty((DynamicObjectCollection)(splitBillIdColl = QueryServiceHelper.query((String)"cdm_receivablebill", (String)"id,equaltradebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", allDraftIdSet), new QFilter("draftbillstatus", "=", (Object)"endorsed")}))) && splitBillIdColl.size() > 0 && EmptyUtil.isNoEmpty(splitTradeBillIdSet = splitBillIdColl.stream().map(e -> e.getLong("equaltradebillid")).collect(Collectors.toSet()))) {
            DynamicObject[] drafttradfebillsBySubBills = BusinessDataServiceHelper.load((Object[])splitTradeBillIdSet.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_drafttradebill"));
            Map<Long, DynamicObject> tradeIdAndDyMap = Arrays.stream(drafttradfebillsBySubBills).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
            for (DynamicObject splitBill : splitBillIdColl) {
                long draftId = splitBill.getLong("id");
                long equaltradebillid = splitBill.getLong("equaltradebillid");
                DynamicObject draftTradeDy = tradeIdAndDyMap.get(equaltradebillid);
                if (!EmptyUtil.isNoEmpty((DynamicObject)draftTradeDy)) continue;
                draftBillIdAndTradeDyMap.put(draftId, draftTradeDy);
            }
        }
    }

    private DynamicObject[] queryPayRecDraftF7(List<Long> draftIds) {
        if (EmptyUtil.isEmpty(draftIds)) {
            return new DynamicObject[0];
        }
        return BusinessDataServiceHelper.load((Object[])draftIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_payandrecdraft_f7"));
    }

    private void batchLockDraftBill(DynamicObject[] payBills, List<Long> draftIds, DynamicObject[] payDraftF7s, Map<Long, DynamicObject> draftBillIdAndTradeMap) {
        for (DynamicObject payBill : payBills) {
            for (Long draftId : draftIds) {
                DynamicObject tradeBill = draftBillIdAndTradeMap.get(draftId);
                if (!EmptyUtil.isNoEmpty((DynamicObject)tradeBill)) continue;
                TXHandle h = TX.requiresNew();
                Throwable throwable = null;
                try {
                    CasBotpHelper.saveRelation((DBRoute)DBRouteConst.TMC, (DynamicObject)payBill, (DynamicObject)tradeBill);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (h == null) continue;
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    h.close();
                }
            }
            DynamicObjectCollection draftDataColl = MultiBaseDataHelper.generateMultiPropValue((DynamicObject)payBill, (String)"draftbill", (DynamicObject[])payDraftF7s);
            payBill.set("draftbill", (Object)draftDataColl);
            this.fillBillDraftInfoEntry(payBill, draftBillIdAndTradeMap);
        }
    }

    private void fillBillDraftInfoEntry(DynamicObject data, Map<Long, DynamicObject> draftBillIdAndTradeMap) {
        DynamicObjectCollection entrys = data.getDynamicObjectCollection("cas_draftinfo");
        DynamicObjectCollection newDrafts = data.getDynamicObjectCollection("draftbill");
        boolean isFromBatchSelect = false;
        if (EmptyUtil.isNoEmpty(this.batchRecIdList) && this.batchRecIdList.size() > 0 && this.batchRecIdList.contains(data.getLong("id"))) {
            isFromBatchSelect = true;
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)newDrafts) && newDrafts.size() > 0 && (EmptyUtil.isEmpty((DynamicObjectCollection)entrys) || entrys.size() == 0)) {
            BigDecimal actpayamt = data.getBigDecimal("actpayamt");
            for (int i = 0; i < newDrafts.size(); ++i) {
                DynamicObjectCollection draftTradeEntrys;
                List draftBillLogList;
                DynamicObject newDraft = (DynamicObject)newDrafts.get(i);
                DynamicObject fbasedataid = newDraft.getDynamicObject("fbasedataid");
                if (!EmptyUtil.isNoEmpty((DynamicObject)fbasedataid)) continue;
                DynamicObject cas_draftinfo = entrys.addNew();
                if (isFromBatchSelect) {
                    cas_draftinfo.set("transamount", (Object)actpayamt);
                } else {
                    cas_draftinfo.set("transamount", (Object)fbasedataid.getBigDecimal("amount"));
                }
                cas_draftinfo.set("paybillcurrency", (Object)fbasedataid.getDynamicObject("currency").getLong("id"));
                cas_draftinfo.set("draftbillinfo", (Object)fbasedataid);
                cas_draftinfo.set("srcbillindex", (Object)i);
                long draftbillId = fbasedataid.getLong("id");
                DynamicObject tradeBill = draftBillIdAndTradeMap.get(draftbillId);
                if (!EmptyUtil.isNoEmpty((DynamicObject)tradeBill) || !EmptyUtil.isNoEmpty(draftBillLogList = (draftTradeEntrys = tradeBill.getDynamicObjectCollection("entrys")).stream().filter(e -> draftbillId == e.getDynamicObject("draftbill").getLong("id")).map(entry -> entry.getLong("billlogid")).collect(Collectors.toList()))) continue;
                Long draftBillLogId = (Long)draftBillLogList.get(0);
                cas_draftinfo.set("draftbilllogid", (Object)draftBillLogId);
                this.updateBillLogIdSet.add(draftBillLogId);
            }
        }
    }

    private void batchDraftBillRollBack(DynamicObject[] payBills, List<Long> draftIds, DynamicObject[] draftTradeBills) {
        ArrayList<DraftLockInfo> lockInfoList = new ArrayList<DraftLockInfo>(payBills.length);
        for (DynamicObject payBill : payBills) {
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            draftLockInfo.setSourceBillId(Long.valueOf(payBill.getLong("id")));
            draftLockInfo.setSourceBillType(payBill.getDataEntityType().getName());
            draftLockInfo.getReleaseBillIdList().addAll(draftIds);
            lockInfoList.add(draftLockInfo);
        }
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"cdm", (String)"LockDraftService", (String)"lockOrReleaseBill", (Object[])new Object[]{JSON.toJSONString(lockInfoList)});
        for (DynamicObject tradeBill : draftTradeBills) {
            try (TXHandle h = TX.requiresNew();){
                CasBotpHelper.deleteRation((String)"cas_paybill", (Long[])new Long[0], (Long)tradeBill.getLong("id"));
            }
        }
    }

    private void batchUpdateValue(DynamicObject[] paybills, DynamicObject draftBill, boolean isEntrust) {
        Map params = this.getOption().getVariables();
        String cs1046 = params.get("cs1046") != null ? (String)params.get("cs1046") : "";
        boolean isFromCdm = params.containsKey("draftbillno");
        boolean cdmBook = params.containsKey("cdmbook");
        boolean endorse = params.containsKey("endorse");
        long currUserId = RequestContext.get().getCurrUserId();
        Map paydateMap = null;
        if (isEntrust) {
            Set sourceOrgIds = ((Stream)Arrays.stream(paybills).parallel()).filter(d -> CasHelper.isNotEmpty((Object)d.getDynamicObject("org")) && CasHelper.isNotEmpty((Object)d.getDynamicObject("org").getLong("id"))).map(d -> d.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
            paydateMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList(sourceOrgIds), (String)"selectpaydate");
        } else {
            paydateMap = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList<Long>(this.orgIds), (String)"selectpaydate");
        }
        for (DynamicObject paybill : paybills) {
            Date payDate = PaymentPayHelper.confirmPayDate((DynamicObject)paybill, (String)cs1046, (Map)params, (Map)paydateMap);
            paybill.set("paydate", (Object)payDate);
            paybill.set("billstatus", (Object)BillStatusEnum.PAY.getValue());
            boolean isNeedBook = CasHelper.isEmpty((Object)paybill.get("entrustorg")) && (!isFromCdm || cdmBook);
            logger.info("---->>> this bill[{}] needbook={}", (Object)paybill.getString("billno"), (Object)isNeedBook);
            paybill.set("cashier", (Object)currUserId);
            if (isFromCdm && !endorse) {
                DynamicObjectCollection draftColl = MultiBaseDataHelper.generateMultiPropValue((DynamicObject)paybill, (String)"draftbill", (DynamicObject[])new DynamicObject[]{draftBill});
                logger.info("=======\u5f00\u7968\u767b\u8bb0\u53cd\u5199\u7ed3\u7b97\u53f7\uff0cbillno:{}", (Object)paybill.getString("billno"));
                paybill.set("draftbill", (Object)draftColl);
                DynamicObjectCollection draftInfoEntries = paybill.getDynamicObjectCollection("cas_draftinfo");
                Set draftIdSet = draftInfoEntries.stream().map(draft -> draft.getDynamicObject("draftbillinfo").getPkValue()).collect(Collectors.toSet());
                if (!draftIdSet.contains(draftBill.getPkValue())) {
                    DraftHelper.addCasDraftInfoEntry((DynamicObjectCollection)draftInfoEntries, (DynamicObject)draftBill);
                }
            }
            PaymentPayHelper.updateEntryDpAmt((DynamicObject)paybill);
        }
        RefundHelper.setSomeRefundAmtFields((DynamicObject[])paybills, (String)"cas_paybill");
        SaveServiceHelper.save((DynamicObject[])paybills);
    }

    private void diffCurPay(DynamicObject[] paybills, String agreeRate, String dpAmtStr, String fee) {
        BigDecimal dpAmt = new BigDecimal(dpAmtStr);
        for (DynamicObject paybill : paybills) {
            if (!paybill.getBoolean("isdiffcur")) continue;
            paybill.set("dpamt", (Object)dpAmt);
            paybill.set("agreedrate", (Object)agreeRate);
            paybill.set("fee", (Object)fee);
            BigDecimal dpEcr = paybill.getBigDecimal("dpexchangerate");
            DynamicObject baseCy = paybill.getDynamicObject("basecurrency");
            String dpQta = paybill.getString("dppayquotation");
            BigDecimal dpLocalAmt = QuotationHelper.callToCurrency((BigDecimal)dpAmt, (BigDecimal)dpEcr, (String)dpQta, (int)baseCy.getInt("amtprecision"));
            BigDecimal localAmt = paybill.getBigDecimal("localamt");
            paybill.set("dplocalamt", (Object)dpLocalAmt);
            paybill.set("lossamt", (Object)localAmt.subtract(dpLocalAmt));
            this.updateMatchAmt(paybill);
        }
    }

    private void payFeePay(DynamicObject[] paybills, String singleStreamStr, String feeStr, String feeactbankStr, String feecurrencyStr, String feepaydateStr) {
        BigDecimal fee = new BigDecimal(feeStr);
        boolean isSingle = Boolean.parseBoolean(singleStreamStr);
        Date feePayDate = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{feepaydateStr}) ? DateUtils.stringToDate((String)feepaydateStr, (String)"yyyy-MM-dd HH:mm:ss") : null;
        DynamicObject bank = CasHelper.isNotEmpty((Object)feeactbankStr) && Long.parseLong(feeactbankStr) != 0L ? BusinessDataServiceHelper.loadSingle((Object)feeactbankStr, (String)"bd_accountbanks") : null;
        DynamicObject feeCurrency = CasHelper.isNotEmpty((Object)feecurrencyStr) && Long.parseLong(feecurrencyStr) != 0L ? BusinessDataServiceHelper.loadSingle((Object)feecurrencyStr, (String)"bd_currency") : null;
        for (DynamicObject paybill : paybills) {
            paybill.set("feepaydate", (Object)feePayDate);
            paybill.set("singlestream", (Object)isSingle);
            paybill.set("fee", (Object)fee);
            paybill.set("feeactbank", (Object)bank);
            paybill.set("feecurrency", (Object)feeCurrency);
            if (isSingle) {
                paybill.set("totalpayamt", (Object)paybill.getBigDecimal("dpamt"));
            } else {
                paybill.set("totalpayamt", (Object)paybill.getBigDecimal("dpamt").add(fee));
            }
            this.updateMatchAmt(paybill);
        }
    }

    private void exChgRatePay(DynamicObject[] paybills, String dpchr) {
        if (StringUtils.isNotBlank((CharSequence)dpchr) && BigDecimal.ZERO.compareTo(new BigDecimal(dpchr)) != 0) {
            for (DynamicObject paybill : paybills) {
                paybill.set("dpexchangerate", (Object)dpchr);
                if (!paybill.getBoolean("isdiffcur")) {
                    paybill.set("exchangerate", (Object)dpchr);
                }
                PaymentFillPropHelper.calculateAmt((DynamicObject)paybill, (boolean)false);
                this.updateMatchAmt(paybill);
            }
        }
    }

    private void updateMatchAmt(DynamicObject payBill) {
        boolean isSingle = payBill.getBoolean("singlestream");
        BigDecimal fee = payBill.getBigDecimal("fee");
        BigDecimal matchAmountPay = payBill.getBigDecimal("matchamountpay");
        BigDecimal umMatchPay = payBill.getBigDecimal("dpamt").subtract(matchAmountPay);
        if (!isSingle) {
            umMatchPay = umMatchPay.add(fee);
        }
        if (BigDecimal.ZERO.compareTo(umMatchPay) != 0 && BigDecimal.ZERO.compareTo(matchAmountPay) != 0) {
            payBill.set("matchflag", (Object)"2");
        }
        payBill.set("unmatchamountpay", (Object)umMatchPay);
        BigDecimal matchAmountRec = payBill.getBigDecimal("matchamountrec");
        BigDecimal umMatchRec = payBill.getBigDecimal("dpamt").subtract(matchAmountRec);
        if (!isSingle) {
            umMatchRec = umMatchRec.add(fee);
        }
        payBill.set("unmatchamountrec", (Object)umMatchRec);
        if (BigDecimal.ZERO.compareTo(umMatchRec) != 0 && BigDecimal.ZERO.compareTo(matchAmountRec) != 0) {
            payBill.set("matchflag", (Object)"2");
        }
    }
}

