/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.helper.AutoMatchHelper;
import kd.fi.cas.business.helper.CasFlowConfirmLogHelper;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.business.helper.PaymentFillPropHelper;
import kd.fi.cas.business.helper.RecClaimBillHelper;
import kd.fi.cas.business.helper.ReceredWayHelper;
import kd.fi.cas.business.helper.StringHelper;
import kd.fi.cas.business.opservice.helper.DealCasSameTransAndRuleNameHelper;
import kd.fi.cas.business.opservice.helper.RecPayRuleHelper;
import kd.fi.cas.business.opservice.helper.ValidAndSetMatchInfoHelper;
import kd.fi.cas.business.opservice.impl.BillPropertyValueHandle;
import kd.fi.cas.business.service.WriteBackServiceImpl;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.PaymentSaveOrSubmitWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.business.writeback.task.WriteDetailParam;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.DataTypeEnum;
import kd.fi.cas.enums.ReceredWayEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.OrgHelper;
import kd.fi.cas.helper.PayAndRecFillTypeHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.helper.RefundHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.info.WriteBackTaskInfo;
import kd.fi.cas.param.ParamMap;
import kd.fi.cas.payment.PaymentPayHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.SerializeHelper;
import kd.fi.cas.util.StringUtils;
import kd.fi.cas.validator.BillNoSaveValidator;
import kd.fi.cas.validator.CrossBorderPayLicenseValidator;
import kd.fi.cas.validator.MainTransferValidator;
import kd.fi.cas.validator.OrgFinishinitValidator;
import kd.fi.cas.validator.PayBillWriteValidator;
import kd.fi.cas.validator.PaymentBillEndorseSaveValidator;
import kd.fi.cas.validator.PaymentBillIsFreezeValidator;
import kd.fi.cas.validator.PaymentSynSaveValidator;
import kd.fi.cas.validator.QuotationOpPayOrAgentValidator;
import kd.fi.cas.validator.common.TxLockValidator;
import kd.fi.cas.validator.pay.PayAccountCashValidator;
import kd.fi.cas.validator.paymentbill.PaymentDiffPayEmptyValidator;
import kd.fi.cas.validator.paymentbill.PaymentLCOpenValidator;
import kd.fi.cas.validator.paymentbill.PaymentSaveNewValidator;
import kd.fi.cas.validator.paymentbill.PaymentSaveValidator;
import kd.fi.cas.validator.paymentbill.PaymentTypeValidator;

public class PaymentSaveOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(PaymentSaveOp.class);
    private static String CONST_API = "api";
    private static final String queryDateSql = "select sum(a.FActAmount)\u3000amount\u3000, sum(a.FLocalAmount) locamount\u3000from  T_CAS_PaymentBillEntry a  where  a.fid = ? ";
    private static final String BOS_SAVE_APPEND_ENTRY_ROWS = "bos_save_appendentryrows";
    private Set<Long> orgIds = new HashSet<Long>(0);
    private Map<String, List<DynamicObject>> srcBillMap = new HashMap<String, List<DynamicObject>>(0);
    private Map<String, Object> orgCS1047Map = new HashMap<String, Object>(0);
    private Map<Long, DynamicObject> orgTableMap = new HashMap<Long, DynamicObject>(0);
    private ParamMap opParam = new ParamMap();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("currency.amtprecision");
        lst.add("sourcetype");
        lst.add("billno");
        lst.add("sourcebillnumber");
        lst.add("sourcebillid");
        lst.add("e_sourcebillid");
        lst.add("e_sourcebillentryid");
        lst.add("e_actamt");
        lst.add("draftbill");
        lst.add("actpayamt");
        lst.add("org");
        lst.add("expectdate");
        lst.add("paymentchannel");
        lst.add("payee");
        lst.add("payeename");
        lst.add("entrustorg");
        lst.add("payeetype");
        lst.add("paymenttype");
        lst.add("itempayee");
        lst.add("itempayeetype");
        lst.add("ispersonpay");
        lst.add("payeebanknum");
        lst.add("payeeformid");
        lst.add("payeebanknum");
        lst.add("payeeacctbank");
        lst.add("e_lockAmt");
        lst.add("e_unlockAmt");
        lst.add("e_unsettledamt");
        lst.add("e_settledamt");
        lst.add("payeeaccformid");
        lst.add("basecurrency");
        lst.add("exratedate");
        lst.add("e_payablelocamt");
        lst.add("e_discountlocamt");
        lst.add("e_discountamt");
        lst.add("e_localamt");
        lst.add("localamt");
        lst.add("iscrosspay");
        lst.add("dpamt");
        lst.add("billno");
        lst.add("description");
        lst.add("isheadpush");
        lst.add("sourcebilltype");
        lst.add("sourcebillid");
        lst.add("sourceentry");
        lst.add("entry");
        lst.add("billtype");
        lst.add("isdiffcur");
        lst.add("payeracctcash");
        lst.add("payeracctbank");
        lst.add("openorg");
        lst.add("dpcurrency");
        lst.add("fee");
        lst.add("totalpayamt");
        lst.add("e_unsettledlocalamt");
        lst.add("exchangerate");
        lst.add("payquotation");
        lst.add("dppayquotation");
        lst.add("agreedquotation");
        lst.add("basecurrency");
        lst.add("currency");
        lst.add("settletype");
        lst.add(String.join((CharSequence)".", "settletype", "settlementtype"));
        lst.add("settletnumber");
        lst.add("singlestream");
        lst.add("feecurrency");
        lst.add("feeactbank");
        lst.add("settlestatus");
        lst.add("unsettleamount");
        lst.add("unsettleamountbase");
        lst.add("settleamount");
        lst.add("settleamountbase");
        lst.add("e_settledlocalamt");
        lst.add("relateotherflow");
        lst.add("org");
        lst.add("matchamountrec");
        lst.add("unmatchamountrec");
        lst.add("matchamountpay");
        lst.add("unmatchamountpay");
        lst.add("paymentidentify");
        lst.add("matchflag");
        lst.add("entry");
        lst.add("entry.e_sourcebillid");
        lst.add("sourcebilltype");
        lst.add("bankcheckentity.ebankcheckflag");
        lst.add("entrance");
        lst.add("entrance");
        lst.add("entry.e_paymenttype");
        lst.add("uniformsocialcreditcode");
        lst.add("totalrefundedamt");
        lst.add("totalremainrefundamt");
        lst.add("localrefundedamt");
        lst.add("localremainrefundamt");
        lst.add("payquotation");
        lst.add("exchangerate");
        lst.add("payerbank");
        lst.add("payeebank");
        lst.add("entry.e_payableamt");
        lst.add("entry.e_refundamt");
        lst.add("entry.e_remainrefundamt");
        lst.add("entry.e_dpamt");
        lst.add("agreedrate");
        lst.add("payeeacctcash");
        lst.add("payeebankname");
        lst.add("recprovince");
        lst.add("reccity");
        lst.add("auditparam");
        lst.add("iscrosspay");
        lst.add("payeetype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new PaymentSaveNewValidator());
        e.getValidators().add(new PaymentLCOpenValidator());
        e.getValidators().add(new PaymentDiffPayEmptyValidator());
        e.getValidators().add(new PaymentBillEndorseSaveValidator());
        e.getValidators().add(new PaymentSaveValidator());
        e.getValidators().add(new BillNoSaveValidator());
        e.getValidators().add(new CrossBorderPayLicenseValidator());
        e.getValidators().add(new PaymentSynSaveValidator());
        e.getValidators().add(new OrgFinishinitValidator());
        e.getValidators().add(new QuotationOpPayOrAgentValidator());
        e.getValidators().add(new PaymentTypeValidator());
        e.addValidator((AbstractValidator)new PaymentBillIsFreezeValidator());
        e.addValidator((AbstractValidator)new MainTransferValidator());
        e.addValidator((AbstractValidator)new PayBillWriteValidator(WriteBackOperateEnum.SAVEVALIDATE));
        e.getValidators().add(new TxLockValidator());
        e.getValidators().add(new PayAccountCashValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] infos;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject info : infos = e.getDataEntities()) {
            DynamicObject org = info.getDynamicObject("org");
            long orgId = CasHelper.isEmpty((Object)org) ? 0L : org.getLong("id");
            this.orgIds.add(orgId);
            PaymentPayHelper.updateEntryDpAmt((DynamicObject)info);
            String payType = info.getString("payeetype");
            if (!"bd_supplier".equalsIgnoreCase(payType)) continue;
            PaymentPayHelper.updateAuditParam((DynamicObject)info);
        }
        this.orgCS1047Map = SystemParameterHelper.getSystemParamsByOrgIds(new ArrayList<Long>(this.orgIds), (String)"cs1047");
        this.srcBillMap = ((Stream)Arrays.stream(infos).parallel()).filter(d -> CasHelper.isNotEmpty((Object)d.getString("sourcebilltype"))).collect(Collectors.groupingBy(d -> d.getString("sourcebilltype")));
        this.orgTableMap = SystemStatusCtrolHelper.getExrateTable(this.orgIds);
        this.opParam.getParams().putAll(this.getOption().getVariables());
        RefundHelper.setSomeRefundAmtFields((DynamicObject[])e.getDataEntities(), (String)"cas_paybill");
    }

    private void setPayValueByRule(Map<String, Object> returnPay, DynamicObject paymentBill, DynamicObject payEntry) {
        String runWay;
        Object payeeacctbank;
        DynamicObject paymenttype = (DynamicObject)returnPay.get("e_paymenttype");
        String payeetype = String.valueOf(returnPay.get("e_payeetype"));
        Object e_recer = returnPay.get("e_recer");
        logger.info("\u6536\u6b3e\u4eba\u7c7b\u578b" + payeetype);
        if (EmptyUtil.isEmpty((Object)e_recer)) {
            ValidAndSetMatchInfoHelper.validAndSetMatchInfo((DynamicObject)paymentBill, (String)payeetype, (String)"pay", (boolean)false);
        }
        DynamicObject e_fundflowitem = null;
        if (returnPay.containsKey("e_fundflowitem")) {
            e_fundflowitem = (DynamicObject)returnPay.get("e_fundflowitem");
        }
        String e_remark = "";
        if (returnPay.containsKey("e_remark")) {
            e_remark = String.valueOf(returnPay.get("e_remark"));
        }
        if (!EmptyUtil.isEmpty((Object)(payeeacctbank = paymentBill.get("payeeacctbank"))) && !"0".equals(payeeacctbank.toString())) {
            paymentBill.set("payeeaccformid", (Object)"bd_accountbanks");
        }
        if (!CasHelper.isEmpty((Object)paymenttype)) {
            DynamicObject billType;
            paymentBill.set("paymenttype", (Object)paymenttype);
            Boolean ispartpayment = paymenttype.getBoolean("ispartpayment");
            if (ispartpayment.booleanValue()) {
                payEntry.set("e_unsettledamt", (Object)payEntry.getBigDecimal("e_actamt").subtract(payEntry.getBigDecimal("e_settledamt")));
                payEntry.set("e_unlockamt", (Object)payEntry.getBigDecimal("e_actamt").subtract(payEntry.getBigDecimal("e_lockamt")));
            }
            if (EmptyUtil.isEmpty((DynamicObject)(billType = paymentBill.getDynamicObject("billtype"))) || BillTypeConstants.PAYBILL_PUR.equals(billType.getLong("id"))) {
                billType = BusinessDataServiceHelper.loadSingle((String)"bos_billtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(ispartpayment != false ? BillTypeConstants.PAYBILL_PUR : BillTypeConstants.PAYBILL_OTR))});
                paymentBill.set("billtype", (Object)billType);
            }
        }
        if (!CasHelper.isEmpty((Object)payeetype)) {
            paymentBill.set("payeetype", (Object)payeetype);
            paymentBill.set("payeeformid", (Object)payeetype);
            if (!CasHelper.isEmpty((Object)e_recer)) {
                if (!AsstActTypeEnum.OTHER.getValue().equals(payeetype)) {
                    DynamicObject e_payerObj = BusinessDataServiceHelper.loadSingle((Object)e_recer, (String)payeetype);
                    paymentBill.set("itempayee", e_payerObj.getPkValue());
                    paymentBill.set("payee", e_payerObj.getPkValue());
                    paymentBill.set("payeename", (Object)e_payerObj.getString("name"));
                    paymentBill.set("payeenumber", (Object)e_payerObj.getString("number"));
                } else {
                    paymentBill.set("itempayee", null);
                    paymentBill.set("payee", null);
                    paymentBill.set("payeenumber", null);
                    paymentBill.set("payeename", e_recer);
                }
            }
        }
        String string = runWay = this.getOption().containsVariable("returnDataByOpHand") ? ReceredWayEnum.HAND.getValue() : "";
        if (PaymentSaveOp.isHandAndOther(paymentBill, runWay, payeetype)) {
            DynamicObject sourceInterPay = BusinessDataServiceHelper.loadSingle((Object)paymentBill.getLong("sourcebillid"), (String)"bei_intelpay", (String)"oppunit,oppbanknumber,oppbank");
            paymentBill.set("payeename", (Object)sourceInterPay.getString("oppunit"));
            paymentBill.set("payeebanknum", (Object)sourceInterPay.getString("oppbanknumber"));
            paymentBill.set("payeebankname", (Object)sourceInterPay.getString("oppbank"));
            if (CasHelper.isNotEmpty((Object)e_recer)) {
                paymentBill.set("payeename", e_recer);
            }
        }
        if (!CasHelper.isEmpty((Object)e_fundflowitem)) {
            payEntry.set("e_fundflowitem", (Object)e_fundflowitem);
        }
        if (!CasHelper.isEmpty((Object)e_remark)) {
            paymentBill.set("description", (Object)e_remark);
        }
        this.fillExtFieldValues(returnPay, paymentBill);
    }

    private static boolean isHandAndOther(DynamicObject paymentBill, String runWay, String payeetype) {
        return CasHelper.isNotEmpty((Object)runWay) && CasHelper.isNotEmpty((Object)payeetype) && AsstActTypeEnum.OTHER.getValue().equals(payeetype) && ReceredWayEnum.HAND.getValue().equals(runWay) && CasHelper.isNotEmpty((Object)paymentBill.getString("sourcebilltype")) && CasHelper.isNotEmpty((Object)paymentBill.getLong("sourcebillid")) && "bei_intelpay".equals(paymentBill.getString("sourcebilltype"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        List<DynamicObject> claimList;
        super.beginOperationTransaction(e);
        DynamicObject[] infos = e.getDataEntities();
        HashMap recInfo = new HashMap(4);
        List<String> detailIds = new ArrayList<String>(8);
        String ruleWay = null;
        for (DynamicObject info : infos) {
            String returnDataByOpHand;
            if (this.getOption().containsVariable("returnDataByOpHolding")) {
                String returnDataByOpHolding = this.getOption().getVariableValue("returnDataByOpHolding");
                this.opParam.put("returnDataByOpHolding", (Object)returnDataByOpHolding);
            }
            if (this.getOption().containsVariable("returnDataByOpHand")) {
                returnDataByOpHand = this.getOption().getVariableValue("returnDataByOpHand");
                this.opParam.put("returnDataByOpHand", (Object)returnDataByOpHand);
            }
            if (this.getOption().containsVariable("returnDataByOpHandMerge")) {
                returnDataByOpHand = this.getOption().getVariableValue("returnDataByOpHandMerge");
                this.opParam.put("returnDataByOpHandMerge", (Object)returnDataByOpHand);
            }
            String sourceBillType = info.getString("sourcebilltype");
            boolean isFromDb = info.getDataEntityState().getFromDatabase();
            if (isFromDb || !"bei_intelpay".equals(sourceBillType)) continue;
            String ruleName = null;
            if (this.getOption().containsVariable("returnDataByOpHand")) {
                ruleWay = ReceredWayEnum.HAND.getValue();
            } else if (this.getOption().containsVariable("returnDataByOpHandMerge")) {
                ruleWay = ReceredWayEnum.HANDMERGE.getValue();
            } else {
                ruleWay = ReceredWayEnum.RULE.getValue();
                DynamicObject payEntry = (DynamicObject)info.getDynamicObjectCollection("entry").get(0);
                Map returnPay = RecPayRuleHelper.getInfoByMatchRule((DynamicObject)info, (String)"pay");
                if (!CasHelper.isEmpty((Object)returnPay) && returnPay.size() > 0) {
                    this.setPayValueByRule(returnPay, info, payEntry);
                    ruleName = (String)returnPay.get("e_rulesname");
                }
            }
            detailIds = ReceredWayHelper.writeInfoBeiRecInfoBei((String)ruleWay, ruleName, (DynamicObject)info, recInfo, detailIds, (String)this.operateOption.getVariableValue("opnumber", ""), (String)"pay");
            this.operateOption.setVariableValue("ruleWay", ruleWay);
        }
        this.batchProcessReceipt(infos, detailIds, ruleWay);
        this.batchProcess(infos);
        PaymentFillPropHelper.setDefaultProvinceAndCity((DynamicObject[])infos);
        if (recInfo != null && recInfo.size() > 0) {
            WriteDetailParam param = new WriteDetailParam();
            param.setRecInfo(recInfo);
            ECGlobalSession.begin((String)"WRITE_DETAIL", (DBRoute)DBRoute.of((String)"cas"), (boolean)true);
            ECGlobalSession.setBusinessType((String)"workbench");
            ECGlobalSession.setBusinessInfo(detailIds);
            ECGlobalSession.setAsync((boolean)true);
            ECGlobalSession.register((String)"fi", (String)"cas", (String)"RecPayWriteDetailService", (Param)param, null, (String)"");
            CasFlowConfirmLogHelper.saveEnterLog(recInfo);
        }
        if ((claimList = Arrays.stream(infos).filter(dynamicObject -> !dynamicObject.getDataEntityState().getFromDatabase()).collect(Collectors.toList())) != null && claimList.size() > 0) {
            RecClaimBillHelper.writeBackByClaimBatch((DynamicObject[])claimList.toArray(new DynamicObject[claimList.size()]), (Boolean)true);
        }
        for (DynamicObject info : infos) {
            PayAndRecFillTypeHelper.fillpayMentBillEntryType((DynamicObject)info);
        }
        PayBillHepler.writeBackLetterCredit((String)"save", (boolean)true, (OperateOption)this.getOption(), (DynamicObject[])infos);
        PayBillHepler.writeBackArrival((OperateOption)this.getOption(), (DynamicObject[])infos);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String feepaysave;
        logger.info("PaymentSaveOp afterExecuteOperationTransaction start");
        Boolean isSave = false;
        for (DynamicObject paymentBill : e.getDataEntities()) {
            String sourceBillType = paymentBill.getString("sourcebilltype");
            if ("bei_transdetail_cas".equals(sourceBillType) || "bei_transdetail".equals(sourceBillType) || "bei_intelpay".equals(sourceBillType)) {
                try {
                    logger.info("\u4e1a\u52a1\u5355\u636e\u4fdd\u5b58\u65f6\u5904\u7406\u540c\u540d\u8f6c\u8d26\u4e1a\u52a1");
                    if (paymentBill.getBoolean("relateotherflow") && this.getOption().containsVariable("ruleWay")) {
                        DealCasSameTransAndRuleNameHelper.dealSameNameTrans((DynamicObject)paymentBill, (String)this.getOption().getVariableValue("ruleWay"));
                        isSave = true;
                    }
                }
                catch (Exception e1) {
                    logger.error("\u4e1a\u52a1\u5355\u636e\u4fdd\u5b58\u65f6\u5904\u7406\u540c\u540d\u8f6c\u8d26\u4e1a\u52a1\u62a5\u9519", (Throwable)e1);
                }
                Map tMatchResult = AutoMatchHelper.getMatchAmount((BigDecimal)BigDecimal.ZERO, (BigDecimal)paymentBill.getBigDecimal("matchamountpay"), (BigDecimal)paymentBill.getBigDecimal("unmatchamountpay"), (Boolean)paymentBill.getBoolean("relateotherflow"), (BigDecimal)paymentBill.getBigDecimal("matchamountrec"), (BigDecimal)paymentBill.getBigDecimal("unmatchamountrec"));
                AutoMatchHelper.initMatchAmount((DynamicObject)paymentBill, (Map)tMatchResult, (String)"matchamountpay", (String)"unmatchamountpay", (String)"matchflag", (String)"matchflagmsg");
            }
            if (!"fr_glreim_paybill".equals(sourceBillType)) continue;
            WriteBackTaskHelper.addRealtimeTask((DynamicObject)paymentBill, (String)sourceBillType, (WriteBackOperateEnum)WriteBackOperateEnum.SAVE, PaymentDisposeConsumer.class);
        }
        if (isSave.booleanValue()) {
            SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
        }
        if ("1".equals(feepaysave = this.operateOption.getVariableValue("feepaysave", ""))) {
            ArrayList<Long> pkIds = new ArrayList<Long>(e.getDataEntities().length);
            for (DynamicObject paymentBill : e.getDataEntities()) {
                paymentBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
                pkIds.add(paymentBill.getLong("id"));
            }
            SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
            OperateOption create = OperateOption.create();
            OperateServiceHelper.execOperate((String)"pay", (String)"cas_paybill", (Object[])pkIds.toArray(new Object[0]), (OperateOption)create);
            DapBuildVoucherCommonUtil.executeWriteBillDBOperation((String)"cas_paybill", (String)"audit", pkIds, (DapBuildVoucherCommonUtil.executeType)DapBuildVoucherCommonUtil.executeType.INSERTWRITE);
        }
        logger.info("PaymentSaveOp afterExecuteOperationTransaction end");
    }

    private void batchProcess(DynamicObject[] payBills) {
        for (DynamicObject payBill : payBills) {
            String sourceBillType = payBill.getString("sourcebilltype");
            if (("bei_transdetail_cas".equals(sourceBillType) || "bei_transdetail".equals(sourceBillType) || "bei_intelpay".equals(sourceBillType)) && !payBill.getDataEntityState().getFromDatabase()) {
                DynamicObject payEntry = (DynamicObject)payBill.getDynamicObjectCollection("entry").get(0);
                String returnDataStr = "";
                Map returnData = null;
                if (!CasHelper.isEmpty((Object)this.opParam) && this.opParam.getParams().size() > 0) {
                    Map paramMap = this.opParam.getParams();
                    if (paramMap.containsKey("returnDataByOpHolding")) {
                        returnDataStr = String.valueOf(paramMap.get("returnDataByOpHolding"));
                        returnData = (Map)SerializationUtils.fromJsonString((String)returnDataStr, Map.class);
                    }
                    if (paramMap.containsKey("returnDataByOpHand")) {
                        returnDataStr = String.valueOf(paramMap.get("returnDataByOpHand"));
                        returnData = (Map)SerializationUtils.fromJsonString((String)returnDataStr, Map.class);
                    }
                    if (paramMap.containsKey("returnDataByOpHandMerge")) {
                        String fundflowitemSeri;
                        returnDataStr = String.valueOf(paramMap.get("returnDataByOpHandMerge"));
                        returnData = (Map)SerializationUtils.fromJsonString((String)returnDataStr, Map.class);
                        DynamicObjectCollection payEntrys = payBill.getDynamicObjectCollection("entry");
                        if (returnData.containsKey("e_fundflowitem") && !CasHelper.isEmpty((Object)(fundflowitemSeri = String.valueOf(returnData.get("e_fundflowitem")))) && payEntrys.size() > 1) {
                            DynamicObject fundflowitem = SerializeHelper.deserializeDynamicObj((String)"cas_fundflowitem", (String)fundflowitemSeri);
                            for (DynamicObject entry : payEntrys) {
                                entry.set("e_fundflowitem", (Object)fundflowitem);
                            }
                        }
                    }
                }
                if (null != returnData && returnData.size() > 0) {
                    String fundflowitemSeri;
                    String paymenttypeSeri;
                    Object isautoackpay;
                    if (returnData.containsKey("isautoackpay") && ((Boolean)(isautoackpay = returnData.get("isautoackpay"))).booleanValue()) {
                        payBill.set("billstatus", (Object)"D");
                    }
                    if (!CasHelper.isEmpty((Object)(paymenttypeSeri = String.valueOf(returnData.get("e_paymenttype"))))) {
                        DynamicObject paymenttype = SerializeHelper.deserializeDynamicObj((String)"cas_paymentbilltype", (String)paymenttypeSeri);
                        returnData.put("e_paymenttype", paymenttype);
                    }
                    if (returnData.containsKey("e_fundflowitem") && !CasHelper.isEmpty((Object)(fundflowitemSeri = String.valueOf(returnData.get("e_fundflowitem"))))) {
                        DynamicObject fundflowitem = SerializeHelper.deserializeDynamicObj((String)"cas_fundflowitem", (String)fundflowitemSeri);
                        returnData.put("e_fundflowitem", fundflowitem);
                    }
                    if (!CasHelper.isEmpty((Object)returnData) && returnData.size() > 0) {
                        logger.info("\u4ea4\u6613\u660e\u7ec6\u4e0b\u63a8\u5e76\u4fdd\u5b58\u4ed8\u6b3e\u5355,\u624b\u5de5\u5165\u8d26,\u8fd4\u56de\u4fe1\u606f" + returnData);
                        this.setPayValueByRule(returnData, payBill, payEntry);
                    }
                }
            }
            this.commonBillHandle(payBill);
        }
        if (this.srcBillMap.size() > 0) {
            for (Map.Entry entry : this.srcBillMap.entrySet()) {
                this.sourceBillHandle((String)entry.getKey(), (List)entry.getValue());
            }
        }
    }

    private void commonBillHandle(DynamicObject payBill) {
        boolean isSame;
        String sourcebillnumber;
        DynamicObjectCollection entryColl = payBill.getDynamicObjectCollection("entry");
        BigDecimal exchangeRate = payBill.getBigDecimal("exchangerate");
        Date exrateDate = payBill.getDate("exratedate") == null ? Calendar.getInstance().getTime() : payBill.getDate("exratedate");
        Long baseCurrencyId = DynamicObjectHelper.getPk((DynamicObject)payBill, (String)"basecurrency");
        Long orgId = DynamicObjectHelper.getPk((DynamicObject)payBill, (String)"org");
        Long currencyId = DynamicObjectHelper.getPk((DynamicObject)payBill, (String)"currency");
        if (CasHelper.isEmpty((Object)baseCurrencyId)) {
            DynamicObject baseCurrency = OrgHelper.getBaseCurrency((long)orgId);
            if (baseCurrency == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u672a\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u4e0d\u80fd\u4fdd\u5b58\u5355\u636e\u3002", (String)"PaymentSaveImpl_1", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            baseCurrencyId = baseCurrency.getLong("id");
        }
        if (!baseCurrencyId.equals(currencyId) && CasHelper.isEmpty((Object)exchangeRate)) {
            DynamicObject exrateTable = payBill.getDynamicObject("exratetable");
            if (exrateTable == null) {
                exrateTable = this.orgTableMap.get(orgId);
            }
            if (CasHelper.isEmpty((Object)exchangeRate)) {
                long exrateTableId = exrateTable == null ? 0L : exrateTable.getLong("id");
                Map exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)currencyId, (Long)baseCurrencyId, (Long)exrateTableId, (Date)exrateDate);
                exchangeRate = BigDecimal.ONE.setScale(10);
                if (exchangeRateByRules != null && exchangeRateByRules.get("exchangeRate") != null) {
                    exchangeRate = (BigDecimal)exchangeRateByRules.get("exchangeRate");
                }
            }
        }
        DynamicObject dynamicObject = payBill.getDynamicObject("basecurrency");
        int round = 10;
        if (dynamicObject != null) {
            round = payBill.getDynamicObject("basecurrency").getInt("amtprecision");
        }
        BigDecimal settledamt = BigDecimal.ZERO;
        BigDecimal settledlocalamt = BigDecimal.ZERO;
        BigDecimal unsettledamt = BigDecimal.ZERO;
        BigDecimal unsettledlocalamtAll = BigDecimal.ZERO;
        String quotation = payBill.getString("payquotation");
        for (DynamicObject entry : entryColl) {
            BigDecimal e_payableamt = entry.getBigDecimal("e_payableamt");
            BigDecimal e_lockamt = entry.getBigDecimal("e_lockamt");
            BigDecimal e_settledamt = entry.getBigDecimal("e_settledamt");
            DynamicObjectHelper.setValueIfAbsent((DynamicObject)entry, (String)"e_unlockAmt", (Object)e_payableamt.subtract(e_lockamt));
            DynamicObjectHelper.setValueIfAbsent((DynamicObject)entry, (String)"e_unsettledamt", (Object)e_payableamt.subtract(e_settledamt));
            logger.info("\u5e94\u4ed8\u91d1\u989d\uff1a{}\uff0c\u5df2\u9501\u5b9a\u91d1\u989d\uff1a{}\uff0c\u5df2\u7ed3\u7b97\u91d1\u989d\uff1a{}", new Object[]{e_payableamt, e_lockamt, e_settledamt});
            BigDecimal unsettledlocalamt = QuotationHelper.callToCurrency((BigDecimal)e_payableamt.subtract(e_settledamt), (BigDecimal)exchangeRate, (String)quotation, (int)round);
            DynamicObjectHelper.setValueIfAbsent((DynamicObject)entry, (String)"e_unsettledlocalamt", (Object)unsettledlocalamt);
            settledamt = settledamt.add(entry.getBigDecimal("e_settledamt"));
            settledlocalamt = settledlocalamt.add(entry.getBigDecimal("e_settledlocalamt"));
            unsettledamt = unsettledamt.add(e_payableamt.subtract(e_settledamt));
            unsettledlocalamtAll = unsettledlocalamtAll.add(unsettledlocalamt);
        }
        payBill.set("settleamount", (Object)settledamt);
        payBill.set("settleamountbase", (Object)settledlocalamt);
        payBill.set("unsettleamount", (Object)unsettledamt);
        payBill.set("unsettleamountbase", (Object)unsettledlocalamtAll);
        if (settledamt.compareTo(BigDecimal.ZERO) > 0 && unsettledamt.compareTo(BigDecimal.ZERO) == 0) {
            payBill.set("settlestatus", (Object)"settled");
        }
        if (settledamt.compareTo(BigDecimal.ZERO) > 0 && unsettledamt.compareTo(BigDecimal.ZERO) > 0) {
            payBill.set("settlestatus", (Object)"partsettle");
        }
        if (settledamt.compareTo(BigDecimal.ZERO) == 0 && unsettledamt.compareTo(BigDecimal.ZERO) > 0) {
            payBill.set("settlestatus", (Object)"unsettle");
        }
        if (StringUtils.isNotEmpty((String)(sourcebillnumber = payBill.getString("sourcebillnumber"))) && sourcebillnumber.length() > 255) {
            sourcebillnumber = sourcebillnumber.substring(0, 252) + "...";
            payBill.set("sourcebillnumber", (Object)sourcebillnumber);
        }
        String settleNumber = payBill.getString("settletnumber");
        payBill.set("settletnumber", (Object)StringHelper.subString((String)settleNumber, (int)2000));
        DynamicObject billtype = payBill.getDynamicObject("billtype");
        if (billtype != null && !BillTypeConstants.PAYBILL_CASH.equals(billtype.getPkValue())) {
            DynamicObject account;
            String payeebanknum = payBill.getString("payeebanknum");
            String payeeacctbank = payBill.getString("payeeacctbank");
            if ((CasHelper.isEmpty((Object)payeeacctbank) || "0".equals(payeeacctbank)) && CasHelper.isNotEmpty((Object)payeebanknum) && (account = AccountBankHelper.getAccountByNumber((DynamicObject)payBill.getDynamicObject("org"), (String)payeebanknum, (Long)payBill.getLong("payee"), (String)payBill.getString("payeeType"))) != null) {
                payBill.set("payeeacctbank", account.getPkValue());
                payBill.set("payeeaccformid", (Object)"bd_accountbanks");
            }
            if (CasHelper.isEmpty((Object)payBill.getString("payeeaccformid")) && CasHelper.isNotEmpty((Object)payeebanknum)) {
                DynamicObject account2;
                String localeValue;
                ILocaleString localeString;
                if (payBill.getDynamicObject("org").getPkValue().equals(payBill.getLong("payee")) && (account = AccountBankHelper.getAccountByNumber((String)payeebanknum)) != null) {
                    payBill.set("payeeaccformid", (Object)"bd_accountbanks");
                }
                if (CasHelper.isNotEmpty((Object)(localeString = payBill.getDynamicObject("org").getLocaleString("name"))) && CasHelper.isNotEmpty((Object)(localeValue = localeString.getLocaleValue())) && localeValue.equals(payBill.getString("payeename")) && (account2 = AccountBankHelper.getAccountByNumber((String)payeebanknum)) != null) {
                    payBill.set("payeeaccformid", (Object)"bd_accountbanks");
                }
            }
        }
        DynamicObject accountBank = payBill.getDynamicObject("payeracctbank");
        DynamicObject accountCash = payBill.getDynamicObject("payeracctcash");
        if (accountBank != null) {
            DynamicObjectHelper.setValueIfAbsent((DynamicObject)payBill, (String)"openorg", (Object)accountBank.get("openorg"));
        } else if (accountCash != null) {
            DynamicObjectHelper.setValueIfAbsent((DynamicObject)payBill, (String)"openorg", (Object)accountCash.get("openorg"));
        }
        boolean bl = isSame = Long.compare(BillTypeConstants.PAYBILL_SYN, payBill.getLong("billtype.id")) == 0;
        if (isSame) {
            payBill.set("entrance", (Object)"SYN");
        }
        new BillPropertyValueHandle(payBill);
        this.dealMatchInfo(payBill);
    }

    private void sourceBillHandle(String srcBillType, List<DynamicObject> bills) {
        if (EmptyUtil.isEmpty(bills)) {
            return;
        }
        switch (srcBillType) {
            case "ar_finarbill": {
                this.lockEntryAmtForArBill(bills);
                this.writeBackSourceBill(srcBillType, bills);
                break;
            }
            case "cas_payapplybill": 
            case "cas_transferapply": 
            case "lc_arrival": {
                this.writeBackSourceBill(srcBillType, bills);
                break;
            }
            case "ap_finapbill": {
                PayBillHepler.lockEntryAmtForApBill(bills);
                break;
            }
            case "fr_glreim_paybill": {
                break;
            }
            default: {
                ArrayList<DynamicObject> lcPayBills = new ArrayList<DynamicObject>(16);
                for (DynamicObject bill : bills) {
                    if (!PayBillHepler.isLCSettlement((DynamicObject)bill)) continue;
                    lcPayBills.add(bill);
                }
                if (lcPayBills.size() > 0) {
                    PayBillHepler.payApplyBillWriteBackArrival(lcPayBills, (WriteBackOperateEnum)WriteBackOperateEnum.SAVE, PaymentSaveOrSubmitWriteBackConsumer.class);
                }
                bills.removeAll(lcPayBills);
                if (bills.size() <= 0) break;
                PayBillHepler.lockEntryAmt((String)srcBillType, bills);
                WriteBackServiceImpl.getInstance().batchWrite(bills, WriteBackOperateEnum.SAVE, PaymentSaveOrSubmitWriteBackConsumer.class);
            }
        }
        for (DynamicObject bill : bills) {
            this.setValueIfPushAndSave(bill);
        }
    }

    private void lockEntryAmtForArBill(List<DynamicObject> bills) {
        for (DynamicObject info : bills) {
            DynamicObjectCollection entryColl = info.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                entry.set("e_lockAmt", (Object)entry.getBigDecimal("e_payableAmt"));
                entry.set("e_unlockAmt", (Object)BigDecimal.ZERO);
            }
        }
    }

    private void writeBackSourceBill(String sourceBillType, List<DynamicObject> bills) {
        if ("cas_payapplybill".equals(sourceBillType)) {
            OperateOption operateOption = this.getOption();
            String isPayScheBack = "";
            String payScheRelease = "";
            String payScheOPType = "";
            String backReason = null;
            String delPayApplyBillIds = "";
            if (operateOption != null && operateOption.containsVariable("isPayScheBack")) {
                isPayScheBack = operateOption.getVariableValue("isPayScheBack");
                payScheRelease = operateOption.getVariableValue("payScheRelease");
                payScheOPType = operateOption.getVariableValue("payScheOPType");
                delPayApplyBillIds = operateOption.getVariableValue("delPayApplyBillIds");
                if (operateOption.containsVariable("backReason")) {
                    backReason = operateOption.getVariableValue("backReason");
                }
            }
            ArrayList<WriteBackTaskInfo> taskInfos = new ArrayList<WriteBackTaskInfo>(bills.size());
            for (DynamicObject bill : bills) {
                WriteBackTaskInfo taskInfo = new WriteBackTaskInfo();
                taskInfo.setBillId((Long)bill.getPkValue());
                taskInfo.setDataEntity(bill.getDataEntityType().getName());
                taskInfo.setSourceEntity(bill.getString("sourcebilltype"));
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("info", bill);
                if (backReason != null) {
                    param.put("backReason", backReason);
                }
                taskInfo.setParam(param);
                taskInfo.setIsPayScheBack(isPayScheBack);
                taskInfo.setPayScheRelease(payScheRelease);
                taskInfo.setPayScheOPType(payScheOPType);
                taskInfo.setDelPayApplyBillIds(delPayApplyBillIds);
                taskInfos.add(taskInfo);
            }
            WriteBackTaskHelper.batchAddRealtimeTaskList(taskInfos, (WriteBackOperateEnum)WriteBackOperateEnum.SAVE, PaymentSaveOrSubmitWriteBackConsumer.class);
            PayBillHepler.payApplyBillWriteBackArrival(bills, (WriteBackOperateEnum)WriteBackOperateEnum.SAVE, PaymentSaveOrSubmitWriteBackConsumer.class);
        } else if (!"ar_finarbill".equals(sourceBillType)) {
            for (DynamicObject info : bills) {
                HashMap<String, DynamicObject> param = new HashMap<String, DynamicObject>(1);
                param.put("info", info);
                WriteBackTaskHelper.addRealtimeTask((DynamicObject)info, (String)sourceBillType, (WriteBackOperateEnum)WriteBackOperateEnum.SAVE, PaymentSaveOrSubmitWriteBackConsumer.class, param);
            }
        }
    }

    private void dealMatchInfo(DynamicObject paymentBill) {
        String sourceBillType;
        BigDecimal matchAmtRec;
        long orgId;
        String payeeType = paymentBill.getString("payeetype");
        Long payerId = paymentBill.getDynamicObject("org").getLong("id");
        Long payeeId = paymentBill.getLong("payee");
        long l = orgId = CasHelper.isEmpty((Object)paymentBill.getDynamicObject("org")) ? 0L : paymentBill.getDynamicObject("org").getLong("id");
        if ("bos_org".equals(payeeType) && payeeId.compareTo(payerId) == 0) {
            boolean cs1047 = this.orgCS1047Map.get(String.valueOf(orgId)) == null ? false : (Boolean)this.orgCS1047Map.get(String.valueOf(orgId));
            paymentBill.set("relateotherflow", (Object)cs1047);
        } else {
            paymentBill.set("relateotherflow", (Object)false);
        }
        if (AsstActTypeEnum.OTHER.getValue().equals(payeeType)) {
            paymentBill.set("payeeacctbank", null);
        }
        if (BigDecimal.ZERO.compareTo(matchAmtRec = paymentBill.getBigDecimal("matchamountrec")) == 0) {
            paymentBill.set("matchamountrec", (Object)BigDecimal.ZERO);
            paymentBill.set("unmatchamountrec", (Object)paymentBill.getBigDecimal("dpamt"));
        }
        if ("bei_intelpay".equals(sourceBillType = paymentBill.getString("sourcebilltype")) || "cas_claimcenterbill".equals(sourceBillType)) {
            paymentBill.set("matchamountpay", (Object)paymentBill.getBigDecimal("totalpayamt"));
            paymentBill.set("unmatchamountpay", (Object)BigDecimal.ZERO);
            BigDecimal unMatchAmountRec = paymentBill.getBigDecimal("unmatchamountrec");
            if (!paymentBill.getBoolean("relateotherflow")) {
                paymentBill.set("matchflag", (Object)"1");
            } else if (BigDecimal.ZERO.compareTo(unMatchAmountRec) < 0) {
                paymentBill.set("matchflag", (Object)"2");
            }
        } else if (StringUtils.isEmpty((String)paymentBill.getString("matchflag")) || "0".equals(paymentBill.getString("matchflag"))) {
            paymentBill.set("matchamountpay", (Object)BigDecimal.ZERO);
            paymentBill.set("unmatchamountpay", (Object)paymentBill.getBigDecimal("totalpayamt"));
            paymentBill.set("matchflag", (Object)"0");
        }
        Map tMatchResult = AutoMatchHelper.getMatchAmount((BigDecimal)BigDecimal.ZERO, (BigDecimal)paymentBill.getBigDecimal("matchamountpay"), (BigDecimal)paymentBill.getBigDecimal("unmatchamountpay"), (Boolean)paymentBill.getBoolean("relateotherflow"), (BigDecimal)paymentBill.getBigDecimal("matchamountrec"), (BigDecimal)paymentBill.getBigDecimal("unmatchamountrec"));
        AutoMatchHelper.initMatchAmount((DynamicObject)paymentBill, (Map)tMatchResult, (String)"matchamountpay", (String)"unmatchamountpay", (String)"matchflag", (String)"matchflagmsg");
    }

    private void setValueIfPushAndSave(DynamicObject paymentBill) {
        Date exrateDate;
        Long orgId = DynamicObjectHelper.getPk((DynamicObject)paymentBill, (String)"org");
        Long baseCurrencyId = DynamicObjectHelper.getPk((DynamicObject)paymentBill, (String)"basecurrency");
        if (CasHelper.isEmpty((Object)baseCurrencyId)) {
            DynamicObject baseCurrency = OrgHelper.getBaseCurrency((long)orgId);
            if (baseCurrency == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u672a\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u4e0d\u80fd\u4fdd\u5b58\u5355\u636e\u3002", (String)"PaymentSaveImpl_1", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            paymentBill.set("basecurrency", (Object)baseCurrency);
            baseCurrencyId = baseCurrency.getLong("id");
        }
        Long currencyId = DynamicObjectHelper.getPk((DynamicObject)paymentBill, (String)"currency");
        BigDecimal exchangeRate = paymentBill.getBigDecimal("exchangerate");
        Date date = exrateDate = paymentBill.getDate("exratedate") == null ? Calendar.getInstance().getTime() : paymentBill.getDate("exratedate");
        if (!baseCurrencyId.equals(currencyId) && CasHelper.isEmpty((Object)exchangeRate)) {
            DynamicObject exrateTable = paymentBill.getDynamicObject("exratetable");
            if (exrateTable == null) {
                exrateTable = this.orgTableMap.get(orgId);
                paymentBill.set("exratetable", (Object)exrateTable);
            }
            if (CasHelper.isEmpty((Object)exchangeRate)) {
                long exrateTableId = exrateTable == null ? 0L : exrateTable.getLong("id");
                Map exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)currencyId, (Long)baseCurrencyId, (Long)exrateTableId, (Date)exrateDate);
                exchangeRate = BigDecimal.ONE.setScale(10);
                if (exchangeRateByRules != null && exchangeRateByRules.get("exchangeRate") != null) {
                    exchangeRate = (BigDecimal)exchangeRateByRules.get("exchangeRate");
                }
            }
            DynamicObjectHelper.setValue((DynamicObject)paymentBill, (String)"exchangerate", (Object)exchangeRate);
        }
        DynamicObjectCollection entry = paymentBill.getDynamicObjectCollection("entry");
        String quotation = paymentBill.getString("payquotation");
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumLocalAmt = BigDecimal.ZERO;
        if (this.getOption().containsVariable(BOS_SAVE_APPEND_ENTRY_ROWS) && "true".equals(this.getOption().getVariableValue(BOS_SAVE_APPEND_ENTRY_ROWS)) && EmptyUtil.isNoEmpty((Long)paymentBill.getLong("id"))) {
            DataSet queryDataSet = DB.queryDataSet((String)"queryamount", (DBRoute)DBRouteConst.cas, (String)queryDateSql, (Object[])new Object[]{paymentBill.getLong("id")});
            for (Row row : queryDataSet) {
                sumAmt = row.getBigDecimal("amount") == null ? BigDecimal.ZERO : row.getBigDecimal("amount");
                sumLocalAmt = row.getBigDecimal("locamount") == null ? BigDecimal.ZERO : row.getBigDecimal("locamount");
            }
        }
        for (DynamicObject rowInfo : entry) {
            BigDecimal localAmount;
            BigDecimal payLocalAmount = rowInfo.getBigDecimal("e_payablelocamt");
            BigDecimal payAmount = rowInfo.getBigDecimal("e_payableamt");
            if (payAmount != null && CasHelper.isEmpty((Object)payLocalAmount)) {
                DynamicObject baseCurrency = paymentBill.getDynamicObject("basecurrency");
                int amtprecision = baseCurrency != null ? baseCurrency.getInt("amtprecision") : 10;
                BigDecimal payAblelocAmt = QuotationHelper.callToCurrency((BigDecimal)payAmount, (BigDecimal)exchangeRate, (String)quotation, (int)amtprecision);
                rowInfo.set("e_payablelocamt", (Object)payAblelocAmt);
            }
            BigDecimal discountLocalAmt = rowInfo.getBigDecimal("e_discountlocamt");
            BigDecimal discountAmt = rowInfo.getBigDecimal("e_discountamt");
            if (discountAmt != null && CasHelper.isEmpty((Object)discountLocalAmt)) {
                rowInfo.set("e_discountlocamt", (Object)discountAmt.multiply(exchangeRate));
            }
            BigDecimal actAmount = rowInfo.getBigDecimal("e_actamt");
            if (payAmount != null && discountAmt != null && CasHelper.isEmpty((Object)actAmount)) {
                BigDecimal actAmt = payAmount.subtract(discountAmt);
                rowInfo.set("e_actamt", (Object)actAmt);
            }
            BigDecimal actLocalAmount = rowInfo.getBigDecimal("e_localamt");
            actAmount = rowInfo.getBigDecimal("e_actamt");
            sumAmt = sumAmt.add(actAmount);
            if (CasHelper.isEmpty((Object)actLocalAmount)) {
                BigDecimal actLocalAmt = actAmount.multiply(exchangeRate);
                rowInfo.set("e_localamt", (Object)actLocalAmt);
            }
            localAmount = CasHelper.isEmpty((Object)(localAmount = rowInfo.getBigDecimal("e_localamt"))) ? BigDecimal.ZERO : localAmount;
            sumLocalAmt = sumLocalAmt.add(localAmount);
        }
        paymentBill.set("actpayamt", (Object)sumAmt);
        paymentBill.set("localamt", (Object)sumLocalAmt);
    }

    private void fillExtFieldValues(Map<String, Object> returnPay, DynamicObject payBill) {
        String handleBillType = (String)returnPay.get("handleBill");
        DynamicObjectCollection billConFieldConfigs = QueryServiceHelper.query((String)"cas_billconvertfieldcfg", (String)"billtype, datatype, extendname, tarfieldname", null);
        billConFieldConfigs.stream().filter(billConFieldConfig -> {
            String billtype = billConFieldConfig.getString("billtype");
            if ("recvbill".equals(billtype)) {
                billtype = billtype.replace("v", "");
            }
            return EmptyUtil.isNoEmpty((String)handleBillType) && handleBillType.contains(billtype);
        }).forEach(billConFieldConfig -> {
            String extendName = billConFieldConfig.getString("extendname");
            String tarfieldname = billConFieldConfig.getString("tarfieldname");
            int dataType = billConFieldConfig.getInt("datatype");
            if (payBill.containsProperty(tarfieldname) && EmptyUtil.isNoEmpty(returnPay.get(extendName)) && DataTypeEnum.getDataTypeByOrdinal((int)dataType) != null) {
                Object value = returnPay.get(extendName);
                payBill.set(tarfieldname, DataType.convertValue((DataType)DataTypeEnum.getDataTypeByOrdinal((int)dataType), value));
            }
        });
    }

    private void batchProcessReceipt(DynamicObject[] paymentBills, List<String> detailIds, String ruleWay) {
        DynamicObjectCollection transDetailList = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)"id,ismatchereceipt", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)detailIds.stream().map(Long::valueOf).toArray())});
        Map idAndResMap = transDetailList.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getBoolean("ismatchereceipt"), (o1, o2) -> o1, HashMap::new));
        if (CollectionUtils.isEmpty((Map)idAndResMap)) {
            return;
        }
        block0: for (DynamicObject info : paymentBills) {
            String sourceBillType = info.getString("sourcebilltype");
            boolean isFromDb = info.getDataEntityState().getFromDatabase();
            if (isFromDb || !"bei_intelpay".equals(sourceBillType)) continue;
            ArrayList<Long> sourceBillIdList = new ArrayList<Long>(10);
            if (ReceredWayEnum.HANDMERGE.getValue().equals(ruleWay)) {
                info.getDynamicObjectCollection("entry").forEach(e -> sourceBillIdList.add(e.getLong("e_sourcebillid")));
            } else {
                sourceBillIdList.add(info.getLong("sourcebillid"));
            }
            for (Long detailId : sourceBillIdList) {
                if (!EmptyUtil.isNoEmpty((Long)detailId) || !idAndResMap.getOrDefault(detailId, false).booleanValue()) continue;
                info.set("isgetreceipt", (Object)true);
                continue block0;
            }
        }
    }
}

