/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.overdraft;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.fi.cas.helper.PayBillCrossHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;
import kd.fi.cas.util.EmptyUtil;

public class PaymentPayValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("paymentidentify");
        return preparePropertys;
    }

    public void validate() {
        Set accBankIds = ((Stream)Arrays.stream(this.dataEntities).parallel()).filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDataEntity().getDynamicObject("payeracctbank"))).map(d -> d.getDataEntity().getDynamicObject("payeracctbank").getLong("id")).collect(Collectors.toSet());
        Set ifmAccIds = PayBillCrossHelper.getIfmAccIds(accBankIds);
        List ids = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getString("id")).collect(Collectors.toList());
        List lockedIds = TxCheckUtil.getLocked(ids);
        String isLock = "false";
        if (this.getOption().containsVariable("isLock")) {
            isLock = this.getOption().getVariableValue("isLock");
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String sourceBillType;
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObject payerAcctBank = entity.getDynamicObject("payeracctbank");
            if (!"true".equals(isLock) && lockedIds.contains(entity.getString("id"))) {
                String error = ResManager.loadKDString((String)"\u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"PaymentCancelPayValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, error, ErrorLevel.Error);
            }
            if ("bei_intelpay".equals(sourceBillType = (String)entity.get("sourcebilltype")) || payerAcctBank == null || !ifmAccIds.contains(payerAcctBank.getLong("id")) || !PaymentBillPluginHelper.paymentIdentify((DynamicObject)entity)) continue;
            String error = ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237\u8bf7\u9009\u62e9\u5185\u90e8\u7ed3\u7b97\u4ed8\u6b3e\u3002", (String)"PaymentErrorCode_48", (String)"fi-cas-business", (Object[])new Object[0]);
            this.addMessage(dataEntity, error, ErrorLevel.Error);
        }
    }
}

