/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recclaim;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.enums.BizTypeEnum;
import kd.fi.cas.enums.ClaimStatusEnum;
import kd.fi.cas.enums.ClaimTypeEnum;
import kd.fi.cas.enums.DataTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.ebext.CasAttachmentHelper;
import kd.fi.cas.mutex.impl.DataLocker;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.validator.recclaim.ClaimBillAuditValidator;

public class ClaimBillClaimAuditOp
extends AbstractOperationServicePlugIn {
    private List<HashMap<Object, String>> updateClaimList = new ArrayList<HashMap<Object, String>>();
    private Set<String> updateClaimNoSet = new HashSet<String>();
    DataLocker dataLocker = new DataLocker();
    ClaimBillAuditValidator validator = new ClaimBillAuditValidator();
    private static final String ATTACHMENT_PANEL_KEY = "attachmentpanel";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(EntityPropertyHelper.getPropertys((String)"cas_claimbill"));
        fieldKeys.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_claimbill", (String)"entryentity"));
        fieldKeys.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_claimbill", (String)"payentity"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        this.validator.setEntityKey("cas_claimbill");
        e.addValidator((AbstractValidator)this.validator);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        QFilter qFilter = new QFilter("biztype", "=", (Object)"110").and(new QFilter("default", "=", (Object)"1")).and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] paymentBillType = BusinessDataServiceHelper.load((String)"cas_paymentbilltype", (String)"id,biztype,ispartpayment", (QFilter[])new QFilter[]{qFilter});
        DynamicObject[] receivingBillType = BusinessDataServiceHelper.load((String)"cas_receivingbilltype", (String)"id,biztype,ispartreceivable", (QFilter[])new QFilter[]{qFilter});
        DynamicObjectCollection claimFieldExtCfgs = QueryServiceHelper.query((String)"cas_claimfieldextcfg", (String)"extendname, datatype, tarfieldname", null);
        Set<String> tarFieldNames = claimFieldExtCfgs.stream().map(fieldExtCfg -> fieldExtCfg.getString("tarfieldname")).collect(Collectors.toSet());
        HashMap<String, DynamicObject> recNo_claimCenterBill = new HashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> payNo_claimCenterBill = new HashMap<String, DynamicObject>(16);
        Boolean hasRec = Boolean.FALSE;
        Boolean hasPay = Boolean.FALSE;
        HashSet<String> recClaimNos = new HashSet<String>(16);
        HashSet<String> payClaimNos = new HashSet<String>(16);
        for (DynamicObject info : e.getDataEntities()) {
            BigDecimal payAmount = info.getBigDecimal("payamount");
            String claimno = info.getString("claimno");
            if (payAmount.compareTo(BigDecimal.ZERO) != 0) {
                hasPay = Boolean.TRUE;
                payClaimNos.add(claimno);
                continue;
            }
            hasRec = Boolean.TRUE;
            recClaimNos.add(claimno);
        }
        HashSet<String> recSameField = new HashSet<String>(16);
        HashSet<String> paySameField = new HashSet<String>(16);
        if (hasRec.booleanValue()) {
            this.prepareBatchJob(Boolean.TRUE, recSameField, tarFieldNames, recClaimNos, recNo_claimCenterBill);
        }
        if (hasPay.booleanValue()) {
            this.prepareBatchJob(Boolean.FALSE, paySameField, tarFieldNames, payClaimNos, payNo_claimCenterBill);
        }
        for (DynamicObject info : e.getDataEntities()) {
            Object[] sourceclaims;
            Long sourceclaimid;
            DynamicObject cas_claimnoticebill;
            Boolean isRec = Boolean.TRUE;
            String entryTemp = "entryentity";
            String billTemp = "e_billstatus";
            BigDecimal payAmount = info.getBigDecimal("payamount");
            if (payAmount.compareTo(BigDecimal.ZERO) != 0) {
                isRec = Boolean.FALSE;
                entryTemp = "payentity";
                billTemp = "e_paybillstatus";
            }
            DynamicObjectCollection entryentityInfo = info.getDynamicObjectCollection(entryTemp);
            String claimno = info.getString("claimno");
            HashSet<String> sameFileNames = isRec != false ? recSameField : paySameField;
            DynamicObject dynamicObject = cas_claimnoticebill = isRec != false ? (DynamicObject)recNo_claimCenterBill.get(claimno) : (DynamicObject)payNo_claimCenterBill.get(claimno);
            if (EmptyUtil.isEmpty((DynamicObject)cas_claimnoticebill)) {
                return;
            }
            String claimstatus = cas_claimnoticebill.getString("claimstatus");
            String claimType = info.getString("claimtype");
            if ("0".equals(claimstatus)) {
                String businessType = info.getString("businesstype");
                cas_claimnoticebill.set("bizdate", (Object)info.getDate("bizdate"));
                cas_claimnoticebill.set("recpaytype", info.get("recpaytype"));
                cas_claimnoticebill.set("paymenttype", info.get("paymenttype"));
                cas_claimnoticebill.set("recpayer", info.get("recpayer"));
                if (BizTypeEnum.REC.getValue().equals(businessType)) {
                    cas_claimnoticebill.set("recbasepayer", info.get("recbasepayer"));
                    cas_claimnoticebill.set("paymentbasetype", info.get("paymentbasetype"));
                }
                cas_claimnoticebill.set("paytype", info.get("paytype"));
                cas_claimnoticebill.set("payeetype", info.get("payeetype"));
                cas_claimnoticebill.set("recpayee", info.get("recpayee"));
                if (BizTypeEnum.PAY.getValue().equals(businessType)) {
                    cas_claimnoticebill.set("recbasetype", info.get("recbasetype"));
                    cas_claimnoticebill.set("recviewpayer", info.get("recviewpayer"));
                }
                cas_claimnoticebill.set("recbasepayee", (Object)info.getDynamicObject("recbasepayee"));
                cas_claimnoticebill.set("singlestream", info.get("singlestream"));
                cas_claimnoticebill.set("fee", info.get("fee"));
                cas_claimnoticebill.set("inneraccount", info.get("inneraccount"));
            }
            DynamicObjectCollection claimNoticeEntry = cas_claimnoticebill.getDynamicObjectCollection(entryTemp);
            String claimBillbillno = info.getString("billno");
            String userName = "";
            if (EmptyUtil.isNoEmpty((DynamicObject)info.getDynamicObject("creator"))) {
                userName = String.valueOf(info.getDynamicObject("creator").getLong("id"));
            }
            List attachments = AttachmentServiceHelper.getAttachments((String)info.getDataEntityType().getName(), (Object)info.getPkValue(), (String)ATTACHMENT_PANEL_KEY);
            List attachmentList = CasAttachmentHelper.attachmentPanelToAttachmentField((List)attachments);
            for (Object claimBillEntry : entryentityInfo) {
                DynamicObjectCollection attachmentCol;
                DynamicObject claimNoticeEntryAddNew = claimNoticeEntry.addNew();
                for (String sameFileName : sameFileNames) {
                    claimNoticeEntryAddNew.set(sameFileName, claimBillEntry.get(sameFileName));
                }
                if (payAmount.compareTo(BigDecimal.ZERO) != 0) {
                    claimNoticeEntryAddNew.set("e_payclaimbill", (Object)claimBillbillno);
                    claimNoticeEntryAddNew.set("e_payclaimperson", (Object)userName);
                    claimNoticeEntryAddNew.set("e_payclaimtype", (Object)claimType);
                    claimNoticeEntryAddNew.set("e_paybillstatus", (Object)"C");
                    claimNoticeEntryAddNew.set("e_paysourceentryid", (Object)claimBillEntry.getLong("id"));
                    attachmentCol = claimNoticeEntryAddNew.getDynamicObjectCollection("payclaimattach");
                } else {
                    claimNoticeEntryAddNew.set("e_claimbill", (Object)claimBillbillno);
                    claimNoticeEntryAddNew.set("e_claimperson", (Object)userName);
                    claimNoticeEntryAddNew.set("e_claimtype", (Object)claimType);
                    claimNoticeEntryAddNew.set("e_billstatus", (Object)"C");
                    claimNoticeEntryAddNew.set("e_sourceentryid", (Object)claimBillEntry.getLong("id"));
                    attachmentCol = claimNoticeEntryAddNew.getDynamicObjectCollection("recclaimattach");
                }
                if (!EmptyUtil.isNoEmpty((Object)attachmentList)) continue;
                attachmentList.forEach(attachment -> attachmentCol.addNew().set("fbasedataid", attachment));
            }
            if (EmptyUtil.isNoEmpty((Object)attachmentList)) {
                Object claimBillEntry;
                TXHandle tx = TX.requiresNew();
                claimBillEntry = null;
                try {
                    try {
                        SaveServiceHelper.save((DynamicObject[])attachmentList.toArray(new DynamicObject[0]));
                    }
                    catch (Exception exception) {
                        this.dataLocker.batchRelease(this.validator.getSuccessLatKeys(), "cas_claimannounce", "ClaimBillClaimAuditOp");
                        tx.markRollback();
                        throw new KDBizException(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0b\u63a8\u8ba4\u9886\u4e2d\u5fc3\u5931\u8d25\u3002", (String)"ClaimBillClaimAuditOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                    }
                }
                catch (Throwable exception) {
                    claimBillEntry = exception;
                    throw exception;
                }
                finally {
                    if (tx != null) {
                        if (claimBillEntry != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable exception) {
                                ((Throwable)claimBillEntry).addSuppressed(exception);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            if (StringUtils.equals((CharSequence)claimType, (CharSequence)ClaimTypeEnum.CHANGE.getValue()) && EmptyUtil.isNoEmpty((Long)(sourceclaimid = Long.valueOf(info.getLong("sourceclaimid")))) && EmptyUtil.isNoEmpty((Object[])(sourceclaims = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"billno,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceclaimid)})))) {
                Object sourceclaim = sourceclaims[0];
                sourceclaim.set("billstatus", (Object)"H");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourceclaim});
                claimNoticeEntry.forEach(arg_0 -> ClaimBillClaimAuditOp.lambda$beginOperationTransaction$2((DynamicObject)sourceclaim, arg_0));
            }
            ClaimBillClaimAuditOp.claimEntryOrder(claimNoticeEntry, billTemp);
            if (payAmount.compareTo(BigDecimal.ZERO) != 0) {
                Boolean singleStream = cas_claimnoticebill.getBoolean("singlestream");
                BigDecimal unclaimamount = BigDecimal.ZERO;
                BigDecimal payableamt = claimNoticeEntry.stream().filter(dy -> !dy.getBoolean("e_paybillstatus")).map(dy -> dy.getBigDecimal("e_payableamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal payactamt = claimNoticeEntry.stream().filter(dy -> !dy.getBoolean("e_paybillstatus")).map(dy -> dy.getBigDecimal("e_payactamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                unclaimamount = payAmount.subtract(cas_claimnoticebill.getBigDecimal("fee")).add(payableamt).subtract(payactamt).subtract(payableamt);
                if (singleStream.booleanValue()) {
                    unclaimamount = unclaimamount.add(cas_claimnoticebill.getBigDecimal("fee"));
                }
                cas_claimnoticebill.set("unclaimamount", (Object)unclaimamount);
                cas_claimnoticebill.set("claimedamount", (Object)payableamt);
                if (payableamt.compareTo(BigDecimal.ZERO) == 0) {
                    cas_claimnoticebill.set("claimstatus", (Object)ClaimStatusEnum.WAIT.getValue());
                    info.set("claimstatus", (Object)ClaimStatusEnum.WAIT.getValue());
                } else if (StringUtils.equals((CharSequence)claimType, (CharSequence)ClaimTypeEnum.CLAIM.getValue())) {
                    if (payAmount.compareTo(BigDecimal.ZERO) > 0 && payableamt.compareTo(BigDecimal.ZERO) > 0 && unclaimamount.compareTo(BigDecimal.ZERO) <= 0 || payAmount.compareTo(BigDecimal.ZERO) < 0 && payableamt.compareTo(BigDecimal.ZERO) < 0 && unclaimamount.compareTo(BigDecimal.ZERO) >= 0) {
                        cas_claimnoticebill.set("claimstatus", (Object)ClaimStatusEnum.CLAIMED.getValue());
                        info.set("claimstatus", (Object)ClaimStatusEnum.CLAIMED.getValue());
                    } else {
                        cas_claimnoticebill.set("claimstatus", (Object)ClaimStatusEnum.PART.getValue());
                        info.set("claimstatus", (Object)ClaimStatusEnum.PART.getValue());
                    }
                }
                long disTypeNum = claimNoticeEntry.stream().map(o -> o.getDynamicObject("e_paymenttype").getPkValue()).distinct().count();
                if (disTypeNum == 1L) {
                    cas_claimnoticebill.set("multipaymenttype", (Object)Boolean.FALSE);
                    DynamicObject ePaymentType = ((DynamicObject)claimNoticeEntry.get(0)).getDynamicObject("e_paymenttype");
                    cas_claimnoticebill.set("paytype", (Object)ePaymentType);
                } else if (disTypeNum > 1L) {
                    cas_claimnoticebill.set("multipaymenttype", (Object)Boolean.TRUE);
                    if (paymentBillType != null && paymentBillType.length != 0) {
                        cas_claimnoticebill.set("paytype", (Object)paymentBillType[0]);
                    }
                }
            } else {
                BigDecimal oldrec = claimNoticeEntry.stream().filter(dy -> !dy.getBoolean("e_billstatus")).map(dy -> dy.getBigDecimal("e_receivableamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal actAmt = claimNoticeEntry.stream().filter(dy -> !dy.getBoolean("e_billstatus")).map(dy -> dy.getBigDecimal("e_actamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal olddis = claimNoticeEntry.stream().filter(dy -> !dy.getBoolean("e_billstatus")).map(dy -> dy.getBigDecimal("e_discountamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal oldfee = claimNoticeEntry.stream().filter(dy -> !dy.getBoolean("e_billstatus")).map(dy -> dy.getBigDecimal("e_fee")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal reamount = cas_claimnoticebill.getBigDecimal("reamount");
                if (!cas_claimnoticebill.getBoolean("isaddfee")) {
                    cas_claimnoticebill.set("fee", (Object)oldfee);
                }
                BigDecimal unclaimamount = BigDecimal.ZERO;
                unclaimamount = unclaimamount.add(reamount).add(cas_claimnoticebill.getBigDecimal("fee")).subtract(oldfee).add(oldrec).subtract(actAmt).subtract(oldrec);
                reamount = reamount.add(cas_claimnoticebill.getBigDecimal("fee"));
                reamount = reamount.add(olddis);
                BigDecimal claimedamount = oldrec;
                cas_claimnoticebill.set("claimedamount", (Object)claimedamount);
                cas_claimnoticebill.set("unclaimamount", (Object)unclaimamount);
                if (StringUtils.equals((CharSequence)claimType, (CharSequence)ClaimTypeEnum.CLAIM.getValue())) {
                    if (reamount.compareTo(BigDecimal.ZERO) > 0 && reamount.compareTo(claimedamount) > 0 || reamount.compareTo(BigDecimal.ZERO) < 0 && reamount.compareTo(claimedamount) < 0) {
                        cas_claimnoticebill.set("claimstatus", (Object)ClaimStatusEnum.PART.getValue());
                        info.set("claimstatus", (Object)ClaimStatusEnum.PART.getValue());
                    } else {
                        cas_claimnoticebill.set("claimstatus", (Object)ClaimStatusEnum.CLAIMED.getValue());
                        info.set("claimstatus", (Object)ClaimStatusEnum.CLAIMED.getValue());
                    }
                } else if (StringUtils.equals((CharSequence)claimType, (CharSequence)ClaimTypeEnum.CHANGE.getValue())) {
                    cas_claimnoticebill.set("claimstatus", (Object)ClaimStatusEnum.CHANGE.getValue());
                    info.set("claimstatus", (Object)ClaimStatusEnum.CHANGE.getValue());
                } else if (StringUtils.equals((CharSequence)claimType, (CharSequence)ClaimTypeEnum.APPEAL.getValue()) || StringUtils.equals((CharSequence)claimType, (CharSequence)ClaimTypeEnum.ADJUST.getValue())) {
                    cas_claimnoticebill.set("claimstatus", (Object)ClaimStatusEnum.APPEAL.getValue());
                    info.set("claimstatus", (Object)ClaimStatusEnum.APPEAL.getValue());
                }
                long disTypeNum = claimNoticeEntry.stream().filter(o -> CasHelper.isNotEmpty((Object)o.getDynamicObject("e_receivingtype"))).map(o -> o.getDynamicObject("e_receivingtype").getPkValue()).distinct().count();
                if (disTypeNum == 1L) {
                    cas_claimnoticebill.set("multireceivingtype", (Object)Boolean.FALSE);
                    DynamicObject eReceivingType = ((DynamicObject)claimNoticeEntry.get(0)).getDynamicObject("e_receivingtype");
                    cas_claimnoticebill.set("recpaytype", (Object)eReceivingType);
                } else if (disTypeNum > 1L) {
                    cas_claimnoticebill.set("multireceivingtype", (Object)Boolean.TRUE);
                    if (receivingBillType != null && receivingBillType.length != 0) {
                        cas_claimnoticebill.set("recpaytype", (Object)receivingBillType[0]);
                    }
                }
            }
            this.fillFieldExtValues(info, cas_claimnoticebill, claimFieldExtCfgs);
            String ClaimNotBillNo = cas_claimnoticebill.getString("billno");
            HashMap<String, String> ClaimStatusMap = new HashMap<String, String>();
            this.updateClaimList.removeIf(o -> CasHelper.isNotEmpty(o.get("billno")) && ((String)o.get("billno")).equals(ClaimNotBillNo));
            this.updateClaimNoSet.add(cas_claimnoticebill.getString("billno"));
            ClaimStatusMap.put("billno", cas_claimnoticebill.getString("billno"));
            ClaimStatusMap.put("claimbillbillno", claimBillbillno);
            ClaimStatusMap.put("id", cas_claimnoticebill.getString("id"));
            ClaimStatusMap.put("claimstatus", cas_claimnoticebill.getString("claimstatus"));
            this.updateClaimList.add(ClaimStatusMap);
        }
        if (recNo_claimCenterBill.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])recNo_claimCenterBill.values().toArray(new DynamicObject[0]));
        }
        if (payNo_claimCenterBill.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])payNo_claimCenterBill.values().toArray(new DynamicObject[0]));
        }
    }

    private void prepareBatchJob(Boolean isRec, Set<String> sameField, Set<String> tarFieldNames, Set<String> claimNos, Map<String, DynamicObject> no_claimCenterBill) {
        DynamicObject[] bills;
        String entryName = isRec != false ? "entryentity" : "payentity";
        sameField.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_claimbill", (String)entryName));
        Set claimnoticebillFields = EntityPropertyHelper.getEntryPropertys((String)"cas_claimcenterbill", (String)entryName);
        sameField.retainAll(claimnoticebillFields);
        StringBuilder stringBuilder = new StringBuilder("id,tradetime,singlestream,fee,inneraccount,paytype,payeetype,recpayee,recviewpayer,recbasetype,currency,isaddfee,reamount,recbasepayee,claimedamount,unclaimamount,bizdate,claimstatus,billno,recpaytype,paymenttype,recpayer,fee,claimstatus,multireceivingtype,multipaymenttype,entryentity,entryentity.e_claimbill,entryentity.e_claimperson,entryentity.e_claimtype,entryentity.e_billstatus,entryentity.e_sourceentryid,entryentity.seq,payentity.seq,payentity.e_payclaimbill,payentity.e_payclaimperson,payentity.e_payclaimtype,payentity.e_paybillstatus,payentity.e_paysourceentryid,paymentbasetype,recbasepayer,entryentity.recclaimattach,payentity.payclaimattach,");
        for (String field : sameField) {
            stringBuilder.append(entryName).append(".").append(field).append(',');
        }
        if (EmptyUtil.isNoEmpty(tarFieldNames)) {
            stringBuilder.append(tarFieldNames.stream().collect(Collectors.joining(","))).append(",");
        }
        String paySelFieldForClaimCenter = stringBuilder.substring(0, stringBuilder.length() - 1);
        QFilter billnoQf = new QFilter("billno", "in", claimNos);
        for (DynamicObject one : bills = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)paySelFieldForClaimCenter, (QFilter[])new QFilter[]{billnoQf})) {
            no_claimCenterBill.put(one.getString("billno"), one);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] claimAnnouncesArr;
        QFilter qFilter;
        HashSet<Long> mergeIdSet = new HashSet<Long>(this.updateClaimList.size());
        HashMap<String, String> idMapClaimStatus = new HashMap<String, String>(this.updateClaimList.size());
        if (this.updateClaimNoSet.size() > 0) {
            qFilter = new QFilter("claimno", "in", this.updateClaimNoSet);
            DynamicObject[] colls = BusinessDataServiceHelper.load((String)"cas_claimbill", (String)"id,billno,claimno,claimstatus", (QFilter[])new QFilter[]{qFilter});
            Map<String, List<DynamicObject>> no_claimBill = Arrays.stream(colls).collect(Collectors.groupingBy(o -> o.getString("claimno")));
            for (HashMap<Object, String> updateClaimMap : this.updateClaimList) {
                mergeIdSet.add(Long.parseLong(updateClaimMap.get("id")));
                idMapClaimStatus.put(updateClaimMap.get("id"), updateClaimMap.get("claimstatus"));
                String key = updateClaimMap.get("billno");
                String claimStatus = updateClaimMap.get("claimstatus");
                List<DynamicObject> tempList = no_claimBill.get(key);
                for (DynamicObject one : tempList) {
                    if (one.getString("billno").equals(updateClaimMap.get("claimbillbillno")) || claimStatus.equals(one.getString("claimstatus"))) continue;
                    one.set("claimstatus", (Object)claimStatus);
                }
            }
            SaveServiceHelper.save((DynamicObject[])colls);
        }
        if ((claimAnnouncesArr = BusinessDataServiceHelper.load((String)"cas_claimannounce", (String)"id,claimstatus,margeid", (QFilter[])(qFilter = new QFilter("margeid", "in", mergeIdSet)).toArray())) != null && claimAnnouncesArr.length > 0) {
            for (DynamicObject claimAnnounces : claimAnnouncesArr) {
                String mergeId = claimAnnounces.getString("margeid");
                claimAnnounces.set("claimstatus", idMapClaimStatus.get(mergeId));
            }
            SaveServiceHelper.save((DynamicObject[])claimAnnouncesArr);
        }
    }

    public static DynamicObjectCollection claimEntryOrder(DynamicObjectCollection entrys, String billTemp) {
        Boolean billstatus;
        int num = 0;
        for (DynamicObject entry : entrys) {
            billstatus = entry.getBoolean(billTemp);
            int seq = entry.getInt("seq");
            if (billstatus.booleanValue()) continue;
            num = seq > num ? seq : num;
        }
        for (DynamicObject entry : entrys) {
            billstatus = entry.getBoolean(billTemp);
            if (!billstatus.booleanValue()) continue;
            entry.set("seq", (Object)(++num));
        }
        return entrys;
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        this.dataLocker.batchRelease(this.validator.getSuccessLatKeys(), "cas_claimannounce", "ClaimBillClaimAuditOp");
        super.onReturnOperation(e);
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        this.dataLocker.batchRelease(this.validator.getSuccessLatKeys(), "cas_claimannounce", "ClaimBillClaimAuditOp");
    }

    private void fillFieldExtValues(DynamicObject info, DynamicObject cas_claimnoticebill, DynamicObjectCollection claimFieldExtCfgs) {
        claimFieldExtCfgs.stream().forEach(fieldExtCfg -> {
            String extendName = fieldExtCfg.getString("extendname");
            String tarFieldName = fieldExtCfg.getString("tarfieldname");
            int dataType = fieldExtCfg.getInt("datatype");
            Object value = info.get(extendName);
            if (cas_claimnoticebill.containsProperty(tarFieldName) && EmptyUtil.isNoEmpty((Object)value) && DataTypeEnum.getDataTypeByOrdinal((int)dataType) != null) {
                cas_claimnoticebill.set(tarFieldName, DataType.convertValue((DataType)DataTypeEnum.getDataTypeByOrdinal((int)dataType), (Object)value));
            }
        });
    }

    private static /* synthetic */ void lambda$beginOperationTransaction$2(DynamicObject sourceclaim, DynamicObject dy) {
        if (StringUtils.equals((CharSequence)dy.getString("e_claimbill"), (CharSequence)sourceclaim.getString("billno"))) {
            dy.set("e_billstatus", (Object)true);
        }
    }
}

