/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recclaim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.enums.ClaimAuthorityEnum;
import kd.fi.cas.helper.TmcAppCache;
import kd.fi.cas.mutex.impl.DataLocker;
import kd.fi.cas.util.EmptyUtil;

public class ClaimNoticeSaveOp
extends AbstractOperationServicePlugIn {
    private static IAppCache cache = TmcAppCache.get((String)"cas", (String)"intelrec", (String)"claim");
    private Set<String> successLatKeys = new HashSet<String>(2);
    private static final Log LOGGER = LogFactory.getLog(ClaimNoticeSaveOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DataLocker dataLocker = new DataLocker();
        DynamicObject[] dataEntities = e.getDataEntities();
        Set claimNoSet = Arrays.stream(dataEntities).map(o -> o.getString("sourceid")).collect(Collectors.toSet());
        HashSet failedLatKeys = new HashSet(claimNoSet.size());
        dataLocker.batchLock(claimNoSet, this.successLatKeys, failedLatKeys, "cas_claimcenterbill", "ClaimNoticeSaveOp");
        for (DynamicObject dataEntity : dataEntities) {
            String businessType;
            DynamicObject entryObject;
            DynamicObject entryObject2;
            String sourceId = (String)dataEntity.get("sourceid");
            if (failedLatKeys.contains(sourceId)) {
                String msg = String.format(ResManager.loadKDString((String)"\u8ba4\u9886\u901a\u77e5\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u5728\u8bd5\u3002", (String)"ClaimBillAuditValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]), new Object[0]);
                throw new KDBizException(msg);
            }
            EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)dataEntity.getDataEntityType().getName()).findProperty("entryentity1");
            DynamicObjectType dt = prop.getDynamicCollectionItemPropertyType();
            String jsonString = (String)cache.get(sourceId, String.class);
            String rulename = (String)cache.get(sourceId + "rulesname", String.class);
            if (EmptyUtil.isNoEmpty((String)rulename)) {
                dataEntity.set("rulesname", (Object)rulename);
            }
            Map map = (Map)SerializationUtils.fromJsonString((String)jsonString, Map.class);
            List userGroupids = (List)map.get("usergroupids");
            List orgids = (List)map.get("orgids");
            List roleids = (List)map.get("roleids");
            List userids = (List)map.get("userids");
            List userGroupnames = (List)map.get("usergroupnames");
            List orgnames = (List)map.get("orgnames");
            List rolenames = (List)map.get("rolenames");
            HashSet<Object> allUserIds = new HashSet<Object>();
            if (!EmptyUtil.isEmpty((Collection)userGroupids)) {
                for (int i = 0; i < userGroupids.size(); ++i) {
                    entryObject2 = new DynamicObject(dt);
                    entryObject2.set("claimtype", (Object)ClaimAuthorityEnum.USERGROUP.getValue());
                    entryObject2.set("claimtypeid", userGroupids.get(i));
                    dataEntity.getDynamicObjectCollection("entryentity1").add((Object)entryObject2);
                }
                DynamicObjectCollection userGroups = QueryServiceHelper.query((String)"fbd_usergroup", (String)"entryentity.userfield", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)userGroupids).and("enable", "=", (Object)"1")}, null);
                Map enableMap = UserServiceHelper.isUserEnable(userGroups.stream().map(o -> o.getLong("entryentity.userfield")).collect(Collectors.toList()));
                List enableUserIds = enableMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
                allUserIds.addAll(enableUserIds);
            }
            if (!EmptyUtil.isEmpty((Collection)orgids) && !EmptyUtil.isEmpty((Collection)roleids)) {
                int i;
                Set orguserids = UserServiceHelper.getAllUsersOfOrg((int)0, orgids.stream().map(org -> Long.valueOf(org.toString())).collect(Collectors.toList()), (boolean)true, (boolean)false);
                List roleuserids = new ArrayList();
                for (i = 0; i < roleids.size(); ++i) {
                    roleuserids.addAll(PermissionServiceHelper.getUsersByRoleID((String)String.valueOf(roleids.get(i))));
                }
                roleuserids = roleuserids.stream().filter(l -> orguserids.contains(l)).collect(Collectors.toCollection(ArrayList::new));
                for (i = 0; i < roleuserids.size(); ++i) {
                    entryObject = new DynamicObject(dt);
                    entryObject.set("claimtype", (Object)ClaimAuthorityEnum.USER.getValue());
                    entryObject.set("claimtypeid", roleuserids.get(i));
                    dataEntity.getDynamicObjectCollection("entryentity1").add((Object)entryObject);
                }
                allUserIds.addAll(roleuserids);
            } else if (!EmptyUtil.isEmpty((Collection)orgids) && EmptyUtil.isEmpty((Collection)roleids)) {
                for (int i = 0; i < orgids.size(); ++i) {
                    entryObject2 = new DynamicObject(dt);
                    entryObject2.set("claimtype", (Object)ClaimAuthorityEnum.USERORG.getValue());
                    entryObject2.set("claimtypeid", orgids.get(i));
                    dataEntity.getDynamicObjectCollection("entryentity1").add((Object)entryObject2);
                }
                allUserIds.addAll(UserServiceHelper.getAllUsersOfOrg((int)0, orgids.stream().map(org -> Long.valueOf(org.toString())).collect(Collectors.toList()), (boolean)true, (boolean)false));
            } else if (!EmptyUtil.isEmpty((Collection)roleids) && EmptyUtil.isEmpty((Collection)orgids)) {
                for (int i = 0; i < roleids.size(); ++i) {
                    entryObject2 = new DynamicObject(dt);
                    entryObject2.set("claimtype", (Object)ClaimAuthorityEnum.ROLER.getValue());
                    entryObject2.set("claimtypeid", roleids.get(i));
                    dataEntity.getDynamicObjectCollection("entryentity1").add((Object)entryObject2);
                    List permUserIds = PermissionServiceHelper.getUsersByRoleID((String)String.valueOf(roleids.get(i)));
                    Map enableMap = UserServiceHelper.isUserEnable((List)permUserIds);
                    List enableUserIds = enableMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
                    allUserIds.addAll(enableUserIds);
                }
            }
            if (!EmptyUtil.isEmpty((Collection)userids)) {
                Map enableMap = UserServiceHelper.isUserEnable(userids.stream().map(uid -> Long.valueOf(uid.toString())).collect(Collectors.toList()));
                List enableUserIds = enableMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
                for (int i = 0; i < enableUserIds.size(); ++i) {
                    entryObject = new DynamicObject(dt);
                    entryObject.set("claimtype", (Object)ClaimAuthorityEnum.USER.getValue());
                    entryObject.set("claimtypeid", enableUserIds.get(i));
                    dataEntity.getDynamicObjectCollection("entryentity1").add((Object)entryObject);
                }
                allUserIds.addAll(enableUserIds);
            }
            if (!EmptyUtil.isEmpty((Collection)userGroupnames)) {
                dataEntity.set("joinclaim", (Object)String.join((CharSequence)",", userGroupnames));
            }
            if (!EmptyUtil.isEmpty((Collection)orgnames)) {
                dataEntity.set("joinunit", (Object)String.join((CharSequence)",", orgnames));
            }
            if (!EmptyUtil.isEmpty((Collection)rolenames)) {
                dataEntity.set("joinrule", (Object)String.join((CharSequence)",", rolenames));
            }
            if (!EmptyUtil.isEmpty(allUserIds)) {
                DynamicObjectCollection userNames = QueryServiceHelper.query((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", allUserIds)});
                String claimusers = String.join((CharSequence)",", userNames.stream().map(dy -> dy.getString("name")).collect(Collectors.toCollection(HashSet::new)));
                dataEntity.set("claimusers", (Object)(claimusers.length() > 1024 ? claimusers.substring(0, 1024) : claimusers));
            }
            if (!"rec".equals(businessType = dataEntity.getString("businesstype"))) continue;
            dataEntity.set("draftbilltype", null);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        List writeBackTransList = Arrays.stream(e.getDataEntities()).filter(d -> "bei_transdetail".equals(d.getString("sourcetype")) && EmptyUtil.isNoEmpty((Object)d.get("sourceid"))).map(d -> {
            HashMap<String, Object> param = new HashMap<String, Object>(4);
            param.put("claimId", d.getLong("id"));
            param.put("transDetailId", d.getLong("sourceid"));
            param.put("ruleName", EmptyUtil.isNoEmpty((String)d.getString("rulesname")) ? d.getString("rulesname") : " ");
            return param;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(writeBackTransList)) {
            try {
                List businessList = writeBackTransList.stream().map(w -> Objects.toString(w.get("claimId"), "")).collect(Collectors.toList());
                CommonParam commonParam = new CommonParam();
                commonParam.put((Object)"paramList", writeBackTransList);
                ECGlobalSession.begin((String)"cas_claim_write_back", (DBRoute)DBRoute.of((String)"cas"), (boolean)true);
                ECGlobalSession.setBusinessType((String)"cas_claim_write_back");
                ECGlobalSession.setBusinessInfo(businessList);
                ECGlobalSession.setAsync((boolean)true);
                ECGlobalSession.register((String)"tmc", (String)"bei", (String)"ClaimWriteBackTransEcService", (Param)commonParam, null, (String)"");
            }
            catch (Exception ex) {
                LOGGER.error("writeBackTransDetailRuleName errer:", (Throwable)ex);
            }
        }
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        DataLocker dataLocker = new DataLocker();
        dataLocker.batchRelease(this.successLatKeys, "cas_claimcenterbill", "ClaimNoticeSaveOp");
        super.onReturnOperation(e);
        for (String successSourceId : this.successLatKeys) {
            cache.remove(successSourceId);
            cache.remove(successSourceId + "rulesname");
        }
    }

    public void rollbackOperation(RollbackOperationArgs e) {
        DataLocker dataLocker = new DataLocker();
        dataLocker.batchRelease(this.successLatKeys, "cas_claimcenterbill", "ClaimNoticeSaveOp");
        for (String successSourceId : this.successLatKeys) {
            cache.remove(successSourceId);
            cache.remove(successSourceId + "rulesname");
        }
    }
}

