/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.opplugin.recclaim;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.ClaimAuthorityEnum;
import kd.fi.cas.enums.MergeStatusEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.RecClaimHelper;
import kd.fi.cas.validator.recclaim.RecClaimCancelNoticeValidator;

public class RecClaimCancelNoticeOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("billno");
        lst.add("claimstatus");
        lst.add("sourceid");
        lst.add("entryentity1.claimtype");
        lst.add("entryentity1.claimtypeid");
        lst.add("currency");
        lst.add("reamount");
        lst.add("oppunit");
        lst.add("description");
        lst.add("tradetime");
        lst.add("tradedetailno");
        lst.add("isunclaim");
        lst.add("mergestatus");
        lst.add("businesstype");
        lst.add("payamount");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new RecClaimCancelNoticeValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        Serializable recAmount;
        super.beforeExecuteOperationTransaction(e);
        HashSet<Object> infos = new HashSet<Object>(e.getDataEntities().length);
        HashMap claimType = new HashMap(e.getDataEntities().length);
        HashMap<String, List<Object>> typeValue = null;
        DynamicObjectCollection dycoll = null;
        ArrayList<String> noticeMes = null;
        StringBuilder message = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-M-dd");
        ArrayList<Long> idList = new ArrayList<Long>(10);
        for (DynamicObject info : e.getDataEntities()) {
            idList.add(info.getLong("id"));
            typeValue = new HashMap<String, List<Object>>();
            dycoll = info.getDynamicObjectCollection("entryentity1");
            typeValue.put("userids", dycoll.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimAuthorityEnum.USER.getValue(), (CharSequence)dy.getString("claimtype"))).map(dy -> dy.get("claimtypeid")).collect(Collectors.toList()));
            typeValue.put("usergroupids", dycoll.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimAuthorityEnum.USERGROUP.getValue(), (CharSequence)dy.getString("claimtype"))).map(dy -> dy.getLong("claimtypeid")).collect(Collectors.toList()));
            typeValue.put("orgids", dycoll.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimAuthorityEnum.USERORG.getValue(), (CharSequence)dy.getString("claimtype"))).map(dy -> dy.get("claimtypeid")).collect(Collectors.toList()));
            typeValue.put("roleids", dycoll.stream().filter(dy -> StringUtils.equals((CharSequence)ClaimAuthorityEnum.ROLER.getValue(), (CharSequence)dy.getString("claimtype"))).map(dy -> dy.get("claimtypeid")).collect(Collectors.toList()));
            message.setLength(0);
            noticeMes = new ArrayList<String>();
            recAmount = info.getBigDecimal("reamount");
            BigDecimal payAmount = info.getBigDecimal("payamount");
            Serializable amount = ((BigDecimal)recAmount).compareTo(BigDecimal.ZERO) != 0 ? recAmount : payAmount;
            String bizType = info.getString("businesstype");
            String bizTypeStr = "rec".equals(bizType) ? ResManager.loadKDString((String)"\u6536\u6b3e", (String)"RecClaimCancelNoticeOp_3", (String)"", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed8\u6b3e", (String)"RecClaimCancelNoticeOp_4", (String)"", (Object[])new Object[0]);
            String curSign = info.getDynamicObject("currency").getString("sign");
            String amountStr = CasHelper.formatDecimal((BigDecimal)amount, (int)2);
            noticeMes.add(String.format(ResManager.loadKDString((String)"1\u7b14%1$s\uff08\u91d1\u989d\uff1a%2$s%3$s\uff09\u5df2\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\u3002", (String)"RecClaimCancelNoticeOp_0", (String)"fi-cas-opplugin", (Object[])new Object[0]), bizTypeStr, curSign, amountStr));
            typeValue.put("title", noticeMes);
            message.setLength(0);
            noticeMes = new ArrayList();
            message.append(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b%1$s\u5df2\u53d6\u6d88\u901a\u77e5\u8ba4\u9886\uff0c\u8bf7\u8fdb\u5165%2$s\u5165\u8d26\u4e2d\u5fc3\u67e5\u770b\u8be6\u60c5\uff1a", (String)"RecClaimCancelNoticeOp_2", (String)"fi-cas-opplugin", (Object[])new Object[0]), bizTypeStr, bizTypeStr));
            message.append("\r\n");
            String desc = info.getString("description") == null ? "" : info.getString("description");
            message.append(String.format(ResManager.loadKDString((String)"%1$s\u91d1\u989d\uff1a%2$s%3$s\uff0c\u5bf9\u65b9\u6237\u540d\uff1a%4$s\uff0c\u6458\u8981\uff1a%5$s\uff0c\u4ea4\u6613\u65f6\u95f4\uff1a%6$s\uff0c\u4ea4\u6613\u660e\u7ec6\u7f16\u53f7\uff1a%7$s\uff0c\u8bf7\u77e5\u6089\u3002", (String)"RecClaimCancelNoticeOp_1", (String)"", (Object[])new Object[0]), bizTypeStr, curSign, amountStr, info.getString("oppunit"), desc, sdf.format(info.getDate("tradetime")), info.getString("tradedetailno")));
            noticeMes.add(message.toString());
            typeValue.put("content", noticeMes);
            typeValue.put("biztype", Collections.singletonList(bizType));
            claimType.put(info.getPkValue(), typeValue);
            infos.add(info.getPkValue());
        }
        QFilter margeid = new QFilter("margeid", "in", idList).and(new QFilter("mergestatus", "=", (Object)MergeStatusEnum.MARFED.getValue()));
        DynamicObject[] childClaim = BusinessDataServiceHelper.load((String)"cas_claimcenterbill", (String)"id", (QFilter[])new QFilter[]{margeid});
        infos.addAll(Arrays.stream(childClaim).map(o -> o.getPkValue()).collect(Collectors.toList()));
        if (infos.size() > 0) {
            OperationResult execOperate = null;
            TXHandle tx = TX.requiresNew();
            recAmount = null;
            try {
                execOperate = OperateServiceHelper.execOperate((String)"delete", (String)"cas_claimcenterbill", (Object[])infos.toArray(), (OperateOption)OperateOption.create());
            }
            catch (Throwable throwable) {
                recAmount = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (recAmount != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)recAmount).addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            HashMap claimTypeTemp = new HashMap(infos.size());
            List successPkid = execOperate.getSuccessPkIds();
            for (Map.Entry claim : claimType.entrySet()) {
                if (!successPkid.contains(claim.getKey())) continue;
                claimTypeTemp.put(claim.getKey(), claim.getValue());
            }
            if (ExtendConfigHelper.shouldSendCancelClaimMsg()) {
                RecClaimHelper.sendClaimNoticeMessage(claimTypeTemp, (String)"cancel");
            }
        }
    }
}

