/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.enums.HotAccountEnum;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.PayBillCrossHelper;
import kd.fi.cas.helper.PaymentBillPluginHelper;
import kd.fi.cas.helper.SettleRecordQueryHelperForCas;
import kd.fi.cas.util.EmptyUtil;

public class PaymentCancelPayValidator
extends AbstractValidator {
    private static final List<String> SOURCE_OR_PAYMENT_TYPE = Arrays.asList("fca_transupbill", "fca_transdownbill", "bei_intelpay", "216", "212");

    public void validate() {
        LinkedList<Long> paymentBillPks = new LinkedList<Long>();
        LinkedList<Long> paymentBillIds = new LinkedList<Long>();
        Set acctIds = ((Stream)Arrays.stream(this.dataEntities).parallel()).filter(d -> EmptyUtil.isNoEmpty((DynamicObject)d.getDataEntity().getDynamicObject("payeracctbank"))).map(d -> d.getDataEntity().getDynamicObject("payeracctbank").getLong("id")).collect(Collectors.toSet());
        Set ifmAccIds = PayBillCrossHelper.getIfmAccIds(acctIds);
        List ids = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getString("id")).collect(Collectors.toList());
        Map targetMaps = CasBotpHelper.getTargetBillIdMap((String)"cas_paybill", ids.stream().map(Long::parseLong).collect(Collectors.toList()), null, Stream.of("ifm_payacceptancebill").collect(Collectors.toSet()), (boolean)true);
        List lockedIds = TxCheckUtil.getLocked(ids);
        String isLock = "false";
        if (this.getOption().containsVariable("isLock")) {
            isLock = this.getOption().getVariableValue("isLock");
        }
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObjectCollection entrys;
            BigDecimal settleAmt;
            DynamicObject payerAcctBank;
            Map thisTargetMaps;
            if (!targetMaps.isEmpty() && targetMaps.containsKey(data.getDataEntity().getLong("id")) && !(thisTargetMaps = (Map)targetMaps.get(data.getDataEntity().getLong("id"))).isEmpty() && thisTargetMaps.containsKey("ifm_payacceptancebill")) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u5185\u90e8\u7ed3\u7b97\u53d7\u7406\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"PaymentCancelPayValidator_30", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if (!"true".equals(isLock) && lockedIds.contains(data.getDataEntity().getString("id"))) {
                String error = ResManager.loadKDString((String)"\u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"PaymentCancelPayValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                this.addMessage(data, error, ErrorLevel.Error);
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(payerAcctBank = data.getDataEntity().getDynamicObject("payeracctbank"))) && "closed".equals(payerAcctBank.getString("acctstatus"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u72b6\u6001\u662f\u5df2\u9500\u6237\u72b6\u6001\u4e0d\u5141\u8bb8\u64cd\u4f5c\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"PaymentCancelPayValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            boolean isCheck = true;
            String source = data.getDataEntity().getString("sourcebilltype");
            DynamicObject paymenttype = data.getDataEntity().getDynamicObject("paymenttype");
            if (SOURCE_OR_PAYMENT_TYPE.contains(source) || SOURCE_OR_PAYMENT_TYPE.contains(paymenttype.getString("biztype"))) {
                isCheck = false;
            }
            if (isCheck && payerAcctBank != null && ifmAccIds.contains(payerAcctBank.getLong("id")) && PaymentBillPluginHelper.paymentIdentify((DynamicObject)data.getDataEntity())) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5185\u90e8\u8d26\u6237\u4e0d\u5141\u8bb8\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"PaymentCancelPayValidator_3", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if ((settleAmt = (entrys = data.getDataEntity().getDynamicObjectCollection("entry")).stream().filter(o -> o.getBigDecimal("e_settledamt").compareTo(BigDecimal.ZERO) > 0).map(o -> o.getBigDecimal("e_settledamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)).compareTo(BigDecimal.ZERO) > 0) {
                paymentBillPks.add((Long)data.getBillPkId());
            }
            paymentBillIds.add((Long)data.getBillPkId());
        }
        HashSet paymentPksWithSettleRecordsVouchered = new HashSet();
        if (!paymentBillPks.isEmpty()) {
            QFilter otherFilter = new QFilter("isvoucher", "=", (Object)"1");
            List mainBillIds = SettleRecordQueryHelperForCas.getBillIdsByMain((String)"ap_settlerecord", (String)"cas_paybill", (Object[])paymentBillPks.toArray(), (QFilter)otherFilter);
            List asstBillIds = SettleRecordQueryHelperForCas.getBillIdsByAsst((String)"ap_settlerecord", (String)"cas_paybill", (Object[])paymentBillPks.toArray(), (QFilter)otherFilter);
            paymentPksWithSettleRecordsVouchered.addAll(mainBillIds);
            paymentPksWithSettleRecordsVouchered.addAll(asstBillIds);
        }
        Map<Long, DynamicObject> feePayBills = this.getFeePayBills(paymentBillIds);
        DynamicObject[] payments = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,hotaccount", (QFilter[])new QFilter[]{new QFilter("id", "in", paymentBillIds)});
        HashMap paymentMap = new HashMap(payments.length);
        Arrays.stream(payments).forEach(o -> paymentMap.put(o.getLong("id"), o));
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject payBill;
            Long billPkId = (Long)data.getBillPkId();
            if (paymentPksWithSettleRecordsVouchered.contains(billPkId)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5bf9\u5e94\u7684\u7ed3\u7b97\u8bb0\u5f55\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"PaymentCancelPayValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
            if ((payBill = (DynamicObject)paymentMap.get(billPkId)) == null || !HotAccountEnum.HOTBILL.getValue().equals(payBill.get("hotaccount")) && !HotAccountEnum.HOTEDBILL.getValue().equals(payBill.get("hotaccount"))) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5df2\u53d1\u751f\u7ea2\u51b2\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u4ed8\u6b3e\u3002", (String)"PaymentCancelPayValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }

    private Map<Long, DynamicObject> getFeePayBills(List<Long> paymentBillIds) {
        QFilter[] filters = new QFilter[]{new QFilter("sourcebillid", "in", paymentBillIds), new QFilter("sourcebilltype", "=", (Object)"cas_paybill"), new QFilter("feepay", "=", (Object)true)};
        DynamicObject[] feePays = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,sourcebillid,billno,org.name,billstatus", (QFilter[])filters);
        HashMap<Long, DynamicObject> feePayBills = new HashMap<Long, DynamicObject>(feePays.length);
        Arrays.stream(feePays).forEach(o -> feePayBills.put(o.getLong("sourcebillid"), (DynamicObject)o));
        return feePayBills;
    }
}

