/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.util.EmptyUtil;

public class RecDraftSaveValidator
extends AbstractValidator {
    private static final List<String> draftTypeSet = Arrays.asList("5", "6", "1", "2");

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Object draftnameSet;
            DynamicObject info = dataEntity.getDataEntity();
            BigDecimal recAmount = info.getBigDecimal("actrecamt");
            DynamicObjectCollection draftInfoEntrys = info.getDynamicObjectCollection("cas_draftinfo");
            DynamicObjectCollection draftBillColl = (DynamicObjectCollection)info.get("draftbill");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)draftBillColl)) continue;
            List draftBillIdList = draftBillColl.stream().map(i -> i.getLong("fbasedataid.id")).collect(Collectors.toList());
            boolean isNotDraftType = this.juadgeIsNotDraftType(info);
            boolean isHotCount = BigDecimal.ZERO.compareTo(recAmount) > 0;
            String sourcebilltype = info.getString("sourcebilltype");
            boolean isFromCasRec = "cas_recbill".equals(sourcebilltype);
            boolean isFromTradeBill = "cdm_drafttradebill".equals(sourcebilltype);
            boolean isFromHotAccountPush = false;
            if (isFromCasRec && !isHotCount) {
                long sourceId = info.getLong("sourcebillid");
                isFromHotAccountPush = QueryServiceHelper.exists((String)"cas_recbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceId), new QFilter("actrecamt", "<", (Object)BigDecimal.ZERO)});
            }
            boolean isNotHotAccount = !isHotCount || !isFromCasRec;
            String name = info.getDynamicObjectType().getName();
            boolean isRecBill = "cas_recbill".equals(name);
            if (!isNotDraftType && isNotHotAccount && !isFromHotAccountPush && isRecBill && !isFromTradeBill) {
                QFilter filter = new QFilter("draftbill.fbasedataid.id", "in", draftBillIdList);
                QFilter filterId = new QFilter("id", "!=", (Object)info.getLong("id"));
                HashSet<String> statusSet = new HashSet<String>(6);
                statusSet.add(BillStatusEnum.DEAD.getValue());
                statusSet.add(BillStatusEnum.CHARGEBANK.getValue());
                filter.and("billstatus", "not in", statusSet);
                HashSet<String> notNeedJuadgeSet = new HashSet<String>(6);
                notNeedJuadgeSet.add("cdm_drafttradebill");
                notNeedJuadgeSet.add("cas_claimcenterbill");
                filter.and("sourcebilltype", "not in", notNeedJuadgeSet);
                filter.and("actrecamt", ">", (Object)BigDecimal.ZERO);
                filter.and("settletype.settlementtype", "in", draftTypeSet);
                DynamicObjectCollection cas_recbills = QueryServiceHelper.query((String)"cas_recbill", (String)"draftbill.fbasedataid.id as draftid,draftbill.fbasedataid.billno as draftname", (QFilter[])new QFilter[]{filter, filterId});
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)cas_recbills)) {
                    draftnameSet = cas_recbills.stream().map(e -> e.getString("draftname")).collect(Collectors.toList());
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e %s \u5df2\u7ecf\u88ab\u5176\u4ed6\u975e\u4f5c\u5e9f\u975e\u5df2\u9000\u5355\u7684\u6536\u6b3e\u5355\u5173\u8054\u3002", (String)"RecBillSelectDraftEdit_0_1", (String)"fi-cas-opplugin", (Object[])new Object[]{draftnameSet.get(0)}));
                    continue;
                }
            }
            ArrayList logIdList = new ArrayList(10);
            BigDecimal totalDealAmount = BigDecimal.ZERO;
            ArrayList<Long> saveLogIdList = new ArrayList<Long>(10);
            draftInfoEntrys.stream().filter(v -> !EmptyUtil.isEmpty((Long)v.getLong("draftbilllogid"))).forEach(v -> logIdList.add(v.getLong("draftbilllogid")));
            if (!EmptyUtil.isEmpty(logIdList)) {
                QFilter qFilter = new QFilter("id", "in", logIdList);
                DynamicObject[] draftBillLogs = BusinessDataServiceHelper.load((String)"cdm_draftbill_log", (String)"id,draftid,dealamount", (QFilter[])qFilter.toArray());
                draftnameSet = draftBillIdList.iterator();
                while (draftnameSet.hasNext()) {
                    long daftBillId = (Long)draftnameSet.next();
                    for (DynamicObject draftBillLog : draftBillLogs) {
                        if (daftBillId != draftBillLog.getLong("draftid")) continue;
                        totalDealAmount = totalDealAmount.add(draftBillLog.getBigDecimal("dealamount"));
                        saveLogIdList.add(daftBillId);
                    }
                }
            }
            draftBillIdList.removeAll(saveLogIdList);
            DynamicObject[] draftDataArr = BusinessDataServiceHelper.load((Object[])draftBillIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_payandrecdraft_f7"));
            BigDecimal billAmount = Arrays.stream(draftDataArr).map(i -> i.getBigDecimal("availableamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            String fromRecClaim = this.getOption().getVariableValue("fromRecClaim", "false");
            boolean isFromclaim = "cas_claimcenterbill".equals(sourcebilltype);
            billAmount = billAmount.add(totalDealAmount);
            if (recAmount.compareTo(billAmount) == 0 || "true".equals(fromRecClaim) || isFromclaim || isFromTradeBill && isNotDraftType) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7968\u636e\u53ef\u7528\u91d1\u989d\u5408\u8ba1\u9700\u4e0e\u6536\u6b3e\u5355\u91d1\u989d\u76f8\u540c", (String)"RecBillSelectDraftEdit_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean juadgeIsNotDraftType(DynamicObject info) {
        boolean isNotDraft = false;
        DynamicObject settleType = info.getDynamicObject("settletype");
        if (EmptyUtil.isNoEmpty((DynamicObject)settleType)) {
            String settlementtype = settleType.getString("settlementtype");
            isNotDraft = !draftTypeSet.contains(settlementtype);
        }
        return isNotDraft;
    }
}

