/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.Pair;
import kd.fi.cas.business.opservice.helper.PaymentServiceHelper;
import kd.fi.cas.business.writeback.WriteBackConfigInvoker;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.ar.ArWriteBackHelper;
import kd.fi.cas.business.writeback.ar.bean.Result;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.business.writeback.refund.CancelRefundWriteBackConsumer;
import kd.fi.cas.consts.RefundConstants;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.helper.RefundHelper;
import kd.fi.cas.opplugin.refund.RefundWriteBackHelper;
import kd.fi.cas.refund.RefundEntryInfo;
import kd.fi.cas.refund.RefundPayBillInfo;
import kd.fi.cas.refund.RefundRenoteOrCancelParam;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.ArrayUtils;

public class ReceivingBillCancelRefundValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(ReceivingBillCancelRefundValidator.class);
    private DynamicObject[] bills;
    private Map<Long, DynamicObject> entrustSourceBills;

    public ReceivingBillCancelRefundValidator(DynamicObject[] bills, Map<Long, DynamicObject> entrustSourceBills) {
        this.bills = bills;
        this.entrustSourceBills = entrustSourceBills;
    }

    public ReceivingBillCancelRefundValidator() {
    }

    public void validate() {
        DynamicObject revBill = this.dataEntities[0].getDataEntity();
        if (!revBill.getBoolean("isrefund")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u672a\u8fdb\u884c\u9000\u6b3e\u6216\u9000\u7968\uff0c\u65e0\u6cd5\u53d6\u6d88\u3002", (String)"ReceivingBillCancelRefundValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
        }
        if (ArrayUtils.isEmpty((Object[])this.bills)) {
            String msg = ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u672a\u67e5\u5230\u5173\u8054\u7684\u5355\u636e,\u8bf7\u68c0\u67e5\u3002", (String)"ReceivingBillCancelRefundValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        if ("cas_paybill".equals(this.bills[0].getDataEntityType().getName())) {
            this.checkPayBills(revBill);
        } else {
            this.checkAgentBills(revBill);
        }
    }

    private void checkPayBills(DynamicObject revBill) {
        Long revId = (Long)revBill.getPkValue();
        List businessIds = Stream.of(this.bills).map(p -> String.valueOf(p.getPkValue())).collect(Collectors.toList());
        businessIds.add(String.valueOf(revId));
        List lockedIds = TxCheckUtil.getLocked(businessIds);
        if (CollectionUtils.containsAny((Collection)lockedIds, businessIds)) {
            String error = ResManager.loadKDString((String)"\u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"PaymentCancelPayValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            throw new KDBizException(error);
        }
        DynamicObject[] fromApplyPayBills = (DynamicObject[])Arrays.stream(this.bills).filter(bill -> StringUtils.equals((CharSequence)bill.getString("sourcebilltype"), (CharSequence)"cas_payapplybill")).toArray(DynamicObject[]::new);
        Pair pair = RefundHelper.getPayBillRelaPayApplyData((DynamicObject[])fromApplyPayBills);
        Map payIdAndPayApplyBillMap = (Map)pair.getKey();
        Map payEntryIdAndPayApplyEntryMap = (Map)pair.getValue();
        Map<Long, List<DynamicObject>> payBillsForFeelBillMap = this.queryPayBillsForFeelBill(this.bills);
        for (DynamicObject payBill : this.bills) {
            String sourceBillType = payBill.getString("sourcebilltype");
            if ("F".equals(payBill.getString("billstatus")) && RefundConstants.TRADE_BILL_TYPE.contains(sourceBillType)) {
                String string = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5b58\u5728\u4e0a\u6e38:%s\u4e0d\u5141\u8bb8\u64cd\u4f5c\u53d6\u6d88\u9000\u7968\u3002", (String)"ReceivingBillCancelRefundValidator_4", (String)"fi-cas-opplugin", (Object[])new Object[0]), payBill.getString("sourcebillnumber"));
                throw new KDBizException(string);
            }
            Long l = payBill.getLong("sourcebillid");
            if (EmptyUtil.isNoEmpty((Long)l) && "lc_arrival".equals(sourceBillType)) {
                DynamicObject entry;
                String payNo;
                DynamicObject arrival = BusinessDataServiceHelper.loadSingle((Object)l, (String)"lc_arrival");
                DynamicObjectCollection entrys = arrival.getDynamicObjectCollection("entrys");
                String billNo = payBill.getString("billno");
                for (int i = entrys.size() - 1; i >= 0 && !billNo.equals(payNo = (entry = (DynamicObject)entrys.get(i)).getString("payno")); --i) {
                    String operateType = entry.getString("operatetype");
                    if (!"payment".equals(operateType)) continue;
                    String msg = ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u786e\u8ba4\u9000\u7968\u65f6\u9009\u62e9\u7684\u4ed8\u6b3e\u5355\u5173\u8054\u7684\u4fe1\u7528\u8bc1\u5230\u5355\u5df2\u91cd\u65b0\u4ed8\u6b3e\uff0c\u4e0d\u5141\u8bb8\u518d\u53d6\u6d88\u786e\u8ba4\u9000\u6b3e\u9000\u7968\u3002", (String)"ReceivingBillCancelRefundValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]);
                    throw new KDBizException(msg);
                }
            }
            if (EmptyUtil.isNoEmpty(payBillsForFeelBillMap.get(l))) {
                ReceivingBillCancelRefundValidator.feeBillCancelRefundVerify(payBillsForFeelBillMap.get(l), l, payBill);
            }
            DynamicObject payApply = (DynamicObject)payIdAndPayApplyBillMap.get(payBill.getLong("id"));
            for (DynamicObject entry : payBill.getDynamicObjectCollection("entry")) {
                if (!EmptyUtil.isNoEmpty((DynamicObject)payApply) || !payApply.getBoolean("refundandrepay")) continue;
                DynamicObject currentPayApplyEntry = (DynamicObject)payEntryIdAndPayApplyEntryMap.get(entry.getLong("id"));
                long entryRelaRecBillId = revBill.getLong("id");
                DynamicObjectCollection payInfoEntries = payApply.getDynamicObjectCollection("cas_payinfo");
                if (!EmptyUtil.isNoEmpty((DynamicObject)currentPayApplyEntry)) continue;
                long entryRelaEntryId = currentPayApplyEntry.getLong("id");
                String refundType = revBill.getString("refundtype");
                logger.info("[checkPayBills]\u4e0e\u4ed8\u6b3e\u7533\u8bf7\u5355\u5bf9\u5e94\u5206\u5f55\u8fdb\u884c\u6821\u9a8c\uff0c\u9000\u6b3e\u7c7b\u578b\uff1a{}\uff0c\u4ed8\u6b3e\u5355\u5206\u5f55Id\uff1a{}\uff0c\u7533\u8bf7\u5355\u5206\u5f55id\uff1a{}\uff0c\u7533\u8bf7\u5355\u5206\u5f55\u662f\u5426\u9000\u7968\uff1a{}\uff0c\u7533\u8bf7\u5355\u5206\u5f55\u662f\u5426\u9000\u6b3e\uff1a{}", new Object[]{refundType, entry.getLong("id"), currentPayApplyEntry.getPkValue(), currentPayApplyEntry.getBoolean("entry_backbill"), currentPayApplyEntry.getBoolean("entry_refund")});
                logger.info("[checkPayBills]\u4e0e\u4ed8\u6b3e\u7533\u8bf7\u5355\u5bf9\u5e94\u5206\u5f55\u8fdb\u884c\u6821\u9a8c\uff0c\u4ed8\u6b3e\u5355\u6240\u6709\u5206\u5f55id\uff1a{}", payEntryIdAndPayApplyEntryMap.keySet());
                List resultList = payInfoEntries.stream().filter(e -> entryRelaEntryId == e.getLong("entry_relaentryid") && entryRelaRecBillId == e.getLong("entry_relarecbillid")).collect(Collectors.toList());
                if (!EmptyUtil.isNoEmpty(resultList)) continue;
                if ("renote".equals(refundType) && !currentPayApplyEntry.getBoolean("entry_backbill") || "refund".equals(refundType) && !currentPayApplyEntry.getBoolean("entry_refund")) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5173\u8054\u4ed8\u6b3e\u7533\u8bf7\u5355\u7684\u201c\u9000\u6b3e/\u9000\u7968\u201d\u5fc5\u987b\u4e3a\u201c\u662f\u201d\u3002", (String)"RevBillRefundRenoteValidator_0", (String)"fi-cas-opplugin", (Object[])new Object[0]));
                }
                if (!resultList.stream().anyMatch(e -> !StringUtils.equals((CharSequence)e.getString("entry_paystatus"), (CharSequence)PayStatusEnum.NOTPAYING.getValue()) && !StringUtils.equals((CharSequence)e.getString("entry_paystatus"), (CharSequence)PayStatusEnum.CLANCEL.getValue()))) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5173\u8054\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u5df2\u518d\u6b21\u4e0b\u63a8\u4ed8\u6b3e\u5904\u7406\u5355\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u9000\u6b3e\u9000\u7968\u3002", (String)"RevBillRefundRenoteValidator_1", (String)"fi-cas-opplugin", (Object[])new Object[0]));
            }
        }
        List writeBackBills = Arrays.stream(this.bills).filter(b -> !PaymentServiceHelper.isEntrustTargetPayBill((DynamicObject)b)).collect(Collectors.toList());
        Map<String, List<DynamicObject>> billBySourceMap = writeBackBills.stream().filter(b -> !PaymentServiceHelper.isEntrustTargetPayBill((DynamicObject)b)).collect(Collectors.groupingBy(p -> p.getString("sourcebilltype")));
        WriteBackOperateEnum operate = "refund".equals(revBill.getString("refundtype")) ? WriteBackOperateEnum.CANCELREFUNDVALIDATE : WriteBackOperateEnum.CANCELRENOTEVALIDATE;
        ArrayList<RefundRenoteOrCancelParam> refundParams = new ArrayList<RefundRenoteOrCancelParam>(billBySourceMap.size());
        for (Map.Entry entry : billBySourceMap.entrySet()) {
            String sourceBillType = (String)entry.getKey();
            List payBillList = (List)entry.getValue();
            try {
                Result sourceValidatorResult;
                CancelRefundWriteBackConsumer cancelConsumer = new CancelRefundWriteBackConsumer(revId, payBillList);
                RefundRenoteOrCancelParam cancelParam = cancelConsumer.initInvokeParams("cas_paybill", sourceBillType, operate);
                refundParams.add(cancelParam);
                if (ArWriteBackHelper.isArApSourceType((String)sourceBillType)) continue;
                this.checkPurchaseBill(sourceBillType, cancelParam);
                Object sourceValidatorRes = WriteBackTaskHelper.batchAddWriteBackTask((DynamicObject[])payBillList.toArray(new DynamicObject[0]), (String)sourceBillType, (WriteBackOperateEnum)operate, (WriteBackConfigInvoker)cancelConsumer, null);
                if (sourceValidatorRes == null || "0".equals((sourceValidatorResult = (Result)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)sourceValidatorRes), Result.class)).getCode())) continue;
                throw new KDBizException(sourceValidatorResult.getErrorInfo());
            }
            catch (Exception e2) {
                logger.error("cancel refund or renote validator error", (Throwable)e2);
                throw new KDBizException(e2.getMessage());
            }
        }
        if (this.entrustSourceBills.isEmpty()) {
            ArWriteBackHelper.arApValidate((Long)revId, (WriteBackOperateEnum)operate, refundParams, (String)"CancelRefundAndRenoteValidateService");
        } else {
            List billList = Arrays.stream(this.bills).collect(Collectors.toList());
            RefundRenoteOrCancelParam refundRenoteOrCancelParam = ArWriteBackHelper.buildApCancelRefundParam((Long)revId, billList, this.entrustSourceBills, (WriteBackOperateEnum)operate);
            ArWriteBackHelper.arApValidate((Long)revId, (WriteBackOperateEnum)operate, Collections.singletonList(refundRenoteOrCancelParam), (String)"CancelRefundAndRenoteValidateService");
        }
    }

    private void checkAgentBills(DynamicObject revBill) {
        Long revId = (Long)revBill.getPkValue();
        WriteBackOperateEnum operate = "refund".equals(revBill.getString("refundtype")) ? WriteBackOperateEnum.CANCELREFUNDVALIDATE : WriteBackOperateEnum.CANCELRENOTEVALIDATE;
        RefundWriteBackHelper.agentWriteBack((Long)revId, (WriteBackOperateEnum)operate, (DynamicObject[])this.bills);
    }

    private Map<Long, List<DynamicObject>> queryPayBillsForFeelBill(DynamicObject[] payBills) {
        Map<Long, List<Object>> latestPayBillMap = new HashMap<Long, List<DynamicObject>>(payBills.length);
        Set feeBillIds = Arrays.stream(payBills).filter(payBill -> EmptyUtil.isNotEmpty((String)payBill.getString("sourcebilltype")) && "cfm_feebill".equals(payBill.getString("sourcebilltype"))).map(payBill -> payBill.getLong("sourcebillid")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(feeBillIds)) {
            return latestPayBillMap;
        }
        QFilter payFilter = new QFilter("sourcebillid", "in", feeBillIds);
        DynamicObjectCollection latestPayBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billstatus,sourcebillid,createtime", (QFilter[])payFilter.toArray());
        latestPayBillMap = latestPayBills.stream().collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("sourcebillid"), Collectors.collectingAndThen(Collectors.toList(), groups -> groups.stream().sorted(Comparator.comparing(pay -> ((DynamicObject)pay).getDate("createtime")).reversed()).collect(Collectors.toList()))));
        return latestPayBillMap;
    }

    private static void feeBillCancelRefundVerify(List<DynamicObject> payBills, Long feeBillId, DynamicObject currentPayBill) {
        DynamicObject latestPayBill = payBills.get(0);
        String payBillStatus = latestPayBill.getString("billstatus");
        if (!BillStatusEnum.RENOTE.getValue().equals(payBillStatus) && !BillStatusEnum.REFUND.getValue().equals(payBillStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5173\u8054\u8d39\u7528\u660e\u7ec6\u5355\u5b58\u5728\u5728\u9014\u7684\u4ed8\u6b3e\u5904\u7406\u5355\u3002", (String)"ReceivingBillRefundPlugin_8", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        DynamicObject feeBill = QueryServiceHelper.queryOne((String)"cfm_feebill", (String)"id,issettle", (QFilter[])new QFilter("id", "=", (Object)feeBillId).toArray());
        boolean issettle = feeBill.getBoolean("issettle");
        if (issettle) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5173\u8054\u8d39\u7528\u660e\u7ec6\u5355\u7684\u201c\u5df2\u7ed3\u7b97\u201d\u4e0d\u4e3a\u5426\u3002", (String)"ReceivingBillRefundPlugin_9", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
        long latestPayBillId = latestPayBill.getLong("id");
        long currentPayBillId = currentPayBill.getLong("id");
        if (EmptyUtil.isNoEmpty((Long)latestPayBillId) && EmptyUtil.isNoEmpty((Long)currentPayBillId) && latestPayBillId != currentPayBillId) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u5904\u7406\u5355\u4e0d\u662f\u6700\u8fd1\u4e00\u6b21\u8fdb\u884c\u9000\u6b3e\u9000\u7968\u7684\u5173\u8054\u5355\u636e\u3002", (String)"ReceivingBillRefundPlugin_12", (String)"fi-cas-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkPurchaseBill(String sourceBillType, RefundRenoteOrCancelParam cancelParam) {
        boolean isScpo = "sctm_scpo".equals(sourceBillType);
        if (!isScpo && !"pm_purorderbill".equals(sourceBillType)) {
            return;
        }
        List refundPayInfos = cancelParam.getRefundPayInfos();
        if (CollectionUtils.isEmpty((Collection)refundPayInfos)) {
            return;
        }
        ArrayList paramList = new ArrayList();
        for (RefundPayBillInfo refundPayInfo : refundPayInfos) {
            List entryInfos = refundPayInfo.getEntryInfos();
            if (CollectionUtils.isEmpty((Collection)entryInfos)) continue;
            for (RefundEntryInfo entryInfo : entryInfos) {
                HashMap<String, Object> entryParam = new HashMap<String, Object>(10);
                entryParam.put("paymentBizType", entryInfo.getPaymentBizType());
                entryParam.put("sourceBillType", sourceBillType);
                entryParam.put("coreBillType", entryInfo.getCoreBillType());
                entryParam.put("coreBillId", entryInfo.getCoreBillId());
                entryParam.put("coreBillEntryId", entryInfo.getCoreBillEntryId());
                entryParam.put("refundAmt", entryInfo.getRefundAmt());
                paramList.add(entryParam);
            }
        }
        logger.info("start checkPurchaseBill: " + SerializationUtils.toJsonString(paramList));
        if (CollectionUtils.isEmpty(paramList)) {
            return;
        }
        Object resultObj = isScpo ? DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sctm", (String)"SctmPoFiValidateService", (String)"verifyPayPrePayAmount", (Object[])new Object[]{paramList}) : DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurOrderFiValidateService", (String)"verifyPayPrePayAmount", (Object[])new Object[]{paramList});
        if (resultObj != null) {
            String resultJson = SerializationUtils.toJsonString((Object)resultObj);
            logger.info("end checkPurchaseBill result: " + resultJson);
            Result result = (Result)SerializationUtils.fromJsonString((String)resultJson, Result.class);
            if (!"0".equals(result.getCode())) {
                throw new KDBizException(result.getErrorInfo());
            }
        }
    }
}

