/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.security.SecureRandom;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.AttachmentInfoPackage;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.BeforeDrawArgs;
import kd.bos.entity.botp.runtime.BeforeDrawOpResult;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.ConvertReport;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.operate.botp.Push;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.fi.cas.consts.CasBFRow;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.errorcode.EBErrorCode;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CodeRuleHelper;
import kd.fi.cas.helper.DevHelper;
import kd.fi.cas.pojo.BotpBackValue;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class CasBotpHelper {
    private static final Log logger = LogFactory.getLog(CasBotpHelper.class);

    public static Map<Long, Set<Long>> getTargetBySourceBillIdMap(String sourceEntity, String targetEntity, Set<Long> sIds, String srcEntityFiled, String srcIdFiled) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{sIds, targetEntity, srcIdFiled, srcEntityFiled})) {
            return result;
        }
        QFilter qFilter = new QFilter(srcIdFiled, "in", sIds).and(new QFilter(srcEntityFiled, "=", (Object)sourceEntity));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getTargetBySourceBillIdMap", (String)targetEntity, (String)("id, " + srcIdFiled), (QFilter[])new QFilter[]{qFilter}, null);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long targetId = row.getLong("id");
                Long sourceId = row.getLong(srcIdFiled);
                result.computeIfAbsent(sourceId, k -> new HashSet()).add(targetId);
            }
        }
        return result;
    }

    public static Map<Long, Map<String, Set<Long>>> getTargetBillIdMap(String sourceEntity, List<Long> billIds, Set<String> excludeTargetEntitys, Set<String> includeTargetEntitys, boolean onlyDirtTarget) {
        HashMap<Long, Map<String, Set<Long>>> map = new HashMap<Long, Map<String, Set<Long>>>(billIds.size());
        Map targetBillMap = BFTrackerServiceHelper.loadBillLinkDownNodes((String)sourceEntity, (Long[])billIds.toArray(new Long[0]), (boolean)onlyDirtTarget);
        for (Map.Entry entry : targetBillMap.entrySet()) {
            Long billId = (Long)entry.getKey();
            HashMap<String, Set> targetIdMap = new HashMap<String, Set>(10);
            BFRowLinkDownNode linkDownNode = (BFRowLinkDownNode)entry.getValue();
            List childNodes = linkDownNode.findAllChildNodes();
            for (BFRowLinkDownNode childNode : childNodes) {
                BFRowId rowId = childNode.getRowId();
                String entityNumber = EntityMetadataCache.loadTableDefine((Long)rowId.getMainTableId()).getEntityNumber();
                if (EmptyUtil.isNoEmpty(excludeTargetEntitys) && excludeTargetEntitys.contains(entityNumber) || EmptyUtil.isNoEmpty(includeTargetEntitys) && !includeTargetEntitys.contains(entityNumber)) continue;
                Set idSet = targetIdMap.computeIfAbsent(entityNumber, o -> new HashSet(2));
                idSet.add(rowId.getBillId());
            }
            map.put(billId, targetIdMap);
        }
        billIds.forEach(d -> map.putIfAbsent((Long)d, Collections.emptyMap()));
        return map;
    }

    public static DynamicObject[] push(DynamicObject[] srcBills, String targetEntity) {
        PushArgs pushArgs = new PushArgs();
        String srcEntityName = srcBills[0].getDataEntityType().getName();
        pushArgs.setSourceEntityNumber(srcEntityName);
        pushArgs.setTargetEntityNumber(targetEntity);
        pushArgs.setHasRight(true);
        pushArgs.setAppId("");
        pushArgs.setDefOrgId(Long.valueOf(0L));
        pushArgs.setRuleId("");
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(10);
        for (DynamicObject srcBill : srcBills) {
            ListSelectedRow row = new ListSelectedRow((Object)srcBill.getLong("id"));
            selectedRows.add(row);
        }
        pushArgs.setSelectedRows(selectedRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            String errMessage = CasBotpHelper.getErrInfo(pushResult);
            logger.error("CasBotpHelper.push pushresult error:" + errMessage);
            ErrorCode ec = new ErrorCode("", errMessage);
            throw new KDBizException(ec, new Object[0]);
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)targetEntity);
        List targetBillObjs = pushResult.loadTargetDataObjects(new IRefrencedataProvider(){

            public void fillReferenceData(Object[] objs, IDataEntityType dType) {
                BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dType);
            }
        }, targetMainType);
        return targetBillObjs.toArray(new DynamicObject[0]);
    }

    public static void checkpush(String sourceEntity, String[] TargetEntitys) {
        if (sourceEntity == null) {
            ErrorCode ec = new ErrorCode("getBotp", ResManager.loadKDString((String)"\u6e90\u5355\u6ca1\u6709\u6307\u5b9a\u3002", (String)"CasBotpHelper_0", (String)"fi-cas-common", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        if (TargetEntitys.length < 1) {
            ErrorCode ec = new ErrorCode("getBotp", ResManager.loadKDString((String)"\u76ee\u6807\u5355\u6ca1\u6709\u6307\u5b9a\u3002", (String)"CasBotpHelper_1", (String)"fi-cas-common", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        for (int i = 0; i < TargetEntitys.length; ++i) {
            CasBotpHelper.checkPushValidity(sourceEntity, TargetEntitys[i]);
        }
    }

    private static void checkPushValidity(String sourceEntity, String targetEntity) {
        QFilter[] filter = new QFilter[]{new QFilter("sourceentitynumber", "=", (Object)sourceEntity), new QFilter("targetentitynumber", "=", (Object)targetEntity), new QFilter("enabled", "=", (Object)"1")};
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)"botp_crlist", (String)"id", (QFilter[])filter);
        if (rules.length < 1) {
            ErrorCode ec = new ErrorCode("getBotp", ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"CasBotpHelper_2", (String)"fi-cas-common", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)targetEntity);
        List items = linkSet.getItems();
        if (items == null || items.isEmpty()) {
            throw new KDException(new ErrorCode("CASBOTPERROR", ResManager.loadKDString((String)"\u6ca1\u6709\u5b9a\u4e49lk\u8868\uff0c\u8bf7\u5728\u76ee\u6807\u5355\u636e\u8bbe\u8ba1\u9875\u9762\u914d\u7f6e\u3002", (String)"CasBotpHelper_3", (String)"fi-cas-common", (Object[])new Object[0])), new Object[0]);
        }
        CodeRuleServiceHelper helper = new CodeRuleServiceHelper();
        List codeRuleList = helper.getAllCodeRuleByEntity(targetEntity);
        if (!(codeRuleList != null && codeRuleList.size() != 0 || DevHelper.isDevEnv())) {
            ErrorCode ec = new ErrorCode("number", ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u6ca1\u6709\u7f16\u7801\u89c4\u5219\u4e0d\u80fd\u751f\u6210\u3002", (String)"CasBotpHelper_4", (String)"fi-cas-common", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
    }

    @Deprecated
    public static DynamicObject[] push(String sourceEntity, String TargetEntity, DynamicObject info) {
        return CasBotpHelper.push(info, TargetEntity);
    }

    public static DynamicObject[] push(DynamicObject info, String TargetEntity) {
        String sourceEntity = info.getDataEntityType().getName();
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        ListSelectedRow row = new ListSelectedRow();
        row.setPrimaryKeyValue(info.getPkValue());
        selectedRows.add(row);
        return CasBotpHelper.dopushs(sourceEntity, TargetEntity, selectedRows, null);
    }

    private static String getErrInfo(ConvertOperationResult result) {
        List billReports = result.getBillReports();
        StringBuilder sb = new StringBuilder();
        sb.append(result.getMessage()).append("\r\n");
        if (billReports != null && billReports.size() > 0) {
            sb.append(billReports.toString()).append("\r\n");
        }
        return sb.toString();
    }

    public static DynamicObject[] push(DynamicObject sourceInfo, String targetEntity, String ruleId) {
        return CasBotpHelper.push(sourceInfo, null, null, targetEntity, ruleId);
    }

    public static DynamicObject[] push(DynamicObject sourceInfo, String sourceEntryKey, Collection<Long> sourceEntryIds, String targetEntity, String ruleId) {
        String sourceEntity = sourceInfo.getDataEntityType().getName();
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>();
        if (kd.bos.util.StringUtils.isNotEmpty((String)sourceEntryKey) && !CollectionUtils.isEmpty(sourceEntryIds)) {
            for (Long entryId : sourceEntryIds) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue(sourceInfo.getPkValue());
                row.setEntryEntityKey(sourceEntryKey);
                row.setEntryPrimaryKeyValue((Object)entryId);
                selectedRows.add(row);
            }
        } else {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue(sourceInfo.getPkValue());
            selectedRows.add(row);
        }
        return CasBotpHelper.dopushs(sourceEntity, targetEntity, selectedRows, ruleId);
    }

    private static DynamicObject[] dopushs(String sourceEntity, String targetEntity, List<ListSelectedRow> selectedRows, String ruleId) {
        if (EmptyUtil.isEmpty((String)ruleId)) {
            ruleId = CasBotpHelper.getDefaultBotpRule(sourceEntity, targetEntity);
        }
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(sourceEntity);
        args.setTargetEntityNumber(targetEntity);
        args.setRuleId(ruleId);
        args.setSelectedRows(selectedRows);
        ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
        if (!result.isSuccess()) {
            String errMessage = CasBotpHelper.getErrInfo(result);
            logger.error("CasBotpHelper.push pushresult error:" + errMessage);
            ErrorCode ec = new ErrorCode("", errMessage);
            throw new KDBizException(ec, new Object[0]);
        }
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
            }
        };
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
        List dynamicresults = result.loadTargetDataObjects(refDataProvider, mainType);
        DynamicObject[] dataEntities = new DynamicObject[dynamicresults.size()];
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        if (codeRuleService == null) {
            codeRuleService = (ICodeRuleService)TypesContainer.createInstance((String)"kd.bos.coderule.service.CodeRuleServiceImp");
        }
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < dynamicresults.size(); ++i) {
            dataEntities[i] = (DynamicObject)dynamicresults.get(i);
            String number = codeRuleService.getNumber(targetEntity, (DynamicObject)dynamicresults.get(i), ((DynamicObject)dynamicresults.get(i)).getString("org.id"));
            if (kd.bos.util.StringUtils.isEmpty((String)number)) {
                if (DevHelper.isDevEnv()) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    number = simpleDateFormat.format(new Date());
                    number = number + String.valueOf(random.nextInt(1000000));
                } else {
                    ErrorCode ec = new ErrorCode("billNo", ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u6ca1\u6709\u7f16\u7801\u89c4\u5219\u4e0d\u80fd\u751f\u6210\u3002", (String)"CasBotpHelper_4", (String)"fi-cas-common", (Object[])new Object[0]));
                    throw new KDBizException(ec, new Object[0]);
                }
            }
            dataEntities[i].set("billno", (Object)number);
        }
        CasBotpHelper.saveAttachmentPanelInfos(mainType, result);
        return dataEntities;
    }

    public static DynamicObject[] pushs(DynamicObject[] infos, String TargetEntity) {
        String sourceEntity = infos[0].getDataEntityType().getName();
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(infos.length);
        for (DynamicObject info : infos) {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue(info.getPkValue());
            selectedRows.add(row);
        }
        return CasBotpHelper.dopushs(sourceEntity, TargetEntity, selectedRows, null);
    }

    private static String getDefaultBotpRule(String sourceEntity, String targetEntity) {
        QFilter[] filter = new QFilter[]{new QFilter("sourceentitynumber", "=", (Object)sourceEntity), new QFilter("targetentitynumber", "=", (Object)targetEntity), new QFilter("enabled", "=", (Object)"1")};
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)"botp_crlist", (String)"id,defrule", (QFilter[])filter);
        if (rules.length < 1) {
            ErrorCode ec = new ErrorCode("getBotp", ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"CasBotpHelper_2", (String)"fi-cas-common", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
        if (rules.length > 1) {
            for (DynamicObject rule : rules) {
                if (!rule.getBoolean("defrule")) continue;
                return rule.getString("id");
            }
        }
        return rules[0].getString("id");
    }

    public static void showParamter(String entitynumber, Long primaryKeyValue, String opeat, IFormView iFormView) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_lookuptracker");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashSet<Long> subEntryIds = new HashSet<Long>();
        subEntryIds.add(primaryKeyValue);
        String linkNodesJson = null;
        List nodes = null;
        nodes = opeat.equals("lookdown") ? BFTrackerServiceHelper.loadLinkDownNodes((String)entitynumber, (String)"", (Long[])subEntryIds.toArray(new Long[subEntryIds.size()])) : BFTrackerServiceHelper.loadLinkUpNodes((String)entitynumber, (String)"", (Long[])subEntryIds.toArray(new Long[subEntryIds.size()]));
        if (nodes.isEmpty()) {
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e", (String)"CasBotpHelper_5", (String)"fi-cas-common", (Object[])new Object[0]));
            return;
        }
        linkNodesJson = SerializationUtils.serializeToBase64((Object)nodes);
        showParameter.getCustomParams().put("linknodes", linkNodesJson);
        showParameter.getCustomParams().put("lookuptype", opeat);
        iFormView.showForm(showParameter);
    }

    public static boolean isPushedBy(DynamicObject bill, String possibleSource) {
        String entity = bill.getDataEntityType().getName();
        String sourceBillType = (String)bill.get("sourcebilltype");
        Long pk = (Long)bill.getPkValue();
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)entity, (Long[])new Long[]{pk});
        HashSet sourcePks = (HashSet)sourceBills.get(possibleSource);
        if (sourcePks != null && !sourcePks.isEmpty()) {
            return !"cdm_drafttradebill".equals(sourceBillType);
        }
        return false;
    }

    private static List<CasBFRow> getLinkedBill(Long id, boolean isLinkUp) {
        String sql = null;
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        if (isLinkUp) {
            sql = "select FID,FSTABLEID,FSBILLID,FTTABLEID,FTBILLID from T_BOTP_BillTracker  WHERE FTBILLID= ?";
            params.add(new SqlParameter(":FTBILLID", -5, (Object)id));
        } else {
            sql = "select FID,FSTABLEID,FSBILLID,FTTABLEID,FTBILLID from T_BOTP_BillTracker  WHERE FSBILLID= ?";
            params.add(new SqlParameter(":FSBILLID", -5, (Object)id));
        }
        ResultSetHandler<List<CasBFRow>> action = new ResultSetHandler<List<CasBFRow>>(){

            public List<CasBFRow> handle(ResultSet rs) throws Exception {
                ArrayList<CasBFRow> rowIds = new ArrayList<CasBFRow>(10);
                while (rs.next()) {
                    Long id = rs.getLong("FID");
                    Long sTableId = rs.getLong("FSTABLEID");
                    Long sBillId = rs.getLong("FSBILLID");
                    Long tTableId = rs.getLong("FTTABLEID");
                    Long tBillId = rs.getLong("FTBILLID");
                    CasBFRow rowId = new CasBFRow(id, sBillId, sTableId, tTableId, tBillId);
                    rowIds.add(rowId);
                }
                return rowIds;
            }
        };
        List rowIds = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]), (ResultSetHandler)action);
        return rowIds;
    }

    public static List<String> getIdByLink(String souTable, String entTable, final Boolean isSource) {
        Long souTableId = CasBotpHelper.getTableIdByEntityKey(souTable);
        Long entTableId = CasBotpHelper.getTableIdByEntityKey(entTable);
        String sql = "SELECT FSBILLID,FTBILLID FROM T_BOTP_BILLTRACKER WHERE FSTABLEID= ? AND FTTABLEID= ?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter(":FSTABLEID", -5, (Object)souTableId));
        params.add(new SqlParameter(":FTTABLEID", -5, (Object)entTableId));
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> list = new ArrayList<String>(10);
                while (rs.next()) {
                    String column = isSource != false ? "FSBILLID" : "FTBILLID";
                    list.add(rs.getString(column));
                }
                return list;
            }
        };
        List listIds = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]), (ResultSetHandler)action);
        return listIds;
    }

    @Deprecated
    public static List<Map<String, Object>> gettargetBill(Long id) {
        List<CasBFRow> list = CasBotpHelper.getLinkedBill(id, false);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(list.size());
        HashMap<String, Object> temp = null;
        for (int i = 0; i < list.size(); ++i) {
            temp = new HashMap<String, Object>();
            temp.put("id", list.get(i).getTbillId());
            temp.put("entity", CasBotpHelper.getEntiKeyByTableId(list.get(i).gettTableId()));
            temp.put("sourceEntity", CasBotpHelper.getEntiKeyByTableId(list.get(i).getsTableId()));
            temp.put("sourceBillId", list.get(i).getsBillid());
            result.add(temp);
        }
        return result;
    }

    public static Long getTableIdByEntityKey(final String entityName) {
        Object[] parameters = new SqlParameter[1];
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FId, FEntityKey, FTableId ");
        sBuilder.append("FROM T_META_EntityInfo ");
        sBuilder.append("WHERE FEntityKey = ? ");
        parameters[0] = new SqlParameter(":FEntityKey", 12, (Object)entityName);
        ResultSetHandler<TableDefine> action = new ResultSetHandler<TableDefine>(){

            public TableDefine handle(ResultSet rs) throws Exception {
                TableDefine tableDefine = null;
                if (rs.next()) {
                    tableDefine = new TableDefine();
                    tableDefine.setEntityNumber(rs.getString("FId"));
                    tableDefine.setEntityKey(entityName);
                    tableDefine.setTableId(Long.valueOf(rs.getLong("FTableId")));
                }
                return tableDefine;
            }
        };
        TableDefine tableDefine = (TableDefine)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])parameters, (ResultSetHandler)action);
        return tableDefine.getTableId();
    }

    public static String getEntiKeyByTableId(final Long tableId) {
        Object[] parameters = new SqlParameter[1];
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FId, FEntityKey, FTableId ");
        sBuilder.append("FROM T_META_EntityInfo ");
        sBuilder.append("WHERE FTableId = ? ");
        parameters[0] = new SqlParameter(":FTableId", -5, (Object)tableId);
        ResultSetHandler<TableDefine> action = new ResultSetHandler<TableDefine>(){

            public TableDefine handle(ResultSet rs) throws Exception {
                TableDefine tableDefine = null;
                if (rs.next()) {
                    tableDefine = new TableDefine();
                    tableDefine.setEntityNumber(rs.getString("FId"));
                    tableDefine.setEntityKey(rs.getString("FEntityKey"));
                    tableDefine.setTableId(tableId);
                }
                return tableDefine;
            }
        };
        TableDefine tableDefine = (TableDefine)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])parameters, (ResultSetHandler)action);
        return tableDefine.getEntityNumber();
    }

    public static void deleteRation(Object Pk, String ... entityKeys) {
        int i;
        ArrayList<Map<String, Object>> relations = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> target = CasBotpHelper.gettargetBill((Long)Pk);
        relations.addAll(target);
        List<CasBFRow> list = CasBotpHelper.getLinkedBill((Long)Pk, true);
        ArrayList source = new ArrayList(list.size());
        for (i = 0; i < list.size(); ++i) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put("id", list.get(i).getTbillId());
            temp.put("entity", CasBotpHelper.getEntiKeyByTableId(list.get(i).gettTableId()));
            temp.put("sourceEntity", CasBotpHelper.getEntiKeyByTableId(list.get(i).getsTableId()));
            temp.put("sourceBillId", list.get(i).getsBillid());
            source.add(temp);
        }
        relations.addAll(source);
        if (entityKeys.length == 0) {
            for (int j = 0; j < relations.size(); ++j) {
                CasBotpHelper.deleteRation_NewMethod((Map)relations.get(j));
            }
        } else {
            for (i = 0; i < entityKeys.length; ++i) {
                for (int j = 0; j < relations.size(); ++j) {
                    String entityKey = (String)((Map)relations.get(j)).get("entity");
                    String sourceEntityKey = (String)((Map)relations.get(j)).get("sourceEntity");
                    if (!entityKey.equals(entityKeys[i]) && !sourceEntityKey.equals(entityKeys[i])) continue;
                    CasBotpHelper.deleteRation_NewMethod((Map)relations.get(j));
                }
            }
        }
    }

    private static void deleteRation_NewMethod(Map<String, Object> map) {
        CasBotpHelper.deleteRation_NewMethod(DBRouteConst.cas, map);
    }

    private static void deleteRation_NewMethod(DBRoute dbRoute, Map<String, Object> map) {
        MainEntityType dataEntityType;
        String entityKey = (String)map.get("entity");
        String routeKey = dbRoute.getRouteKey();
        if (!routeKey.equalsIgnoreCase((dataEntityType = EntityMetadataCache.getDataEntityType((String)entityKey)).getDBRouteKey()) && !routeKey.equalsIgnoreCase(dataEntityType.getAppId())) {
            logger.info("CasBotpHelper.deleteRation_NewMethod dbRoute:{} and {}'s routeKey:{} or appId:{} not the same!", new Object[]{routeKey, entityKey, dataEntityType.getDBRouteKey(), dataEntityType.getAppId()});
            return;
        }
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)entityKey);
        String tc = linkSet.getTrackerTable();
        String lk = null;
        List items = linkSet.getItems();
        if (items == null || items.size() <= 0) {
            throw new KDException(new ErrorCode("CASBOTPERROR", String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u5b9a\u4e49lk\u8868\uff0c\u8bf7\u5728\u76ee\u6807\u5355\u636e\u8bbe\u8ba1\u9875\u9762\u914d\u7f6e\u3002", (String)"CasBotpHelper_6", (String)"fi-cas-common", (Object[])new Object[0]), entityKey)), new Object[0]);
        }
        lk = ((LinkSetItemElement)items.get(0)).getTableName();
        CasBotpHelper.deleteDBRation(dbRoute, map, tc, lk);
        try (TXHandle h = TX.requiresNew();){
            CasBotpHelper.deleteRation(map);
        }
    }

    private static void deleteDBRation(DBRoute dbRoute, Map<String, Object> map, String tc, String lk) {
        Long FSBillId = (Long)map.get("sourceBillId");
        Long FTBILLID = (Long)map.get("id");
        String sBuilder_tc = "";
        ArrayList<SqlParameter> params_tc = new ArrayList<SqlParameter>();
        sBuilder_tc = "delete from  " + tc + " where FSBillId= ? and FTId= ?";
        params_tc.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
        params_tc.add(new SqlParameter(":FTId", -5, (Object)FTBILLID));
        DB.execute((DBRoute)dbRoute, (String)sBuilder_tc, (Object[])params_tc.toArray(new SqlParameter[params_tc.size()]));
        String sBuilder_lk = "";
        ArrayList<SqlParameter> params_lk = new ArrayList<SqlParameter>();
        sBuilder_lk = "delete from  " + lk + " where FSBillId= ? and FId= ?";
        params_lk.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
        params_lk.add(new SqlParameter(":FId", -5, (Object)FTBILLID));
        DB.execute((DBRoute)dbRoute, (String)sBuilder_lk, (Object[])params_lk.toArray(new SqlParameter[params_lk.size()]));
    }

    private static void deleteRation(Map<String, Object> map) {
        Long FSBillId = (Long)map.get("sourceBillId");
        Long FTBILLID = (Long)map.get("id");
        String sBuilder = "";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        sBuilder = "delete from T_BOTP_BillTracker where FSBillId= ? and FTBillId= ?";
        params.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
        params.add(new SqlParameter(":FTBillId", -5, (Object)FTBILLID));
        DB.execute((DBRoute)DBRoute.basedata, (String)sBuilder, (Object[])params.toArray(new SqlParameter[params.size()]));
    }

    public static void deleteRation(String FSEntityKey, Long[] FSBillIds, Long FTBILLID) {
        CasBotpHelper.deleteRation(DBRouteConst.cas, FSEntityKey, FSBillIds, FTBILLID);
    }

    public static void deleteRation(DBRoute dbRoute, String FSEntityKey, Long[] FSBillIds, Long FTBILLID) {
        if (FSEntityKey == null || FSEntityKey.length() < 1) {
            return;
        }
        ArrayList relations = new ArrayList(0);
        List<CasBFRow> list = CasBotpHelper.getLinkedBill(FTBILLID, true);
        list.addAll(CasBotpHelper.getLinkedBill(FTBILLID, false));
        ArrayList source = new ArrayList(list.size());
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put("id", list.get(i).getTbillId());
            temp.put("entity", CasBotpHelper.getEntiKeyByTableId(list.get(i).gettTableId()));
            temp.put("sourceEntity", CasBotpHelper.getEntiKeyByTableId(list.get(i).getsTableId()));
            temp.put("sourceBillId", list.get(i).getsBillid());
            source.add(temp);
        }
        relations.addAll(source);
        for (int j = 0; j < relations.size(); ++j) {
            Map relation = (Map)relations.get(j);
            String entityKey = (String)relation.get("entity");
            String sourceEntityKey = (String)relation.get("sourceEntity");
            if (!entityKey.equals(FSEntityKey) && !sourceEntityKey.equals(FSEntityKey)) continue;
            if (FSBillIds == null || FSBillIds.length < 1) {
                CasBotpHelper.deleteRation_NewMethod(dbRoute, relation);
                continue;
            }
            if (!Stream.of(FSBillIds).anyMatch(b -> b.equals(relation.get("sourceBillId")))) continue;
            CasBotpHelper.deleteRation_NewMethod(dbRoute, relation);
        }
    }

    public static void deleteRation(DBRoute dbRoute, String FSEntityKey, Long[] FSBillIds, Long FTBILLID, boolean isLinkUp) {
        if (FSEntityKey == null || FSEntityKey.length() < 1) {
            return;
        }
        ArrayList relations = new ArrayList(0);
        List<CasBFRow> list = CasBotpHelper.getLinkedBill(FTBILLID, isLinkUp);
        ArrayList source = new ArrayList(list.size());
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put("id", list.get(i).getTbillId());
            temp.put("entity", CasBotpHelper.getEntiKeyByTableId(list.get(i).gettTableId()));
            temp.put("sourceEntity", CasBotpHelper.getEntiKeyByTableId(list.get(i).getsTableId()));
            temp.put("sourceBillId", list.get(i).getsBillid());
            source.add(temp);
        }
        relations.addAll(source);
        for (int j = 0; j < relations.size(); ++j) {
            Map relation = (Map)relations.get(j);
            String entityKey = (String)relation.get("entity");
            String sourceEntityKey = (String)relation.get("sourceEntity");
            if (!entityKey.equals(FSEntityKey) && !sourceEntityKey.equals(FSEntityKey)) continue;
            if (FSBillIds == null || FSBillIds.length < 1) {
                CasBotpHelper.deleteRation_NewMethod(dbRoute, relation);
                continue;
            }
            if (!Stream.of(FSBillIds).anyMatch(b -> b.equals(relation.get("sourceBillId")))) continue;
            CasBotpHelper.deleteRation_NewMethod(dbRoute, relation);
        }
    }

    public static void saveRelation(DynamicObject[] targetBills) {
        for (DynamicObject targetBill : targetBills) {
            CasBotpHelper.saveRelation(targetBill);
        }
    }

    public static void saveRelation(DynamicObject targetBill) {
        String sourceKey = targetBill.getString("sourcebilltype");
        Long sourcePk = targetBill.getLong("sourcebillid");
        String targetKey = targetBill.getDataEntityType().getName();
        Long targetPk = (Long)targetBill.getPkValue();
        CasBotpHelper.saveRelation(sourceKey, sourcePk, targetKey, targetPk);
    }

    public static void saveRelation(DBRoute targetDbRoute, DynamicObject sourceBill, DynamicObject targetBill) {
        String sourceKey = sourceBill.getDataEntityType().getName();
        Long sourcePk = (Long)sourceBill.getPkValue();
        String targetKey = targetBill.getDataEntityType().getName();
        Long targetPk = (Long)targetBill.getPkValue();
        CasBotpHelper.saveRelation(targetDbRoute, sourceKey, sourcePk, targetKey, targetPk);
    }

    public static void saveRelation(DynamicObject sourceBill, DynamicObject targetBill) {
        CasBotpHelper.saveRelation(DBRouteConst.cas, sourceBill, targetBill);
    }

    public static void saveRelation(Collection<DynamicObject> sourceBills, DynamicObject targetBill) {
        ArrayList<Long> sourcePks = new ArrayList<Long>(sourceBills.size());
        String sourceKey = null;
        for (DynamicObject sourceBill : sourceBills) {
            sourcePks.add((Long)sourceBill.getPkValue());
            sourceKey = sourceBill.getDataEntityType().getName();
        }
        String targetKey = targetBill.getDataEntityType().getName();
        CasBotpHelper.saveRelation(sourceKey, sourcePks, targetKey, (Long)targetBill.getPkValue());
    }

    public static void saveRelation(String sourceEntityKey, Collection<Long> sourcePks, String targetEntityKey, Long targetPk) {
        Long sourceTableId = CasBotpHelper.getTableIdByEntityKey(sourceEntityKey);
        Long targetTableId = CasBotpHelper.getTableIdByEntityKey(targetEntityKey);
        ArrayList<CasBFRow> rows = new ArrayList<CasBFRow>(sourcePks.size());
        for (Long sourcePk : sourcePks) {
            long pk = DBServiceHelper.genGlobalLongId();
            CasBFRow row = new CasBFRow(Long.valueOf(pk), sourcePk, sourceTableId, targetTableId, targetPk);
            rows.add(row);
        }
        CasBotpHelper.saveRelation(rows, targetEntityKey);
    }

    public static void saveRelation(DBRoute targetDBRoute, String sourceEntityKey, Collection<Long> sourcePks, String targetEntityKey, Long targetPk) {
        Long sourceTableId = CasBotpHelper.getTableIdByEntityKey(sourceEntityKey);
        Long targetTableId = CasBotpHelper.getTableIdByEntityKey(targetEntityKey);
        ArrayList<CasBFRow> rows = new ArrayList<CasBFRow>(sourcePks.size());
        for (Long sourcePk : sourcePks) {
            long pk = DBServiceHelper.genGlobalLongId();
            CasBFRow row = new CasBFRow(Long.valueOf(pk), sourcePk, sourceTableId, targetTableId, targetPk);
            rows.add(row);
        }
        CasBotpHelper.saveRelation(targetDBRoute, rows, targetEntityKey);
    }

    public static void saveRelation(String sourceEntityKey, Long sourcePk, String targetEntityKey, Collection<Long> targetPks) {
        CasBotpHelper.saveRelation(DBRouteConst.cas, sourceEntityKey, sourcePk, targetEntityKey, targetPks);
    }

    public static void saveRelation(DBRoute targetDBRoute, String sourceEntityKey, Long sourcePk, String targetEntityKey, Collection<Long> targetPks) {
        Long sourceTableId = CasBotpHelper.getTableIdByEntityKey(sourceEntityKey);
        Long targetTableId = CasBotpHelper.getTableIdByEntityKey(targetEntityKey);
        ArrayList<CasBFRow> rows = new ArrayList<CasBFRow>(targetPks.size());
        for (Long targetPk : targetPks) {
            long pk = DBServiceHelper.genGlobalLongId();
            CasBFRow row = new CasBFRow(Long.valueOf(pk), sourcePk, sourceTableId, targetTableId, targetPk);
            rows.add(row);
        }
        CasBotpHelper.saveRelation(targetDBRoute, rows, targetEntityKey);
    }

    public static void batchSaveRelation(String sourceEntityKey, String targetEntityKey, List<Pair<Long, Long>> srcTarIds) {
        Long sourceTableId = CasBotpHelper.getTableIdByEntityKey(sourceEntityKey);
        Long targetTableId = CasBotpHelper.getTableIdByEntityKey(targetEntityKey);
        ArrayList<CasBFRow> rows = new ArrayList<CasBFRow>(srcTarIds.size());
        for (Pair<Long, Long> srcTarId : srcTarIds) {
            long pk = DBServiceHelper.genGlobalLongId();
            CasBFRow row = new CasBFRow(Long.valueOf(pk), (Long)srcTarId.getKey(), sourceTableId, targetTableId, (Long)srcTarId.getValue());
            rows.add(row);
        }
        CasBotpHelper.saveRelation(rows, targetEntityKey);
    }

    public static void batchSaveRelation(DBRoute targetDBRoute, String sourceEntityKey, String targetEntityKey, List<Pair<Long, Long>> srcTarIds) {
        Long sourceTableId = CasBotpHelper.getTableIdByEntityKey(sourceEntityKey);
        Long targetTableId = CasBotpHelper.getTableIdByEntityKey(targetEntityKey);
        ArrayList<CasBFRow> rows = new ArrayList<CasBFRow>(srcTarIds.size());
        for (Pair<Long, Long> srcTarId : srcTarIds) {
            long pk = DBServiceHelper.genGlobalLongId();
            CasBFRow row = new CasBFRow(Long.valueOf(pk), (Long)srcTarId.getKey(), sourceTableId, targetTableId, (Long)srcTarId.getValue());
            rows.add(row);
        }
        CasBotpHelper.saveRelation(targetDBRoute, rows, targetEntityKey);
    }

    public static void saveRelation(List<CasBFRow> rows, String targetEntityKey) {
        CasBotpHelper.saveRelation(DBRouteConst.cas, rows, targetEntityKey);
    }

    public static void saveRelation(DBRoute targetDBRoute, List<CasBFRow> rows, String targetEntityKey) {
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)targetEntityKey);
        String tc = linkSet.getTrackerTable();
        String lk = null;
        for (LinkSetItemElement linkEntry : linkSet.getItems()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)linkEntry.getParentEntityKey(), (CharSequence)targetEntityKey)) continue;
            lk = linkEntry.getTableName();
            break;
        }
        if (lk == null) {
            throw new KDException(new ErrorCode("CAS_BOTP_ERROR", String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u5b9a\u4e49lk\u8868\uff0c\u8bf7\u5728\u76ee\u6807\u5355\u636e\u8bbe\u8ba1\u9875\u9762\u914d\u7f6e\u3002", (String)"CasBotpHelper_6", (String)"fi-cas-common", (Object[])new Object[0]), targetEntityKey)), new Object[0]);
        }
        CasBotpHelper.saveBizRelation(targetDBRoute, rows, tc, lk);
        try (TXHandle h = TX.requiresNew();){
            CasBotpHelper.saveSysRelation(rows);
        }
    }

    public static void saveRelation(String sourceEntityKey, Long sourcePk, String targetEntityKey, Long targetPk) {
        CasBotpHelper.saveRelation(DBRouteConst.cas, sourceEntityKey, sourcePk, targetEntityKey, targetPk);
    }

    public static void saveRelation(DBRoute targetDBRoute, String sourceEntityKey, Long sourcePk, String targetEntityKey, Long targetPk) {
        CasBotpHelper.saveRelation(targetDBRoute, sourceEntityKey, sourcePk, targetEntityKey, Collections.singletonList(targetPk));
    }

    public static void deleteRation(Long sourceBillId, Long id) {
        String sBuilder = "";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        sBuilder = "delete from T_BOTP_BillTracker where FSBillId= ? and FTBillId= ?";
        params.add(new SqlParameter(":FSBillId", -5, (Object)sourceBillId));
        params.add(new SqlParameter(":FTBillId", -5, (Object)id));
        DB.execute((DBRoute)DBRoute.basedata, (String)sBuilder, (Object[])params.toArray(new SqlParameter[params.size()]));
    }

    private static void saveSysRelation(List<CasBFRow> rows) {
        ArrayList<SqlParameter[]> batchParameters = new ArrayList<SqlParameter[]>(rows.size());
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        for (CasBFRow row : rows) {
            params.clear();
            params.add(new SqlParameter(":FID", -5, (Object)row.getId()));
            params.add(new SqlParameter(":FSTABLEID", -5, (Object)row.getsTableId()));
            params.add(new SqlParameter(":FSBILLID", -5, (Object)row.getsBillid()));
            params.add(new SqlParameter(":FTTABLEID", -5, (Object)row.gettTableId()));
            params.add(new SqlParameter(":FTBILLID", -5, (Object)row.getTbillId()));
            params.add(new SqlParameter(":FCREATETIME", 91, (Object)new Date()));
            batchParameters.add(params.toArray(new SqlParameter[params.size()]));
        }
        String sBuilder = "INSERT INTO T_BOTP_BillTracker (FID, FSTABLEID, FSBILLID, FTTABLEID, FTBILLID, FCREATETIME) VALUES (?, ?, ?, ?, ?, ?)";
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)sBuilder, batchParameters);
    }

    private static void saveBizRelation(DBRoute dbRoute, List<CasBFRow> rows, String tc, String lk) {
        ArrayList<SqlParameter[]> tcBatchParameters = new ArrayList<SqlParameter[]>(rows.size());
        ArrayList<SqlParameter[]> lkBatchParameters = new ArrayList<SqlParameter[]>(rows.size());
        ArrayList<SqlParameter[]> deleteBatchParameters = new ArrayList<SqlParameter[]>(rows.size());
        ArrayList<SqlParameter> params_tc = new ArrayList<SqlParameter>(10);
        ArrayList<SqlParameter> params_lk = new ArrayList<SqlParameter>(10);
        ArrayList<SqlParameter> delParams_lk = new ArrayList<SqlParameter>(10);
        for (CasBFRow row : rows) {
            params_tc.clear();
            params_lk.clear();
            delParams_lk.clear();
            Long id_tc = DBServiceHelper.genGlobalLongId();
            Long FTBillId = row.getTbillId();
            Long FTTableId = row.gettTableId();
            Long FTId = row.getTbillId();
            Long FSBillId = row.getsBillid();
            Long FSTableId = row.getsTableId();
            Long FSId = row.getsBillid();
            params_tc.add(new SqlParameter(":FID", -5, (Object)id_tc));
            params_tc.add(new SqlParameter(":FTBillId", -5, (Object)FTBillId));
            params_tc.add(new SqlParameter(":FTTableId", -5, (Object)FTTableId));
            params_tc.add(new SqlParameter(":FTId", -5, (Object)FTId));
            params_tc.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
            params_tc.add(new SqlParameter(":FSTableId", -5, (Object)FSTableId));
            params_tc.add(new SqlParameter(":FSId", -5, (Object)FSId));
            tcBatchParameters.add(params_tc.toArray(new SqlParameter[params_tc.size()]));
            Long id_lk = DBServiceHelper.genGlobalLongId();
            params_lk.add(new SqlParameter(":FId", -5, (Object)FTId));
            params_lk.add(new SqlParameter(":FPKId", -5, (Object)id_lk));
            params_lk.add(new SqlParameter(":FSeq", 4, (Object)1));
            params_lk.add(new SqlParameter(":FSTableId", -5, (Object)FSTableId));
            params_lk.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
            params_lk.add(new SqlParameter(":FSId", -5, (Object)FSBillId));
            lkBatchParameters.add(params_lk.toArray(new SqlParameter[params_lk.size()]));
            delParams_lk.add(new SqlParameter(":FId", -5, (Object)FTId));
            delParams_lk.add(new SqlParameter(":FSTableId", -5, (Object)FSTableId));
            delParams_lk.add(new SqlParameter(":FSBillId", -5, (Object)FSBillId));
            delParams_lk.add(new SqlParameter(":FSId", -5, (Object)FSBillId));
            deleteBatchParameters.add(delParams_lk.toArray(new SqlParameter[delParams_lk.size()]));
        }
        String sBuilder_tc = "INSERT INTO " + tc + " (FID, FTBillId, FTTableId,FTId,FSBillId,FSTableId,FSId) VALUES (?, ?,?,?, ?,?,?)";
        DB.executeBatch((DBRoute)dbRoute, (String)sBuilder_tc, tcBatchParameters);
        String delete_lk = "delete from  " + lk + " where  FId= ? and FSTableId=? and FSBillId=? and FSId=?";
        DB.executeBatch((DBRoute)dbRoute, (String)delete_lk, deleteBatchParameters);
        String sBuilder_lk = "INSERT INTO " + lk + " (FId, FPKId, FSeq,FSTableId,FSBillId,FSId) VALUES (?, ?,?,?, ?,?)";
        DB.executeBatch((DBRoute)dbRoute, (String)sBuilder_lk, lkBatchParameters);
    }

    public static Set<Long> getSrcBillByDestBill(Long destBillId, String destEntityKey, String srcEntityKey) {
        Map srcBills = BFTrackerServiceHelper.findSourceBills((String)destEntityKey, (Long[])new Long[]{destBillId});
        Set entrySet = srcBills.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            HashSet value = (HashSet)entry.getValue();
            if (!srcEntityKey.equals(key)) continue;
            return value;
        }
        return null;
    }

    public static Map<Long, Set<Long>> batchGetSrcBillByDestBill(Long[] destBillIds, String destEntityKey, String srcEntityKey) {
        if (EmptyUtil.isEmpty((Object[])destBillIds)) {
            return new HashMap<Long, Set<Long>>(0);
        }
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(destBillIds.length);
        for (Long destBillId : destBillIds) {
            Set<Long> srcIds = CasBotpHelper.getSrcBillByDestBill(destBillId, destEntityKey, srcEntityKey);
            map.put(destBillId, srcIds);
        }
        return map;
    }

    public static void checkPushRule(String sourcebill, String[] targetEntitys) {
        if (null == targetEntitys || targetEntitys.length == 0) {
            return;
        }
        EBErrorCode ebErrorCode = new EBErrorCode();
        for (String targetEntity : targetEntitys) {
            QFilter[] filter = new QFilter[]{new QFilter("sourceentitynumber", "=", (Object)sourcebill), new QFilter("targetentitynumber", "=", (Object)targetEntity), new QFilter("enabled", "=", (Object)"1")};
            DynamicObject[] rules = BusinessDataServiceHelper.load((String)"botp_crlist", (String)"id", (QFilter[])filter);
            if (rules.length >= 1) continue;
            if ("ar_finarbill".equals(targetEntity)) {
                throw new KDException(ebErrorCode.PUSH_NO_AR(), new Object[0]);
            }
            throw new KDBizException(ebErrorCode.PUSH_NO(), new Object[0]);
        }
    }

    public static void checkPushMsg(String sourceEntity, String targetEntity, String msg) {
        QFilter[] filter = new QFilter[]{new QFilter("sourceentitynumber", "=", (Object)sourceEntity), new QFilter("targetentitynumber", "=", (Object)targetEntity), new QFilter("enabled", "=", (Object)"1")};
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)"botp_crlist", (String)"id", (QFilter[])filter);
        if (rules.length < 1) {
            ErrorCode ec = new ErrorCode("getBotp", CasHelper.isEmpty(msg) ? ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"CasBotpHelper_2", (String)"fi-cas-common", (Object[])new Object[0]) : msg);
            throw new KDException(ec, new Object[0]);
        }
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)targetEntity);
        List items = linkSet.getItems();
        if (items == null || items.isEmpty()) {
            throw new KDException(new ErrorCode("CASBOTPERROR", ResManager.loadKDString((String)"\u6ca1\u6709\u5b9a\u4e49lk\u8868\uff0c\u8bf7\u5728\u76ee\u6807\u5355\u636e\u8bbe\u8ba1\u9875\u9762\u914d\u7f6e\u3002", (String)"CasBotpHelper_3", (String)"fi-cas-common", (Object[])new Object[0])), new Object[0]);
        }
        CodeRuleServiceHelper helper = new CodeRuleServiceHelper();
        List codeRuleList = helper.getAllCodeRuleByEntity(targetEntity);
        if (!(codeRuleList != null && codeRuleList.size() != 0 || DevHelper.isDevEnv())) {
            ErrorCode ec = new ErrorCode("number", ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u6ca1\u6709\u7f16\u7801\u89c4\u5219\u4e0d\u80fd\u751f\u6210\u3002", (String)"CasBotpHelper_4", (String)"fi-cas-common", (Object[])new Object[0]));
            throw new KDException(ec, new Object[0]);
        }
    }

    public static boolean isFindTargetBill(String sourceEntity, String targetEntity, Long[] sourceBill) {
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)sourceEntity, (Long[])sourceBill);
        return !CasHelper.isEmpty(targetBills) && targetBills.size() > 0 && !CasHelper.isEmpty(targetBills.get(targetEntity));
    }

    public static void linkSourceRow(DynamicObject targetObj, String entityNumber, String entityKey) {
        if (EmptyUtil.isEmpty((DynamicObject)targetObj) || EmptyUtil.isEmpty((String)entityNumber) || EmptyUtil.isEmpty((String)entityKey)) {
            return;
        }
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)entityNumber, (String)entityKey);
        Long srcTableId = tableDefine.getTableId();
        String lkEntryKey = "entry_lk";
        DynamicObjectCollection targetRows = targetObj.getDynamicObjectCollection("entry");
        if (EmptyUtil.isEmpty((Object)targetObj.get("sourcebilltype")) || "bei_intelrec".equals(targetObj.get("sourcebilltype")) || "bei_transdetail_cas".equals(targetObj.get("sourcebilltype")) || "bei_transdetail".equals(targetObj.get("sourcebilltype"))) {
            for (DynamicObject targetRow : targetRows) {
                DynamicObjectCollection linkRows = targetRow.getDynamicObjectCollection(lkEntryKey);
                Long sourcebillid = targetRow.getLong("e_sourcebillid");
                Long sourcebillentryid = targetRow.getLong("e_sourcebillentryid");
                String corebillno = targetRow.getString("e_corebillno");
                linkRows.clear();
                if (!entityNumber.equals(targetRow.getString("e_corebilltype")) || EmptyUtil.isEmpty((Long)sourcebillid) || EmptyUtil.isEmpty((Long)sourcebillentryid) || EmptyUtil.isEmpty((String)corebillno)) continue;
                DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
                linkRows.add((Object)linkRow);
                linkRow.set(lkEntryKey + "_stableid", (Object)srcTableId);
                linkRow.set(lkEntryKey + "_sbillid", (Object)sourcebillid);
                linkRow.set(lkEntryKey + "_sid", (Object)sourcebillentryid);
            }
        }
    }

    public static void linkSource(DynamicObject targetObj, String entityNumber) {
        if (EmptyUtil.isEmpty((DynamicObject)targetObj) || EmptyUtil.isEmpty((String)entityNumber)) {
            return;
        }
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)entityNumber, (String)entityNumber);
        Long srcTableId = tableDefine.getTableId();
        String lkEntryKey = "entry_lk";
        DynamicObjectCollection targetRows = targetObj.getDynamicObjectCollection("entry");
        if (EmptyUtil.isEmpty((Object)targetObj.get("sourcebilltype")) || "bei_intelrec".equals(targetObj.get("sourcebilltype")) || "bei_transdetail_cas".equals(targetObj.get("sourcebilltype")) || "bei_transdetail".equals(targetObj.get("sourcebilltype"))) {
            for (DynamicObject targetRow : targetRows) {
                DynamicObjectCollection linkRows = targetRow.getDynamicObjectCollection(lkEntryKey);
                Long sourcebillid = targetRow.getLong("e_sourcebillid");
                Long sourcebillentryid = targetRow.getLong("e_sourcebillentryid");
                String corebillno = targetRow.getString("e_corebillno");
                linkRows.clear();
                if (!entityNumber.equals(targetRow.getString("e_corebilltype")) || EmptyUtil.isEmpty((Long)sourcebillid) || EmptyUtil.isEmpty((Long)sourcebillentryid) || EmptyUtil.isEmpty((String)corebillno)) continue;
                DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
                linkRows.add((Object)linkRow);
                linkRow.set(lkEntryKey + "_stableid", (Object)srcTableId);
                linkRow.set(lkEntryKey + "_sbillid", (Object)sourcebillid);
                linkRow.set(lkEntryKey + "_sid", (Object)sourcebillentryid);
            }
        }
    }

    public static void doBeforeDraw(IFormView view, String soureEntity, String targetEntity, Boolean isMultiSelect, QFilter filter, CloseCallBack closeCallBack) {
        CasBotpHelper.doBeforeDraw(view, soureEntity, soureEntity, targetEntity, isMultiSelect, filter, closeCallBack);
    }

    public static void doBeforeDraw(IFormView view, String soureEntity, String srcLayoutFormId, String targetEntity, Boolean isMultiSelect, QFilter filter, CloseCallBack closeCallBack) {
        String ruleId = CasBotpHelper.getRule(soureEntity, targetEntity);
        if (EmptyUtil.isEmpty((String)ruleId)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6709\u6548\u7684\u8f6c\u6362\u89c4\u5219,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e", (String)"CasBotpHelper_7", (String)"fi-cas-common", (Object[])new Object[0]));
            return;
        }
        BeforeDrawArgs args = new BeforeDrawArgs();
        args.setSourceEntityNumber(soureEntity);
        args.setTargetEntityNumber(targetEntity);
        args.setTargetPageId(view.getPageId());
        args.setRuleId(ruleId);
        ConvertOperationResult opResult = ConvertServiceHelper.beforeDraw((BeforeDrawArgs)args);
        BeforeDrawOpResult result = (BeforeDrawOpResult)opResult;
        if (!result.isSuccess()) {
            StringBuilder sBuilder = new StringBuilder();
            if (result.getReports().size() == 0) {
                sBuilder.append(result.getMessage());
            } else {
                for (ConvertReport report : result.getReports()) {
                    sBuilder.append(report).append("; ");
                }
            }
            view.showErrorNotification(sBuilder.toString());
        } else {
            String drawFilter = result.getDrawFilter();
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)srcLayoutFormId, (boolean)isMultiSelect);
            QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            if (EmptyUtil.isNoEmpty((String)drawFilter)) {
                QFilter fi = QFilter.fromSerializedString((String)drawFilter);
                if (filter != null) {
                    qFilter.and(fi);
                }
            }
            if (filter != null) {
                qFilter.and(filter);
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
            logger.info("\u9009\u5355\u7684\u8fc7\u6ee4\u6761\u4ef6:" + qFilter.toString());
            if (result.getDrawSelectedEntity().size() > 0) {
                String selectEntity = (String)result.getDrawSelectedEntity().get(result.getDrawSelectedEntity().size() - 1);
                showParameter.getListFilterParameter().setSelectEntity(selectEntity);
                showParameter.getCustomParams().put("ismergerows", false);
            }
            if (result.getSrcMainOrgId() != null) {
                showParameter.setIsolationOrg(true);
                showParameter.setUseOrgId(result.getSrcMainOrgId().longValue());
            } else {
                showParameter.setIsolationOrg(false);
            }
            showParameter.setCloseCallBack(closeCallBack);
            view.showForm((FormShowParameter)showParameter);
        }
    }

    public static void doDraw(IFormView view, String soureEntity, String targetEntity, ListSelectedRowCollection rows) {
        String mianOrgFieldName = "org";
        MainEntityType tagEntityType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
        String mainOrg = tagEntityType.getMainOrg();
        if (!EmptyUtil.isEmpty((String)mainOrg)) {
            mianOrgFieldName = mainOrg;
        }
        String ruleId = CasBotpHelper.getRule(soureEntity, targetEntity);
        DrawArgs args = new DrawArgs();
        args.setSourceEntityNumber(soureEntity);
        args.setTargetEntityNumber(targetEntity);
        args.getSelectedRows().addAll(rows);
        args.setTargetPageId(view.getPageId());
        args.setRuleId(ruleId);
        args.setBuildConvReport(true);
        ConvertOperationResult result = ConvertServiceHelper.draw((DrawArgs)args);
        if (!result.isSuccess() || result.getCachePageIds().size() == 0) {
            Push.showReport((IFormView)view, (AbstractConvertServiceArgs)args, (ConvertOperationResult)result);
        } else {
            IRefrencedataProvider refProvider = BusinessDataReader::loadRefence;
            IBillView billView = (IBillView)view.getView(view.getPageId());
            List dataEntitys = result.loadTargetDataObjects(refProvider, billView.getModel().getDataEntityType());
            DynamicObject dataEntity = (DynamicObject)dataEntitys.get(0);
            String tagBillno = dataEntity.getString("billno");
            if (EmptyUtil.isEmpty((String)tagBillno) && EmptyUtil.isNoEmpty((DynamicObject)dataEntity.getDynamicObject(mianOrgFieldName))) {
                String codeNumber = CodeRuleHelper.generateNumber((String)dataEntity.getDataEntityType().getName(), (DynamicObject)dataEntity, (String)dataEntity.getDynamicObject(mianOrgFieldName).getPkValue().toString(), (String)"");
                dataEntity.set("billno", (Object)codeNumber);
            }
            ((IBillModel)billView.getModel()).push((Object)dataEntity);
            billView.updateView();
            view.sendFormAction((IFormView)billView);
            result.release(refProvider, billView.getModel().getDataEntityType());
        }
    }

    private static String getRule(String soureEntity, String targetEntity) {
        List rules = ConvertMetaServiceHelper.loadRules((String)soureEntity, (String)targetEntity);
        String ruleId = "";
        if (EmptyUtil.isEmpty((Collection)rules)) {
            return ruleId;
        }
        for (ConvertRuleElement rule : rules) {
            if (!rule.isDefRule() || !rule.isEnabled()) continue;
            ruleId = rule.getId();
            break;
        }
        if (EmptyUtil.isEmpty((String)ruleId)) {
            ruleId = rules.stream().filter(ConvertRuleElement::isEnabled).findFirst().map(ConvertRuleElement::getId).orElse("");
        }
        return ruleId;
    }

    public static List<BotpBackValue> getDestBillBySrcBill(String srcEntity, Long[] srcIds) {
        if (srcIds == null || srcIds.length == 0) {
            return new ArrayList<BotpBackValue>();
        }
        ArrayList<BotpBackValue> returns = new ArrayList<BotpBackValue>(srcIds.length);
        for (Long srcId : srcIds) {
            Map tarIds = BFTrackerServiceHelper.findTargetBills((String)srcEntity, (Long[])new Long[]{srcId});
            if (tarIds == null || tarIds.size() <= 0) continue;
            for (Map.Entry tarId : tarIds.entrySet()) {
                BotpBackValue botpValue = new BotpBackValue();
                botpValue.setSrcEntity(srcEntity);
                botpValue.setSrcId(srcId);
                botpValue.setTargetEntity((String)tarId.getKey());
                botpValue.setTargetIds((Set)tarId.getValue());
                returns.add(botpValue);
            }
        }
        return returns;
    }

    public static Set<Long> getDestCdmRecBillSet(Long[] srcIds) {
        DynamicObjectCollection draftbills;
        Set<Long> hasNextCdmRecBillIdSet = new HashSet<Long>(8);
        if (srcIds != null && srcIds.length > 0 && (draftbills = QueryServiceHelper.query((String)"cdm_receivablebill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", (Object)srcIds).and("source", "=", (Object)"cas").and("billstatus", "not in", (Object)new String[]{"A", "H"})})) != null && draftbills.size() > 0) {
            hasNextCdmRecBillIdSet = draftbills.stream().map(e -> e.getLong("sourcebillid")).collect(Collectors.toSet());
        }
        return hasNextCdmRecBillIdSet;
    }

    public static Set<Long> getDestBillBySrcBill(String srcEntity, Long srcBillId, String targetEntity) {
        return CasBotpHelper.batchGetDestBillIds(srcEntity, new Long[]{srcBillId}, targetEntity);
    }

    public static Map<Long, Set<Long>> batchGetDestBillBySrcBill(String srcEntity, Long[] srcIds, String targetEntity) {
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(srcIds.length);
        List<BotpBackValue> botpValues = CasBotpHelper.getDestBillBySrcBill(srcEntity, srcIds);
        botpValues.forEach(e -> map.put(e.getSrcId(), e.getTargetIds()));
        return map;
    }

    public static Set<Long> batchGetDestBillIds(String srcEntity, Long[] srcIds, String targetEntity) {
        List<BotpBackValue> botpValues = CasBotpHelper.getDestBillBySrcBill(srcEntity, srcIds);
        return botpValues.stream().filter(o -> targetEntity.equals(o.getTargetEntity())).map(e -> e.getTargetIds()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static void showTrackParameter(List<Tuple<String, List<Long>>> billTuple, IFormView iFormView) {
        if (CollectionUtils.isEmpty(billTuple)) {
            iFormView.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e", (String)"TmcBotpHelper_0", (String)"tmc-fbp-common", (Object[])new Object[0]));
            return;
        }
        for (Tuple<String, List<Long>> tuple : billTuple) {
            BillShowParameter showParameter;
            String entityNumber = (String)tuple.item1;
            List billIds = (List)tuple.item2;
            if (billIds.size() == 1) {
                showParameter = CasBotpHelper.createBillShowParameter(entityNumber, (Long)billIds.get(0));
                if (showParameter == null) continue;
                iFormView.showForm((FormShowParameter)showParameter);
                continue;
            }
            showParameter = CasBotpHelper.createShowParameter(entityNumber, new HashSet<Long>(billIds));
            if (showParameter == null) continue;
            iFormView.showForm((FormShowParameter)showParameter);
        }
    }

    private static BillShowParameter createBillShowParameter(String entityNumber, Long billId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(entityNumber);
        showParameter.setPkId((Object)billId);
        showParameter.getCustomParams().put("isIgnoreLicense", true);
        showParameter.getCustomParams().put("isFromTrack", "true");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("tabbills");
        showParameter.setShowTitle(false);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        showParameter.setCaption(mainType.getDisplayName().toString());
        showParameter.setStatusValue(OperationStatus.VIEW.getValue());
        showParameter.setHasRight(true);
        return showParameter;
    }

    public static ListShowParameter createShowParameter(String entityNumber, HashSet<Long> billIds) {
        QFilter qFilter = null;
        qFilter = billIds.size() == 1 ? new QFilter("id", "=", (Object)billIds.iterator().next()) : new QFilter("id", "in", (Object)billIds.toArray(new Long[billIds.size()]));
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId(entityNumber);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("tabbills");
        showParameter.setShowTitle(false);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        showParameter.setCaption(mainType.getDisplayName().toString());
        for (Long billId : billIds) {
            showParameter.addLinkQueryPkId((Object)billId);
        }
        showParameter.getListFilterParameter().setFilter(qFilter);
        showParameter.addCustPlugin("kd.bos.form.plugin.botp.LookUpTrackerList");
        showParameter.setHasRight(true);
        return showParameter;
    }

    public static Map<Long, String> sourceBilStatus(Set<Long> sourceIds, Set<Long> selectIds, Boolean isConfirm) {
        if (selectIds.isEmpty()) {
            return null;
        }
        QFilter qFilter = new QFilter("entry.e_sourcebillid", "in", sourceIds);
        DynamicObject[] getPayBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id, billstatus, entry.e_sourcebillid", (QFilter[])new QFilter[]{qFilter});
        HashMap<Long, HashSet<String>> payBillStatus = new HashMap<Long, HashSet<String>>(getPayBills.length);
        for (DynamicObject payBill : getPayBills) {
            Long id = payBill.getLong("id");
            if (selectIds.contains(id)) continue;
            String billStatus = payBill.getString("billstatus");
            DynamicObjectCollection payBillInfo = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject payInfo : payBillInfo) {
                Long eSourceId = payInfo.getLong("e_sourcebillid");
                HashSet<String> statusList = (HashSet<String>)payBillStatus.get(eSourceId);
                if (statusList == null) {
                    statusList = new HashSet<String>(getPayBills.length);
                    payBillStatus.put(eSourceId, statusList);
                }
                statusList.add(billStatus);
            }
        }
        HashMap<Long, String> result = new HashMap<Long, String>(payBillStatus.size());
        for (Map.Entry billState : payBillStatus.entrySet()) {
            String status = "";
            Long keyValue = (Long)billState.getKey();
            Set statusList = (Set)billState.getValue();
            if (isConfirm.booleanValue() && statusList.isEmpty()) {
                result.put(keyValue, BillStatusEnum.PAY.getValue());
                continue;
            }
            if (!isConfirm.booleanValue() && statusList.isEmpty()) {
                result.put(keyValue, BillStatusEnum.AUDIT.getValue());
                continue;
            }
            if (isConfirm.booleanValue()) {
                status = statusList.size() == 1 && statusList.contains(BillStatusEnum.PAY.getValue()) ? BillStatusEnum.PAY.getValue() : BillStatusEnum.BEING.getValue();
            } else if (statusList.size() == 1 && statusList.contains(BillStatusEnum.AUDIT.getValue())) {
                status = BillStatusEnum.AUDIT.getValue();
            } else if (statusList.contains(BillStatusEnum.PAY.getValue())) {
                status = BillStatusEnum.BEING.getValue();
            }
            result.put(keyValue, status);
        }
        return result;
    }

    private static void saveAttachmentPanelInfos(MainEntityType targetEntityType, ConvertOperationResult pushResult) {
        Map sourceAttachmentPanelInfos = pushResult.getBillAttachmentPanelInfos();
        for (Map.Entry billAttachmentIndex : sourceAttachmentPanelInfos.entrySet()) {
            Long targetPk = Long.parseLong(billAttachmentIndex.getKey().toString());
            Map billAttachmentItemInfoList = (Map)billAttachmentIndex.getValue();
            if (billAttachmentItemInfoList == null || billAttachmentItemInfoList.isEmpty()) continue;
            AttachmentInfoPackage pkg = new AttachmentInfoPackage();
            pkg.setAppId(targetEntityType.getAppId());
            pkg.setFormId(targetEntityType.getName());
            pkg.setPkId((Object)targetPk);
            pkg.setAttachmentInfo(billAttachmentItemInfoList);
            pkg.persist();
        }
    }
}

