/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;

public class DraftHelper {
    private static Log logger = LogFactory.getLog(DraftHelper.class);

    public static boolean isDraftBill(Long recbillId, String entityName) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "=", (Object)recbillId));
        qFilters.add(new QFilter("settletype.settlementtype", "in", (Object)new String[]{SettleMentTypeEnum.BUSINESS.getValue(), SettleMentTypeEnum.BANK.getValue(), SettleMentTypeEnum.PROMISSORY.getValue(), SettleMentTypeEnum.CHECK.getValue()}));
        return QueryServiceHelper.exists((String)entityName, (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    public static boolean isSettlePromise(Object settletype) {
        if (!CasHelper.isEmpty(settletype)) {
            DynamicObject settle = (DynamicObject)settletype;
            String type = (String)settle.get("settlementtype");
            if (SettleMentTypeEnum.BUSINESS.getValue().equals(type) || SettleMentTypeEnum.BANK.getValue().equals(type)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSettle(Object settletype) {
        if (!CasHelper.isEmpty(settletype)) {
            DynamicObject settle = (DynamicObject)settletype;
            String type = (String)settle.get("settlementtype");
            if (SettleMentTypeEnum.BUSINESS.getValue().equals(type) || SettleMentTypeEnum.BANK.getValue().equals(type) || SettleMentTypeEnum.PROMISSORY.getValue().equals(type) || SettleMentTypeEnum.CHECK.getValue().equals(type)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isParameterDraftOn(Long primaryKeyValue, String entityPaymentbill) {
        DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)entityPaymentbill);
        long orgId = (Long)payBill.getDynamicObject("org").getPkValue();
        boolean isOpen = SystemParameterHelper.getCdmParameterBoolean((long)orgId, (String)DraftHelper.getKey(payBill.get("settletype")));
        return isOpen;
    }

    public static String getWarnMesg(DynamicObject info, String key, String entity, boolean selectDraftFlag) {
        DynamicObjectCollection draftBillCol;
        if (CasHelper.isEmpty(key)) {
            return "";
        }
        long orgId = (Long)info.getDynamicObject("org").getPkValue();
        String tip = "cas_paybill".equals(entity) ? ResManager.loadKDString((String)"\u4ed8\u6b3e", (String)"DraftHelper_0", (String)"fi-cas-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6536\u6b3e", (String)"DraftHelper_1", (String)"fi-cas-common", (Object[])new Object[0]);
        ArrayList<String> typeList = new ArrayList<String>();
        boolean isOpen = SystemParameterHelper.getCdmParameterBoolean((long)orgId, (String)key);
        if (!isOpen) {
            return "";
        }
        if ("cas_paybill".equals(entity) && DraftHelper.isAllPayDrafBill(info.getDynamicObjectCollection("draftbill"))) {
            return "";
        }
        if (selectDraftFlag) {
            return "";
        }
        if ("cas_recbill".equals(entity) && (draftBillCol = info.getDynamicObjectCollection("draftbill")) != null && draftBillCol.size() > 0) {
            return "";
        }
        boolean isdraft = SystemParameterHelper.getCdmParameterBoolean((long)orgId, (String)"isdraft");
        boolean ischeck = SystemParameterHelper.getCdmParameterBoolean((long)orgId, (String)"ischeck");
        boolean ispromissorynote = SystemParameterHelper.getCdmParameterBoolean((long)orgId, (String)"ispromissorynote");
        if (isdraft) {
            typeList.add(ResManager.loadKDString((String)"\u6c47\u7968", (String)"DraftHelper_4", (String)"fi-cas-common", (Object[])new Object[0]));
        }
        if (ischeck) {
            typeList.add(ResManager.loadKDString((String)"\u652f\u7968", (String)"DraftHelper_5", (String)"fi-cas-common", (Object[])new Object[0]));
        }
        if (ispromissorynote) {
            typeList.add(ResManager.loadKDString((String)"\u672c\u7968", (String)"DraftHelper_6", (String)"fi-cas-common", (Object[])new Object[0]));
        }
        return String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u522b\u4e3a%1$s\u7684%2$s\u5355\u4e0d\u652f\u6301\u786e\u8ba4%3$s", (String)"DraftHelper_7", (String)"fi-cas-common", (Object[])new Object[0]), String.join((CharSequence)ResManager.loadKDString((String)"\u6216", (String)"DraftHelper_8", (String)"fi-cas-common", (Object[])new Object[0]), typeList), tip, tip);
    }

    public static String getWarnMesg(Long primaryKeyValue, String key, String entity) {
        DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)entity);
        boolean selectDraftFlag = SystemParameterHelper.getParameterBoolean((long)payBill.getDynamicObject("org").getLong("id"), (String)"cs122");
        return DraftHelper.getWarnMesg(payBill, key, entity, selectDraftFlag);
    }

    public static String getRecWarnMesg(Map<String, Map<String, Object>> systemParamsCdmMap, String key, String orgId) {
        if (CasHelper.isEmpty(key)) {
            return "";
        }
        String tip = ResManager.loadKDString((String)"\u6536\u6b3e", (String)"DraftHelper_1", (String)"fi-cas-common", (Object[])new Object[0]);
        ArrayList<String> typeList = new ArrayList<String>();
        Boolean isOpen = (Boolean)systemParamsCdmMap.get(orgId).get(key);
        if (!isOpen.booleanValue()) {
            return "";
        }
        Boolean isdraft = (Boolean)systemParamsCdmMap.get(orgId).get("isdraft");
        Boolean ischeck = (Boolean)systemParamsCdmMap.get(orgId).get("ischeck");
        Boolean ispromissorynote = (Boolean)systemParamsCdmMap.get(orgId).get("ispromissorynote");
        if (isdraft.booleanValue()) {
            typeList.add(ResManager.loadKDString((String)"\u6c47\u7968", (String)"DraftHelper_4", (String)"fi-cas-common", (Object[])new Object[0]));
        }
        if (ischeck.booleanValue()) {
            typeList.add(ResManager.loadKDString((String)"\u652f\u7968", (String)"DraftHelper_5", (String)"fi-cas-common", (Object[])new Object[0]));
        }
        if (ispromissorynote.booleanValue()) {
            typeList.add(ResManager.loadKDString((String)"\u672c\u7968", (String)"DraftHelper_6", (String)"fi-cas-common", (Object[])new Object[0]));
        }
        return String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u522b\u4e3a%1$s\u7684%2$s\u5355\u4e0d\u652f\u6301\u786e\u8ba4%3$s", (String)"DraftHelper_7", (String)"fi-cas-common", (Object[])new Object[0]), String.join((CharSequence)ResManager.loadKDString((String)"\u6216", (String)"DraftHelper_8", (String)"fi-cas-common", (Object[])new Object[0]), typeList), tip, tip);
    }

    public static boolean isAllPayDrafBill(DynamicObjectCollection draftBills) {
        if (draftBills == null || draftBills.isEmpty()) {
            return false;
        }
        boolean result = true;
        for (DynamicObject draftBill : draftBills) {
            if ("paybill".equals(((DynamicObject)draftBill.get("fbasedataid")).getString("rptype")) && !"payoffed".equals(((DynamicObject)draftBill.get("fbasedataid")).getString("draftbillstatus"))) continue;
            result = false;
            break;
        }
        return result;
    }

    public static String getKey(Object settletype) {
        if (!CasHelper.isEmpty(settletype)) {
            String type;
            DynamicObject settle = (DynamicObject)settletype;
            switch (type = (String)settle.get("settlementtype")) {
                case "5": 
                case "6": {
                    return "isdraft";
                }
                case "1": {
                    return "ischeck";
                }
                case "2": {
                    return "ispromissorynote";
                }
            }
        }
        return "";
    }

    public static boolean isNoticeTicketPush(Object recbillId) {
        DynamicObject claimBill;
        DynamicObject[] claimBills;
        boolean isNoticeTicket = false;
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)recbillId, (String)"cas_recbill");
        if ("cas_claimcenterbill".equals(recBill.getString("sourcebilltype")) && !CasHelper.isEmpty(claimBills = BusinessDataServiceHelper.load((Object[])new Object[]{recBill.get("sourcebillid")}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)recBill.getString("sourcebilltype")))) && StringUtils.equals((CharSequence)(claimBill = claimBills[0]).getString("businesstype"), (CharSequence)"recticket")) {
            isNoticeTicket = true;
        }
        return isNoticeTicket;
    }

    public static boolean isHasRecDrafBill(DynamicObjectCollection drafBills) {
        for (DynamicObject drafBill : drafBills) {
            DynamicObject basedata = (DynamicObject)drafBill.get("fbasedataid");
            if (basedata == null || !"receivebill".equals(basedata.getString("rptype"))) continue;
            return true;
        }
        return false;
    }

    public static List<Object> getBillTypeIdList(Object settlementTypeId, String settlementType) {
        DynamicObject[] dynObjWithId = null;
        dynObjWithId = BusinessDataServiceHelper.load((String)"cdm_billtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("settlementtypebd.fbasedataid.id", "in", settlementTypeId)});
        if (dynObjWithId.length == 0) {
            dynObjWithId = BusinessDataServiceHelper.load((String)"cdm_billtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("settlementtype", "=", (Object)settlementType), QFilter.isNull((String)"settlementtypebd.fbasedataid.id")});
        }
        return Arrays.stream(dynObjWithId).filter(Objects::nonNull).map(DataEntityBase::getPkValue).collect(Collectors.toList());
    }

    public static Set<String> getRelatedBillNoSet(DynamicObject payBillInfo) {
        HashSet<String> hasRelatedSet = new HashSet<String>();
        DynamicObjectCollection draftBillList = payBillInfo.getDynamicObjectCollection("draftbill");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)draftBillList)) {
            return hasRelatedSet;
        }
        DynamicObject[] draftDataArr = BusinessDataServiceHelper.load((Object[])draftBillList.stream().filter(e -> "paybill".equals(e.getString("fbasedataid.rptype"))).map(e -> e.get("fbasedataid.id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_payandrecdraft_f7"));
        Set draftIds = Arrays.stream(draftDataArr).map(o -> o.getLong("id")).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(draftIds)) {
            return hasRelatedSet;
        }
        QFilter filter = new QFilter("draftbill.fbasedataid", "in", draftIds);
        if (payBillInfo.getDataEntityState().getFromDatabase()) {
            filter.and(new QFilter("id", "!=", payBillInfo.getPkValue()));
        }
        Object[] payBillList = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,draftbill.fbasedataid,actpayamt,billstatus", (QFilter[])new QFilter[]{filter});
        HashMap draftIdAndNumMap = new HashMap(8);
        HashSet allDraftIdSet = new HashSet(8);
        HashSet<Long> payDraftIdSet = new HashSet<Long>(8);
        HashSet<Long> recDraftIdSet = new HashSet<Long>(8);
        if (EmptyUtil.isNoEmpty((Object[])payBillList)) {
            BigDecimal sum = Arrays.stream(payBillList).filter(payBill -> StringUtils.equals((CharSequence)payBill.getString("billstatus"), (CharSequence)BillStatusEnum.PAY.getValue())).map(payBill -> EmptyUtil.isNoEmpty((Object)payBill.get("actpayamt")) ? payBill.getBigDecimal("actpayamt") : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (BigDecimal.ZERO.compareTo(sum) == 0) {
                return hasRelatedSet;
            }
            Arrays.stream(payBillList).forEach(payBill -> {
                DynamicObjectCollection draftBillListFromDB = payBill.getDynamicObjectCollection("draftbill");
                draftBillListFromDB.stream().filter(Objects::nonNull).forEach(draftBill -> {
                    DynamicObject base = draftBill.getDynamicObject("fbasedataid");
                    if (EmptyUtil.isNoEmpty((DynamicObject)base) && draftIds.contains(base.getLong("id"))) {
                        String draftbillno = base.getString("draftbillno");
                        String rptypeStr = base.getString("rptype");
                        long draftId = base.getLong("id");
                        hasRelatedSet.add(draftbillno);
                        draftIdAndNumMap.put(draftId, draftbillno);
                        allDraftIdSet.add(draftId);
                        if ("paybill".equals(rptypeStr)) {
                            payDraftIdSet.add(draftId);
                        } else {
                            recDraftIdSet.add(draftId);
                        }
                    }
                });
            });
        }
        if (EmptyUtil.isNoEmpty(hasRelatedSet) && hasRelatedSet.size() > 0) {
            Set<Long> needRemoverecDraftIdSet;
            Set<String> newDraftIdSet = new HashSet<String>();
            Set<Long> needRemovepayDraftIdSet = DraftHelper.checkRefusedData(payDraftIdSet, "cdm_payablebill");
            if (EmptyUtil.isNoEmpty(needRemovepayDraftIdSet) && needRemovepayDraftIdSet.size() > 0) {
                allDraftIdSet.removeAll(needRemovepayDraftIdSet);
            }
            if (EmptyUtil.isNoEmpty(needRemoverecDraftIdSet = DraftHelper.checkRefusedData(recDraftIdSet, "cdm_receivablebill")) && needRemoverecDraftIdSet.size() > 0) {
                allDraftIdSet.removeAll(needRemoverecDraftIdSet);
            }
            if (EmptyUtil.isNoEmpty(allDraftIdSet) && allDraftIdSet.size() > 0) {
                newDraftIdSet = allDraftIdSet.stream().map(draftIdAndNumMap::get).collect(Collectors.toSet());
            }
            return newDraftIdSet;
        }
        return hasRelatedSet;
    }

    public static Map<Long, Set<Long>> getOnlyUsePayDraftBillMap(DynamicObject payBill) {
        HashMap<Long, Set<Long>> needUpdatePayDraftBillMap = new HashMap<Long, Set<Long>>(8);
        DynamicObjectCollection payBillDrafts = payBill.getDynamicObjectCollection("draftbill");
        HashSet<Long> payDraftBillIdSet = new HashSet<Long>(8);
        HashSet<String> rptypeSet = new HashSet<String>(8);
        for (DynamicObject payBillDraft : payBillDrafts) {
            DynamicObject fbasedataid = payBillDraft.getDynamicObject("fbasedataid");
            if (!EmptyUtil.isNoEmpty((DynamicObject)fbasedataid)) continue;
            String rpTypeStr = fbasedataid.getString("rptype");
            rptypeSet.add(rpTypeStr);
            if (!"paybill".equals(rpTypeStr)) continue;
            payDraftBillIdSet.add(fbasedataid.getLong("id"));
        }
        if (rptypeSet.size() == 1 && payDraftBillIdSet.size() > 0) {
            needUpdatePayDraftBillMap.put(payBill.getLong("id"), payDraftBillIdSet);
        }
        return needUpdatePayDraftBillMap;
    }

    public static Set<DynamicObject> updateDraftCasEntry(DynamicObject casBill, Set<Long> draftIdSet, String billType, String addOrDelete, String batchStr) {
        DynamicObject[] recBills;
        HashSet<DynamicObject> needUpdateDySet = new HashSet<DynamicObject>(8);
        if (EmptyUtil.isEmpty(draftIdSet)) {
            return needUpdateDySet;
        }
        String billno = casBill.getString("billno");
        String casBillType = casBill.getDataEntityType().getName();
        long payBillId = casBill.getLong("id");
        for (DynamicObject data : recBills = BusinessDataServiceHelper.load((String)billType, (String)"id,releatedcasbillentrys,releatedcasbillentrys.rel_billtype,releatedcasbillentrys.rel_billno,releatedcasbillentrys.rel_billid,releatedcasbillentrys.rel_bizdate,releatedcasbillentrys.rel_billamount,releatedcasbillentrys.rel_isrefuse,releatedcasbillentrys.rel_createtime,releatedcasbillentrys.rel_modifytime,releatedcasbillentrys.rel_batchuseflag", (QFilter[])new QFilter[]{new QFilter("id", "in", draftIdSet)})) {
            DynamicObjectCollection releatedcasbillEntrys = data.getDynamicObjectCollection("releatedcasbillentrys");
            Set matchCasBills = releatedcasbillEntrys.stream().filter(e1 -> payBillId == e1.getLong("rel_billid") && !e1.getBoolean("rel_isrefuse")).collect(Collectors.toSet());
            if ((EmptyUtil.isEmpty(matchCasBills) || matchCasBills.size() == 0) && "add".equals(addOrDelete)) {
                Date bizdate = casBill.getDate("bizdate");
                BigDecimal actpayamt = BigDecimal.ZERO;
                DynamicObject newCasBillEntry = releatedcasbillEntrys.addNew();
                newCasBillEntry.set("rel_billid", (Object)payBillId);
                newCasBillEntry.set("rel_billno", (Object)billno);
                if (casBillType.equalsIgnoreCase("cas_paybill")) {
                    actpayamt = casBill.getBigDecimal("actpayamt");
                } else if (casBillType.equalsIgnoreCase("cas_recbill")) {
                    actpayamt = casBill.getBigDecimal("actrecamt");
                }
                newCasBillEntry.set("rel_billtype", (Object)casBillType);
                newCasBillEntry.set("rel_bizdate", (Object)bizdate);
                newCasBillEntry.set("rel_billamount", (Object)actpayamt);
                newCasBillEntry.set("rel_createtime", (Object)new Date());
                newCasBillEntry.set("rel_modifytime", (Object)new Date());
                if (EmptyUtil.isNoEmpty((String)batchStr)) {
                    newCasBillEntry.set("rel_batchuseflag", (Object)batchStr);
                }
                needUpdateDySet.add(data);
                continue;
            }
            if (!EmptyUtil.isNoEmpty(matchCasBills) || !"delete".equals(addOrDelete)) continue;
            releatedcasbillEntrys.removeAll(matchCasBills);
            needUpdateDySet.add(data);
        }
        return needUpdateDySet;
    }

    public static Set<Long> getReleatedCasPayBill(QFilter payFilter, String cdmConstant) {
        Set<Long> hasCasPayIdSet = new HashSet<Long>(8);
        DynamicObjectCollection hasCasPayBillRecDraft = QueryServiceHelper.query((String)cdmConstant, (String)"id,releatedcasbillentrys,releatedcasbillentrys.rel_billtype", (QFilter[])new QFilter[]{payFilter, new QFilter("releatedcasbillentrys.rel_billtype", "=", (Object)"cas_paybill"), new QFilter("releatedcasbillentrys.rel_isrefuse", "=", (Object)"0")});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)hasCasPayBillRecDraft)) {
            hasCasPayIdSet = hasCasPayBillRecDraft.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        }
        return hasCasPayIdSet;
    }

    public static Set<Long> getReleatedRecPayBill(QFilter payFilter, String cdmConstant) {
        Set<Long> hasCasPayIdSet = new HashSet<Long>(8);
        DynamicObjectCollection hasCasRecBillRecDraft = QueryServiceHelper.query((String)cdmConstant, (String)"id,releatedcasbillentrys,releatedcasbillentrys.rel_billtype", (QFilter[])new QFilter[]{payFilter, new QFilter("releatedcasbillentrys.rel_billtype", "=", (Object)"cas_recbill")});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)hasCasRecBillRecDraft)) {
            hasCasPayIdSet = hasCasRecBillRecDraft.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        }
        return hasCasPayIdSet;
    }

    public static void addCasDraftInfoEntry(DynamicObjectCollection draftInfoEntries, DynamicObject draftBill) {
        DynamicObject newDraftEntry = draftInfoEntries.addNew();
        newDraftEntry.set("transamount", draftBill.get("amount"));
        newDraftEntry.set("paybillcurrency", draftBill.getDynamicObject("currency").getPkValue());
        newDraftEntry.set("draftbillinfo", (Object)draftBill);
    }

    public static Map<Long, BigDecimal> getNewestAvailamountMap(DynamicObjectCollection draftbillColl, String settlenumberOrDraft) {
        HashMap<Long, BigDecimal> draftIdAndAvailaAmountMap = new HashMap<Long, BigDecimal>(8);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)draftbillColl)) {
            logger.info("draftbillColl is null");
            return draftIdAndAvailaAmountMap;
        }
        HashSet<Long> payDraftIdSet = new HashSet<Long>(8);
        HashSet<Long> recDraftIdSet = new HashSet<Long>(8);
        if ("settlenumber".equals(settlenumberOrDraft)) {
            for (DynamicObject entryInfoDy : draftbillColl) {
                DynamicObject fbasedataid = entryInfoDy.getDynamicObject("fbasedataid");
                if (!EmptyUtil.isNoEmpty((DynamicObject)fbasedataid)) continue;
                long draftId = fbasedataid.getLong("id");
                String rptype = fbasedataid.getString("rptype");
                if ("paybill".equalsIgnoreCase(rptype)) {
                    payDraftIdSet.add(draftId);
                    continue;
                }
                recDraftIdSet.add(draftId);
            }
        } else if ("draft".equals(settlenumberOrDraft)) {
            for (DynamicObject draftDy : draftbillColl) {
                long draftId = draftDy.getLong("id");
                String rptype = draftDy.getString("rptype");
                if ("paybill".equalsIgnoreCase(rptype)) {
                    payDraftIdSet.add(draftId);
                    continue;
                }
                recDraftIdSet.add(draftId);
            }
        }
        if (EmptyUtil.isNoEmpty(payDraftIdSet)) {
            DynamicObjectCollection payDraftDyColl = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", payDraftIdSet)});
            Map<Long, BigDecimal> payDraftIdMap = payDraftDyColl.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getBigDecimal("availableamount")));
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)payDraftDyColl)) {
                draftIdAndAvailaAmountMap.putAll(payDraftIdMap);
            }
        }
        if (EmptyUtil.isNoEmpty(recDraftIdSet)) {
            DynamicObjectCollection recDraftDyColl = QueryServiceHelper.query((String)"cdm_receivablebill", (String)"id,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", recDraftIdSet)});
            Map<Long, BigDecimal> recDraftIdMap = recDraftDyColl.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getBigDecimal("availableamount")));
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)recDraftDyColl)) {
                draftIdAndAvailaAmountMap.putAll(recDraftIdMap);
            }
        }
        return draftIdAndAvailaAmountMap;
    }

    public static Set<Long> checkRefusedData(Set<Long> payDraftIdSet, String cdmConstant) {
        HashSet<Long> needRemoveDraftIdSet = new HashSet<Long>(16);
        if (EmptyUtil.isNoEmpty(payDraftIdSet) && payDraftIdSet.size() > 0) {
            DynamicObject[] hasCasPayBillRecDraftArr;
            for (DynamicObject hasCasPayBillRecDraft : hasCasPayBillRecDraftArr = BusinessDataServiceHelper.load((String)cdmConstant, (String)"id,releatedcasbillentrys,releatedcasbillentrys.rel_billtype,releatedcasbillentrys.rel_isrefuse", (QFilter[])new QFilter[]{new QFilter("id", "in", payDraftIdSet)})) {
                Set not_refuseSet;
                DynamicObjectCollection releatedcasbillentrys = hasCasPayBillRecDraft.getDynamicObjectCollection("releatedcasbillentrys");
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)releatedcasbillentrys) || releatedcasbillentrys.size() == 0 || !EmptyUtil.isEmpty(not_refuseSet = releatedcasbillentrys.stream().filter(e -> "cas_paybill".equals(e.getString("rel_billtype")) && !e.getBoolean("rel_isrefuse")).collect(Collectors.toSet())) && not_refuseSet.size() != 0) continue;
                long needRemoveDraftId = hasCasPayBillRecDraft.getLong("id");
                needRemoveDraftIdSet.add(needRemoveDraftId);
            }
        }
        return needRemoveDraftIdSet;
    }

    public static Map<Long, Set<Long>> getBatchDealCasBillId(DynamicObject[] paybills, Set<Long> dealReleRecIdSet, Map<Long, Long> releaIdAndPayIdMap, Map<Long, Set<Long>> payIdAndDraftIdSetMap) {
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(16);
        Map<Object, Object> payDraftBillsMap = new HashMap(16);
        Map<Object, Object> recDraftBillsMap = new HashMap(16);
        List recBillIds = Arrays.stream(paybills).map(o -> o.getLong("id")).collect(Collectors.toList());
        HashSet<Long> payDraftIdSet = new HashSet<Long>(16);
        HashSet<Long> recDraftIdSet = new HashSet<Long>(16);
        for (DynamicObject info : paybills) {
            DynamicObjectCollection draftInfoEntrys = info.getDynamicObjectCollection("cas_draftinfo");
            if (draftInfoEntrys.size() != 1) continue;
            DynamicObject draftDy = ((DynamicObject)draftInfoEntrys.get(0)).getDynamicObject("draftbillinfo");
            String rptype = draftDy.getString("rptype");
            if (rptype.equals("paybill")) {
                payDraftIdSet.add(draftDy.getLong("id"));
                continue;
            }
            recDraftIdSet.add(draftDy.getLong("id"));
        }
        if (EmptyUtil.isNoEmpty(payDraftIdSet)) {
            DynamicObjectCollection payDraftBills = QueryServiceHelper.query((String)"cdm_payablebill", (String)"id,releatedcasbillentrys,releatedcasbillentrys.rel_billtype,releatedcasbillentrys.rel_billno,releatedcasbillentrys.rel_billid,releatedcasbillentrys.rel_bizdate,releatedcasbillentrys.rel_billamount,releatedcasbillentrys.rel_isrefuse,releatedcasbillentrys.rel_batchuseflag", (QFilter[])new QFilter[]{new QFilter("id", "in", payDraftIdSet)});
            payDraftBillsMap = payDraftBills.stream().collect(Collectors.groupingBy(e -> e.getLong("id")));
        }
        if (EmptyUtil.isNoEmpty(recDraftIdSet)) {
            DynamicObjectCollection recDraftBills = QueryServiceHelper.query((String)"cdm_receivablebill", (String)"id,releatedcasbillentrys,releatedcasbillentrys.rel_billtype,releatedcasbillentrys.rel_billno,releatedcasbillentrys.rel_billid,releatedcasbillentrys.rel_bizdate,releatedcasbillentrys.rel_billamount,releatedcasbillentrys.rel_isrefuse,releatedcasbillentrys.rel_batchuseflag", (QFilter[])new QFilter[]{new QFilter("id", "in", recDraftIdSet)});
            recDraftBillsMap = recDraftBills.stream().collect(Collectors.groupingBy(e -> e.getLong("id")));
        }
        for (DynamicObject info : paybills) {
            long casBillId = info.getLong("id");
            DynamicObjectCollection draftInfoEntrys = info.getDynamicObjectCollection("cas_draftinfo");
            if (draftInfoEntrys.size() != 1) continue;
            HashSet<Long> draftIdSet = new HashSet<Long>(1);
            DynamicObject draftDy = ((DynamicObject)draftInfoEntrys.get(0)).getDynamicObject("draftbillinfo");
            long draftId = draftDy.getLong("id");
            draftIdSet.add(draftId);
            List recBills = new ArrayList(16);
            String rptype = draftDy.getString("rptype");
            recBills = rptype.equals("paybill") ? (List)payDraftBillsMap.get(draftId) : (List)recDraftBillsMap.get(draftId);
            List rel_batchuseflagList = recBills.stream().filter(e1 -> casBillId == e1.getLong("releatedcasbillentrys.rel_billid") && EmptyUtil.isNoEmpty((String)e1.getString("releatedcasbillentrys.rel_batchuseflag"))).map(e1 -> e1.getString("releatedcasbillentrys.rel_batchuseflag")).collect(Collectors.toList());
            if (!EmptyUtil.isNoEmpty(rel_batchuseflagList) || rel_batchuseflagList.size() <= 0) continue;
            String rel_batchuseflag = (String)rel_batchuseflagList.get(0);
            Set rel_billidSet = recBills.stream().filter(e2 -> casBillId != e2.getLong("releatedcasbillentrys.rel_billid") && rel_batchuseflag.equals(e2.getString("releatedcasbillentrys.rel_batchuseflag"))).map(e2 -> e2.getLong("releatedcasbillentrys.rel_billid")).collect(Collectors.toSet());
            if (!EmptyUtil.isNoEmpty(rel_billidSet) || rel_billidSet.size() <= 0) continue;
            HashSet<Long> notInCallButBatchReleaRecIdSet = new HashSet<Long>(16);
            for (Long rel_billid : rel_billidSet) {
                if (recBillIds.contains(rel_billid)) continue;
                if (!dealReleRecIdSet.contains(rel_billid)) {
                    notInCallButBatchReleaRecIdSet.add(rel_billid);
                    releaIdAndPayIdMap.put(rel_billid, casBillId);
                }
                dealReleRecIdSet.add(rel_billid);
            }
            if (!EmptyUtil.isNoEmpty(notInCallButBatchReleaRecIdSet) || notInCallButBatchReleaRecIdSet.size() <= 0) continue;
            map.put(casBillId, notInCallButBatchReleaRecIdSet);
            payIdAndDraftIdSetMap.put(casBillId, draftIdSet);
        }
        return map;
    }

    public static void setSubBillInfo(DynamicObject targetBill, BigDecimal actpayamt) {
        boolean issplit = targetBill.getBoolean("issplit");
        if (issplit) {
            targetBill.set("standardbillamount", (Object)new BigDecimal("0.01"));
            String subbillrange = targetBill.getString("subbillrange");
            if (EmptyUtil.isEmpty((String)subbillrange) || "0".equals(subbillrange)) {
                long subEndFlag = actpayamt.multiply(new BigDecimal("100")).longValue();
                long subStartFlag = 1L;
                targetBill.set("subbillrange", (Object)(subStartFlag + "-" + subEndFlag));
                targetBill.set("subbillquantity", (Object)subEndFlag);
                targetBill.set("subbillstartflag", (Object)1L);
                targetBill.set("subbillendflag", (Object)subEndFlag);
            }
        }
    }

    public static String getValidateMsg(String batchStr, ValidateResultCollection validateResults) {
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append(batchStr);
        errorMsg.append("\r\n");
        if (null != validateResults) {
            List list = validateResults.getValidateErrors();
            for (ValidateResult vr : list) {
                List errInfoList = vr.getAllErrorInfo();
                for (OperateErrorInfo info : errInfoList) {
                    errorMsg.append(info.getMessage()).append("\r\n");
                }
            }
        }
        return errorMsg.toString();
    }

    public static String getNeedPreRecButNotRec(DynamicObject[] draftBillColl) {
        logger.info("getNeedPreRecButNotRec is start");
        String errorMsg = "";
        HashMap orgIdAndDrftIdMap = new HashMap(16);
        HashMap<Long, String> draftIdAndDrfBillnoMap = new HashMap<Long, String>(16);
        for (DynamicObject draftDy : draftBillColl) {
            String rptype = draftDy.getString("rptype");
            if (!"receivebill".equalsIgnoreCase(rptype)) continue;
            draftIdAndDrfBillnoMap.put(draftDy.getLong("id"), draftDy.getString("billno"));
            long companyId = draftDy.getDynamicObject("company").getLong("id");
            Set draftBillIdSet = (Set)orgIdAndDrftIdMap.get(companyId);
            if (EmptyUtil.isNoEmpty((Object)draftBillIdSet)) {
                draftBillIdSet.add(draftDy.getLong("id"));
                continue;
            }
            HashSet<Long> draftBillIdSetNew = new HashSet<Long>(1);
            draftBillIdSetNew.add(draftDy.getLong("id"));
            orgIdAndDrftIdMap.put(companyId, draftBillIdSetNew);
        }
        HashSet needCheckDraftIdSet = new HashSet(16);
        for (Map.Entry entry : orgIdAndDrftIdMap.entrySet()) {
            Set draftIds;
            boolean isneedrecfirst;
            Long orgId = (Long)entry.getKey();
            String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
            Object isneedrecfirstOb = SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)orgId, (String)"isneedrecfirst");
            if (null == isneedrecfirstOb || !(isneedrecfirst = ((Boolean)isneedrecfirstOb).booleanValue()) || !EmptyUtil.isNoEmpty((Object)(draftIds = (Set)entry.getValue()))) continue;
            needCheckDraftIdSet.addAll(draftIds);
        }
        if (EmptyUtil.isNoEmpty(needCheckDraftIdSet)) {
            QFilter filter = new QFilter("draftbill.fbasedataid.id", "in", needCheckDraftIdSet);
            filter.and("billstatus", "=", (Object)BillStatusEnum.PAY.getValue());
            DynamicObjectCollection cas_recbills = QueryServiceHelper.query((String)"cas_recbill", (String)"draftbill.fbasedataid.id as draftid", (QFilter[])new QFilter[]{filter});
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)cas_recbills)) {
                Set haRecDraftIdSet = cas_recbills.stream().map(e -> e.getLong("draftid")).collect(Collectors.toSet());
                boolean bl = needCheckDraftIdSet.removeAll(haRecDraftIdSet);
            }
            if (EmptyUtil.isNoEmpty(needCheckDraftIdSet)) {
                StringJoiner stringJoiner = new StringJoiner("\r\n");
                for (Long draftid : needCheckDraftIdSet) {
                    String drfatbillnoStr = (String)draftIdAndDrfBillnoMap.get(draftid);
                    String msg = ResManager.loadKDString((String)"\u5e94\u6536\u7968\u636e \u201c%s\u201d \u672a\u5b8c\u6210\u7968\u636e\u6536\u6b3e\u4e1a\u52a1\u95ed\u73af\uff0c\u8bf7\u5148\u5b8c\u6210\u7968\u636e\u6536\u6b3e\u540e\u518d\u7528\u4e8e\u4ed8\u6b3e\u3002", (String)"DraftHelper_9", (String)"fi-cas-common", (Object[])new Object[]{drfatbillnoStr});
                    stringJoiner.add(msg);
                }
                if (EmptyUtil.isNoEmpty((Object)stringJoiner)) {
                    errorMsg = stringJoiner.toString();
                }
            }
        }
        return errorMsg;
    }

    public static Set<Long> getCorrectEndorseTRadeDraftId(DynamicObject[] billHandleDataArr) {
        HashSet<Long> realNeedQueryDraftIdSet = new HashSet<Long>(16);
        HashSet<Long> tradeBillIdSet = new HashSet<Long>(16);
        HashSet billIdList = new HashSet(16);
        HashMap tradeIdAndDraftIdSetMap = new HashMap(16);
        for (DynamicObject billHandleData : billHandleDataArr) {
            long draftradeBillId = billHandleData.getLong("id");
            DynamicObjectCollection draftEntrys = billHandleData.getDynamicObjectCollection("entrys");
            Set draftIdSet = draftEntrys.stream().map(i -> i.getDynamicObject("draftbill").getLong("id")).collect(Collectors.toSet());
            if (!EmptyUtil.isNoEmpty(draftIdSet)) continue;
            tradeIdAndDraftIdSetMap.put(draftradeBillId, draftIdSet);
            tradeBillIdSet.add(draftradeBillId);
            billIdList.addAll(draftIdSet);
        }
        DynamicObjectCollection splitBillIdColl = QueryServiceHelper.query((String)"cdm_receivablebill", (String)"id,equaltradebillid,supperbillid", (QFilter[])new QFilter[]{new QFilter("equaltradebillid", "in", tradeBillIdSet)});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)splitBillIdColl) && splitBillIdColl.size() > 0) {
            HashMap<String, Long> subAndSupperIdMap = new HashMap<String, Long>(16);
            HashSet<Long> hasSplitTradeBillIdSet = new HashSet<Long>(16);
            for (DynamicObject splitBillIdDy : splitBillIdColl) {
                long supperbillid = splitBillIdDy.getLong("supperbillid");
                long equaltradebillid = splitBillIdDy.getLong("equaltradebillid");
                long subDraftId = splitBillIdDy.getLong("id");
                String keyStr = equaltradebillid + "_" + supperbillid;
                subAndSupperIdMap.put(keyStr, subDraftId);
                hasSplitTradeBillIdSet.add(equaltradebillid);
            }
            for (DynamicObject billHandleData : billHandleDataArr) {
                long draftradeBillId = billHandleData.getLong("id");
                if (!hasSplitTradeBillIdSet.contains(draftradeBillId)) {
                    Set draftIdSet = (Set)tradeIdAndDraftIdSetMap.get(draftradeBillId);
                    realNeedQueryDraftIdSet.addAll(draftIdSet);
                    continue;
                }
                DynamicObjectCollection draftEntrys = billHandleData.getDynamicObjectCollection("entrys");
                for (DynamicObject draftEntry : draftEntrys) {
                    DynamicObject draftbill = draftEntry.getDynamicObject("draftbill");
                    if (!EmptyUtil.isNoEmpty((DynamicObject)draftbill)) continue;
                    long draftId = draftbill.getLong("id");
                    String keyStr = draftradeBillId + "_" + draftId;
                    Long subDraftId = (Long)subAndSupperIdMap.get(keyStr);
                    if (EmptyUtil.isNoEmpty((Long)subDraftId)) {
                        realNeedQueryDraftIdSet.add(subDraftId);
                        continue;
                    }
                    realNeedQueryDraftIdSet.add(draftId);
                }
            }
            Set splitBillIdSet = splitBillIdColl.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            billIdList.addAll(splitBillIdSet);
        } else {
            realNeedQueryDraftIdSet.addAll(billIdList);
        }
        return realNeedQueryDraftIdSet;
    }
}

