/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.Pair;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.consts.RefundConstants;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.QuotationHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.ArrayUtils;

public class RefundHelper {
    private static final String PAYBILL_SELECT_PROPERTIES = "id,billno,payeracctbank.bankaccountnumber,actpayamt,payee,payeename,payeebanknum,sourcebilltype,description,usage,dpamt,dpcurrency.id,currency.id";
    private static final String AGENTPAYBILL_SELECT_PROPERTIES = "id,billno,payeracctbank.bankaccountnumber,payamount,currency.id,isencryption,entry.id,entry.payeename,entry.e_encryptamount,entry.payeeacctbank,entry.e_remark,sourcebilltype,description,entry.e_issuccess,entry.e_isrefund,fee,entry.e_remainrefundamt";

    public static boolean isPaid(Long recbillId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "=", (Object)recbillId));
        qFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.PAY.getValue()));
        return QueryServiceHelper.exists((String)"cas_recbill", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    public static boolean isRefund(Long recbillId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "=", (Object)recbillId));
        qFilters.add(new QFilter("isrefund ", "=", (Object)"1"));
        return QueryServiceHelper.exists((String)"cas_recbill", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    @Deprecated
    public static DynamicObject[] loadPaymentBillsRenote(Long recbillId) {
        Object[] notDifferPayBills = RefundHelper.loadPaymentRenoteBills(recbillId, null, false);
        Object[] differPayBills = RefundHelper.loadPaymentRenoteBills(recbillId, null, true);
        return (DynamicObject[])ArrayUtils.addAll((Object[])notDifferPayBills, (Object[])differPayBills);
    }

    @Deprecated
    public static DynamicObject[] loadPaymentBillsRenote(Long recbillId, List<QFilter> lstFilters) {
        Object[] notDifferPayBills = RefundHelper.loadPaymentRenoteBills(recbillId, lstFilters, false);
        Object[] differPayBills = RefundHelper.loadPaymentRenoteBills(recbillId, lstFilters, true);
        return (DynamicObject[])ArrayUtils.addAll((Object[])notDifferPayBills, (Object[])differPayBills);
    }

    public static DynamicObjectCollection loadPaymentBillRenote(Long recbillId, List<QFilter> lstFilters) {
        DynamicObjectCollection notDifferPayBills = RefundHelper.loadPaymentRenoteBill(recbillId, lstFilters, false);
        DynamicObjectCollection differPayBills = RefundHelper.loadPaymentRenoteBill(recbillId, lstFilters, true);
        notDifferPayBills.addAll((Collection)differPayBills);
        return notDifferPayBills;
    }

    @Deprecated
    public static DynamicObject[] loadPaymentRenoteBills(Long recbillId, List<QFilter> lstFilters, boolean isDifferCurrency) {
        return (DynamicObject[])RefundHelper.loadPaymentRenoteBill(recbillId, lstFilters, isDifferCurrency).toArray((Object[])new DynamicObject[0]);
    }

    public static DynamicObjectCollection loadPaymentRenoteBill(Long recbillId, List<QFilter> lstFilters, boolean isDifferCurrency) {
        DynamicObject recbill = QueryServiceHelper.queryOne((String)"cas_recbill", (String)"refundbatchseqid,actrecamt,fee,accountbank.id,org.id,currency.id,receivingtype.ispartreceivable", (QFilter[])new QFilter("id", "=", (Object)recbillId).toArray());
        DynamicObjectCollection paybills = null;
        List<Object> payBillsFilters = new ArrayList<QFilter>();
        if (StringUtils.isNotEmpty((CharSequence)recbill.getString("refundbatchseqid"))) {
            payBillsFilters.add(new QFilter("batchseqid", "=", recbill.get("refundbatchseqid")));
            paybills = QueryServiceHelper.query((String)"cas_paybill", (String)PAYBILL_SELECT_PROPERTIES, (QFilter[])payBillsFilters.toArray(new QFilter[0]));
        }
        if (null == paybills || paybills.isEmpty()) {
            payBillsFilters = RefundHelper.buildPaymentBillQFilters(lstFilters, recbill, isDifferCurrency);
            paybills = QueryServiceHelper.query((String)"cas_paybill", (String)PAYBILL_SELECT_PROPERTIES, (QFilter[])payBillsFilters.toArray(new QFilter[0]));
        }
        return paybills;
    }

    public static boolean existsPaymentBillsRenote(Long recbillId) {
        boolean existsNotDifferPayBill = RefundHelper.existsPaymentRenoteBills(recbillId, false);
        boolean existsDifferPayBill = RefundHelper.existsPaymentRenoteBills(recbillId, true);
        return existsNotDifferPayBill || existsDifferPayBill;
    }

    public static boolean existsPaymentRenoteBills(Long recbillId, boolean isDifferCurrency) {
        DynamicObject recbill = BusinessDataServiceHelper.loadSingle((Object)recbillId, (String)"cas_recbill", (String)"refundbatchseqid,actrecamt,fee,accountbank.id,org.id,currency.id,receivingtype.ispartreceivable");
        boolean exists = false;
        List<Object> payBillsFilters = new ArrayList<QFilter>();
        if (StringUtils.isNotEmpty((CharSequence)recbill.getString("refundbatchseqid"))) {
            payBillsFilters.add(new QFilter("batchseqid", "=", recbill.get("refundbatchseqid")));
            exists = QueryServiceHelper.exists((String)"cas_paybill", (QFilter[])payBillsFilters.toArray(new QFilter[0]));
        }
        if (!exists) {
            payBillsFilters = RefundHelper.buildPaymentBillQFilters(null, recbill, isDifferCurrency);
            exists = QueryServiceHelper.exists((String)"cas_paybill", (QFilter[])payBillsFilters.toArray(new QFilter[0]));
        }
        return exists;
    }

    private static List<QFilter> buildPaymentBillQFilters(List<QFilter> lstFilters, DynamicObject recbill, boolean isDifferCurrency) {
        ArrayList<QFilter> payBillsFilters = new ArrayList<QFilter>();
        if (lstFilters != null) {
            payBillsFilters.addAll(lstFilters);
        }
        payBillsFilters.add(new QFilter("payeracctbank", "=", (Object)recbill.getLong("accountbank.id")));
        payBillsFilters.add(new QFilter("org.id", "=", (Object)recbill.getLong("org.id")));
        if (isDifferCurrency) {
            RefundHelper.refundAddDifferFilters(payBillsFilters, recbill);
        } else {
            payBillsFilters.add(new QFilter("currency", "=", (Object)recbill.getLong("currency.id")));
            Set<String> statusSet = RefundHelper.getCanRefundStatus();
            payBillsFilters.add(new QFilter("billstatus", "in", statusSet));
            payBillsFilters.add(new QFilter("isdiffcur", "=", (Object)"0"));
        }
        return payBillsFilters;
    }

    @Deprecated
    public static DynamicObject[] loadAgentPayBillsRenote(Long recbillId) {
        return RefundHelper.loadAgentRenotePayBills(recbillId, null);
    }

    @Deprecated
    public static DynamicObject[] loadAgentPayBillsRenote(Long recbillId, List<QFilter> lstFilters) {
        return RefundHelper.loadAgentRenotePayBills(recbillId, lstFilters);
    }

    @Deprecated
    public static DynamicObject[] loadAgentRenotePayBills(Long recbillId, List<QFilter> lstFilters) {
        return (DynamicObject[])RefundHelper.loadAgentRenotePayBill(recbillId, lstFilters).toArray((Object[])new DynamicObject[0]);
    }

    public static DynamicObjectCollection loadAgentRenotePayBill(Long recbillId, List<QFilter> lstFilters) {
        DynamicObject recbill = QueryServiceHelper.queryOne((String)"cas_recbill", (String)"refundbatchseqid,accountbank.id,org.id,currency.id", (QFilter[])new QFilter("id", "=", (Object)recbillId).toArray());
        DynamicObjectCollection agentpaybills = null;
        List<Object> agentPayBillsFilters = new ArrayList<QFilter>();
        if (StringUtils.isNotEmpty((CharSequence)recbill.getString("refundbatchseqid"))) {
            agentPayBillsFilters.add(new QFilter("batchseqid", "=", recbill.get("refundbatchseqid")));
            agentpaybills = QueryServiceHelper.query((String)"cas_agentpaybill", (String)AGENTPAYBILL_SELECT_PROPERTIES, (QFilter[])agentPayBillsFilters.toArray(new QFilter[0]));
        }
        if (null == agentpaybills || agentpaybills.isEmpty()) {
            agentPayBillsFilters = RefundHelper.buildAgentBillQFilters(lstFilters, recbill);
            agentpaybills = QueryServiceHelper.query((String)"cas_agentpaybill", (String)AGENTPAYBILL_SELECT_PROPERTIES, (QFilter[])agentPayBillsFilters.toArray(new QFilter[0]));
        }
        return agentpaybills;
    }

    public static boolean existsAgentPayBillsRenote(Long recbillId) {
        return RefundHelper.existsAgentRenotePayBills(recbillId);
    }

    public static boolean existsAgentRenotePayBills(Long recbillId) {
        DynamicObject recbill = BusinessDataServiceHelper.loadSingle((Object)recbillId, (String)"cas_recbill", (String)"refundbatchseqid,accountbank.id,org.id,currency.id");
        boolean exists = false;
        List<Object> agentPayBillsFilters = new ArrayList<QFilter>();
        if (StringUtils.isNotEmpty((CharSequence)recbill.getString("refundbatchseqid"))) {
            agentPayBillsFilters.add(new QFilter("batchseqid", "=", recbill.get("refundbatchseqid")));
            exists = QueryServiceHelper.exists((String)"cas_agentpaybill", (QFilter[])agentPayBillsFilters.toArray(new QFilter[0]));
        }
        if (!exists) {
            agentPayBillsFilters = RefundHelper.buildAgentBillQFilters(null, recbill);
            exists = QueryServiceHelper.exists((String)"cas_agentpaybill", (QFilter[])agentPayBillsFilters.toArray(new QFilter[0]));
        }
        return exists;
    }

    private static List<QFilter> buildAgentBillQFilters(List<QFilter> lstFilters, DynamicObject recbill) {
        ArrayList<QFilter> agentPayBillsFilters = new ArrayList<QFilter>();
        if (lstFilters != null) {
            agentPayBillsFilters.addAll(lstFilters);
        }
        agentPayBillsFilters.add(new QFilter("payeracctbank", "=", (Object)recbill.getLong("accountbank.id")));
        agentPayBillsFilters.add(new QFilter("org.id", "=", (Object)recbill.getLong("org.id")));
        agentPayBillsFilters.add(new QFilter("currency", "=", (Object)recbill.getLong("currency.id")));
        agentPayBillsFilters.add(new QFilter("entry.e_issuccess", "=", (Object)"1"));
        agentPayBillsFilters.add(new QFilter("entry.e_isrefund", "=", (Object)"0"));
        return agentPayBillsFilters;
    }

    public static boolean isExistPayBills(Long recbillId) {
        boolean existsPayBill = RefundHelper.existsPaymentBillsRenote(recbillId);
        boolean existsAgentPayBill = RefundHelper.existsAgentPayBillsRenote(recbillId);
        return existsPayBill || existsAgentPayBill;
    }

    public static DynamicObject[] loadPaymentBillsRefund(Long recbillId) {
        Object[] notDifferPayBills = RefundHelper.loadPaymentBills(recbillId, null, false);
        Object[] differPayBills = RefundHelper.loadPaymentBills(recbillId, null, true);
        return (DynamicObject[])ArrayUtils.addAll((Object[])notDifferPayBills, (Object[])differPayBills);
    }

    @Deprecated
    public static DynamicObject[] loadPaymentBillsRefund(Long recbillId, List<QFilter> lstFilters) {
        Object[] notDifferPayBills = RefundHelper.loadPaymentBills(recbillId, lstFilters, false);
        Object[] differPayBills = RefundHelper.loadPaymentBills(recbillId, lstFilters, true);
        return (DynamicObject[])ArrayUtils.addAll((Object[])notDifferPayBills, (Object[])differPayBills);
    }

    public static DynamicObjectCollection loadPaymentBillRefund(Long recbillId, List<QFilter> lstFilters) {
        DynamicObjectCollection notDifferPayBills = RefundHelper.loadRefundPaymentBill(recbillId, lstFilters, false);
        DynamicObjectCollection differPayBills = RefundHelper.loadRefundPaymentBill(recbillId, lstFilters, true);
        notDifferPayBills.addAll((Collection)differPayBills);
        return notDifferPayBills;
    }

    @Deprecated
    public static DynamicObject[] loadPaymentBills(Long recbillId, List<QFilter> lstFilters, boolean isDifferCurrency) {
        return (DynamicObject[])RefundHelper.loadRefundPaymentBill(recbillId, lstFilters, isDifferCurrency).toArray((Object[])new DynamicObject[0]);
    }

    public static DynamicObjectCollection loadRefundPaymentBill(Long recbillId, List<QFilter> lstFilters, boolean isDifferCurrency) {
        DynamicObject recbill = QueryServiceHelper.queryOne((String)"cas_recbill", (String)"actrecamt,fee,currency.id,org.id,receivingtype.ispartreceivable", (QFilter[])new QFilter("id", "=", (Object)recbillId).toArray());
        List<QFilter> payBillsFilters = RefundHelper.getPayBillRefundCommonFilters(isDifferCurrency, recbill);
        if (lstFilters != null) {
            payBillsFilters.addAll(lstFilters);
        }
        DynamicObjectCollection paybills = QueryServiceHelper.query((String)"cas_paybill", (String)PAYBILL_SELECT_PROPERTIES, (QFilter[])payBillsFilters.toArray(new QFilter[0]));
        return paybills;
    }

    private static List<QFilter> getPayBillRefundCommonFilters(boolean isDifferCurrency, DynamicObject recbill) {
        ArrayList<QFilter> payBillsFilters = new ArrayList<QFilter>();
        if (isDifferCurrency) {
            RefundHelper.refundAddDifferFilters(payBillsFilters, recbill);
        } else {
            payBillsFilters.add(new QFilter("currency", "=", (Object)recbill.getLong("currency.id")));
            Set<String> statusSet = RefundHelper.getCanRefundStatus();
            payBillsFilters.add(new QFilter("billstatus", "in", statusSet));
            payBillsFilters.add(new QFilter("isdiffcur", "=", (Object)"0"));
        }
        payBillsFilters.add(new QFilter("org.id", "=", (Object)recbill.getLong("org.id")));
        return payBillsFilters;
    }

    public static DynamicObject[] loadAgentPayBillsRefund(Long recbillId) {
        return RefundHelper.loadAgentPayBills(recbillId, null);
    }

    @Deprecated
    public static DynamicObject[] loadAgentPayBillsRefund(Long recbillId, List<QFilter> lstFilters) {
        return RefundHelper.loadAgentPayBills(recbillId, lstFilters);
    }

    public static DynamicObject[] loadAgentPayBills(Long recbillId, List<QFilter> lstFilters) {
        return (DynamicObject[])RefundHelper.loadAgentRefundPayBill(recbillId, lstFilters).toArray((Object[])new DynamicObject[0]);
    }

    public static DynamicObjectCollection loadAgentRefundPayBill(Long recbillId, List<QFilter> lstFilters) {
        DynamicObject recbill = QueryServiceHelper.queryOne((String)"cas_recbill", (String)"currency.id,org.id", (QFilter[])new QFilter("id", "=", (Object)recbillId).toArray());
        List<QFilter> agentPayBillsFilters = RefundHelper.getAgentRefundCommonFilter(recbill);
        if (null != lstFilters) {
            agentPayBillsFilters.addAll(lstFilters);
        }
        DynamicObjectCollection agentpaybills = QueryServiceHelper.query((String)"cas_agentpaybill", (String)AGENTPAYBILL_SELECT_PROPERTIES, (QFilter[])agentPayBillsFilters.toArray(new QFilter[0]));
        return agentpaybills;
    }

    private static List<QFilter> getAgentRefundCommonFilter(DynamicObject recbill) {
        ArrayList<QFilter> agentPayBillsFilters = new ArrayList<QFilter>();
        agentPayBillsFilters.add(new QFilter("currency", "=", (Object)recbill.getLong("currency.id")));
        agentPayBillsFilters.add(new QFilter("org.id", "=", (Object)recbill.getLong("org.id")));
        agentPayBillsFilters.add(new QFilter("entry.e_issuccess", "=", (Object)"1"));
        return agentPayBillsFilters;
    }

    public static boolean isExistPayBillsRefund(Long recbillId) {
        DynamicObject recbill = QueryServiceHelper.queryOne((String)"cas_recbill", (String)"actrecamt,fee,currency.id,org.id,receivingtype.ispartreceivable", (QFilter[])new QFilter("id", "=", (Object)recbillId).toArray());
        List<QFilter> payBillsFilters = RefundHelper.getPayBillRefundCommonFilters(true, recbill);
        List<QFilter> differCurrencyPayBillsFilters = RefundHelper.getPayBillRefundCommonFilters(false, recbill);
        List<QFilter> agentRefundCommonFilter = RefundHelper.getAgentRefundCommonFilter(recbill);
        return QueryServiceHelper.exists((String)"cas_paybill", (QFilter[])payBillsFilters.toArray(new QFilter[0])) || QueryServiceHelper.exists((String)"cas_paybill", (QFilter[])differCurrencyPayBillsFilters.toArray(new QFilter[0])) || QueryServiceHelper.exists((String)"cas_agentpaybill", (QFilter[])agentRefundCommonFilter.toArray(new QFilter[0]));
    }

    public static boolean isSettled(Long recbillId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("id", "=", (Object)recbillId));
        qFilters.add(new QFilter("entry.e_settledamt", ">", (Object)BigDecimal.ZERO));
        return QueryServiceHelper.exists((String)"cas_recbill", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    public static boolean isExistTransHandleBillsRefund(long recBillId) {
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)recBillId, (String)"cas_recbill", (String)"payername,actrecamt,fee,receivingtype.ispartreceivable,receivingtype.ispartreceivable,payer,currency.id,inneraccount.company.id,accountbank.id");
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>(1);
        lstFilters.add(new QFilter("agentpayeraccount.id", "=", (Object)recBill.getLong("accountbank.id")));
        return QueryServiceHelper.exists((String)"ifm_transhandlebill", (QFilter[])RefundHelper.buildIfmQFilter(recBill, lstFilters).toArray(new QFilter[0]));
    }

    public static boolean isExistTransHandleBillsRefundMoney(long recBillId) {
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)recBillId, (String)"cas_recbill", (String)"payername,actrecamt,fee,receivingtype.ispartreceivable,receivingtype.ispartreceivable,payer,currency.id,inneraccount.company.id");
        ArrayList<QFilter> lstFilters = new ArrayList<QFilter>(1);
        lstFilters.add(new QFilter("payee", "=", recBill.get("payer")));
        return QueryServiceHelper.exists((String)"ifm_transhandlebill", (QFilter[])RefundHelper.buildIfmQFilter(recBill, lstFilters).toArray(new QFilter[0]));
    }

    public static List<QFilter> buildIfmQFilter(DynamicObject recBill, List<QFilter> lstFilters) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter("paidstatus", "=", (Object)"D"));
        qFilterList.add(new QFilter("paymenttype.ispartpayment", "=", recBill.get("receivingtype.ispartreceivable")));
        qFilterList.add(new QFilter("currency.id", "=", recBill.get("currency.id")));
        qFilterList.add(new QFilter("org.id", "=", recBill.get("inneraccount.company.id")));
        BigDecimal actrecamt = recBill.getBigDecimal("actrecamt");
        BigDecimal fee = recBill.getBigDecimal("fee");
        if (actrecamt != null && fee != null) {
            actrecamt = actrecamt.add(fee);
        }
        qFilterList.add(new QFilter("actpayamt", ">=", (Object)actrecamt));
        if (lstFilters != null) {
            qFilterList.addAll(lstFilters);
        }
        return qFilterList;
    }

    public static DynamicObjectCollection loadIfmTransHandleBills(DynamicObject recBill, List<QFilter> lstFilters) {
        String select = "id,billno,payeracctbank.number,currency.id,actpayamt,payeename,payeebanknum,description,usage,sourcebilltype";
        return QueryServiceHelper.query((String)"ifm_transhandlebill", (String)select, (QFilter[])RefundHelper.buildIfmQFilter(recBill, lstFilters).toArray(new QFilter[0]), null);
    }

    private static Set<String> getCanRefundStatus() {
        HashSet<String> statusSet = new HashSet<String>(3);
        statusSet.add(BillStatusEnum.PAY.getValue());
        statusSet.add(BillStatusEnum.RENOTE.getValue());
        statusSet.add(BillStatusEnum.REFUND.getValue());
        return statusSet;
    }

    public static Pair<List<DynamicObject>, Map<Long, BigDecimal>> getRefundEntryAndAmt(DynamicObject paybill, List<DynamicObject> reles, boolean releWithInfo) {
        List<Object> refundEntryList;
        Map<Long, BigDecimal> entryIdWithRefundAmt;
        DynamicObjectCollection entryList = paybill.getDynamicObjectCollection("entry");
        if (paybill.getBoolean("isdiffcur")) {
            Map<Long, BigDecimal> entryIdWithRefundAmt2 = entryList.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getBigDecimal("e_payableamt")));
            return new Pair((Object)entryList, entryIdWithRefundAmt2);
        }
        if (releWithInfo) {
            entryIdWithRefundAmt = reles.stream().filter(r -> BigDecimal.ZERO.compareTo(r.getBigDecimal("currentrefundamt")) != 0).collect(Collectors.toMap(r -> r.getLong("entryid"), r -> r.getBigDecimal("currentrefundamt")));
            refundEntryList = entryList.stream().filter(e -> entryIdWithRefundAmt.containsKey(e.getLong("id"))).collect(Collectors.toList());
        } else {
            refundEntryList = new ArrayList(entryList.size());
            entryIdWithRefundAmt = new HashMap<Long, BigDecimal>((int)((double)entryList.size() / 0.75) + 1);
            entryList.sort(Comparator.comparing(e -> e.getBigDecimal("e_remainrefundamt")));
            BigDecimal currentRefundAmt = reles.stream().filter(r -> r.getLong("id") == ((Long)paybill.getPkValue()).longValue()).map(r -> r.getBigDecimal("currentrefundamt")).findFirst().orElse(BigDecimal.ZERO);
            for (DynamicObject entry : entryList) {
                if (currentRefundAmt.compareTo(BigDecimal.ZERO) == 0) break;
                BigDecimal remainRefundAmt = entry.getBigDecimal("e_remainrefundamt");
                if (remainRefundAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                if (remainRefundAmt.compareTo(BigDecimal.ZERO) < 0 && currentRefundAmt.compareTo(BigDecimal.ZERO) > 0 || remainRefundAmt.abs().compareTo(currentRefundAmt.abs()) <= 0) {
                    entryIdWithRefundAmt.put((Long)entry.getPkValue(), remainRefundAmt);
                    currentRefundAmt = currentRefundAmt.subtract(remainRefundAmt);
                } else {
                    entryIdWithRefundAmt.put((Long)entry.getPkValue(), currentRefundAmt);
                    currentRefundAmt = BigDecimal.ZERO;
                }
                refundEntryList.add(entry);
            }
        }
        return new Pair(refundEntryList, entryIdWithRefundAmt);
    }

    public static void setSomeRefundAmtFields(DynamicObject[] bills, String entityType) {
        Function<DynamicObject, BigDecimal> amtFun = "cas_paybill".equals(entityType) ? payBillEntry -> payBillEntry.getBigDecimal("e_payableamt") : agentBillEntry -> {
            if (agentBillEntry.getBoolean("e_issuccess")) {
                return AgentPayBillHelper.decodeAmount(agentBillEntry.getString("e_encryptamount"));
            }
            return BigDecimal.ZERO;
        };
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entryList = bill.getDynamicObjectCollection("entry");
            if (CollectionUtils.isEmpty((Collection)entryList)) continue;
            BigDecimal payableAmtSum = BigDecimal.ZERO;
            BigDecimal totalRefundedAmt = BigDecimal.ZERO;
            for (DynamicObject entry : entryList) {
                BigDecimal ePayableAmt = amtFun.apply(entry);
                BigDecimal refundAmt = entry.getBigDecimal("e_refundamt");
                entry.set("e_remainrefundamt", (Object)ePayableAmt.subtract(refundAmt));
                payableAmtSum = payableAmtSum.add(ePayableAmt);
                totalRefundedAmt = totalRefundedAmt.add(refundAmt);
            }
            bill.set("totalrefundedamt", (Object)totalRefundedAmt);
            BigDecimal totalRemainRefundAmt = payableAmtSum.subtract(totalRefundedAmt);
            bill.set("totalremainrefundamt", (Object)totalRemainRefundAmt);
            BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
            if (exchangeRate == null || exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
                exchangeRate = BigDecimal.ONE;
            }
            if ("0".equals(bill.getString("payquotation"))) {
                bill.set("localrefundedamt", (Object)totalRefundedAmt.multiply(exchangeRate));
                bill.set("localremainrefundamt", (Object)totalRemainRefundAmt.multiply(exchangeRate));
                continue;
            }
            bill.set("localrefundedamt", (Object)totalRefundedAmt.divide(exchangeRate, 10, RoundingMode.DOWN));
            bill.set("localremainrefundamt", (Object)totalRemainRefundAmt.divide(exchangeRate, 10, RoundingMode.DOWN));
        }
    }

    public static DynamicObject[] queryHadRefundBills(Long revId, String entityName) {
        if (!"cas_paybill".equals(entityName) && !"cas_agentpaybill".equals(entityName)) {
            return new DynamicObject[0];
        }
        String billIdSql = "cas_paybill".equals(entityName) ? "select fid from T_CAS_PAYMENTBILL_REV where frevid = ? group by fid" : "select fid from T_CAS_AGENTPAYBILL_REV where frevid = ? group by fid";
        DataSet dataSet = DB.queryDataSet((String)"queryBillIds", (DBRoute)DBRouteConst.cas, (String)billIdSql, (Object[])new Object[]{revId});
        Set<Object> ids = new HashSet();
        for (Row row : dataSet) {
            Long payOrAgentId = row.getLong("fid");
            ids.add(payOrAgentId);
        }
        if (ids.isEmpty()) {
            ids = RefundHelper.queryOldBillIds(revId, entityName);
        }
        if (ids.isEmpty()) {
            return new DynamicObject[0];
        }
        return BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
    }

    private static Set<Long> queryOldBillIds(Long revId, String entityName) {
        String sql;
        QFilter filter;
        if ("cas_paybill".equals(entityName)) {
            filter = new QFilter("refundbillid", "=", (Object)revId).and("entry.e_refundamt", "!=", (Object)BigDecimal.ZERO);
            sql = "insert into T_CAS_PAYMENTBILL_REV (fid,fentryid,fseq,frevid,fpentryid,frefundamt) values(?,?,?,?,?,?)";
        } else {
            filter = new QFilter("entry.refundbillid", "=", (Object)revId).and("entry.e_isrefund", "=", (Object)true).and("entry.e_refundamt", "!=", (Object)BigDecimal.ZERO);
            sql = "insert into T_CAS_AGENTPAYBILL_REV (fid,fentryid,fseq,frevid,fpentryid,frefundamt) values(?,?,?,?,?,?)";
        }
        DynamicObjectCollection billWithEntryList = QueryServiceHelper.query((String)entityName, (String)"id,entry.id,entry.e_refundamt", (QFilter[])filter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)billWithEntryList)) {
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(billWithEntryList.size());
            for (DynamicObject billEntry : billWithEntryList) {
                Object[] param = new Object[]{billEntry.getLong("id"), DBServiceHelper.genGlobalLongId(), 1, revId, billEntry.getLong("entry.id"), billEntry.get("entry.e_refundamt")};
                paramList.add(param);
            }
            DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, paramList);
            return billWithEntryList.stream().map(b -> b.getLong("id")).collect(Collectors.toSet());
        }
        return new HashSet<Long>(0);
    }

    public static Map<Long, DynamicObject> getPayEntryIdAndPayApplyEntryMap(Set<Long> paymentBillIdSet, String releBillType) {
        HashMap<Long, DynamicObject> payEntryIdAndPayApplyEntryMap = new HashMap<Long, DynamicObject>(16);
        if ("cas_paybill".equals(releBillType)) {
            QFilter qFilter = new QFilter("id", "in", paymentBillIdSet).and("sourcebilltype", "=", (Object)"cas_payapplybill");
            DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)String.join((CharSequence)",", RefundConstants.PAY_BILL_SELECT_FIELDS), (QFilter[])qFilter.toArray());
            Pair<Map<Long, DynamicObject>, Map<Long, DynamicObject>> pair = RefundHelper.getPayBillRelaPayApplyData(payBills);
            return (Map)pair.getValue();
        }
        return payEntryIdAndPayApplyEntryMap;
    }

    public static Map<Long, DynamicObject> getPayIdAndPayApplyBillMap(DynamicObject[] payBills) {
        Set payApplyBillIdSet;
        HashMap<Long, DynamicObject> payIdAndPayApplyBillMap = new HashMap<Long, DynamicObject>(16);
        if (EmptyUtil.isNoEmpty((Object[])payBills) && EmptyUtil.isNoEmpty(payApplyBillIdSet = Arrays.stream(payBills).map(pay -> pay.getLong("sourcebillid")).collect(Collectors.toSet()))) {
            DynamicObject[] payApplyBills = BusinessDataServiceHelper.load((String)"cas_payapplybill", (String)String.join((CharSequence)",", RefundConstants.PAY_APPLY_BILL_SELECT_FIELDS), (QFilter[])new QFilter("id", "in", payApplyBillIdSet).toArray());
            Map<Long, DynamicObject> idAndPayApplyBillMap = Arrays.stream(payApplyBills).collect(Collectors.toMap(payApply -> payApply.getLong("id"), dy -> dy, (m1, m2) -> m1));
            Arrays.stream(payBills).forEach(pay -> {
                DynamicObject payApplyBill = (DynamicObject)idAndPayApplyBillMap.get(pay.getLong("sourcebillid"));
                if (EmptyUtil.isNoEmpty((DynamicObject)payApplyBill)) {
                    payIdAndPayApplyBillMap.put(pay.getLong("id"), payApplyBill);
                }
            });
        }
        return payIdAndPayApplyBillMap;
    }

    public static Pair<Map<Long, DynamicObject>, Map<Long, DynamicObject>> getPayBillRelaPayApplyData(DynamicObject[] payBills) {
        Map<Long, DynamicObject> payIdAndPayApplyBillMap = RefundHelper.getPayIdAndPayApplyBillMap(payBills);
        HashMap<Long, DynamicObject> payEntryIdAndPayApplyEntryMap = new HashMap<Long, DynamicObject>(16);
        if (EmptyUtil.isNoEmpty((Object[])payBills)) {
            Map<Long, DynamicObject> idAndPayBillMap = Arrays.stream(payBills).collect(Collectors.toMap(pay -> pay.getLong("id"), dy -> dy, (m1, m2) -> m1));
            for (Map.Entry<Long, DynamicObject> entry : payIdAndPayApplyBillMap.entrySet()) {
                DynamicObject payBill = idAndPayBillMap.get(entry.getKey());
                DynamicObject payApplyBill = entry.getValue();
                DynamicObjectCollection payEntries = payBill.getDynamicObjectCollection("entry");
                DynamicObjectCollection payApplyEntries = payApplyBill.getDynamicObjectCollection("cas_payinfo");
                for (DynamicObject payEntry : payEntries) {
                    DynamicObject matchPayApplyEntry = payApplyEntries.stream().filter(patApplyEntry -> patApplyEntry.getPkValue().equals(payEntry.getLong("e_sourcebillentryid"))).findFirst().orElse(null);
                    if (!EmptyUtil.isNoEmpty((DynamicObject)matchPayApplyEntry)) continue;
                    payEntryIdAndPayApplyEntryMap.put(Long.parseLong(payEntry.getPkValue().toString()), matchPayApplyEntry);
                }
            }
        }
        return new Pair(payIdAndPayApplyBillMap, payEntryIdAndPayApplyEntryMap);
    }

    public static void updateEntrustAmt(DynamicObject bill, BigDecimal refundAmt, boolean cancelRefund) {
        BigDecimal agreedrate = bill.getBigDecimal("agreedrate");
        String agreedquotation = bill.getString("agreedquotation");
        DynamicObject updateBill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)bill.getDataEntityType().getName(), (String)"id,entrustamt");
        BigDecimal entrustamt = updateBill.getBigDecimal("entrustamt");
        BigDecimal dpRefundAmt = QuotationHelper.callToCurrency((BigDecimal)refundAmt, (BigDecimal)agreedrate, (String)agreedquotation, (int)10);
        BigDecimal newEntrustAmt = cancelRefund ? entrustamt.add(dpRefundAmt) : entrustamt.subtract(dpRefundAmt);
        updateBill.set("entrustamt", (Object)newEntrustAmt);
        SaveServiceHelper.update((DynamicObject)updateBill);
    }

    public static List<DynamicObject> copyReles(Long sourceBillId, List<DynamicObject> refundEntryList, List<DynamicObject> reles, boolean releWithInfo, String entityName) {
        Map<Long, DynamicObject> refundEntryMap = refundEntryList.stream().collect(Collectors.toMap(re -> (Long)re.getPkValue(), re -> re));
        boolean isPayBill = "cas_paybill".equals(entityName);
        ArrayList<DynamicObject> copyReles = new ArrayList<DynamicObject>(reles.size());
        for (DynamicObject rele : reles) {
            DynamicObjectType releType = rele.getDynamicObjectType();
            DynamicObject copyRele = new DynamicObject(releType);
            for (IDataEntityProperty property : releType.getJsonSerializerProperties()) {
                String name = property.getName();
                copyRele.set(name, rele.get(name));
            }
            copyRele.set("id", (Object)sourceBillId);
            if (releWithInfo && rele.getLong("entryid") != 0L) {
                DynamicObject refundEntry = refundEntryMap.get(rele.getLong("entryid"));
                if (isPayBill) {
                    copyRele.set("entryid", (Object)refundEntry.getLong("e_sourcebillentryid"));
                } else {
                    copyRele.set("entryid", (Object)refundEntry.getLong("sourceentryid"));
                }
            }
            copyReles.add(copyRele);
        }
        return copyReles;
    }

    public static List<DynamicObject> replaceEntrustBills(DynamicObject[] bills, Map<Long, DynamicObject> entrustSourceBills) {
        ArrayList<DynamicObject> writeBackBills = new ArrayList<DynamicObject>(bills.length);
        for (DynamicObject bill : bills) {
            DynamicObject sourceBill = entrustSourceBills.get((Long)bill.getPkValue());
            if (sourceBill != null) {
                writeBackBills.add(sourceBill);
                continue;
            }
            writeBackBills.add(bill);
        }
        return writeBackBills;
    }

    public static DynamicObjectCollection filterNotZeroRelaList(List<DynamicObject> relaList) {
        return relaList.stream().filter(rela -> rela.getBigDecimal("currentrefundamt").compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toCollection(DynamicObjectCollection::new));
    }

    public static QFilter buildPayBillFilterByTransBill(DynamicObject transDetailBill) {
        QFilter filter = new QFilter("payeracctbank", "=", (Object)transDetailBill.getLong("accountbank.id"));
        filter.and("dpcurrency", "=", transDetailBill.get("currency.id"));
        QFilter amtFilter = new QFilter("dpamt", "=", transDetailBill.get("creditamount")).or("dpamt", "=", (Object)transDetailBill.getBigDecimal("debitamount").negate());
        filter.and(amtFilter);
        Date nextDay = DateUtils.getNextDay((Date)transDetailBill.getDate("bizdate"), (int)1);
        Date transBillDate = DateUtils.getDataFormat((Date)nextDay, (boolean)true);
        filter.and("bizdate", "<", (Object)transBillDate);
        filter.and("billstatus", "=", (Object)BillStatusEnum.PAY.getValue());
        filter.and("totalrefundedamt", "=", (Object)BigDecimal.ZERO);
        return filter;
    }

    public static QFilter buildAgentBillFilterByTransBill(DynamicObject transDetailBill) {
        QFilter filter = new QFilter("payeracctbank", "=", (Object)transDetailBill.getLong("accountbank.id"));
        filter.and("currency", "=", transDetailBill.get("currency.id"));
        Date nextDay = DateUtils.getNextDay((Date)transDetailBill.getDate("bizdate"), (int)1);
        Date transBillDate = DateUtils.getDataFormat((Date)nextDay, (boolean)true);
        filter.and("bizdate", "<", (Object)transBillDate);
        filter.and("billstatus", "=", (Object)BillStatusEnum.PAY.getValue());
        filter.and("entry.e_isrefund", "=", (Object)"0");
        filter.and("entry.e_issuccess", "=", (Object)"1");
        filter.and("entry.e_isrepaid", "=", (Object)"0");
        return filter;
    }

    public static List<DynamicObject> filterAgentAmtByTransDetail(List<DynamicObject> agentBills, DynamicObject transDetailBill) {
        if (CollectionUtils.isEmpty(agentBills)) {
            return new ArrayList<DynamicObject>(0);
        }
        BigDecimal creditAmount = transDetailBill.getBigDecimal("creditamount");
        BigDecimal debitAmount = transDetailBill.getBigDecimal("debitamount");
        return agentBills.stream().filter(ag -> {
            if (ag.getBoolean("isencryption")) {
                BigDecimal amt = AgentPayBillHelper.decodeAmount(ag.getString("entry.e_encryptamount"));
                return amt.compareTo(creditAmount) == 0 || amt.compareTo(debitAmount.negate()) == 0;
            }
            BigDecimal amount = ag.getBigDecimal("entry.e_amount");
            return amount.compareTo(creditAmount) == 0 || amount.compareTo(debitAmount.negate()) == 0;
        }).collect(Collectors.toList());
    }

    private static void refundAddDifferFilters(List<QFilter> payBillsFilters, DynamicObject recbill) {
        payBillsFilters.add(new QFilter("dpcurrency", "=", (Object)recbill.getLong("currency.id")));
        payBillsFilters.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.PAY.getValue()));
        payBillsFilters.add(new QFilter("totalrefundedamt", "=", (Object)BigDecimal.ZERO));
        payBillsFilters.add(new QFilter("isdiffcur", "=", (Object)"1"));
    }
}

