/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.util;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.fi.cas.util.EmptyUtil;

public class PropertyEqualChecker {
    public static <T> boolean areAllPropertiesEqual(List<T> list, List<Function<T, Object>> attributeGetters) {
        if (EmptyUtil.isEmpty(list)) {
            return true;
        }
        List baseDataList = attributeGetters.stream().map(extractor -> extractor.apply(list.get(0))).collect(Collectors.toList());
        return list.stream().allMatch(d -> attributeGetters.stream().allMatch(extractor -> PropertyEqualChecker.areEqual(extractor.apply(d), baseDataList.get(attributeGetters.indexOf(extractor)))));
    }

    private static boolean areEqual(Object a, Object b) {
        if (EmptyUtil.isEmpty((Object)a) && EmptyUtil.isEmpty((Object)b)) {
            return true;
        }
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).longValue() == ((Number)b).longValue();
        }
        return Objects.equals(a, b);
    }
}

