/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.trip.change;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.trip.util.TripReqChangeUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.ErBillStatusEnum;

public class TripEntryInfoChangeOP
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("isloan");
        fieldKeys.add("reimbursetime");
        fieldKeys.add("billstatus");
        fieldKeys.add("ischange");
        fieldKeys.add("srcentryid");
        fieldKeys.add("srcentrydata");
        fieldKeys.add("srcentrydata_tag");
        fieldKeys.add("changetime");
        fieldKeys.add("changer");
        for (Map.Entry entry : TripReqChangeUtil.getTriphistoryMappingresult().entrySet()) {
            fieldKeys.add(entry.getKey());
            fieldKeys.add(entry.getValue());
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        this.addTripEntryChangeValidator(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        if (bills.length > 0) {
            this.billsEntryChange(bills);
            SaveServiceHelper.save((DynamicObject[])bills);
        }
    }

    protected void billsEntryChange(DynamicObject[] bills) {
        for (DynamicObject bill : bills) {
            bill.set("ischange", (Object)Boolean.TRUE);
            this.addTripEntryHistory(bill);
        }
    }

    protected void addTripEntryHistory(DynamicObject bill) {
        DynamicObjectCollection tripColl = bill.getDynamicObjectCollection("tripentry");
        DynamicObjectCollection historyColl = bill.getDynamicObjectCollection("tripchangehistoryentry");
        Date changeDate = new Date();
        int seq = historyColl.size() + 1;
        for (int i = 0; i < tripColl.size(); ++i) {
            DynamicObject oldTripEntry = (DynamicObject)tripColl.get(i);
            DynamicObject newHistory = historyColl.addNew();
            newHistory.set("srcentryid", oldTripEntry.getPkValue());
            String srcData = SerializationUtils.toJsonString((Object)oldTripEntry);
            newHistory.set("srcentrydata", (Object)(srcData.length() > 100 ? srcData.substring(0, 100) + "..." : srcData));
            newHistory.set("srcentrydata_tag", (Object)srcData);
            newHistory.set("changetime", (Object)changeDate);
            newHistory.set("changer_id", (Object)CommonServiceHelper.getCurrentUserID());
            for (Map.Entry mappingEntry : TripReqChangeUtil.getTriphistoryMappingresult().entrySet()) {
                String mappingKey = (String)mappingEntry.getKey();
                String value = (String)mappingEntry.getValue();
                if ("tripchangehistoryentry.seq".equals(mappingKey)) {
                    mappingKey = "seq";
                    value = "seq";
                }
                if (oldTripEntry.get(value) instanceof DynamicObjectCollection) {
                    DynamicObjectCollection histroryCollection = newHistory.getDynamicObjectCollection(mappingKey);
                    for (DynamicObject d : oldTripEntry.getDynamicObjectCollection(value)) {
                        DynamicObject n = histroryCollection.addNew();
                        n.set("fbasedataid_id", (Object)ErCommonUtils.getPk((Object)d.getDynamicObject("fbasedataid")));
                    }
                    continue;
                }
                newHistory.set(mappingKey, "seq".equals(value) ? Integer.valueOf(seq++) : oldTripEntry.get(value));
            }
        }
    }

    protected void addTripEntryChangeValidator(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new TripEntryInfoChangeValiator());
    }

    public AbstractValidator getTripEntryInfoChangeValiator() {
        return new TripEntryInfoChangeValiator();
    }

    private static class TripEntryInfoChangeValiator
    extends AbstractValidator {
        private TripEntryInfoChangeValiator() {
        }

        public void validate() {
            ExtendedDataEntity[] dataEntities;
            for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                DynamicObject billObj = dataEntity.getDataEntity();
                if (billObj.getBoolean("isloan")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fa\u5dee\u501f\u6b3e\u5355\u4e0d\u80fd\u53d8\u66f4\u3002", (String)"TripEntryInfoChangeOP_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (!billObj.getString("billstatus").equals(ErBillStatusEnum.E.name())) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5ba1\u6838\u901a\u8fc7\u7684\u51fa\u5dee\u7533\u8bf7\u5355\u624d\u80fd\u53d8\u66f4\u3002", (String)"TripEntryInfoChangeOP_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (billObj.getInt("reimbursetime") <= 0) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355\u5df2\u7ecf\u62a5\u9500\uff0c\u4e0d\u80fd\u53d8\u66f4\u3002", (String)"TripEntryInfoChangeOP_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

