/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.trip.change;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.trip.util.TripReqChangeUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.opplugin.trip.change.TripEntryInfoRevokeOP;

public class TripEntryInfoRevokeOP
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("isloan");
        fieldKeys.add("reimbursetime");
        fieldKeys.add("billstatus");
        fieldKeys.add("ischange");
        fieldKeys.add("srcentryid");
        fieldKeys.add("srcentrydata");
        fieldKeys.add("srcentrydata_tag");
        fieldKeys.add("changetime");
        fieldKeys.add("changer");
        fieldKeys.add("rstartdate");
        fieldKeys.add("rfirstenddate");
        fieldKeys.add("renddate");
        fieldKeys.add("rvehicle");
        fieldKeys.add("rfrom");
        fieldKeys.add("rto");
        fieldKeys.add("rfirstto");
        fieldKeys.add("amount");
        fieldKeys.add("approveamount");
        fieldKeys.add("notpayamount");
        fieldKeys.add("encashamount");
        fieldKeys.add("loanamount");
        fieldKeys.add("accountentry");
        for (Map.Entry entry : TripReqChangeUtil.getTriphistoryMappingresult().entrySet()) {
            fieldKeys.add(entry.getKey());
            fieldKeys.add(entry.getValue());
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new TripEntryInfoRevokeValidator(null));
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        if (bills.length > 0) {
            this.doRevoke(bills);
            SaveServiceHelper.save((DynamicObject[])bills);
            Object[] ids = new Object[bills.length];
            for (int index = 0; index < bills.length; ++index) {
                ids[index] = bills[index].getPkValue();
            }
            OperateOption op = OperateOption.create();
            op.setVariableValue("WF", String.valueOf(true));
            OperationResult res = OperationServiceHelper.executeOperate((String)"audit", (String)"er_tripreqbill", (Object[])ids, (OperateOption)op);
            if (!res.isSuccess()) {
                StringBuilder tips = this.buildErrorInfoBuilder(res);
                throw new KDException(String.format(ResManager.loadKDString((String)"\u884c\u7a0b\u64a4\u9500\u5931\u8d25\uff1a%1$s", (String)"TripEntryInfoRevokeOP_0", (String)"fi-er-opplugin", (Object[])new Object[0]), tips.toString()));
            }
        }
    }

    private StringBuilder buildErrorInfoBuilder(OperationResult res) {
        StringBuilder tips = new StringBuilder();
        if (null != res.getMessage()) {
            tips.append(res.getMessage());
        }
        if (null != res.getAllErrorInfo() && res.getAllErrorInfo().size() > 0) {
            List list = res.getAllErrorInfo();
            list.stream().forEach(p -> tips.append(p.getMessage()));
        }
        return tips;
    }

    private void doRevoke(DynamicObject[] bills) {
        DynamicObject bill = bills[0];
        DynamicObjectCollection historyEntities = bill.getDynamicObjectCollection("tripchangehistoryentry");
        if (historyEntities.size() == 0) {
            return;
        }
        Optional<DynamicObject> optional = historyEntities.stream().max(Comparator.comparing(e -> e.getDate("changetime")));
        Date maxDate = optional.isPresent() ? new Date(optional.get().getDate("changetime").getTime()) : new Date(((DynamicObject)historyEntities.get(0)).getDate("changetime").getTime());
        List<DynamicObject> upToDate = historyEntities.stream().filter(v -> v.getDate("changetime").compareTo(maxDate) == 0).collect(Collectors.toList());
        DynamicObjectCollection currentEntities = bill.getDynamicObjectCollection("tripentry");
        this.compareAndSwapEntities(currentEntities, upToDate);
        historyEntities.removeAll(upToDate);
        if (historyEntities.size() == 0) {
            bill.set("ischange", (Object)false);
        }
        bill.set("billstatus", (Object)"B");
        this.revokeHeadAmount(bill);
        CommonServiceHelper.executeRedundancyField((DynamicObject)bill);
    }

    private void revokeHeadAmount(DynamicObject bill) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalAccAppAmount = BigDecimal.ZERO;
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("tripentry");
        for (int i = 0; i < entries.size(); ++i) {
            BigDecimal tripAmount = ((DynamicObject)entries.get(i)).getBigDecimal("tripamount");
            totalAmount = totalAmount.add(tripAmount);
            BigDecimal accAppAmount = ((DynamicObject)entries.get(i)).getBigDecimal("tripaccappamount");
            totalAccAppAmount = totalAccAppAmount.add(tripAmount);
        }
        bill.set("amount", (Object)totalAmount);
        bill.set("approveamount", (Object)totalAccAppAmount);
        bill.set("encashamount", (Object)totalAccAppAmount);
    }

    private void compareAndSwapEntities(DynamicObjectCollection currentEntities, List<DynamicObject> historyEntities) {
        Map<Long, DynamicObject> historyEntitiesMap = historyEntities.stream().collect(Collectors.toMap(v -> v.getLong("srcentryid"), v -> v));
        ArrayList<DynamicObject> removeList = new ArrayList<DynamicObject>(currentEntities.size());
        int seq = 1;
        for (DynamicObject dynamicObject : currentEntities) {
            Long entryId = (Long)dynamicObject.getPkValue();
            if (historyEntitiesMap.containsKey(entryId)) {
                this.swap(dynamicObject, historyEntitiesMap.remove(entryId), seq++);
                continue;
            }
            removeList.add(dynamicObject);
        }
        currentEntities.removeAll(removeList);
        for (Map.Entry<Long, DynamicObject> entry : historyEntitiesMap.entrySet()) {
            DynamicObject newRow = currentEntities.addNew();
            this.swap(newRow, entry.getValue(), seq++);
        }
    }

    private void swap(DynamicObject targetEntry, DynamicObject item, int seq) {
        Map propMap = TripReqChangeUtil.getTriphistoryMappingresult();
        for (Map.Entry entry : propMap.entrySet()) {
            String propKey = (String)entry.getKey();
            String value = (String)entry.getValue();
            if ("tripchangehistoryentry.seq".equals(propKey)) {
                propKey = "seq";
                value = "seq";
            }
            if (item.get(propKey) instanceof DynamicObjectCollection) {
                DynamicObjectCollection curr = targetEntry.getDynamicObjectCollection(value);
                for (int index = curr.size() - 1; index >= 0; --index) {
                    curr.remove(index);
                }
                for (DynamicObject d : item.getDynamicObjectCollection(propKey)) {
                    Long hisBaseDataId = ErCommonUtils.getPk((Object)d.getDynamicObject("fbasedataid"));
                    DynamicObject n = curr.addNew();
                    n.set("fbasedataid_id", (Object)hisBaseDataId);
                }
                continue;
            }
            targetEntry.set(value, "seq".equals(value) ? Integer.valueOf(seq) : item.get(propKey));
        }
    }
}

