/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

class payerBankCheck
extends AbstractValidator {
    payerBankCheck() {
    }

    public void validate() {
        ExtendedDataEntity[] dataEntitys = this.getDataEntities();
        String repaymentAmtCtrl = ErStdConfig.get((String)"RepaymentAmountControl");
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            int entryRowCount;
            DynamicObject payerbank = dataEntity.getDataEntity().getDynamicObject("payerbank");
            if (payerbank != null && !payerbank.getBoolean("enable")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u94f6\u884c\u5df2\u7981\u7528\u3002", (String)"ErReapymentSubmitOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            Long companyId = ErCommonUtils.getPk((Object)dataEntity.getDataEntity().get("company"));
            DynamicObjectCollection recentryCollectoin = dataEntity.getDataEntity().getDynamicObjectCollection("recentry");
            int n = entryRowCount = !recentryCollectoin.isEmpty() ? recentryCollectoin.size() : 0;
            if (SystemParamterUtil.getRepayRelateReceive((Long)companyId) && StringUtils.equals((CharSequence)"approveandsubmit", (CharSequence)this.getOperateKey()) && entryRowCount < 1) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8fd8\u6b3e\u5355\u672a\u5173\u8054\u6536\u6b3e\u5355\uff0c\u8bf7\u5148\u5173\u8054\u6536\u6b3e\u5355\u3002", (String)"ErRepayMentBillPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (entryRowCount < 1) continue;
            for (int i = 0; i < recentryCollectoin.size(); ++i) {
                String msg;
                String recbillno = ((DynamicObject)recentryCollectoin.get(i)).getString("recbillno");
                Long billid = (Long)dataEntity.getDataEntity().getPkValue();
                QFilter qFilter = new QFilter("recentry.recbillno", "=", (Object)recbillno).and("id", "!=", (Object)billid);
                System.out.println("---qFilter---" + qFilter);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"er_repaymentbill", (String)"id,billno", (QFilter[])new QFilter[]{qFilter});
                if (dynamicObject != null) {
                    String msg2 = String.format(ResManager.loadKDString((String)"\u5173\u8054\u6536\u6b3e\u5355\uff08%1$s\uff09\u5df2\u88ab\u8fd8\u6b3e\u5355\uff08%2$s\uff09\u5173\u8054\uff0c\u8bf7\u91cd\u65b0\u5173\u8054\u6536\u6b3e\u5355\u3002", (String)"ErRepayMentBillPlugin_8", (String)"fi-er-formplugin", (Object[])new Object[0]), recbillno, dynamicObject.getString("billno"));
                    this.addErrorMessage(dataEntity, msg2);
                    continue;
                }
                long recbillid = ((DynamicObject)recentryCollectoin.get(i)).getLong("recbillid");
                DynamicObject casRecbill = BusinessDataServiceHelper.loadSingle((Object)recbillid, (String)"cas_recbill");
                if (casRecbill == null) {
                    msg = String.format(ResManager.loadKDString((String)"\u5173\u8054\u6536\u6b3e\u5355\uff08%1$s\uff09\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5173\u8054\u6536\u6b3e\u5355\u3002", (String)"ErRepayMentBillPlugin_10", (String)"fi-er-formplugin", (Object[])new Object[0]), recbillno);
                    this.addErrorMessage(dataEntity, msg);
                    continue;
                }
                if (casRecbill == null || "D".equals(casRecbill.getString("billstatus"))) continue;
                msg = String.format(ResManager.loadKDString((String)"\u5173\u8054\u6536\u6b3e\u5355\uff08%1$s\uff09\u4e0d\u662f\u5df2\u6536\u6b3e\u72b6\u6001\uff0c\u8bf7\u91cd\u65b0\u5173\u8054\u6536\u6b3e\u5355\u3002", (String)"ErRepayMentBillPlugin_9", (String)"fi-er-formplugin", (Object[])new Object[0]), recbillno);
                this.addErrorMessage(dataEntity, msg);
            }
            String errorMsg = this.verifyBillCanbeSubmit(dataEntity, repaymentAmtCtrl);
            if (errorMsg == null) continue;
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }

    public String verifyBillCanbeSubmit(ExtendedDataEntity dataEntity, String repaymentAmtCtrl) {
        String errorMsg = null;
        DynamicObjectCollection recentryCollectoin = dataEntity.getDataEntity().getDynamicObjectCollection("recentry");
        if (recentryCollectoin != null && !recentryCollectoin.isEmpty()) {
            BigDecimal totalActrecamt = BigDecimal.ZERO;
            BigDecimal totalfee = BigDecimal.ZERO;
            for (int i = 0; i < recentryCollectoin.size(); ++i) {
                BigDecimal actrecamt = ((DynamicObject)recentryCollectoin.get(i)).getBigDecimal("actrecamt");
                Long recbillid = ((DynamicObject)recentryCollectoin.get(i)).getLong("recbillid");
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)recbillid, (String)"cas_recbill");
                if (dynamicObject != null) {
                    if (dynamicObject.containsProperty("localamt") && dynamicObject.getBigDecimal("localamt").compareTo(actrecamt) != 0) {
                        actrecamt = dynamicObject.getBigDecimal("localamt");
                    }
                    if (dynamicObject.containsProperty("fee") && dynamicObject.getBigDecimal("fee") != null) {
                        totalfee = totalfee.add(dynamicObject.getBigDecimal("fee"));
                    }
                }
                totalActrecamt = totalActrecamt.add(actrecamt);
            }
            if ("true".equals(ErStdConfig.get((String)"isIncludeFee"))) {
                totalActrecamt = totalActrecamt.add(totalfee);
            }
            BigDecimal approveamount = dataEntity.getDataEntity().getBigDecimal("approveamount");
            double diff = Math.abs(approveamount.subtract(totalActrecamt).doubleValue());
            if (repaymentAmtCtrl == null || "1".equals(repaymentAmtCtrl)) {
                if (diff > 0.1) {
                    errorMsg = ResManager.loadKDString((String)"\u6536\u6b3e\u603b\u91d1\u989d\uff08\u672c\u4f4d\u5e01\uff09\u987b\u7b49\u4e8e\u8fd8\u6b3e\u603b\u91d1\u989d\uff08\u672c\u4f4d\u5e01\uff09\u3002", (String)"EM-E-366843", (String)"fi-er-formplugin", (Object[])new Object[0]);
                }
            } else if ("2".equals(repaymentAmtCtrl)) {
                if (totalActrecamt.compareTo(approveamount) < 0 && diff > 0.1) {
                    errorMsg = ResManager.loadKDString((String)"\u6536\u6b3e\u603b\u91d1\u989d\uff08\u672c\u4f4d\u5e01\uff09\u987b\u5927\u4e8e\u6216\u7b49\u4e8e\u8fd8\u6b3e\u603b\u91d1\u989d\uff08\u672c\u4f4d\u5e01\uff09\u3002", (String)"EM-E-100310", (String)"fi-er-formplugin", (Object[])new Object[0]);
                }
            } else if (diff > 0.1) {
                errorMsg = ResManager.loadKDString((String)"\u6536\u6b3e\u603b\u91d1\u989d\uff08\u672c\u4f4d\u5e01\uff09\u987b\u7b49\u4e8e\u8fd8\u6b3e\u603b\u91d1\u989d\uff08\u672c\u4f4d\u5e01\uff09\u3002", (String)"EM-E-366843", (String)"fi-er-formplugin", (Object[])new Object[0]);
            }
        }
        return errorMsg;
    }
}

