/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp.up;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.DrawArgs;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.BotpDrawServiceUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEnhancedConvertReportUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.formplugin.mobile.ErReimburseUpRequestMobPlugin;
import org.apache.commons.lang3.StringUtils;

public class TripReimburseSelectTripReqMobPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener {
    private static final String TRIPREIMBURSE = "TRIPREIMBURSE";
    private static final String fromId = "er_reimbursebill_upreq_mb";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"lab_delete_offapply", "lab_done_offapply", "flex_add_apply", "vectorap_add_apply", "deleteflex", "image_delete_apply"});
        this.addClickListeners(new String[]{"flex_arow11", "vectorap11", "lab_delete_writeoff", "lab_done_writeoff"});
        AbstractGrid entryentity = (AbstractGrid)this.getControl("writeoffapply");
        if (entryentity != null) {
            entryentity.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.writeOffApplyCardSetVisible(false);
        InvoiceUtils.updateInvoiceLabel((IFormView)this.getView());
        ErReimburseUpRequestMobPlugin.hiddenOrShow((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false, (String)"clearloanentry", (String)"lab_done_writeoff", (String)"lab_delete_writeoff", (String)"image_delete_writeoff");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("flex_arow11".equals(key) || "vectorap11".equals(key)) {
            if (ErEntityTypeUtils.isTripReimburseBill((String)this.getView().getEntityId()) && "1".equals(this.getModel().getValue("billkind")) && CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity("entryentity"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u201c\u5dee\u65c5\u660e\u7ec6\u201d\u3002", (String)"EM-W-422248", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            this.openUpBillList(TRIPREIMBURSE);
        } else if ("lab_delete_writeoff".equals(key)) {
            ErReimburseUpRequestMobPlugin.hiddenOrShow((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true, (String)"clearloanentry", (String)"lab_done_writeoff", (String)"lab_delete_writeoff", (String)"image_delete_writeoff");
        } else if ("lab_done_writeoff".equals(key)) {
            ErReimburseUpRequestMobPlugin.hiddenOrShow((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false, (String)"clearloanentry", (String)"lab_done_writeoff", (String)"lab_delete_writeoff", (String)"image_delete_writeoff");
        }
        switch (key) {
            case "deleteflex": 
            case "image_delete_apply": {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("writeoffapply");
                if (rowIndex <= -1) break;
                this.getModel().deleteEntryRow("writeoffapply", rowIndex);
                break;
            }
            case "lab_delete_offapply": {
                this.writeOffApplyCardSetVisible(true);
                break;
            }
            case "lab_done_offapply": {
                this.writeOffApplyCardSetVisible(false);
                break;
            }
            case "flex_add_apply": 
            case "vectorap_add_apply": {
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId("er_tripreq_selectbill_mb");
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "select_tripreq_bill"));
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    @Deprecated
    private void openUpBillList(String drawSourceType) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(fromId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        Long companyId = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
        customParams.put("applierId", ErCommonUtils.getPk((Object)this.getModel().getValue("applier")));
        customParams.put("orgId", ErCommonUtils.getPk((Object)this.getModel().getValue("org")));
        customParams.put("currency", ErCommonUtils.getPk((Object)this.getModel().getValue("currency")));
        customParams.put("companyId", companyId);
        customParams.put("writeofftype", this.getModel().getValue("loanchecktype"));
        String sourceEntity = this.getSourceEntity(drawSourceType);
        customParams.put("drawSourceEntity", sourceEntity);
        customParams.put("ids", this.getexistids(sourceEntity));
        showParameter.setCustomParams(customParams);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, showParameter.getFormId()));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private List<Long> getexistids(String sourceEntity) {
        DynamicObjectCollection writeoffapplys = this.getModel().getEntryEntity("clearloanentry");
        return writeoffapplys.stream().map(e -> e.getLong("reqaccountentryid")).collect(Collectors.toList());
    }

    private String getSourceEntity(String drawSourceType) {
        return "er_dailyloanbill,er_tripreqbill";
    }

    public void entryRowClick(RowClickEvent evt) {
        int index = evt.getRow();
        if (evt.getSource() instanceof CardEntry && "writeoffapply".equals(((CardEntry)evt.getSource()).getEntryKey())) {
            DynamicObject applyBill;
            String applyBillNo = (String)this.getModel().getValue("applybillno", index);
            String srcBillIdStr = (String)this.getModel().getValue("sourceapplybillid", index);
            QFilter qFilter = new QFilter("billno", "=", (Object)applyBillNo);
            if (StringUtils.isNumeric((CharSequence)srcBillIdStr)) {
                qFilter.and("id", "=", (Object)Long.valueOf(srcBillIdStr));
            }
            if ((applyBill = QueryServiceHelper.queryOne((String)"er_tripreqbill", (String)"id", (QFilter[])new QFilter[]{qFilter})) != null) {
                HashMap<String, Object> customParam = new HashMap<String, Object>();
                customParam.put("FormId", "er_tripreqbill_mob");
                customParam.put("Status", BillOperationStatus.VIEW.getValue());
                customParam.put("hiddenmtoolbarap", Boolean.TRUE.toString());
                customParam.put("isDrawPreViewBill", Boolean.TRUE);
                customParam.put("billId", applyBill.getLong("id"));
                MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
                formShowParameter.setCustomParams(customParam);
                formShowParameter.setFormId("er_dlbill_tabap_inh");
                formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u8be6\u60c5", (String)"TripReimburseSelectTripReqMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                this.getView().showForm((FormShowParameter)formShowParameter);
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        int[] rowIndexs = e.getRowIndexs();
        switch (entryName) {
            case "writeoffapply": {
                CommonServiceHelper.tripReimburseDelWriteOffApply((IDataModel)this.getModel(), (IFormView)this.getView(), (int[])rowIndexs);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        DynamicObjectCollection writeoffapply;
        String entryName = e.getEntryProp().getName();
        if ("writeoffapply".equals(entryName) && (writeoffapply = this.getModel().getDataEntity(true).getDynamicObjectCollection("writeoffapply")).isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"lab_delete_offapply", "lab_done_offapply"});
        }
        if ("clearloanentry".equals(entryName)) {
            this.refreshClearLoan();
        }
    }

    private void refreshClearLoan() {
        Long companyId;
        String loanType = (String)this.getModel().getValue("loanchecktype");
        if (StringUtils.isBlank((CharSequence)loanType) && (companyId = ErCommonUtils.getPk((Object)this.getModel().getValue("company"))) != null) {
            loanType = (String)ErCommonUtils.getLoanCheckType((long)companyId);
            this.getModel().setValue("loanchecktype", (Object)loanType);
        }
        AmountChangeUtil.refreshPayAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (String)loanType);
        AmountChangeUtil.refreshReceiveAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (BigDecimal)((BigDecimal)this.getModel().getValue("encashamount")), (String)loanType);
        AmountChangeUtil.loanClearEntryChange((IFormView)this.getView(), (IDataModel)this.getModel(), (String)loanType);
        AmountChangeUtil.refreshPayAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (String)loanType);
        BigDecimal totalClearLoanAmount = AmountUtils.getEntryAmount((IDataModel)this.getModel(), (String)"clearloanentry", (String)"loanclearamount");
        this.getModel().setValue("checkloanamount", (Object)totalClearLoanAmount);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        IDataModel model = this.getModel();
        String actionId = event.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"select_tripreq_bill")) {
            ListSelectedRowCollection selectBill = (ListSelectedRowCollection)event.getReturnData();
            if (selectBill == null || selectBill.isEmpty()) {
                return;
            }
            DynamicObjectCollection writeOffApply = this.getModel().getDataEntity(true).getDynamicObjectCollection("writeoffapply");
            Set existApplyBillNo = writeOffApply.stream().map(v -> v.getString("applybillno")).collect(Collectors.toSet());
            Iterator iterator = selectBill.iterator();
            while (iterator.hasNext()) {
                ListSelectedRow curRow = (ListSelectedRow)iterator.next();
                if (!existApplyBillNo.contains(curRow.getBillNo())) continue;
                iterator.remove();
            }
            if (selectBill.isEmpty()) {
                return;
            }
            String billTypeNumber = ((DynamicObject)this.getModel().getValue("stdbilltype")).getString("number");
            String ruleId = null;
            ruleId = StringUtils.equals((CharSequence)billTypeNumber, (CharSequence)"er_tripreimbursebill_BT_CLS") ? "1118640902613561344" : "1123175223563535360";
            DrawArgs args = BotpDrawServiceUtil.buildDrawArgs((String)"er_tripreqbill", (String)model.getDataEntityType().getName(), (IFormView)this.getView(), (ListSelectedRowCollection)selectBill, (String)ruleId);
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)4);
            ConvertOperationResult result = ConvertServiceHelper.draw((DrawArgs)args);
            if (result.isSuccess()) {
                BotpDrawServiceUtil.dealResult((ConvertOperationResult)result, (List)resultList, (BillEntityType)((BillEntityType)model.getDataEntityType()));
            }
            for (DynamicObject bill : resultList) {
                ((IBillModel)model).push((Object)bill);
            }
            this.getView().updateView();
        }
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)fromId)) {
            Map resultMap = (Map)event.getReturnData();
            if (resultMap == null || resultMap.size() == 0) {
                return;
            }
            Iterator iterator = resultMap.entrySet().iterator();
            ArrayList dataEntitysDyn = Lists.newArrayListWithExpectedSize((int)4);
            ArrayList<ConvertOperationResult> convertResults = new ArrayList<ConvertOperationResult>(10);
            boolean existFail = false;
            DrawArgs failArgs = new DrawArgs();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                DrawArgs args = new DrawArgs();
                args.setSourceEntityNumber((String)next.getKey());
                args.setTargetEntityNumber(this.getModel().getDataEntityType().getName());
                args.getSelectedRows().addAll((Collection)next.getValue());
                args.setTargetPageId(this.getView().getPageId());
                args.setRuleId(this.getRuleId((String)next.getKey()));
                args.setBuildConvReport(true);
                ConvertRuleElement loadRule = ConvertRuleCache.loadRule((String)args.getRuleId());
                if (!loadRule.isEnabled()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5355\u636e\u6ca1\u6709\u542f\u7528\u5bf9\u5e94\u7684\u4e0a\u62c9\u89c4\u5219\uff0c\u8bf7\u542f\u7528\u6216\u8005\u91cd\u65b0\u8bbe\u7f6e\u89c4\u5219\u3002", (String)"TripReimburseSelectTripReqMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                ConvertOperationResult result = ConvertServiceHelper.draw((DrawArgs)args);
                convertResults.add(result);
                if (result.isSuccess()) {
                    IRefrencedataProvider refProvider = new IRefrencedataProvider(){

                        public void fillReferenceData(Object[] dataEntitys, IDataEntityType type) {
                            BusinessDataReader.loadRefence((Object[])dataEntitys, (IDataEntityType)type);
                        }
                    };
                    List dataEntitys = result.loadTargetDataObjects(refProvider, (MainEntityType)((BillEntityType)model.getDataEntityType()));
                    dataEntitysDyn.addAll(dataEntitys);
                    result.release(refProvider, (MainEntityType)((BillEntityType)model.getDataEntityType()));
                    continue;
                }
                existFail = true;
                failArgs = args;
            }
            if (existFail) {
                ErEnhancedConvertReportUtil.showEnhancedConvertReport(convertResults, (DrawArgs)failArgs, (IFormView)this.getView());
            }
            if (!dataEntitysDyn.isEmpty()) {
                BigDecimal approveAmount;
                Long companyId;
                DynamicObject pushDyn = this.mergeResult(dataEntitysDyn);
                ((IBillModel)this.getView().getModel()).push((Object)pushDyn);
                String loanType = (String)this.getModel().getValue("loanchecktype");
                if (StringUtils.isBlank((CharSequence)loanType) && (companyId = ErCommonUtils.getPk((Object)this.getModel().getValue("company"))) != null) {
                    loanType = (String)ErCommonUtils.getLoanCheckType((long)companyId);
                    this.getModel().setValue("loanchecktype", (Object)loanType);
                }
                if (BigDecimal.ZERO.compareTo(approveAmount = (BigDecimal)this.getModel().getValue("approveamount")) == 0) {
                    // empty if block
                }
                this.refreshClearLoan();
                this.getView().updateView("clearloanentry");
                this.getView().updateView("istravelers");
                ErReimburseUpRequestMobPlugin.hiddenOrShow((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false, (String)"clearloanentry", (String)"lab_done_writeoff", (String)"lab_delete_writeoff", (String)"image_delete_writeoff");
            }
        }
    }

    protected DynamicObject mergeResult(List<DynamicObject> dataEntitysDyn) {
        DynamicObject result = dataEntitysDyn.get(0);
        HashSet<String> contains = new HashSet<String>();
        DynamicObjectCollection clearLoanEntry = result.getDynamicObjectCollection("clearloanentry");
        for (DynamicObject clearRow : clearLoanEntry) {
            contains.add(clearRow.getString("reqaccountentryid") + clearRow.getString("loanbillid"));
        }
        for (int i = 1; i < dataEntitysDyn.size(); ++i) {
            DynamicObject temp = dataEntitysDyn.get(i);
            DynamicObjectCollection tempClearLoanEntry = temp.getDynamicObjectCollection("clearloanentry");
            for (DynamicObject tempClearRow : tempClearLoanEntry) {
                String conStr = tempClearRow.getString("reqaccountentryid") + tempClearRow.getString("loanbillid");
                if (contains.contains(conStr)) continue;
                clearLoanEntry.add((Object)tempClearRow);
            }
        }
        return result;
    }

    private String getRuleId(String entityName) {
        if ("er_dailyloanbill".equals(entityName)) {
            return "514160845400318976";
        }
        return "514155471423153152";
    }

    private void writeOffApplyCardSetVisible(boolean visible) {
        IDataModel model = this.getModel();
        DynamicObjectCollection writeoffapply = model.getDataEntity(true).getDynamicObjectCollection("writeoffapply");
        CardEntry writeOffApplyCard = (CardEntry)this.getControl("writeoffapply");
        if (writeoffapply.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"lab_delete_offapply", "lab_done_offapply"});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(!visible), new String[]{"lab_delete_offapply"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"lab_done_offapply"});
        for (int rowIndex = 0; rowIndex < writeoffapply.size(); ++rowIndex) {
            writeOffApplyCard.setChildVisible(visible, rowIndex, new String[]{"deleteflex"});
        }
    }
}

