/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.botp.up;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildDrawFilterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.TripExpenseItemServiceHelper;
import kd.fi.er.business.servicehelper.TripReimburseServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripBusinessRelatDailyBusinessUtil;
import kd.fi.er.business.trip.dailybiz.TripNotReimbursedOrderUtil;
import kd.fi.er.business.trip.dailybiz.TripReimCreateOrderEntrysUtil;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp;
import kd.fi.er.business.utils.EntrustReimburseUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.SystemParamterUtil;

public class TripReqToTripReimburseSelectBillPlugin
extends AbstractConvertPlugIn {
    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("tripentry.id");
    }

    public void afterBuildDrawFilter(AfterBuildDrawFilterEventArgs event) {
        DynamicObject targetBill = event.getTargetDataEntity();
        QFilter qFilter = TripReqToTripReimburseSelectBillPlugin.tripReqSelectBillSetFilter(targetBill);
        event.setPlugFilter(qFilter);
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        Map srcfldPro = e.getFldProperties();
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject targetBill = billDataEntity.getDataEntity();
            boolean isTravelers = targetBill.getBoolean("istravelers");
            if (!isTravelers) {
                DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("writeoffapply");
                Set idSet = entry.stream().map(row -> row.getString("sourceapplybillid")).filter(StringUtils::isNotBlank).map(Long::valueOf).collect(Collectors.toSet());
                QFilter qFilter = new QFilter("id", "in", (Object)idSet);
                qFilter.and("istravelers", "=", (Object)Boolean.TRUE);
                boolean upBillIsTravelers = QueryServiceHelper.exists((String)"er_tripreqbill", (QFilter[])new QFilter[]{qFilter});
                if (upBillIsTravelers) {
                    targetBill.set("istravelers", (Object)upBillIsTravelers);
                }
            }
            DynamicObjectCollection tripEntry = targetBill.getDynamicObjectCollection("tripentry");
            for (DynamicObject row2 : tripEntry) {
                row2.set("entrycostdept", targetBill.get("costdept"));
                row2.set("entrycostcompany", targetBill.get("costcompany"));
            }
            DynamicObjectCollection writeOffApplyEntity = targetBill.getDynamicObjectCollection("writeoffapply");
            LinkedList<String> billNumbers = new LinkedList<String>();
            for (DynamicObject row3 : writeOffApplyEntity) {
                billNumbers.add(row3.getString("applybillno"));
            }
            TripReqToTripReimburseSelectBillPlugin.setMobShowData(writeOffApplyEntity, billNumbers);
            CommonServiceHelper.updateRelateCount(billNumbers, (DynamicObjectCollection)writeOffApplyEntity);
            List convertSourceBillRows = (List)billDataEntity.getValue("ConvertSource");
            this.genOrderEntrys(billDataEntity, e.getFldProperties(), targetBill);
            Object[] sourceBills = convertSourceBillRows.stream().map(l -> ((DynamicProperty)srcfldPro.get("id")).getValue(l)).distinct().collect(Collectors.toList()).toArray();
            DynamicObject[] sourceBillCollection = BusinessDataServiceHelper.load((Object[])sourceBills, (DynamicObjectType)this.getSrcMainType());
            this.tripEntrySetVehicleAndTravlerForDraw(sourceBillCollection, targetBill);
            this.setTripMulWayTo(sourceBillCollection, targetBill);
            for (int i = 0; i < convertSourceBillRows.size(); ++i) {
                Long companyId = ErCommonUtils.getPk((Object)targetBill.getDynamicObject("company"));
                DynamicObject sourceBillDynamicObject = BusinessDataServiceHelper.loadSingle((Object)((DynamicProperty)srcfldPro.get("id")).getValue(convertSourceBillRows.get(i)), (String)this.getSrcMainType().getName(), (String)"id,tripentry.id,tripentry.vehicle,tripentry.vehicles,tripentry.travelers,tripentry.mulwayto");
                Map<String, List<DynamicObject>> tripExpenseItemMap = this.getTripExpenseItemInfosMap(companyId, sourceBillDynamicObject);
                Long tripentrysourceid = (Long)((DynamicProperty)srcfldPro.get("tripentry.id")).getValue(convertSourceBillRows.get(i));
                this.initDefaultTargetEntryData(tripExpenseItemMap, targetBill, tripentrysourceid, i);
            }
        }
    }

    protected Map<String, List<DynamicObject>> getTripExpenseItemInfosMap(Long companyId, DynamicObject sourceBillDynamicObject) {
        HashMap<String, List<DynamicObject>> tripExpenseItemMap = new HashMap<String, List<DynamicObject>>();
        DynamicObjectCollection sourceTripEntrys = sourceBillDynamicObject.getDynamicObjectCollection("tripentry");
        for (int i = 0; i < sourceTripEntrys.size(); ++i) {
            DynamicObject sourceTripEntry = (DynamicObject)sourceTripEntrys.get(i);
            String vehicles = sourceTripEntry.getString("vehicles");
            String sourceTripEntryId = String.valueOf(sourceTripEntry.getPkValue());
            if (tripExpenseItemMap.get(sourceTripEntryId) != null) continue;
            List<String> collect = Arrays.stream(vehicles.split(",")).filter(e -> org.apache.commons.lang.StringUtils.isNotBlank((String)e)).collect(Collectors.toList());
            List<DynamicObject> tripExpenseItemInfos = this.getDefaultExpenseItems(companyId, collect);
            tripExpenseItemMap.put(sourceTripEntryId, tripExpenseItemInfos);
        }
        return tripExpenseItemMap;
    }

    private List<DynamicObject> getDefaultExpenseItems(Long companyId, String vehicle) {
        List tripExpenseItems = CoreBaseBillServiceHelper.getTripExpenseItems((Long)companyId);
        Map<Object, DynamicObject> tripExpItemMaps = tripExpenseItems.stream().filter(e -> e != null).collect(Collectors.toMap(DataEntityBase::getPkValue, e -> e));
        Long vehicleItem = TripExpenseItemServiceHelper.getSingleTripExpItemByCompanyAndVehicle((Long)companyId, (String)vehicle);
        DynamicObject vehicleExpenseItem = tripExpItemMaps.get(vehicleItem);
        List<DynamicObject> defaultList = tripExpenseItems.stream().filter(item -> item.getBoolean("isdefault") == Boolean.TRUE.booleanValue()).collect(Collectors.toList());
        if (vehicleExpenseItem != null) {
            defaultList.remove(vehicleExpenseItem);
            defaultList.add(0, vehicleExpenseItem);
        }
        return defaultList;
    }

    private List<DynamicObject> getDefaultExpenseItems(Long companyId, List<String> vehicles) {
        List tripExpenseItems = CoreBaseBillServiceHelper.getTripExpenseItems((Long)companyId);
        Map<Object, DynamicObject> tripExpItemMaps = tripExpenseItems.stream().filter(e -> e != null).collect(Collectors.toMap(DataEntityBase::getPkValue, e -> e));
        List<DynamicObject> defaultList = tripExpenseItems.stream().filter(item -> item.getBoolean("isdefault") == Boolean.TRUE.booleanValue()).collect(Collectors.toList());
        String needCarryVehicle = (String)ErCommonUtils.getEMParameter((long)companyId, (String)"needcarryvehicle");
        if (needCarryVehicle != null && needCarryVehicle.equals("1")) {
            for (int i = 0; i < vehicles.size(); ++i) {
                String vehicle = vehicles.get(i);
                Long vehicleItem = TripExpenseItemServiceHelper.getSingleTripExpItemByCompanyAndVehicle((Long)companyId, (String)vehicle);
                DynamicObject vehicleExpenseItem = tripExpItemMaps.get(vehicleItem);
                if (vehicleExpenseItem == null) continue;
                defaultList.remove(vehicleExpenseItem);
                defaultList.add(0, vehicleExpenseItem);
            }
        }
        return defaultList;
    }

    private void initDefaultTargetEntryData(Map<String, List<DynamicObject>> tripExpenseItemMap, DynamicObject targetBill, Long tripentrysourceid, int index) {
        Long toCityId;
        ErTripStdServiceImp stdService;
        DynamicObject tripArea;
        DynamicObjectCollection targetTripEntrys = targetBill.getDynamicObjectCollection("tripentry");
        for (int i = 0; i < targetTripEntrys.size(); ++i) {
            DynamicObject targetTripEntry = (DynamicObject)targetTripEntrys.get(i);
            if (!tripentrysourceid.equals(targetTripEntry.get("tripentrysourceid"))) continue;
            index = i;
            break;
        }
        DynamicObject targetTripEntry = (DynamicObject)targetTripEntrys.get(index);
        Long companyId = ErCommonUtils.getPk((Object)targetBill.get("company"));
        DynamicObject to = targetTripEntry.getDynamicObject("to");
        if (null != to && (tripArea = (stdService = new ErTripStdServiceImp()).getTripAreaByCityIdAndCompanyId(toCityId = (Long)to.getPkValue(), companyId)) != null) {
            targetTripEntry.set("tripentryarea", (Object)tripArea);
        }
        Long currencyId = ErCommonUtils.getPk((Object)targetBill.get("currency"));
        Long currentTripEntryTripItemId = TripExpenseItemServiceHelper.getSingleTripExpItemByCompanyAndVehicle((Long)companyId, (String)targetTripEntry.getString("vehicle"));
        Date startDate = (Date)targetTripEntry.get("startdate");
        Date endDate = (Date)targetTripEntry.get("enddate");
        Long tirpCurrencyId = ErCommonUtils.getPk((Object)targetTripEntry.get("tripcurrency"));
        DynamicObjectCollection entryentitys = targetTripEntry.getDynamicObjectCollection("entryentity");
        List<DynamicObject> tripExpenseItemInfos = tripExpenseItemMap.get(String.valueOf(tripentrysourceid));
        if (tripExpenseItemInfos == null) {
            return;
        }
        boolean configOffset = SystemParamterUtil.manuallyaddexpenseoffset((Long)companyId);
        boolean isOrgOffset = InvoiceOffsetUtils.deductibleOfTaxPayer((DynamicObject)targetBill);
        configOffset = configOffset && isOrgOffset;
        Integer entrySeq = 0;
        for (DynamicObject tripExpenseItemInfo : tripExpenseItemInfos) {
            DynamicObject entry = entryentitys.addNew();
            entry.set("expenseitem_id", tripExpenseItemInfo.getPkValue());
            entry.set("exchangerate", (Object)targetTripEntry.getBigDecimal("tripexchangerate"));
            entry.set("entrycurrency", (Object)targetTripEntry.getDynamicObject("tripcurrency"));
            entry.set("detailquotetype", (Object)((String)targetTripEntry.get("tripquotetype")));
            if (tirpCurrencyId != null && tirpCurrencyId.compareTo(currencyId) != 0) {
                entry.set("isMulticurrency", (Object)Boolean.TRUE);
            }
            entry.set("pic", tripExpenseItemInfo.get("expenseitemicon"));
            entry.set("offset", (Object)(configOffset && tripExpenseItemInfo.getBoolean("isoffset") ? 1 : 0));
            entry.set("taxrate", tripExpenseItemInfo.get("taxrate"));
            entrySeq = entrySeq + 1;
            entry.set("seq", (Object)entrySeq);
            entry.set("daycount", targetTripEntry.get("tripday"));
            BigDecimal calDaycount = CommonServiceHelper.getLiveDaysByDate((Date)startDate, (Date)endDate);
            if (tripExpenseItemInfo.getString("attribute").equals("1")) {
                calDaycount = CommonServiceHelper.getSubsidyDaysByDate((Date)startDate, (Date)endDate, (Long)companyId);
            }
            entry.set("caldaycount", (Object)calDaycount);
            entry.set("trip2startdate", (Object)startDate);
            entry.set("trip2enddate", (Object)endDate);
            if (Objects.equals(tripExpenseItemInfo.getPkValue(), currentTripEntryTripItemId)) {
                entry.set("isdefault", (Object)Boolean.TRUE);
            }
            entry.set("itemfrom", (Object)ItemFrom.Manual.getValue());
            entry.set("settlementtype", (Object)"1");
        }
        TripReimCreateOrderEntrysUtil.adjuestExpenseDetailOrder((DynamicObjectCollection)entryentitys);
    }

    protected void genOrderEntrys(ExtendedDataEntity billDataEntity, Map<String, DynamicProperty> srcfldPro, DynamicObject targetBill) {
        List sourceBillRows = (List)billDataEntity.getValue("ConvertSource");
        ArrayList<Long> reqBillIds = new ArrayList<Long>(sourceBillRows.size());
        ArrayList<String> reqBillNos = new ArrayList<String>(sourceBillRows.size());
        for (int i = 0; i < sourceBillRows.size(); ++i) {
            Long reqbillId = (Long)srcfldPro.get("id").getValue(sourceBillRows.get(i));
            String reqbillNo = (String)srcfldPro.get("billno").getValue(sourceBillRows.get(i));
            reqBillIds.add(reqbillId);
            reqBillNos.add(reqbillNo);
        }
        Long companyId = ErCommonUtils.getPk((Object)targetBill.getDynamicObject("company"));
        List notReimbursedOrderList = TripNotReimbursedOrderUtil.queryNotReimbursedOrdersByReq(reqBillIds, reqBillNos, (Long)companyId);
        if (notReimbursedOrderList == null || notReimbursedOrderList.isEmpty()) {
            return;
        }
        List noTripIdNotReimbursedOrderList = notReimbursedOrderList;
        Map notReimbursedOrderTripIdMap = notReimbursedOrderList.stream().collect(Collectors.groupingBy(v -> v.getString("tripid"), Collectors.mapping(v -> v, Collectors.toList())));
        boolean isShowInvoiceEntry = SystemParamterUtil.getIsShowInvoiceEntry((long)companyId);
        DynamicObjectCollection targetTripEntrys = targetBill.getDynamicObjectCollection("tripentry");
        List<DynamicObject> currentTripOrders = null;
        for (int i = 0; i < targetTripEntrys.size(); ++i) {
            DynamicObject targetTripEntry = (DynamicObject)targetTripEntrys.get(i);
            String currentSourcetripid = targetTripEntry.getString("tripentrysourceid");
            Set<Long> travelerIdSet = this.getTargetTravelerIdSet(targetTripEntry);
            if (i > 0 && currentTripOrders != null && !currentSourcetripid.equals(((DynamicObject)targetTripEntrys.get(i - 1)).getString("tripentrysourceid"))) {
                this.initMappingNotExistTravlerOrders(targetBill, (DynamicObject)targetTripEntrys.get(i - 1), currentTripOrders, isShowInvoiceEntry);
            }
            if ((currentTripOrders = notReimbursedOrderTripIdMap.get(currentSourcetripid)) == null || currentTripOrders.size() < 1) continue;
            noTripIdNotReimbursedOrderList.removeAll(currentTripOrders);
            List successInitOrderBills = TripReimCreateOrderEntrysUtil.initOrderEntrys((DynamicObject)targetBill, (DynamicObject)targetTripEntry, travelerIdSet, currentTripOrders, (boolean)isShowInvoiceEntry, null, null, null);
            if (successInitOrderBills.isEmpty()) continue;
            currentTripOrders.removeAll(successInitOrderBills);
        }
        DynamicObject lastTargetTripEntry = (DynamicObject)targetTripEntrys.get(targetTripEntrys.size() - 1);
        this.initMappingNotExistTravlerOrders(targetBill, lastTargetTripEntry, currentTripOrders, isShowInvoiceEntry);
        DynamicObject firstTargetTripEntry = (DynamicObject)targetTripEntrys.get(0);
        this.initMappingNotExistTravlerOrders(targetBill, firstTargetTripEntry, noTripIdNotReimbursedOrderList, isShowInvoiceEntry);
        TripReimburseServiceHelper.updateBillHeadAmount((DynamicObject)targetBill);
    }

    private void initMappingNotExistTravlerOrders(DynamicObject targetBill, DynamicObject lastTargetTripEntry, List<DynamicObject> tripOrders, boolean isShowInvoiceEntry) {
        Set<Long> travelerIdSet;
        if (tripOrders == null || tripOrders.isEmpty()) {
            return;
        }
        Set<Long> finalTravelerIdSet = travelerIdSet = this.getTargetTravelerIdSet(lastTargetTripEntry);
        tripOrders.stream().forEach(tripOrder -> {
            Long sourcetravelerId = TripBusinessRelatDailyBusinessUtil.getOrderTravelerId((DynamicObject)tripOrder);
            finalTravelerIdSet.add(sourcetravelerId);
        });
        TripReimCreateOrderEntrysUtil.initOrderEntrys((DynamicObject)targetBill, (DynamicObject)lastTargetTripEntry, finalTravelerIdSet, tripOrders, (boolean)isShowInvoiceEntry, null, null, null);
    }

    private Set<Long> getTargetTravelerIdSet(DynamicObject targetTripEntry) {
        DynamicObjectCollection travelers = targetTripEntry.getDynamicObjectCollection("travelers");
        if (travelers == null || travelers.isEmpty()) {
            return new HashSet<Long>();
        }
        HashSet<Long> travelerIdSet = new HashSet<Long>(travelers.size());
        for (DynamicObject traveler : travelers) {
            Long travelerId = ErCommonUtils.getPk((Object)traveler.get("fbasedataid_id"));
            travelerIdSet.add(travelerId);
        }
        return travelerIdSet;
    }

    public static QFilter tripReqSelectBillSetFilter(DynamicObject targetBill) {
        DynamicObjectCollection tripEntry = targetBill.getDynamicObjectCollection("tripentry");
        ArrayList travelerList = new ArrayList();
        for (int i = 0; i < tripEntry.size(); ++i) {
            DynamicObjectCollection travelers = ((DynamicObject)tripEntry.get(i)).getDynamicObjectCollection("travelers");
            travelerList.addAll(travelers);
        }
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObjectCollection writeOffApplyEntry = targetBill.getDynamicObjectCollection("writeoffapply");
        List selectBillNumbers = writeOffApplyEntry.stream().map(bill -> bill.getString("applybillno")).collect(Collectors.toList());
        Set travelerIdSet = travelerList.stream().map(traveler -> traveler.getLong("fbasedataid_id")).collect(Collectors.toSet());
        Long applierId = ErCommonUtils.getPk((Object)targetBill.get("applier"));
        travelerIdSet.add(applierId);
        Set<Long> billId = TripReqToTripReimburseSelectBillPlugin.getTripReqBillIds(applierId);
        QFilter qFilter = new QFilter("id", "in", billId);
        qFilter.and("billstatus", "=", (Object)"E");
        qFilter.and("isloan", "=", (Object)false);
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"er_tripreqbill", (String)"billno,id", (QFilter[])new QFilter[]{qFilter});
        qFilter.and("billno", "not in", selectBillNumbers);
        DynamicObject currency = targetBill.getDynamicObject("currency");
        qFilter.and("currency", "=", (Object)ErCommonUtils.getPk((Object)currency));
        DynamicObject company = targetBill.getDynamicObject("company");
        String reqBillToReimburseCount = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)company), (String)"reqbilltoreimbursecount");
        if (org.apache.commons.lang.StringUtils.equals((String)"0", (String)reqBillToReimburseCount) && bills.size() > 0) {
            Set<Long> idSet = bills.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
            String params = Stream.generate(() -> "?").limit(idSet.size()).collect(Collectors.joining(","));
            String sql = String.format("SELECT fsbillid FROM t_er_reimbclearapplyentry_lk WHERE FSBILLID IN (%s);", params);
            Set fsbillidUp = (Set)DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, (Object[])idSet.toArray(new Long[idSet.size()]), resultSet -> {
                HashSet<Long> sBillIds = new HashSet<Long>(3);
                while (resultSet.next()) {
                    sBillIds.add(resultSet.getLong("fsbillid"));
                }
                return sBillIds;
            });
            sql = String.format("SELECT fsbillid FROM T_ER_ReimburseBill_lk WHERE FSBILLID IN (%s);", params);
            Set fsbillidPush = (Set)DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, (Object[])idSet.toArray(new Long[idSet.size()]), resultSet -> {
                HashSet<Long> sBillIds = new HashSet<Long>(3);
                while (resultSet.next()) {
                    sBillIds.add(resultSet.getLong("fsbillid"));
                }
                return sBillIds;
            });
            fsbillidPush.addAll(fsbillidUp);
            Long[] allIds = (Long[])fsbillidPush.stream().toArray(Long[]::new);
            Map exitsPushBill = BFTrackerServiceHelper.findTargetBills((String)"er_tripreqbill", (Long[])allIds);
            if (exitsPushBill != null && exitsPushBill.containsKey("er_tripreimbursebill")) {
                QFilter qF = new QFilter("billstatus", "!=", (Object)"H");
                qF.and("id", "in", exitsPushBill.get("er_tripreimbursebill"));
                DynamicObjectCollection notDisCardBill = QueryServiceHelper.query((String)"er_tripreimbursebill", (String)"id,billstatus", (QFilter[])new QFilter[]{qF});
                Set notDisCardIds = notDisCardBill.stream().map(v -> ErCommonUtils.getPk((Object)v.getLong("id"))).collect(Collectors.toSet());
                Map excludeBill = BFTrackerServiceHelper.findSourceBills((String)"er_tripreimbursebill", (Long[])((Long[])notDisCardIds.stream().toArray(Long[]::new)));
                fsbillidPush = (Set)excludeBill.get("er_tripreqbill");
            }
            qFilter.and("id", "not in", (Object)fsbillidPush);
        }
        return qFilter;
    }

    public static void setMobShowData(DynamicObjectCollection writeOffApplyEntity, List<String> billNumbers) {
        if (writeOffApplyEntity != null && !writeOffApplyEntity.isEmpty()) {
            DynamicObject[] selectBills = BusinessDataServiceHelper.load((String)"er_tripreqbill", (String)"billno, rvehicle,tripentry.from,tripentry.to,tripentry.startdate,tripentry.enddate,tripentry.travelers", (QFilter[])new QFilter[]{new QFilter("billno", "in", billNumbers).and("tripentry.seq", "=", (Object)1)});
            HashMap<String, DynamicObject> billNoMap = new HashMap<String, DynamicObject>(selectBills.length);
            for (DynamicObject bill : selectBills) {
                billNoMap.put(bill.getString("billno"), bill);
            }
            for (DynamicObject row : writeOffApplyEntity) {
                DynamicObject bill = (DynamicObject)billNoMap.get(row.getString("applybillno"));
                DynamicObject tripEntry = (DynamicObject)bill.getDynamicObjectCollection("tripentry").get(0);
                row.set("applyfromcity", tripEntry.get("from"));
                row.set("applytocity", tripEntry.get("to"));
                row.set("applystartdate", tripEntry.get("startdate"));
                row.set("applyenddate", tripEntry.get("enddate"));
                row.set("applyrvehicle", bill.get("rvehicle"));
                DynamicObjectCollection tripentry = bill.getDynamicObjectCollection("tripentry");
                HashSet ids = Sets.newHashSetWithExpectedSize((int)tripentry.size());
                for (DynamicObject ite : tripentry) {
                    Set traveler = ite.getDynamicObjectCollection("travelers").stream().map(v -> (Long)v.get("fbasedataid_id")).collect(Collectors.toSet());
                    ids.addAll(traveler);
                }
                DynamicObjectCollection targetApplyTravers = row.getDynamicObjectCollection("applytravelers");
                targetApplyTravers.clear();
                for (Long id : ids) {
                    DynamicObject trav = targetApplyTravers.addNew();
                    trav.set("fbasedataid_id", (Object)id);
                }
                row.set("applytravelers", (Object)targetApplyTravers);
            }
        }
    }

    private void tripEntrySetVehicleAndTravlerForDraw(DynamicObject[] sourceBillObject, DynamicObject targetBill) {
        BillEntityType srcMainType = this.getSrcMainType();
        BillEntityType tgtMainType = this.getTgtMainType();
        List srcTripEntry = Arrays.stream(sourceBillObject).flatMap(l -> l.getDynamicObjectCollection("tripentry").stream()).collect(Collectors.toList());
        DynamicObjectCollection targetTripEntry = targetBill.getDynamicObjectCollection("tripentry");
        MulBasedataProp targetFieldProp = (MulBasedataProp)tgtMainType.findProperty("travelers");
        MulBasedataProp sourceFieldProp = (MulBasedataProp)srcMainType.findProperty("travelers");
        Map<Long, DynamicObject> srcIdMappingEntry = srcTripEntry.stream().collect(Collectors.toMap(row -> row.getLong("id"), row -> row));
        for (DynamicObject tgtRow : targetTripEntry) {
            DynamicObject srcRow = srcIdMappingEntry.get(tgtRow.getLong("tripentrysourceid"));
            if (srcRow == null) continue;
            tgtRow.set("vehicles", srcRow.get("vehicles"));
            DynamicObjectCollection srcMulField = srcRow.getDynamicObjectCollection("travelers");
            DynamicObjectCollection targetMulField = tgtRow.getDynamicObjectCollection("travelers");
            for (DynamicObject srcElement : srcMulField) {
                DynamicObject targetElement = new DynamicObject(targetFieldProp.getDynamicCollectionItemPropertyType());
                targetFieldProp.getRefIdProp().setValue((Object)targetElement, sourceFieldProp.getRefIdProp().getValue((Object)srcElement));
                targetMulField.add((Object)targetElement);
            }
        }
    }

    private void setTripMulWayTo(DynamicObject[] srcBills, DynamicObject tagetBill) {
        Map<Long, DynamicObject> idMapEntry = Arrays.stream(srcBills).flatMap(l -> l.getDynamicObjectCollection("tripentry").stream()).filter(card -> card.get("id") != null).collect(Collectors.toMap(item -> item.getLong("id"), item -> item, (v1, v2) -> v1));
        DynamicObjectCollection targetBillTripentrys = tagetBill.getDynamicObjectCollection("tripentry");
        MulBasedataProp targetFieldProp = (MulBasedataProp)this.getSrcMainType().findProperty("mulwayto");
        MulBasedataProp sourceFieldProp = (MulBasedataProp)this.getTgtMainType().findProperty("mulwayto");
        for (int i = 0; i < targetBillTripentrys.size(); ++i) {
            DynamicObject targetBillTripentry = (DynamicObject)targetBillTripentrys.get(i);
            DynamicObjectCollection targetFieldRows = targetBillTripentry.getDynamicObjectCollection("mulwayto");
            targetFieldRows.clear();
            DynamicObject sourceBillTripentry = idMapEntry.get(targetBillTripentry.getLong("tripentrysourceid"));
            if (sourceBillTripentry == null) continue;
            DynamicObjectCollection sourceFieldRows = sourceBillTripentry.getDynamicObjectCollection("mulwayto");
            for (DynamicObject srcFieldRow : sourceFieldRows) {
                DynamicObject targetFieldRow = new DynamicObject(targetFieldProp.getDynamicCollectionItemPropertyType());
                targetFieldProp.getRefIdProp().setValue((Object)targetFieldRow, sourceFieldProp.getRefIdProp().getValue((Object)srcFieldRow));
                targetFieldRows.add((Object)targetFieldRow);
            }
        }
    }

    public static Set<Long> getTripReqBillIds(Long applierId) {
        Set EntrustId = EntrustReimburseUtils.addConsignor((Long)applierId, (String)"er_tripreqbill");
        EntrustId.add(applierId);
        String params = Stream.generate(() -> "?").limit(EntrustId.size()).collect(Collectors.joining(","));
        String sql = String.format("select fid from T_ER_ReqBill WHERE fapplierid IN (%s) and fbillstatus='E';", params);
        Set reqBillIds = (Set)DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, (Object[])EntrustId.toArray(new Long[EntrustId.size()]), resultSet -> {
            HashSet<Long> billIds = new HashSet<Long>(3);
            while (resultSet.next()) {
                billIds.add(resultSet.getLong("fid"));
            }
            return billIds;
        });
        sql = String.format("select e.fid as fid from T_ER_ReqBill r left join t_er_reqtripentry e on e.fid=r.fid left join t_er_reqbillpartner p on e.fentryid = p.fentryid  where p.fbasedataid = " + applierId + " and r.fbillstatus = 'E';", new Object[0]);
        reqBillIds.addAll((Collection)DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, resultSet -> {
            HashSet<Long> billIds = new HashSet<Long>(3);
            while (resultSet.next()) {
                billIds.add(resultSet.getLong("fid"));
            }
            return billIds;
        }));
        sql = String.format("select e.fid as fid from  T_ER_ReqBill e left join t_er_tripreqower p on e.fid = p.fid  where p.fbasedataid = " + applierId + " and e.fbillstatus='E' ;", new Object[0]);
        reqBillIds.addAll((Collection)DB.query((DBRoute)DBRoute.of((String)"er"), (String)sql, resultSet -> {
            HashSet<Long> billIds = new HashSet<Long>(3);
            while (resultSet.next()) {
                billIds.add(resultSet.getLong("fid"));
            }
            return billIds;
        }));
        return reqBillIds;
    }
}

