/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.botp;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.fi.er.business.utils.ErChangeAccountConvertUtils;

public class ExpenseBillToAgentBillConvertPlugin
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(ExpenseBillToAgentBillConvertPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("costcompany");
    }

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        if (ErChangeAccountConvertUtils.pushValidator((AbstractConvertPlugIn)this, (BeforeBuildRowConditionEventArgs)e)) {
            return;
        }
        List selectedRows = e.getSelectedRows();
        List pkLists = selectedRows.stream().map(v -> v.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObject[] load = BusinessDataServiceHelper.load((String)this.getSrcMainType().getName(), (String)"costcompany.id,costcompany.name", (QFilter[])new QFilter[]{new QFilter("id", "in", pkLists)});
        boolean bankOrg = true;
        String errorMsg = null;
        for (DynamicObject srcBill : load) {
            if (ExpenseBillToAgentBillConvertPlugin.getBankRollOrg(srcBill.getDynamicObject("costcompany").getPkValue()) != 0L) continue;
            bankOrg = false;
            errorMsg = String.format(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u201c%s\u201d\u672a\u8bbe\u7f6e\u8d44\u91d1\u7ec4\u7ec7\u59d4\u6258\uff0c\u65e0\u6cd5\u4e0b\u63a8\u3002", (String)"ExpenseBillToAgentBillConvertPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), srcBill.getDynamicObject("costcompany").get("name"));
            break;
        }
        if (!bankOrg) {
            e.setCustFilterDesc(errorMsg);
            e.setCustFilterExpression(" billstatus = '-1' ");
            QFilter qFilter = new QFilter("billstatus", "=", (Object)"-1");
            e.getCustQFilters().add(qFilter);
        }
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        ArrayList srcBillPks = Lists.newArrayListWithExpectedSize((int)billDataEntitys.length);
        String srcEntityNumber = this.getSrcMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            DynamicObject srcRow = (DynamicObject)srcRows.get(0);
            srcBillPks.add(((DynamicProperty)e.getFldProperties().get("id")).getValue((Object)srcRow));
            Object costCompany = ((DynamicProperty)e.getFldProperties().get("costcompany")).getValue((Object)srcRow);
            Long bankRollOrg = ExpenseBillToAgentBillConvertPlugin.getBankRollOrg(costCompany);
            billDataEntity.getDataEntity().set("org_id", (Object)bankRollOrg);
        }
        ExpenseBillToAgentBillConvertPlugin.setFundFlowItem(e, srcEntityNumber, srcBillPks, billDataEntitys);
    }

    private static void setFundFlowItem(AfterFieldMappingEventArgs e, String srcEntityNumber, List<Object> srcBillPks, ExtendedDataEntity[] billDataEntitys) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)srcEntityNumber);
        DynamicProperty tripexpenseitem = dataEntityType.getProperty("tripentry");
        String expenseItemField = tripexpenseitem != null ? "tripentry.tripexpenseitem" : "expenseentryentity.expenseitem";
        DynamicObjectCollection sourcebills = QueryServiceHelper.query((String)srcEntityNumber, (String)expenseItemField.concat(",id"), (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillPks)});
        Map<Object, Object> sourceExpenseItemMap = sourcebills.stream().collect(Collectors.toMap(k -> k.get("id"), v -> v.get(expenseItemField), (a, b) -> a));
        DynamicObjectCollection rel_expesne_fundflow = QueryServiceHelper.query((String)"er_rel_expense_fundflow", (String)"fundflowitem,expenseitem", (QFilter[])new QFilter[]{new QFilter("expenseitem", "in", sourceExpenseItemMap.values())});
        Map<Object, Object> rel_expesne_fundflowMap = rel_expesne_fundflow.stream().collect(Collectors.toMap(k -> k.get("expenseitem"), v -> v.get("fundflowitem"), (a, b) -> a));
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            Object fundflowitemID;
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            DynamicObject srcRow = (DynamicObject)srcRows.get(0);
            Object sourcebillID = ((DynamicProperty)e.getFldProperties().get("id")).getValue((Object)srcRow);
            Object sourceExpenseItem = sourceExpenseItemMap.get(sourcebillID);
            if (sourceExpenseItem == null || (fundflowitemID = rel_expesne_fundflowMap.get(sourceExpenseItem)) == null) continue;
            DynamicObjectCollection coll = billDataEntity.getDataEntity().getDynamicObjectCollection("entry");
            coll.forEach(v -> v.set("e_fundflowitem_id", fundflowitemID));
        }
    }

    private static Long getBankRollOrg(Object org) {
        Long companyId = 0L;
        Long orgId = Long.valueOf(org.toString());
        try {
            String fromOrgType = "10";
            String toOrgType = "08";
            Long billTypeId = 0L;
            companyId = OrgServiceHelper.getToOrg((String)fromOrgType, (String)toOrgType, (Long)orgId, (Long)billTypeId);
        }
        catch (Exception e) {
            logger.info(String.format("getBankRollOrg error \uff1aorgId = %s", orgId) + "exmsg:" + e.getMessage());
        }
        if (companyId == 0L && ExpenseBillToAgentBillConvertPlugin.isBankRollOrg(orgId)) {
            companyId = orgId;
        }
        return companyId;
    }

    private static boolean isBankRollOrg(Long orgId) {
        QFilter idFilter = new QFilter("id", "=", (Object)orgId);
        QFilter dutyFilter = new QFilter("fisbankroll", "=", (Object)true);
        QFilter[] filters = new QFilter[]{idFilter, dutyFilter};
        return QueryServiceHelper.exists((String)"bos_org", (QFilter[])filters);
    }
}

