/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.botp;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.ErChangeAccountConvertUtils;

public class ExpenseBillToPayBillConvertPlugin
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(ExpenseBillToPayBillConvertPlugin.class);

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        ErChangeAccountConvertUtils.pushValidator((AbstractConvertPlugIn)this, (BeforeBuildRowConditionEventArgs)e);
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        String targetEntityNumber = this.getTgtMainType().getName();
        String srcEntityNumber = this.getSrcMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        ArrayList srcBillPks = Lists.newArrayListWithExpectedSize((int)billDataEntitys.length);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject targetBill = billDataEntity.getDataEntity();
            this.setTargetBillPayerBank(targetBill);
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            DynamicObject srcRow = (DynamicObject)srcRows.get(0);
            srcBillPks.add(((DynamicProperty)e.getFldProperties().get("id")).getValue((Object)srcRow));
        }
        ExpenseBillToPayBillConvertPlugin.setFundFlowItem(e, srcEntityNumber, srcBillPks, billDataEntitys);
    }

    private static void setFundFlowItem(AfterFieldMappingEventArgs e, String srcEntityNumber, List<Object> srcBillPks, ExtendedDataEntity[] billDataEntitys) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)srcEntityNumber);
        DynamicProperty tripexpenseitem = dataEntityType.getProperty("tripentry");
        String expenseItemField = tripexpenseitem != null ? "tripentry.tripexpenseitem" : "expenseentryentity.expenseitem";
        DynamicObjectCollection sourcebills = QueryServiceHelper.query((String)srcEntityNumber, (String)expenseItemField.concat(",id"), (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillPks)});
        Map<Object, Object> sourceExpenseItemMap = sourcebills.stream().collect(Collectors.toMap(k -> k.get("id"), v -> v.get(expenseItemField), (a, b) -> a));
        DynamicObjectCollection rel_expesne_fundflow = QueryServiceHelper.query((String)"er_rel_expense_fundflow", (String)"fundflowitem,expenseitem", (QFilter[])new QFilter[]{new QFilter("expenseitem", "in", sourceExpenseItemMap.values())});
        Map<Object, Object> rel_expesne_fundflowMap = rel_expesne_fundflow.stream().collect(Collectors.toMap(k -> k.get("expenseitem"), v -> v.get("fundflowitem"), (a, b) -> a));
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            Object fundflowitemID;
            DynamicObject targetBill = billDataEntity.getDataEntity();
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            DynamicObject srcRow = (DynamicObject)srcRows.get(0);
            Object sourcebillID = ((DynamicProperty)e.getFldProperties().get("id")).getValue((Object)srcRow);
            Object sourceExpenseItem = sourceExpenseItemMap.get(sourcebillID);
            if (sourceExpenseItem == null || (fundflowitemID = rel_expesne_fundflowMap.get(sourceExpenseItem)) == null) continue;
            billDataEntity.setValue("fundflowitem_id", fundflowitemID);
        }
    }

    private void setTargetBillPayerBank(DynamicObject targetBill) {
        DynamicObject payerAcctBank = targetBill.getDynamicObject("payeracctbank");
        if (payerAcctBank != null) {
            DynamicObject payerBank = payerAcctBank.getDynamicObject("bank");
            if (payerBank != null) {
                targetBill.set("payerbank_id", payerBank.getPkValue());
            } else {
                logger.info("\u8be5\u7ec4\u7ec7\u94f6\u884c\u8d26\u6237\u5bf9\u5e94\u91d1\u878d\u673a\u6784\u4e3a\u7a7a\uff1apayeracctbank -->" + SerializationUtils.toJsonString((Object)payerAcctBank) + "-->" + SerializationUtils.toJsonString((Object)payerBank));
            }
        }
    }
}

