/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.daily.service.ErMainPageDailyService;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.invoicepackage.util.QuickReimUtil;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.utils.ErOrgUtils;
import kd.fi.er.common.model.invoice.InvoiceAttachmentVo;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.common.model.invoice.xh.AttachData;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import kd.fi.er.model.FormModel;
import kd.fi.er.model.MainPageModel;
import org.apache.commons.lang3.StringUtils;

public class ErHomeAddNewDialogPlugin
extends AbstractMobFormPlugin {
    private static final Log log = LogFactory.getLog(AbstractMobFormPlugin.class);
    protected static final Map<String, MainPageModel> controlMap = new HashMap<String, MainPageModel>();
    private static final String MSCAN_TYPE = "mscantype";

    public void afterCreateNewData(EventObject e) {
        Long costCompanyId = ErOrgUtils.getCostCompanyId((AbstractFormPlugin)this, (ErMainPageDailyService)((ErMainPageDailyService)this.getView().getService(ErMainPageDailyService.class)));
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)costCompanyId);
        if (config != null) {
            ShowInvoiceCloudPageUtil.registCheckback((AbstractFormPlugin)this);
        }
    }

    public void registerListener(EventObject e) {
        Set<String> controlIdSet = controlMap.keySet();
        String[] controlIds = controlIdSet.toArray(new String[controlIdSet.size()]);
        this.addClickListeners(controlIds);
        this.addClickListeners(new String[]{"mscanquickreim"});
    }

    public void click(EventObject evt) {
        Long costCompanyId;
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (controlMap.get(key) != null) {
            MainPageModel mainPageModel = controlMap.get(key);
            if (mainPageModel == null) {
                return;
            }
            FormModel formModel = new FormModel(mainPageModel.getFormId(), mainPageModel.getFormName(), mainPageModel.getFormType(), mainPageModel.getCallBack().booleanValue());
            FormShowParameter formShowParameter = formModel.getFormShowParameter();
            if ("mblock_applyproject_add".equals(key) || "mblock_contract_add".equals(key)) {
                mainPageModel.getCustomParam().put("checkRightAppId", "cexp");
                if (formShowParameter.getAppId() == null) {
                    formShowParameter.setAppId("1GARA29DA8+R");
                }
            } else {
                mainPageModel.getCustomParam().put("checkRightAppId", "exp");
                if (formShowParameter.getAppId() == null) {
                    formShowParameter.setAppId("18X6P1ZSXS44");
                }
            }
            if ("mblock_enapply_add".equals(key) || "mblock_enpubreim_add".equals(key)) {
                formShowParameter.setCustomParam("reimbursetype", (Object)"entertainment");
                formShowParameter.setCustomParam("bizitem", (Object)"entertainment");
            } else if ("mblock_meetapply_add".equals(key) || "mblock_meetpubreim_add".equals(key)) {
                formShowParameter.setCustomParam("reimbursetype", (Object)"meetting");
                formShowParameter.setCustomParam("bizitem", (Object)"meetting");
            } else if ("mblock_enapplybill_add".equals(key) || "mblock_enreimbill_add".equals(key)) {
                formShowParameter.setCustomParam("reimbursetype", (Object)"entertainment_bill");
                formShowParameter.setCustomParam("bizitem", (Object)"entertainment_bill");
            } else if ("mblock_meetapplybill_add".equals(key) || "mblock_meetreimbill_add".equals(key)) {
                formShowParameter.setCustomParam("reimbursetype", (Object)"meetting_bill");
                formShowParameter.setCustomParam("bizitem", (Object)"meetting_bill");
            } else if ("mblock_asset_add".equals(key)) {
                formShowParameter.setCustomParam("reimbursetype", (Object)"asset");
                formShowParameter.setCustomParam("bizitem", (Object)"asset");
            } else if ("mblock_publicreimburs_add".equals(key) || "mblock_prepaybill_add".equals(key)) {
                String appid = "exp";
                Set licenseModules = LicenseServiceHelper.getLicenseModules();
                if (CollectionUtils.isNotEmpty((Collection)licenseModules)) {
                    if (licenseModules.stream().anyMatch("exp"::equalsIgnoreCase)) {
                        appid = "exp";
                    }
                    if (licenseModules.stream().anyMatch("cexp"::equalsIgnoreCase)) {
                        appid = "cexp";
                    }
                }
                mainPageModel.getCustomParam().put("checkRightAppId", appid);
                formShowParameter.setAppId(appid);
            }
            this.getView().showForm(formShowParameter);
        } else if ("mscanquickreim".equalsIgnoreCase(key) && (costCompanyId = ErOrgUtils.getCostCompanyId((AbstractFormPlugin)this, (ErMainPageDailyService)((ErMainPageDailyService)this.getView().getService(ErMainPageDailyService.class)))) != null) {
            this.getPageCache().put(MSCAN_TYPE, key);
            boolean enableXhInvoice = KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud();
            if (enableXhInvoice) {
                ShowInvoiceCloudPageUtil.showCosmicInvoiceListOnMob((AbstractFormPlugin)this, (String)"rim_inv_collect_mobile", (String)"alreadyBackFromXHInvoiceCloud", (ShowType)ShowType.Floating, (Long)costCompanyId);
            } else {
                ShowInvoiceCloudPageUtil.importInvoiceFromInvoicePackageInMob((AbstractFormPlugin)this, (Long)costCompanyId, null);
            }
        }
    }

    public void customEvent(CustomEventArgs e) {
        try {
            String eventName = e.getEventName();
            log.info("\u3010\u53d1\u7968\u5939\u3011\u53d1\u7968\u52a9\u624b\u5df2\u5173\u95ed\uff0c\u89e6\u53d1: " + eventName);
            if ("alreadyBackFromInvoiceCloud".equalsIgnoreCase(eventName)) {
                String msg = e.getEventArgs();
                log.info("\u3010\u53d1\u7968\u5939\u3011\u53d1\u7968\u52a9\u624b\u5df2\u5173\u95ed\uff0c\u8fd4\u56de: " + msg);
                JSONObject importInvoiceJson = JSON.parseObject((String)msg);
                if (importInvoiceJson.containsKey((Object)"version")) {
                    String serialNoStr = importInvoiceJson.getString("serialNo");
                    JSONObject option = importInvoiceJson.getJSONObject("option");
                    JSONArray certificateList = option.getJSONArray("certificateList");
                    if (StringUtils.isEmpty((CharSequence)serialNoStr) && certificateList.isEmpty()) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u5939\u3011\u672a\u63a5\u6536\u5230\u53d1\u7968\u4e91\u4f20\u9012\u7684\u6570\u636e\u3002", (String)"ImportInvoiceInMainPageMobPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    Long costCompanyId = ErOrgUtils.getCostCompanyId((AbstractFormPlugin)this, (ErMainPageDailyService)((ErMainPageDailyService)this.getView().getService(ErMainPageDailyService.class)));
                    InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)costCompanyId);
                    if (config == null) {
                        return;
                    }
                    List invoiceVOS = QuickReimUtil.queryInvoice((String)serialNoStr, (InvoiceCloudCfgBO)config, (IFormView)this.getView());
                    List attachmentVos = certificateList.toJavaList(InvoiceAttachmentVo.class);
                    if (kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)invoiceVOS) && kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)attachmentVos)) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u5939\u3011\u672a\u63a5\u6536\u5230\u53d1\u7968\u4e91\u4f20\u9012\u7684\u6570\u636e\u3002", (String)"ImportInvoiceInMainPageMobPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    String mscanType = this.getPageCache().get(MSCAN_TYPE);
                    ShowInvoiceCloudPageUtil.openQuickReimList((List)invoiceVOS, (List)attachmentVos, (String)mscanType, (AbstractFormPlugin)this);
                }
            }
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u5939\u3011customEvent\u5f02\u5e38\uff1a%s\u3002", (String)"ImportInvoiceInMainPageMobPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]), ex));
            log.error((Throwable)ex);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        log.info("\u3010\u4e00\u952e\u62a5\u9500\u3011\u53d1\u7968\u52a9\u624b\u5df2\u5173\u95ed\uff0c\u89e6\u53d1: " + actionId);
        if (actionId != null && StringUtils.equals((CharSequence)actionId, (CharSequence)"alreadyBackFromXHInvoiceCloud")) {
            log.info("\u3010\u4e00\u952e\u62a5\u9500\u3011\u53d1\u7968\u52a9\u624b\u5df2\u5173\u95ed\uff0c\u8fd4\u56de: " + returnData);
            String returnJsonStr = JSON.toJSONString((Object)returnData);
            if (!this.isJsonStr(returnJsonStr) && StringUtils.contains((CharSequence)returnJsonStr, (CharSequence)"cancel")) {
                log.info("\u5df2\u9000\u51fa\u4e00\u952e\u62a5\u9500\u3002");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9000\u51fa\u4e00\u952e\u62a5\u9500\u3002", (String)"ImportInvoiceInMainPageMobPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            JSONObject returnJsonOb = JSON.parseObject((String)returnJsonStr);
            JSONArray invoiceDataJson = returnJsonOb.getJSONArray("invoiceData");
            JSONArray attachDataJson = returnJsonOb.getJSONArray("attachData");
            List invoiceVOS = invoiceDataJson.toJavaList(InvoiceVO.class);
            List attachmentVos = attachDataJson.toJavaList(AttachData.class);
            if (kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)invoiceVOS) && kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)attachmentVos)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u3010\u4e00\u952e\u62a5\u9500\u3011\u672a\u63a5\u6536\u5230\u53d1\u7968\u4e91\u4f20\u9012\u7684\u6570\u636e\u3002", (String)"ImportInvoiceInMainPageMobPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            String mscanType = this.getPageCache().get(MSCAN_TYPE);
            ShowInvoiceCloudPageUtil.openQuickReimList((List)invoiceVOS, (List)attachmentVos, (String)mscanType, (AbstractFormPlugin)this);
        }
    }

    private boolean isJsonStr(String returnData) {
        if (StringUtils.isEmpty((CharSequence)returnData)) {
            return false;
        }
        return returnData.startsWith("{") && returnData.endsWith("}");
    }

    static {
        controlMap.put("mblock_dailyreimbill_add", new MainPageModel("er_dailyreimbursebill_mob", null, "6", false));
        controlMap.put("mblock_dailyloanbill_add", new MainPageModel("er_dailyloanbill_mob", null, "6", false));
        controlMap.put("mblock_dailyapplybill_add", new MainPageModel("er_dailyapplybill_mob", null, "6", false));
        controlMap.put("mblock_enapply_add", new MainPageModel("er_dailyapplybill_mob", null, "6", false));
        controlMap.put("mblock_meetapply_add", new MainPageModel("er_dailyapplybill_mob", null, "6", false));
        controlMap.put("mblock_publicreimburs_add", new MainPageModel("er_publicreimbursebill_mob", null, "6", false));
        controlMap.put("mblock_enpubreim_add", new MainPageModel("er_publicreimbursebill_mob", null, "6", false));
        controlMap.put("mblock_meetpubreim_add", new MainPageModel("er_publicreimbursebill_mob", null, "6", false));
        controlMap.put("mblock_reimctlapply_add", new MainPageModel("er_reimctlapplybill_mob", null, "6", false));
        controlMap.put("mblock_prepaybill_add", new MainPageModel("er_prepaybill_mob", null, "6", false));
        controlMap.put("mblock_dailyvehicle_add", new MainPageModel("er_dailyvehiclebill_mob", null, "6", false));
        controlMap.put("mblock_applyproject_add", new MainPageModel("er_applyprojectbill_mob", null, "6", false));
        controlMap.put("mblock_mealbill_add", new MainPageModel("er_mealapplication_bill_mob", null, "6", false));
        controlMap.put("mblock_contract_add", new MainPageModel("er_contractbill_mob", null, "6", false));
        controlMap.put("mblock_enapplybill_add", new MainPageModel("er_dailyapplybill_mob", null, "6", false));
        controlMap.put("mblock_enreimbill_add", new MainPageModel("er_dailyreimbursebill_mob", null, "6", false));
        controlMap.put("mblock_meetapplybill_add", new MainPageModel("er_dailyapplybill_mob", null, "6", false));
        controlMap.put("mblock_meetreimbill_add", new MainPageModel("er_dailyreimbursebill_mob", null, "6", false));
        controlMap.put("mblock_asset_add", new MainPageModel("er_publicreimbursebill_mob", null, "6", false));
    }
}

