/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import kd.fi.er.formplugin.mobile.amount.query.AmountQueryAndReimburseForMobUtils;
import kd.fi.er.formplugin.pool.mobile.OpenFormUtil;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang.StringUtils;

public class ErMainPagePlugin
extends AbstractMobFormPlugin {
    private static final Log logger = LogFactory.getLog(ErMainPagePlugin.class);
    private static final String CACHE_TAX_REG_NUM = "cacheTaxRegNum";
    private static final String IR_APP_ID = "exp";
    private static final String PUB_APP_ID = "cexp";
    private static final String MBLOCK_PUBLICREIMBURSE = "mblock_publicreimburse";
    private static final String MBLOCK_REIMCTLAPPLY = "mblock_reimctlapply";
    private static final String MBLOCK_DAILYVEHICLEBIL = "mblock_dailyvehiclebil";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"mblock_reimburse", "mblock_loan", "floatbuttonap_new", "mcostrequest", "amt_query", "flex_dailylaon", "flex_receivable", "imag_help", MBLOCK_PUBLICREIMBURSE, "mblock_repay", "expense_record", "expense_jcl", "expense_wdfy", MBLOCK_REIMCTLAPPLY, "mblock_prepaybill", "mblock_applypaybill", "wf_mobile", MBLOCK_DAILYVEHICLEBIL, "mblock_applyproject", "mblock_mealbill", "mblock_contract"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ShowInvoiceCloudPageUtil.registCheckback((AbstractFormPlugin)this);
        this.getView().setVisible(AmountQueryAndReimburseForMobUtils.isCanShowAmtQuery(), new String[]{"amt_query"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initNotReimburse();
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter p = (FormShowParameter)e.getSource();
        if (p.getAppId() == null || p.getAppId().equals("tra")) {
            p.setAppId(IR_APP_ID);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        switch (key) {
            case "mblock_reimburse": {
                this.showMobList("er_dailyreimbursebill", "er_reimbursebill_moblist", null, null);
                break;
            }
            case "mblock_publicreimburse": {
                this.showMobList("er_publicreimbursebill", "er_reimbursebill_moblist", null, null);
                break;
            }
            case "mblock_loan": {
                this.showMobList("er_dailyloanbill", "er_dlbill_mobtemplate", null, null);
                break;
            }
            case "mblock_repay": {
                this.showMobList("er_repaymentbill", "er_repaybill__mobtemplate", null, null);
                break;
            }
            case "floatbuttonap_new": {
                FormModel formModel = new FormModel("er_addnew_dialog_daily", ResManager.loadKDString((String)"\u65b0\u589e", (String)"ErMainPagePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", true);
                ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
                break;
            }
            case "mcostrequest": {
                this.showMobList("er_dailyapplybill", "er_dapplybill_mobtemplate", null, null);
                break;
            }
            case "amt_query": {
                MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
                formShowParameter.setAppId(IR_APP_ID);
                formShowParameter.setFormId("er_employee_amt_query_mb");
                formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u989d\u5ea6\u67e5\u8be2", (String)"ErMainPagePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                this.getView().showForm((FormShowParameter)formShowParameter);
                break;
            }
            case "flex_dailylaon": {
                paraMap.put("tabKey", "noReimburse");
                this.showMobList("er_dailyloanbill", "er_dlbill_mobtemplate", paraMap, ResManager.loadKDString((String)"\u5f85\u62a5\u9500", (String)"ErMainPagePlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                break;
            }
            case "flex_receivable": {
                this.showMobList("er_dailyreimbursebill", "er_reimbursebill_moblist", null, null);
                break;
            }
            case "imag_help": {
                HashMap<String, String> para = new HashMap<String, String>();
                para.put("formId", "er_todotips");
                FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "callBackName");
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(showParameter);
            }
            case "expense_record": {
                MobileBillShowParameter mfsp = new MobileBillShowParameter();
                mfsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "expense_record"));
                mfsp.setAppId(IR_APP_ID);
                mfsp.setFormId("er_expense_recordbill_mob");
                mfsp.getOpenStyle().setShowType(ShowType.Floating);
                mfsp.setCaption(ResManager.loadKDString((String)"\u8bb0\u8d39\u7528", (String)"ErMainPagePlugin_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
                this.getView().showForm((FormShowParameter)mfsp);
                break;
            }
            case "expense_jcl": {
                MobileBillShowParameter mfspJcl = new MobileBillShowParameter();
                mfspJcl.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "expense_jcl"));
                mfspJcl.setAppId(IR_APP_ID);
                mfspJcl.setFormId("er_trip_recordbill_mob");
                mfspJcl.getOpenStyle().setShowType(ShowType.Floating);
                mfspJcl.setCaption(ResManager.loadKDString((String)"\u8bb0\u5dee\u65c5", (String)"ErMainPagePlugin_9", (String)"fi-er-formplugin", (Object[])new Object[0]));
                this.getView().showForm((FormShowParameter)mfspJcl);
                break;
            }
            case "expense_wdfy": {
                MobileFormShowParameter mfspWdfy = new MobileFormShowParameter();
                mfspWdfy.setAppId(IR_APP_ID);
                mfspWdfy.setFormId("er_expense_list_card_mb");
                mfspWdfy.getOpenStyle().setShowType(ShowType.Floating);
                mfspWdfy.setCaption(ResManager.loadKDString((String)"\u6211\u7684\u8d39\u7528", (String)"ErMainPagePlugin_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
                this.getView().showForm((FormShowParameter)mfspWdfy);
                break;
            }
            case "mblock_reimctlapply": {
                this.showMobList("er_reimctlapplybill", "bos_moblist", null, null);
                break;
            }
            case "mblock_prepaybill": {
                this.showMobList("er_prepaybill", "bos_moblist", null, null);
                break;
            }
            case "mblock_applypaybill": {
                MobileListShowParameter parameterp = new MobileListShowParameter();
                parameterp.setBillFormId("er_applypaybill");
                parameterp.setFormId("bos_moblist");
                parameterp.getOpenStyle().setShowType(ShowType.Floating);
                parameterp.setAppId(PUB_APP_ID);
                parameterp.setHasRight(true);
                this.getView().showForm((FormShowParameter)parameterp);
                break;
            }
            case "wf_mobile": {
                String clientFullContextPath = RequestContext.get().getClientFullContextPath();
                String suffixUrl = "mobile.html#/form/wf_mobilelist_mob";
                String url = clientFullContextPath + suffixUrl;
                HashMap<String, String> custom_param = new HashMap<String, String>();
                custom_param.put("url", url);
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("formType", "5");
                paramMap.put("formId", "er_wfmobilelist_mb");
                paramMap.put("customParam", custom_param);
                paramMap.put("needCallBack", Boolean.FALSE);
                paramMap.put("formName", ResManager.loadKDString((String)"\u5ba1\u6279\u5f85\u529e", (String)"ErMainPagePlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
                ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
                break;
            }
            case "mblock_dailyvehiclebil": {
                this.showMobList("er_dailyvehiclebill", "bos_moblist", null, null);
                break;
            }
            case "mblock_applyproject": {
                MobileListShowParameter parameter = new MobileListShowParameter();
                parameter.setBillFormId("er_applyprojectbill");
                parameter.setFormId("bos_moblist");
                parameter.getOpenStyle().setShowType(ShowType.Floating);
                parameter.setAppId(PUB_APP_ID);
                parameter.setHasRight(true);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "mblock_mealbill": {
                this.showMobList("er_mealapplication_bill", "bos_moblist", null, null);
                break;
            }
            case "mblock_contract": {
                MobileListShowParameter parameter = new MobileListShowParameter();
                parameter.setBillFormId("er_contractbill");
                parameter.setFormId("bos_moblist");
                parameter.getOpenStyle().setShowType(ShowType.Floating);
                parameter.setAppId(PUB_APP_ID);
                parameter.setHasRight(true);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
        }
    }

    private void showMobList(String billFormId, String formId, Map<String, Object> paraMap, String caption) {
        Set licenseModules;
        MobileListShowParameter showParameter = new MobileListShowParameter();
        showParameter.setBillFormId(billFormId);
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        String appid = IR_APP_ID;
        if ((billFormId.equals("er_prepaybill") || billFormId.equals("er_publicreimbursebill")) && CollectionUtils.isNotEmpty((Collection)(licenseModules = LicenseServiceHelper.getLicenseModules()))) {
            if (licenseModules.stream().anyMatch(IR_APP_ID::equalsIgnoreCase)) {
                appid = IR_APP_ID;
            }
            if (licenseModules.stream().anyMatch(PUB_APP_ID::equalsIgnoreCase)) {
                appid = PUB_APP_ID;
            }
        }
        showParameter.setAppId(appid);
        if (caption != null) {
            showParameter.setCaption(caption);
        }
        if (paraMap != null) {
            showParameter.setCustomParams(paraMap);
        }
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected void jumpToSelectPage(List rawInvoiceLst) {
        HashMap<String, List> customParam = new HashMap<String, List>();
        customParam.put("invoiceReimburse", rawInvoiceLst);
        FormModel formModel = new FormModel("er_reimtype_select", "", "5", true, customParam);
        logger.info("\u6253\u5f00\u201c\u9009\u62e9\u62a5\u9500\u7c7b\u578b\u201d\u754c\u9762");
        ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        this.initNotReimburse();
        String actionId = e.getActionId();
        if ("er_addNew_dialog_daily".equalsIgnoreCase(actionId)) {
            if (e.getReturnData() != null) {
                FormModel formModel = (FormModel)e.getReturnData();
                if (formModel == null) {
                    return;
                }
                String formId = formModel.getFormId();
                if (StringUtils.isEmpty((String)formId)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u656c\u8bf7\u671f\u5f85", (String)"ErMainPagePlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter formShowParameter = formModel.getFormShowParameter();
                Map params = formModel.getCustomParam();
                if (params != null && params.get("appId") != null) {
                    formShowParameter.setAppId((String)params.get("appId"));
                }
                if (formModel.getCallBack().booleanValue()) {
                    formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formModel.getFormId()));
                }
                this.getView().showForm(formShowParameter);
            }
        } else if ("expense_record".equalsIgnoreCase(actionId) || "expense_jcl".equalsIgnoreCase(actionId)) {
            OpenFormUtil.openMobileFormPage((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u6211\u7684\u8d39\u7528", (String)"ErMainPagePlugin_10", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)"er_expense_list_card_mb", (ShowType)ShowType.Floating, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "er_expense_list_card_mb11"));
        }
    }

    public void initNotReimburse() {
        Long currentUserID = CommonServiceHelper.getCurrentUserID();
        Map countMap = CommonServiceHelper.getNotReimburseCountUsedByEmPage((Long)CommonServiceHelper.getCurrentUserID());
        int tripNotReimburseCount = (Integer)countMap.get("tripNotReimburseCount");
        BigDecimal amount = CommonServiceHelper.getTripReimburseOutStandingAmount((Long)currentUserID);
        Label labelap_receivablev = (Label)this.getView().getControl("labelap_receivablev");
        BigDecimal notArrivedBankAmount = CommonServiceHelper.getReceivableInDailyReimburse((Long)currentUserID);
        DynamicObject currency = BaseCurrencyServiceHelper.getBaseCurrencyObject((Long)RequestContext.get().getOrgId());
        AmountFormatsUtil.setAmountLabel((Label)labelap_receivablev, (DynamicObject)currency, (BigDecimal)notArrivedBankAmount);
        if (tripNotReimburseCount == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_waiting"});
        }
        if (amount.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_oustangding"});
        }
        if (notArrivedBankAmount.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_receivable"});
        }
        if (tripNotReimburseCount == 0 && amount.compareTo(BigDecimal.ZERO) == 0 && notArrivedBankAmount.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flex_notreimburse"});
        }
    }
}

