/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.entryimport.datahandle;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.formplugin.entryimport.datahandle.AbstractEntryModelDataHandler;
import org.apache.commons.lang3.StringUtils;

public class ShareEntryImportDataHandler
extends AbstractEntryModelDataHandler {
    private static final Log logger = LogFactory.getLog(ShareEntryImportDataHandler.class);

    public ShareEntryImportDataHandler() {
        super("expenseentryentity_rule");
    }

    public void setEntryData(IDataModel model, IFormView view, IPageCache pageCache, Map<String, Object> returnData) {
        String sharemethod = "rate";
        Object imptMethod = returnData.get("imptmethod");
        if (imptMethod != null && "cover".equals(imptMethod)) {
            ArrayList<IDataEntityProperty> entries = new ArrayList<IDataEntityProperty>();
            entries.add(model.getProperty("expenseentryentity_rule"));
            for (IDataEntityProperty entry : entries) {
                if (entry == null) continue;
                model.deleteEntryData(entry.getName());
            }
        }
        List rowDatas = (List)returnData.get("rowDatas");
        ErCommonUtils.setIsBatchExcelImportExpenseEnry((IPageCache)pageCache, (boolean)true);
        StringBuilder errorInfo = new StringBuilder();
        model.beginInit();
        int[] rowIndex = model.batchCreateNewEntryRow("expenseentryentity_rule", rowDatas.size());
        model.endInit();
        ArrayList deleteRows = Lists.newArrayList();
        long[] expenseIds = null;
        String entityProp = "";
        entityProp = ErEntityTypeUtils.isShareBill((String)view.getEntityId()) ? "expenseentryentity_wait" : "expenseentryentity";
        DynamicObjectCollection expenEntrys = model.getDataEntity(true).getDynamicObjectCollection(entityProp);
        if (expenEntrys != null && expenEntrys.size() > 0) {
            expenseIds = ORM.create().genLongIds(view.getEntityId(), expenEntrys.size());
        }
        for (int rowNum = 0; rowNum < rowDatas.size(); ++rowNum) {
            Map row = (Map)rowDatas.get(rowNum);
            if (rowNum == rowDatas.size() - 1) {
                ErCommonUtils.setIsBatchExcelImportExpenseEnry((IPageCache)pageCache, (boolean)false);
            }
            try {
                for (String key : row.keySet()) {
                    this.setColumnData(row, rowIndex[rowNum], key, model, view, errorInfo);
                    String sharemethodStr = model.getValue("sharemethod").toString();
                    if (sharemethodStr != null) {
                        sharemethodStr = StringUtils.equals((CharSequence)sharemethodStr, (CharSequence)"avg") || StringUtils.equals((CharSequence)sharemethodStr, (CharSequence)ResManager.loadKDString((String)"\u91d1\u989d\u5e73\u5747", (String)"ShareEntryImportDataHandler_12", (String)"fi-er-formplugin", (Object[])new Object[0])) ? "avg" : (StringUtils.equals((CharSequence)sharemethodStr, (CharSequence)"amount") || StringUtils.equals((CharSequence)sharemethodStr, (CharSequence)ResManager.loadKDString((String)"\u91d1\u989d\u5206\u644a", (String)"ShareEntryImportDataHandler_19", (String)"fi-er-formplugin", (Object[])new Object[0])) ? "amount" : "rate");
                        sharemethod = sharemethodStr;
                    }
                    if (StringUtils.equals((CharSequence)sharemethod, (CharSequence)"avg")) {
                        model.beginInit();
                        model.setValue("sharerate_comrule", (Object)BigDecimal.ZERO, rowIndex[rowNum]);
                        model.endInit();
                    }
                    if (!StringUtils.equals((CharSequence)sharemethod, (CharSequence)"amount") || expenEntrys == null || expenEntrys.size() <= 0 || !StringUtils.equals((CharSequence)key, (CharSequence)"sharewaitseq_comrule")) continue;
                    int expenEntryIndex = Integer.parseInt((String)row.get(key)) - 1;
                    if (expenEntryIndex < 0 || expenEntryIndex >= expenEntrys.size()) {
                        errorInfo.append(ResManager.loadKDString((String)"\u7b2c", (String)"ShareEntryImportDataHandler_0", (String)"fi-er-formplugin", (Object[])new Object[0])).append((String)row.get("excelrow")).append(ResManager.loadKDString((String)"\u884c: ", (String)"ShareEntryImportDataHandler_9", (String)"fi-er-formplugin", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u5f85\u644a\u884c\u53f7\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002", (String)"ShareEntryImportDataHandler_20", (String)"fi-er-formplugin", (Object[])new Object[0])).append("\n");
                        deleteRows.add(rowIndex[rowNum]);
                        continue;
                    }
                    DynamicObject expenEntry = (DynamicObject)expenEntrys.get(expenEntryIndex);
                    int seq = expenEntry.getInt("seq");
                    Long entryId = (Long)expenEntry.getPkValue();
                    if (Objects.equals(entryId, 0L) && expenseIds != null && expenEntryIndex < expenseIds.length) {
                        entryId = expenseIds[expenEntryIndex];
                        expenEntry.set("id", (Object)entryId);
                    }
                    DynamicObject entryCurrency = ErEntityTypeUtils.isShareBill((String)view.getEntityId()) ? expenEntry.getDynamicObject("entrycurrency_wait") : expenEntry.getDynamicObject("entrycurrency");
                    model.beginInit();
                    model.setValue("sharewaitseq_comrule", (Object)seq, rowIndex[rowNum]);
                    model.setValue("sharewaitid_comrule", (Object)entryId, rowIndex[rowNum]);
                    model.setValue("sharecurrency_comrule", (Object)entryCurrency, rowIndex[rowNum]);
                    model.endInit();
                }
            }
            catch (Exception e) {
                errorInfo.append(ResManager.loadKDString((String)"\u7b2c", (String)"ShareEntryImportDataHandler_0", (String)"fi-er-formplugin", (Object[])new Object[0])).append((String)row.get("excelrow")).append(ResManager.loadKDString((String)"\u884c: ", (String)"ShareEntryImportDataHandler_9", (String)"fi-er-formplugin", (Object[])new Object[0])).append(e.getMessage() == null ? e.toString() : e.getMessage()).append("\n");
                logger.info("EntryImport >> \u6570\u636e\u5bfc\u5165\u5b58\u5728\u5f02\u5e38 >> ", (Object)e);
            }
            if (rowNum % 3 != 1) continue;
            view.getPageCache().put("task_percent", String.valueOf(((float)rowNum - 1.0f) / (float)rowDatas.size() * 100.0f).replaceAll("\\.[0-9]*", ""));
        }
        if (!"".equals(errorInfo.toString())) {
            view.getPageCache().put("task_error", errorInfo.toString());
        }
        if (!deleteRows.isEmpty()) {
            model.deleteEntryRows("expenseentryentity_rule", deleteRows.stream().mapToInt(i -> i).toArray());
            logger.info("EntryImport >> \u5220\u9664\u5f85\u644a\u884c\u53f7\u5f02\u5e38\u884c >> ");
        }
        ErCommonUtils.setIsBatchExcelImportExpenseEnry((IPageCache)pageCache, (boolean)false);
    }

    public void setColumnData(Map<String, String> row, int rowIndex, String key, IDataModel model, IFormView view, StringBuilder errorInfo) {
        String value = row.get(key);
        if (StringUtils.isEmpty((CharSequence)value) || key.contains(".name")) {
            return;
        }
        if (key.endsWith(".id")) {
            model.setValue(key.replace(".id", ""), (Object)value, rowIndex);
            return;
        }
        IDataEntityProperty property = model.getProperty(key = key.replace(".number", ""));
        if (property == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"sharemethod") || StringUtils.equals((CharSequence)key, (CharSequence)"sharewaitseq_comrule")) {
            return;
        }
        if (property instanceof TextAreaProp) {
            TextAreaProp text = (TextAreaProp)property;
            if (text.getMaxLenth() > 0 && value.length() > text.getMaxLenth()) {
                String tip = ResManager.loadKDString((String)"\u884c: \"%1$s\" \u5b57\u6bb5\u6570\u636e\u8d85\u51fa\u6700\u5927\u9650\u5236, \u5df2\u622a\u53d6\u6709\u6548\u90e8\u5206\u3002", (String)"AbstractEntryModelDataHandler_11", (String)"fi-er-formplugin", (Object[])new Object[0]);
                errorInfo.append(ResManager.loadKDString((String)"\u7b2c", (String)"AbstractEntryModelDataHandler_0", (String)"fi-er-formplugin", (Object[])new Object[0])).append(row.get("excelrow")).append(String.format(tip, property.getDisplayName().getLocaleValue())).append("\n");
                value = value.substring(0, text.getMaxLenth());
            }
            model.setValue(key, (Object)value, rowIndex);
        } else if (property instanceof ItemClassProp) {
            DynamicObject classItemBaseDataDym;
            ItemClassProp itemClassProp = (ItemClassProp)property;
            String typePropName = itemClassProp.getTypePropName();
            String dataType = row.get(typePropName);
            String dataTypeNumber = "";
            ItemClassTypeProp typeProp = (ItemClassTypeProp)model.getProperty(typePropName);
            List comboItems = typeProp.getComboItems();
            for (ValueMapItem item : comboItems) {
                if (!StringUtils.equals((CharSequence)dataType, (CharSequence)item.getName().getLocaleValue())) continue;
                dataTypeNumber = item.getValue();
                model.setValue(typePropName, (Object)item.getValue(), rowIndex);
                break;
            }
            String numberProperty = "number";
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)dataTypeNumber);
            if (dataEntityType instanceof BasedataEntityType) {
                numberProperty = ((BasedataEntityType)dataEntityType).getNumberProperty();
            }
            if ((classItemBaseDataDym = BusinessDataServiceHelper.loadSingleFromCache((String)dataTypeNumber, (String)"id", (QFilter[])new QFilter(numberProperty, "=", (Object)value).toArray())) != null) {
                model.setValue(key, classItemBaseDataDym.get("id"), rowIndex);
            } else {
                model.setItemValueByNumber(key, value, rowIndex);
            }
        } else if (property instanceof BasedataProp || property instanceof CurrencyProp) {
            BasedataProp baseProp = (BasedataProp)property;
            DynamicObject basedataDOFromCache = BusinessDataServiceHelper.loadSingleFromCache((String)baseProp.getBaseEntityId(), (String)"id", (QFilter[])new QFilter[]{QFilter.of((String)"number=?", (Object[])new Object[]{value})});
            if (basedataDOFromCache != null) {
                model.setValue(key, basedataDOFromCache.get("id"), rowIndex);
            } else {
                model.setItemValueByNumber(key, value, rowIndex);
            }
        } else if (property instanceof BooleanProp) {
            if ("\u662f".equals(value)) {
                model.setValue(key, (Object)Boolean.TRUE, rowIndex);
            } else {
                model.setValue(key, (Object)Boolean.FALSE, rowIndex);
            }
        } else if (property instanceof ComboProp) {
            ComboEdit type = (ComboEdit)view.getControl(key);
            ComboProp itemProp = (ComboProp)type.getProperty();
            List comboItems = itemProp.getComboItems();
            for (ValueMapItem item : comboItems) {
                if (!StringUtils.equals((CharSequence)value, (CharSequence)item.getName().getLocaleValue())) continue;
                model.setValue(key, (Object)item.getValue(), rowIndex);
                return;
            }
        } else if (property instanceof AmountProp || property instanceof DecimalProp) {
            BigDecimal amount = new BigDecimal(value);
            model.setValue(key, (Object)amount, rowIndex);
        } else if (property instanceof TextProp) {
            TextProp text = (TextProp)property;
            if (text.getMaxLenth() > 0 && value.length() > text.getMaxLenth()) {
                String tip = ResManager.loadKDString((String)"\u884c: \"%1$s\" \u5b57\u6bb5\u6570\u636e\u8d85\u51fa\u6700\u5927\u9650\u5236, \u5df2\u622a\u53d6\u6709\u6548\u90e8\u5206\u3002", (String)"AbstractEntryModelDataHandler_11", (String)"fi-er-formplugin", (Object[])new Object[0]);
                errorInfo.append(ResManager.loadKDString((String)"\u7b2c", (String)"AbstractEntryModelDataHandler_0", (String)"fi-er-formplugin", (Object[])new Object[0])).append(row.get("excelrow")).append(String.format(tip, property.getDisplayName().getLocaleValue())).append("\n");
                value = value.substring(0, text.getMaxLenth());
            }
            model.setValue(key, (Object)value, rowIndex);
        } else {
            model.setValue(key, (Object)value, rowIndex);
        }
    }
}

