/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.trip.dailybiz;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripBusinessRelatDailyBusinessUtil;
import kd.fi.er.business.trip.dailybiz.TripNotReimbursedOrderUtil;
import kd.fi.er.business.trip.dailybiz.TripReimCreateOrderEntrysUtil;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang.StringUtils;

public class TripReimBillUpOrdersPlugin
extends AbstractBillPlugIn {
    private static Log logger = LogFactory.getLog(TripReimBillUpOrdersPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"trip2advtoolbar"});
        this.addClickListeners(new String[]{"chooseorder"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("chooseorder".equals(key)) {
            this.openChooseOrder();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("chooseorder".equals(key)) {
            this.openChooseOrder();
        }
    }

    protected void openChooseOrder() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(this.getFormId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, showParameter.getFormId()));
        Map customParam = showParameter.getCustomParams();
        customParam.put("existOrderNums", this.getExistOrderNums());
        customParam.put("applier", ErCommonUtils.getPk((Object)this.getModel().getValue("applier")));
        customParam.put("creator", ErCommonUtils.getPk((Object)this.getModel().getValue("creator")));
        customParam.put("tripUsers", this.getTripUsers());
        Object value = ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)this.getModel().getValue("company")), (String)"onlychoosetriporder");
        customParam.put("reqbillIds", this.getReqbillIds(value));
        customParam.put("onlychoosetriporder", value);
        customParam.put("companyId", ErCommonUtils.getPk((Object)this.getModel().getValue("company")));
        logger.info("Line 99 customParam{}", (Object)customParam);
        this.getView().showForm(showParameter);
    }

    protected String getFormId() {
        return "er_travel_up_order";
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (this.getFormId().equals(closedCallBackEvent.getActionId())) {
            Map map = (Map)closedCallBackEvent.getReturnData();
            if (map == null || map.size() == 0) {
                return;
            }
            List list = (List)map.get("entryentity");
            Long companyId = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
            companyId = companyId == null ? Long.valueOf(0L) : companyId;
            Set ordernums = list.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            List orders = TripNotReimbursedOrderUtil.queryNotReimbursedOrdersByOrderId(ordernums, (Long)companyId, (Boolean)true);
            if (orders.size() == 0) {
                return;
            }
            boolean isShowInvoiceEntry = SystemParamterUtil.getIsShowInvoiceEntry((long)companyId);
            HashSet travelerIdSet = new HashSet(4);
            orders.stream().forEach(tripOrder -> {
                Long sourcetravelerId = TripBusinessRelatDailyBusinessUtil.getOrderTravelerId((DynamicObject)tripOrder);
                travelerIdSet.add(sourcetravelerId);
            });
            DynamicObject dynamicObject = this.getModel().getDataEntity(true);
            int tripIndex = this.getModel().getEntryCurrentRowIndex("tripentry");
            int entryIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject tripentry = (DynamicObject)dynamicObject.getDynamicObjectCollection("tripentry").get(tripIndex);
            String formId = this.getView().getFormShowParameter().getFormId();
            TripReimCreateOrderEntrysUtil.initOrderEntrys((DynamicObject)dynamicObject, (DynamicObject)tripentry, travelerIdSet, (List)orders, (boolean)isShowInvoiceEntry, (boolean)true, null, null, (String)formId, null);
            this.getModel().updateCache();
            DynamicObjectCollection collection = tripentry.getDynamicObjectCollection("entryentity");
            this.sortEntryEntity(orders, entryIndex, collection);
            CoreBaseBillServiceHelper.refreshEntryRowSeq((IDataModel)this.getModel(), (boolean)false, (int)tripIndex);
            for (int i = 0; i < collection.size(); ++i) {
                Object val;
                if (!((DynamicObject)collection.get(i)).getBoolean("pulltravelorder") || (val = this.getModel().getValue("trip2travelers", i, tripIndex)) == null || ((DynamicObjectCollection)val).size() == 0) continue;
                Object[] olds = ((DynamicObjectCollection)val).stream().map(e -> e.get("fbasedataid_id")).collect(Collectors.toList()).toArray(new Object[0]);
                Object[] objects = new Object[]{1};
                try {
                    this.getModel().beginInit();
                    this.getModel().setValue("trip2travelers", (Object)objects, i, tripIndex);
                    this.getModel().endInit();
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                this.getModel().setValue("trip2travelers", (Object)olds, i, tripIndex);
            }
            AmountChangeUtil.updateTripEntryTitleAmountLabel((IFormView)this.getView(), (IDataModel)this.getModel());
            AmountChangeUtil.updateTripEntryAndHeadAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (int)tripIndex);
            this.getView().updateView("entryentity");
            this.getView().updateView("invoiceentry");
            this.getView().updateView("invoiceoffsetamount");
        }
    }

    private void sortEntryEntity(List<DynamicObject> orders, int entryIndex, DynamicObjectCollection collection) {
        collection.sort((a, b) -> {
            String bSettlement;
            String aSettlement = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)a.getString("settlementtype"), (CharSequence)"1");
            if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)aSettlement, (CharSequence)(bSettlement = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)b.getString("settlementtype"), (CharSequence)"1"))) && org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)aSettlement, (CharSequence)"2")) {
                String aOrderFormId = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)a.getString("orderformid"), (CharSequence)"");
                String bOrderFormId = (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)b.getString("orderformid"), (CharSequence)"");
                return aOrderFormId.compareTo(bOrderFormId);
            }
            if (aSettlement.equalsIgnoreCase("2")) {
                return -1;
            }
            if (bSettlement.equalsIgnoreCase("2")) {
                return 1;
            }
            return aSettlement.compareTo(bSettlement);
        });
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject entry = (DynamicObject)collection.get(i);
            entry.set("seq", (Object)(i + 1));
        }
    }

    protected Set<String> getExistOrderNums() {
        HashSet<String> ordernums = new HashSet<String>(12);
        this.getEntryOrderNums(this.getView(), ordernums);
        return ordernums;
    }

    private List<Long> getTripUsers() {
        DynamicObjectCollection tripEntryCollction = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        if (tripEntryCollction == null || tripEntryCollction.size() == 0) {
            return new ArrayList<Long>();
        }
        if ("1".equals(this.getModel().getValue("billkind"))) {
            ArrayList<Long> list = new ArrayList<Long>(1);
            Long applierId = ErCommonUtils.getPk((Object)this.getModel().getValue("applier"));
            if (applierId != null) {
                list.add(applierId);
            }
            return list;
        }
        DynamicObject tripEntry = (DynamicObject)tripEntryCollction.get(this.getModel().getEntryCurrentRowIndex("tripentry"));
        DynamicObjectCollection travels = tripEntry.getDynamicObjectCollection("travelers");
        if (travels != null) {
            return travels.stream().map(e -> ErCommonUtils.getPk((Object)e.get("fbasedataid_id"))).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    protected Set<Long> getReqbillIds(Object value) {
        HashSet<Long> reqbillIds = new HashSet<Long>(2);
        if ("1".equals(value)) {
            this.getModel().getEntryEntity("writeoffapply").forEach(e -> e.getDynamicObjectCollection("writeoffapply_lk").forEach(m -> reqbillIds.add(m.getLong("writeoffapply_lk_sbillid"))));
        }
        return reqbillIds;
    }

    protected void getEntryOrderNums(IFormView view, Set<String> ordernums) {
        DynamicObjectCollection tripEntryCollction = view.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry");
        tripEntryCollction.stream().forEach(m -> m.getDynamicObjectCollection("entryentity").stream().forEach(n -> {
            if (StringUtils.isNotBlank((String)n.getString("ordernum"))) {
                ordernums.add(n.getString("ordernum"));
            }
        }));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int ordertripreimburse = SystemParamterUtil.getcheckparamDefaute((long)ErCommonUtils.getPk((Object)this.getModel().getValue("company")), (String)"ordertripreimburse");
        int carordertripreimburse = SystemParamterUtil.getcheckparamDefaute((long)ErCommonUtils.getPk((Object)this.getModel().getValue("company")), (String)"carordertripreimburse");
        int mealOrderTripReimburse = SystemParamterUtil.getcheckparamDefaute((long)ErCommonUtils.getPk((Object)this.getModel().getValue("company")), (String)"mealordertripreimburse");
        String appId = this.getView().getFormShowParameter().getAppId();
        int showpullorder = 0;
        if ((ordertripreimburse == 1 || carordertripreimburse == 1) && ("ssc".equals(appId) && "task_approve".equals(this.getView().getFormShowParameter().getParentFormId()) || "wf_approvalpage_bac".equals(this.getView().getFormShowParameter().getParentFormId()))) {
            ErCommonUtils.setValueWithoutDBField((IDataModel)this.getModel(), (String)"showpullorder", (Object)2);
            showpullorder = 2;
        } else if (ordertripreimburse == 1 || carordertripreimburse == 1 || mealOrderTripReimburse == 1) {
            ErCommonUtils.setValueWithoutDBField((IDataModel)this.getModel(), (String)"showpullorder", (Object)1);
            showpullorder = 1;
        }
        if (showpullorder == 1 && !Arrays.asList("A", "D").contains(this.getModel().getValue("billstatus")) || showpullorder == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"chooseorder", "btn_chooseorder"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult or = afterDoOperationEventArgs.getOperationResult();
        if (or != null && !or.isSuccess()) {
            return;
        }
        if (Arrays.asList("A", "D").contains(this.getModel().getValue("billstatus"))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"chooseorder", "btn_chooseorder"});
        } else if ("submit".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"chooseorder", "btn_chooseorder"});
        }
    }
}

