/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web;

import java.lang.constant.Constable;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ChooseExpenseItem
extends AbstractBasePlugIn
implements RowClickEventListener {
    public void initialize() {
        super.initialize();
        AbstractGrid entryentity = (AbstractGrid)this.getControl("entryentity");
        entryentity.addRowClickListener((RowClickEventListener)this);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String formId = (String)customParams.get("formid");
        if (formId == null) {
            return;
        }
        QFilter qC = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter bdFilter = null;
        Object companyId = customParams.get("companyid");
        if (companyId == null) {
            LogFactory.getLog(ChooseExpenseItem.class).info(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u516c\u53f8ID\u3002", (String)"ChooseExpenseItem_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        } else if (companyId instanceof Integer) {
            Integer compId = (Integer)companyId;
            bdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripexpenseitem", (Long)compId.longValue());
        } else if (companyId instanceof Long) {
            bdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_tripexpenseitem", (Long)((Long)companyId));
        }
        QFilter[] qFilters = new QFilter[]{qC, bdFilter};
        String selectExpensePros = "id,number,longnumber,expenseitemicon,isdefault,isvactax";
        DynamicObject[] tripExpenseitems = BusinessDataServiceHelper.load((String)"er_tripexpenseitem", (String)selectExpensePros, (QFilter[])qFilters);
        Map<Object, DynamicObject> tripExpenseitem = Arrays.stream(tripExpenseitems).collect(Collectors.toMap(DataEntityBase::getPkValue, dynamicObject -> dynamicObject));
        Set<Map.Entry<Object, DynamicObject>> tripExpenseitemEntries = tripExpenseitem.entrySet();
        DynamicObject chooseExpenseitem = BusinessDataServiceHelper.newDynamicObject((String)"er_chooseexpenseitem");
        DynamicObjectCollection entry = chooseExpenseitem.getDynamicObjectCollection("entryentity");
        for (Map.Entry<Object, DynamicObject> tripExpenseitemEntrie : tripExpenseitemEntries) {
            DynamicObject tripExpenseitemObj = tripExpenseitemEntrie.getValue();
            DynamicObject entryObj = entry.addNew();
            entryObj.set("expenseitem", (Object)tripExpenseitemObj);
            entryObj.set("expenseitem_Id", tripExpenseitemObj.get("id"));
            String expenseitemicon = (String)tripExpenseitemObj.get("expenseitemicon");
            if (StringUtils.isNotBlank((CharSequence)expenseitemicon) && expenseitemicon.startsWith("/")) {
                String server = RequestContext.get().getClientFullContextPath();
                server = server.substring(0, server.length() - 1);
                expenseitemicon = server + expenseitemicon;
            }
            entryObj.set("expenseitempic", (Object)expenseitemicon);
        }
        e.setDataEntity((Object)chooseExpenseitem);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void entryRowClick(RowClickEvent rowClickEvent) {
        int rowIndex = rowClickEvent.getRow();
        if (rowIndex < 0) {
            return;
        }
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        DynamicObject entryRow = (DynamicObject)entry.get(rowIndex);
        Long expenseItemId = entryRow.getLong("expenseitem_id");
        Boolean isvactax = entryRow.getBoolean("isvactax");
        HashMap<String, Constable> returnMap = new HashMap<String, Constable>();
        returnMap.put("tripexpenseId", expenseItemId);
        returnMap.put("isvactax", isvactax);
        this.getView().returnDataToParent(returnMap);
        this.getView().close();
    }

    public void entryRowDoubleClick(RowClickEvent rowClickEvent) {
    }
}

