/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.fileservice;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.isc.IscHelper;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ErFileUtils {
    private static final Log logger = LogFactory.getLog(ErFileUtils.class);

    public static InputStream checkFileExists(String path) {
        InputStream inputStream = IscHelper.class.getClassLoader().getResourceAsStream(path);
        if (inputStream == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u6216\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\u3002", (String)"IscHelper_3", (String)"fi-er-business", (Object[])new Object[0]));
        }
        return inputStream;
    }

    public static void impoortDTSFile(String jsonuri) throws IOException {
        String reportContentPath = "classpath:/" + jsonuri + "/";
        String dtsFilePattern = "*.dts";
        String dataTriggerPath = "dataTrigger/" + dtsFilePattern;
        String serviceFlowPath = "serviceFlow/" + dtsFilePattern;
        IscHelper.readDts(new PathMatchingResourcePatternResolver().getResources(reportContentPath + dataTriggerPath));
        IscHelper.readDts(new PathMatchingResourcePatternResolver().getResources(reportContentPath + serviceFlowPath));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFile(InputStream inputStream) {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
            int available = bufferedInputStream.available();
            byte[] bytes = new byte[available];
            bufferedInputStream.read(bytes);
            String string = new String(bytes, StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            logger.error("kd.fi.er.business.isc.IscHelper.readFile>>>\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25:", (Throwable)e);
            return "";
        }
    }
}

