/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.invoicecloud.model.InvoiceTypeModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class InvoiceTypeUtils {
    private static String ER_INVOICE_TYPE = "er_invoicetype";

    public static Set<String> loadEInvoiceTypes() {
        QFilter filter = QFilter.of((String)"enable='1' and iseinvoice='1'", (Object[])new Object[0]);
        DynamicObjectCollection data = QueryServiceHelper.query((String)ER_INVOICE_TYPE, (String)"number", (QFilter[])filter.toArray());
        Set<String> set = data.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
        return set;
    }

    public static DynamicObjectCollection loadInvoiceTypes(QFilter[] filters) {
        DynamicObjectCollection load = QueryServiceHelper.query((String)ER_INVOICE_TYPE, (String)"number,name", (QFilter[])filters);
        return load;
    }

    public static Set<String> loadSpecialInvoiceTypes() {
        QFilter filter = QFilter.of((String)"enable='1' and isspecialinvoice='1'", (Object[])new Object[0]);
        DynamicObjectCollection data = QueryServiceHelper.query((String)ER_INVOICE_TYPE, (String)"number", (QFilter[])filter.toArray());
        Set<String> set = data.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
        return set;
    }

    public static Set<Long> loadSpecialInvoiceIds() {
        QFilter filter = QFilter.of((String)"enable='1' and isspecialinvoice='1'", (Object[])new Object[0]);
        DynamicObjectCollection data = QueryServiceHelper.query((String)ER_INVOICE_TYPE, (String)"id", (QFilter[])filter.toArray());
        Set<Long> set = data.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        return set;
    }

    public static Set<String> loadVehicleInvoiceTypes() {
        return InvoiceTypeUtils.loadInvoiceTypes("istransportinvoice");
    }

    public static Set<String> loadVatInvoiceTypes() {
        return InvoiceTypeUtils.loadInvoiceTypes("isvatinvoice");
    }

    private static Set<String> loadInvoiceTypes(String field) {
        QFilter filter = QFilter.of((String)String.format("enable='1' and %s='1'", field), (Object[])new Object[0]);
        Map invoiceTypeMap = BusinessDataServiceHelper.loadFromCache((String)ER_INVOICE_TYPE, (String)"number", (QFilter[])filter.toArray());
        if (invoiceTypeMap.isEmpty()) {
            return Collections.emptySet();
        }
        Collection invoiceTypeCol = invoiceTypeMap.values();
        if (invoiceTypeCol.isEmpty()) {
            return Collections.emptySet();
        }
        Set<String> set = invoiceTypeCol.stream().map(e -> e.getString("number")).collect(Collectors.toSet());
        return set;
    }

    public static List<InvoiceTypeModel> loadInvoiceModels() {
        return InvoiceTypeUtils.loadInvoiceModels("");
    }

    public static InvoiceTypeModel loadInvoiceModel(String invoiceTypeNumber) {
        DynamicObjectCollection invoices;
        List<InvoiceTypeModel> invoiceTypeModels;
        QFilter[] qFilters = new QFilter[]{};
        if (StringUtils.isNotEmpty((String)invoiceTypeNumber)) {
            QFilter filter = QFilter.of((String)String.format("enable='1' and number= '%s'", invoiceTypeNumber), (Object[])new Object[0]);
            qFilters = new QFilter[]{filter};
        }
        InvoiceTypeModel invoiceTypeModel = CollectionUtils.isEmpty(invoiceTypeModels = InvoiceTypeUtils.buildInvoiceTypeModel(invoices = QueryServiceHelper.query((String)ER_INVOICE_TYPE, (String)"id,number,name,isvatinvoice,isspecialinvoice,iseinvoice,istransportinvoice,isproforma", (QFilter[])qFilters))) ? InvoiceTypeUtils.loadOtherInvoiceModel() : invoiceTypeModels.get(0);
        return invoiceTypeModel;
    }

    public static InvoiceTypeModel loadOtherInvoiceModel() {
        QFilter filter = QFilter.of((String)String.format("enable='1' and number= '%s'", "11"), (Object[])new Object[0]);
        QFilter[] qFilters = new QFilter[]{filter};
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)ER_INVOICE_TYPE, (String)"id,number,name,isvatinvoice,isspecialinvoice,iseinvoice,istransportinvoice,isproforma", (QFilter[])qFilters);
        List<InvoiceTypeModel> invoiceTypeModels = InvoiceTypeUtils.buildInvoiceTypeModel(invoices);
        if (CollectionUtils.isNotEmpty(invoiceTypeModels)) {
            return invoiceTypeModels.get(0);
        }
        return new InvoiceTypeModel();
    }

    public static List<InvoiceTypeModel> loadInvoiceModels(String invoiceTypeNumber) {
        QFilter[] qFilters = new QFilter[]{};
        if (StringUtils.isNotEmpty((String)invoiceTypeNumber)) {
            QFilter filter = QFilter.of((String)String.format("enable='1' and number= '%s'", invoiceTypeNumber), (Object[])new Object[0]);
            qFilters = new QFilter[]{filter};
        }
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)ER_INVOICE_TYPE, (String)"id,number,name,isvatinvoice,isspecialinvoice,iseinvoice,istransportinvoice,isproforma", (QFilter[])qFilters);
        List<InvoiceTypeModel> invoiceTypeModels = InvoiceTypeUtils.buildInvoiceTypeModel(invoices);
        return invoiceTypeModels;
    }

    private static List<InvoiceTypeModel> buildInvoiceTypeModel(DynamicObjectCollection invoiceDOCollection) {
        ArrayList<InvoiceTypeModel> invoiceTypeModels = new ArrayList<InvoiceTypeModel>(invoiceDOCollection.size());
        for (DynamicObject dynamicObject : invoiceDOCollection) {
            InvoiceTypeModel model = new InvoiceTypeModel();
            model.setId(Long.valueOf(dynamicObject.getLong("id")));
            model.setNumber(dynamicObject.getString("number"));
            model.setVatInvoice(dynamicObject.getBoolean("isvatinvoice"));
            model.setSpecialInvoice(dynamicObject.getBoolean("isspecialinvoice"));
            model.setEInvoice(dynamicObject.getBoolean("iseinvoice"));
            model.setTransportInvoice(dynamicObject.getBoolean("istransportinvoice"));
            model.setProforma(dynamicObject.getBoolean("isproforma"));
            invoiceTypeModels.add(model);
        }
        return invoiceTypeModels;
    }
}

