/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.provider.param.AfterDataModelProxy;
import kd.fi.er.business.invoicecloud.provider.param.DataModelProxy;
import kd.fi.er.business.invoicecloud.provider.param.InvoiceContextProxy;
import kd.fi.er.business.invoicecloud.provider.service.IAfterCreateExpenseItemEntryService;
import kd.fi.er.business.invoicecloud.provider.service.IBeforeCreateExpenseItemEntryService;
import kd.fi.er.business.invoicecloud.provider.service.factory.InvoiceServiceFactory;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.AbstractInvoiceService;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.invoice.utils.InvoiceUtils2;
import kd.fi.er.common.model.invoice.bo.ExpenseEntryBO;
import org.apache.commons.lang3.StringUtils;

public abstract class CreateEntryService
extends AbstractInvoiceService {
    private static final Log log = LogFactory.getLog(CreateEntryService.class);
    protected IDataModel dataModel;
    protected boolean isOrgOffset;
    protected DynamicObject curSelectedItem = null;

    public CreateEntryService(InvoiceContext invoiceContext) {
        super(invoiceContext);
        this.dataModel = invoiceContext.getExtView().getModel();
        this.isOrgOffset = invoiceContext.getInvoiceConfig().isOrgOffset();
    }

    protected void initRelation() {
        InvoiceUtils2.clearCacheRelation();
    }

    public void process() {
    }

    protected final void genExpenseItemEntry(InvoiceContext invoiceContext, ExpenseEntryBO expenseEntryBO, int rowIndex, int parentIndex) {
        this.executeBeforeCreateExpenseEntry(invoiceContext, expenseEntryBO, rowIndex, parentIndex);
        this.createExpenseItemEntry(expenseEntryBO, rowIndex, parentIndex);
        this.executeAfterCreateExpenseEntry(invoiceContext, expenseEntryBO, rowIndex, parentIndex);
    }

    protected void createExpenseItemEntry(ExpenseEntryBO expenseEntryBO, int rowIndex, int parentIndex) {
    }

    public DynamicObject getCurSelectedItem() {
        return this.curSelectedItem;
    }

    public void setCurSelectedItem(DynamicObject curSelectedItem) {
        this.curSelectedItem = curSelectedItem;
    }

    private final void executeBeforeCreateExpenseEntry(InvoiceContext invoiceContext, ExpenseEntryBO expenseEntryBO, int rowIndex, int parentIndex) {
        try {
            IBeforeCreateExpenseItemEntryService beforeCreateExpenseService = (IBeforeCreateExpenseItemEntryService)InvoiceServiceFactory.getSingletonService(IBeforeCreateExpenseItemEntryService.class);
            if (beforeCreateExpenseService == null) {
                return;
            }
            IFormView view = invoiceContext.getView();
            InvoiceContextProxy contextProxy = new InvoiceContextProxy(invoiceContext);
            DataModelProxy modelProxy = new DataModelProxy(this.dataModel);
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u8d39\u7528\u660e\u7ec6\u751f\u6210\u524d\u7f6e\u670d\u52a1\u524dExpenseEntryBO:" + expenseEntryBO);
            if (this.isTripBill(view)) {
                DynamicObject tripEntry = this.getTripEntryDynamicObject(parentIndex);
                beforeCreateExpenseService.beforeCreateExpenseItemEntryForTrip(contextProxy, modelProxy, tripEntry, expenseEntryBO, rowIndex, parentIndex);
            } else if (this.isPublicBill(view) || this.isDailyBill(view)) {
                beforeCreateExpenseService.beforeCreateExpenseItemEntry(contextProxy, modelProxy, expenseEntryBO, rowIndex);
            } else if (this.isPool(view)) {
                beforeCreateExpenseService.beforeCreateExpenseItemEntryForExpensePool(contextProxy, modelProxy, expenseEntryBO);
            }
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u8d39\u7528\u660e\u7ec6\u751f\u6210\u524d\u7f6e\u670d\u52a1\u540eExpenseEntryBO:" + expenseEntryBO);
        }
        catch (Exception e) {
            log.error("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u7b2c\u4e09\u65b9\u660e\u7ec6\u751f\u6210\u524d\u7f6e\u670d\u52a1\u5f02\u5e38:", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private final void executeAfterCreateExpenseEntry(InvoiceContext invoiceContext, ExpenseEntryBO expenseEntryBO, int rowIndex, int parentIndex) {
        try {
            IAfterCreateExpenseItemEntryService afterCreateExpenseEntry = (IAfterCreateExpenseItemEntryService)InvoiceServiceFactory.getSingletonService(IAfterCreateExpenseItemEntryService.class);
            if (afterCreateExpenseEntry == null) {
                return;
            }
            IFormView view = invoiceContext.getView();
            InvoiceContextProxy contextProxy = new InvoiceContextProxy(invoiceContext);
            AfterDataModelProxy dataModelProxy = new AfterDataModelProxy(this.dataModel);
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u8d39\u7528\u660e\u7ec6\u751f\u6210\u540e\u7f6e\u670d\u52a1\u524dExpenseEntryBO:" + expenseEntryBO);
            if (this.isTripBill(view)) {
                DynamicObject tripEntry = this.getTripEntryDynamicObject(parentIndex);
                afterCreateExpenseEntry.afterCreateExpenseItemEntryForTrip(contextProxy, dataModelProxy, tripEntry, expenseEntryBO, rowIndex, parentIndex);
            } else if (this.isPublicBill(view) || this.isDailyBill(view)) {
                afterCreateExpenseEntry.afterCreateExpenseItemEntry(contextProxy, dataModelProxy, expenseEntryBO, rowIndex);
            } else if (this.isPool(view)) {
                afterCreateExpenseEntry.afterCreateExpenseItemEntryForExpensePool(contextProxy, dataModelProxy, expenseEntryBO);
            }
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u8d39\u7528\u660e\u7ec6\u751f\u6210\u540e\u7f6e\u670d\u52a1\u540eExpenseEntryBO:" + expenseEntryBO);
        }
        catch (Exception e) {
            log.error("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u7b2c\u4e09\u65b9\u660e\u7ec6\u751f\u6210\u540e\u7f6e\u670d\u52a1\u5f02\u5e38:", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private boolean isTripBill(IFormView view) {
        String entityId = view.getEntityId();
        String parentEntityId = "";
        IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        if (parentView != null) {
            parentEntityId = parentView.getEntityId();
        }
        return ErEntityTypeUtils.isTripReimburseBill((String)entityId) || ErEntityTypeUtils.isTripReimburseBill((String)parentEntityId);
    }

    private boolean isPublicBill(IFormView view) {
        String entityId = view.getEntityId();
        String parentEntityId = "";
        IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        if (parentView != null) {
            parentEntityId = parentView.getEntityId();
        }
        return ErEntityTypeUtils.isPublicReimburseBill((String)entityId) || ErEntityTypeUtils.isPublicReimburseBill((String)parentEntityId);
    }

    private boolean isDailyBill(IFormView view) {
        String entityId = view.getEntityId();
        String parentEntityId = "";
        IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        if (parentView != null) {
            parentEntityId = parentView.getEntityId();
        }
        return ErEntityTypeUtils.isDailyReimburseBill((String)entityId) || ErEntityTypeUtils.isDailyReimburseBill((String)parentEntityId);
    }

    private boolean isPool(IFormView view) {
        String entityId = view.getEntityId();
        String parentEntityId = "";
        IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        if (parentView != null) {
            parentEntityId = parentView.getEntityId();
        }
        return ErEntityTypeUtils.isTripRecordBill((String)entityId) || ErEntityTypeUtils.isExpenseRecordBill((String)entityId) || ErEntityTypeUtils.isTripRecordBill((String)parentEntityId) || ErEntityTypeUtils.isExpenseRecordBill((String)parentEntityId);
    }

    private DynamicObject getTripEntryDynamicObject(int tripIndex) {
        IFormView parentView;
        IFormView view = this.invoiceContext.getView();
        IDataModel dataModel = view.getModel();
        if (dataModel.getProperty("tripentry") == null) {
            dataModel = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId()).getModel();
        }
        if (dataModel != null && dataModel.getProperty("tripentry") == null && (parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId())) != null) {
            dataModel = parentView.getViewNoPlugin(parentView.getFormShowParameter().getParentPageId()).getModel();
        }
        if (dataModel == null || dataModel.getProperty("tripentry") == null) {
            return null;
        }
        if (tripIndex != -1) {
            return (DynamicObject)dataModel.getEntryEntity("tripentry").get(tripIndex);
        }
        int currentRowIndex = dataModel.getEntryCurrentRowIndex("tripentry");
        return (DynamicObject)dataModel.getEntryEntity("tripentry").get(currentRowIndex);
    }

    Set getSeatGradle(ExpenseEntryBO expenseEntryBO, DynamicObject expenseItemDO, RefObject<String> attrRef) {
        String attribute = "";
        if (expenseItemDO != null) {
            attribute = expenseItemDO.getString("attribute");
        }
        Set seatGrade = new HashSet(16);
        Map seatGradeBO = expenseEntryBO.getSeatGrades();
        if (seatGradeBO == null) {
            return seatGrade;
        }
        if (StringUtils.equals((CharSequence)attribute, (CharSequence)"2")) {
            seatGrade = (Set)seatGradeBO.get("2");
        } else if (StringUtils.equals((CharSequence)attribute, (CharSequence)"4")) {
            seatGrade = (Set)seatGradeBO.get("4");
        } else if (StringUtils.equals((CharSequence)attribute, (CharSequence)"7")) {
            seatGrade = (Set)seatGradeBO.get("7");
        } else {
            List list = seatGradeBO.values().stream().filter(m -> m.size() > 0).collect(Collectors.toList());
            if (list.size() > 1) {
                log.info("\u5b58\u5728\u4e0d\u540c\u7c7b\u578b\u4ea4\u901a\u5de5\u5177\u7684\u5ea7\u4f4d\u7b49\u7ea7\uff0c\u5ea7\u4f4d\u7b49\u7ea7\u5b57\u6bb5\u4e0d\u8d4b\u503c");
            } else if (list.size() == 1) {
                seatGrade = (Set)list.get(0);
                attribute = (String)seatGradeBO.entrySet().stream().filter(m -> ((Set)m.getValue()).size() > 0).findFirst().get().getKey();
            }
        }
        attrRef.setValue((Object)attribute);
        return seatGrade;
    }

    public void setValueIfExist(String name, Object value, int rowIndex, int parentIndex) {
        if (this.dataModel.getProperty(name) != null) {
            this.dataModel.setValue(name, value, rowIndex, parentIndex);
        }
    }

    public void setValueIfExist(String name, Object value, int rowIndex) {
        if (this.dataModel.getProperty(name) != null) {
            this.dataModel.setValue(name, value, rowIndex);
        }
    }

    public void setValueIfExist(String name, Object value) {
        if (this.dataModel.getProperty(name) != null) {
            this.dataModel.setValue(name, value);
        }
    }

    public Object getValueIfExist(String name) {
        if (this.dataModel.getProperty(name) != null) {
            return this.dataModel.getValue(name);
        }
        return null;
    }

    public Object getValueIfExist(String name, int rowIndex) {
        if (this.dataModel.getProperty(name) != null) {
            return this.dataModel.getValue(name, rowIndex);
        }
        return null;
    }

    public Object getValueIfExist(String name, int rowIndex, int parentIndex) {
        if (this.dataModel.getProperty(name) != null) {
            return this.dataModel.getValue(name, rowIndex, parentIndex);
        }
        return null;
    }

    protected String subStringCity(String cityName) {
        if (StringUtils.isEmpty((CharSequence)cityName)) {
            return "";
        }
        String result = cityName;
        String cityRes = ResManager.loadKDString((String)"\u5e02", (String)"CreateNewTripItemEntryServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]);
        String specCityRes = ResManager.loadKDString((String)"\u7279\u522b\u884c\u653f\u533a", (String)"CreateNewTripItemEntryServiceImpl_1", (String)"fi-er-business", (Object[])new Object[0]);
        if (result.endsWith(cityRes)) {
            result = result.substring(0, result.length() - 1);
        }
        result = result.replace(specCityRes, "");
        return result;
    }
}

