/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateEntryService;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.model.invoice.bo.ExpenseEntryBO;
import org.apache.commons.lang3.ObjectUtils;

public class CreateExpenseItemEntryServiceImpl
extends CreateEntryService {
    private static final Log log = LogFactory.getLog(CreateExpenseItemEntryServiceImpl.class);
    private final String EXPENSE_ITEM_ENTRY = "expenseentryentity";

    public CreateExpenseItemEntryServiceImpl(InvoiceContext invoiceContext, IDataModel dataModel) {
        super(invoiceContext);
        this.dataModel = dataModel;
    }

    public CreateExpenseItemEntryServiceImpl(InvoiceContext invoiceContext, IDataModel dataModel, boolean isOrgOffset) {
        this(invoiceContext, dataModel);
        this.isOrgOffset = isOrgOffset;
    }

    @Override
    public void process() {
        List expenseEntryBOs = this.invoiceContext.getExpenseEntryBOs();
        String zeroCreate = ErStdConfig.getInvoiceZeroAmountCreateItem();
        if (StringUtils.equals((CharSequence)zeroCreate, (CharSequence)"0")) {
            expenseEntryBOs = expenseEntryBOs.stream().filter(entry -> entry.getTotalAmount().abs().compareTo(BigDecimal.valueOf(1.0E-6)) > 0).collect(Collectors.toList());
        }
        if (expenseEntryBOs.size() <= 0) {
            log.info("\u672a\u5bfc\u5165\u4efb\u4f55\u6709\u6548\u53d1\u7968");
            return;
        }
        DynamicObjectCollection expenseEntrys = this.dataModel.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
        HashMap<Long, Integer> rowIndexByEntryId = new HashMap<Long, Integer>(expenseEntrys.size());
        for (int i = 0; i < expenseEntrys.size(); ++i) {
            rowIndexByEntryId.put(((DynamicObject)expenseEntrys.get(i)).getLong("id"), i);
        }
        expenseEntryBOs.sort((entry1, entry2) -> ((Date)ObjectUtils.defaultIfNull((Object)entry1.getHappenDate(), (Object)ErCommonUtils.getDateFromLocalDate(LocalDate.now()))).compareTo(entry2.getHappenDate()));
        for (ExpenseEntryBO expenseEntryBO : expenseEntryBOs) {
            int rowIndex = rowIndexByEntryId.containsKey(expenseEntryBO.getEntryId()) ? ((Integer)rowIndexByEntryId.get(expenseEntryBO.getEntryId())).intValue() : this.dataModel.createNewEntryRow("expenseentryentity");
            this.genExpenseItemEntry(this.invoiceContext, expenseEntryBO, rowIndex, -1);
        }
    }

    @Override
    protected void createExpenseItemEntry(ExpenseEntryBO expenseEntryBO, int rowIndex, int parentIndex) {
        log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011CreateExpenseItemEntryServiceImpl \u8d39\u7528\u660e\u7ec6\u4fe1\u606f: " + expenseEntryBO + "\uff0c rowIndex\uff1a" + rowIndex + ", parentIndex\uff1a" + parentIndex);
        String itemFrom = expenseEntryBO.getItemFrom();
        if (ItemFrom.TripBusiness.equalsFrom(itemFrom)) {
            this.createTripBusinessExpense(expenseEntryBO, rowIndex, parentIndex);
        } else {
            this.createNormalExpense(expenseEntryBO, rowIndex, parentIndex);
        }
    }

    private void createTripBusinessExpense(ExpenseEntryBO expenseEntryBO, int rowIndex, int parentIndex) {
        DynamicObject expenseEntryDO = (DynamicObject)this.dataModel.getEntryEntity("expenseentryentity").get(rowIndex);
        expenseEntryDO.set("id", (Object)expenseEntryBO.getEntryId());
        this.dataModel.setValue("itemfrom", (Object)ItemFrom.TripBusiness.getValue(), rowIndex);
        this.dataModel.setValue("invoicelink", (Object)StringUtils.abbreviate((String)expenseEntryBO.getInvoiceCodeUnion(), (int)129), rowIndex);
        this.dataModel.setValue("invoiceno_entry", (Object)StringUtils.abbreviate((String)expenseEntryBO.getInvoiceNoUnion(), (int)129), rowIndex);
    }

    private void createNormalExpense(ExpenseEntryBO expenseEntryBO, int rowIndex, int parentIndex) {
        DynamicObject expenseEntryDO = (DynamicObject)this.dataModel.getEntryEntity("expenseentryentity").get(rowIndex);
        expenseEntryDO.set("id", (Object)expenseEntryBO.getEntryId());
        this.dataModel.setValue("itemfrom", (Object)ItemFrom.InvoiceCloud.getValue(), rowIndex);
        this.dataModel.setValue("invoicetypeitem", (Object)expenseEntryBO.getInvoiceType(), rowIndex);
        this.dataModel.setValue("happendate", (Object)expenseEntryBO.getHappenDate(), rowIndex);
        this.dataModel.setValue("expenseitem", (Object)expenseEntryBO.getExpenseItemId(), rowIndex);
        this.dataModel.beginInit();
        this.dataModel.setValue("offset", (Object)(expenseEntryBO.getIsOffset() == false ? 1 : 0), rowIndex);
        this.dataModel.endInit();
        this.dataModel.setValue("offset", (Object)expenseEntryBO.getIsOffset(), rowIndex);
        this.dataModel.setValue("entrycurrency", (Object)expenseEntryBO.getEntryCurrencyId(), rowIndex);
        this.dataModel.setValue("expenseamount", (Object)expenseEntryBO.getTotalAmount(), rowIndex);
        AmountUtils.refreshCurrAmount((IDataModel)this.dataModel, (BigDecimal)expenseEntryBO.getTotalAmount(), (String)"currexpenseamount", (String)"exchangerate", (String)"entrycurrency", (String)"expquotetype", (int)rowIndex);
        this.dataModel.setValue("expeapproveamount", (Object)expenseEntryBO.getTotalAmount(), rowIndex);
        AmountUtils.refreshCurrAmount((IDataModel)this.dataModel, (BigDecimal)expenseEntryBO.getTotalAmount(), (String)"expeapprovecurramount", (String)"exchangerate", (String)"entrycurrency", (String)"expquotetype", (int)rowIndex);
        this.dataModel.setValue("airportconstructionfee", (Object)expenseEntryBO.getAirportConstructionFee(), rowIndex);
        if (!this.isOrgOffset) {
            this.dataModel.setValue("taxrate", (Object)BigDecimal.ZERO, rowIndex);
            this.dataModel.setValue("taxamount", (Object)BigDecimal.ZERO, rowIndex);
            this.dataModel.setValue("orientryamount", (Object)expenseEntryBO.getTotalAmount(), rowIndex);
            if (this.dataModel.getProperty("approvetax") != null) {
                this.dataModel.setValue("approvetax", (Object)BigDecimal.ZERO, rowIndex);
            }
            this.dataModel.setValue("deductibletax", (Object)BigDecimal.ZERO, rowIndex);
            this.dataModel.setValue("iteminoutamount", (Object)BigDecimal.ZERO, rowIndex);
        } else {
            this.dataModel.setValue("taxrate", (Object)expenseEntryBO.getTaxRate().multiply(BigDecimal.valueOf(100L)), rowIndex);
            this.dataModel.setValue("taxamount", (Object)expenseEntryBO.getTaxAmount(), rowIndex);
            this.dataModel.setValue("orientryamount", (Object)expenseEntryBO.getNotIncludeTaxAmount(), rowIndex);
            if (this.dataModel.getProperty("approvetax") != null) {
                this.dataModel.setValue("approvetax", this.dataModel.getValue("taxamount", rowIndex), rowIndex);
            }
            this.dataModel.setValue("deductibletax", (Object)expenseEntryBO.getOffsetAmount(), rowIndex);
            this.dataModel.setValue("iteminoutamount", (Object)expenseEntryBO.getItemInOutAmount(), rowIndex);
        }
        this.dataModel.setValue("is_special_invoice", (Object)expenseEntryBO.getIsSpecialInvoice(), rowIndex);
        this.dataModel.setValue("taxclasscode", (Object)expenseEntryBO.getTaxClassCodeId(), rowIndex);
        this.dataModel.setValue("invoicelink", (Object)StringUtils.abbreviate((String)expenseEntryBO.getInvoiceCodeUnion(), (int)129), rowIndex);
        this.dataModel.setValue("invoiceno_entry", (Object)StringUtils.abbreviate((String)expenseEntryBO.getInvoiceNoUnion(), (int)129), rowIndex);
        IDataEntityProperty goodsNameProp = this.dataModel.getProperty("expensegoodsname");
        if (goodsNameProp != null) {
            this.dataModel.setValue("expensegoodsname", (Object)expenseEntryBO.getGoodName(), rowIndex);
        }
        this.copyItem(rowIndex);
        this.dataModel.setValue("remark", (Object)expenseEntryBO.getRemark(), rowIndex);
    }

    private void copyItem(int rowIndex) {
        if (this.curSelectedItem != null) {
            this.dataModel.setValue("entrycostcompany", (Object)ErCommonUtils.getPk(this.curSelectedItem.get("entrycostcompany")), rowIndex);
            this.dataModel.setValue("entrycostdept", (Object)ErCommonUtils.getPk(this.curSelectedItem.get("entrycostdept")), rowIndex);
            this.dataModel.setValue("std_project", (Object)ErCommonUtils.getPk(this.curSelectedItem.get("std_project")), rowIndex);
        } else {
            if (null == this.dataModel.getValue("entrycostcompany", rowIndex)) {
                this.dataModel.setValue("entrycostcompany", (Object)ErCommonUtils.getPk(this.dataModel.getValue("costcompany")), rowIndex);
            }
            if (null == this.dataModel.getValue("entrycostdept", rowIndex)) {
                this.dataModel.setValue("entrycostdept", (Object)ErCommonUtils.getPk(this.dataModel.getValue("costdept")), rowIndex);
            }
        }
    }
}

