/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.provider.param.AfterDataModelProxy;
import kd.fi.er.business.invoicecloud.provider.param.DataModelProxy;
import kd.fi.er.business.invoicecloud.provider.param.InvoiceContextProxy;
import kd.fi.er.business.invoicecloud.provider.service.IAfterCreateInvoiceInfoService;
import kd.fi.er.business.invoicecloud.provider.service.IBeforeCreateInvoiceInfoService;
import kd.fi.er.business.invoicecloud.provider.service.factory.InvoiceServiceFactory;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceServiceI;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.bo.InvoiceEntryBO;
import kd.fi.er.common.model.invoice.bo.InvoiceItemEntryBO;
import org.apache.commons.lang3.StringUtils;

public class CreateInvoiceEntryServiceImpl
extends CreateInvoiceServiceI {
    private static final Log log = LogFactory.getLog(CreateInvoiceEntryServiceImpl.class);
    private IDataModel dataModel;
    private boolean isImportNonDeductionTaxAmount;

    public CreateInvoiceEntryServiceImpl(InvoiceContext invoiceContext, IDataModel dataModel) {
        super(invoiceContext);
        this.dataModel = dataModel;
        this.isImportNonDeductionTaxAmount = invoiceContext.getInvoiceConfig().isOrgOffset() && invoiceContext.getInvoiceConfig().isImportNonDeductionTaxAmout();
    }

    @Deprecated
    public CreateInvoiceEntryServiceImpl(InvoiceContext invoiceContext, IDataModel dataModel, boolean isOrgOffset) {
        this(invoiceContext, dataModel);
    }

    public void process() {
        List invoiceEntryBOs = this.invoiceContext.getInvoiceEntryBOs();
        if (invoiceEntryBOs.size() <= 0) {
            log.info("\u672a\u5bfc\u5165\u4efb\u4f55\u53d1\u7968");
            return;
        }
        this.initRelation();
        DynamicObjectCollection invoiceCollection = this.dataModel.getEntryEntity("invoiceentry");
        List<Object> sortList = this.sortInvoiceEntity(invoiceCollection, invoiceEntryBOs);
        this.createEntryRowForBos(invoiceCollection, invoiceEntryBOs, sortList);
        this.resetInvoiceEntitySeq(this.dataModel.getEntryEntity("invoiceentry"));
        List invoiceItemEntryBOs = this.invoiceContext.getInvoiceItemEntryBOs();
        int size = invoiceItemEntryBOs.size();
        int[] rowIndexes = this.dataModel.batchCreateNewEntryRow("invoiceitementry", size);
        for (int i = 0; i < size; ++i) {
            this.createInvoiceItem((InvoiceItemEntryBO)invoiceItemEntryBOs.get(i), rowIndexes[i]);
        }
    }

    @Override
    protected void createInvoiceHeadEntry(InvoiceEntryBO invoiceEntryBO, int rowIndex) {
        log.info("\u3010\u5bfc\u5165\u53d1\u7968\u3011CreateInvoiceEntryServiceImpl \u53d1\u7968\u4fe1\u606f: " + invoiceEntryBO);
        DynamicObject dataEntity = this.dataModel.getDataEntity(true);
        DynamicObject invoiceEntryDO = (DynamicObject)dataEntity.getDynamicObjectCollection("invoiceentry").get(rowIndex);
        invoiceEntryDO.set("id", (Object)invoiceEntryBO.getEntryId());
        this.setValueIfExist("invoicefrom", invoiceEntryBO.getInvoiceFrom(), rowIndex);
        this.setValueIfExist("invoicecurrency", invoiceEntryBO.getInvoiceCurrencyId(), rowIndex);
        IDataEntityProperty invoiceTypeProp = this.dataModel.getProperty("invoicetype");
        if (invoiceTypeProp instanceof ComboProp) {
            this.setValueIfExist("invoicetype", invoiceEntryBO.getInvoiceType(), rowIndex);
        } else {
            this.setValueIfExist("invoicetype", invoiceEntryBO.getInvoiceTypeId(), rowIndex);
        }
        this.setValueIfExist("invoicetype", invoiceEntryBO.getInvoiceType(), rowIndex);
        this.setValueIfExist("invoicecode", invoiceEntryBO.getInvoiceCode(), rowIndex);
        this.setValueIfExist("invoiceno", invoiceEntryBO.getInvoiceNo(), rowIndex);
        this.setValueIfExist("invoicedate", invoiceEntryBO.getInvoiceDate(), rowIndex);
        this.setValueIfExist("carrierdate", invoiceEntryBO.getCarrierDate(), rowIndex);
        this.setValueIfExist("totalamount", invoiceEntryBO.getTotalAmount(), rowIndex);
        this.setValueIfExist("passengername", invoiceEntryBO.getPassengerName(), rowIndex);
        if (this.isImportNonDeductionTaxAmount || invoiceEntryBO.getIsOffset().booleanValue()) {
            this.setValueIfExist("alltaxrate", invoiceEntryBO.getAllTaxRate(), rowIndex);
            this.setValueIfExist("taxrate_invoice", invoiceEntryBO.getTaxRate().multiply(BigDecimal.valueOf(100L)), rowIndex);
            this.setValueIfExist("taxamount_invoice", invoiceEntryBO.getTaxAmount(), rowIndex);
            this.setValueIfExist("offset_invoice", invoiceEntryBO.getIsOffset(), rowIndex);
            this.setValueIfExist("offsetamount", invoiceEntryBO.getOffsetAmount(), rowIndex);
            this.setValueIfExist("inoutamount", invoiceEntryBO.getInOutAmount(), rowIndex);
        }
        this.setValueIfExist("validatemessage", InvoiceUtils.getLimitedValidateMessage(invoiceEntryBO.getValidateMessage()), rowIndex);
        this.setValueIfExist("buyerorgname", invoiceEntryBO.getBuyerOrgName(), rowIndex);
        this.setValueIfExist("makeoutcompname", invoiceEntryBO.getMakeOutCompanyName(), rowIndex);
        this.setValueIfExist("count", 1, rowIndex);
        this.setValueIfExist("remark_invoice", StringUtils.abbreviate((String)invoiceEntryBO.getRemark_Invoice(), (int)1024), rowIndex);
        this.setValueIfExist("frominvoicecloud", invoiceEntryBO.getIsFromInvoiceCloud(), rowIndex);
        this.setValueIfExist("serialno", invoiceEntryBO.getSerialNo(), rowIndex);
        this.setValueIfExist("invoiceairportconstfee", invoiceEntryBO.getAirportConstructionFee(), rowIndex);
        this.setValueIfExist("ismapexpense", invoiceEntryBO.isMapExpenseItem() ? "1" : "0", rowIndex);
        this.setValueIfExist("invoicefromcity", invoiceEntryBO.getFrom(), rowIndex);
        this.setValueIfExist("invoicetocity", invoiceEntryBO.getTo(), rowIndex);
        this.setValueIfExist("ie_validatest", invoiceEntryBO.getCheckStatus(), rowIndex);
        this.setValueIfExist("istartcity", invoiceEntryBO.getStartCity(), rowIndex);
        this.setValueIfExist("idestcity", invoiceEntryBO.getDestCity(), rowIndex);
        this.setValueIfExist("istartprovince", invoiceEntryBO.getStartProvince(), rowIndex);
        this.setValueIfExist("idestprovince", invoiceEntryBO.getDestProvince(), rowIndex);
        this.setValueIfExist("seatgrade", invoiceEntryBO.getSeatGrade(), rowIndex);
        this.setValueIfExist("transportnote", invoiceEntryBO.getTransportNote(), rowIndex);
        this.setValueIfExist("invoicenotaxamount", invoiceEntryBO.getInvoiceNoTaxAmount(), rowIndex);
        this.setValueIfExist("invoiceischange", invoiceEntryBO.getInvoiceIsChange(), rowIndex);
        this.setValueIfExist("buyertaxno", invoiceEntryBO.getBuyerTaxNo(), rowIndex);
        this.setValueIfExist("salertaxno_h", invoiceEntryBO.getSalerTaxNo(), rowIndex);
        this.setValueIfExist("ticketchanges", invoiceEntryBO.getTicketChanges(), rowIndex);
        this.setValueIfExist("sequencenum", invoiceEntryBO.getSequenceNum(), rowIndex);
        if (StringUtils.equals((CharSequence)invoiceEntryBO.getSequenceNum(), (CharSequence)"1")) {
            this.setValueIfExist("sequencenuminfo", InvoiceUtils.getLimitedValidateMessage(invoiceEntryBO.getSequenceNumInfo()), rowIndex);
        }
        this.setValueIfExist("flighttrainnums", invoiceEntryBO.getFlightTrainNums(), rowIndex);
        this.setValueIfExist("issupplement", invoiceEntryBO.isSupplement() ? "1" : "0", rowIndex);
        this.setValueIfExist("billcreatetime", invoiceEntryBO.getBillCreateTime(), rowIndex);
        this.setValueIfExist("passverifybuyername", invoiceEntryBO.getPassVerifyBuyerName(), rowIndex);
        this.setValueIfExist("passverifybuyertaxno", invoiceEntryBO.getPassVerifyBuyerTaxNo(), rowIndex);
        this.setValueIfExist("personalinvoice", invoiceEntryBO.getPersonalInvoice(), rowIndex);
        this.setValueIfExist("invoicegoodsname", InvoiceUtils.getLimitedValidateMessage(invoiceEntryBO.getInvoiceGoodsName()), rowIndex);
        this.setValueIfExist("invoicealltaxcode", InvoiceUtils.getLimitedValidateMessage(invoiceEntryBO.getInvoiceAllTaxCode()), rowIndex);
        this.setValueIfExist("customeridnumber", invoiceEntryBO.getCustomerIDNumber(), rowIndex);
        this.setValueIfExist("airconstfee", invoiceEntryBO.getAirConstFee(), rowIndex);
        this.setValueIfExist("othertotaltaxamount", invoiceEntryBO.getOtherTotalTaxAmount(), rowIndex);
        this.setValueIfExist("insurancepremium", invoiceEntryBO.getInsurancePremium(), rowIndex);
        this.setValueIfExist("isred", invoiceEntryBO.getRed(), rowIndex);
        this.setValueIfExist("region", invoiceEntryBO.getRegion(), rowIndex);
        this.setValueIfExist("isxbrl", invoiceEntryBO.isXbrl(), rowIndex);
        this.setValueIfExist("uploadSeq", invoiceEntryBO.getUploadSeq(), rowIndex);
        this.setValueIfExist("invoicestartdate", invoiceEntryBO.getStartDate(), rowIndex);
        this.setValueIfExist("invoiceenddate", invoiceEntryBO.getEndDate(), rowIndex);
        this.setValueIfExist("invoicecity", invoiceEntryBO.getCity(), rowIndex);
        this.setValueIfExist("invoiceairtime", invoiceEntryBO.getAirTime(), rowIndex);
        this.setValueIfExist("invoicefuelsurcharge", invoiceEntryBO.getFuelSurcharge(), rowIndex);
        this.setValueIfExist("invoicebuyeraddressphone", invoiceEntryBO.getBuyerAddressPhone(), rowIndex);
        this.setValueIfExist("endorsement", invoiceEntryBO.getEndorsement(), rowIndex);
        this.setValueIfExist("blockchain", invoiceEntryBO.getBlockChain(), rowIndex);
        this.setValueIfExist("islinkagedetail", invoiceEntryBO.isLinkageDetail(), rowIndex);
        this.setValueIfExist("billingpoolid", invoiceEntryBO.getBillingPoolId(), rowIndex);
        this.setValueIfExist("expirypaydate", invoiceEntryBO.getDueDate(), rowIndex);
        this.setValueIfExist("country", invoiceEntryBO.getCountryId(), rowIndex);
        this.setValueIfExist("countrystr", invoiceEntryBO.getCountry(), rowIndex);
        this.setValueIfExist("taxDetails", invoiceEntryBO.getTaxDetails(), rowIndex);
        this.setValueIfExist("ismutilreimburse", invoiceEntryBO.getMutiReimburse(), rowIndex);
        this.setValueIfExist("oribalanceamount", invoiceEntryBO.getOriBalanceAmount(), rowIndex);
        this.setValueIfExist("poolreimburseamount", invoiceEntryBO.getPoolReimburseAmount(), rowIndex);
        if (invoiceEntryBO.getBillingPoolId() != null && invoiceEntryBO.getBillingPoolId() != 0L) {
            this.setValueIfExist("ispool", true, rowIndex);
            if (invoiceEntryBO.isCanCloseMultiReimburse()) {
                IPageCache pageCache = this.invoiceContext.getView().getPageCache();
                pageCache.put(invoiceEntryBO.getSerialNo(), "1");
            }
        }
        this.setValueIfExist("specmodel_h", invoiceEntryBO.getSpecModel_h(), rowIndex);
        this.setValueIfExist("unit_h", invoiceEntryBO.getUnit_h(), rowIndex);
        this.setValueIfExist("num_h", invoiceEntryBO.getNum_h(), rowIndex);
        this.setValueIfExist("unitprice_h", invoiceEntryBO.getUnitPrice_h(), rowIndex);
        this.setInvoiceEntryCustomFields(invoiceEntryBO, rowIndex);
    }

    @Override
    protected void createInvoiceItemEntry(InvoiceItemEntryBO invoiceItemEntryBO, int rowIndex) {
        DynamicObject dataEntity = this.dataModel.getDataEntity(true);
        DynamicObject invoiceItemEntryDO = (DynamicObject)dataEntity.getDynamicObjectCollection("invoiceitementry").get(rowIndex);
        InvoiceEntryBO invoiceEntryBO = invoiceItemEntryBO.getInvoiceEntryBO();
        String invoiceType = invoiceEntryBO.getInvoiceType();
        invoiceItemEntryDO.set("id", (Object)invoiceItemEntryBO.getEntryId());
        long itemEntryId = invoiceItemEntryBO.getExpenseEntryBO() == null ? 0L : invoiceItemEntryBO.getExpenseEntryBO().getEntryId();
        Long entryId = invoiceEntryBO.getEntryId();
        log.info("\u3010\u5bfc\u5165\u53d1\u7968\u3011\u53d1\u7968\u660e\u7ec6\u5206\u5f55\u884c\u53f7\uff1a" + rowIndex + ", itemEntryId\uff1a" + itemEntryId + ", invoiceHeadEntryId\uff1a" + entryId + ", invoiceItemEntryBO:" + invoiceItemEntryBO);
        this.setValueIfExist("itementryid", itemEntryId, rowIndex);
        this.setValueIfExist("invoiceheadentryid", entryId, rowIndex);
        this.setValueIfExist("invoicetype_item", invoiceItemEntryBO.getInvoiceType_item(), rowIndex);
        this.setValueIfExist("invoiceno_item", invoiceItemEntryBO.getInvoiceNo_item(), rowIndex);
        this.setValueIfExist("invoicedate_item", invoiceItemEntryBO.getInvoiceDate_item(), rowIndex);
        this.setValueIfExist("invoicecurrency_item", invoiceItemEntryBO.getInvoiceCurrency_item(), rowIndex);
        this.setValueIfExist("totalamount_item", invoiceItemEntryBO.getTotalAmount_item(), rowIndex);
        this.setValueIfExist("unitprice", invoiceItemEntryBO.getUnitPrice(), rowIndex);
        this.setValueIfExist("invoiceitemtaxrate", invoiceItemEntryBO.getInvoiceItemTaxRate(), rowIndex);
        this.setValueIfExist("unit", invoiceItemEntryBO.getUnit(), rowIndex);
        this.setValueIfExist("excludeamount", invoiceItemEntryBO.getExcludeAmount(), rowIndex);
        this.setValueIfExist("specmodel", invoiceItemEntryBO.getSpecModel(), rowIndex);
        this.setValueIfExist("invoiceitemtaxamout", invoiceItemEntryBO.getInvoiceItemTaxAmout(), rowIndex);
        this.setValueIfExist("goodscode", StringUtils.defaultIfBlank((CharSequence)invoiceItemEntryBO.getGoodsCode(), (CharSequence)invoiceType), rowIndex);
        this.setValueIfExist("num", invoiceItemEntryBO.getNum(), rowIndex);
        this.setValueIfExist("goodsname", invoiceItemEntryBO.getGoodsName(), rowIndex);
        this.setValueIfExist("invoiceitemoffset", invoiceItemEntryBO.getInvoiceItemOffset(), rowIndex);
        this.setValueIfExist("salertaxno", invoiceItemEntryBO.getSalerTaxNo(), rowIndex);
        this.setValueIfExist("invoicecloudoffset", invoiceItemEntryBO.getInvoiceCloudOffset(), rowIndex);
        this.setValueIfExist("invoiceitemserialno", invoiceItemEntryBO.getInvoiceItemSerialNo(), rowIndex);
        this.setInvoiceItemCustomFields(invoiceItemEntryBO, rowIndex);
    }

    public List<Object> sortInvoiceEntity(DynamicObjectCollection invoiceColl, List<InvoiceEntryBO> invoiceEntryBOs) {
        ArrayList sortList = Lists.newArrayListWithExpectedSize((int)(invoiceColl.size() + invoiceEntryBOs.size()));
        sortList.addAll(invoiceColl);
        sortList.addAll(invoiceEntryBOs);
        sortList.sort((u, v) -> {
            Date vInvoiceDate;
            Date vCreateTime;
            Long vSeq;
            Long uSeq = (Long)this.getFieldData(u, "uploadSeq");
            int cmpResult = this.compare(uSeq, vSeq = (Long)this.getFieldData(v, "uploadSeq"));
            if (cmpResult != 0) {
                return cmpResult;
            }
            Date uCreateTime = (Date)this.getFieldData(u, "billcreatetime");
            cmpResult = this.compare(uCreateTime, vCreateTime = (Date)this.getFieldData(v, "billcreatetime"));
            if (cmpResult != 0) {
                return cmpResult;
            }
            Date uInvoiceDate = (Date)this.getFieldData(u, "invoicedate");
            cmpResult = this.compare(uInvoiceDate, vInvoiceDate = (Date)this.getFieldData(v, "invoicedate"));
            if (cmpResult != 0) {
                return cmpResult;
            }
            String uInvoiceNo = this.getInvoiceNo(u);
            String vInvoiceNo = this.getInvoiceNo(v);
            return this.compare((Comparable)((Object)uInvoiceNo), (Comparable)((Object)vInvoiceNo));
        });
        return sortList;
    }

    private int compare(Comparable a, Comparable b) {
        if (a != null && b != null) {
            return a.compareTo(b);
        }
        if (a == null && b != null) {
            return 1;
        }
        if (a != null && b == null) {
            return -1;
        }
        return 0;
    }

    protected void createEntryRowForBos(DynamicObjectCollection invoiceColl, List<InvoiceEntryBO> invoiceEntryBOs, List<Object> sortList) {
        if (invoiceColl.isEmpty()) {
            this.dataModel.beginInit();
            int[] invoiceHeadRowIndexs = this.dataModel.batchCreateNewEntryRow("invoiceentry", invoiceEntryBOs.size());
            this.dataModel.endInit();
            int i = 0;
            for (int index = 0; index < sortList.size(); ++index) {
                Object entry = sortList.get(index);
                if (!(entry instanceof InvoiceEntryBO)) continue;
                this.createInvoiceHead((InvoiceEntryBO)entry, invoiceHeadRowIndexs[i++]);
            }
        } else {
            for (int index = 0; index < sortList.size(); ++index) {
                Object entry = sortList.get(index);
                if (!(entry instanceof InvoiceEntryBO)) continue;
                this.dataModel.beginInit();
                int insertIndex = this.dataModel.insertEntryRow("invoiceentry", index);
                this.dataModel.endInit();
                this.createInvoiceHead((InvoiceEntryBO)entry, insertIndex);
            }
        }
        if (this.invoiceContext.getView() != null) {
            this.invoiceContext.getView().updateView("invoiceentry");
        }
    }

    protected void resetInvoiceEntitySeq(DynamicObjectCollection invoiceColl) {
        for (int index = 0; index < invoiceColl.size(); ++index) {
            ((DynamicObject)invoiceColl.get(index)).set("seq", (Object)(index + 1));
        }
    }

    private Object getFieldData(Object dateSource, String fieldName) {
        Object data = null;
        if (dateSource instanceof DynamicObject) {
            data = ((DynamicObject)dateSource).get(fieldName);
        }
        if (dateSource instanceof InvoiceEntryBO) {
            switch (fieldName) {
                case "billcreatetime": {
                    data = ((InvoiceEntryBO)dateSource).getBillCreateTime();
                    break;
                }
                case "invoicedate": {
                    data = ((InvoiceEntryBO)dateSource).getInvoiceDate();
                    break;
                }
                case "uploadSeq": {
                    data = ((InvoiceEntryBO)dateSource).getUploadSeq();
                }
            }
        }
        return data;
    }

    private String getInvoiceNo(Object dateSource) {
        if (dateSource instanceof DynamicObject) {
            return ((DynamicObject)dateSource).getString("invoiceno");
        }
        if (dateSource instanceof InvoiceEntryBO) {
            return ((InvoiceEntryBO)dateSource).getInvoiceNo();
        }
        return null;
    }

    private final void createInvoiceHead(InvoiceEntryBO invoiceEntryBO, int rowIndex) {
        this.executeBeforeCreateInvoiceHead(invoiceEntryBO, rowIndex);
        this.createInvoiceHeadEntry(invoiceEntryBO, rowIndex);
        this.executeAfterCreateInvoiceHead(invoiceEntryBO, rowIndex);
    }

    protected final void createInvoiceItem(InvoiceItemEntryBO invoiceItemEntryBO, int rowIndex) {
        this.executeBeforeCreateInvoiceItem(invoiceItemEntryBO, rowIndex);
        this.createInvoiceItemEntry(invoiceItemEntryBO, rowIndex);
        this.executeAfterCreateInvoiceItem(invoiceItemEntryBO, rowIndex);
    }

    private final void executeBeforeCreateInvoiceHead(InvoiceEntryBO invoiceEntryBO, int rowIndex) {
        try {
            IBeforeCreateInvoiceInfoService beforeService = (IBeforeCreateInvoiceInfoService)InvoiceServiceFactory.getSingletonService(IBeforeCreateInvoiceInfoService.class);
            if (beforeService == null) {
                return;
            }
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u53d1\u7968\u4fe1\u606f\u751f\u6210\u524d\u7f6e\u670d\u52a1\u524dinvoiceEntryBO:" + invoiceEntryBO);
            beforeService.beforeCreateInvoiceEntry(new InvoiceContextProxy(this.invoiceContext), new DataModelProxy(this.dataModel), invoiceEntryBO, rowIndex);
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u53d1\u7968\u4fe1\u606f\u751f\u6210\u524d\u7f6e\u670d\u52a1\u540einvoiceEntryBO:" + invoiceEntryBO);
        }
        catch (Exception e) {
            log.error("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u7b2c\u4e09\u65b9\u53d1\u7968\u4fe1\u606f\u751f\u6210\u524d\u7f6e\u670d\u52a1\u5f02\u5e38:", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private final void executeAfterCreateInvoiceHead(InvoiceEntryBO invoiceEntryBO, int rowIndex) {
        try {
            IAfterCreateInvoiceInfoService afterService = (IAfterCreateInvoiceInfoService)InvoiceServiceFactory.getSingletonService(IAfterCreateInvoiceInfoService.class);
            if (afterService == null) {
                return;
            }
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u53d1\u7968\u4fe1\u606f\u751f\u6210\u540e\u7f6e\u670d\u52a1\u524dinvoiceEntryBO:" + invoiceEntryBO);
            afterService.afterCreateInvoiceEntry(new InvoiceContextProxy(this.invoiceContext), new AfterDataModelProxy(this.dataModel), invoiceEntryBO, rowIndex);
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u53d1\u7968\u4fe1\u606f\u751f\u6210\u540e\u7f6e\u670d\u52a1\u540einvoiceEntryBO:" + invoiceEntryBO);
        }
        catch (Exception e) {
            log.error("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u7b2c\u4e09\u65b9\u53d1\u7968\u4fe1\u606f\u751f\u6210\u524d\u7f6e\u670d\u52a1\u5f02\u5e38:", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private final void executeBeforeCreateInvoiceItem(InvoiceItemEntryBO invoiceItemEntryBO, int rowIndex) {
        try {
            IBeforeCreateInvoiceInfoService beforeService = (IBeforeCreateInvoiceInfoService)InvoiceServiceFactory.getSingletonService(IBeforeCreateInvoiceInfoService.class);
            if (beforeService == null) {
                return;
            }
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u53d1\u7968\u660e\u7ec6\u751f\u6210\u524d\u7f6e\u670d\u52a1\u524dinvoiceItemEntryBO:" + invoiceItemEntryBO);
            beforeService.beforeCreateInvoiceItemEntry(new InvoiceContextProxy(this.invoiceContext), new DataModelProxy(this.dataModel), invoiceItemEntryBO, rowIndex);
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u53d1\u7968\u660e\u7ec6\u751f\u6210\u524d\u7f6e\u670d\u52a1\u540einvoiceItemEntryBO:" + invoiceItemEntryBO);
        }
        catch (Exception e) {
            log.error("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u7b2c\u4e09\u65b9\u53d1\u7968\u660e\u7ec6\u751f\u6210\u524d\u7f6e\u670d\u52a1\u5f02\u5e38:", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private final void executeAfterCreateInvoiceItem(InvoiceItemEntryBO invoiceItemEntryBO, int rowIndex) {
        try {
            IAfterCreateInvoiceInfoService afterService = (IAfterCreateInvoiceInfoService)InvoiceServiceFactory.getSingletonService(IAfterCreateInvoiceInfoService.class);
            if (afterService == null) {
                return;
            }
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u53d1\u7968\u660e\u7ec6\u751f\u6210\u540e\u7f6e\u670d\u52a1\u524dinvoiceItemEntryBO:" + invoiceItemEntryBO);
            afterService.afterCreateInvoiceItemEntry(new InvoiceContextProxy(this.invoiceContext), new AfterDataModelProxy(this.dataModel), invoiceItemEntryBO, rowIndex);
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u53d1\u7968\u660e\u7ec6\u751f\u6210\u540e\u7f6e\u670d\u52a1\u540einvoiceItemEntryBO:" + invoiceItemEntryBO);
        }
        catch (Exception e) {
            log.error("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u7b2c\u4e09\u65b9\u53d1\u7968\u660e\u7ec6\u751f\u6210\u540e\u7f6e\u670d\u52a1\u5f02\u5e38:", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private void setInvoiceEntryCustomFields(InvoiceEntryBO invoiceEntryBO, int rowIndex) {
        Map customFields = invoiceEntryBO.getCustomFields();
        if (customFields.isEmpty()) {
            return;
        }
        Field[] fields = InvoiceEntryBO.class.getDeclaredFields();
        List fieldNameList = Arrays.stream(fields).map(field -> field.getName().toLowerCase()).collect(Collectors.toList());
        DynamicObjectCollection entryEntity = this.dataModel.getEntryEntity("invoiceentry");
        DataEntityPropertyCollection properties = entryEntity.getDynamicObjectType().getProperties();
        for (Map.Entry next : customFields.entrySet()) {
            String fieldName = (String)next.getKey();
            Object value = next.getValue();
            if (fieldNameList.contains(fieldName.toLowerCase()) || properties.get((Object)fieldName) == null) continue;
            this.dataModel.setValue(fieldName, value, rowIndex);
        }
    }

    private void setInvoiceItemCustomFields(InvoiceItemEntryBO invoiceItemEntryBO, int rowIndex) {
        Map customFields = invoiceItemEntryBO.getCustomFields();
        if (customFields.isEmpty()) {
            return;
        }
        Field[] fields = InvoiceItemEntryBO.class.getDeclaredFields();
        List fieldNameList = Arrays.stream(fields).map(field -> field.getName().toLowerCase()).collect(Collectors.toList());
        DynamicObjectCollection entryEntity = this.dataModel.getEntryEntity("invoiceitementry");
        DataEntityPropertyCollection properties = entryEntity.getDynamicObjectType().getProperties();
        for (Map.Entry next : customFields.entrySet()) {
            String fieldName = (String)next.getKey();
            Object value = next.getValue();
            if (fieldNameList.contains(fieldName.toLowerCase()) || properties.get((Object)fieldName) == null) continue;
            this.dataModel.setValue(fieldName, value, rowIndex);
        }
    }
}

