/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceTypeEnum;
import kd.fi.er.business.invoicecloud.util.InvoiceTypeUtils;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService.GroupKey;
import kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService.MergeInvoiceService;
import kd.fi.er.common.constant.StdConfigConstant;
import kd.fi.er.common.model.invoice.bo.ExpenseEntryBO;
import kd.fi.er.common.model.invoice.bo.InvoiceEntryBO;
import kd.fi.er.common.model.invoice.bo.InvoiceItemEntryBO;
import kd.fi.er.common.model.invoice.merge.ItemEnum;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class MergeInvoicesInOneServiceImpl
extends MergeInvoiceService {
    private long expenseOrTripItemEntryId;

    public MergeInvoicesInOneServiceImpl(InvoiceContext invoiceContext, long expenseOrTripItemEntryId, IDataModel model) {
        super(invoiceContext);
        this.expenseOrTripItemEntryId = expenseOrTripItemEntryId;
        this.setModel(model);
        this.setUseExpenseDate(invoiceContext.getInvoiceConfig().isUseExpenseDate());
    }

    @Deprecated
    public MergeInvoicesInOneServiceImpl(InvoiceContext invoiceContext, String entityName, IDataModel model) {
        super(invoiceContext);
        this.expenseOrTripItemEntryId = 0L;
        this.setModel(model);
        this.setUseExpenseDate(invoiceContext.getInvoiceConfig().isUseExpenseDate());
    }

    @Deprecated
    public MergeInvoicesInOneServiceImpl(InvoiceContext invoiceContext, long expenseOrTripItemEntryId, IDataModel model, boolean useExpenseDate) {
        super(invoiceContext);
        this.expenseOrTripItemEntryId = expenseOrTripItemEntryId;
        this.setModel(model);
        this.setUseExpenseDate(useExpenseDate);
    }

    @Deprecated
    public MergeInvoicesInOneServiceImpl(InvoiceContext invoiceContext, String entityName, IDataModel model, boolean useExpenseDate) {
        super(invoiceContext);
        this.expenseOrTripItemEntryId = 0L;
        this.setModel(model);
        this.setUseExpenseDate(useExpenseDate);
    }

    public void process() {
        List invoiceEntryBOs = this.invoiceContext.getInvoiceEntryBOs();
        if (invoiceEntryBOs.isEmpty()) {
            return;
        }
        Map<Long, List<InvoiceEntryBO>> invoiceGroupByCurrency = invoiceEntryBOs.stream().collect(Collectors.groupingBy(bo -> bo.getInvoiceCurrencyId()));
        DynamicObject selectItem = null;
        List selectItems = this.invoiceContext.getSelectItem();
        if (selectItems != null && !selectItems.isEmpty()) {
            selectItem = (DynamicObject)selectItems.get(0);
        }
        for (Map.Entry<Long, List<InvoiceEntryBO>> sameCurrencyInvoiceEntry : invoiceGroupByCurrency.entrySet()) {
            DynamicObject expenseitem;
            List<InvoiceEntryBO> invoiceEntryList = sameCurrencyInvoiceEntry.getValue();
            List<InvoiceItemEntryBO> invoiceItemEntryBOs = invoiceEntryList.stream().map(invoiceEntry -> invoiceEntry.getInvoiceItemEntryBOs()).flatMap(invoiceEntry -> invoiceEntry.stream()).collect(Collectors.toList());
            GroupKey groupKey = new GroupKey();
            groupKey.setGoodCode("");
            groupKey.setInvoiceType("");
            Long itemId = null;
            if (selectItem != null && (expenseitem = selectItem.getDynamicObject("expenseitem")) != null) {
                itemId = (Long)expenseitem.getPkValue();
            }
            if (itemId == null) {
                groupKey.setItemId((Long)ObjectUtils.defaultIfNull((Object)((InvoiceItemEntryBO)invoiceItemEntryBOs.get(0)).getExpenseItemId(), (Object)0L));
            } else {
                groupKey.setItemId((Long)ObjectUtils.defaultIfNull(itemId, (Object)0L));
            }
            Set taxs = invoiceItemEntryBOs.stream().map(invoiceItem -> invoiceItem.getInvoiceItemTaxRate()).collect(Collectors.toSet());
            if (taxs.size() != 1) {
                groupKey.setTaxRate(BigDecimal.ZERO);
            } else {
                groupKey.setTaxRate((BigDecimal)taxs.iterator().next());
            }
            ExpenseEntryBO expenseEntryBO = this.genExpenseEntryBOByInvoiceItemBO(groupKey, invoiceItemEntryBOs);
            invoiceItemEntryBOs.forEach(invoiceItemBO -> {
                if (invoiceItemBO.getInvoiceEntryBO().getTotalAmount().compareTo(BigDecimal.ZERO) != 0) {
                    invoiceItemBO.setExpenseEntryBO(expenseEntryBO);
                }
            });
            this.invoiceContext.getExpenseEntryBOs().add(expenseEntryBO);
        }
        this.updateLinkDetail();
    }

    private ExpenseEntryBO genExpenseEntryBOByInvoiceItemBO(GroupKey groupKey, List<InvoiceItemEntryBO> groupedInvoiceItemEntryBOs) {
        ExpenseEntryBO expenseEntryBO = new ExpenseEntryBO();
        long expenseEntryId = this.expenseOrTripItemEntryId == 0L ? ORM.create().genLongId(this.invoiceContext.getView().getEntityId()) : this.expenseOrTripItemEntryId;
        expenseEntryBO.setEntryId(Long.valueOf(expenseEntryId));
        expenseEntryBO.setExpenseItemId(groupKey.getItemId());
        if (Objects.equals(this.invoiceContext.getInvoiceConfig().getExpenseDateValue(), StdConfigConstant.EXPENSE_DATE_VALUE_HEAD) && this.getUseExpenseDate()) {
            expenseEntryBO.setHappenDate((Date)this.getModel().getValue("bizdate"));
        } else {
            expenseEntryBO.setHappenDate(this.getEarliestDate(groupedInvoiceItemEntryBOs));
        }
        BigDecimal airportConstructionFeeAmount = groupedInvoiceItemEntryBOs.stream().map(itemBo -> (BigDecimal)ObjectUtils.defaultIfNull((Object)itemBo.getInvoiceEntryBO().getAirportConstructionFee(), (Object)BigDecimal.ZERO)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        expenseEntryBO.setAirportConstructionFee(airportConstructionFeeAmount);
        expenseEntryBO.setIsPriceAndTaxSeperated(Boolean.valueOf(true));
        expenseEntryBO.setInvoiceItemEntryVOs(groupedInvoiceItemEntryBOs);
        Optional<InvoiceItemEntryBO> invoiceItemBOWithGoodsCodeOP = groupedInvoiceItemEntryBOs.stream().filter(invoiceItemBO -> StringUtils.isNotBlank((CharSequence)invoiceItemBO.getGoodsCode())).findFirst();
        String goodsCode = "";
        if (invoiceItemBOWithGoodsCodeOP.isPresent()) {
            goodsCode = invoiceItemBOWithGoodsCodeOP.get().getGoodsCode();
        }
        DynamicObject taxClassCodeDO = BusinessDataServiceHelper.loadSingleFromCache((String)"er_taxclasscode", (String)"id", (QFilter[])new QFilter[]{new QFilter("mergecode", "=", (Object)goodsCode)});
        Long taxClassCodeId = 0L;
        if (taxClassCodeDO != null) {
            taxClassCodeId = (Long)taxClassCodeDO.getPkValue();
        }
        expenseEntryBO.setTaxClassCodeId(taxClassCodeId);
        Optional<InvoiceItemEntryBO> invoiceItemBOWithGoodNameOP = groupedInvoiceItemEntryBOs.stream().filter(invoiceItemBO -> StringUtils.isNotBlank((CharSequence)invoiceItemBO.getGoodsName())).findFirst();
        if (invoiceItemBOWithGoodNameOP.isPresent()) {
            expenseEntryBO.setGoodName(invoiceItemBOWithGoodNameOP.get().getGoodsName());
        } else {
            expenseEntryBO.setGoodName("");
        }
        Set<String> set = InvoiceTypeUtils.loadSpecialInvoiceTypes();
        boolean isSpecialInvoice = groupedInvoiceItemEntryBOs.stream().allMatch(invoiceItem -> set.contains(invoiceItem.getInvoiceEntryBO().getInvoiceType()));
        expenseEntryBO.setIsSpecialInvoice(Boolean.valueOf(isSpecialInvoice));
        Set invoiceNoList = groupedInvoiceItemEntryBOs.stream().map(itemBo -> itemBo.getInvoiceEntryBO().getInvoiceNo()).collect(Collectors.toSet());
        Set invoiceCodeList = groupedInvoiceItemEntryBOs.stream().map(itemBo -> itemBo.getInvoiceEntryBO().getInvoiceCode()).collect(Collectors.toSet());
        expenseEntryBO.setInvoiceNoUnion(StringUtils.join(invoiceNoList, (String)","));
        expenseEntryBO.setInvoiceCodeUnion(StringUtils.join(invoiceCodeList, (String)","));
        expenseEntryBO.setTaxRate(groupKey.getTaxRate());
        BigDecimal taxAmount = groupedInvoiceItemEntryBOs.stream().map(invoiceItem -> invoiceItem.getInvoiceItemTaxAmout()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        if (!this.invoiceContext.getInvoiceConfig().isImportNonDeductionTaxAmout()) {
            Stream<InvoiceItemEntryBO> entryBOStream = this.invoiceContext.getInvoiceConfig().isInvoicesCredits() ? groupedInvoiceItemEntryBOs.stream().filter(v -> v.getInvoiceItemOffset()) : groupedInvoiceItemEntryBOs.stream().filter(v -> v.getInvoiceCloudOffset());
            BigDecimal reComputeTaxAmount = entryBOStream.map(invoiceItem -> invoiceItem.getInvoiceItemTaxAmout()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            if (taxAmount.compareTo(reComputeTaxAmount) != 0 || reComputeTaxAmount.compareTo(BigDecimal.ZERO) == 0) {
                expenseEntryBO.setTaxRate(BigDecimal.ZERO);
            }
            taxAmount = reComputeTaxAmount;
        }
        expenseEntryBO.setTaxAmount(taxAmount);
        this.setOffset(groupedInvoiceItemEntryBOs, expenseEntryBO);
        BigDecimal totalAmount = groupedInvoiceItemEntryBOs.stream().map(invoiceItem -> invoiceItem.getTotalAmount()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        expenseEntryBO.setTotalAmount(totalAmount);
        BigDecimal notIncludeTaxAmount = totalAmount.subtract(taxAmount);
        expenseEntryBO.setNotIncludeTaxAmount(notIncludeTaxAmount);
        Set invoiceTypeSet = groupedInvoiceItemEntryBOs.stream().map(invoiceItemBO -> invoiceItemBO.getInvoiceEntryBO().getInvoiceType()).collect(Collectors.toSet());
        String invoiceType = InvoiceTypeEnum.NULL.getValue();
        if (invoiceTypeSet.size() == 1) {
            invoiceType = (String)invoiceTypeSet.iterator().next();
        }
        expenseEntryBO.setInvoiceType(invoiceType);
        List invoiceEntryBOs = groupedInvoiceItemEntryBOs.stream().map(item -> item.getInvoiceEntryBO()).collect(Collectors.toList());
        List passengers = invoiceEntryBOs.stream().filter(invoice -> StringUtils.isNotBlank((CharSequence)invoice.getPassengerName())).map(invoice -> invoice.getPassengerName()).collect(Collectors.toList());
        Set<String> vehicleInvoiceTypes = InvoiceTypeUtils.loadVehicleInvoiceTypes();
        List vehicleInvoiceEntryBOs = invoiceEntryBOs.stream().filter(invoice -> vehicleInvoiceTypes.contains(invoice.getInvoiceType()) && StringUtils.isNotBlank((CharSequence)invoice.getStartCity()) && StringUtils.isNotBlank((CharSequence)invoice.getDestCity()) && invoice.getInvoiceDate() != null).collect(Collectors.toList());
        vehicleInvoiceEntryBOs.sort(Comparator.comparing(InvoiceEntryBO::getInvoiceDateForSort));
        if (!vehicleInvoiceEntryBOs.isEmpty()) {
            InvoiceEntryBO firstInvoice = (InvoiceEntryBO)vehicleInvoiceEntryBOs.get(0);
            InvoiceEntryBO lastInvoice = (InvoiceEntryBO)vehicleInvoiceEntryBOs.get(vehicleInvoiceEntryBOs.size() - 1);
            String startCity = firstInvoice.getStartCity();
            String destCity = lastInvoice.getDestCity();
            startCity = startCity.endsWith(ResManager.loadKDString((String)"\u5e02", (String)"MergeInvoicesInOneServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0])) ? startCity.substring(0, startCity.length() - 1) : startCity;
            destCity = destCity.endsWith(ResManager.loadKDString((String)"\u5e02", (String)"MergeInvoicesInOneServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0])) ? destCity.substring(0, destCity.length() - 1) : destCity;
            startCity = startCity.replace(ResManager.loadKDString((String)"\u7279\u522b\u884c\u653f\u533a", (String)"MergeInvoicesInOneServiceImpl_1", (String)"fi-er-business", (Object[])new Object[0]), "");
            destCity = destCity.replace(ResManager.loadKDString((String)"\u7279\u522b\u884c\u653f\u533a", (String)"MergeInvoicesInOneServiceImpl_1", (String)"fi-er-business", (Object[])new Object[0]), "");
            expenseEntryBO.setStartCity(startCity);
            expenseEntryBO.setEndCity(destCity);
            expenseEntryBO.setStartDate(firstInvoice.getInvoiceDate());
            expenseEntryBO.setEndDate(lastInvoice.getInvoiceDate());
            expenseEntryBO.setPassengers(passengers);
        }
        this.seatGrade(expenseEntryBO, groupedInvoiceItemEntryBOs);
        expenseEntryBO.setEntryCurrencyId(groupedInvoiceItemEntryBOs.get(0).getInvoiceEntryBO().getInvoiceCurrencyId());
        return expenseEntryBO;
    }

    private void setOffset(List<InvoiceItemEntryBO> groupedInvoiceItemEntryBOs, ExpenseEntryBO expenseEntryBO) {
        Boolean isItemOffset = false;
        boolean invoicesCredits = this.invoiceContext.getInvoiceConfig().isInvoicesCredits();
        Boolean isInvoiceOffset = invoicesCredits ? Boolean.valueOf(groupedInvoiceItemEntryBOs.stream().anyMatch(invoiceItem -> invoiceItem.getInvoiceItemOffset())) : Boolean.valueOf(groupedInvoiceItemEntryBOs.stream().anyMatch(invoiceItem -> invoiceItem.getInvoiceCloudOffset()));
        if (expenseEntryBO.getExpenseItemId() != null && expenseEntryBO.getExpenseItemId() != 0L) {
            ItemEnum item = groupedInvoiceItemEntryBOs.get(0).getItemEnum();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)expenseEntryBO.getExpenseItemId(), (String)item.getEntityName());
            isItemOffset = dynamicObject.getBoolean(item.getOffsetName());
        }
        expenseEntryBO.setInvoiceIsOffset(isInvoiceOffset);
        boolean orgOffset = this.invoiceContext.getInvoiceConfig().isOrgOffset();
        expenseEntryBO.setIsOffset(Boolean.valueOf(isInvoiceOffset != false && isItemOffset != false && orgOffset));
        if (expenseEntryBO.getIsOffset().booleanValue()) {
            Optional<BigDecimal> reduce = groupedInvoiceItemEntryBOs.stream().filter(invoiceItem -> invoicesCredits ? invoiceItem.getInvoiceItemOffset() : invoiceItem.getInvoiceCloudOffset()).map(invoiceItem -> invoiceItem.getInvoiceItemTaxAmout()).reduce(BigDecimal::add);
            if (reduce.isPresent()) {
                expenseEntryBO.setOffsetAmount(reduce.get());
            }
        } else {
            expenseEntryBO.setOffsetAmount(BigDecimal.ZERO);
        }
        expenseEntryBO.setItemInOutAmount(expenseEntryBO.getTaxAmount().subtract(expenseEntryBO.getOffsetAmount()));
    }

    private void seatGrade(ExpenseEntryBO expenseEntryBO, List<InvoiceItemEntryBO> groupedInvoiceItemEntryBOs) {
        List invoiceEntryBOs = this.invoiceContext.getInvoiceEntryBOs();
        HashMap seatGrades = Maps.newHashMapWithExpectedSize((int)2);
        Set airSeatGrade = invoiceEntryBOs.stream().filter(invoice -> StringUtils.equalsAny((CharSequence)invoice.getInvoiceType(), (CharSequence[])new CharSequence[]{InvoiceTypeEnum.key_10.getValue(), InvoiceTypeEnum.key_28.getValue()})).map(invoice -> invoice.getSeatGrade()).collect(Collectors.toSet());
        seatGrades.put("2", airSeatGrade);
        Set trainSeatGrade = invoiceEntryBOs.stream().filter(invoice -> StringUtils.equalsAny((CharSequence)invoice.getInvoiceType(), (CharSequence[])new CharSequence[]{InvoiceTypeEnum.key_9.getValue(), InvoiceTypeEnum.key_29.getValue()})).map(invoice -> invoice.getSeatGrade()).collect(Collectors.toSet());
        seatGrades.put("4", trainSeatGrade);
        Set shipSeatGrade = invoiceEntryBOs.stream().filter(invoice -> StringUtils.equals((CharSequence)invoice.getInvoiceType(), (CharSequence)InvoiceTypeEnum.key_20.getValue())).map(invoice -> invoice.getSeatGrade()).collect(Collectors.toSet());
        seatGrades.put("7", shipSeatGrade);
        expenseEntryBO.setSeatGrades((Map)seatGrades);
    }
}

