/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import org.apache.commons.lang.StringUtils;

public class CreditLevelServiceHelper {
    private static final String USER_ID = "userid";
    private static final String ENTITY_NUMBER = "entitynumber";
    private static final String BILL_ENTITY = "billentity";
    private static Log logger = LogFactory.getLog(CreditLevelServiceHelper.class);

    private CreditLevelServiceHelper() {
    }

    @Deprecated
    public static String getCreditLevelByTask(Object appilerStr) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(USER_ID, appilerStr);
        return CreditLevelServiceHelper.getCreditLevelByParam(param);
    }

    public static String getCreditLevelByUserAndView(Object userId, IFormView view) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(USER_ID, userId);
        return CreditLevelServiceHelper.getCreditLevelByParam(param);
    }

    private static String getCreditLevelByParam(Map<String, Object> param) {
        String creditLeveInfo = "";
        DynamicObject userArchive = CreditLevelServiceHelper.getCreditInfoByTask(param);
        if (userArchive != null) {
            String curLevName = userArchive.getString("creditlevel.name");
            BigDecimal curLevScoreBG = userArchive.getBigDecimal("creditvalue").setScale(1, 5);
            creditLeveInfo = String.format(ResManager.loadKDString((String)"%1$s \u5206\u6570:%2$s", (String)"CreditLevelServiceHelper_3", (String)"fi-er-business", (Object[])new Object[0]), curLevName, curLevScoreBG);
        }
        return creditLeveInfo;
    }

    private static DynamicObject getCreditInfoByTask(Map<String, Object> param) {
        String msg = "";
        DynamicObject creditInfo = null;
        try {
            long startTime = System.currentTimeMillis();
            logger.info("getCreditInfoByUserId - start");
            msg = (String)DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"getCreditInfoByUserId", (Object[])new Object[]{param});
            logger.info("getCreditInfoByUserId - end,cost {}ms", (Object)(System.currentTimeMillis() - startTime));
            Map creditMap = (Map)JSONObject.parse((String)msg);
            String credit = String.valueOf(creditMap.get("creditinfo"));
            if (!StringUtils.isEmpty((String)credit)) {
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)"task_creditfiles");
                Object[] userArchives = DynamicObjectSerializeUtil.deserialize((String)credit, (DynamicObjectType)type);
                if (userArchives == null || userArchives.length == 0) {
                    return creditInfo;
                }
                creditInfo = (DynamicObject)userArchives[0];
            }
        }
        catch (Exception e) {
            logger.error("getCreditLevelByTask_msg:" + msg, (Throwable)e);
        }
        return creditInfo;
    }

    public static void showCreditFilesForm(IFormView view, String userId) {
        if (kd.bos.util.StringUtils.isEmpty((String)userId)) {
            view.showMessage(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7f16\u53f7%s\u7684\u4fe1\u7528\u6863\u6848\u3002", (String)"CreditLevelServiceHelper_1", (String)"fi-er-business", (Object[])new Object[0]), userId));
        } else {
            Object id = CreditLevelServiceHelper.getCreditFilesID(userId, view);
            if (id == null || StringUtils.isEmpty((String)id.toString())) {
                view.showMessage(String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7f16\u53f7%s\u7684\u4fe1\u7528\u6863\u6848\u3002", (String)"CreditLevelServiceHelper_1", (String)"fi-er-business", (Object[])new Object[0]), userId));
            } else {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("task_creditfiles");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCaption(ResManager.loadKDString((String)"\u4fe1\u7528\u6863\u6848", (String)"CreditLevelServiceHelper_2", (String)"fi-er-business", (Object[])new Object[0]));
                parameter.setStatus(OperationStatus.VIEW);
                parameter.setPkId(id);
                parameter.setHasRight(true);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("fromwhere", "tasklist");
                String pageid = view.getPageId();
                map.put("pageid", pageid);
                parameter.setCustomParams(map);
                view.showForm((FormShowParameter)parameter);
            }
        }
    }

    @Deprecated
    public static Object getCreditFilesID(Object userId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(USER_ID, userId);
        return CreditLevelServiceHelper.getCreditFilesID(param);
    }

    public static Object getCreditFilesID(Object userId, IFormView view) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(USER_ID, userId);
        return CreditLevelServiceHelper.getCreditFilesID(param);
    }

    private static Object getCreditFilesID(Map<String, Object> param) {
        DynamicObject creditInfo = CreditLevelServiceHelper.getCreditInfoByTask(param);
        return creditInfo == null ? null : creditInfo.getPkValue();
    }

    public static void showCreditInfoForm(IFormView view, long userid, String targetContainerNum) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("task_creditfilecontrol");
        parameter.getOpenStyle().setTargetKey(targetContainerNum);
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setHasRight(true);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(USER_ID, userid);
        parameter.setCustomParams(map);
        view.showForm((FormShowParameter)parameter);
    }
}

