/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.servicehelper.rule;

import com.google.common.collect.ArrayListMultimap;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.formula.OutValue;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.js.ErContextFactory;
import kd.fi.er.business.servicehelper.rule.BillSettingRuleInfo;
import kd.fi.er.business.utils.ErAIUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class BillSettingRuleUtil {
    private static Log log = LogFactory.getLog(BillSettingRuleUtil.class);
    private static final ErContextFactory contextFactory = new ErContextFactory();

    public static BillSettingRuleInfo getBillSettingRuleInfo(IDataModel model) {
        DynamicObject company;
        BillSettingRuleInfo billSettingRuleInfo = null;
        String billtype = model.getDataEntityType().getName();
        String controlfield = BillSettingRuleUtil.getControlField(billtype);
        if (controlfield != null && model.getProperty(controlfield) != null && (company = (DynamicObject)model.getValue("company")) != null) {
            Object value = model.getValue(controlfield);
            billSettingRuleInfo = BillSettingRuleInfo.getInstance(controlfield, value, (Long)company.getPkValue(), billtype);
        }
        return billSettingRuleInfo;
    }

    private static String getControlField(String billtype) {
        String controlField;
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"er_setting_group", (String)"controlfield", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)billtype)});
        if (queryOne != null && StringUtils.isNotBlank((CharSequence)(controlField = queryOne.getString("controlfield")))) {
            return controlField;
        }
        String srcBillType = null;
        if (ErEntityTypeUtils.isDailyApplyBill((String)billtype)) {
            srcBillType = "er_dailyapplybill";
        } else if (ErEntityTypeUtils.isDailyReimburseBill((String)billtype)) {
            srcBillType = "er_dailyreimbursebill";
        } else if (ErEntityTypeUtils.isPublicReimburseBill((String)billtype)) {
            srcBillType = "er_publicreimbursebill";
        }
        if (StringUtils.isNotBlank((CharSequence)srcBillType) && !billtype.equals(srcBillType)) {
            return BillSettingRuleUtil.getControlField(srcBillType);
        }
        log.info("{} not exist controlfield", (Object)billtype);
        return null;
    }

    public static BillSettingRuleInfo getBillSettingRuleInfo(DynamicObject dataEntity) {
        DynamicObject company;
        BillSettingRuleInfo billSettingRuleInfo = null;
        String billtype = dataEntity.getDynamicObjectType().getName();
        String controlfield = BillSettingRuleUtil.getControlField(billtype);
        if (dataEntity.getDynamicObjectType().getProperty(controlfield) != null && (company = (DynamicObject)dataEntity.get("company")) != null) {
            Object value = dataEntity.get(controlfield);
            billSettingRuleInfo = BillSettingRuleInfo.getInstance(controlfield, value, (Long)company.getPkValue(), billtype);
        }
        return billSettingRuleInfo;
    }

    public static void setFormTitleForPC(BillSettingRuleInfo billSettingRuleInfo, IFormView view) {
        if (billSettingRuleInfo != null && billSettingRuleInfo.getFormTitle() != null && StringUtils.isNotBlank((CharSequence)billSettingRuleInfo.getFormTitle().getLocaleValue())) {
            view.setFormTitle(new LocaleString(billSettingRuleInfo.getFormTitle().getLocaleValue()));
        }
    }

    public static void setFormTitleForMob(BillSettingRuleInfo billSettingRuleInfo, IFormView view) {
        if (billSettingRuleInfo != null && billSettingRuleInfo.getFormTitle() != null && StringUtils.isNotBlank((CharSequence)billSettingRuleInfo.getFormTitle().getLocaleValue())) {
            view.executeClientCommand("setCaption", new Object[]{billSettingRuleInfo.getFormTitle().getLocaleValue()});
        }
    }

    public static void setFieldNameForPC(BillSettingRuleInfo billSettingRuleInfo, IFormView view) {
        if (billSettingRuleInfo != null) {
            BillSettingRuleUtil.setFieldName(billSettingRuleInfo, view, false);
        }
    }

    private static void setFieldName(BillSettingRuleInfo billSettingRuleInfo, IFormView view, boolean isMob) {
        Map<String, ILocaleString> fieldCaption = billSettingRuleInfo.getFieldCaption();
        for (Map.Entry<String, ILocaleString> entry : fieldCaption.entrySet()) {
            String fieldName = entry.getKey();
            String[] arr = fieldName.split("\\.");
            if (arr.length > 1) {
                EntryGrid entrytGrid = (EntryGrid)view.getControl(arr[0]);
                if (entrytGrid == null) continue;
                if (isMob) {
                    BillSettingRuleUtil.setColumnProperty(view, arr[1], entry.getValue());
                    continue;
                }
                entrytGrid.setColumnProperty(arr[1], "header", (Object)entry.getValue().getLocaleValue());
                continue;
            }
            FieldEdit fieldEdit = (FieldEdit)view.getControl(fieldName);
            if (fieldEdit == null) continue;
            fieldEdit.setCaption(new LocaleString(entry.getValue().getLocaleValue()));
        }
    }

    public static void setFieldNameForMob(BillSettingRuleInfo billSettingRuleInfo, IFormView view) {
        if (billSettingRuleInfo != null) {
            BillSettingRuleUtil.setFieldName(billSettingRuleInfo, view, true);
        }
    }

    private static void setColumnProperty(IFormView view, String field, ILocaleString header) {
        HashMap<String, String> arg = new HashMap<String, String>();
        arg.put("zh_CN", header.getLocaleValue_zh_CN());
        arg.put("en", header.getLocaleValue_en());
        arg.put("zh_TW", header.getLocaleValue_zh_TW());
        HashMap<String, HashMap<String, String>> map = new HashMap<String, HashMap<String, String>>();
        map.put("header", arg);
        view.updateControlMetadata(field, map);
    }

    public static void setFieldHidden(BillSettingRuleInfo billSettingRuleInfo, IFormView view) {
        Long companyid = ErCommonUtils.getPk(view.getModel().getValue("company"));
        String billtype = view.getModel().getDataEntityType().getName();
        ArrayListMultimap<String, String> allHiddenMultiMap = BillSettingRuleInfo.getAllHiddenMultiMap(companyid, billtype);
        ArrayListMultimap<String, String> hiddenMultiMap = null;
        hiddenMultiMap = billSettingRuleInfo != null ? billSettingRuleInfo.getHiddenMultiMap() : ArrayListMultimap.create();
        if (hiddenMultiMap != null) {
            BillSettingRuleUtil.removeFields(allHiddenMultiMap, hiddenMultiMap);
        }
        Set keySet = allHiddenMultiMap.keySet();
        for (String entryName : keySet) {
            List fields = allHiddenMultiMap.get((Object)entryName);
            if (fields.isEmpty()) continue;
            Control control = view.getControl(entryName);
            if (control instanceof CardEntry) {
                ((CardEntry)control).setChildVisible(false, -1, fields.toArray(new String[0]));
                continue;
            }
            view.setVisible(Boolean.valueOf(false), fields.toArray(new String[0]));
        }
        log.info("field hidden:{}", allHiddenMultiMap);
    }

    private static void removeFields(ArrayListMultimap<String, String> allHiddenMultiMap, ArrayListMultimap<String, String> hiddenMultiMap) {
        Set keySet = hiddenMultiMap.keySet();
        for (String entryName : keySet) {
            List hiddenFieldsList = hiddenMultiMap.get((Object)entryName);
            List allHiddenFieldsList = allHiddenMultiMap.get((Object)entryName);
            allHiddenFieldsList.removeAll(hiddenFieldsList);
        }
    }

    public static void setFieldMustInput(BillSettingRuleInfo billSettingRuleInfo, IFormView view) {
        if (billSettingRuleInfo != null) {
            ArrayListMultimap<String, BillSettingRuleInfo.MustInputField> mustInputMultiMap = billSettingRuleInfo.getMustInputMultiMap();
            Set keySet = mustInputMultiMap.keySet();
            for (String entryName : keySet) {
                List fields = mustInputMultiMap.get((Object)entryName);
                if (fields == null) continue;
                for (BillSettingRuleInfo.MustInputField field : fields) {
                    Control fieldEdit = view.getControl(field.getField());
                    if (!(fieldEdit instanceof FieldEdit)) continue;
                    ((FieldEdit)fieldEdit).setMustInput(true);
                }
            }
        }
    }

    public static void setFieldLock(BillSettingRuleInfo billSettingRuleInfo, IFormView view) {
        Map<String, BillSettingRuleInfo.LockConditionInfo> lockMap;
        if (billSettingRuleInfo == null) {
            return;
        }
        Set<String> lockSets = billSettingRuleInfo.getLockSets();
        if (!lockSets.isEmpty()) {
            BillSettingRuleUtil.setEnable(view, false, -1, lockSets.toArray(new String[0]));
        }
        if (!(lockMap = billSettingRuleInfo.getLockMap()).isEmpty()) {
            for (Map.Entry<String, BillSettingRuleInfo.LockConditionInfo> entry : lockMap.entrySet()) {
                String fieldKey = entry.getKey();
                BillSettingRuleInfo.LockConditionInfo lockConditionInfo = entry.getValue();
                BillSettingRuleUtil.doLock(view, fieldKey, lockConditionInfo, -1);
            }
        }
    }

    public static void setFieldLockByExprWhenPropertyChange(BillSettingRuleInfo billSettingRuleInfo, IFormView view, String fieldName, int rowIndex) {
        if (billSettingRuleInfo == null || !billSettingRuleInfo.getEffictiveFields().contains(fieldName) || billSettingRuleInfo.getLockMap().isEmpty()) {
            return;
        }
        List<BillSettingRuleInfo.LockConditionInfo> lockConditionInfos = billSettingRuleInfo.getLockConditionInfosByEffictiveField(fieldName);
        if (!lockConditionInfos.isEmpty()) {
            for (BillSettingRuleInfo.LockConditionInfo lockConditionInfo : lockConditionInfos) {
                String fieldKey = lockConditionInfo.getFieldKey();
                BillSettingRuleUtil.doLock(view, fieldKey, lockConditionInfo, rowIndex);
            }
        }
    }

    private static void doLock(IFormView view, String fieldKey, BillSettingRuleInfo.LockConditionInfo lockConditionInfo, int rowIndex) {
        Control control = view.getControl(fieldKey);
        if (control instanceof FieldEdit) {
            String sourceName = ((FieldEdit)control).getProperty().getParent().getName();
            RowDataModel rowModel = new RowDataModel(sourceName, view.getModel());
            if (((FieldEdit)control).getProperty().getParent() instanceof EntryType) {
                if (rowIndex == -1) {
                    int entryRowCount = view.getModel().getEntryRowCount(sourceName);
                    for (int row = 0; row < entryRowCount; ++row) {
                        BillSettingRuleUtil.entryDoLock(view, fieldKey, lockConditionInfo, sourceName, rowModel, row);
                    }
                } else {
                    BillSettingRuleUtil.entryDoLock(view, fieldKey, lockConditionInfo, sourceName, rowModel, rowIndex);
                }
            } else {
                rowModel.setRowContext(view.getModel().getDataEntity());
                BillSettingRuleUtil.setEnable(view, !BillSettingRuleUtil.exprBoolean(rowModel, lockConditionInfo), 0, fieldKey);
            }
        }
    }

    private static void entryDoLock(IFormView view, String fieldKey, BillSettingRuleInfo.LockConditionInfo lockConditionInfo, String entryName, RowDataModel rowModel, int row) {
        DynamicObject entryRowEntity = view.getModel().getEntryRowEntity(entryName, row);
        rowModel.setRowContext((Object)entryRowEntity, row);
        BillSettingRuleUtil.setEnable(view, !BillSettingRuleUtil.exprBoolean(rowModel, lockConditionInfo), row, fieldKey);
    }

    private static boolean exprBoolean(RowDataModel rowModel, BillSettingRuleInfo.LockConditionInfo lockCondition) {
        Context context = contextFactory.makeContext();
        contextFactory.enterContext(context);
        ScriptableObject prototype = context.initStandardObjects();
        prototype.setParentScope(null);
        Scriptable scope = context.newObject((Scriptable)prototype);
        List effictiveFields = lockCondition.getEffictiveFields();
        String express = lockCondition.getLockconditionexpr();
        for (String field : effictiveFields) {
            OutValue value = new OutValue();
            rowModel.tryGetValue(field, value);
            if (value.get() instanceof Date) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                value.set((Object)df.format(value.get()));
            }
            if (field.contains(".")) {
                String fileldName = field.replace(".", "_");
                express = express.replace(field, fileldName);
                field = fileldName;
            }
            scope.put(field, scope, value.get() == null ? "" : value.get());
        }
        scope.setPrototype((Scriptable)prototype);
        Object result = context.evaluateString(scope, express, null, -1, null);
        return Boolean.TRUE.equals(result);
    }

    private static void setEnable(IFormView view, boolean enable, int rowIndex, String ... ctlKeys) {
        for (String ctlKey : ctlKeys) {
            Control ctl = view.getControl(ctlKey);
            if (!(ctl instanceof FieldEdit)) continue;
            ((FieldEdit)ctl).setEnable("", enable, rowIndex);
        }
    }

    public static String getRealFieldName(String fieldname) {
        int indexOf = fieldname.indexOf(46);
        if (indexOf != -1) {
            return fieldname.substring(indexOf + 1);
        }
        return fieldname;
    }

    public static List<String> checkMustInput(ExtendedDataEntity extendedDataEntity, BillSettingRuleInfo billSettingRuleInfo) {
        ArrayList errorMessage = Lists.newArrayListWithExpectedSize((int)4);
        if (billSettingRuleInfo != null) {
            ArrayListMultimap<String, BillSettingRuleInfo.MustInputField> mustInputMultiMap = billSettingRuleInfo.getMustInputMultiMap();
            Set keySet = mustInputMultiMap.keySet();
            for (String entryName : keySet) {
                List fields = mustInputMultiMap.get((Object)entryName);
                if (fields == null) continue;
                if ("head".equals(entryName)) {
                    BillSettingRuleUtil.checkValue((List<String>)errorMessage, extendedDataEntity.getDataEntity(), (List<BillSettingRuleInfo.MustInputField>)fields);
                    continue;
                }
                if (extendedDataEntity.getDataEntity().getDataEntityType().getName().equals(entryName)) {
                    BillSettingRuleUtil.checkEntry(errorMessage, extendedDataEntity.getDataEntity(), fields);
                    continue;
                }
                DynamicObjectCollection coll = extendedDataEntity.getDataEntity().getDynamicObjectCollection(entryName);
                BillSettingRuleUtil.checkValue((List<String>)errorMessage, coll, (List<BillSettingRuleInfo.MustInputField>)fields);
            }
        }
        return errorMessage;
    }

    private static void checkEntry(List<String> errorMessage, DynamicObject dataEntity, List<BillSettingRuleInfo.MustInputField> fields) {
        for (BillSettingRuleInfo.MustInputField entryname : fields) {
            if (!dataEntity.getDynamicObjectCollection(entryname.getField()).isEmpty()) continue;
            errorMessage.add(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1s\u201d", (String)"FeeStandardControlOp_mustinputentrytips", (String)"fi-er-opplugin", (Object[])new Object[0]), BillSettingRuleUtil.getDisplayName(dataEntity, entryname.getField())));
        }
    }

    private static void checkValue(List<String> errorMessage, DynamicObjectCollection entryentities, List<BillSettingRuleInfo.MustInputField> fields) {
        for (int i = 0; i < entryentities.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryentities.get(i);
            DynamicObjectType type = entry.getDynamicObjectType();
            for (BillSettingRuleInfo.MustInputField field : fields) {
                Object value;
                if (type.getProperty(field.getField()) == null || (value = entry.get(field.getField())) != null && !StringUtils.isEmpty((CharSequence)value.toString()) && (!(value instanceof Number) || 0.0 != ((Number)value).doubleValue())) continue;
                errorMessage.add(String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\uff0c\u8bf7\u586b\u5199\u201c%2s\u201d\u3002", (String)"FeeStandardControlOp_mustinputtips", (String)"fi-er-opplugin", (Object[])new Object[0]), i + 1, StringUtils.isNotBlank((CharSequence)field.getDiyname()) ? field.getDiyname() : BillSettingRuleUtil.getDisplayName(entry, field.getField())));
            }
        }
    }

    private static void checkValue(List<String> errorMessage, DynamicObject dataEntity, List<BillSettingRuleInfo.MustInputField> fields) {
        DynamicObjectType type = dataEntity.getDynamicObjectType();
        for (BillSettingRuleInfo.MustInputField field : fields) {
            Object value;
            if (type.getProperty(field.getField()) == null || (value = dataEntity.get(field.getField())) != null && !StringUtils.isEmpty((CharSequence)value.toString()) && (!(value instanceof Number) || 0.0 != ((Number)value).doubleValue())) continue;
            errorMessage.add(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1s\u201d", (String)"FeeStandardControlOp_mustinputheadtips", (String)"fi-er-opplugin", (Object[])new Object[0]), StringUtils.isNotBlank((CharSequence)field.getDiyname()) ? field.getDiyname() : BillSettingRuleUtil.getDisplayName(dataEntity, field.getField())));
        }
    }

    public static String getDisplayName(DynamicObject entry, String field) {
        DynamicProperty property = entry.getDynamicObjectType().getProperty(field);
        if (property != null) {
            return property.getDisplayName().getLocaleValue();
        }
        return ((DynamicObject)entry.getParent()).getDynamicObjectType().getProperty(field).getDisplayName().getLocaleValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean matchByCondition(DynamicObject bill, DynamicObject entry) {
        try (IFormView view = null;){
            String entityId = bill.getDataEntityType().getName();
            if (bill.getDataEntityState().getFromDatabase()) {
                bill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)entityId);
            }
            view = ErAIUtils.getView((String)entityId);
            RowDataModel rowModel = new RowDataModel(entityId, view.getModel());
            rowModel.setRowContext(bill);
            HashMap map = new HashMap(8);
            boolean bl = BillSettingRuleUtil.exprBoolean(rowModel, new BillSettingRuleInfo.LockConditionInfo("", entry.getString("conditionjs_tag"), entry.getString("condition_tag"), map));
            return bl;
        }
        return false;
    }
}

