/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.share;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.share.ERHandleBeforeShareService;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.CollectorsUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ShareBillService {
    public static void buildDoneEntry(DynamicObject shareBill) {
        String approveTaxFormulaType = ErStdConfig.getApproveTaxFormulaType();
        Object shareMethod = shareBill.get("sharemethod");
        Object shareRule = shareBill.get("sharerule");
        ShareBillService.handThisShareAmount(shareBill);
        DynamicObjectCollection waitEntrys = shareBill.getDynamicObjectCollection("expenseentryentity_wait");
        DataEntityPropertyCollection waitEntryProps = waitEntrys.getDynamicObjectType().getProperties();
        DynamicObjectCollection ruleEntrys = shareBill.getDynamicObjectCollection("expenseentryentity_rule");
        DataEntityPropertyCollection ruleEntryProps = ruleEntrys.getDynamicObjectType().getProperties();
        DynamicObjectCollection doneEntrys = shareBill.getDynamicObjectCollection("expenseentryentity");
        DataEntityPropertyCollection doneEntryProps = doneEntrys.getDynamicObjectType().getProperties();
        int size = waitEntrys.size();
        long[] waitEntryIds = ORM.create().genLongIds("er_expensesharebill", size);
        for (int j = 0; j < size; ++j) {
            DynamicObject waitEntry = (DynamicObject)waitEntrys.get(j);
            if (waitEntry.getPkValue() == null || ((Long)waitEntry.getPkValue()).compareTo(0L) == 0) {
                long waitEntryId = waitEntryIds[j];
                waitEntry.set("id", (Object)waitEntryId);
            }
            DynamicObjectCollection newRuleEntrys = (DynamicObjectCollection)ruleEntrys.clone();
            if ("amount".equalsIgnoreCase(shareMethod.toString()) || "expenseitemrule".equalsIgnoreCase(shareRule.toString())) {
                newRuleEntrys.clear();
                newRuleEntrys.addAll((Collection)ruleEntrys.stream().filter(ruleEntry -> ((Long)waitEntry.getPkValue()).compareTo(ruleEntry.getLong("sharewaitid_comrule")) == 0).collect(Collectors.toList()));
                if (newRuleEntrys == null || newRuleEntrys.size() < 1) {
                    newRuleEntrys.addNew();
                }
            }
            ShareBillService.handlDoneEntry(shareBill, approveTaxFormulaType, waitEntry, waitEntryProps, newRuleEntrys, ruleEntryProps, doneEntrys, doneEntryProps);
            if (j != size - 1) continue;
            ERHandleBeforeShareService.dealAmountTailDifference(doneEntrys, waitEntry, false);
        }
    }

    private static void handThisShareAmount(DynamicObject bill) {
        boolean isAllShare = SystemParamterUtil.isAllShare((Long)ErCommonUtils.getPk(bill.getDynamicObject("company")));
        DynamicObjectCollection ruleEntrys = bill.getDynamicObjectCollection("expenseentryentity_rule");
        BigDecimal totalShareRate = ruleEntrys.stream().map(v -> v.getBigDecimal("sharerate_comrule")).reduce((b1, b2) -> b1.add((BigDecimal)b2)).orElse(BigDecimal.ZERO);
        bill.set("sumsharerate", (Object)totalShareRate);
        int scale = bill.getBigDecimal("sumsharerate") == null ? 4 : bill.getBigDecimal("sumsharerate").scale();
        BigDecimal shareRate = bill.getBigDecimal("sumsharerate").divide(BigDecimal.valueOf(100L), scale + 2, RoundingMode.HALF_EVEN);
        String shareMethod = bill.getString("sharemethod");
        String shareRule = bill.getString("sharerule");
        int precision = bill.getDynamicObject("currency").getInt("amtprecision");
        String approveTaxFormulaType = ErStdConfig.getApproveTaxFormulaType();
        DynamicObjectCollection waitEntrys = bill.getDynamicObjectCollection("expenseentryentity_wait");
        int size = waitEntrys.size();
        ArrayList rateList = Lists.newArrayListWithExpectedSize((int)size);
        for (int j = 0; j < size; ++j) {
            Long expenEntryId;
            Map ruleEntryRateMap;
            DynamicObject waitEntry = (DynamicObject)waitEntrys.get(j);
            int entryPrecision = waitEntry.getDynamicObject("entrycurrency_wait").getInt("amtprecision");
            BigDecimal waitAmount = waitEntry.getBigDecimal("expenseamount_wait");
            BigDecimal waitAmountCurr = waitEntry.getBigDecimal("currexpenseamount_wait");
            BigDecimal waitApproveAmount = waitEntry.getBigDecimal("expeapproveamount_wait");
            BigDecimal waitApproveAmountCurr = waitEntry.getBigDecimal("expeapprovecurramount_w");
            BigDecimal waitTaxAmount = waitEntry.getBigDecimal("taxamount_wait");
            BigDecimal waitNoTaxAmount = waitEntry.getBigDecimal("orientryamount_wait");
            BigDecimal waitApproveTax = waitEntry.getBigDecimal("approvetax_wait");
            BigDecimal waitDeTaxAmount = waitEntry.getBigDecimal("deductibletax_wait");
            BigDecimal waitApproveNoTaxAmount = waitEntry.getBigDecimal("price_wait");
            BigDecimal waitApproveCurrNoTaxAmount = waitEntry.getBigDecimal("curprice_wait");
            BigDecimal waitItemInoutAmount = waitEntry.getBigDecimal("iteminoutamount_wait");
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal amountCurr = BigDecimal.ZERO;
            BigDecimal taxAmount = BigDecimal.ZERO;
            BigDecimal noTaxAmount = BigDecimal.ZERO;
            BigDecimal approveTax = BigDecimal.ZERO;
            BigDecimal approveAmount = BigDecimal.ZERO;
            BigDecimal approveAmountCurr = BigDecimal.ZERO;
            BigDecimal deTaxAmount = BigDecimal.ZERO;
            BigDecimal approveNoTaxAmount = BigDecimal.ZERO;
            BigDecimal approveCurrNoTaxAmount = BigDecimal.ZERO;
            BigDecimal itemInoutAmount = BigDecimal.ZERO;
            if ("avg".equalsIgnoreCase(shareMethod) || "amount".equalsIgnoreCase(shareMethod) || isAllShare) {
                amount = waitAmount;
                amountCurr = waitAmountCurr;
                approveAmount = waitApproveAmount;
                approveAmountCurr = waitApproveAmountCurr;
                taxAmount = waitTaxAmount;
                noTaxAmount = waitNoTaxAmount;
                approveTax = waitApproveTax;
                deTaxAmount = waitDeTaxAmount;
                approveNoTaxAmount = waitApproveNoTaxAmount;
                approveCurrNoTaxAmount = waitApproveCurrNoTaxAmount;
                itemInoutAmount = waitItemInoutAmount;
                if ("rate".equalsIgnoreCase(shareMethod) && "expenseitemrule".equalsIgnoreCase(shareRule)) {
                    ruleEntryRateMap = ruleEntrys.stream().collect(Collectors.groupingBy(ruleEntry -> ruleEntry.getLong("sharewaitid_comrule"), CollectorsUtil.summingBigDecimal(ruleEntry -> ruleEntry.getBigDecimal("sharerate_comrule"))));
                    shareRate = ruleEntryRateMap.get(expenEntryId = ErCommonUtils.getPk(waitEntry.getPkValue())) != null ? ((BigDecimal)ruleEntryRateMap.get(expenEntryId)).divide(BigDecimal.valueOf(100L), scale + 2, RoundingMode.HALF_EVEN) : BigDecimal.valueOf(100L).divide(BigDecimal.valueOf(100L), scale + 2, RoundingMode.HALF_EVEN);
                    rateList.add(shareRate.multiply(BigDecimal.valueOf(100L)));
                }
            } else if ("rate".equalsIgnoreCase(shareMethod) && "expenseitemrule".equalsIgnoreCase(shareRule)) {
                ruleEntryRateMap = ruleEntrys.stream().collect(Collectors.groupingBy(ruleEntry -> ruleEntry.getLong("sharewaitid_comrule"), CollectorsUtil.summingBigDecimal(ruleEntry -> ruleEntry.getBigDecimal("sharerate_comrule"))));
                shareRate = ruleEntryRateMap.get(expenEntryId = ErCommonUtils.getPk(waitEntry.getPkValue())) != null ? ((BigDecimal)ruleEntryRateMap.get(expenEntryId)).divide(BigDecimal.valueOf(100L), scale + 2, RoundingMode.HALF_EVEN) : BigDecimal.valueOf(100L).divide(BigDecimal.valueOf(100L), scale + 2, RoundingMode.HALF_EVEN);
                rateList.add(shareRate.multiply(BigDecimal.valueOf(100L)));
                amount = waitAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                amountCurr = waitAmountCurr.multiply(shareRate).setScale(precision, RoundingMode.HALF_UP);
                approveAmount = waitApproveAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                approveAmountCurr = waitApproveAmountCurr.multiply(shareRate).setScale(precision, RoundingMode.HALF_UP);
                taxAmount = waitTaxAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                approveTax = waitApproveTax.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                deTaxAmount = waitDeTaxAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                itemInoutAmount = waitItemInoutAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
            } else {
                amount = waitAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                amountCurr = waitAmountCurr.multiply(shareRate).setScale(precision, RoundingMode.HALF_UP);
                approveAmount = waitApproveAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                approveAmountCurr = waitApproveAmountCurr.multiply(shareRate).setScale(precision, RoundingMode.HALF_UP);
                taxAmount = waitTaxAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                approveTax = waitApproveTax.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                deTaxAmount = waitDeTaxAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                itemInoutAmount = waitItemInoutAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
            }
            waitEntry.set("this_e_applyamount", (Object)amount);
            waitEntry.set("this_e_currapplyamount", (Object)amountCurr);
            waitEntry.set("this_e_approveamount", (Object)approveAmount);
            waitEntry.set("this_e_approvecurramount", (Object)approveAmountCurr);
            waitEntry.set("this_e_tax", (Object)taxAmount);
            waitEntry.set("this_e_approvetax", (Object)approveTax);
            waitEntry.set("this_e_apporvetax", (Object)deTaxAmount);
            waitEntry.set("this_e_iteminoutamount", (Object)itemInoutAmount);
            if ("avg".equalsIgnoreCase(shareMethod) || "amount".equalsIgnoreCase(shareMethod) || isAllShare) {
                waitEntry.set("this_e_notax", (Object)noTaxAmount);
                waitEntry.set("this_e_approvenotax", (Object)approveNoTaxAmount);
                waitEntry.set("this_e_curprice", (Object)approveCurrNoTaxAmount);
                continue;
            }
            waitEntry.set("this_e_notax", (Object)amount.subtract(taxAmount));
            BigDecimal price = StringUtils.equals((CharSequence)approveTaxFormulaType, (CharSequence)"1") ? approveAmount.subtract(deTaxAmount) : approveAmount.subtract(approveTax);
            waitEntry.set("this_e_approvenotax", (Object)price);
            BigDecimal waitChangeRate = waitEntry.getBigDecimal("exchangerate_wait");
            String detailQuoteType = (String)ObjectUtils.defaultIfNull((Object)waitEntry.getString("expquotetype_wait"), (Object)"0");
            BigDecimal curprice = AmountUtils.getCurrencyAmount((BigDecimal)price, (BigDecimal)waitChangeRate, (int)precision, (String)detailQuoteType);
            waitEntry.set("this_e_curprice", (Object)curprice);
        }
        if ("rate".equalsIgnoreCase(shareMethod) && "expenseitemrule".equalsIgnoreCase(shareRule) && !rateList.isEmpty()) {
            BigDecimal maxRate = (BigDecimal)Collections.max(rateList);
            bill.set("sumsharerate", (Object)maxRate);
        }
    }

    private static void handlDoneEntry(DynamicObject shareBill, String approveTaxFormulaType, DynamicObject waitEntry, DataEntityPropertyCollection waitEntryProps, DynamicObjectCollection ruleEntrys, DataEntityPropertyCollection ruleEntryProps, DynamicObjectCollection doneEntrys, DataEntityPropertyCollection doneEntryProps) {
        BigDecimal this_waitCurprice;
        BigDecimal this_waitItemInOutAmount;
        BigDecimal this_waitDeTaxAmount;
        BigDecimal this_waitApproveTax;
        BigDecimal this_waitTaxAmount;
        BigDecimal this_waitApproveAmountCurr;
        BigDecimal this_waitApproveAmount;
        BigDecimal this_waitAmountCurr;
        BigDecimal this_waitAmount;
        int precision = AmountUtils.getCurrencyPrecision((DynamicObject)shareBill, (String)"currency");
        Object shareRule = shareBill.get("sharerule");
        Object shareMethod = shareBill.get("sharemethod");
        String taxshareway = "1";
        if (shareBill.containsProperty("taxshareway")) {
            taxshareway = shareBill.getString("taxshareway");
        }
        int ruleEntrySize = ruleEntrys.size();
        BigDecimal shareNum = new BigDecimal(ruleEntrySize);
        int entryPrecision = waitEntry.getDynamicObject("entrycurrency_wait").getInt("amtprecision");
        BigDecimal waitAmount = waitEntry.getBigDecimal("expenseamount_wait");
        BigDecimal waitAmountCurr = waitEntry.getBigDecimal("currexpenseamount_wait");
        BigDecimal waitApproveAmount = waitEntry.getBigDecimal("expeapproveamount_wait");
        BigDecimal waitApproveAmountCurr = waitEntry.getBigDecimal("expeapprovecurramount_w");
        BigDecimal waitTaxAmount = waitEntry.getBigDecimal("taxamount_wait");
        BigDecimal waitApproveTax = waitEntry.getBigDecimal("approvetax_wait");
        BigDecimal waitDeTaxAmount = waitEntry.getBigDecimal("deductibletax_wait");
        BigDecimal waitItemInOutAmount = waitEntry.getBigDecimal("iteminoutamount_wait");
        BigDecimal waitCurprice = waitEntry.getBigDecimal("curprice_wait");
        BigDecimal this_balanceWaitAmount = this_waitAmount = waitEntry.getBigDecimal("this_e_applyamount");
        BigDecimal this_balanceWaitAmountCurr = this_waitAmountCurr = waitEntry.getBigDecimal("this_e_currapplyamount");
        BigDecimal this_balanceWaitApproveAmount = this_waitApproveAmount = waitEntry.getBigDecimal("this_e_approveamount");
        BigDecimal this_balanceWaitApproveAmountCurr = this_waitApproveAmountCurr = waitEntry.getBigDecimal("this_e_approvecurramount");
        BigDecimal this_balanceWaitTaxAmount = this_waitTaxAmount = waitEntry.getBigDecimal("this_e_tax");
        BigDecimal this_balanceWaitApproveTax = this_waitApproveTax = waitEntry.getBigDecimal("this_e_approvetax");
        BigDecimal this_balanceWaitDeTaxAmount = this_waitDeTaxAmount = waitEntry.getBigDecimal("this_e_apporvetax");
        BigDecimal this_balanceWaitItemInOutAmount = this_waitItemInOutAmount = waitEntry.getBigDecimal("this_e_iteminoutamount");
        BigDecimal this_balanceWaitCurprice = this_waitCurprice = waitEntry.getBigDecimal("this_e_curprice");
        for (int i = 0; i < ruleEntrys.size(); ++i) {
            BigDecimal approveTax;
            BigDecimal taxAmount;
            BigDecimal approveAmountCurr;
            BigDecimal approveAmount;
            BigDecimal amountCurr;
            BigDecimal amount;
            DynamicObject ruleEntry = (DynamicObject)ruleEntrys.get(i);
            DynamicObject doneEntry = doneEntrys.addNew();
            ArrayList currentRuleProps = new ArrayList();
            ruleEntryProps.forEach(ruleEntryProp -> {
                String ruleEntryPropName = ruleEntryProp.getName();
                doneEntryProps.forEach(doneEntryProp -> {
                    String doneEntryPropName = doneEntryProp.getName();
                    if ((ruleEntryPropName.contains("comrule") || ruleEntryPropName.contains(shareRule.toString()) || ruleEntryPropName.contains("entrycostdept_orgrule") || ruleEntryPropName.contains("entrycostcompany_orgrule") || ruleEntryPropName.contains("entryexpenseitem")) && ruleEntryPropName.contains(doneEntryPropName) && !ruleEntryPropName.contains("id") && !doneEntryPropName.equalsIgnoreCase("seq") && !doneEntryPropName.equalsIgnoreCase("id") && ruleEntry.get(ruleEntryPropName) != null) {
                        doneEntry.set(doneEntryPropName, ruleEntry.get(ruleEntryPropName));
                        currentRuleProps.add(doneEntryPropName);
                    }
                });
            });
            waitEntryProps.forEach(waitEntryProp -> {
                String waitEntryPropName = waitEntryProp.getName();
                doneEntryProps.forEach(doneEntryProp -> {
                    String doneEntryPropName = doneEntryProp.getName();
                    if (!(currentRuleProps.contains(doneEntryPropName) || !waitEntryPropName.contains(doneEntryPropName) || waitEntryPropName.contains("id") || doneEntryPropName.equalsIgnoreCase("seq") || doneEntryPropName.equalsIgnoreCase("id"))) {
                        doneEntry.set(doneEntryPropName, waitEntry.get(waitEntryPropName));
                    }
                });
            });
            if (StringUtils.equals((CharSequence)"expenseitemrule", (CharSequence)String.valueOf(shareRule))) {
                if (((Long)waitEntry.getPkValue()).compareTo(ruleEntry.getLong("sharewaitid_comrule")) == 0) {
                    doneEntry.set("expenseitem", ruleEntry.get("entryexpenseitem"));
                    doneEntry.set("entrycostcompany", ruleEntry.get("entrycostcompany_orgrule"));
                    doneEntry.set("entrycostdept", ruleEntry.get("entrycostdept_orgrule"));
                } else {
                    doneEntry.set("expenseitem", waitEntry.get("expenseitem_wait"));
                    doneEntry.set("entrycostcompany", waitEntry.get("entrycostcompany_wait"));
                    doneEntry.set("entrycostdept", waitEntry.get("entrycostdept_wait"));
                }
            }
            doneEntry.set("sdstd_entrycostcenter", ruleEntry.get("std_entrycostcenter_crule") != null ? ruleEntry.get("std_entrycostcenter_crule") : waitEntry.get("std_entrycostcenter_wait"));
            doneEntry.set("lkwaitentryid", waitEntry.getPkValue());
            doneEntry.set("remark", null);
            BigDecimal deTaxAmount = BigDecimal.ZERO;
            BigDecimal itemInOutAmount = BigDecimal.ZERO;
            BigDecimal curprice = BigDecimal.ZERO;
            if ("avg".equalsIgnoreCase(shareMethod.toString())) {
                amount = waitAmount.divide(shareNum, entryPrecision, RoundingMode.HALF_UP);
                amountCurr = waitAmountCurr.divide(shareNum, precision, RoundingMode.HALF_UP);
                approveAmount = waitApproveAmount.divide(shareNum, entryPrecision, RoundingMode.HALF_UP);
                approveAmountCurr = waitApproveAmountCurr.divide(shareNum, precision, RoundingMode.HALF_UP);
                taxAmount = waitTaxAmount.divide(shareNum, entryPrecision, RoundingMode.HALF_UP);
                approveTax = waitApproveTax.divide(shareNum, entryPrecision, RoundingMode.HALF_UP);
                deTaxAmount = waitDeTaxAmount.divide(shareNum, entryPrecision, RoundingMode.HALF_UP);
                itemInOutAmount = waitItemInOutAmount.divide(shareNum, entryPrecision, RoundingMode.HALF_UP);
                curprice = waitCurprice.divide(shareNum, precision, RoundingMode.HALF_UP);
            } else if ("rate".equalsIgnoreCase(shareMethod.toString())) {
                int scale = doneEntry.getBigDecimal("sharerate").scale();
                BigDecimal shareRate = doneEntry.getBigDecimal("sharerate").divide(BigDecimal.valueOf(100L), scale + 2, RoundingMode.HALF_EVEN);
                amount = waitAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                amountCurr = waitAmountCurr.multiply(shareRate).setScale(precision, RoundingMode.HALF_UP);
                approveAmount = waitApproveAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                approveAmountCurr = waitApproveAmountCurr.multiply(shareRate).setScale(precision, RoundingMode.HALF_UP);
                taxAmount = waitTaxAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                approveTax = waitApproveTax.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                deTaxAmount = waitDeTaxAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                itemInOutAmount = waitItemInOutAmount.multiply(shareRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                curprice = waitCurprice.multiply(shareRate).setScale(precision, RoundingMode.HALF_UP);
            } else {
                BigDecimal waitExchangedRate = waitEntry.getBigDecimal("exchangerate_wait");
                String waitQuoteType = waitEntry.getString("expquotetype_wait");
                if (waitQuoteType == null || StringUtils.isBlank((CharSequence)waitQuoteType)) {
                    waitQuoteType = "1";
                }
                amount = ruleEntry.getBigDecimal("shareamount_comrule").setScale(entryPrecision, RoundingMode.HALF_UP);
                amountCurr = AmountUtils.getCurrencyAmount((BigDecimal)amount, (BigDecimal)waitExchangedRate, (int)precision, (String)waitQuoteType);
                approveAmount = ruleEntry.getBigDecimal("shareappamount_comrule").setScale(entryPrecision, RoundingMode.HALF_UP);
                approveAmountCurr = AmountUtils.getCurrencyAmount((BigDecimal)approveAmount, (BigDecimal)waitExchangedRate, (int)precision, (String)waitQuoteType);
                BigDecimal waitTaxRate = waitEntry.getBigDecimal("taxrate_wait");
                if (waitTaxRate.compareTo(BigDecimal.ZERO) == 0 || "2".equals(taxshareway)) {
                    waitTaxRate = amount.divide(waitAmount, entryPrecision + 4, RoundingMode.HALF_UP);
                    BigDecimal waitApproveTaxRate = approveAmount.divide(waitApproveAmount, entryPrecision + 4, RoundingMode.HALF_UP);
                    taxAmount = waitTaxAmount.multiply(waitTaxRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                    approveTax = waitApproveTax.multiply(waitApproveTaxRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                    deTaxAmount = waitDeTaxAmount.multiply(waitApproveTaxRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                    itemInOutAmount = waitItemInOutAmount.multiply(waitApproveTaxRate).setScale(entryPrecision, RoundingMode.HALF_UP);
                } else {
                    String formulaType;
                    Boolean waitoffset;
                    waitTaxRate = waitTaxRate.divide(BigDecimal.valueOf(100L), entryPrecision + 4, RoundingMode.HALF_UP);
                    taxAmount = amount.multiply(waitTaxRate).divide(BigDecimal.ONE.add(waitTaxRate), entryPrecision + 4, RoundingMode.HALF_UP).setScale(entryPrecision, RoundingMode.HALF_UP);
                    approveTax = approveAmount.multiply(waitTaxRate).divide(BigDecimal.ONE.add(waitTaxRate), entryPrecision + 4, RoundingMode.HALF_UP).setScale(entryPrecision, RoundingMode.HALF_UP);
                    DynamicObject company = shareBill.getDynamicObject("company");
                    Long companyId = null;
                    if (company != null) {
                        companyId = (Long)company.getPkValue();
                    }
                    if ((waitoffset = Boolean.valueOf(waitEntry.getBoolean("offset_wait"))).booleanValue()) {
                        deTaxAmount = SystemParamterUtil.isAmountToDeductibletax((Long)companyId) ? approveTax : taxAmount;
                    }
                    itemInOutAmount = StringUtils.equalsIgnoreCase((CharSequence)(formulaType = ErStdConfig.get((String)"transferouttax.formula")), (CharSequence)"1") ? taxAmount.subtract(deTaxAmount) : approveTax.subtract(deTaxAmount);
                }
            }
            if (i == ruleEntrys.size() - 1) {
                amount = this_balanceWaitAmount;
                amountCurr = this_balanceWaitAmountCurr;
                approveAmount = this_balanceWaitApproveAmount;
                approveAmountCurr = this_balanceWaitApproveAmountCurr;
                taxAmount = this_balanceWaitTaxAmount;
                approveTax = this_balanceWaitApproveTax;
                deTaxAmount = this_balanceWaitDeTaxAmount;
                itemInOutAmount = this_balanceWaitItemInOutAmount;
                curprice = this_balanceWaitCurprice;
            }
            this_balanceWaitAmount = this_balanceWaitAmount.subtract(amount);
            this_balanceWaitAmountCurr = this_balanceWaitAmountCurr.subtract(amountCurr);
            this_balanceWaitApproveAmount = this_balanceWaitApproveAmount.subtract(approveAmount);
            this_balanceWaitApproveAmountCurr = this_balanceWaitApproveAmountCurr.subtract(approveAmountCurr);
            this_balanceWaitTaxAmount = this_balanceWaitTaxAmount.subtract(taxAmount);
            this_balanceWaitApproveTax = this_balanceWaitApproveTax.subtract(approveTax);
            this_balanceWaitDeTaxAmount = this_balanceWaitDeTaxAmount.subtract(deTaxAmount);
            this_balanceWaitItemInOutAmount = this_balanceWaitItemInOutAmount.subtract(itemInOutAmount);
            this_balanceWaitCurprice = this_balanceWaitCurprice.subtract(curprice);
            doneEntry.set("expenseamount", (Object)amount);
            doneEntry.set("currexpenseamount", (Object)amountCurr);
            doneEntry.set("expeapproveamount", (Object)approveAmount);
            doneEntry.set("expeapprovecurramount", (Object)approveAmountCurr);
            doneEntry.set("taxamount", (Object)taxAmount);
            doneEntry.set("orientryamount", (Object)amount.subtract(taxAmount));
            doneEntry.set("approvetax", (Object)approveTax);
            doneEntry.set("deductibletax", (Object)deTaxAmount);
            BigDecimal price = StringUtils.equals((CharSequence)approveTaxFormulaType, (CharSequence)"1") ? approveAmount.subtract(deTaxAmount) : approveAmount.subtract(approveTax);
            doneEntry.set("price", (Object)price);
            doneEntry.set("iteminoutamount", (Object)itemInOutAmount);
            if ("amount".equalsIgnoreCase(shareMethod.toString())) {
                if (i < ruleEntrys.size() - 1) {
                    BigDecimal changeRate = doneEntry.getBigDecimal("exchangerate");
                    String detailQuoteType = (String)ObjectUtils.defaultIfNull((Object)doneEntry.getString("expquotetype"), (Object)"0");
                    curprice = AmountUtils.getCurrencyAmount((BigDecimal)price, (BigDecimal)changeRate, (int)precision, (String)detailQuoteType);
                }
                this_balanceWaitCurprice = this_balanceWaitCurprice.subtract(curprice);
            }
            doneEntry.set("curprice", (Object)curprice);
            if (doneEntry.getDate("entrymonth") == null) continue;
            doneEntry.set("happendate", (Object)doneEntry.getDate("entrymonth"));
        }
    }

    public static boolean checkHasBeforeShareBill(String entityName, Long[] billIds) {
        Long shareBillTableId = EntityMetadataCache.loadTableDefine((String)"er_expensesharebill", (String)"er_expensesharebill").getTableId();
        Map loadBillLinkDownNodes = BFTrackerServiceHelper.loadBillLinkDownNodes((String)entityName, (Long[])billIds, (boolean)true);
        for (Map.Entry mapEntry : loadBillLinkDownNodes.entrySet()) {
            BFRowLinkDownNode downNode = (BFRowLinkDownNode)mapEntry.getValue();
            Map tNodes = downNode.getTNodes();
            for (Map.Entry mapEntry2 : tNodes.entrySet()) {
                Long mainTableId = ((BFRowId)mapEntry2.getKey()).getMainTableId();
                if (!mainTableId.equals(shareBillTableId)) continue;
                return true;
            }
        }
        return false;
    }
}

