/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.dao;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.dao.IErDao;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.trip.annotation.KDTripEntity;
import kd.fi.er.business.trip.dao.IDataHandleDao;
import kd.fi.er.business.trip.exception.TripException;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.ExistDataModel;
import kd.fi.er.business.trip.model.IDataModel;
import kd.fi.er.business.trip.model.OrderExistDataModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripFieldSetValueUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.util.order.TripGetOrderTripIdUtil;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractOrderDao
implements IDataHandleDao {
    private static final Log logger = LogFactory.getLog(AbstractOrderDao.class);
    private IErDao erDao = null;
    private IErDao allOrderdao = null;
    protected OrderExistDataModel existData;

    public void setExistDataModel(ExistDataModel existData) {
        this.existData = (OrderExistDataModel)existData;
    }

    public void generateData(IDataModel dataModel) throws TripException {
        if (dataModel == null) {
            return;
        }
        AbstractOrderModel orderModel = (AbstractOrderModel)dataModel;
        Class<?> orderModelClass = orderModel.getClass();
        KDTripEntity entityName = orderModelClass.getAnnotation(KDTripEntity.class);
        String orderNum = orderModel.getOrderNum();
        if (this.erDao == null) {
            this.erDao = ErDaoFactory.getInstance((String)entityName.name());
        }
        if (Supplier.XIECHENG.getValue().equals(orderModel.getServer()) && orderModel.getChecking().booleanValue() && null != this.existData.getAllCheckingMapping() && !this.existData.getAllCheckingMapping().isEmpty() && null != this.existData.getAllCheckingMapping().get(orderNum) && "C".equals(((DynamicObject)this.existData.getAllCheckingMapping().get(orderNum)).getString("billstatus"))) {
            return;
        }
        HashMap<String, DynamicObject> existOrderMapping = (HashMap<String, DynamicObject>)this.existData.getOrderMapping().get(entityName.name());
        DynamicObject orderDynamic = null;
        BigDecimal totalamount = BigDecimal.ZERO;
        BigDecimal servicefee = BigDecimal.ZERO;
        BigDecimal dealamount = BigDecimal.ZERO;
        if (existOrderMapping != null) {
            orderDynamic = (DynamicObject)existOrderMapping.get(orderNum);
            if (null != orderDynamic) {
                orderModel.setExistOrder(Boolean.TRUE);
                totalamount = orderDynamic.getBigDecimal("totalamount");
                if (orderDynamic.containsProperty("servicefee")) {
                    servicefee = orderDynamic.getBigDecimal("servicefee");
                }
                if (orderDynamic.containsProperty("dealamount")) {
                    dealamount = orderDynamic.getBigDecimal("dealamount");
                }
            } else {
                totalamount = ConvertUtil.getOrderAmountInit();
            }
        } else {
            totalamount = ConvertUtil.getOrderAmountInit();
            existOrderMapping = new HashMap<String, DynamicObject>();
            this.existData.getOrderMapping().put(entityName.name(), existOrderMapping);
        }
        Date now = new Date();
        String userId = RequestContext.get().getUserId();
        if (orderDynamic == null) {
            orderDynamic = this.erDao.getEmptyDynamicObject();
            orderModel.setCreator(userId);
            orderModel.setCreateTime(now);
            existOrderMapping.put(orderNum, orderDynamic);
            if (orderDynamic.containsProperty("reimbursestatus")) {
                orderDynamic.set("reimbursestatus", (Object)"A");
            }
        } else if (orderDynamic.containsProperty("reimbursestatus") && StringUtils.isBlank((String)orderDynamic.getString("reimbursestatus"))) {
            orderDynamic.set("reimbursestatus", (Object)"A");
        }
        orderModel.setModifier(userId);
        orderModel.setModifyTime(now);
        TripFieldSetValueUtil.getInstance().HandleAllClassField(orderDynamic, (Object)orderModel, orderModelClass);
        logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u8ba2\u5355\u8d39\u7528\u627f\u62c5\u90e8\u95e82\uff1a{}", (Object)orderDynamic.getString("expcommitdepnum"));
        if (null != orderModel.getOrderNatrue()) {
            orderDynamic.set("isbusiness", (Object)orderModel.getOrderNatrue().getKey());
        }
        if (null != orderModel.getProductType()) {
            orderDynamic.set("producttype", (Object)orderModel.getProductType().getKey());
        }
        if (null != orderModel.getOperationType() && null != orderModel.getOperationType().getKey()) {
            orderDynamic.set("operationtype", (Object)orderModel.getOperationType().getKey());
        }
        if (null != orderModel.getOrderType() && null != orderModel.getOrderType().getKey()) {
            orderDynamic.set("ordertype", (Object)orderModel.getOrderType().getKey());
        }
        if (orderDynamic.containsProperty("isdeductible")) {
            Map invoiceSetMap = TripCommonUtil.getInvoiceInfoByOperation((String)orderModel.getServer(), (String)orderModel.getOperationType().getKey());
            orderDynamic.set("isdeductible", (Object)Boolean.valueOf((String)invoiceSetMap.get("isdeductible")));
        }
        if (orderDynamic.containsProperty("needbilling")) {
            String producttype_value = orderDynamic.getString("producttype");
            if ("1".equals(producttype_value)) {
                orderDynamic.set("needbilling", (Object)true);
            } else if ("2".equals(producttype_value)) {
                orderDynamic.set("needbilling", (Object)false);
            }
        }
        if (Supplier.XIECHENG.getValue().equals(orderModel.getServer()) && !orderModel.getChecking().booleanValue()) {
            orderDynamic.set("totalamount", (Object)totalamount);
            if (orderDynamic.containsProperty("servicefee")) {
                orderDynamic.set("servicefee", (Object)servicefee);
            }
            if (orderDynamic.containsProperty("dealamount")) {
                orderDynamic.set("dealamount", (Object)dealamount);
            }
        }
        this.handleOrderCurrency(orderDynamic);
        this.handleIndividrualData(orderModel, orderDynamic);
        this.handleReqbillRelectedField(orderDynamic, orderModel, entityName);
        this.handleAllOrder(orderDynamic, orderModel, orderNum);
    }

    protected abstract void handleIndividrualData(AbstractOrderModel var1, DynamicObject var2);

    private void handleReqbillRelectedField(DynamicObject orderDynamic, AbstractOrderModel orderModel, KDTripEntity entityName) throws TripException {
        DynamicObject mealapplication;
        String oabillnum = orderModel.getOaBillNum();
        DynamicObject reqObject = null;
        if (null != oabillnum && !oabillnum.trim().isEmpty() && (reqObject = (DynamicObject)this.existData.getReqbillMapping().get(oabillnum)) != null) {
            this.firstSetDept(orderDynamic, orderModel, reqObject);
            Object tripPK = TripGetOrderTripIdUtil.getOrderTripId((String)entityName.name(), (DynamicObject)orderDynamic, (DynamicObjectCollection)reqObject.getDynamicObjectCollection("tripentry"));
            orderDynamic.set("tripid", tripPK);
            if (null != tripPK) {
                String tripPKStr = String.valueOf(tripPK);
                DynamicObjectCollection tripEntry = reqObject.getDynamicObjectCollection("tripentry");
                for (DynamicObject entry : tripEntry) {
                    String entryPk = String.valueOf(ErCommonUtils.getPk(entry));
                    if (!StringUtils.equals((String)entryPk, (String)tripPKStr) || !entry.containsProperty("std_project")) continue;
                    orderDynamic.set("std_project", entry.get("std_project"));
                    break;
                }
            }
            return;
        }
        DynamicObject dailyObject = null;
        if (null != oabillnum && !oabillnum.trim().isEmpty() && reqObject == null) {
            dailyObject = (DynamicObject)this.existData.getDailyApplybillMapping().get(oabillnum);
            this.firstSetDept(orderDynamic, orderModel, dailyObject);
        }
        DynamicObject vehicleObject = null;
        if (entityName.name().equals("er_vehiclebill") && null != oabillnum && !oabillnum.trim().isEmpty()) {
            vehicleObject = (DynamicObject)this.existData.getDailyVehicleBillMapping().get(oabillnum);
            if (vehicleObject != null) {
                this.firstSetDept(orderDynamic, orderModel, vehicleObject);
                if (vehicleObject.containsProperty("headproject")) {
                    orderDynamic.set("std_project", vehicleObject.get("headproject"));
                }
                return;
            }
        } else if (entityName.name().equals("er_mealbill") && null != oabillnum && !oabillnum.trim().isEmpty() && (mealapplication = (DynamicObject)this.existData.getMealApplyBillMapping().get(oabillnum)) != null) {
            this.firstSetDept(orderDynamic, orderModel, mealapplication);
            if (mealapplication.containsProperty("headproject")) {
                orderDynamic.set("std_project", mealapplication.get("headproject"));
            }
            return;
        }
        if (!TripSyncConfigUtil.getBoolean("trip_sync_orderbill_isverify_mustinput") || entityName.name().equals("er_vehiclebill") || entityName.name().equals("er_mealbill")) {
            if (orderDynamic.get("sourcebookedid") == null) {
                logger.info("\u5546\u65c5\u96c6\u6210,\u8ba2\u5355\u6ca1\u6709\u51fa\u5dee\u7533\u8bf7\u5355\u65f6,\u9884\u8ba2\u4eba\u4e3a\u7a7a.");
                return;
            }
            this.firstSetDept(orderDynamic, orderModel, null);
            return;
        }
        if (TripSyncConfigUtil.getBoolean("trip_sync_orderbill_isverify_mustinput")) {
            throw new TripException(String.format("%1$s%2%s", ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u7684\u7533\u8bf7\u5355\uff1a", (String)"AbstractOrderDao_0", (String)"fi-er-business", (Object[])new Object[0]), oabillnum));
        }
    }

    private void firstSetDept(DynamicObject orderDynamic, AbstractOrderModel orderModel, DynamicObject dynamicObject) {
        String server = orderModel.getServer();
        if (null != dynamicObject) {
            orderDynamic.set("bookeddept", (Object)dynamicObject.getDynamicObject("org"));
            if (orderDynamic.containsProperty("company")) {
                orderDynamic.set("company", (Object)dynamicObject.getDynamicObject("company"));
            }
            if (orderDynamic.getDynamicObjectType().getProperties().containsKey((Object)"bookedcompany")) {
                orderDynamic.set("bookedcompany", (Object)dynamicObject.getDynamicObject("company"));
            }
            if (!Supplier.CHAILVYIHAO.name().equals(server) || orderDynamic.get("expcommitcomnum") == null) {
                orderDynamic.set("expcommitcomnum", dynamicObject.get("costcompany"));
            }
            if (!Supplier.CHAILVYIHAO.name().equals(server) || orderDynamic.get("expcommitdepnum") == null) {
                orderDynamic.set("expcommitdepnum", dynamicObject.get("costdept"));
            }
            if (orderDynamic.containsProperty("std_costcenter") && orderDynamic.get("std_costcenter") == null) {
                orderDynamic.set("std_costcenter", dynamicObject.get("std_costcenter"));
            }
            if (Supplier.CHAILVYIHAO.name().equals(server) && orderModel.getExpcommitdepnumDym() != null) {
                orderDynamic.set("expcommitdepnum", (Object)orderModel.getExpcommitdepnumDym());
            }
            if (Supplier.CHAILVYIHAO.name().equals(server) && orderModel.getExpcommitcomnumDym() != null) {
                orderDynamic.set("expcommitcomnum", (Object)orderModel.getExpcommitcomnumDym());
            }
        } else {
            DynamicObject std_costcenter;
            Long accountId;
            if (orderModel.getExpcommitdepnumDym() != null) {
                orderDynamic.set("expcommitdepnum", (Object)orderModel.getExpcommitdepnumDym());
            }
            if (orderModel.getExpcommitcomnumDym() != null) {
                orderDynamic.set("expcommitcomnum", (Object)orderModel.getExpcommitcomnumDym());
            }
            Long bookerId = null;
            DynamicProperty bookerProp = orderDynamic.getDynamicObjectType().getProperty("sourcebookedid");
            bookerId = bookerProp instanceof BasedataProp ? (orderDynamic.get("sourcebookedid") instanceof Long ? Long.valueOf(orderDynamic.getLong("sourcebookedid")) : ErCommonUtils.getPk(orderDynamic.getDynamicObject("sourcebookedid"))) : Long.valueOf(orderDynamic.getLong("sourcebookedid"));
            DynamicObject dept = this.getDept(bookerId);
            logger.info(String.format("\u5546\u65c5\u96c6\u6210\uff0c\u8ba2\u5355\u8d39\u7528\u627f\u62c5\u516c\u53f8.\u90e8\u95e8 IS_MUST_SIGN sourcebookedid:%1$s dept:%2$s", bookerId, dept));
            if (null == dept) {
                return;
            }
            orderDynamic.set("bookeddept", (Object)dept);
            Map companyfromOrg = OrgUnitServiceHelper.getCompanyfromOrg((Object)dept.getPkValue());
            logger.info("\u5546\u65c5\u96c6\u6210,\u90e8\u95e8\u6240\u5c5e\u516c\u53f8\u6570\u636e:{}", (Object)companyfromOrg);
            if (null != companyfromOrg) {
                if (orderDynamic.containsProperty("company") && null == orderDynamic.get("company")) {
                    orderDynamic.set("company", companyfromOrg.get("id"));
                }
                if (orderDynamic.getDynamicObjectType().getProperties().containsKey((Object)"bookedcompany")) {
                    orderDynamic.set("bookedcompany", companyfromOrg.get("id"));
                }
            }
            if (orderDynamic.get("expcommitdepnum") == null) {
                orderDynamic.set("expcommitdepnum", (Object)dept);
            }
            if (orderDynamic.get("expcommitcomnum") == null && null != (accountId = CoreBaseBillServiceHelper.getAccountOrgId((Long)((Long)dept.getPkValue()), (Boolean)true))) {
                DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((Object)accountId, (String)"bos_org");
                orderDynamic.set("expcommitcomnum", (Object)account);
            }
            if (orderDynamic.get("std_costcenter") == null && null != (std_costcenter = ErCostCenterUtil.getCostCenterByCostDept((Long)((Long)dept.getPkValue())))) {
                orderDynamic.set("std_costcenter", (Object)std_costcenter);
            }
        }
    }

    private void handleOrderCurrency(DynamicObject orderDynamic) {
        Object o = ActionLocalCache.get().get("AbstractOrderDao.currency", (Object)"currency", () -> {
            String server = orderDynamic.getString("server");
            DynamicObject erBizInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"er_biz_info", (String)"id, checkingcurrency", (QFilter[])new QFilter("number", "=", (Object)server).toArray());
            if (erBizInfo == null) {
                return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)1L)});
            }
            return erBizInfo.getDynamicObject("checkingcurrency");
        });
        orderDynamic.set("currency", o == null ? BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)1L)}) : o);
    }

    private void handleAllOrder(DynamicObject orderDynamic, AbstractOrderModel orderModel, String orderNum) {
        DynamicObject reqObject;
        DynamicObject allOrderDynamic;
        if (this.allOrderdao == null) {
            this.allOrderdao = ErDaoFactory.getInstance((String)"er_allorderbill");
        }
        if ((allOrderDynamic = (DynamicObject)this.existData.getAllOrderMapping().get(orderNum)) == null) {
            allOrderDynamic = this.allOrderdao.getEmptyDynamicObject();
            this.existData.getAllOrderMapping().put(orderNum, allOrderDynamic);
        }
        DynamicObjectType dynamicObjectType = orderDynamic.getDynamicObjectType();
        String tableName = dynamicObjectType.getAlias();
        Long orderId = (Long)orderDynamic.getPkValue();
        if (orderId == null || orderId == 0L) {
            Long id = DBServiceHelper.genLongIds((String)tableName, (int)1)[0];
            orderDynamic.set("id", (Object)id);
            orderId = id;
        }
        String formID = dynamicObjectType.getName();
        DataEntityPropertyCollection orderProperties = dynamicObjectType.getProperties();
        DataEntityPropertyCollection allOrderProperties = allOrderDynamic.getDynamicObjectType().getProperties();
        for (IDataEntityProperty orderProperty : allOrderProperties) {
            String orderPropName = orderProperty.getName();
            if ("id".equals(orderPropName) || orderProperties.get((Object)orderPropName) == null) continue;
            allOrderDynamic.set(orderPropName, orderDynamic.get(orderPropName));
        }
        allOrderDynamic.set("orderformid", (Object)formID);
        allOrderDynamic.set("orderid", (Object)orderId);
        allOrderDynamic.set("uniqueid", (Object)orderModel.getUniqueId());
        logger.info("\u5f53\u524d\u8ba2\u5355\u603b\u8868\u6570\u636eID:" + allOrderDynamic.getPkValue());
        String oabillnum = orderModel.getOaBillNum();
        DynamicObject[] vehicleBill = BusinessDataServiceHelper.load((String)"er_dailyvehiclebill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)oabillnum)});
        if (vehicleBill != null && vehicleBill.length > 0) {
            DynamicObject dynamicObject = vehicleBill[0];
            allOrderDynamic.set("billauditstatus", (Object)("E".equals(dynamicObject.get("billstatus")) ? ResManager.loadKDString((String)"\u5ba1\u6838\u901a\u8fc7", (String)"AbstractOrderDao_1", (String)"fi-er-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5ba1\u6838\u672a\u901a\u8fc7", (String)"AbstractOrderDao_2", (String)"fi-er-business", (Object[])new Object[0])));
        }
        if ((reqObject = (DynamicObject)this.existData.getReqbillMapping().get(oabillnum)) != null) {
            allOrderDynamic.set("dept", reqObject.get("org"));
        } else if (!TripSyncConfigUtil.getBoolean("trip_sync_orderbill_isverify_mustinput") && reqObject == null) {
            DynamicObject dept = this.getDept(ErCommonUtils.getPk(orderDynamic.get("sourcebookedid")));
            allOrderDynamic.set("dept", (Object)dept);
        }
    }

    protected DynamicObject getDept(Long travelUserPkValue) {
        Map userMap = CommonServiceHelper.getUserMap((Long)travelUserPkValue);
        if (userMap != null && userMap.size() > 0) {
            DynamicObject dept = (DynamicObject)userMap.get("org");
            return dept;
        }
        return null;
    }

    protected void handleAccountOrg(DynamicObject travelUser, DynamicObject orderDynamic) {
        String oabillnum = orderDynamic.getString("oabillnum");
        DynamicObject reqObject = (DynamicObject)this.existData.getReqbillMapping().get(oabillnum);
        DynamicObject dept = this.getDept((Long)travelUser.getPkValue());
        logger.info(String.format("\u5546\u65c5\u96c6\u6210\u8d39\u7528\u627f\u62c5\u90e8\u95e8.\u516c\u53f8\uff1a%1$s %2$s", orderDynamic.get("expcommitdepnum"), orderDynamic.get("expcommitcomnum")));
        if (reqObject == null && orderDynamic.get("expcommitdepnum") == null && dept != null) {
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u6ca1\u6709\u51fa\u5dee\u7533\u8bf7\u5355\uff0c\u4e14\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u4e3a\u7a7a\uff0c\u5219\u4f18\u5148\u53d6\u4e58\u673a\u4eba\u6240\u5728\u90e8\u95e8 {}", orderDynamic.get("expcommitdepnum"));
            orderDynamic.set("expcommitdepnum", (Object)dept);
        }
        if (reqObject == null && orderDynamic.get("expcommitcomnum") == null && dept != null) {
            Long accountId = CoreBaseBillServiceHelper.getAccountOrgId((Long)((Long)dept.getPkValue()), (Boolean)true);
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u6ca1\u6709\u51fa\u5dee\u7533\u8bf7\u5355\uff0c\u4e14\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff0c\u5219\u4f18\u5148\u53d6\u4e58\u673a\u4eba\u6240\u5728\u90e8\u95e8\u6838\u7b97\u4e3b\u4f53 {}", orderDynamic.get("expcommitcomnum"));
            if (null != accountId) {
                DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((Object)accountId, (String)"bos_org");
                orderDynamic.set("expcommitcomnum", (Object)account);
            }
        }
        if (reqObject == null && orderDynamic.get("std_costcenter") == null && dept != null) {
            DynamicObject std_costcenter = ErCostCenterUtil.getCostCenterByCostDept((Long)((Long)dept.getPkValue()));
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u6ca1\u6709\u51fa\u5dee\u7533\u8bf7\u5355\uff0c\u4e14\u6210\u672c\u4e2d\u5fc3\u4e3a\u7a7a\uff0c\u5219\u4f18\u5148\u53d6\u4e58\u673a\u4eba\u6240\u5728\u90e8\u95e8\u6838\u7b97\u4e3b\u4f53 {}", orderDynamic.get("std_costcenter"));
            if (null != std_costcenter) {
                orderDynamic.set("std_costcenter", (Object)std_costcenter);
            }
        }
    }
}

