/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.service.function;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.ExistDataModel;
import kd.fi.er.business.trip.model.HotelOrderModel;
import kd.fi.er.business.trip.model.MealOrderModel;
import kd.fi.er.business.trip.model.OrderExistDataModel;
import kd.fi.er.business.trip.model.PlaneOrderModel;
import kd.fi.er.business.trip.model.TrainOrderModel;
import kd.fi.er.business.trip.model.VehicleOrderModel;
import kd.fi.er.business.trip.service.function.template.InPutFunctionTemp;
import kd.fi.er.business.trip.service.validate.Validate;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractOrderInvoke<T>
extends InPutFunctionTemp {
    private static final Log logger = LogFactory.getLog(AbstractOrderInvoke.class);

    public AbstractOrderInvoke() {
    }

    public AbstractOrderInvoke(Map params) {
        super(params);
    }

    protected String supplier() {
        return null;
    }

    protected String function() {
        return "orderInvoke";
    }

    protected void saveInfos(Object infos) {
        logger.info("\u5546\u65c5\u96c6\u6210,\u8ba2\u5355\u4fdd\u5b58,start");
        List orders = (List)infos;
        if (orders == null || orders.size() == 0) {
            return;
        }
        AtomicInteger i = new AtomicInteger(0);
        logger.info("\u5546\u65c5\u96c6\u6210,\u8ba2\u5355\u4fdd\u8ba2\u5355\u6570\u91cf\uff1a", (Object)orders.size());
        int intValue = TripSyncConfigUtil.getIntValue("trip_sync_order_size", 100);
        ArrayList partition = new ArrayList(Lists.partition((List)orders, (int)intValue));
        for (List abstractOrderModels : partition) {
            i.getAndAdd(1);
            this.saveOrders(abstractOrderModels);
            logger.info("\u5206\u6279\u6b21\u4fdd\u5b58\uff1a\u7b2c+" + i.get() + "\u6279\u6b21\u4fdd\u5b58\u7ed3\u675f");
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u8ba2\u5355\u4fdd\u5b58,end");
    }

    private void saveOrders(Object infos) {
        OrderExistDataModel model;
        block24: {
            List orders = (List)infos;
            if (orders == null || orders.size() == 0) {
                return;
            }
            if (TripSyncConfigUtil.getBoolean("trip_sync_orderbill_isverify_mustinput")) {
                StringBuilder message = new StringBuilder();
                for (AbstractOrderModel order : orders) {
                    if (Supplier.XIECHENG.name().equalsIgnoreCase(order.getServer()) && "er_planebill".equalsIgnoreCase(order.getBillFormId())) break;
                    Validate result = order.validate();
                    if (result.result.success) continue;
                    message.append(order.getOrderNum()).append(':').append(result.result.message.toString());
                }
                if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6821\u9a8c\u51fa\u9519:%s", (String)"AbstractOrderInvoke_0", (String)"fi-er-business", (Object[])new Object[0]), message));
                }
            }
            this.validateBeforeSave(orders);
            model = new OrderExistDataModel();
            String lockKey = "fi.er.trip.order" + ((AbstractOrderModel)orders.get(0)).getOrderNum();
            try (DLock dLock = DLock.create((String)lockKey);){
                boolean isLock = dLock.tryLock(30000L);
                if (isLock) {
                    this.judgeIfContinue(orders);
                    for (AbstractOrderModel orderModel : orders) {
                        orderModel.addExistDataFilter((ExistDataModel)model);
                    }
                    model.query();
                    for (AbstractOrderModel orderModel : orders) {
                        orderModel.generateData();
                    }
                    this.handleBeforeSave(model.getOrderMapping());
                    model.save();
                    break block24;
                }
                logger.info(String.format("\u5c1d\u8bd5\u83b7\u53d6\u9501\u5931\u8d25%s\u3002", lockKey));
                throw new KDBizException(ResManager.loadKDString((String)"\u5c1d\u8bd5\u83b7\u53d6\u9501\u5931\u8d25\u3002", (String)"AbstractOrderInvoke_1", (String)"fi-er-business", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error("\u5546\u65c5\u96c6\u6210,\u8ba2\u5355\u4fdd\u5b58,\u5931\u8d25:", (Throwable)e);
                throw e;
            }
            finally {
                this.clearCachOrdersByError(orders);
            }
        }
        this.handleAfterSave(model.getOrderMapping());
    }

    protected void validateBeforeSave(List<? extends AbstractOrderModel> orders) {
    }

    protected void handleBeforeSave(Map<String, Map<String, DynamicObject>> orderMapping) {
    }

    protected void handleAfterSave(Map<String, Map<String, DynamicObject>> orderMapping) {
    }

    public void handlePlaneOrderExtCovert(PlaneOrderModel planeOrderModel, JSONObject planeOrderJsonInfo) {
    }

    public void handlePlaneOrderExtCovert(List<AbstractOrderModel> planeOrderModels, JSONObject planeOrderJsonInfo) {
    }

    public void handleHotelOrderExtCovert(HotelOrderModel hotelOrderModel, JSONObject hotelOrderJsonInfo) {
    }

    public void handleHotelOrderExtCovert(List<AbstractOrderModel> hotelOrderModels, JSONObject hotelOrderJsonInfo) {
    }

    public void handleCarOrderExtCovert(VehicleOrderModel carOrderModel, JSONObject carOrderJsonInfo) {
    }

    public void handleCarOrderExtCovert(List<AbstractOrderModel> carOrderModels, JSONObject carOrderJsonInfo) {
    }

    public void handleTrainOrderExtCovert(TrainOrderModel trainOrderModel, JSONObject trainOrderJsonInfo) {
    }

    public void handleMealOrderExtCovert(MealOrderModel mealOrderModel, JSONObject mealOrderJsonInfo) {
    }

    protected void handleQueryParamsExt(String url, JSONObject jsonObject, Map<String, Object> map) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void judgeIfContinue(List<? extends AbstractOrderModel> orders) {
        DistributeSessionlessCache distributeSessionlessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String lockKey = "fi.er.trip.judgeIfContinue";
        DLock dLock = DLock.create((String)lockKey);
        dLock.lock();
        String[] existOrderNums = distributeSessionlessCache.getList("existOrderNums");
        ArrayList<String> existOrderNumsList = new ArrayList<String>(Arrays.asList(existOrderNums));
        Set orderNumSet = orders.stream().map(AbstractOrderModel::getOrderNum).collect(Collectors.toSet());
        try {
            HashSet<String> existOrderNumsSet = new HashSet<String>(existOrderNumsList);
            Iterator iterator = orderNumSet.iterator();
            HashSet needRemoveOrderNums = Sets.newHashSetWithExpectedSize((int)16);
            logger.info("\u8fdb\u5165\u5224\u65ad{}", (Object)existOrderNumsSet.size());
            while (iterator.hasNext()) {
                String orderNum = (String)iterator.next();
                if (existOrderNumsSet.remove(orderNum)) {
                    needRemoveOrderNums.add(orderNum);
                    continue;
                }
                existOrderNumsSet.add(orderNum);
            }
            if (CollectionUtils.isNotEmpty((Collection)needRemoveOrderNums)) {
                Set needRemoveOrders = orders.stream().map(AbstractOrderModel::getOrderNum).filter(needRemoveOrderNums::contains).collect(Collectors.toSet());
                Iterator<? extends AbstractOrderModel> newIterator = orders.iterator();
                while (newIterator.hasNext()) {
                    AbstractOrderModel next = newIterator.next();
                    String orderNum = next.getOrderNum();
                    if (!needRemoveOrders.contains(orderNum)) continue;
                    newIterator.remove();
                }
            }
            if (CollectionUtils.isNotEmpty(existOrderNumsSet)) {
                distributeSessionlessCache.remove("existOrderNums");
                distributeSessionlessCache.addList("existOrderNums", existOrderNumsSet.toArray(new String[existOrderNumsSet.size()]), 3600000);
            } else {
                distributeSessionlessCache.remove("existOrderNums");
            }
        }
        catch (Exception ex) {
            logger.error("\u5224\u65ad\u8ba2\u5355\u662f\u5426\u7ee7\u7eed\u5904\u7406\u5931\u8d25:", (Throwable)ex);
        }
        finally {
            dLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCachOrdersByError(List<? extends AbstractOrderModel> orders) {
        String lockKey = "fi.er.trip.clearCachOrdersByError";
        DLock dLock = DLock.create((String)lockKey);
        try {
            DistributeSessionlessCache distributeSessionlessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
            String[] existOrderNums = distributeSessionlessCache.getList("existOrderNums");
            ArrayList<String> existOrderNumsList = new ArrayList<String>(Arrays.asList(existOrderNums));
            Set orderNumSet = orders.stream().map(AbstractOrderModel::getOrderNum).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(existOrderNumsList)) {
                existOrderNumsList.removeAll(orderNumSet);
            }
            if (CollectionUtils.isNotEmpty(existOrderNumsList)) {
                distributeSessionlessCache.remove("existOrderNums");
                distributeSessionlessCache.addList("existOrderNums", existOrderNumsList.toArray(new String[existOrderNumsList.size()]), 3600000);
            } else {
                distributeSessionlessCache.remove("existOrderNums");
            }
        }
        catch (Exception ex) {
            logger.error("\u4e1a\u52a1\u903b\u8f91\u6267\u884c\u5b8c\u540e\u6e05\u7f13\u5b58\u62a5\u9519:", (Throwable)ex);
        }
        finally {
            dLock.unlock();
        }
    }
}

