/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.trip.supplier.travelno1.invoke.order;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.trip.model.AbstractOrderModel;
import kd.fi.er.business.trip.model.HotelOrderModel;
import kd.fi.er.business.trip.model.MealOrderModel;
import kd.fi.er.business.trip.model.PlaneOrderModel;
import kd.fi.er.business.trip.model.TrainOrderModel;
import kd.fi.er.business.trip.model.VehicleOrderModel;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.supplier.travelno1.systemexternal.TTripPropMapping;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.trip.v2.utils.TripDataDealUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;

public class TTripOrderCommonConvert {
    private static String splitSign = "-";
    private static Log logger = LogFactory.getLog(TTripOrderCommonConvert.class);

    public static void buildOrderCommonData(AbstractOrderModel orderModel, JSONObject orderJson) {
        BigDecimal productRealClearingMoney;
        orderModel.setServer(Supplier.CHAILVYIHAO.name());
        orderModel.setOrderDate(TripCommonUtil.convertToDate((String)orderJson.getString("tradeTime")));
        orderModel.setOrderNum(orderJson.getString("orderId"));
        orderModel.setOrderType(TTripPropMapping.getOrderTypeEnumByKey((String)orderJson.getString("productSubTypeName")));
        orderModel.setOaBillNum(orderJson.getString("corporationApplyNo"));
        orderModel.setOperationType(TTripPropMapping.getOperationTypeEnumByKey((String)orderJson.getString("productType")));
        orderModel.setOrderSort("2".equalsIgnoreCase(orderJson.getString("productType")) || "4".equalsIgnoreCase(orderJson.getString("productType")) ? AbstractOrderModel.OrderSort.B : AbstractOrderModel.OrderSort.A);
        orderModel.setProductType(TTripPropMapping.getPayTypeEnumByKey((String)orderJson.getString("payType")));
        orderModel.setOrderNatrue("1".equalsIgnoreCase(orderJson.getString("travelType")) ? AbstractOrderModel.OrderNatrue.A : AbstractOrderModel.OrderNatrue.B);
        orderModel.setSourceBookedId(orderJson.getString("orderUserOutStaffNo"));
        String travelerNo = orderJson.getString("passengerOutStaffNo");
        String travelerNmae = orderJson.getString("passengersName");
        String joinNO = StringUtils.isNotBlank((CharSequence)travelerNo) ? travelerNo : travelerNmae;
        BigDecimal bigDecimal = productRealClearingMoney = orderJson.getBigDecimal("productRealClearingMoney") == null ? BigDecimal.ZERO : orderJson.getBigDecimal("productRealClearingMoney");
        if (orderModel instanceof PlaneOrderModel) {
            ((PlaneOrderModel)orderModel).setSourcetravelerid(travelerNo);
            ((PlaneOrderModel)orderModel).setTravelername(travelerNmae);
            orderModel.setServiceFeePaytype((String)TTripPropMapping.payTypeMap().get(orderJson.getString("serveFeePayType")));
            orderModel.setPersonalFee(productRealClearingMoney);
        }
        if (orderModel instanceof HotelOrderModel) {
            ((HotelOrderModel)orderModel).setSourceTravelerId(travelerNo);
            ((HotelOrderModel)orderModel).setTravelerName(travelerNmae);
            orderModel.setServiceFeePaytype((String)TTripPropMapping.payTypeMap().get(orderJson.getString("serveFeePayType")));
            orderModel.setPersonalFee(productRealClearingMoney);
        }
        if (orderModel instanceof VehicleOrderModel) {
            ((VehicleOrderModel)orderModel).setPasseger(travelerNo);
            ((VehicleOrderModel)orderModel).setPassegername(travelerNmae);
            orderModel.setServiceFeePaytype((String)TTripPropMapping.payTypeMap().get(orderJson.getString("serveFeePayType")));
            orderModel.setPersonalFee(productRealClearingMoney);
        }
        if (orderModel instanceof TrainOrderModel) {
            ((TrainOrderModel)orderModel).setPasseger(travelerNo);
            ((TrainOrderModel)orderModel).setPassegername(travelerNmae);
            orderModel.setServiceFeePaytype((String)TTripPropMapping.payTypeMap().get(orderJson.getString("serveFeePayType")));
            orderModel.setPersonalFee(productRealClearingMoney);
        }
        if (orderModel instanceof MealOrderModel) {
            orderModel.setServiceFeePaytype((String)TTripPropMapping.payTypeMap().get(orderJson.getString("serveFeePayType")));
            orderModel.setPersonalFee(productRealClearingMoney);
            joinNO = orderJson.getString("orderUserOutStaffNo");
        }
        BigDecimal totalAmount = orderJson.getBigDecimal("orderMoney").subtract(productRealClearingMoney);
        orderModel.setTotalAmount(totalAmount);
        orderModel.setOrderNum(orderModel.getOrderNum() + splitSign + joinNO);
        orderModel.setUniqueId(TripDataDealUtils.getValue(orderJson, "keyId", "", String::new));
        String parentNumStr = orderJson.getString("originalOrderId");
        if (StringUtils.isNotBlank((CharSequence)parentNumStr)) {
            orderModel.setParentOrderNum(parentNumStr + splitSign + joinNO);
            orderModel.setOriOrderNum(parentNumStr + splitSign + joinNO);
        }
        if (orderModel.getOrderType() == AbstractOrderModel.OrderType.O && StringUtils.isBlank((CharSequence)orderModel.getParentOrderNum())) {
            orderModel.setParentOrderNum(orderModel.getOrderNum());
            orderModel.setOriOrderNum(orderModel.getOrderNum());
        }
        orderModel.setHappendDate(TripCommonUtil.convertToDate((String)orderJson.getString("tradeTime")));
        TTripOrderCommonConvert.queryAndBuildCostOrg(orderModel, orderJson.getString("settleSubjectNumber"), orderJson.getString("costCenterCode"));
    }

    private static void queryAndBuildCostOrg(AbstractOrderModel orderModel, String costcompanyNo, String costdeptNo) {
        if (StringUtils.isNotBlank((CharSequence)costcompanyNo) || StringUtils.isNotBlank((CharSequence)costdeptNo)) {
            boolean isTtrpReqSyncId = TripSyncConfigUtil.getBoolean("ttrip_issyncorg_num");
            QFilter noFilter = null;
            if (isTtrpReqSyncId) {
                ArrayList<String> orgNos = new ArrayList<String>();
                orgNos.add(costcompanyNo);
                orgNos.add(costdeptNo);
                noFilter = new QFilter("number", "in", orgNos);
            } else {
                ArrayList<Long> orgIds = new ArrayList<Long>();
                if (NumberUtils.isNumber((String)costcompanyNo)) {
                    orgIds.add(Long.parseLong(costcompanyNo));
                }
                if (NumberUtils.isNumber((String)costdeptNo)) {
                    orgIds.add(Long.parseLong(costdeptNo));
                }
                if (CollectionUtils.isEmpty(orgIds)) {
                    ArrayList<String> orgNos = new ArrayList<String>();
                    orgNos.add(costcompanyNo);
                    orgNos.add(costdeptNo);
                    noFilter = new QFilter("number", "in", orgNos);
                } else {
                    noFilter = new QFilter("id", "in", orgIds);
                }
            }
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u5dee\u65c5\u58f9\u53f7\uff0c\u8ba2\u5355\u8d39\u7528\u627f\u62c5\u516c\u53f8\uff1a{}\uff0c\u8d39\u7528\u627f\u62c5\u90e8\u95e8\uff1a{}", (Object)costcompanyNo, (Object)costdeptNo);
            QFilter[] qFilters = new QFilter[]{noFilter};
            Map costOrgDO = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id, number", (QFilter[])qFilters);
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u5dee\u65c5\u58f9\u53f7\uff0c\u8ba2\u5355\u8d39\u7528\u627f\u62c5\u516c\u53f8\uff1a{}", (Object)costOrgDO);
            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u5dee\u65c5\u4e00\u53f7\uff0c{},{}", (Object)isTtrpReqSyncId);
            if (costOrgDO != null && costOrgDO.size() > 0) {
                costOrgDO.forEach((key, value) -> {
                    if (NumberUtils.isNumber((String)costdeptNo) && NumberUtils.isNumber((String)costcompanyNo)) {
                        if (isTtrpReqSyncId) {
                            if (value != null && value.get("number") != null && StringUtils.isNotBlank((CharSequence)costcompanyNo) && value.getString("number").equalsIgnoreCase(costcompanyNo)) {
                                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u5dee\u65c5\u4e00\u53f7\uff0c1 costcompanyNo {},{}", (Object)costcompanyNo, (Object)value.getString("number"));
                                orderModel.setExpcommitcomnum(value.getPkValue().toString());
                                orderModel.setExpcommitcomnumDym((DynamicObject)value);
                            }
                            if (value != null && value.get("number") != null && StringUtils.isNotBlank((CharSequence)costdeptNo) && value.getString("number").equalsIgnoreCase(costdeptNo)) {
                                logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u5dee\u65c5\u4e00\u53f7\uff0c1 costdeptNo {},{}", (Object)costdeptNo, (Object)value.getString("number"));
                                orderModel.setExpcommitdepnum(value.getPkValue().toString());
                                orderModel.setExpcommitdepnumDym((DynamicObject)value);
                            }
                        } else {
                            if (value != null && value.getPkValue() != null && StringUtils.isNotBlank((CharSequence)costcompanyNo) && ((Long)value.getPkValue()).compareTo(Long.parseLong(costcompanyNo)) == 0) {
                                orderModel.setExpcommitcomnum(value.getPkValue().toString());
                                orderModel.setExpcommitcomnumDym((DynamicObject)value);
                            }
                            if (value != null && value.getPkValue() != null && StringUtils.isNotBlank((CharSequence)costdeptNo) && ((Long)value.getPkValue()).compareTo(Long.parseLong(costdeptNo)) == 0) {
                                orderModel.setExpcommitdepnum(value.getPkValue().toString());
                                orderModel.setExpcommitdepnumDym((DynamicObject)value);
                            }
                        }
                    } else {
                        if (value != null && value.get("number") != null && StringUtils.isNotBlank((CharSequence)costcompanyNo) && value.getString("number").equalsIgnoreCase(costcompanyNo)) {
                            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u5dee\u65c5\u4e00\u53f7\uff0ccostcompanyNo {},{}", (Object)costcompanyNo, (Object)value.getString("number"));
                            orderModel.setExpcommitcomnum(value.getPkValue().toString());
                            orderModel.setExpcommitcomnumDym((DynamicObject)value);
                        }
                        if (value != null && value.get("number") != null && StringUtils.isNotBlank((CharSequence)costdeptNo) && value.getString("number").equalsIgnoreCase(costdeptNo)) {
                            logger.info("\u5546\u65c5\u96c6\u6210\uff0c\u5dee\u65c5\u4e00\u53f7\uff0ccostdeptNo {},{}", (Object)costdeptNo, (Object)value.getString("number"));
                            orderModel.setExpcommitdepnum(value.getPkValue().toString());
                            orderModel.setExpcommitdepnumDym((DynamicObject)value);
                        }
                    }
                });
            }
        }
    }
}

