/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.fi.er.business.daily.reimburse.AmountObject;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.daily.reimburse.topublic.AccountInfo;
import kd.fi.er.business.daily.reimburse.topublic.PublicReimbursePayerAcctUtils;
import kd.fi.er.business.daily.service.model.CurrencyBO;
import kd.fi.er.business.expand.ErExpandServiceFacade;
import kd.fi.er.business.ext.enums.ErExtcaseEnum;
import kd.fi.er.business.ext.helper.ErExtHelper;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.log.LogUtils;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.BillsFieldNameMappingUtils;
import kd.fi.er.business.utils.CalculateTripSumUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.ReceiveEntryPropChange;
import kd.fi.er.business.utils.ReimburseUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.model.ChangeField;
import kd.fi.er.common.field.writeoffmoney.TripReimburseWriteOffFields;
import kd.fi.er.formplugin.daily.web.util.WriteOffMoneyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class AmountChangeUtil {
    private static final Log logger = LogFactory.getLog(AmountChangeUtil.class);

    public void entryChange() {
    }

    public void tripEntryChange() {
    }

    public static void loanClearEntryChange(IFormView view, IDataModel dataModel, String loanType) {
        if (loanType.equals("1")) {
            AmountChangeUtil.changeOffMoneyByOriCurrcy(view, dataModel);
        } else if (loanType.equals("2")) {
            AmountChangeUtil.changeOffMoneyByStandardCurrcy(view, dataModel);
        }
    }

    private static void changeOffMoneyByStandardCurrcy(IFormView view, IDataModel dataModel) {
        BillsFieldNameMappingUtils.loanClearEntryCheck((IFormView)view);
        String loanClearKey = BillsFieldNameMappingUtils.loanClearKey;
        String checkAmtOriKey = BillsFieldNameMappingUtils.checkAmtOriKey;
        String checkAmtKey = BillsFieldNameMappingUtils.checkAmtKey;
        String loanBalanceOriAmtkey = BillsFieldNameMappingUtils.loanBalanceOriAmtkey;
        String loanBalanceAmtkey = BillsFieldNameMappingUtils.loanBalanceAmtkey;
        BigDecimal approveReimburseAmount = (BigDecimal)dataModel.getValue("approveamount");
        BigDecimal monthsettleAmount = (BigDecimal)dataModel.getValue("monthsettleamount");
        approveReimburseAmount = approveReimburseAmount.subtract(monthsettleAmount);
        DynamicObjectCollection loanClearEntrys = dataModel.getEntryEntity(loanClearKey);
        for (int i = 0; i < loanClearEntrys.size(); ++i) {
            DynamicObject loanClearEntry = (DynamicObject)loanClearEntrys.get(i);
            if (approveReimburseAmount.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal clearLoanAmount = loanClearEntry.getBigDecimal(loanBalanceAmtkey);
                if (clearLoanAmount.compareTo(approveReimburseAmount) > 0) {
                    dataModel.setValue(checkAmtKey, (Object)approveReimburseAmount, i);
                } else {
                    dataModel.setValue(checkAmtKey, (Object)clearLoanAmount, i);
                }
                approveReimburseAmount = approveReimburseAmount.subtract(clearLoanAmount);
                if (approveReimburseAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    approveReimburseAmount = BigDecimal.ZERO;
                }
            } else {
                dataModel.setValue(checkAmtKey, (Object)BigDecimal.ZERO, i);
            }
            BigDecimal loanClearAmount = loanClearEntry.getBigDecimal(checkAmtKey);
            if (loanClearAmount.compareTo(loanClearEntry.getBigDecimal(loanBalanceAmtkey)) == 0) {
                dataModel.setValue(checkAmtOriKey, (Object)loanClearEntry.getBigDecimal(loanBalanceOriAmtkey), i);
                continue;
            }
            BigDecimal loanClearExchageRate = loanClearEntry.getBigDecimal("loanexchangerate");
            if (loanClearExchageRate == null || loanClearExchageRate.compareTo(BigDecimal.ZERO) == 0) {
                loanClearExchageRate = BigDecimal.ONE;
            }
            int precision = AmountUtils.getAmountFieldPrecision((DynamicObject)loanClearEntry, (String)checkAmtOriKey);
            String quoteType = dataModel.getProperty("loanentryquotetype") == null ? "0" : (String)loanClearEntry.get("loanentryquotetype");
            BigDecimal loanamount = "0".equals(quoteType) ? loanClearAmount.divide(loanClearExchageRate, precision, RoundingMode.HALF_UP) : loanClearAmount.multiply(loanClearExchageRate).setScale(precision, RoundingMode.HALF_UP);
            dataModel.beginInit();
            dataModel.setValue(checkAmtOriKey, (Object)loanamount, i);
            dataModel.endInit();
            view.updateView(checkAmtOriKey, i);
        }
    }

    private static void changeOffMoneyByOriCurrcy(IFormView view, IDataModel dataModel) {
        BillsFieldNameMappingUtils.loanClearEntryCheck((IFormView)view);
        String entryKey = BillsFieldNameMappingUtils.entryKey;
        String loanClearKey = BillsFieldNameMappingUtils.loanClearKey;
        String loanClearCurrencyKey = BillsFieldNameMappingUtils.loanClearCurrencyKey;
        String checkAmtOriKey = BillsFieldNameMappingUtils.checkAmtOriKey;
        String loanBalanceOriAmtkey = BillsFieldNameMappingUtils.loanBalanceOriAmtkey;
        DynamicObjectCollection entrys = dataModel.getEntryEntity(entryKey);
        DynamicObjectCollection loanClearEntrys = dataModel.getEntryEntity(loanClearKey);
        Map expcurApproveAmountMap = AmountUtils.groupByCurrency((DynamicObjectCollection)entrys, (String)"entryentity", (String)"entrycurrency", (String)"orientryappamount");
        for (Map.Entry entry : expcurApproveAmountMap.entrySet()) {
            if (loanClearEntrys.size() <= 0) continue;
            DynamicObject loanClearEntry = (DynamicObject)loanClearEntrys.get(0);
            String loanClearCurrencyId = null;
            if (loanClearEntry != null && loanClearEntry.get(loanClearCurrencyKey) != null && ((DynamicObject)loanClearEntry.get(loanClearCurrencyKey)).getPkValue() != null) {
                loanClearCurrencyId = ((DynamicObject)loanClearEntry.get(loanClearCurrencyKey)).getPkValue().toString();
            }
            if (loanClearEntrys.size() == 1) {
                if (((String)entry.getKey()).equals(loanClearCurrencyId)) {
                    if (((BigDecimal)entry.getValue()).compareTo(loanClearEntry.getBigDecimal(loanBalanceOriAmtkey)) > 0) {
                        dataModel.setValue(checkAmtOriKey, (Object)loanClearEntry.getBigDecimal(loanBalanceOriAmtkey), 0);
                        entry.setValue(((BigDecimal)entry.getValue()).subtract(loanClearEntry.getBigDecimal(loanBalanceOriAmtkey)));
                    } else {
                        dataModel.setValue(checkAmtOriKey, entry.getValue(), 0);
                        entry.setValue(BigDecimal.ZERO);
                    }
                } else if (!expcurApproveAmountMap.containsKey(loanClearCurrencyId)) {
                    dataModel.setValue(checkAmtOriKey, (Object)BigDecimal.ZERO, 0);
                }
            }
            if (loanClearEntrys.size() <= 1) continue;
            for (int rowIndex = 0; rowIndex < loanClearEntrys.size(); ++rowIndex) {
                String loanEntryCurrency = null;
                if (loanClearEntrys.get(rowIndex) != null && ((DynamicObject)loanClearEntrys.get(rowIndex)).getDynamicObject(loanClearCurrencyKey) != null && ((DynamicObject)loanClearEntrys.get(rowIndex)).getDynamicObject(loanClearCurrencyKey).getPkValue() != null) {
                    loanEntryCurrency = ((DynamicObject)loanClearEntrys.get(rowIndex)).getDynamicObject(loanClearCurrencyKey).getPkValue().toString();
                }
                DynamicObject loanEntry = (DynamicObject)loanClearEntrys.get(rowIndex);
                if (((String)entry.getKey()).equals(loanEntryCurrency)) {
                    if (((BigDecimal)entry.getValue()).compareTo(loanEntry.getBigDecimal(loanBalanceOriAmtkey)) > 0) {
                        dataModel.setValue(checkAmtOriKey, (Object)loanEntry.getBigDecimal(loanBalanceOriAmtkey), rowIndex);
                        entry.setValue(((BigDecimal)entry.getValue()).subtract(loanEntry.getBigDecimal(loanBalanceOriAmtkey)));
                        continue;
                    }
                    dataModel.setValue(checkAmtOriKey, entry.getValue(), rowIndex);
                    entry.setValue(BigDecimal.ZERO);
                    continue;
                }
                if (expcurApproveAmountMap.containsKey(loanEntryCurrency)) continue;
                dataModel.setValue(checkAmtOriKey, (Object)BigDecimal.ZERO, rowIndex);
            }
        }
    }

    public static AmountObject refreshPayAmount(IFormView view, IDataModel dataModel, String loanType) {
        DynamicObject dataEntity = dataModel.getDataEntity(true);
        BigDecimal payAmount = AmountChangeUtil.calculatePayAmount(dataEntity, loanType);
        Object invokeExtService = ErExpandServiceFacade.get().invokeExtService("ext.service.er.payamountCalc", "payamountCalc", new Object[]{dataModel, loanType, BigDecimal.ZERO, payAmount}, new Class[]{BillModel.class, String.class, BigDecimal.class, BigDecimal.class});
        String encashAmtKey = TripReimburseWriteOffFields.getInstance().encashAmtKey;
        if (invokeExtService == null || "-1".equals(invokeExtService)) {
            dataModel.setValue(encashAmtKey, (Object)payAmount.max(BigDecimal.ZERO));
            return new AmountObject(BigDecimal.ZERO, payAmount.max(BigDecimal.ZERO));
        }
        AmountObject extResult = (AmountObject)invokeExtService;
        dataModel.setValue(encashAmtKey, (Object)extResult.getCurrAmount().max(BigDecimal.ZERO));
        return extResult;
    }

    public static BigDecimal calculatePayAmount(DynamicObject dataEntity, String writeOffType) {
        BigDecimal payAmount;
        String entryKey = TripReimburseWriteOffFields.getInstance().entryKey;
        String loanClearKey = TripReimburseWriteOffFields.getInstance().loanClearKey;
        String loanClearCurrencyKey = TripReimburseWriteOffFields.getInstance().loanClearCurrencyKey;
        String approveAmtKey = TripReimburseWriteOffFields.getInstance().approveAmtKey;
        String checkAmtOriKey = TripReimburseWriteOffFields.getInstance().checkAmtOriKey;
        String checkAmtKey = TripReimburseWriteOffFields.getInstance().checkAmtKey;
        BigDecimal monthsettleamount = BigDecimal.ZERO;
        if (dataEntity.getDataEntityType().getProperties().get((Object)"monthsettleamount") != null) {
            monthsettleamount = dataEntity.getBigDecimal("monthsettleamount");
        }
        DynamicObjectCollection loanClearEntries = dataEntity.getDynamicObjectCollection(loanClearKey);
        if (WriteOffTypeEnum.ORGI_WO.getValue().equals(writeOffType) && loanClearEntries.size() > 0) {
            String approveAmtOriKey = "orientryappamount";
            approveAmtKey = "entryappamount";
            String entryCurrencyKey = "entrycurrency";
            String entryExchangerateKey = "exchangerate";
            String entryQuoteTypeKey = "detailquotetype";
            Map expeCurrcyAmount = AmountUtils.groupByCurrencyToObject((DynamicObjectCollection)dataEntity.getDynamicObjectCollection(entryKey), (String)"entryentity", (String)approveAmtOriKey, (String)approveAmtKey, (String)entryCurrencyKey, (String)entryExchangerateKey, (String)entryQuoteTypeKey);
            Map loanClearCurrencyAmount = AmountUtils.groupByCurrency((DynamicObjectCollection)loanClearEntries, (String)loanClearCurrencyKey, (String)checkAmtOriKey);
            for (Map.Entry entry : expeCurrcyAmount.entrySet()) {
                for (Map.Entry loanClearCurrencyEnrty : loanClearCurrencyAmount.entrySet()) {
                    if (!((String)entry.getKey()).equals(loanClearCurrencyEnrty.getKey())) continue;
                    AmountObject amount = (AmountObject)entry.getValue();
                    amount.setOrgiAmount(amount.getOrgiAmount().subtract((BigDecimal)loanClearCurrencyEnrty.getValue()));
                    entry.setValue(amount);
                }
            }
            int currencyPrecision = AmountUtils.getCurrencyPrecision((DynamicObject)dataEntity, (String)"currency");
            payAmount = expeCurrcyAmount.entrySet().stream().map(v -> AmountUtils.getCurrencyAmount((BigDecimal)((AmountObject)v.getValue()).getOrgiAmount(), (BigDecimal)((AmountObject)v.getValue()).getExchangeRate(), (int)currencyPrecision, (String)((AmountObject)v.getValue()).getQuoteType())).reduce((a1, a2) -> a1.add((BigDecimal)a2)).orElse(BigDecimal.ZERO).subtract(monthsettleamount);
        } else {
            BigDecimal entryAmount = AmountUtils.getEntryAmount((DynamicObjectCollection)dataEntity.getDynamicObjectCollection(entryKey), (String)approveAmtKey);
            BigDecimal loanClearAmount = AmountUtils.getEntryAmount((DynamicObjectCollection)loanClearEntries, (String)checkAmtKey);
            payAmount = entryAmount.subtract(loanClearAmount).subtract(monthsettleamount);
        }
        return payAmount;
    }

    public static void refreshReceiveAmount(IFormView view, IDataModel dataModel, BigDecimal encashAmount, String loanType) {
        block4: {
            int count;
            block3: {
                String isgetaccountcurrency;
                block5: {
                    isgetaccountcurrency = "0";
                    if (dataModel.getValue("company") != null) {
                        isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)dataModel.getValue("company")).getPkValue()));
                    }
                    count = dataModel.getEntryRowCount("accountentry");
                    if (encashAmount.compareTo(BigDecimal.ZERO) < 0) break block3;
                    if (count > 1) break block4;
                    Object currentUser = dataModel.getValue("applier");
                    if (count != 0 || currentUser == null) break block5;
                    dataModel.beginInit();
                    int index = dataModel.createNewEntryRow("accountentry");
                    dataModel.endInit();
                    view.updateView("accountentry");
                    RowDataEntity row = new RowDataEntity(index, dataModel.getEntryRowEntity("accountentry", index));
                    AfterAddRowEventArgs e = new AfterAddRowEventArgs(new EntryProp(), new RowDataEntity[]{row});
                    PayeeServiceHelper.defualtCurrencySetting((AfterAddRowEventArgs)e, (IDataModel)dataModel, (IFormView)view);
                    AmountChangeUtil.setReciveAmount(view, dataModel, encashAmount, loanType);
                    break block4;
                }
                if (!"0".equals(isgetaccountcurrency) && (!"1".equals(isgetaccountcurrency) || dataModel.getValue("accountcurrency", 0) == null)) break block4;
                AmountChangeUtil.setReciveAmount(view, dataModel, encashAmount, loanType);
                break block4;
            }
            if (count > 0) {
                for (int i = count - 1; i >= 0; --i) {
                    dataModel.deleteEntryRow("accountentry", i);
                }
            }
        }
    }

    public static void setReciveAmount(IFormView view, IDataModel dataModel, BigDecimal encashAmount, String loanType) {
        if (dataModel.getEntryRowCount("accountentry") == 0) {
            return;
        }
        WriteOffMoneyUtils.setReciveAmount((BigDecimal)BigDecimal.ZERO, (BigDecimal)encashAmount, (IDataModel)dataModel, (String)loanType, (IFormView)view);
        ErExtHelper.invokeMutiParamsExpandPlugin((ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_AFTERCHANGE_RECIVEAMOUNT, (Object[])new Object[]{dataModel, loanType});
    }

    public static Map<String, Object> getCurrencyPayerAndParam(IDataModel model, int rowIndex, Long reimburserId) {
        HashMap<String, Object> exchangeMap = new HashMap<String, Object>();
        String isgetaccountcurrency = "0";
        if (model.getValue("company") != null) {
            isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)model.getValue("company")).getPkValue()));
        }
        if (isgetaccountcurrency.equals("1")) {
            DynamicObject account = PayeeServiceHelper.getDefaultAccount((Long)reimburserId);
            Long tragCurrency = ErCommonUtils.getPk(account.get("currency") == null ? null : account.get("currency"));
            exchangeMap = AmountChangeUtil.getCurrentEntryExchangeRate(tragCurrency, model);
            exchangeMap.put("currencyId", tragCurrency);
        } else {
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            exchangeMap.put("currencyId", currency.getPkValue());
            exchangeMap.put("exchangeRate", BigDecimal.ONE);
        }
        return exchangeMap;
    }

    public static Map<String, Object> getCurrencyByParamentForInit(IFormView view, IDataModel model, String isgetaccountcurrency) {
        Long tragCurrency = null;
        Map<String, Object> exchangeMap = new HashMap<String, Object>();
        if (ErEntityTypeUtils.isPrePayBill((String)view.getEntityId()) || ErEntityTypeUtils.isPublicReimburseBill((String)view.getEntityId())) {
            String billpayertype = (String)model.getValue("billpayertype");
            DynamicObject billpayer = (DynamicObject)model.getValue("billpayerid");
            if (billpayer != null) {
                switch (billpayertype) {
                    case "bd_supplier": 
                    case "bd_customer": {
                        AccountInfo accountInfo = PublicReimbursePayerAcctUtils.getPayerDefaultInfo((String)billpayertype, (Long)((Long)billpayer.getPkValue()));
                        if (accountInfo == null) break;
                        tragCurrency = ErCommonUtils.getPk(accountInfo.getCurrency() == null ? ErCommonUtils.getPk(model.getValue("currency")) : accountInfo.getCurrency());
                        break;
                    }
                    case "bos_user": {
                        List defaultAccts = PayeeServiceHelper.getOtherDefaultAccountByPayerID((Long)((Long)billpayer.getPkValue()), (Object)model.getDataEntity().getPkValue(), (boolean)false);
                        if (defaultAccts.size() <= 0) break;
                        Long l = tragCurrency = ((DynamicObject)defaultAccts.get(0)).get("currency") == null ? ErCommonUtils.getPk(model.getValue("currency")) : (Long)((DynamicObject)((DynamicObject)defaultAccts.get(0)).get("currency")).getPkValue();
                    }
                }
            }
            if (tragCurrency == null) {
                tragCurrency = ErCommonUtils.getPk(model.getValue("currency"));
            }
        } else {
            Object currentUser = model.getValue("applier");
            DynamicObject payer = PayeeServiceHelper.getDefaultAccount((Long)Long.valueOf(((DynamicObject)currentUser).getPkValue().toString()));
            tragCurrency = "1".equals(isgetaccountcurrency) && payer != null ? ErCommonUtils.getPk(payer.get("currency") == null ? null : payer.get("currency")) : ErCommonUtils.getPk(model.getValue("currency"));
        }
        if (tragCurrency != null) {
            exchangeMap = AmountChangeUtil.getCurrentEntryExchangeRate(tragCurrency, model);
            exchangeMap.put("currencyId", tragCurrency);
        }
        return exchangeMap;
    }

    public static void iscurrencyChangeSetAccInfo(IDataModel model, IFormView view, Map<String, Object> exchangeMap, String isgetaccountcurrency) {
        if ("1".equals(isgetaccountcurrency) && !exchangeMap.isEmpty() && model.getEntryEntity("accountentry").size() == 1) {
            String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeMap.get("quoteType")), (Object)"0");
            BigDecimal accchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeMap.get("exchangeRate")), (Object)BigDecimal.ONE);
            model.setValue("accquotetype", (Object)quoteType, 0);
            model.setValue("accexchangerate", (Object)accchangeRate, 0);
            model.setValue("accountcurrency", exchangeMap.get("currencyId"), 0);
            model.setValue("orireceiveamount", (Object)BigDecimal.ZERO, 0);
            model.setValue("receiveamount", (Object)BigDecimal.ZERO, 0);
            ErCommonUtils.updateView(view, 0, "accexchangerate", "accountcurrency", "accquotetype");
        }
    }

    @Deprecated
    public static boolean judgeReceiveCurrency(IFormView view, IDataModel dataModel, String loanType) {
        return WriteOffMoneyUtils.judgeReceiveCurrency((IDataModel)dataModel, (String)loanType, (boolean)false);
    }

    public static void showPayAmountLable(IDataModel dataModel, Label encashamountlabel, String payAmountKey) {
        BigDecimal payAmount = (BigDecimal)dataModel.getValue(payAmountKey);
        String currencySign = "";
        int amountPrecition = AmountUtils.getCurrencyPrecision((IDataModel)dataModel, (String)"currency");
        DynamicObject currency = (DynamicObject)dataModel.getValue("currency");
        if (currency != null) {
            currencySign = currency.getString("sign");
            amountPrecition = currency.getInt("amtprecision");
            payAmount = payAmount.setScale(amountPrecition, RoundingMode.HALF_UP);
        }
        String formatMoneyByUser = AmountUtils.formatMoneyByUser((Long)Long.valueOf(RequestContext.get().getUserId()), (String)currencySign, (int)amountPrecition, (BigDecimal)payAmount);
        if (encashamountlabel != null) {
            encashamountlabel.setText(formatMoneyByUser);
        }
    }

    @Deprecated
    public static BigDecimal refreshEnrtyExchangeRate(IDataModel model, IFormView view, int rowIndex, DynamicObject entryCurrency) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (model.getValue("currency") == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"AmountChangeUtil_1", (String)"fi-er-business", (Object[])new Object[0]));
        }
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        DynamicObject company = (DynamicObject)model.getValue("company");
        DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
        if (entryCurrency != null && currency != null && company != null) {
            Long srcCurrencyId = (Long)entryCurrency.getPkValue();
            Long targetCurrencyId = (Long)currency.getPkValue();
            Map exchangeRateFromSysParams = CommonServiceHelper.getExchangeRateFromSysParams((Object)company, (Object)costCompany, (Long)srcCurrencyId, (Long)targetCurrencyId, (Object)model);
            exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeRateFromSysParams.get("exchangeRate")), (Object)BigDecimal.ONE);
        }
        return exchangeRate;
    }

    public static Map<String, Object> refreshEnrtyExchangeRate(IDataModel model, IFormView view, DynamicObject entryCurrency) {
        if (model.getValue("currency") == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"AmountChangeUtil_1", (String)"fi-er-business", (Object[])new Object[0]));
        }
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        DynamicObject company = (DynamicObject)model.getValue("company");
        DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
        if (entryCurrency != null && currency != null && company != null) {
            Long srcCurrencyId = (Long)entryCurrency.getPkValue();
            Long targetCurrencyId = (Long)currency.getPkValue();
            return CommonServiceHelper.getExchangeRateFromSysParams((Object)ErCommonUtils.getPk(company), (Object)costCompany, (Long)srcCurrencyId, (Long)targetCurrencyId, (Object)model);
        }
        return new HashMap<String, Object>(2);
    }

    public static void refreshEntryAmount(IDataModel model, String entryField, String oriAmountField, String amountField, String exchangeRateField, int rowIndex) {
        int rowNum;
        if (rowIndex == -1) {
            rowIndex = 0;
        }
        if ((rowNum = model.getEntryRowCount(entryField)) == 0) {
            return;
        }
        BigDecimal oriAmount = (BigDecimal)model.getValue(oriAmountField, rowIndex);
        BigDecimal exchangeRate = (BigDecimal)model.getValue(exchangeRateField, rowIndex);
        if (exchangeRate == null) {
            exchangeRate = BigDecimal.ONE;
        }
        BigDecimal amount = oriAmount.multiply(exchangeRate).setScale(AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"currency"), 5);
        model.setValue(amountField, (Object)amount, rowIndex);
    }

    public static void refreshCurrencyShowInTripEntryAmount(IFormView view, IDataModel model, DynamicObject curTripentry) {
        if (ThreadCache.exists((Object)"reimIsPushVar")) {
            return;
        }
        DynamicObject currency = curTripentry.getDynamicObject("tripcurrency");
        BigDecimal exchangeRate = curTripentry.getBigDecimal("tripexchangerate");
        String tripQuoteType = (String)ObjectUtils.defaultIfNull((Object)curTripentry.getString("tripquotetype"), (Object)"0");
        DynamicObjectCollection tripEntrys = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
        int currentTripIndex = model.getEntryCurrentRowIndex("tripentry");
        for (int tripIndex = 0; tripIndex < tripEntrys.size(); ++tripIndex) {
            DynamicObject tripEntry = (DynamicObject)tripEntrys.get(tripIndex);
            DynamicObject curCurrency = (DynamicObject)model.getValue("tripcurrency", tripIndex);
            if (ErCommonUtils.getPk(curCurrency) == null || ErCommonUtils.getPk(currency) == null || ErCommonUtils.getPk(curCurrency).compareTo(ErCommonUtils.getPk(currency)) != 0) continue;
            if (AmountChangeUtil.isReimTripEntryNotRuned(tripIndex)) {
                model.setValue("tripcurrency", (Object)currency, tripIndex);
                logger.info("tripexchangerate:" + exchangeRate + ";tripIndex:" + tripIndex + ";");
                model.setValue("tripexchangerate", (Object)exchangeRate, tripIndex);
                model.setValue("tripquotetype", (Object)tripQuoteType, tripIndex);
            }
            DynamicObjectCollection entrys = tripEntry.getDynamicObjectCollection("entryentity");
            model.setEntryCurrentRowIndex("tripentry", tripIndex);
            for (int entryIndex = 0; entryIndex < entrys.size(); ++entryIndex) {
                if (!AmountChangeUtil.isReimTripEntryEntiryNotRuned(tripIndex, entryIndex)) continue;
                model.setValue("entrycurrency", (Object)currency, entryIndex, tripIndex);
                logger.info("exchangerate:" + exchangeRate + ";entryIndex:" + entryIndex + ";tripIndex:" + tripIndex);
                model.setValue("exchangerate", (Object)exchangeRate, entryIndex, tripIndex);
                model.setValue("detailquotetype", (Object)tripQuoteType, entryIndex, tripIndex);
                DataEntityPropertyCollection entryProCollection = model.getDataEntity(true).getDynamicObjectCollection("tripentry").getDynamicObjectType().getProperties();
                IDataEntityProperty entrycurrencyPro = (IDataEntityProperty)((SubEntryProp)entryProCollection.get((Object)"entryentity")).getDynamicCollectionItemPropertyType().getProperties().get((Object)"entrycurrency");
                AmountChangeUtil.refreshCellFmt(view, "entryentity", entrycurrencyPro, currency, entryIndex);
            }
        }
        logger.info("\u7ed3\u675f\u5faa\u73af");
        AmountChangeUtil.printInVokeCount();
        model.setEntryCurrentRowIndex("tripentry", currentTripIndex);
    }

    private static boolean isReimTripEntryNotRuned(int tripIndex) {
        return true;
    }

    private static boolean isReimTripEntryEntiryNotRuned(int tripIndex, int entryIndex) {
        return true;
    }

    private static void printInVokeCount() {
        if (ThreadCache.exists((Object)"reimIsPushVar")) {
            Map controlMap = (Map)ThreadCache.get((Object)"reimIsPushVar");
            AtomicInteger tripEntrysCountAtomic = (AtomicInteger)controlMap.get("reimTripEntryInvokeCount");
            AtomicInteger tripEntryEntirysCountAtomic = (AtomicInteger)controlMap.get("reimTripEntryentityInvokeCount");
            logger.info("tripEntryInvokeCount:" + tripEntrysCountAtomic + ";tripEntryEntiryInvokeCount:" + tripEntryEntirysCountAtomic);
        }
    }

    protected static void refreshCellFmt(IFormView view, String entryName, IDataEntityProperty entrycurrencyPro, DynamicObject currency, int entryIndex) {
        EntryGrid entryGrid = (EntryGrid)view.getControl(entryName);
        entryGrid.setFmtInfo(entrycurrencyPro, currency);
        entryGrid.updateCellFmt("entrycurrency", entryIndex);
    }

    public static void refreshCurrencyShowInExpenseEntryAmount(IFormView view, IDataModel model, DynamicObject curTripentry, DynamicObject curEntry) {
        DynamicObjectCollection curEntrys = curTripentry.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection tripEntrys = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
        for (int tripIndex = 0; tripIndex < tripEntrys.size(); ++tripIndex) {
            Set<Long> keySet;
            Stream<DynamicObject> dynamicObjectStream;
            Map<Long, List<DynamicObject>> groupEntryCurrencyMap;
            BigDecimal exchangeRate = null;
            String quoteType = "0";
            DynamicObject tripEntry = (DynamicObject)tripEntrys.get(tripIndex);
            DynamicObjectCollection entrys = tripEntry.getDynamicObjectCollection("entryentity");
            if (!ErStdConfig.getBoolean((String)"tripCurrencyExrate.noControl")) {
                for (int entryIndex = 0; entryIndex < entrys.size(); ++entryIndex) {
                    List<DynamicObject> curEntryList;
                    DynamicObject currency = ((DynamicObject)entrys.get(entryIndex)).getDynamicObject("entrycurrency");
                    if (curEntry != null) {
                        DynamicObject curCurrency = curEntry.getDynamicObject("entrycurrency");
                        exchangeRate = curEntry.getBigDecimal("exchangerate");
                        quoteType = (String)ObjectUtils.defaultIfNull((Object)curEntry.getString("detailquotetype"), (Object)"0");
                        if (ErCommonUtils.getPk(currency) != null && ErCommonUtils.getPk(curCurrency) != null && ErCommonUtils.getPk(currency).compareTo(ErCommonUtils.getPk(curCurrency)) == 0) {
                            model.setValue("exchangerate", (Object)exchangeRate, entryIndex, tripIndex);
                        }
                    }
                    Map<Long, List<DynamicObject>> curEntryGroupCurrencyMap = curEntrys.stream().collect(Collectors.groupingBy(v -> ErCommonUtils.getPk(v.getDynamicObject("entrycurrency"))));
                    if (curEntry != null || ErCommonUtils.getPk(currency) == null || curEntryGroupCurrencyMap.get(ErCommonUtils.getPk(currency)) == null || (curEntryList = curEntryGroupCurrencyMap.get(ErCommonUtils.getPk(currency = ((DynamicObject)entrys.get(entryIndex)).getDynamicObject("entrycurrency")))) == null || curEntryList.isEmpty()) continue;
                    exchangeRate = curEntryList.get(0).getBigDecimal("exchangerate");
                    quoteType = (String)ObjectUtils.defaultIfNull((Object)curEntryList.get(0).getString("detailquotetype"), (Object)"0");
                    model.setValue("exchangerate", (Object)exchangeRate, entryIndex, tripIndex);
                }
            }
            if ((groupEntryCurrencyMap = (dynamicObjectStream = entrys.stream().filter(v -> ErCommonUtils.getPk(v.getDynamicObject("entrycurrency")) != null)).collect(Collectors.groupingBy(v -> ErCommonUtils.getPk(v.getDynamicObject("entrycurrency"))))).size() > 1) {
                model.setValue("tripexchangerate", (Object)BigDecimal.ONE, tripIndex);
                model.setValue("tripcurrency", model.getValue("currency"), tripIndex);
                model.setValue("tripquotetype", (Object)BigDecimal.ZERO, tripIndex);
            } else if (groupEntryCurrencyMap.size() == 1 && (keySet = groupEntryCurrencyMap.keySet()).iterator().hasNext()) {
                Long currencyId = keySet.iterator().next() == 0L ? ErCommonUtils.getPk(model.getValue("currency")) : keySet.iterator().next();
                model.setValue("tripcurrency", (Object)currencyId, tripIndex);
                Map<String, Object> exchangeMap = AmountChangeUtil.getCurrentEntryExchangeRate(currencyId, model);
                BigDecimal tripExchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeMap.get("exchangeRate")), (Object)BigDecimal.ONE);
                String tripQuoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeMap.get("quoteType")), (Object)"0");
                model.setValue("tripquotetype", (Object)tripQuoteType, tripIndex);
                model.setValue("tripexchangerate", (Object)tripExchangeRate, tripIndex);
            }
            IDataEntityProperty entrycurrencyPro = (IDataEntityProperty)model.getDataEntity(true).getDynamicObjectCollection("tripentry").getDynamicObjectType().getProperties().get((Object)"tripcurrency");
            AmountChangeUtil.refreshCellFmt(view, "tripentry", entrycurrencyPro, (DynamicObject)model.getValue("tripcurrency", tripIndex), tripIndex);
        }
        logger.info("\u7ed3\u675f\u5faa\u73af");
    }

    public static void recalcReimburseAmountField(IFormView view, IDataModel model, boolean needRecalculate) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection tripEntrys = dataEntity.getDynamicObjectCollection("tripentry");
        if (tripEntrys == null) {
            return;
        }
        int oldTripEntryRowIndex = model.getEntryCurrentRowIndex("tripentry");
        for (int tripEntryRowIndex = 0; tripEntryRowIndex < tripEntrys.size(); ++tripEntryRowIndex) {
            int parentIndex = tripEntryRowIndex;
            DynamicObjectCollection entryItemEntrys = ((DynamicObject)tripEntrys.get(tripEntryRowIndex)).getDynamicObjectCollection("entryentity");
            if (entryItemEntrys != null && !entryItemEntrys.isEmpty()) {
                List<Integer> entryItemRows = Stream.iterate(0, i -> i + 1).limit(entryItemEntrys.size()).collect(Collectors.toList());
                AmountChangeUtil.recalcReimburseAmountField(view, model, tripEntryRowIndex, entryItemRows, needRecalculate);
                entryItemRows.forEach(rowIndex -> model.setValue("approvetax", model.getValue("taxamount", rowIndex.intValue(), parentIndex), rowIndex.intValue(), parentIndex));
                continue;
            }
            AmountChangeUtil.updateTripEntryAndHeadAmount(view, model, tripEntryRowIndex);
        }
        logger.info("\u7ed3\u675f\u5faa\u73af");
        Control tripEntry = view.getControl("tripentry");
        if (tripEntry instanceof CardEntry) {
            ((CardEntry)tripEntry).selectCard(Integer.valueOf(oldTripEntryRowIndex));
        }
    }

    public static void recalcReimburseAmountField(IFormView view, IDataModel model, int tripEntryRowIndex, List<Integer> entryItemRows, boolean needRecalculate) {
        DynamicObject dataEntity = model.getDataEntity(true);
        int tripEntrySize = dataEntity.getDynamicObjectCollection("tripentry").size();
        if (tripEntrySize > 0 && tripEntrySize > tripEntryRowIndex) {
            model.beginInit();
            DynamicObjectCollection reimburseDetails = ((DynamicObject)dataEntity.getDynamicObjectCollection("tripentry").get(tripEntryRowIndex)).getDynamicObjectCollection("entryentity");
            if (!reimburseDetails.isEmpty()) {
                for (Integer i : entryItemRows) {
                    DynamicObject reimburseDetail = (DynamicObject)reimburseDetails.get(i.intValue());
                    BigDecimal reimburseAmountOri = reimburseDetail.getBigDecimal("orientryamount");
                    BigDecimal reimburseAppAmountOri = reimburseDetail.getBigDecimal("orientryappamount");
                    BigDecimal exchangeRate = reimburseDetail.getBigDecimal("exchangerate");
                    String detailQuoteType = (String)ObjectUtils.defaultIfNull((Object)reimburseDetail.getString("detailquotetype"), (Object)"0");
                    int precision = AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"currency");
                    BigDecimal currencyAmount = AmountUtils.getCurrencyAmount((BigDecimal)reimburseAmountOri, (BigDecimal)exchangeRate, (int)precision, (String)detailQuoteType);
                    BigDecimal currencyAppAmount = AmountUtils.getCurrencyAmount((BigDecimal)reimburseAppAmountOri, (BigDecimal)exchangeRate, (int)precision, (String)detailQuoteType);
                    model.setValue("entryamount", (Object)currencyAmount, i.intValue(), tripEntryRowIndex);
                    model.setValue("entryappamount", (Object)currencyAppAmount, i.intValue(), tripEntryRowIndex);
                }
            }
            model.endInit();
            model.setValue("tripdeductibletax", (Object)AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)reimburseDetails, "deductibletax"), tripEntryRowIndex);
            for (Integer i : entryItemRows) {
                ErCommonUtils.updateView(view, (int)i, tripEntryRowIndex, "entryamount", "entryappamount");
            }
            AmountChangeUtil.updateTripEntryAndHeadAmount(view, model, tripEntryRowIndex);
        }
    }

    public static void updateTripEntryAndHeadAmount(IFormView view, IDataModel model, int entryRowIndex) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection reimburseDetails = ((DynamicObject)dataEntity.getDynamicObjectCollection("tripentry").get(entryRowIndex)).getDynamicObjectCollection("entryentity");
        model.beginInit();
        model.setValue("triporiamount", (Object)AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)reimburseDetails, "orientryamount"), entryRowIndex);
        model.setValue("tripamount", (Object)AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)reimburseDetails, "entryamount"), entryRowIndex);
        model.setValue("taxamounttotalori", (Object)AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)reimburseDetails, "taxamount"), entryRowIndex);
        model.setValue("taxamounttotal", (Object)AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)reimburseDetails, "taxamount"), entryRowIndex);
        model.setValue("notaxamounttotalori", (Object)AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)reimburseDetails, "notaxamount"), entryRowIndex);
        model.setValue("notaxamounttotal", (Object)AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)reimburseDetails, "notaxamount"), entryRowIndex);
        boolean ischanged = model.getDataChanged();
        model.setValue("tripappnottaxamount", (Object)AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)reimburseDetails, "curprice"), entryRowIndex);
        model.setValue("tripdeductibletax", (Object)AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)reimburseDetails, "deductibletax"), entryRowIndex);
        model.setDataChanged(ischanged);
        model.endInit();
        AmountChangeUtil.updateTitleAmountTotal(model);
        model.setValue("tripapporiamount", (Object)AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)reimburseDetails, "orientryappamount"), entryRowIndex);
        model.beginInit();
        model.setValue("tripappamount", (Object)new BigDecimal(-1), entryRowIndex);
        model.endInit();
        model.setValue("tripappamount", (Object)AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)reimburseDetails, "entryappamount"), entryRowIndex);
        AmountChangeUtil.updateTripEntryTitleAmountLabel(view, model);
        AmountChangeUtil.updateExpenseDetailAmountLabelForMob(view, model);
        ErCommonUtils.updateView(view, entryRowIndex, "tripcurrency", "triporiamount", "tripamount", "taxamounttotalori", "taxamounttotal", "notaxamounttotalori", "notaxamounttotal", "tripdeductibletax", "tripappnottaxamount");
        BigDecimal totalOffsetAmount = ReimburseUtils.sumOffsetAmount(model, view);
        model.setValue("totaloffsetamount", (Object)totalOffsetAmount);
        CalculateTripSumUtil.setLabelTripappnottaxamount((IFormView)view, (int)entryRowIndex);
        CalculateTripSumUtil.setLabelTripdeductibletax((IFormView)view, (int)entryRowIndex);
    }

    public static void updateExpenseDetailAmountLabelForMob(IFormView view, IDataModel model) {
        Label tripEntryAmountTotalLable = (Label)view.getControl("totalamountlab");
        if (tripEntryAmountTotalLable != null) {
            DynamicObject dataEntity = model.getDataEntity(true);
            int tripEntryRowIndex = model.getEntryCurrentRowIndex("tripentry");
            DynamicObjectCollection tripEntry = dataEntity.getDynamicObjectCollection("tripentry");
            if (!tripEntry.isEmpty()) {
                DynamicObjectCollection entryEntitys = ((DynamicObject)tripEntry.get(tripEntryRowIndex)).getDynamicObjectCollection("entryentity");
                BigDecimal reimburseAppAmountTotal = AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)entryEntitys, "entryamount");
                DynamicObject currency = (DynamicObject)model.getValue("currency");
                String moneyStringWithSymbol = "";
                if (currency != null) {
                    CurrencyBO currencyBO = new CurrencyBO((Long)currency.getPkValue());
                    String currencyBOSymbol = currencyBO.getSymbol();
                    moneyStringWithSymbol = AmountFormatsUtil.getLabelAmountAfterFormat((String)currencyBOSymbol, (BigDecimal)reimburseAppAmountTotal, (int)currencyBO.getPrecision());
                }
                tripEntryAmountTotalLable.setText(moneyStringWithSymbol);
            }
        }
    }

    public static TitleAmountTotalBO updateTitleAmountTotal(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity(true);
        List<DynamicObject> entryEntitys = dataEntity.getDynamicObjectCollection("tripentry").stream().flatMap(tripEntry -> tripEntry.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toList());
        List<DynamicObject> monthEntryEntitys = entryEntitys.stream().filter(x -> "2".equals(x.getString("settlementtype"))).collect(Collectors.toList());
        BigDecimal reimburseMonthMountTotal = AmountChangeUtil.sumAmountBy(monthEntryEntitys, "entryappamount");
        model.setValue("monthsettleamount", (Object)reimburseMonthMountTotal);
        BigDecimal reimburseAmountTotal = AmountChangeUtil.sumAmountBy(entryEntitys, "entryamount");
        BigDecimal reimburseAppAmountTotal = AmountChangeUtil.sumAmountBy(entryEntitys, "entryappamount");
        model.setValue("amount", (Object)reimburseAmountTotal);
        model.setValue("approveamount", (Object)reimburseAppAmountTotal);
        return new TitleAmountTotalBO(reimburseAmountTotal, reimburseAppAmountTotal);
    }

    public static void updateTripEntryTitleAmountLabel(IFormView view, IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity(true);
        Label tripEntryAmountTotalLable = (Label)view.getControl("totaltripamtlabel");
        Label tripEntryAppAmountTotalLable = (Label)view.getControl("totaltripappamtlabel");
        if (tripEntryAmountTotalLable == null && tripEntryAppAmountTotalLable == null) {
            return;
        }
        List<DynamicObject> entryEntitys = dataEntity.getDynamicObjectCollection("tripentry").stream().flatMap(tripEntry -> tripEntry.getDynamicObjectCollection("entryentity").stream()).collect(Collectors.toList());
        BigDecimal reimburseAppAmountTotal = AmountChangeUtil.sumAmountBy(entryEntitys, "entryappamount");
        BigDecimal reimburseAmountTotal = AmountChangeUtil.sumAmountBy(entryEntitys, "entryamount");
        DynamicObject companyCurrencyDO = dataEntity.getDynamicObject("currency");
        if (companyCurrencyDO != null) {
            String language;
            CurrencyBO currencyBO = new CurrencyBO((Long)companyCurrencyDO.getPkValue());
            String currencyBOSymbol = currencyBO.getSymbol();
            if (tripEntryAmountTotalLable != null) {
                tripEntryAmountTotalLable.setText(AmountFormatsUtil.getLabelAmountAfterFormat((String)currencyBOSymbol, (BigDecimal)reimburseAmountTotal, (int)currencyBO.getPrecision()));
                language = ResManager.getLanguage();
                if (!"zh_CN".equals(language) && !"zh_TW".equals(language)) {
                    tripEntryAmountTotalLable.setText(AmountFormatsUtil.getLabelAmountAfterFormat((String)currencyBOSymbol, (BigDecimal)reimburseAmountTotal, (int)currencyBO.getPrecision()));
                }
            }
            if (tripEntryAppAmountTotalLable != null) {
                tripEntryAppAmountTotalLable.setText(AmountFormatsUtil.getLabelAmountAfterFormat((String)currencyBOSymbol, (BigDecimal)reimburseAppAmountTotal, (int)currencyBO.getPrecision()));
                language = ResManager.getLanguage();
                if (!"zh_CN".equals(language) && !"zh_TW".equals(language)) {
                    tripEntryAppAmountTotalLable.setText(AmountFormatsUtil.getLabelAmountAfterFormat((String)currencyBOSymbol, (BigDecimal)reimburseAppAmountTotal, (int)currencyBO.getPrecision()));
                }
            }
        }
    }

    public static BigDecimal sumAmountBy(Collection<DynamicObject> entryEntities, String fieldName) {
        if (entryEntities == null || entryEntities.isEmpty()) {
            return BigDecimal.ZERO;
        }
        return entryEntities.stream().map(entryentity -> entryentity.getBigDecimal(fieldName)).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
    }

    @Deprecated
    public static BigDecimal getCurrentEntryExchangeRate(IDataModel model, long currencyDOId) {
        DynamicObject companyDO = (DynamicObject)model.getValue("company");
        DynamicObject companyCurrencyDO = (DynamicObject)model.getValue("currency");
        DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
        Map exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams((Object)companyDO, (Object)costCompany, (Long)currencyDOId, (Long)ErCommonUtils.getPk(companyCurrencyDO), (Object)model);
        return (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeRateAndQuoteType.get("exchangeRate")), (Object)BigDecimal.ONE);
    }

    public static Map<String, Object> getCurrentEntryExchangeRate(long currencyDOId, IDataModel model) {
        DynamicObject companyDO = (DynamicObject)model.getValue("company");
        DynamicObject companyCurrencyDO = (DynamicObject)model.getValue("currency");
        DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
        return CommonServiceHelper.getExchangeRateFromSysParams((Object)companyDO, (Object)costCompany, (Long)currencyDOId, (Long)ErCommonUtils.getPk(companyCurrencyDO), (Object)model);
    }

    public static void accExchangeRateChange(Object propValue, int rowIndex, IDataModel model, IFormView view) {
        new ReceiveEntryPropChange(model).accExchangeRateChange(propValue, rowIndex, view);
    }

    public static void orireceiveamountChange(Object propValue, int rowIndex, IDataModel model) {
        new ReceiveEntryPropChange(model).orireceiveamountChange(propValue, rowIndex);
    }

    public static void handleDiiff(IDataModel model, String accountentry, String accReceiveamount, String accOriReceiveAmount, String accExchangeRate, String currency) {
        new ReceiveEntryPropChange(model).handleDiiff(accountentry, accReceiveamount, accOriReceiveAmount, accExchangeRate, currency);
    }

    public static BigDecimal getCashAmount(IDataModel model) {
        BigDecimal cashAmount = BigDecimal.ZERO;
        String name = model.getDataEntityType().getName();
        if (ErEntityTypeUtils.isDailyLoanBill((String)name) || ErEntityTypeUtils.isTripReqBill((String)name) || ErEntityTypeUtils.isPrePayBill((String)name)) {
            cashAmount = (BigDecimal)model.getValue("approveamount");
        } else if (ErEntityTypeUtils.isDailyReimburseBill((String)name)) {
            cashAmount = (BigDecimal)model.getValue("payamount");
        } else if (ErEntityTypeUtils.isPublicReimburseBill((String)name)) {
            cashAmount = (BigDecimal)model.getValue("payamount");
        } else if (ErEntityTypeUtils.isTripReimburseBill((String)name)) {
            cashAmount = (BigDecimal)model.getValue("encashamount");
        }
        return cashAmount;
    }

    public static void setCashAmount(IDataModel model, BigDecimal cashAmount) {
        String name = model.getDataEntityType().getName();
        if (ErEntityTypeUtils.isDailyLoanBill((String)name) || ErEntityTypeUtils.isTripReqBill((String)name)) {
            model.setValue("approveamount", (Object)cashAmount);
        } else if (ErEntityTypeUtils.isDailyReimburseBill((String)name)) {
            model.setValue("payamount", (Object)cashAmount);
        } else if (ErEntityTypeUtils.isPublicReimburseBill((String)name)) {
            model.setValue("payamount", (Object)cashAmount);
        } else if (ErEntityTypeUtils.isTripReimburseBill((String)name)) {
            model.setValue("encashamount", (Object)cashAmount);
        }
    }

    public static void updateTripApproveInfo(IDataModel model, IFormView view, int parentIndex, int rowIndex, boolean needRecalculate) {
        BigDecimal expenseAmount = (BigDecimal)model.getValue("orientryamount", rowIndex, parentIndex);
        BigDecimal expenseAmountAppOri = model.getProperty("orientryappamount") != null ? (BigDecimal)model.getValue("orientryappamount", rowIndex, parentIndex) : (BigDecimal)model.getValue("orientryamount", rowIndex, parentIndex);
        BigDecimal expenseTaxrate = (BigDecimal)model.getValue("taxrate", rowIndex, parentIndex);
        String itemFrom = (String)model.getValue("itemfrom", rowIndex, parentIndex);
        expenseTaxrate = expenseTaxrate.divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_EVEN);
        DynamicObject expenseCurrencyDO = (DynamicObject)model.getValue("entrycurrency", rowIndex, parentIndex);
        int precision = expenseCurrencyDO.getInt("amtprecision");
        BigDecimal airportConstructionAmount = (BigDecimal)model.getValue("airportconstructionfee", rowIndex, parentIndex);
        BigDecimal appTaxAmount = expenseAmountAppOri.subtract(airportConstructionAmount).multiply(expenseTaxrate).divide(BigDecimal.ONE.add(expenseTaxrate), precision, RoundingMode.HALF_EVEN);
        BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", rowIndex, parentIndex);
        BigDecimal difClear = ErStdConfig.taxDifferenceClear();
        if (appTaxAmount.compareTo(taxAmount) > 0 || taxAmount.subtract(appTaxAmount).compareTo(difClear) <= 0) {
            appTaxAmount = taxAmount;
        }
        if (needRecalculate && !ItemFrom.TripBusiness.getValue().equals(itemFrom)) {
            model.setValue("approvetax", (Object)appTaxAmount, rowIndex, parentIndex);
        }
    }

    public static void updateApproveInfo(IDataModel model, int rowIndex, boolean needRecalculate) {
        BigDecimal taxAmount;
        BigDecimal appTaxAmount;
        if (!needRecalculate) {
            return;
        }
        if (!ErCommonUtils.hasProperties(model, "expenseamount", "expeapproveamount", "taxrate", "entrycurrency", "approvetax")) {
            return;
        }
        BigDecimal difClear = ErStdConfig.taxDifferenceClear();
        BigDecimal expenseAmountAppOri = (BigDecimal)model.getValue("expeapproveamount", rowIndex);
        BigDecimal expenseTaxrate = (BigDecimal)model.getValue("taxrate", rowIndex);
        expenseTaxrate = expenseTaxrate.divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_EVEN);
        DynamicObject expenseCurrencyDO = (DynamicObject)model.getValue("entrycurrency", rowIndex);
        if (expenseCurrencyDO == null) {
            return;
        }
        int precision = expenseCurrencyDO.getInt("amtprecision");
        IDataEntityProperty airportconstructionfee = model.getProperty("airportconstructionfee");
        BigDecimal airportConstructionAmount = BigDecimal.ZERO;
        if (airportconstructionfee != null) {
            airportConstructionAmount = (BigDecimal)model.getValue("airportconstructionfee", rowIndex);
        }
        if ((appTaxAmount = expenseAmountAppOri.subtract(airportConstructionAmount).multiply(expenseTaxrate).divide(BigDecimal.ONE.add(expenseTaxrate), precision, RoundingMode.HALF_EVEN)).compareTo(taxAmount = (BigDecimal)model.getValue("taxamount", rowIndex)) > 0 || taxAmount.subtract(appTaxAmount).compareTo(difClear) <= 0) {
            appTaxAmount = taxAmount;
        }
        model.setValue("approvetax", (Object)appTaxAmount, rowIndex);
    }

    public static void updateInOutAmount(IDataModel model, int rowIndex, int parentIndex, ChangeField changeFieldType) {
        BigDecimal outAmount;
        String formulaType = ErStdConfig.get((String)"transferouttax.formula");
        if (model.getProperty("iteminoutamount") == null) {
            return;
        }
        if (changeFieldType != ChangeField.All && !formulaType.equalsIgnoreCase(changeFieldType.getValue()) && ChangeField.DEDUCTIBLE_TAX != changeFieldType) {
            return;
        }
        if (model.getDataEntity(true).getDynamicObjectType().getProperty("expenseentryentity") != null) {
            BigDecimal offsetAmount = (BigDecimal)model.getValue("deductibletax", rowIndex, parentIndex);
            BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", rowIndex, parentIndex);
            BigDecimal approveTax = (BigDecimal)model.getValue("approvetax", rowIndex, parentIndex);
            outAmount = StringUtils.equalsIgnoreCase((String)formulaType, (String)"1") ? taxAmount.subtract(offsetAmount) : approveTax.subtract(offsetAmount);
        } else {
            BigDecimal offsetAmount = (BigDecimal)model.getValue("deductibletax", rowIndex, parentIndex);
            BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", rowIndex, parentIndex);
            BigDecimal approveTax = (BigDecimal)model.getValue("approvetax", rowIndex, parentIndex);
            outAmount = StringUtils.equalsIgnoreCase((String)formulaType, (String)"1") ? taxAmount.subtract(offsetAmount) : approveTax.subtract(offsetAmount);
        }
        if (BigDecimal.ZERO.compareTo(outAmount) >= 0) {
            outAmount = BigDecimal.ZERO;
        }
        logger.info("updateInOutAmount changeFieldType: " + changeFieldType.getField() + "   ,outAmount: " + outAmount);
        model.setValue("iteminoutamount", (Object)outAmount, rowIndex, parentIndex);
    }

    public static void updateInOutAmount(DynamicObject item, DynamicObject costcompany, DynamicObject company, ChangeField changeFieldType) {
        String formulaType = ErStdConfig.get((String)"transferouttax.formula");
        if (changeFieldType != ChangeField.All && !formulaType.equalsIgnoreCase(changeFieldType.getValue()) && ChangeField.DEDUCTIBLE_TAX != changeFieldType) {
            return;
        }
        BigDecimal taxAmount = item.getBigDecimal("taxamount");
        BigDecimal approveTax = item.getBigDecimal("approvetax");
        BigDecimal deductibleTax = item.getBigDecimal("deductibletax");
        BigDecimal inOutAmount = StringUtils.equalsIgnoreCase((String)formulaType, (String)ChangeField.TAX_AMOUNT.getValue()) ? taxAmount.subtract(deductibleTax) : approveTax.subtract(deductibleTax);
        if (BigDecimal.ZERO.compareTo(inOutAmount) >= 0 || !InvoiceOffsetUtils.deductibleOfTaxPayer((Long)ErCommonUtils.getPk(company), (Long)ErCommonUtils.getPk(costcompany))) {
            inOutAmount = BigDecimal.ZERO;
        }
        logger.info("updateInOutAmount item changeFieldType: " + changeFieldType.getField() + "   ,inOutAmount: " + inOutAmount);
        item.set("iteminoutamount", (Object)inOutAmount);
    }

    public static BigDecimal getNoTaxAmount(BigDecimal approveAmount, BigDecimal deTaxAmount, BigDecimal approveTax) {
        String approveTaxFormulaType = ErStdConfig.getApproveTaxFormulaType();
        BigDecimal price = StringUtils.equals((String)approveTaxFormulaType, (String)"1") ? approveAmount.subtract(deTaxAmount) : approveAmount.subtract(approveTax);
        return price;
    }

    @Deprecated
    public static void updatePrice(IDataModel model, IFormView view, String entryName, String oriAppAmountFieldName, int rowIndex, String currencyField, boolean isTrip) {
        BigDecimal price;
        String formulaType;
        logger.info("kd.fi.er.business.utils.AmountChangeUtil.updatePrice \u8be5\u65b9\u6cd5\u5df2\u5e9f\u5f03,\u8bf7\u4f7f\u7528\u65b0\u65b9\u6cd5");
        int currentRowIndex = rowIndex;
        if (rowIndex == -1) {
            currentRowIndex = model.getEntryCurrentRowIndex(entryName);
        }
        DynamicObject currentRowEntity = model.getEntryRowEntity(entryName, currentRowIndex);
        BigDecimal expeapproveAmount = currentRowEntity.getBigDecimal(oriAppAmountFieldName);
        boolean existDeductible = true;
        IDataEntityProperty deductibleTaxProp = (IDataEntityProperty)model.getDataEntity(true).getDynamicObjectCollection(entryName).getDynamicObjectType().getProperties().get((Object)"deductibletax");
        if (deductibleTaxProp == null) {
            existDeductible = false;
        }
        if (StringUtils.equals((String)(formulaType = ErStdConfig.getApproveTaxFormulaType()), (String)"1")) {
            BigDecimal tax = existDeductible ? currentRowEntity.getBigDecimal("deductibletax") : currentRowEntity.getBigDecimal("approvetax");
            price = expeapproveAmount.subtract(tax);
        } else {
            BigDecimal approveTax = currentRowEntity.getBigDecimal("approvetax");
            price = expeapproveAmount.subtract(approveTax);
        }
        model.setValue("price", (Object)price, currentRowIndex);
        AmountChangeUtil.setCurPrice(model, view, price, currentRowIndex, -1, currencyField);
    }

    public static void updatePrice(IDataModel model, IFormView view, String entryName, String oriAppAmountFieldName, int rowIndex, int parentIndex, String currencyField, ChangeField changeField) {
        IDataEntityProperty priceProp;
        IDataEntityProperty approveTaxProp;
        String logLevel = LogUtils.getDataLogLevel();
        if ("debug".equals(logLevel)) {
            String logInfo = LogUtils.LogStackTraceStr(Thread.currentThread().getStackTrace());
            logger.info("\u6838\u5b9a\u4e0d\u542b\u7a0e\u91d1\u989d\u5237\u65b0\u5806\u6808\uff1a" + logInfo);
        }
        int currentRowIndex = rowIndex;
        if (rowIndex == -1) {
            currentRowIndex = model.getEntryCurrentRowIndex(entryName);
        }
        DynamicObject currentRowEntity = model.getEntryRowEntity(entryName, currentRowIndex, parentIndex);
        BigDecimal expeapproveAmount = currentRowEntity.getBigDecimal(oriAppAmountFieldName);
        DataEntityPropertyCollection properties = currentRowEntity.getDynamicObjectType().getProperties();
        boolean existDeductible = true;
        boolean existApproveTax = true;
        boolean existPrice = true;
        IDataEntityProperty deductibleTaxProp = (IDataEntityProperty)properties.get((Object)"deductibletax");
        if (deductibleTaxProp == null) {
            existDeductible = false;
        }
        if ((approveTaxProp = (IDataEntityProperty)properties.get((Object)"approvetax")) == null) {
            existApproveTax = false;
        }
        if ((priceProp = (IDataEntityProperty)properties.get((Object)"price")) == null) {
            existPrice = false;
        }
        if (!existApproveTax && !existDeductible || !existPrice) {
            return;
        }
        String formulaType = ErStdConfig.getApproveTaxFormulaType();
        logger.info("\u6838\u5b9a\u4e0d\u542b\u7a0e\u91d1\u989d\u5237\u65b0 formulaType:" + formulaType + ",changeField:" + changeField.getField());
        if (StringUtils.equals((String)formulaType, (String)"1") && (ChangeField.APPROVE_TAX != changeField || ChangeField.APPROVE_TAX == changeField && !existDeductible)) {
            BigDecimal tax = existDeductible ? currentRowEntity.getBigDecimal("deductibletax") : currentRowEntity.getBigDecimal("approvetax");
            BigDecimal price = expeapproveAmount.subtract(tax);
            model.setValue("price", (Object)price, currentRowIndex, parentIndex);
            AmountChangeUtil.setCurPrice(model, view, price, currentRowIndex, parentIndex, currencyField);
            logger.info("\u6838\u5b9a\u4e0d\u542b\u7a0e\u91d1\u989d\u5237\u65b0 tax:" + tax + ",price:" + price + ",currentRowIndex:" + currentRowIndex + ",parentIndex" + parentIndex);
        } else if (StringUtils.equals((String)formulaType, (String)"2") && ChangeField.DEDUCTIBLE_TAX != changeField) {
            BigDecimal approveTax = currentRowEntity.getBigDecimal("approvetax");
            BigDecimal price = expeapproveAmount.subtract(approveTax);
            model.setValue("price", (Object)price, currentRowIndex, parentIndex);
            AmountChangeUtil.setCurPrice(model, view, price, currentRowIndex, parentIndex, currencyField);
            logger.info("\u6838\u5b9a\u4e0d\u542b\u7a0e\u91d1\u989d\u5237\u65b0 approveTax:" + approveTax + ",price:" + price + ",currentRowIndex:" + currentRowIndex + ",parentIndex" + parentIndex);
        }
    }

    @Deprecated
    public static void setCurPrice(IDataModel model, IFormView view, BigDecimal price, int rowIndex, String currencyField) {
        IDataEntityProperty curPriceProp = model.getProperty("curprice");
        if (price != null && curPriceProp != null) {
            BigDecimal exchangeRate = (BigDecimal)model.getValue("exchangerate", rowIndex);
            exchangeRate = exchangeRate.compareTo(BigDecimal.ZERO) != 0 ? exchangeRate : BigDecimal.ONE;
            String quoteTypeField = "expquotetype";
            if (ErEntityTypeUtils.isTripReimburseBill((String)model.getDataEntityType().getName())) {
                quoteTypeField = "detailquotetype";
            }
            String quoteType = model.getProperty(quoteTypeField) == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue(quoteTypeField, rowIndex)), (Object)"0");
            BigDecimal curPrice = StringUtils.equals((String)"1", (String)quoteType) ? price.divide(exchangeRate, AmountUtils.getCurrencyPrecision((IDataModel)model, (String)currencyField), RoundingMode.HALF_UP) : price.multiply(exchangeRate).setScale(AmountUtils.getCurrencyPrecision((IDataModel)model, (String)currencyField), RoundingMode.HALF_UP);
            model.setValue("curprice", (Object)curPrice, rowIndex);
            view.updateView("curprice", rowIndex);
        }
    }

    public static void setCurPrice(IDataModel model, IFormView view, BigDecimal price, int rowIndex, int parentIndex, String currencyField) {
        IDataEntityProperty curPriceProp = model.getProperty("curprice");
        if (price != null && curPriceProp != null) {
            BigDecimal exchangeRate = (BigDecimal)model.getValue("exchangerate", rowIndex, parentIndex);
            exchangeRate = exchangeRate.compareTo(BigDecimal.ZERO) != 0 ? exchangeRate : BigDecimal.ONE;
            String quoteTypeField = "expquotetype";
            if (ErEntityTypeUtils.isTripReimburseBill((String)model.getDataEntityType().getName())) {
                quoteTypeField = "detailquotetype";
            }
            String quoteType = model.getProperty(quoteTypeField) == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue(quoteTypeField, rowIndex, parentIndex)), (Object)"0");
            BigDecimal curPrice = StringUtils.equals((String)"1", (String)quoteType) ? price.divide(exchangeRate, AmountUtils.getCurrencyPrecision((IDataModel)model, (String)currencyField), RoundingMode.HALF_UP) : price.multiply(exchangeRate).setScale(AmountUtils.getCurrencyPrecision((IDataModel)model, (String)currencyField), RoundingMode.HALF_UP);
            model.setValue("curprice", (Object)curPrice, rowIndex, parentIndex);
            view.updateView("curprice", rowIndex, parentIndex);
        }
    }

    public static BigDecimal getOriAmount(BigDecimal currAmount, Map<String, Object> currencyMap, String quoteType) {
        int precision = AmountUtils.getCurrencyPrecision((Object)currencyMap.get("currencyId"));
        return AmountUtils.getOriAmount((BigDecimal)currAmount, (BigDecimal)((BigDecimal)currencyMap.get("exchangeRate")), (int)precision, (String)quoteType);
    }

    public static void setTripReimPrice(IDataModel model, int rowIndex, int parentIndex) {
        String formulaType = ErStdConfig.getApproveTaxFormulaType();
        BigDecimal tax = StringUtils.equals((String)formulaType, (String)"1") ? (BigDecimal)model.getValue("deductibletax", rowIndex, parentIndex) : (BigDecimal)model.getValue("approvetax", rowIndex, parentIndex);
        BigDecimal expeApproveAmount = (BigDecimal)model.getValue("orientryappamount", rowIndex, parentIndex);
        BigDecimal price = expeApproveAmount.subtract(tax);
        String quoteType = (String)model.getValue("detailquotetype", rowIndex, parentIndex);
        BigDecimal exchangeRate = (BigDecimal)model.getValue("exchangerate", rowIndex, parentIndex);
        int precision = AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"currency");
        BigDecimal curPrice = StringUtils.equals((String)"1", (String)quoteType) ? price.divide(exchangeRate, precision, RoundingMode.HALF_UP) : price.multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
        model.beginInit();
        model.setValue("price", (Object)price, rowIndex, parentIndex);
        model.setValue("curprice", (Object)curPrice, rowIndex, parentIndex);
        model.endInit();
    }

    public static void updateTaxAmount(IFormView view, int index, int parentIndex, boolean needRecalculate) {
        Object auto;
        IDataModel model = view.getModel();
        Boolean autoInvoice = null;
        Boolean itemFromInvoice = null;
        if (model.getProperty("automapinvoice") != null) {
            autoInvoice = (Boolean)model.getValue("automapinvoice");
        }
        if (autoInvoice == null && (auto = view.getFormShowParameter().getCustomParams().get("automapinvoice")) != null) {
            autoInvoice = (Boolean)auto;
        }
        if (model.getProperty("itemfrom") != null) {
            String itemFrom = (String)model.getValue("itemfrom", index, parentIndex);
            itemFromInvoice = StringUtils.equals((String)itemFrom, (String)ItemFrom.InvoiceCloud.getValue());
        }
        boolean allowEdit = SystemParamterUtil.isEnableItemAmountEdit((Long)ErCommonUtils.getPk(model.getValue("company")));
        boolean allowEditTax = autoInvoice == null || autoInvoice == false || itemFromInvoice == null || itemFromInvoice == false || allowEdit;
        logger.info("updateTaxAmount allowEditTax\uff1a" + allowEditTax + " needRecalculate\uff1a" + needRecalculate);
        if (!allowEditTax) {
            return;
        }
        BigDecimal airportConstructFee = BigDecimal.ZERO;
        if (model.getProperty("expenseentryentity") != null) {
            BigDecimal oriEntryAmount = (BigDecimal)model.getValue("expenseamount", index, parentIndex);
            if (model.getProperty("airportconstructionfee") != null) {
                airportConstructFee = (BigDecimal)model.getValue("airportconstructionfee", index, parentIndex);
            }
            BigDecimal taxRate = (BigDecimal)model.getValue("taxrate", index, parentIndex);
            taxRate = taxRate.divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_EVEN);
            DynamicObject entryCurrency = (DynamicObject)model.getValue("entrycurrency", index, parentIndex);
            if (entryCurrency == null) {
                return;
            }
            int precision = entryCurrency.getInt("amtprecision");
            BigDecimal taxAmount = needRecalculate ? oriEntryAmount.subtract(airportConstructFee).multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), precision, RoundingMode.HALF_EVEN) : (BigDecimal)model.getValue("taxamount", index, parentIndex);
            BigDecimal noTaxAmount = oriEntryAmount.subtract(taxAmount);
            model.setValue("taxamount", (Object)taxAmount, index, parentIndex);
            model.setValue("orientryamount", (Object)noTaxAmount, index, parentIndex);
        } else {
            BigDecimal oriEntryAmount = (BigDecimal)model.getValue("orientryamount", index, parentIndex);
            if (model.getProperty("airportconstructionfee") != null) {
                airportConstructFee = (BigDecimal)model.getValue("airportconstructionfee", index, parentIndex);
            }
            BigDecimal taxRate = (BigDecimal)model.getValue("taxrate", index, parentIndex);
            taxRate = taxRate.divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_EVEN);
            DynamicObject entryCurrency = (DynamicObject)model.getValue("entrycurrency", index, parentIndex);
            if (entryCurrency == null) {
                return;
            }
            int precision = entryCurrency.getInt("amtprecision");
            BigDecimal taxAmount = needRecalculate ? oriEntryAmount.subtract(airportConstructFee).multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), precision, RoundingMode.HALF_EVEN) : (BigDecimal)model.getValue("taxamount", index, parentIndex);
            BigDecimal noTaxAmount = oriEntryAmount.subtract(taxAmount);
            model.setValue("taxamount", (Object)taxAmount, index, parentIndex);
            model.setValue("notaxamount", (Object)noTaxAmount, index, parentIndex);
        }
    }

    static class TitleAmountTotalBO {
        private BigDecimal Amount;
        private BigDecimal ApproveAmount;

        public TitleAmountTotalBO(BigDecimal amount, BigDecimal approveAmount) {
            this.Amount = amount;
            this.ApproveAmount = approveAmount;
        }

        public BigDecimal getAmount() {
            return this.Amount;
        }

        public BigDecimal getApproveAmount() {
            return this.ApproveAmount;
        }
    }
}

