/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Month;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.er.business.daily.service.model.CurrencyBO;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.model.EntityInfo;
import org.apache.commons.lang.StringUtils;

public class ErCommonUtils {
    private static final Log log = LogFactory.getLog(ErCommonUtils.class);
    private static final Object NULL_OBJECT = new Object();
    private static final String THREAD_CACHE_KEY = "kd.fi.er.business.utils.ErCommonUtils.getEMParameter(long, String)";
    public static final int RESEND_COUNT = 1;

    public static boolean isResearchEnvironment() {
        String tenantId = RequestContext.get().getTenantId();
        String researchEnvs = String.join((CharSequence)",", "tenant_devfi_dev", "tenant_devfi_test", "tenant_patchfi_dev", "tenant_feature_sit_fi_dev", "baseline_a", "baseline_b", "baseline_c");
        return researchEnvs.contains(tenantId);
    }

    public static Long genBillIdIfNotExist(IDataModel dataModel) {
        return ErCommonUtils.genBillIdIfNotExist(dataModel.getDataEntity());
    }

    public static Long genBillIdIfNotExist(DynamicObject dataEntity) {
        Long billId = (Long)dataEntity.getPkValue();
        if (billId == null || Objects.equals(billId, 0L)) {
            billId = ORM.create().genLongId(dataEntity.getDataEntityType());
            dataEntity.set("id", (Object)billId);
        }
        return billId;
    }

    public static String join(String[] arr, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(arr[i]).append(separator);
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.lastIndexOf(separator));
        }
        return null;
    }

    public static String join(Collection arr, String separator) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : arr) {
            sb.append(obj).append(separator);
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.lastIndexOf(separator));
        }
        return null;
    }

    public static String join(String separator, String ... arr) {
        String[] arrnew = (String[])arr.clone();
        return ErCommonUtils.join(arrnew, separator);
    }

    public static Long getPk(Object entity) {
        if (entity instanceof DynamicObject) {
            return (Long)((DynamicObject)entity).getPkValue();
        }
        if (entity instanceof Long) {
            return (Long)entity;
        }
        if (entity instanceof Integer) {
            return Long.valueOf(entity.toString());
        }
        return null;
    }

    public static String pojo2Json(Object obj) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T json2Pojo(Class<T> type, String json) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return (T)objectMapper.readValue(json, type);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.size() == 0;
    }

    public static boolean isEmpty(Object[] arr) {
        return arr == null || arr.length == 0;
    }

    public static Map key2Map(Collection collection) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)collection.size());
        for (Object value : collection) {
            map.put(value, value);
        }
        return map;
    }

    public static Map key2Map(Object[] arr) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)arr.length);
        for (Object value : arr) {
            map.put(value, value);
        }
        return map;
    }

    public static List filter(List filterList, List list) {
        ArrayList retList = new ArrayList();
        Map filterMap = ErCommonUtils.key2Map(filterList);
        for (Object obj : list) {
            if (filterMap.containsKey(obj)) continue;
            retList.add(obj);
        }
        return retList;
    }

    public static Object[] filter(Object[] filterArr, Object[] arr) {
        ArrayList<Object> retList = new ArrayList<Object>();
        Map filterMap = ErCommonUtils.key2Map(filterArr);
        for (Object obj : arr) {
            if (filterMap.containsKey(obj)) continue;
            retList.add(obj);
        }
        return retList.toArray();
    }

    public static Object getLoanCheckType(long companyId) {
        Object loanCheckType = ErCommonUtils.getEMParameter(companyId, "er010");
        return loanCheckType == null ? "2" : loanCheckType.toString();
    }

    @Deprecated
    public static boolean getEnableTripStandard(long companyId) {
        return SystemParamterUtil.isEnableTripStandard((Long)companyId);
    }

    @Deprecated
    public static void updateBillEntryState(DynamicObject bill, String billState) {
        DynamicObjectCollection tripenrtys = bill.getDynamicObjectCollection("tripentry");
        for (DynamicObject tripenrty : tripenrtys) {
            tripenrty.set("tripentrystatus", (Object)billState);
        }
    }

    @Deprecated
    public static int getSubsidiesDays(long companyId) {
        Object value = ErCommonUtils.getEMParameter(companyId, "subsidiesdays");
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value.toString());
    }

    public static int getResendCountFromAppCache(String key) {
        Integer count = (Integer)AppCache.get((String)"er").get(key, Integer.class);
        int countFlag = 0;
        int result = 0;
        if (null != count) {
            countFlag = count;
            result = countFlag++;
        } else {
            result = countFlag++;
        }
        if (result == 1) {
            AppCache.get((String)"er").remove(key);
            return result;
        }
        AppCache.get((String)"er").put(key, (Object)countFlag);
        return result;
    }

    public static void removeKeyFromAppCache(String key) {
        AppCache.get((String)"er").remove(key);
    }

    public static void putKeyValueToAppCache(String key, Object value) {
        AppCache.get((String)"er").put(key, value);
    }

    public static <T> T getKeyValueFromAppCache(String key, Class<T> clazz) {
        Object t = AppCache.get((String)"er").get(key, clazz);
        return (T)t;
    }

    public static Long getCompanyIdByOrgId(Long orgId) {
        return (Long)OrgUnitServiceHelper.getCompanyfromOrg((Long)orgId).get("id");
    }

    public static int getEnableInvoiceAfterReimburse(long companyId) {
        Object emParameter = ErCommonUtils.getEMParameter(companyId, "invoiceAfterReimburse");
        if (emParameter != null) {
            return Integer.parseInt(emParameter.toString());
        }
        return 1;
    }

    public static int getEnablePayAfterInvoice(long companyId) {
        Object emParameter = ErCommonUtils.getEMParameter(companyId, "payAfterInvoice");
        if (emParameter != null) {
            return Integer.parseInt(emParameter.toString());
        }
        return 0;
    }

    @Deprecated
    public static int getEnableAlterCostBear(long companyId) {
        Object emParameter = ErCommonUtils.getEMParameter(companyId, "alterCostBear");
        if (emParameter != null) {
            return Integer.parseInt(emParameter.toString());
        }
        return 0;
    }

    public static int getExpenseAssumeShowTypes(long companyId) {
        Object emParameter = ErCommonUtils.getEMParameter(companyId, "expensesassumeshowtypes");
        if (emParameter != null) {
            return Integer.parseInt(emParameter.toString());
        }
        return 1;
    }

    public static boolean storageLimits(Long companyId, String entityType) {
        String value = (String)ErCommonUtils.getEMParameter(companyId, "storageLimits");
        if (value != null && StringUtils.isNotEmpty((String)value)) {
            List<String> billList = Arrays.asList(value.split(","));
            return billList.contains(entityType);
        }
        return false;
    }

    public static Object getEMParameter(long companyId, String parameterName) {
        String key = String.format("%s,%s", THREAD_CACHE_KEY, companyId);
        Object paramData = null;
        Object value = null;
        if (ThreadCache.exists((Object)key)) {
            paramData = ThreadCache.get((Object)key);
            if (paramData == NULL_OBJECT) {
                paramData = null;
            }
            if (paramData != null) {
                value = ((Map)paramData).get(parameterName.toLowerCase());
            }
            return value;
        }
        AppParam appParam = ErCommonUtils.getAppParam(companyId);
        paramData = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        if (paramData == null) {
            ThreadCache.put((Object)key, (Object)NULL_OBJECT);
        } else {
            ThreadCache.put((Object)key, (Object)paramData);
        }
        if (paramData != null) {
            value = ((Map)paramData).get(parameterName.toLowerCase());
        }
        log.info("\u8d39\u7528\u83b7\u53d6\u53c2\u6570>>>> companyId: " + companyId + ", parameterName : " + parameterName + ", value : " + (value == null ? "" : value));
        return value;
    }

    public static Map<Long, Object> getEMParameter(List<Long> companyIds, String parameterName) {
        AppParam appParam = ErCommonUtils.getAppParam(companyIds.get(0));
        Map paramsMap = SystemParamServiceHelper.loadBatchAppParameterByOrgFromCache((AppParam)appParam, companyIds);
        return paramsMap.entrySet().stream().collect(Collectors.toMap(e -> Long.valueOf((String)e.getKey()), e -> ((Map)e.getValue()).get(parameterName)));
    }

    public static Object getFAParameter(long companyId, String parameterName) {
        Map paramData = null;
        log.info("\u5f00\u59cb\u8c03\u7528\u63a5\u53e3\u83b7\u53d6paramData>>>> companyId: " + companyId);
        AppParam appParam = ErCommonUtils.getFaParam(companyId);
        paramData = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        log.info("\u7ed3\u675f\u8c03\u7528\u63a5\u53e3\u83b7\u53d6paramData>>>> companyId: " + companyId);
        Object value = null;
        if (paramData != null) {
            value = paramData.get(parameterName.toLowerCase());
        }
        log.info("\u56fa\u5b9a\u8d44\u4ea7\u83b7\u53d6\u53c2\u6570>>>> companyId: " + companyId + ", parameterName : " + parameterName + ", value : " + (value == null ? "" : value));
        return value;
    }

    public static boolean isNeedImageScan(boolean imageParam, DynamicObject company, boolean isNoInvoice, String isAllInvoice) {
        boolean paperlessParam = false;
        if (company != null) {
            Long companyId = (Long)company.getPkValue();
            paperlessParam = SystemParamterUtil.isPaperlessReport((Long)companyId);
        }
        if (imageParam) {
            if (!paperlessParam) {
                return true;
            }
            if (paperlessParam && (isNoInvoice || StringUtils.equals((String)isAllInvoice, (String)"1") || StringUtils.equals((String)isAllInvoice, (String)"0"))) {
                return false;
            }
        }
        return true;
    }

    public static boolean isNeedImageScan(boolean imageParam, DynamicObject company, boolean isNoInvoice, String isAllInvoice, boolean needUploadInvoice) {
        boolean paperlessParam = false;
        if (company != null) {
            Long companyId = (Long)company.getPkValue();
            paperlessParam = SystemParamterUtil.isPaperlessReport((Long)companyId);
        }
        log.info("\u662f\u5426\u96c6\u6210\u53d1\u7968\u4e91\u5f71\u50cf\uff1a" + imageParam + "\uff0c\u53d1\u7968\u72b6\u6001\uff1a" + isAllInvoice + "\uff0c\u6709\u5f85\u4e0a\u4f20\u7684\u7eb8\u7968/\u9644\u4ef6\uff1a" + needUploadInvoice + "\uff0c\u65e0\u7eb8\u5316\u62a5\u8d26\uff1a" + paperlessParam);
        if (imageParam) {
            if (!paperlessParam) {
                return true;
            }
            if (isNoInvoice || StringUtils.equals((String)isAllInvoice, (String)"1") || StringUtils.equals((String)isAllInvoice, (String)"0")) {
                return needUploadInvoice;
            }
        }
        return true;
    }

    public static Object getEMParameterUpdate(Long companyId, String parameterName) {
        AppParam appParam = ErCommonUtils.getAppParam(companyId);
        Map appParaCache = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        return appParaCache.get(parameterName.toLowerCase());
    }

    public static void saveEMParameter(long companyId, String parameterName, Object value) {
        AppParam appParam = ErCommonUtils.getAppParam(companyId);
        Map paramCacheMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        paramCacheMap.put(parameterName, value);
        SystemParamServiceHelper.saveAppParameter((String)appParam.getAppId(), (String)appParam.getViewType(), (Long)appParam.getOrgId(), (Long)appParam.getActBookId(), (Map)paramCacheMap);
        String key = String.format("%s,%s,%s", THREAD_CACHE_KEY, companyId, parameterName);
        if (value == null) {
            value = NULL_OBJECT;
        }
        ThreadCache.put((Object)key, (Object)value);
    }

    private static AppParam getAppParam(long companyId) {
        String appId = "10MYBGBYHXDU";
        String viewType = "01";
        Long orgId = companyId;
        Long actBookId = 0L;
        AppParam appParam = new AppParam(appId, viewType, orgId, actBookId);
        return appParam;
    }

    private static AppParam getAppParam(Long companyId) {
        String appId = "10MYBGBYHXDU";
        String viewType = "01";
        Long orgId = companyId;
        Long actBookId = 0L;
        AppParam appParam = new AppParam(appId, viewType, orgId, actBookId);
        return appParam;
    }

    private static AppParam getFaParam(long companyId) {
        String appId = "83bfebc800001aac";
        String viewType = "01";
        Long orgId = companyId;
        Long actBookId = 0L;
        AppParam appParam = new AppParam(appId, viewType, orgId, actBookId);
        return appParam;
    }

    public static LocalDate getLocalDateFromDate(Date date) {
        if (date == null) {
            return null;
        }
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate localDate = instant.atZone(zoneId).toLocalDate();
        return localDate;
    }

    public static Date getDateFromLocalDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        ZoneId zoneId = ZoneId.systemDefault();
        Instant instant = localDate.atStartOfDay(zoneId).toInstant();
        return Date.from(instant);
    }

    @Deprecated
    public static String getMoneyStringWithSymbol(BigDecimal amount, CurrencyBO currencyBO) {
        String formattedAmount = "0.00";
        formattedAmount = ErCommonUtils.getFormattedMoneyString(amount, currencyBO);
        String language = ResManager.getLanguage();
        if (!"zh_CN".equals(language) && !"zh_TW".equals(language)) {
            return formattedAmount + currencyBO.getSymbol();
        }
        return currencyBO.getSymbol() + formattedAmount;
    }

    @Deprecated
    public static String getFormattedMoneyString(BigDecimal amount, CurrencyBO currencyBO) {
        amount = Objects.isNull(amount) ? BigDecimal.ZERO : amount;
        amount = amount.setScale((int)currencyBO.getPrecision(), RoundingMode.HALF_EVEN);
        String formattedAmount = currencyBO.getDefaultDecimalFormat().format(amount);
        return formattedAmount;
    }

    public static String getFormattedMoneyString(BigDecimal amount, int precision) {
        amount = Objects.isNull(amount) ? BigDecimal.ZERO : amount;
        amount = amount.setScale(precision, RoundingMode.HALF_EVEN);
        String formatStr = ",##0." + StringUtils.repeat((String)"0", (int)precision);
        DecimalFormat decimalFormat = new DecimalFormat();
        String language = ResManager.getLanguage();
        decimalFormat = !"zh_CN".equals(language) && !"zh_TW".equals(language) ? new DecimalFormat(formatStr, new DecimalFormatSymbols(Locale.GERMANY)) : new DecimalFormat(formatStr);
        String formattedAmount = decimalFormat.format(amount);
        return formattedAmount;
    }

    public static String[] getFormattedMoneyStringWithUnit(BigDecimal amount, int precision) {
        String[] moneyString = new String[2];
        if (amount.compareTo(new BigDecimal(1000)) < 0) {
            moneyString[0] = ErCommonUtils.getFormattedMoneyString(amount, 2);
            moneyString[1] = ResManager.loadKDString((String)"\u5143", (String)"ErCommonUtils_1", (String)"fi-er-business", (Object[])new Object[0]);
        } else if (amount.compareTo(new BigDecimal(1000)) >= 0 && amount.compareTo(new BigDecimal(1000000)) < 0) {
            amount = amount.divide(new BigDecimal(10000), 2, 4);
            moneyString[0] = ErCommonUtils.getFormattedMoneyString(amount, 2);
            moneyString[1] = ResManager.loadKDString((String)"\u4e07\u5143", (String)"ErCommonUtils_2", (String)"fi-er-business", (Object[])new Object[0]);
        } else if (amount.compareTo(new BigDecimal(1000000)) >= 0 && amount.compareTo(new BigDecimal(100000000)) < 0) {
            amount = amount.divide(new BigDecimal(1000000), 2, 4);
            moneyString[0] = ErCommonUtils.getFormattedMoneyString(amount, 2);
            moneyString[1] = ResManager.loadKDString((String)"\u767e\u4e07\u5143", (String)"ErCommonUtils_3", (String)"fi-er-business", (Object[])new Object[0]);
        } else if (amount.compareTo(new BigDecimal(100000000)) >= 0 && amount.compareTo(new BigDecimal(1000000000)) < 0) {
            amount = amount.divide(new BigDecimal(100000000), 2, 4);
            moneyString[0] = ErCommonUtils.getFormattedMoneyString(amount, 2);
            moneyString[1] = ResManager.loadKDString((String)"\u4ebf\u5143", (String)"ErCommonUtils_4", (String)"fi-er-business", (Object[])new Object[0]);
        } else {
            moneyString[0] = ErCommonUtils.getFormattedMoneyString(amount, 2);
            moneyString[1] = ResManager.loadKDString((String)"\u5143", (String)"ErCommonUtils_1", (String)"fi-er-business", (Object[])new Object[0]);
        }
        return moneyString;
    }

    @Deprecated
    public static boolean getAlterCostBearFromPageCache(IDataModel model) {
        DynamicObject company = (DynamicObject)model.getValue("company");
        String sourcebillId = (String)model.getValue("sourcebillid");
        int alterFlag = 0;
        if (company != null && StringUtils.isNotBlank((String)sourcebillId)) {
            long companyId = (Long)company.getPkValue();
            alterFlag = ErCommonUtils.getEnableAlterCostBear(companyId);
        }
        return alterFlag == 1;
    }

    public static Long getCompany(Long userId) {
        DynamicObject userDO = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
        List isNotPartEntrys = userDO.getDynamicObjectCollection("entryentity").stream().filter(entry -> !entry.getBoolean("ispartjob")).collect(Collectors.toList());
        if (isNotPartEntrys == null || isNotPartEntrys.isEmpty()) {
            log.warn(String.format("\u6570\u636e\u9519\u8bef: \u7528\u6237(%s)\u672a\u627e\u5230\u975e\u517c\u804c\u7ec4\u7ec7", SerializationUtils.toJsonString((Object)userDO)));
            return null;
        }
        if (isNotPartEntrys.size() > 1) {
            log.warn(String.format("\u6570\u636e\u9519\u8bef: \u7528\u6237(%s)\u627e\u5230\u591a\u4e2a\u975e\u517c\u804c\u7ec4\u7ec7(%s), \u968f\u4fbf\u53d6\u5176\u4e2d\u4e00\u4e2a\u7ec4\u7ec7(%s)", SerializationUtils.toJsonString((Object)userDO), SerializationUtils.toJsonString(isNotPartEntrys), SerializationUtils.toJsonString(isNotPartEntrys.get(0))));
        }
        Long deptId = (Long)((DynamicObject)isNotPartEntrys.get(0)).getDynamicObject("dpt").getPkValue();
        Long companyId = ErCommonUtils.getCompanyIdByOrgId(deptId);
        return companyId;
    }

    public static Object getObjectValue(Object entity) {
        if (entity instanceof DynamicObject) {
            return (Long)((DynamicObject)entity).getPkValue();
        }
        return entity;
    }

    public static void setIsBatchExcelImportExpenseEnry(IPageCache pageCache, boolean isBatch) {
        pageCache.put("isBatchExcelImportExpenseEnry", Boolean.toString(isBatch));
    }

    public static boolean isBatchExcelImportExpenseEnry(IPageCache pageCache) {
        String isBatchStr = pageCache.get("isBatchExcelImportExpenseEnry");
        if (StringUtils.isBlank((String)isBatchStr)) {
            return false;
        }
        return Boolean.parseBoolean(isBatchStr);
    }

    public static String serializeQFilter(QFilter qFilter) {
        if (qFilter == null) {
            return "";
        }
        return qFilter.toString();
    }

    public static void updateView(IFormView view, int rowIndex, String ... fields) {
        for (String field : fields) {
            if (view.getControl(field) == null) continue;
            try {
                view.updateView(field, rowIndex);
            }
            catch (IndexOutOfBoundsException e) {
                log.error("\u5728\u66f4\u65b0" + field + "\u5b57\u6bb5\u65f6\u51fa\u9519, rowIndex=" + rowIndex, (Throwable)e);
            }
        }
    }

    public static void updateView(IFormView view, int rowIndex, int parentRowIndex, String ... fields) {
        for (String field : fields) {
            if (view.getControl(field) == null) continue;
            try {
                view.updateView(field, rowIndex, parentRowIndex);
            }
            catch (IndexOutOfBoundsException e) {
                log.error("\u5728\u66f4\u65b0" + field + "\u5b57\u6bb5\u65f6\u51fa\u9519\uff0crowIndex=" + rowIndex + "\uff0cparentRowIndex=" + parentRowIndex, (Throwable)e);
            }
        }
    }

    public static boolean isAllowEditTaxAndTaxrate(Long companyId) {
        if (companyId == null) {
            log.info("isAllowEditTaxAndTaxrate companyId is Null");
            return true;
        }
        String result = (String)ErCommonUtils.getEMParameter(companyId, "itemamountedit");
        if (StringUtils.isBlank((String)result)) {
            return true;
        }
        return StringUtils.equals((String)result, (String)"1");
    }

    public static String getUserImageFullPath(Long userId) {
        ArrayList<Long> id = new ArrayList<Long>(1);
        id.add(userId);
        Map userAvatarPath = UserServiceHelper.getUserAvatarPath(id, (boolean)true);
        if (userAvatarPath.size() > 0) {
            return (String)userAvatarPath.get(userId);
        }
        return null;
    }

    public static String getTripAreaOrgType() {
        MainEntityType tripEntityType = EntityMetadataCache.getDataEntityType((String)"er_tripentryedit");
        BasedataProp tripAreaProp = (BasedataProp)tripEntityType.getProperty("tripArea");
        String orgType = tripAreaProp.getOrgProp();
        return orgType == null ? "company" : orgType;
    }

    public static String getReimCtlDeptFieldName(Long companyId) {
        String COST_DEPT = "2";
        String controlOrgName = (String)ErCommonUtils.getEMParameter(companyId, "reimcontrolorgname");
        if (StringUtils.equals((String)controlOrgName, (String)"2")) {
            return "entrycostdept";
        }
        return "org";
    }

    public static boolean isEnableIntelligentExpenseItem(Long companyId) {
        String enableIntelligent = (String)ErCommonUtils.getEMParameter(companyId, "intelligentexpenseitem");
        return org.apache.commons.lang3.StringUtils.equals((CharSequence)enableIntelligent, (CharSequence)"1");
    }

    public static Object getValueInModel(IDataModel model, String propName, String entityName, int rowIndex, String parentEntityName, int parentRowIndex) {
        DynamicObject parentRow = model.getEntryRowEntity(parentEntityName, parentRowIndex);
        DynamicObjectCollection subRows = parentRow.getDynamicObjectCollection(entityName);
        return ((DynamicObject)subRows.get(rowIndex)).get(propName);
    }

    public static Map<String, LocalDate> getQuarterPeriod(int year, int quarter) {
        LocalDate localDate = LocalDate.of(year, 1, 1);
        LocalDate quarterEndDate = localDate.withMonth(quarter * 3);
        Month firstMonthOfQuarter = quarterEndDate.getMonth().firstMonthOfQuarter();
        Month endMonthOfQuarter = quarterEndDate.getMonth();
        LocalDate start = LocalDate.of(localDate.getYear(), firstMonthOfQuarter, 1);
        LocalDate end = LocalDate.of(localDate.getYear(), endMonthOfQuarter, endMonthOfQuarter.length(localDate.isLeapYear()));
        HashMap<String, LocalDate> quarterPeriod = new HashMap<String, LocalDate>(2);
        quarterPeriod.put("start", start);
        quarterPeriod.put("end", end);
        return quarterPeriod;
    }

    public static Map<String, LocalDate> getQuarterPeriod(YearMonth yearMonth) {
        int quarter = (yearMonth.getMonth().firstMonthOfQuarter().getValue() + 2) / 3;
        return ErCommonUtils.getQuarterPeriod(yearMonth.getYear(), quarter);
    }

    private static void setBizChanged(DynamicObject dyo, String propName, boolean value) {
        if (dyo == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)propName)) {
            return;
        }
        DynamicProperty property = dyo.getDynamicObjectType().getProperty(propName);
        dyo.getDataEntityState().setBizChanged(property.getOrdinal(), value);
    }

    public static void setValueWithoutDBField(IDataModel model, String propertyName, Object value) {
        model.setValue(propertyName, value);
        ErCommonUtils.setBizChanged(model.getDataEntity(), propertyName, false);
    }

    public static void setDealUnit(IFormView view, Long unitId) {
        String formId = view.getEntityId();
        if (ErEntityTypeUtils.isPublicReimburseBill((String)formId) || ErEntityTypeUtils.isPrePayBill((String)formId)) {
            if (unitId != null && unitId != 0L) {
                view.getModel().beginInit();
                view.getModel().setValue("billpayerid", (Object)unitId);
                view.getModel().endInit();
                view.updateView("accountentry");
            }
        } else {
            view.getPageCache().put("headUnit", String.valueOf(unitId));
        }
    }

    public static String getCostOrgUseMode(Long companyId) {
        String useMode = (String)ErCommonUtils.getEMParameter(companyId, "costorgusemode");
        return useMode == null ? "0" : useMode;
    }

    public static int getCostCenterSelect(Long companyId) {
        Object emParameter = ErCommonUtils.getEMParameter(companyId, "costcenterselectrange");
        if (emParameter != null) {
            return Integer.parseInt(emParameter.toString());
        }
        return 1;
    }

    public static String getTripDateSelectRange(Long companyId) {
        String range = (String)ErCommonUtils.getEMParameter(companyId, "tripdateselectrange");
        return range == null ? "0" : range;
    }

    public static boolean isHasOnWayDownBill(String sBillType, Long sBillId, List<EntityInfo> downBillInfos) {
        for (EntityInfo info : downBillInfos) {
            String selectedProperties = String.join((CharSequence)",", "id", "billstatus", info.entryName + ".id", info.entryName + "." + info.sourceName);
            QFilter f = new QFilter(info.entryName + "." + info.sourceName, "=", (Object)sBillId);
            f.and("billstatus", "in", (Object)info.status);
            DynamicObject[] onWayBills = BusinessDataServiceHelper.load((String)info.entityName, (String)selectedProperties, (QFilter[])new QFilter[]{f});
            if (onWayBills == null || onWayBills.length <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isXkModeType() {
        return LicenseServiceHelper.getModeType() == 4;
    }

    public static boolean costcompanyonlyleaf() {
        return !ErCommonUtils.isXkModeType() && !"2".equals(ErStdConfig.get((String)"costcompanyonlyleaf"));
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(date);
    }

    public static String getDynObjLocalName(DynamicObject dyn) {
        if (dyn == null) {
            return "";
        }
        return dyn.getLocaleString("name") == null ? "" : dyn.getLocaleString("name").getLocaleValue();
    }

    public static boolean hasProperties(Object obj, String ... propNames) {
        if (obj instanceof DynamicObject) {
            for (String propName : propNames) {
                if (StringUtils.isBlank((String)propName)) {
                    return false;
                }
                DynamicProperty property = ((DynamicObject)obj).getDynamicObjectType().getProperty(propName);
                if (property != null) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof IFormView) {
            IDataModel model = ((IFormView)obj).getModel();
            return ErCommonUtils.hasProperties(model, propNames);
        }
        if (obj instanceof IDataModel) {
            for (String propName : propNames) {
                if (StringUtils.isBlank((String)propName)) {
                    return false;
                }
                if (((IDataModel)obj).getProperty(propName) != null) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof DynamicObjectCollection) {
            DynamicObjectType objectType = ((DynamicObjectCollection)obj).getDynamicObjectType();
            for (String propName : propNames) {
                if (StringUtils.isBlank((String)propName)) {
                    return false;
                }
                DynamicProperty property = objectType.getProperty(propName);
                if (property != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

