/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.property.BooleanProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.cache.model.CheckLevel;
import kd.fi.er.business.invoicecloud.cache.model.DuplicateInvoiceDo;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.provider.param.req.DeleteVoucherRequestParam;
import kd.fi.er.business.invoicecloud.provider.param.req.SaveVoucherRequestParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.DeleteVoucherResp;
import kd.fi.er.business.invoicecloud.provider.param.resp.SaveVoucherResp;
import kd.fi.er.business.invoicecloud.util.InvoiceTypeUtils;
import kd.fi.er.business.invoicecloud.v2.InvoiceFrom;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.model.ChangeField;
import kd.fi.er.business.utils.model.DetailExpenseModel;
import kd.fi.er.common.invoice.utils.InvoiceUtils2;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.common.model.invoice.ItemInvoiceRelationEnum;
import kd.fi.er.common.model.invoice.bo.PropBo;
import kd.fi.er.common.model.invoice.xh.QueryInvoiceDetailParam;
import kd.fi.er.formplugin.util.OffsetUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.base.Objects;

public class InvoiceUtils {
    @Deprecated
    public static final Set<String> VATINVOICE;
    public static final Set<String> SIGNS;
    public static final Set<String> LEFTSIGNS;
    public static final Set<String> RIGHTSIGNS;
    public static final String LEFTSIGN = "(";
    public static final String RIGHTSIGN = ")";
    private static final Log log;
    private static final String ITEM_TAX_AMOUNT = "item_tax_amount";
    private static final String ITEM_NOT_TAX_AMOUNT = "item_not_tax_amount";
    private static final String ITEM_APPROVE_AMOUNT = "item_approve_amount";
    private static final String STRICT_CONTROL;
    private static final String ONLY_SUGGEST;
    private static final String NO_CONTROL;

    public static String getLimitedLenStr(String rawStr, int len) {
        if (len < 0 || rawStr == null || rawStr.length() == 0 || rawStr.length() <= len) {
            return rawStr;
        }
        if (len == 0) {
            return "";
        }
        String result = rawStr.substring(0, len);
        if (result.length() > 3) {
            result = result.substring(0, len - 3) + "...";
        }
        return result;
    }

    public static String removeSign(String name) {
        for (String sign : SIGNS) {
            name = StringUtils.replace((String)name, (String)sign, (String)"");
        }
        return name;
    }

    public static String repeatSign(String name) {
        for (String sign : RIGHTSIGNS) {
            name = StringUtils.replace((String)name, (String)sign, (String)RIGHTSIGN);
        }
        for (String sign : LEFTSIGNS) {
            name = StringUtils.replace((String)name, (String)sign, (String)LEFTSIGN);
        }
        return name;
    }

    public static String getLimitedInvoiceNo(String rawInvoiceNo) {
        return InvoiceUtils.getLimitedLenStr(rawInvoiceNo, 255);
    }

    public static String getLimitedInvoiceCode(String rawInvoiceCode) {
        return InvoiceUtils.getLimitedLenStr(rawInvoiceCode, 129);
    }

    public static String getLimitedValidateMessage(String validateMessage) {
        return InvoiceUtils.getLimitedLenStr(validateMessage, 255);
    }

    @Deprecated
    public static List<DynamicObject> getEntryEntityByEntryIds(DynamicObjectCollection entrys, Collection<Long> entryIds) {
        return new ArrayList<DynamicObject>();
    }

    public static boolean isSameInvoiceType(DynamicObject dataEntity, Set<Long> itemIds, List<InvoiceVO> invoiceVOs) {
        Map<String, Map<Long, Object>> invocieInfoMap;
        Map<Long, Object> invoiceTypeKey;
        boolean isMustSameType = ErStdConfig.isMustSameInvoiceTypeInRelatingInvoice();
        if (!isMustSameType) {
            return true;
        }
        HashSet types = Sets.newHashSet();
        if (invoiceVOs != null && !invoiceVOs.isEmpty()) {
            types.addAll(invoiceVOs.stream().map(v -> v.getInvoiceType()).collect(Collectors.toSet()));
        }
        if ((invoiceTypeKey = (invocieInfoMap = InvoiceUtils.getInvoiceInfoOfItems(dataEntity, Sets.newHashSet((Object[])new String[]{"invoicetype"}), itemIds)).get("invoicetype")) != null) {
            types.addAll(invoiceTypeKey.values().stream().collect(Collectors.toSet()));
        }
        return types.size() == 1;
    }

    public static void refresh(DynamicObject dataEntity, DynamicObject expenseItem, List<DynamicObject> invoiceList) {
        if (BigDecimal.ZERO.compareTo(expenseItem.getBigDecimal("taxrate")) == 0) {
            Set<Long> invoiceItemIdOfInvoiceItemEntry = InvoiceUtils.autoMapInvoiceItemMappingInfo(dataEntity).get(expenseItem.getPkValue());
            List<Object> invoiceItemList = Lists.newArrayList();
            if (invoiceItemIdOfInvoiceItemEntry != null) {
                invoiceItemList = dataEntity.getDynamicObjectCollection("invoiceitementry").stream().filter(invoiceItem -> invoiceItemIdOfInvoiceItemEntry.contains(invoiceItem.getPkValue())).collect(Collectors.toList());
            }
            if (!invoiceItemList.isEmpty()) {
                BigDecimal tax = ((DynamicObject)invoiceItemList.get(0)).getBigDecimal("invoiceitemtaxrate");
                if (invoiceItemList.stream().allMatch(invoiceItem -> tax.compareTo(invoiceItem.getBigDecimal("invoiceitemtaxrate")) == 0)) {
                    BigDecimal taxAmount = invoiceItemList.stream().map(item -> (BigDecimal)ObjectUtils.defaultIfNull((Object)item.getBigDecimal("invoiceitemtaxamout"), (Object)BigDecimal.ZERO)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    expenseItem.set("taxrate", (Object)tax.multiply(BigDecimal.valueOf(100L)));
                    expenseItem.set("taxamount", (Object)taxAmount);
                }
            }
        }
    }

    public static List<String> checkUnbindInvoice(DynamicObject bill, ExtendedDataEntity dataEntity) {
        ArrayList resultList = Lists.newArrayList();
        DynamicObjectCollection invoiceEntrys = bill.getDynamicObjectCollection("invoiceentry");
        ArrayList noMapInvoiceNo = Lists.newArrayListWithExpectedSize((int)invoiceEntrys.size());
        for (DynamicObject invoiceEntry : invoiceEntrys) {
            String invoiceFrom = invoiceEntry.getString("invoicefrom");
            if (!StringUtils.equalsIgnoreCase((CharSequence)ItemFrom.InvoiceCloud.getValue(), (CharSequence)invoiceFrom) && !StringUtils.equalsIgnoreCase((CharSequence)ItemFrom.Manual.getValue(), (CharSequence)invoiceFrom)) continue;
            BigDecimal totalAmount = invoiceEntry.getBigDecimal("totalamount");
            if (StringUtils.equals((CharSequence)ErStdConfig.getInvoiceZeroAmountCreateItem(), (CharSequence)"0") && BigDecimal.ZERO.compareTo(totalAmount) == 0 || !InvoiceUtils.getExpenseEntryByInvoiceEntryId(bill, (Long)invoiceEntry.getPkValue()).isEmpty()) continue;
            String invoiceNo = invoiceEntry.getString("seq");
            noMapInvoiceNo.add(invoiceNo);
        }
        if (!noMapInvoiceNo.isEmpty()) {
            String noMap = StringUtils.join((Iterable)noMapInvoiceNo, (String)",");
            String fmt = ResManager.loadKDString((String)"\u7b2c%s\u884c\u53d1\u7968\u672a\u5173\u8054\u8d39\u7528\uff0c\u8bf7\u5173\u8054\u540e\u518d\u63d0\u4ea4\u3002", (String)"InvoiceUtils_0", (String)"fi-er-business", (Object[])new Object[0]);
            resultList.add(String.format(fmt, noMap));
        }
        return resultList;
    }

    public static List<String> checkKeyAmount(DynamicObject bill, BillEntityType type, String key, String keyName) {
        ArrayList resultList = Lists.newArrayList();
        DynamicObjectCollection invoiceEntry = bill.getDynamicObjectCollection("invoiceentry");
        if (invoiceEntry.isEmpty()) {
            return resultList;
        }
        Map<String, BigDecimal> itemMap = InvoiceUtils.itemOfInvoice(bill, type, (Set<String>)Sets.newHashSet((Object[])new String[]{key}));
        Map<String, BigDecimal> invoiceMap = InvoiceUtils.invoiceInfo(bill, type, (Set<String>)Sets.newHashSet((Object[])new String[]{"totalamount"}));
        BigDecimal itemAmount = itemMap.get(key);
        BigDecimal invoiceAmount = invoiceMap.get("totalamount");
        log.info("\u5355\u636e\u7f16\u53f7\uff1a" + bill.getString("billno") + "\uff0c \u8d39\u7528" + key + "\u603b\u548c\uff1a " + itemAmount + "\uff0c \u53d1\u7968\u62a5\u9500\u91d1\u989d\u603b\u548c\uff1a" + invoiceAmount);
        BigDecimal differAmount = itemAmount.subtract(invoiceAmount);
        QFilter queryFilter = new QFilter("id", "=", (Object)1);
        String selectPropties = "id,sign,amtprecision";
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)selectPropties, (QFilter[])new QFilter[]{queryFilter});
        String sign = currency.getString("sign");
        int amtprecision = currency.getInt("amtprecision");
        StringBuilder sb = new StringBuilder(keyName).append(ResManager.loadKDString((String)"\u8d85\u51fa\u53d1\u7968\u91d1\u989d%s", (String)"InvoiceUtils_1", (String)"fi-er-business", (Object[])new Object[0]));
        if (differAmount.compareTo(BigDecimal.ZERO) > 0) {
            String formatStr = AmountUtils.formatMoneyByUser((Long)RequestContext.get().getCurrUserId(), (String)sign, (int)amtprecision, (BigDecimal)differAmount);
            resultList.add(String.format(sb.toString(), formatStr));
        }
        return resultList;
    }

    public static List<String> checkKeyAmount(IDataModel model, BillEntityType type, String key, String keyName) {
        ArrayList resultList = Lists.newArrayList();
        Map<String, BigDecimal> itemMap = InvoiceUtils.itemOfInvoice(model, type, (Set<String>)Sets.newHashSet((Object[])new String[]{key}));
        Map<String, BigDecimal> invoiceMap = InvoiceUtils.invoiceInfo(model, type, (Set<String>)Sets.newHashSet((Object[])new String[]{"totalamount"}));
        BigDecimal itemAmount = itemMap.get(key);
        BigDecimal invoiceAmount = invoiceMap.get("totalamount");
        log.info("\u5355\u636e\u7f16\u53f7\uff1a" + model.getValue("billno") + "\uff0c \u8d39\u7528" + key + "\u603b\u548c\uff1a " + itemAmount + "\uff0c \u53d1\u7968\u62a5\u9500\u91d1\u989d\u603b\u548c\uff1a" + invoiceAmount);
        BigDecimal differAmount = itemAmount.subtract(invoiceAmount);
        QFilter queryFilter = new QFilter("id", "=", (Object)1);
        String selectPropties = "id,sign,amtprecision";
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)selectPropties, (QFilter[])new QFilter[]{queryFilter});
        String sign = currency.getString("sign");
        int amtprecision = currency.getInt("amtprecision");
        StringBuilder sb = new StringBuilder(keyName).append(ResManager.loadKDString((String)"\u8d85\u51fa\u53d1\u7968\u91d1\u989d%s", (String)"InvoiceUtils_1", (String)"fi-er-business", (Object[])new Object[0]));
        if (differAmount.compareTo(BigDecimal.ZERO) > 0) {
            String formatStr = AmountUtils.formatMoneyByUser((Long)RequestContext.get().getCurrUserId(), (String)sign, (int)amtprecision, (BigDecimal)differAmount);
            resultList.add(String.format(sb.toString(), formatStr));
        }
        return resultList;
    }

    public static <T> List<String> checkAmount(T bill, BillEntityType type) {
        if (bill instanceof IDataModel) {
            return InvoiceUtils.checkKeyAmount((IDataModel)bill, type, type.getAmountKey(), ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d", (String)"InvoiceUtils_2", (String)"fi-er-business", (Object[])new Object[0]));
        }
        if (bill instanceof DynamicObject) {
            return InvoiceUtils.checkKeyAmount((DynamicObject)bill, type, type.getAmountKey(), ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d", (String)"InvoiceUtils_2", (String)"fi-er-business", (Object[])new Object[0]));
        }
        return new ArrayList<String>();
    }

    public static List<String> checkTaxAmount(DynamicObject bill, BillEntityType type) {
        ArrayList resultList = Lists.newArrayList();
        BigDecimal stdDifference = BigDecimal.ZERO;
        try {
            stdDifference = ErStdConfig.taxDifferenceClear();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7a0e\u989d\u5dee\u503c\u5931\u8d25", (Throwable)e);
            return resultList;
        }
        log.info("\u5355\u636eid: \u5c3e\u5dee\uff1a%s , ");
        if (BigDecimal.ZERO.compareTo(stdDifference) == 0) {
            return resultList;
        }
        Map<String, BigDecimal> itemMap = InvoiceUtils.itemOfInvoice(bill, type, (Set<String>)Sets.newHashSet((Object[])new String[]{"taxamount"}));
        Map<String, BigDecimal> invoiceMap = InvoiceUtils.invoiceInfo(bill, type, (Set<String>)Sets.newHashSet((Object[])new String[]{"taxamount_invoice"}));
        BigDecimal itemTaxAmout = itemMap.get("taxamount");
        BigDecimal invoiceTaxAmout = invoiceMap.get("taxamount_invoice");
        log.info("\u5355\u636e\u7f16\u53f7\uff1a" + bill.getString("billno") + "\uff0c \u8d39\u7528\u7a0e\u989d\u603b\u548c\uff1a " + itemTaxAmout + "\uff0c \u53d1\u7968\u7a0e\u989d\u603b\u548c\uff1a" + invoiceTaxAmout);
        if (invoiceTaxAmout.compareTo(itemTaxAmout) < 0) {
            BigDecimal difference = itemTaxAmout.subtract(invoiceTaxAmout);
            HashSet itemIds = Sets.newHashSet();
            Map<Long, Set<Long>> invoiceItemMap = InvoiceUtils.autoMapInvoiceMappingInfo(bill);
            Map<Long, Set<Long>> invoiceAndItemMap = InvoiceUtils.nonAutoMapInvoiceMappingInfo(bill);
            itemIds.addAll(invoiceItemMap.keySet());
            itemIds.addAll(invoiceAndItemMap.keySet());
            String fmt = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c \u8d39\u7528\u7a0e\u989d\u603b\u548c - \u53d1\u7968\u7a0e\u989d\u603b\u548c = %2$s", (String)"InvoiceUtils_15", (String)"fi-er-business", (Object[])new Object[0]);
            log.info(String.format("\u5355\u636e\u7f16\u53f7\uff1a%s\uff0c \u8d39\u7528\u7a0e\u989d\u603b\u548c - \u53d1\u7968\u7a0e\u989d\u603b\u548c = %s", bill.getString("billno"), difference));
            resultList.add(String.format(fmt, bill.getString("billno"), difference));
            InvoiceUtils.clearDiffernce(bill, difference, itemIds, type);
        }
        return resultList;
    }

    public static List<String> checkOffsetTaxAmount(DynamicObject bill, BillEntityType type) {
        ArrayList resultList = Lists.newArrayList();
        if (!ErStdConfig.isTaxDifferenceValidate()) {
            return resultList;
        }
        Map<String, BigDecimal> itemMap = InvoiceUtils.itemOfInvoice(bill, type, (Set<String>)Sets.newHashSet((Object[])new String[]{"deductibletax"}));
        Map<String, BigDecimal> invoiceMap = InvoiceUtils.invoiceInfo(bill, type, (Set<String>)Sets.newHashSet((Object[])new String[]{"taxamount_invoice"}));
        BigDecimal itemOffsetTaxAmout = itemMap.get("deductibletax");
        BigDecimal invoiceOffsetTaxAmout = invoiceMap.get("taxamount_invoice");
        log.info("\u5355\u636e\u7f16\u53f7\uff1a" + bill.getString("billno") + "\uff0c \u8d39\u7528\u53ef\u62b5\u6263\u7a0e\u989d\u603b\u548c\uff1a " + itemOffsetTaxAmout + "\uff0c \u53d1\u7968\u53ef\u62b5\u6263\u7a0e\u989d\u603b\u548c\uff1a" + invoiceOffsetTaxAmout);
        if (invoiceOffsetTaxAmout.compareTo(itemOffsetTaxAmout) < 0) {
            BigDecimal difference = itemOffsetTaxAmout.subtract(invoiceOffsetTaxAmout);
            String fmt = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c \u8d39\u7528\u53ef\u62b5\u6263\u7a0e\u989d\u603b\u548c - \u53d1\u7968\u53ef\u62b5\u6263\u7a0e\u989d\u603b\u548c = %2$s", (String)"InvoiceUtils_18", (String)"fi-er-business", (Object[])new Object[0]);
            log.info(String.format("\u5355\u636e\u7f16\u53f7\uff1a%s\uff0c \u8d39\u7528\u53ef\u62b5\u6263\u7a0e\u989d\u603b\u548c - \u53d1\u7968\u53ef\u62b5\u6263\u7a0e\u989d\u603b\u548c = %s", bill.getString("billno"), difference));
            resultList.add(String.format(fmt, bill.getString("billno"), difference));
        }
        return resultList;
    }

    public static Map<String, BigDecimal> itemOfInvoice(DynamicObject bill, BillEntityType type, Set<String> keys) {
        Map<Long, Set<Long>> invoiceItemMap = InvoiceUtils.autoMapInvoiceMappingInfo(bill);
        Map<Long, Set<Long>> invoiceAndItemMap = InvoiceUtils.nonAutoMapInvoiceMappingInfo(bill);
        HashSet itemIds = Sets.newHashSet();
        itemIds.addAll(invoiceItemMap.keySet());
        itemIds.addAll(invoiceAndItemMap.keySet());
        Map<String, BigDecimal> itemMap = InvoiceUtils.getItemValue(bill, (Set<Long>)itemIds, type, keys);
        return itemMap;
    }

    public static Map<String, BigDecimal> itemOfInvoice(IDataModel model, BillEntityType type, Set<String> keys) {
        Map<Long, Set<Long>> invoiceItemMap = InvoiceUtils.autoMapInvoiceMappingInfo(model);
        Map<Long, Set<Long>> invoiceAndItemMap = InvoiceUtils.nonAutoMapInvoiceMappingInfo(model);
        HashSet itemIds = Sets.newHashSet();
        itemIds.addAll(invoiceItemMap.keySet());
        itemIds.addAll(invoiceAndItemMap.keySet());
        Map<String, BigDecimal> itemMap = InvoiceUtils.getItemValue(model, (Set<Long>)itemIds, type, keys);
        return itemMap;
    }

    public static Map<String, BigDecimal> invoiceInfo(DynamicObject bill, BillEntityType type, Set<String> keys) {
        Map<Long, Set<Long>> invoiceItemMap = InvoiceUtils.autoMapInvoiceMappingInfo(bill);
        Map<Long, Set<Long>> invoiceAndItemMap = InvoiceUtils.nonAutoMapInvoiceMappingInfo(bill);
        HashSet invoiceItemEntryIds = Sets.newHashSet();
        invoiceItemMap.values().forEach(invoice -> invoiceItemEntryIds.addAll(invoice));
        invoiceAndItemMap.values().forEach(invoice -> invoiceItemEntryIds.addAll(invoice));
        Map<String, BigDecimal> invoiceMap = InvoiceUtils.getInvoiceValue(bill, (Set<Long>)invoiceItemEntryIds, keys);
        return invoiceMap;
    }

    public static Map<String, BigDecimal> invoiceInfo(IDataModel model, BillEntityType type, Set<String> keys) {
        Map<Long, Set<Long>> invoiceItemMap = InvoiceUtils.autoMapInvoiceMappingInfo(model);
        Map<Long, Set<Long>> invoiceAndItemMap = InvoiceUtils.nonAutoMapInvoiceMappingInfo(model);
        HashSet invoiceItemEntryIds = Sets.newHashSet();
        invoiceItemMap.values().forEach(invoice -> invoiceItemEntryIds.addAll(invoice));
        invoiceAndItemMap.values().forEach(invoice -> invoiceItemEntryIds.addAll(invoice));
        Map<String, BigDecimal> invoiceMap = InvoiceUtils.getInvoiceValue(model, (Set<Long>)invoiceItemEntryIds, keys);
        return invoiceMap;
    }

    public static Set<Long> mapInvoiceSet(DynamicObject bill, Long expenseId) {
        HashSet invoiceSet = Sets.newHashSet();
        Boolean isAutoMapInvoice = bill.getBoolean("automapinvoice");
        if (isAutoMapInvoice.booleanValue()) {
            Set<Long> autoInvoiceSet = InvoiceUtils.autoMapInvoiceMappingInfo(bill).get(expenseId);
            if (autoInvoiceSet != null) {
                invoiceSet.addAll(autoInvoiceSet);
            }
        } else {
            Set<Long> nonAutoInvoiceSet = InvoiceUtils.nonAutoMapInvoiceMappingInfo(bill).get(expenseId);
            if (nonAutoInvoiceSet != null) {
                invoiceSet.addAll(nonAutoInvoiceSet);
            }
        }
        return invoiceSet;
    }

    public static Set<Long> mapInvoiceSetCache(IDataModel dataModel, Long expenseId) {
        HashSet invoiceSet = Sets.newHashSet();
        Boolean autoInvoice = (Boolean)dataModel.getValue("automapinvoice");
        if (autoInvoice.booleanValue()) {
            Set autoInvoiceSet = (Set)InvoiceUtils2.autoMapInvoiceMappingInfoCache((IDataModel)dataModel, (String)"autoMapInvoiceMappingInfo").get(expenseId);
            if (autoInvoiceSet != null) {
                invoiceSet.addAll(autoInvoiceSet);
            }
        } else {
            Set nonAutoInvoiceSet = (Set)InvoiceUtils2.nonAutoMapInvoiceMappingInfoCache((IDataModel)dataModel, (String)"nonAutoMapInvoiceMappingInfo").get(expenseId);
            if (nonAutoInvoiceSet != null) {
                invoiceSet.addAll(nonAutoInvoiceSet);
            }
        }
        return invoiceSet;
    }

    public static Map<Long, Set<Long>> autoMapInvoiceMappingInfo(DynamicObject bill) {
        Map<Long, Set<Long>> invoiceItemMap = InvoiceUtils.getInvoiceItemColl(bill, "invoiceitementry", "itementryid", "invoiceheadentryid");
        if (invoiceItemMap.isEmpty()) {
            return invoiceItemMap;
        }
        IDataEntityProperty tripEntryProp = (IDataEntityProperty)bill.getDataEntityType().getProperties().get((Object)"tripentry");
        IDataEntityProperty expenseEntryProp = (IDataEntityProperty)bill.getDataEntityType().getProperties().get((Object)"expenseentryentity");
        HashMap splitLine = new HashMap();
        DynamicObjectCollection entryEntity = null;
        if (tripEntryProp != null) {
            if ("1".equals(bill.getString("billkind"))) {
                entryEntity = ((DynamicObject)bill.getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
            }
        } else if (expenseEntryProp != null) {
            entryEntity = bill.getDynamicObjectCollection("expenseentryentity");
        }
        if (entryEntity != null && entryEntity.getDynamicObjectType().getProperty("invoicefromparent") != null) {
            DynamicObjectCollection finalEntryEntity = entryEntity;
            invoiceItemMap.forEach((key, value) -> finalEntryEntity.stream().filter(obj -> obj.getBoolean("invoicefromparent") && key == Long.parseLong(obj.getString("splitline"))).map(obj -> (Long)obj.getPkValue()).forEach(pkValue -> splitLine.put(pkValue, value)));
            if (!splitLine.isEmpty()) {
                invoiceItemMap.putAll(splitLine);
            }
        }
        return invoiceItemMap;
    }

    public static Map<Long, Set<Long>> autoMapInvoiceMappingInfo(IDataModel model) {
        Map<Long, Set<Long>> invoiceItemMap = InvoiceUtils.getInvoiceItemColl(model, "invoiceitementry", "itementryid", "invoiceheadentryid");
        if (invoiceItemMap.isEmpty()) {
            return invoiceItemMap;
        }
        IDataEntityProperty tripEntryProp = (IDataEntityProperty)model.getDataEntityType().getProperties().get((Object)"tripentry");
        IDataEntityProperty expenseEntryProp = (IDataEntityProperty)model.getDataEntityType().getProperties().get((Object)"expenseentryentity");
        HashMap splitLine = new HashMap();
        DynamicObjectCollection entryEntity = null;
        if (tripEntryProp != null) {
            if ("1".equals(model.getValue("billkind"))) {
                entryEntity = model.getEntryEntity("entryentity");
            }
        } else if (expenseEntryProp != null) {
            entryEntity = model.getEntryEntity("expenseentryentity");
        }
        if (entryEntity != null && entryEntity.getDynamicObjectType().getProperty("invoicefromparent") != null) {
            DynamicObjectCollection finalEntryEntity = entryEntity;
            invoiceItemMap.forEach((key, value) -> finalEntryEntity.stream().filter(obj -> obj.getBoolean("invoicefromparent") && key == Long.parseLong(obj.getString("splitline"))).map(obj -> (Long)obj.getPkValue()).forEach(pkValue -> splitLine.put(pkValue, value)));
            if (!splitLine.isEmpty()) {
                invoiceItemMap.putAll(splitLine);
            }
        }
        return invoiceItemMap;
    }

    @Deprecated
    public static Map<Long, Set<Long>> autoMapInvoiceMappingInfoCache(IDataModel model, String cacheKey) {
        return null;
    }

    @Deprecated
    public static Map<Long, Set<Long>> autoMapInvoiceItemMappingInfo(IDataModel model) {
        return new HashMap<Long, Set<Long>>();
    }

    public static Map<Long, Set<Long>> autoMapInvoiceItemMappingInfo(DynamicObject bill) {
        Map<Long, Set<Long>> invoiceItemMap = InvoiceUtils.getInvoiceItemColl(bill, "invoiceitementry", "itementryid", "id");
        if (invoiceItemMap.isEmpty()) {
            return invoiceItemMap;
        }
        IDataEntityProperty tripEntryProp = (IDataEntityProperty)bill.getDataEntityType().getProperties().get((Object)"tripentry");
        IDataEntityProperty expenseEntryProp = (IDataEntityProperty)bill.getDataEntityType().getProperties().get((Object)"expenseentryentity");
        HashMap splitLine = new HashMap();
        DynamicObjectCollection entryEntity = null;
        if (tripEntryProp != null) {
            if ("1".equals(bill.getString("billkind"))) {
                entryEntity = ((DynamicObject)bill.getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
            }
        } else if (expenseEntryProp != null) {
            entryEntity = bill.getDynamicObjectCollection("expenseentryentity");
        }
        if (entryEntity != null && entryEntity.getDynamicObjectType().getProperty("invoicefromparent") != null) {
            DynamicObjectCollection finalEntryEntity = entryEntity;
            invoiceItemMap.forEach((key, value) -> finalEntryEntity.stream().filter(obj -> obj.getBoolean("invoicefromparent") && key == Long.parseLong(obj.getString("splitline"))).map(obj -> (Long)obj.getPkValue()).forEach(pkValue -> splitLine.put(pkValue, value)));
            if (!splitLine.isEmpty()) {
                invoiceItemMap.putAll(splitLine);
            }
        }
        return invoiceItemMap;
    }

    public static Map<Long, Set<Long>> autoMapItemMappingInfo(DynamicObject bill) {
        Map<Long, Set<Long>> invoiceItemMap = InvoiceUtils.getInvoiceItemColl(bill, "invoiceitementry", "invoiceheadentryid", "itementryid");
        if (invoiceItemMap.isEmpty()) {
            return invoiceItemMap;
        }
        IDataEntityProperty tripEntryProp = (IDataEntityProperty)bill.getDataEntityType().getProperties().get((Object)"tripentry");
        IDataEntityProperty expenseEntryProp = (IDataEntityProperty)bill.getDataEntityType().getProperties().get((Object)"expenseentryentity");
        DynamicObjectCollection entryEntity = null;
        if (tripEntryProp != null) {
            if ("1".equals(bill.getString("billkind"))) {
                entryEntity = ((DynamicObject)bill.getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
            }
        } else if (expenseEntryProp != null) {
            entryEntity = bill.getDynamicObjectCollection("expenseentryentity");
        }
        if (entryEntity != null && entryEntity.getDynamicObjectType().getProperty("invoicefromparent") != null) {
            DynamicObjectCollection finalEntryEntity = entryEntity;
            invoiceItemMap.forEach((key, value) -> finalEntryEntity.stream().filter(obj -> obj.getBoolean("invoicefromparent") && value.contains(Long.parseLong(obj.getString("splitline")))).map(obj -> (Long)obj.getPkValue()).forEach(pkValue -> value.add(pkValue)));
        }
        return invoiceItemMap;
    }

    @Deprecated
    public static Map<Long, Set<Long>> autoMapItemMappingInfoCache(IFormView view, IDataModel model, String cacheKey) {
        return null;
    }

    @Deprecated
    public static Map<Long, Set<Long>> autoMapItemMappingInfo(IFormView view, DynamicObject bill) {
        return null;
    }

    @Deprecated
    public static Map<Long, Set<Long>> autoMapItemMappingInfo(IFormView view) {
        return new HashMap<Long, Set<Long>>();
    }

    public static Map<Long, Set<Long>> nonAutoMapInvoiceMappingInfo(DynamicObject bill) {
        Map<Long, Set<Long>> invoiceAndItemMap = InvoiceUtils.getInvoiceItemColl(bill, "invoiceandexpense", "expenseentryid", "invoiceentryid");
        return invoiceAndItemMap;
    }

    public static Map<Long, Set<Long>> nonAutoMapInvoiceMappingInfo(IDataModel model) {
        Map<Long, Set<Long>> invoiceAndItemMap = InvoiceUtils.getInvoiceItemColl(model, "invoiceandexpense", "expenseentryid", "invoiceentryid");
        return invoiceAndItemMap;
    }

    @Deprecated
    public static Map<Long, Set<Long>> nonAutoMapInvoiceMappingInfoCache(IDataModel dataModel, String cacheKey) {
        return new HashMap<Long, Set<Long>>();
    }

    public static Map<Long, Set<Long>> nonAutoMapItemMapingInfo(DynamicObject bill) {
        Map<Long, Set<Long>> invoiceAndItemMap = InvoiceUtils.getInvoiceItemColl(bill, "invoiceandexpense", "invoiceentryid", "expenseentryid");
        return invoiceAndItemMap;
    }

    @Deprecated
    public static Map<Long, Set<Long>> nonAutoMapItemMappingInfoCache(IDataModel model, String cacheKey) {
        return null;
    }

    @Deprecated
    public static Map<Long, Set<Long>> nonAutoMapItemMappingInfoCache(IFormView view, IDataModel model, String cacheKey) {
        return null;
    }

    @Deprecated
    public static Map<Long, Set<Long>> nonAutoMapItemMappingInfo(IFormView view, DynamicObject bill) {
        return new HashMap<Long, Set<Long>>();
    }

    public static Map<Long, Set<Long>> nonAutoMapItemMappingInfo(IFormView view) {
        return null;
    }

    public static List<DynamicObject> getAutoInvoiceItemByItemId(DynamicObject bill, Long itemId) {
        return bill.getDynamicObjectCollection("invoiceitementry").stream().filter(v -> Objects.equal((Object)itemId, (Object)v.getLong("itementryid"))).collect(Collectors.toList());
    }

    public static List<DynamicObject> getAutoInvoiceItemByItemId(IDataModel model, Long itemId) {
        return model.getEntryEntity("invoiceitementry").stream().filter(v -> Objects.equal((Object)itemId, (Object)v.getLong("itementryid"))).collect(Collectors.toList());
    }

    public static List<DynamicObject> getNonAutoInvoiceItemByItemId(DynamicObject bill, Long itemId) {
        Set<Long> invoiceIdsSet = InvoiceUtils.nonAutoMapInvoiceMappingInfo(bill).get(itemId);
        return InvoiceUtils.getInvoiceItemByInvoiceHeadIds(bill, invoiceIdsSet);
    }

    public static List<DynamicObject> getNonAutoInvoiceItemByItemId(IDataModel model, Long itemId) {
        Set<Long> invoiceIdsSet = InvoiceUtils.nonAutoMapInvoiceMappingInfo(model).get(itemId);
        return InvoiceUtils.getInvoiceItemByInvoiceHeadIds(model, invoiceIdsSet);
    }

    public static List<DynamicObject> getAutoInvoiceInfoByItemId(DynamicObject bill, Long itemId) {
        Set invoiceHeadIdSet = bill.getDynamicObjectCollection("invoiceitementry").stream().filter(v -> Objects.equal((Object)itemId, (Object)v.getLong("itementryid"))).map(invoiceItem -> invoiceItem.getLong("invoiceheadentryid")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(invoiceHeadIdSet)) {
            return new ArrayList<DynamicObject>();
        }
        List<DynamicObject> relateInvoiceEntry = bill.getDynamicObjectCollection("invoiceentry").stream().filter(invoiceEntry -> invoiceHeadIdSet.contains(invoiceEntry.getPkValue())).collect(Collectors.toList());
        return relateInvoiceEntry;
    }

    public static List<DynamicObject> getAutoInvoiceInfoByItemId(IDataModel model, Long itemId) {
        Map autoMapInvoiceMappingInfo = InvoiceUtils2.autoMapInvoiceMappingInfoCache((IDataModel)model, (String)"autoMapInvoiceMappingInfo");
        Set invoiceHeadIdSet = (Set)autoMapInvoiceMappingInfo.get(itemId);
        if (CollectionUtils.isEmpty((Collection)invoiceHeadIdSet)) {
            return new ArrayList<DynamicObject>();
        }
        List<DynamicObject> relateInvoiceEntry = model.getEntryEntity("invoiceentry").stream().filter(invoiceEntry -> invoiceHeadIdSet.contains(invoiceEntry.getPkValue())).collect(Collectors.toList());
        return relateInvoiceEntry;
    }

    public static List<DynamicObject> getNonAutoInvoiceInfoByItemId(DynamicObject bill, Long itemId) {
        Set invoiceHeadIdSet = bill.getDynamicObjectCollection("invoiceandexpense").stream().filter(v -> Objects.equal((Object)itemId, (Object)v.getLong("expenseentryid"))).map(invoiceItem -> invoiceItem.getLong("invoiceentryid")).collect(Collectors.toSet());
        if (invoiceHeadIdSet.isEmpty()) {
            return new ArrayList<DynamicObject>();
        }
        List<DynamicObject> relateInvoiceEntry = bill.getDynamicObjectCollection("invoiceentry").stream().filter(invoiceEntry -> invoiceHeadIdSet.contains(invoiceEntry.getPkValue())).collect(Collectors.toList());
        return relateInvoiceEntry;
    }

    public static List<DynamicObject> getNonAutoInvoiceInfoByItemId(IDataModel model, Long itemId) {
        Map nonAutoInvoiceInfo = InvoiceUtils2.nonAutoMapInvoiceMappingInfoCache((IDataModel)model, (String)"nonAutoMapInvoiceMappingInfo");
        Set invoiceHeadIdSet = (Set)nonAutoInvoiceInfo.get(itemId);
        if (CollectionUtils.isEmpty((Collection)invoiceHeadIdSet)) {
            return new ArrayList<DynamicObject>();
        }
        List<DynamicObject> relateInvoiceEntry = model.getEntryEntity("invoiceentry").stream().filter(invoiceEntry -> invoiceHeadIdSet.contains(invoiceEntry.getPkValue())).collect(Collectors.toList());
        return relateInvoiceEntry;
    }

    public static List<DynamicObject> getInvoiceItemByInvoiceHeadIds(DynamicObject bill, Set<Long> invoiceIdsSet) {
        if (invoiceIdsSet == null) {
            return Collections.emptyList();
        }
        return bill.getDynamicObjectCollection("invoiceitementry").stream().filter(v -> invoiceIdsSet.contains(v.getLong("invoiceheadentryid"))).collect(Collectors.toList());
    }

    public static List<DynamicObject> getInvoiceItemByInvoiceHeadIds(IDataModel model, Set<Long> invoiceIdsSet) {
        if (invoiceIdsSet == null) {
            return Collections.emptyList();
        }
        return model.getEntryEntity("invoiceitementry").stream().filter(v -> invoiceIdsSet.contains(v.getLong("invoiceheadentryid"))).collect(Collectors.toList());
    }

    public static Set<Long> getExpenseItemIdsByInvoiceHeadIds(IFormView view, Set<Long> invoiceIdsSet) {
        List<DetailExpenseModel> detailsModels = InvoiceUtils.getExpenseItemByInvoiceHeadIds(view, invoiceIdsSet);
        Set<Long> expenseItemIds = detailsModels.stream().map(item -> (Long)item.getDynamicObject().getPkValue()).collect(Collectors.toSet());
        return expenseItemIds;
    }

    public static List<Long> getAutoItemIdByInvoiceHeadIds(IDataModel model, Set<Long> invoiceIdsSet, String entryKey) {
        if (invoiceIdsSet == null) {
            return Collections.emptyList();
        }
        List<Long> expenseItemId = model.getEntryEntity("invoiceitementry").stream().filter(v -> invoiceIdsSet.contains(v.getLong("invoiceheadentryid"))).map(invoiceItem -> invoiceItem.getLong("itementryid")).collect(Collectors.toList());
        expenseItemId.remove(0L);
        if (!CollectionUtils.isEmpty(expenseItemId)) {
            if (model.getEntryEntity(entryKey) == null || model.getEntryEntity(entryKey).isEmpty()) {
                return new ArrayList<Long>();
            }
            List invoiceFromParentPkValue = model.getEntryEntity(entryKey).stream().filter(v -> v.getBoolean("invoicefromparent") && expenseItemId.contains(Long.parseLong(v.getString("splitline")))).map(v -> (Long)v.getPkValue()).collect(Collectors.toList());
            expenseItemId.addAll(invoiceFromParentPkValue);
        }
        return expenseItemId;
    }

    public static List<Long> getNonAutoItemIdByInvoiceHeadIds(IDataModel model, Set<Long> invoiceIdsSet) {
        if (invoiceIdsSet == null) {
            return Collections.emptyList();
        }
        List<Long> expenseItemId = model.getEntryEntity("invoiceandexpense").stream().filter(v -> invoiceIdsSet.contains(v.getLong("invoiceentryid"))).map(invoiceItem -> invoiceItem.getLong("expenseentryid")).collect(Collectors.toList());
        return expenseItemId;
    }

    public static Set<Long> needDeleteInvoiceIndex(DynamicObject bill, Set<Long> existItemEntryIds) {
        HashSet needDeleteInvocieIdSet = Sets.newHashSet();
        Map<Long, Set<Long>> itemInvoiceMap = InvoiceUtils.autoMapInvoiceMappingInfo(bill);
        Set deletedItemIds = itemInvoiceMap.keySet().stream().filter(itemid -> !existItemEntryIds.contains(itemid)).collect(Collectors.toSet());
        HashSet preDeleteInvocieIdSet = Sets.newHashSet();
        for (Map.Entry<Long, Set<Long>> map : itemInvoiceMap.entrySet()) {
            if (!deletedItemIds.contains(map.getKey())) continue;
            preDeleteInvocieIdSet.addAll((Collection)map.getValue());
        }
        Map<Long, Set<Long>> invoiceItemMap = InvoiceUtils.autoMapItemMappingInfo(bill);
        for (Map.Entry<Long, Set<Long>> map : invoiceItemMap.entrySet()) {
            Set otherItemIds;
            Long key = map.getKey();
            if (!preDeleteInvocieIdSet.contains(key) || !(otherItemIds = map.getValue().stream().filter(itemid -> itemid != 0L && !deletedItemIds.contains(itemid)).collect(Collectors.toSet())).isEmpty()) continue;
            needDeleteInvocieIdSet.add(key);
        }
        return needDeleteInvocieIdSet;
    }

    public static Map<Long, Set<Long>> getInvoiceItemColl(DynamicObject bill, String entryKey, String key, String value) {
        HashMap invoiceItemMap = Maps.newHashMap();
        DynamicObjectCollection invoiceItemColl = bill.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : invoiceItemColl) {
            Long keyId = entry.getLong(key);
            if (keyId == 0L) continue;
            Long valueId = entry.getLong(value);
            Set valueIds = (Set)invoiceItemMap.get(keyId);
            if (valueIds == null) {
                valueIds = Sets.newHashSet();
                invoiceItemMap.put(keyId, valueIds);
            }
            valueIds.add(valueId);
        }
        return invoiceItemMap;
    }

    public static Map<Long, Set<Long>> getInvoiceItemCollCache(IDataModel dataModel, String entryKey, String key, String value, String cacheKey) {
        return null;
    }

    public static Map<Long, Set<Long>> getInvoiceItemColl(IDataModel bill, String entryKey, String key, String value) {
        HashMap invoiceItemMap = Maps.newHashMap();
        DynamicObjectCollection invoiceItemColl = bill.getEntryEntity(entryKey);
        for (DynamicObject entry : invoiceItemColl) {
            Long keyId = entry.getLong(key);
            if (keyId == 0L) continue;
            Long valueId = entry.getLong(value);
            Set valueIds = (Set)invoiceItemMap.get(keyId);
            if (valueIds == null) {
                valueIds = Sets.newHashSet();
                invoiceItemMap.put(keyId, valueIds);
            }
            valueIds.add(valueId);
        }
        return invoiceItemMap;
    }

    public static Map<String, BigDecimal> getInvoiceValue(IDataModel model, Set<Long> idSet, Set<String> keys) {
        HashMap invoiceValueMap = Maps.newHashMapWithExpectedSize((int)keys.size());
        DynamicObjectCollection invoiceItemColl = model.getEntryEntity("invoiceentry");
        for (String key : keys) {
            BigDecimal value = InvoiceUtils.getAddBigDecimalValue((List<DynamicObject>)invoiceItemColl, idSet, key);
            if (value == null) {
                value = BigDecimal.ZERO;
            }
            invoiceValueMap.put(key, value);
        }
        return invoiceValueMap;
    }

    public static Map<String, BigDecimal> getInvoiceValue(DynamicObject bill, Set<Long> idSet, Set<String> keys) {
        HashMap invoiceValueMap = Maps.newHashMapWithExpectedSize((int)keys.size());
        DynamicObjectCollection invoiceItemColl = bill.getDynamicObjectCollection("invoiceentry");
        for (String key : keys) {
            BigDecimal value = InvoiceUtils.getAddBigDecimalValue((List<DynamicObject>)invoiceItemColl, idSet, key);
            if (value == null) {
                value = BigDecimal.ZERO;
            }
            invoiceValueMap.put(key, value);
        }
        return invoiceValueMap;
    }

    @Deprecated
    public static Map<String, BigDecimal> getExpenseItemValue(DynamicObject pEntry, Set<Long> idSet, String entryKey, String key) {
        return Maps.newHashMap();
    }

    public static BigDecimal getAddBigDecimalValue(List<DynamicObject> itemColl, Set<Long> idSet, String key) {
        BigDecimal reulut = itemColl.stream().filter(itemEnty -> idSet == null ? true : idSet.contains(itemEnty.getPkValue())).map(itemEnty -> itemEnty.getBigDecimal(key)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        return reulut;
    }

    @Deprecated
    public static Map<String, BigDecimal> getTripItemValue(DynamicObject bill, Set<Long> idSet) {
        return Maps.newHashMap();
    }

    public static Map<String, BigDecimal> getItemValue(DynamicObject bill, Set<Long> idSet, BillEntityType type, Set<String> keys) {
        HashMap itemMap = Maps.newHashMapWithExpectedSize((int)keys.size());
        List<Object> itemColl = Lists.newArrayList();
        if (type == BillEntityType.TripReimburse) {
            DynamicObjectCollection tripColl = bill.getDynamicObjectCollection("tripentry");
            for (DynamicObject tripItem : tripColl) {
                DynamicObjectCollection items = tripItem.getDynamicObjectCollection(type.getItemKey());
                if (items.isEmpty()) continue;
                itemColl.addAll(items.stream().collect(Collectors.toList()));
            }
        } else {
            itemColl = bill.getDynamicObjectCollection(type.getItemKey()).stream().collect(Collectors.toList());
        }
        for (String key : keys) {
            BigDecimal value = InvoiceUtils.getAddBigDecimalValue((List<DynamicObject>)itemColl, idSet, key);
            if (value == null) {
                value = BigDecimal.ZERO;
            }
            itemMap.put(key, value);
        }
        return itemMap;
    }

    public static Map<String, BigDecimal> getItemValue(IDataModel model, Set<Long> idSet, BillEntityType type, Set<String> keys) {
        HashMap itemMap = Maps.newHashMapWithExpectedSize((int)keys.size());
        List<Object> itemColl = Lists.newArrayList();
        if (type == BillEntityType.TripReimburse) {
            DynamicObjectCollection tripColl = model.getEntryEntity("tripentry");
            for (DynamicObject tripItem : tripColl) {
                DynamicObjectCollection items = tripItem.getDynamicObjectCollection(type.getItemKey());
                if (items.isEmpty()) continue;
                itemColl.addAll(items.stream().collect(Collectors.toList()));
            }
        } else {
            itemColl = model.getEntryEntity(type.getItemKey()).stream().collect(Collectors.toList());
        }
        for (String key : keys) {
            BigDecimal value = InvoiceUtils.getAddBigDecimalValue((List<DynamicObject>)itemColl, idSet, key);
            if (value == null) {
                value = BigDecimal.ZERO;
            }
            itemMap.put(key, value);
        }
        return itemMap;
    }

    public static void refresh(DynamicObject dataEntity, DynamicObject expenseItem, IDataModel model, List<DynamicObject> invoiceList, int itemIndex, int parentIndex) {
        if (BigDecimal.ZERO.compareTo(expenseItem.getBigDecimal("taxrate")) == 0) {
            Set<Long> invoiceItemIdOfInvoiceItemEntry = InvoiceUtils.autoMapInvoiceItemMappingInfo(dataEntity).get(expenseItem.getPkValue());
            List<Object> invoiceItemList = Lists.newArrayList();
            if (invoiceItemIdOfInvoiceItemEntry != null) {
                invoiceItemList = dataEntity.getDynamicObjectCollection("invoiceitementry").stream().filter(invoiceItem -> invoiceItemIdOfInvoiceItemEntry.contains(invoiceItem.getPkValue())).collect(Collectors.toList());
            }
            if (!invoiceItemList.isEmpty()) {
                BigDecimal tax = ((DynamicObject)invoiceItemList.get(0)).getBigDecimal("invoiceitemtaxrate");
                if (invoiceItemList.stream().allMatch(invoiceItem -> tax.compareTo(invoiceItem.getBigDecimal("invoiceitemtaxrate")) == 0)) {
                    BigDecimal taxAmount = invoiceItemList.stream().map(item -> (BigDecimal)ObjectUtils.defaultIfNull((Object)item.getBigDecimal("invoiceitemtaxamout"), (Object)BigDecimal.ZERO)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    model.setValue("taxrate", (Object)tax.multiply(BigDecimal.valueOf(100L)), itemIndex, parentIndex);
                    model.setValue("taxamount", (Object)taxAmount, itemIndex, parentIndex);
                }
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static String refreshTaxAmountShare(IDataModel model, long costCompanyId, List<Long> invoiceEntryIds, List<Long> selectedItemIds, BillEntityType type) {
        InvoiceUtils.log.info("\u9009\u4e2d\u7684\u53d1\u7968\u4fe1\u606f\u5206\u5f55ids:" + invoiceEntryIds + ", \u9009\u4e2d\u7684\u8d39\u7528\u660e\u7ec6\u5206\u5f55ids:" + selectedItemIds);
        bill = model.getDataEntity();
        result = InvoiceUtils.checkAmount(model, type);
        if (!result.isEmpty()) {
            InvoiceUtils.log.info("\u8d85\u989d\u62a5\u9500\u68c0\u67e5:" + result);
            return ResManager.loadKDString((String)"\u6574\u5355\u62a5\u9500\u5408\u8ba1\u91d1\u989d\u8d85\u51fa\u53d1\u7968\u603b\u989d\u3002", (String)"InvoiceUtils_5", (String)"fi-er-business", (Object[])new Object[0]);
        }
        shareType = ErStdConfig.taxShareType();
        shareTax4ItemTatalAmountLessThaninvoice = StringUtils.equals((CharSequence)shareType, (CharSequence)"3") != false || StringUtils.equals((CharSequence)shareType, (CharSequence)"2") != false;
        selectedInvoiceTotalAmount = InvoiceUtils.getInvoiceValue(bill, invoiceEntryIds.stream().collect(Collectors.toSet()), (Set<String>)Sets.newHashSet((Object[])new String[]{"totalamount"})).get("totalamount");
        if (selectedInvoiceTotalAmount == null) {
            selectedInvoiceTotalAmount = BigDecimal.ZERO;
        }
        if ((selectedItemTotalAmount = InvoiceUtils.getItemValue(bill, selectedItemIds.stream().collect(Collectors.toSet()), type, (Set<String>)Sets.newHashSet((Object[])new String[]{type.getAmountKey()})).get(type.getAmountKey())) == null) {
            selectedItemTotalAmount = BigDecimal.ZERO;
        }
        if (!shareTax4ItemTatalAmountLessThaninvoice && selectedItemTotalAmount.compareTo(selectedInvoiceTotalAmount) != 0) {
            InvoiceUtils.log.info("\u7a0e\u989d\u5206\u644a\u89c4\u5219\u68c0\u67e5 selectedItemTotalAmount:" + selectedItemTotalAmount + ", selectedInvoiceTotalAmount:" + selectedInvoiceTotalAmount + ", shareType:" + shareType);
            return ResManager.loadKDString((String)"\u7a0e\u989d\u5206\u644a\u89c4\u5219\u68c0\u67e5\u4e0d\u901a\u8fc7\u3002", (String)"InvoiceUtils_12", (String)"fi-er-business", (Object[])new Object[0]);
        }
        invoiceItemColl = bill.getDynamicObjectCollection("invoiceentry");
        rateSet = invoiceItemColl.stream().filter((Predicate<DynamicObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$refreshTaxAmountShare$50(java.util.List kd.bos.dataentity.entity.DynamicObject ), (Lkd/bos/dataentity/entity/DynamicObject;)Z)(invoiceEntryIds)).map((Function<DynamicObject, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$refreshTaxAmountShare$51(kd.bos.dataentity.entity.DynamicObject ), (Lkd/bos/dataentity/entity/DynamicObject;)Ljava/lang/String;)()).collect(Collectors.toSet());
        InvoiceUtils.log.info("\u53d1\u7968\u4fe1\u606f\u7a0e\u7387rateSet: " + rateSet);
        taxError = false;
        itemInvoiceRelationEnum = OffsetUtils.getItemInvoiceRelation(null, model, new HashSet<Long>(invoiceEntryIds));
        if (itemInvoiceRelationEnum == ItemInvoiceRelationEnum.IsOneForOne) ** GOTO lbl-1000
        if (itemInvoiceRelationEnum == ItemInvoiceRelationEnum.IsOneForN) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        isOneFor = v0;
        v1 = isOneFor = isOneFor != false && ErStdConfig.getBoolean((String)"invoicecloud.multitax.distribution") != false;
        if (rateSet.size() > 1 && !isOneFor) {
            InvoiceUtils.log.info("\u53d1\u7968\u4fe1\u606f\u5b58\u5728\u591a\u7a0e\u7387\uff0c\u4e0d\u8ba1\u7b97\u7a0e\u989d\u7a0e\u989d\u3002");
            taxError = true;
        }
        tax = (String)rateSet.iterator().next();
        existBlacnk = rateSet.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$refreshTaxAmountShare$52(java.lang.String ), (Ljava/lang/String;)Z)());
        if (existBlacnk || StringUtils.contains((CharSequence)tax, (CharSequence)",") && !isOneFor || !InvoiceUtils.matches("[\\d|,]+", tax)) {
            InvoiceUtils.log.info("\u7a0e\u7387\u683c\u5f0f\u9519\u8bef\u3002");
            taxError = true;
        }
        isImportNonDeductionTaxAmount = KingdeeInvoiceCloudConfig.isNonOffsetImportTaxAmout((Long)costCompanyId);
        if (taxError) {
            if (isImportNonDeductionTaxAmount) {
                return ResManager.loadKDString((String)"\u5df2\u52fe\u9009\u7684\u53d1\u7968\u4fe1\u606f\u5b58\u5728\u591a\u7a0e\u7387\u6216\u7a0e\u7387\u5f02\u5e38\uff08\u4e3a\u7a7a\u6216\u683c\u5f0f\u9519\u8bef\uff09\uff0c\u5173\u8054\u540e\u65e0\u6cd5\u8ba1\u7b97\u7a0e\u7387\u3001\u7a0e\u989d\u3002", (String)"InvoiceUtils_14", (String)"fi-er-business", (Object[])new Object[0]);
            }
            return "";
        }
        isOneForScene = (rateSet.size() > 1 || StringUtils.contains((CharSequence)tax, (CharSequence)",") != false) && isOneFor != false;
        InvoiceUtils.log.info("costCompanyId:" + costCompanyId + "   \u662f\u5426\u5bfc\u5165\u4e0d\u53ef\u62b5\u6263\u53d1\u7968\u7684\u7a0e\u989d isImportNonDeductionTaxAmount: " + isImportNonDeductionTaxAmount);
        updateTaxrate = false;
        if (!isImportNonDeductionTaxAmount) {
            if (itemInvoiceRelationEnum != ItemInvoiceRelationEnum.IsOneForOne) {
                isAllOffset = InvoiceOffsetUtils.isInvoiceItemAllOffset((Collection)bill.getDynamicObjectCollection("invoiceitementry"), invoiceEntryIds);
                InvoiceUtils.log.info("isAllOffset:" + isAllOffset);
                if (!isAllOffset) {
                    tax = "0";
                    updateTaxrate = true;
                }
            }
        }
        allInvoiceItemMap = InvoiceUtils.nonAutoMapItemMapingInfo(bill);
        invoiceItemMap = Maps.newHashMapWithExpectedSize((int)allInvoiceItemMap.size());
        for (Object entry : allInvoiceItemMap.entrySet()) {
            value = entry.getValue();
            value.remove(0L);
            key = (Long)entry.getKey();
            if (!invoiceEntryIds.contains(key)) continue;
            invoiceItemMap.put(key, value);
        }
        itemIdAndTaxAmount = Maps.newHashMap();
        for (Map.Entry entry : invoiceItemMap.entrySet()) {
            InvoiceUtils.computeTaxAmountShare(bill, itemIdAndTaxAmount, (Long)entry.getKey(), (Set)entry.getValue(), selectedInvoiceTotalAmount, type, costCompanyId);
        }
        InvoiceUtils.log.info("\u5173\u8054\u7a0e\u7387 tax:" + tax);
        if (type == BillEntityType.TripReimburse) {
            tripColl = bill.getDynamicObjectCollection("tripentry");
            currParentIndex = model.getEntryCurrentRowIndex("tripentry");
            for (parentIndex = 0; parentIndex < tripColl.size(); ++parentIndex) {
                model.setEntryCurrentRowIndex("tripentry", parentIndex);
                InvoiceUtils.setTax((DynamicObject)tripColl.get(parentIndex), type, model, isOneForScene == false || updateTaxrate != false, tax, itemIdAndTaxAmount, parentIndex);
            }
            model.setEntryCurrentRowIndex("tripentry", currParentIndex);
        } else {
            InvoiceUtils.setTax(bill, type, model, isOneForScene == false || updateTaxrate != false, tax, itemIdAndTaxAmount, 0);
        }
        return "";
    }

    private static void setTax(DynamicObject bill, BillEntityType type, IDataModel model, boolean updateTaxRate, String tax, Map<Long, BigDecimal> itemIdAndTaxAmount, int parentIndex) {
        DynamicObjectCollection items = bill.getDynamicObjectCollection(type.getItemKey());
        for (int itemIndex = 0; itemIndex < items.size(); ++itemIndex) {
            DynamicObject item = (DynamicObject)items.get(itemIndex);
            Long id = (Long)item.getPkValue();
            BigDecimal taxAmount = itemIdAndTaxAmount.get(id);
            BigDecimal amount = item.getBigDecimal(type.getAmountKey());
            log.info(id + "  \u91d1\u989damount:" + amount + "  \u7a0e\u989dtaxAmount:" + taxAmount);
            if (taxAmount == null || BigDecimal.ZERO.compareTo(amount) == 0) continue;
            if (updateTaxRate) {
                model.setValue("taxrate", (Object)new BigDecimal(tax), itemIndex, parentIndex);
            }
            model.setValue("taxamount", (Object)taxAmount, itemIndex, parentIndex);
            log.info("parentIndex: " + parentIndex + ", itemIndex : " + itemIndex + ", taxrate" + tax + ", taxamount" + taxAmount);
        }
    }

    private static void computeTaxAmountShare(DynamicObject bill, Map<Long, BigDecimal> itemIdAndTaxAmount, Long invoiceId, Set<Long> itemIdSets, BigDecimal selectedInvoiceTotalAmount, BillEntityType type, long costCompanyId) {
        HashSet ids = Sets.newHashSet((Object[])new Long[]{invoiceId});
        HashSet keys = Sets.newHashSet((Object[])new String[]{"taxamount_invoice"});
        String shareType = ErStdConfig.taxShareType();
        log.info("\u5206\u644a\u7c7b\u578bshareType: " + shareType);
        boolean shouldComputeShareTax = StringUtils.equals((CharSequence)shareType, (CharSequence)"2");
        boolean shouldClearOldTaxData = StringUtils.equals((CharSequence)shareType, (CharSequence)"3") || StringUtils.equals((CharSequence)shareType, (CharSequence)"2");
        Map<String, BigDecimal> invoiceInfo = InvoiceUtils.getInvoiceValue(bill, (Set<Long>)ids, (Set<String>)keys);
        BigDecimal invoiceTaxAmout = invoiceInfo.get("taxamount_invoice");
        boolean isImportNonDeductionTaxAmout = KingdeeInvoiceCloudConfig.isNonOffsetImportTaxAmout((Long)costCompanyId);
        if (!isImportNonDeductionTaxAmout) {
            DynamicObjectCollection invoiceItems = bill.getDynamicObjectCollection("invoiceitementry");
            invoiceTaxAmout = InvoiceOffsetUtils.getOffsetInvoiceItem((Collection)invoiceItems, (Long)invoiceId).map(v -> v.getBigDecimal("invoiceitemtaxamout")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        Map<Long, DynamicObject> allItemAmountMap = InvoiceUtils.getAllItem(bill, type, itemIdSets);
        boolean write = allItemAmountMap.values().stream().allMatch(item -> BigDecimal.ZERO.compareTo(item.getBigDecimal("taxamount")) == 0);
        if (!(shouldClearOldTaxData || !allItemAmountMap.isEmpty() && write)) {
            return;
        }
        BigDecimal amountTotal = allItemAmountMap.values().stream().map(item -> item.getBigDecimal(type.getAmountKey())).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        if (amountTotal == null || amountTotal.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        if (shouldComputeShareTax) {
            invoiceTaxAmout = invoiceTaxAmout.multiply(amountTotal).divide(selectedInvoiceTotalAmount, 8, 4);
        }
        int size = allItemAmountMap.size();
        BigDecimal amountTemp = BigDecimal.ZERO;
        HashMap allItemTaxAmountMap = Maps.newHashMapWithExpectedSize((int)size);
        for (Map.Entry<Long, DynamicObject> entry : allItemAmountMap.entrySet()) {
            DynamicObject item2 = entry.getValue();
            BigDecimal oldTaxAmount = item2.getBigDecimal("taxamount");
            BigDecimal amount = item2.getBigDecimal(type.getAmountKey());
            log.info(entry.getKey() + "\u62a5\u9500\u91d1\u989damount:" + amount + " \u5206\u644a\u524d\u7a0e\u989doldTaxAmount:" + oldTaxAmount);
            if (!(shouldClearOldTaxData || oldTaxAmount != null && BigDecimal.ZERO.compareTo(oldTaxAmount) == 0)) {
                log.info(entry.getKey() + "\u5173\u8054\u540e\u7684\u5355\u636e\u7a0e\u989d\u4e0d\u4e3a\u7a7a\u4e0d\u5206\u644a,\u4e14\u5206\u644a\u65b9\u5f0f\u4e0d\u4e3a2\u62163   \u4e0d\u5206\u644a");
                return;
            }
            DynamicObject currency = item2.getDynamicObject("entrycurrency");
            int amtprecision = 4;
            if (currency != null) {
                amtprecision = currency.getInt("amtprecision");
            }
            BigDecimal taxAmount = invoiceTaxAmout.multiply(amount).divide(amountTotal, amtprecision, 4);
            log.info(entry.getKey() + "\u62a5\u9500\u91d1\u989damount:" + amount + " \u5206\u644a\u540e\u7a0e\u989dtaxAmount:" + taxAmount);
            if (taxAmount.abs().compareTo(amount.abs()) > 0) {
                log.info(entry.getKey() + "amount:" + amount + "< taxAmount:" + taxAmount + "\u4e0d\u5206\u644a");
                return;
            }
            if (size == 1) {
                taxAmount = invoiceTaxAmout.subtract(amountTemp);
                allItemTaxAmountMap.put(entry.getKey(), taxAmount);
                log.info("\u4e00\u884c\u660e\u7ec6 allItemTaxAmountMap key:" + entry.getKey() + " value:" + taxAmount);
                continue;
            }
            amountTemp = amountTemp.add(taxAmount);
            allItemTaxAmountMap.put(entry.getKey(), taxAmount);
            --size;
            log.info("\u591a\u884c\u660e\u7ec6 allItemTaxAmountMap key:" + entry.getKey() + " value:" + taxAmount);
        }
        log.info("allItemTaxAmountMap:" + allItemTaxAmountMap);
        allItemTaxAmountMap.forEach((key, value) -> {
            BigDecimal taxAmount = (BigDecimal)itemIdAndTaxAmount.get(key);
            if (taxAmount == null) {
                taxAmount = BigDecimal.ZERO;
            }
            taxAmount = taxAmount.add((BigDecimal)value);
            itemIdAndTaxAmount.put((Long)key, taxAmount);
            log.info("itemIdAndTaxAmount key:" + key + " taxAmount:" + taxAmount);
        });
    }

    private static Map<Long, DynamicObject> getAllItem(DynamicObject bill, BillEntityType type, Set<Long> itemIdSet) {
        Map<Object, Object> allItem = Maps.newHashMap();
        if (type == BillEntityType.TripReimburse) {
            DynamicObjectCollection tripColl = bill.getDynamicObjectCollection("tripentry");
            for (DynamicObject tripItem : tripColl) {
                DynamicObjectCollection items = tripItem.getDynamicObjectCollection(type.getItemKey());
                if (items.isEmpty()) continue;
                allItem.putAll(items.stream().filter(item -> itemIdSet.contains(item.getPkValue())).collect(Collectors.toMap(item -> (Long)item.getPkValue(), item -> item)));
            }
        } else {
            allItem = bill.getDynamicObjectCollection(type.getItemKey()).stream().filter(item -> itemIdSet.contains(item.getPkValue())).collect(Collectors.toMap(item -> (Long)item.getPkValue(), item -> item));
        }
        allItem.remove(0L);
        return allItem;
    }

    public static Set<Long> getExpenseEntryByInvoiceEntryId(DynamicObject dataEntity, Long invoiceEntryId) {
        Map<Long, Set<Long>> invoiceItemMap = InvoiceUtils.autoMapItemMappingInfo(dataEntity);
        Map<Long, Set<Long>> invoiceAndItemMap = InvoiceUtils.nonAutoMapItemMapingInfo(dataEntity);
        HashSet invoiceEntryIds = Sets.newHashSet();
        if (invoiceItemMap.get(invoiceEntryId) != null) {
            invoiceEntryIds.addAll((Collection)invoiceItemMap.get(invoiceEntryId));
        }
        if (invoiceAndItemMap.get(invoiceEntryId) != null) {
            invoiceEntryIds.addAll((Collection)invoiceAndItemMap.get(invoiceEntryId));
        }
        return invoiceEntryIds.stream().filter(item -> !Objects.equal((Object)item, (Object)0L)).collect(Collectors.toSet());
    }

    private static void clearDiffernce(DynamicObject bill, BigDecimal difference, Set<Long> itemIds, BillEntityType type) {
        HashMap keyMap = Maps.newHashMap();
        DynamicObject company = bill.getDynamicObject("company");
        if (type == BillEntityType.TripReimburse) {
            DynamicObjectCollection tripColl = bill.getDynamicObjectCollection("tripentry");
            DynamicObject currency = bill.getDynamicObject("currency");
            for (DynamicObject tripEntry : tripColl) {
                if (difference.compareTo(BigDecimal.ZERO) != 0) {
                    DynamicObjectCollection detailEntry = tripEntry.getDynamicObjectCollection("entryentity");
                    keyMap.put(ITEM_TAX_AMOUNT, "taxamount");
                    keyMap.put(ITEM_NOT_TAX_AMOUNT, "notaxamount");
                    keyMap.put(ITEM_APPROVE_AMOUNT, "orientryappamount");
                    DynamicObject costcompany = bill.getDynamicObject("costcompany");
                    difference = InvoiceUtils.clearDifference(detailEntry, keyMap, difference, itemIds, currency, "detailquotetype", costcompany, company);
                    if (!StringUtils.equals((CharSequence)"0", (CharSequence)bill.getString("billkind"))) continue;
                    InvoiceUtils.refreshTrip(tripEntry);
                    continue;
                }
                break;
            }
        } else {
            if (type == BillEntityType.CheckingPayBill) {
                keyMap.put(ITEM_TAX_AMOUNT, "taxamount");
                keyMap.put(ITEM_NOT_TAX_AMOUNT, "notaxoriamount");
            } else {
                keyMap.put(ITEM_TAX_AMOUNT, "taxamount");
                keyMap.put(ITEM_NOT_TAX_AMOUNT, "orientryamount");
                keyMap.put(ITEM_APPROVE_AMOUNT, "expeapproveamount");
            }
            DynamicObjectCollection detailEntry = bill.getDynamicObjectCollection(type.getItemKey());
            DynamicObject currency = bill.getDynamicObject("currency");
            InvoiceUtils.clearDifference(detailEntry, keyMap, difference, itemIds, currency, "expquotetype", null, company);
        }
    }

    private static BigDecimal clearDifference(DynamicObjectCollection entry, Map<String, String> keyMap, BigDecimal difference, Set<Long> itemIds, DynamicObject currency, String quoteTypeFieldName, DynamicObject costcompany, DynamicObject company) {
        BigDecimal stdDifference = BigDecimal.ZERO;
        String key = keyMap.get(ITEM_TAX_AMOUNT);
        try {
            stdDifference = ErStdConfig.taxDifferenceClear();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7a0e\u989d\u5dee\u503c\u5931\u8d25", (Throwable)e);
            return BigDecimal.ZERO;
        }
        log.info("\u5355\u636eid: \u5c3e\u5dee\uff1a%s , ");
        if (difference.compareTo(stdDifference) > 0) {
            return BigDecimal.ZERO;
        }
        for (int index = 0; index < entry.size(); ++index) {
            DynamicObject item = (DynamicObject)entry.get(index);
            if (difference.compareTo(BigDecimal.ZERO) == 0) break;
            if (!itemIds.contains(item.getPkValue())) continue;
            BigDecimal taxAmount = item.getBigDecimal(key);
            if (taxAmount.compareTo(difference) >= 0) {
                item.set(key, (Object)taxAmount.subtract(difference));
                difference = BigDecimal.ZERO;
            } else {
                difference = difference.subtract(taxAmount);
                item.set(key, (Object)BigDecimal.ZERO);
            }
            InvoiceUtils.refreshTaxAmount(item, keyMap, currency, quoteTypeFieldName, costcompany, company);
        }
        return difference;
    }

    private static void refreshTaxAmount(DynamicObject item, Map<String, String> keyMap, DynamicObject currency, String quoteType, DynamicObject costcompany, DynamicObject company) {
        if (keyMap.get(ITEM_APPROVE_AMOUNT) == null) {
            BigDecimal taxAmount = item.getBigDecimal("taxamount");
            BigDecimal actentryamount = item.getBigDecimal("actentryamount");
            BigDecimal orientryamount = actentryamount.subtract(taxAmount);
            item.set(keyMap.get(ITEM_NOT_TAX_AMOUNT), (Object)orientryamount);
            return;
        }
        int precision = currency.getInt("amtprecision");
        BigDecimal offsetAmount = item.getBigDecimal("deductibletax");
        BigDecimal taxAmount = item.getBigDecimal("taxamount");
        BigDecimal expenseAmountAppOri = item.getBigDecimal(keyMap.get(ITEM_APPROVE_AMOUNT));
        BigDecimal approveTax = item.getBigDecimal("approvetax");
        boolean offset = item.getBoolean("offset");
        BigDecimal orientryamount = expenseAmountAppOri.subtract(taxAmount);
        if (offset) {
            offsetAmount = taxAmount;
            item.set("deductibletax", (Object)taxAmount);
        }
        AmountChangeUtil.updateInOutAmount(item, costcompany, company, ChangeField.All);
        String approveTaxFormulaType = ErStdConfig.getApproveTaxFormulaType();
        BigDecimal price = StringUtils.equals((CharSequence)approveTaxFormulaType, (CharSequence)"1") ? expenseAmountAppOri.subtract(offsetAmount) : expenseAmountAppOri.subtract(approveTax);
        BigDecimal changeRate = item.getBigDecimal("exchangerate");
        String detailQuoteType = (String)ObjectUtils.defaultIfNull((Object)item.getString(quoteType), (Object)"0");
        BigDecimal curprice = AmountUtils.getCurrencyAmount((BigDecimal)price, (BigDecimal)changeRate, (int)precision, (String)detailQuoteType);
        item.set("curprice", (Object)curprice);
        item.set(keyMap.get(ITEM_NOT_TAX_AMOUNT), (Object)orientryamount);
        item.set("price", (Object)price);
    }

    private static void refreshTrip(DynamicObject tripEntry) {
        List<DynamicObject> itemColl = tripEntry.getDynamicObjectCollection(BillEntityType.TripReimburse.getItemKey()).stream().collect(Collectors.toList());
        HashMap keyMap = Maps.newHashMapWithExpectedSize((int)3);
        keyMap.put("notaxamounttotalori", "notaxamount");
        keyMap.put("taxamounttotalori", "taxamount");
        keyMap.put("pricetotal", "price");
        for (Map.Entry entry : keyMap.entrySet()) {
            BigDecimal value = InvoiceUtils.getAddBigDecimalValue(itemColl, null, (String)entry.getValue());
            tripEntry.set((String)entry.getKey(), (Object)value);
        }
    }

    public static Map<String, Map<Long, Object>> getInvoiceInfoOfItems(DynamicObject dataEntity, Set<String> keys, Set<Long> itemIds) {
        Set<Long> invoiceIds = InvoiceUtils.getInvoiceIdsOfItems(dataEntity, itemIds);
        return InvoiceUtils.getInvoiceInfo(dataEntity, keys, invoiceIds);
    }

    public static Set<Long> getInvoiceIdsOfItems(IDataModel model, Set<Long> itemIds) {
        HashSet invoiceIds = Sets.newHashSet();
        if (itemIds == null || itemIds.isEmpty()) {
            return invoiceIds;
        }
        Map invoiceIdsOfInvoiceItemEntry = InvoiceUtils2.autoMapInvoiceMappingInfoCache((IDataModel)model, (String)"autoMapInvoiceMappingInfo");
        Map invoiceIdsOfExpenseAndInvoiceEntry = InvoiceUtils2.nonAutoMapInvoiceMappingInfoCache((IDataModel)model, (String)"nonAutoMapInvoiceMappingInfo");
        for (Long itemId : itemIds) {
            if (invoiceIdsOfInvoiceItemEntry.get(itemId) != null) {
                invoiceIds.addAll((Collection)invoiceIdsOfInvoiceItemEntry.get(itemId));
            }
            if (invoiceIdsOfExpenseAndInvoiceEntry.get(itemId) == null) continue;
            invoiceIds.addAll((Collection)invoiceIdsOfExpenseAndInvoiceEntry.get(itemId));
        }
        return invoiceIds;
    }

    public static Set<Long> getInvoiceIdsOfItems(DynamicObject dataEntity, Set<Long> itemIds) {
        HashSet invoiceIds = Sets.newHashSet();
        if (itemIds == null) {
            return invoiceIds;
        }
        Map<Long, Set<Long>> invoiceIdsOfInvoiceItemEntry = InvoiceUtils.autoMapInvoiceMappingInfo(dataEntity);
        Map<Long, Set<Long>> invoiceIdsOfExpenseAndInvoiceEntry = InvoiceUtils.nonAutoMapInvoiceMappingInfo(dataEntity);
        for (Long itemId : itemIds) {
            if (invoiceIdsOfInvoiceItemEntry.get(itemId) != null) {
                invoiceIds.addAll((Collection)invoiceIdsOfInvoiceItemEntry.get(itemId));
            }
            if (invoiceIdsOfExpenseAndInvoiceEntry.get(itemId) == null) continue;
            invoiceIds.addAll((Collection)invoiceIdsOfExpenseAndInvoiceEntry.get(itemId));
        }
        return invoiceIds;
    }

    public static Map<String, Map<Long, Object>> getInvoiceInfo(DynamicObject dataEntity, Set<String> keys, Set<Long> invoiceIds) {
        HashMap invocieInfoMap = Maps.newHashMapWithExpectedSize((int)keys.size());
        DynamicObjectCollection invoiceColl = dataEntity.getDynamicObjectCollection("invoiceentry");
        for (DynamicObject invoice : invoiceColl) {
            Long invoiceId = ErCommonUtils.getPk(invoice);
            if (!invoiceIds.contains(invoiceId)) continue;
            for (String key : keys) {
                Map valueMap = (Map)invocieInfoMap.get(key);
                if (valueMap == null) {
                    valueMap = Maps.newHashMapWithExpectedSize((int)invoiceIds.size());
                    invocieInfoMap.put(key, valueMap);
                }
                Object value = invoice.get(key);
                valueMap.put(invoiceId, value);
            }
        }
        return invocieInfoMap;
    }

    public static List<String> checkBuyerNameAndTaxNo(DynamicObject bill, Long orgId, boolean isTipsBeforeSubmit) {
        return InvoiceUtils.checkBuyerNameAndTaxNo(bill, orgId, null, isTipsBeforeSubmit);
    }

    public static List<String> checkBuyerNameAndTaxNo(DynamicObject bill, Long orgId, DynamicObject invoiceOrg, boolean isTipsBeforeSubmit) {
        DynamicObjectType invoiceDynamicObjectType;
        List needCheckSerialNos;
        boolean isShowReimed;
        boolean allNoControl;
        ArrayList resultList = Lists.newArrayList();
        DynamicObjectCollection invoiceEntries = bill.getDynamicObjectCollection("invoiceentry");
        if (invoiceEntries == null || invoiceEntries.isEmpty()) {
            return resultList;
        }
        List invoiceCollection = invoiceEntries.getDynamicObjectType().getProperty("invoicefrom") == null ? invoiceEntries.stream().collect(Collectors.toList()) : invoiceEntries.stream().filter(invoice -> StringUtils.equals((CharSequence)invoice.getString("invoicefrom"), (CharSequence)InvoiceFrom.InvoiceCloud.getValue())).collect(Collectors.toList());
        List serialNos = invoiceCollection.stream().map(invoice -> invoice.getString("serialno")).collect(Collectors.toList());
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)orgId);
        log.info("\u6821\u9a8c\u53d1\u7968\u62ac\u5934\u548c\u7a0e\u53f7 \u53d1\u7968\u4e91\u914d\u7f6e:" + config);
        if (config == null) {
            if (!isTipsBeforeSubmit && !serialNos.isEmpty()) {
                String fmt = ResManager.loadKDString((String)"\u8be5\u5355\u636e\u542b\u6709\u53d1\u7968\u4e91\u5bfc\u5165\u7684\u53d1\u7968\uff0c\u4f46\u5f53\u524d\u7ec4\u7ec7\u201c%1$s\u201d\u672a\u542f\u7528\u53d1\u7968\u4e91\u914d\u7f6e\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"BillSavePlugin_9", (String)"fi-er-opplugin", (Object[])new Object[0]);
                String name = invoiceOrg != null && invoiceOrg.getDataEntityType().getProperties().get((Object)"name") != null ? invoiceOrg.getString("name") : "";
                resultList.add(String.format(fmt, StringUtils.defaultIfBlank((CharSequence)name, (CharSequence)orgId.toString())));
            }
            return resultList;
        }
        log.info("\u3010\u53d1\u7968\u4e91\u3011\u63d0\u4ea4\u6821\u9a8c \u53d1\u7968\u5e8f\u5217\u53f7\uff1a" + serialNos);
        HashSet<String> set1 = new HashSet<String>(serialNos.size());
        HashSet<String> dupSerialNos = new HashSet<String>(1);
        for (String serialNo : serialNos) {
            if (set1.contains(serialNo)) {
                dupSerialNos.add(serialNo);
                continue;
            }
            set1.add(serialNo);
        }
        if (!isTipsBeforeSubmit && dupSerialNos.size() > 0) {
            List invoiceNos = invoiceEntries.stream().filter(i -> StringUtils.equals((CharSequence)i.getString("invoicefrom"), (CharSequence)InvoiceFrom.InvoiceCloud.getValue())).map(i -> i.getString("invoiceno")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            HashSet<String> set = new HashSet<String>(invoiceNos.size());
            HashSet<String> dup = new HashSet<String>(1);
            for (String invoiceNo : invoiceNos) {
                if (set.contains(invoiceNo)) {
                    dup.add(invoiceNo);
                    continue;
                }
                set.add(invoiceNo);
            }
            String fmt = ResManager.loadKDString((String)"\u8be5\u5355\u636e\u53d1\u7968\u5206\u5f55\u5b58\u5728\u91cd\u590d\u53d1\u7968\uff08%1$s\uff09\uff0c\u8bf7\u5220\u9664\u91cd\u590d\u53d1\u7968\u3002", (String)"BillSavePlugin_10", (String)"fi-er-opplugin", (Object[])new Object[0]);
            resultList.add(String.format(fmt, String.join((CharSequence)",", dup.size() > 0 ? dup : dupSerialNos)));
        }
        String reimedCtrl = config.getReimedCi();
        String sameTaxNoCtrl = config.getTaxNumNotMatchCi();
        String sameTitleCtrl = config.getNameNotMatchCi();
        String sameNameCtrl = config.getBuyerNameLessEqual5Ci();
        String checkPassCtrl = config.getCheckNotPassCi();
        boolean bl = allNoControl = NO_CONTROL.equalsIgnoreCase(reimedCtrl) && NO_CONTROL.equalsIgnoreCase(sameTaxNoCtrl) && NO_CONTROL.equalsIgnoreCase(sameTitleCtrl) && NO_CONTROL.equalsIgnoreCase(sameNameCtrl) && NO_CONTROL.equalsIgnoreCase(checkPassCtrl);
        if (allNoControl) {
            return resultList;
        }
        boolean bl2 = isShowReimed = isTipsBeforeSubmit ? ONLY_SUGGEST.equalsIgnoreCase(reimedCtrl) : STRICT_CONTROL.equalsIgnoreCase(reimedCtrl);
        if (isShowReimed && (needCheckSerialNos = (invoiceDynamicObjectType = invoiceEntries.getDynamicObjectType()).getProperty("ismutilreimburse") != null ? invoiceCollection.stream().filter(invoice -> !invoice.getBoolean("ismutilreimburse")).map(invoice -> invoice.getString("serialno")).collect(Collectors.toList()) : serialNos) != null && !needCheckSerialNos.isEmpty()) {
            QFilter serialNoFilter = new QFilter("invoiceentry.serialno", "in", needCheckSerialNos);
            QFilter excludeBillStatusFilter = new QFilter("billstatus", "not in", Arrays.asList("A", "D", "H"));
            QFilter[] qFilters = new QFilter[]{serialNoFilter, excludeBillStatusFilter};
            ArrayList duplicateInvoiceDos = Lists.newArrayList();
            List<DuplicateInvoiceDo> dupFromDailyReim = InvoiceUtils.queryDuplicateInvoices("er_dailyreimbursebill", ResManager.loadKDString((String)"\u8d39\u7528\u62a5\u9500\u5355", (String)"BillSavePlugin_1", (String)"fi-er-opplugin", (Object[])new Object[0]), qFilters);
            List<DuplicateInvoiceDo> dupFromTripReim = InvoiceUtils.queryDuplicateInvoices("er_tripreimbursebill", ResManager.loadKDString((String)"\u5dee\u65c5\u62a5\u9500\u5355", (String)"BillSavePlugin_2", (String)"fi-er-opplugin", (Object[])new Object[0]), qFilters);
            List<DuplicateInvoiceDo> dupFromPubReim = InvoiceUtils.queryDuplicateInvoices("er_publicreimbursebill", ResManager.loadKDString((String)"\u5bf9\u516c\u62a5\u9500\u5355", (String)"BillSavePlugin_3", (String)"fi-er-opplugin", (Object[])new Object[0]), qFilters);
            duplicateInvoiceDos.addAll(dupFromDailyReim);
            duplicateInvoiceDos.addAll(dupFromTripReim);
            duplicateInvoiceDos.addAll(dupFromPubReim);
            Set invoiceEntryIds = invoiceEntries.stream().map(invoice -> (Long)invoice.getPkValue()).collect(Collectors.toSet());
            List newAllDumpInvoiceDOs = duplicateInvoiceDos.stream().filter(v -> !invoiceEntryIds.contains(v.getEntryId())).collect(Collectors.toList());
            if (!newAllDumpInvoiceDOs.isEmpty()) {
                String fmt = ResManager.loadKDString((String)"\u53d1\u7968\u201c%1$s\u201d\u5df2\u88ab\u201c%2$s\u201d\uff08%3$s\uff09\u5f15\u7528\u3002", (String)"BillSavePlugin_4", (String)"fi-er-opplugin", (Object[])new Object[0]);
                Iterator iterator = newAllDumpInvoiceDOs.iterator();
                while (iterator.hasNext()) {
                    DuplicateInvoiceDo dup = (DuplicateInvoiceDo)iterator.next();
                    String msg = String.format(fmt, dup.getInvoiceNo(), dup.getBillName(), dup.getBillNo());
                    resultList.add(msg);
                }
            }
        }
        boolean isShowTaxNo = isTipsBeforeSubmit ? ONLY_SUGGEST.equalsIgnoreCase(sameTaxNoCtrl) : STRICT_CONTROL.equalsIgnoreCase(sameTaxNoCtrl);
        boolean isShowName = isTipsBeforeSubmit ? ONLY_SUGGEST.equalsIgnoreCase(sameTitleCtrl) : STRICT_CONTROL.equalsIgnoreCase(sameTitleCtrl);
        boolean isShowPerson = isTipsBeforeSubmit ? ONLY_SUGGEST.equalsIgnoreCase(sameNameCtrl) : STRICT_CONTROL.equalsIgnoreCase(sameNameCtrl);
        boolean checkNotPassCi = isTipsBeforeSubmit ? ONLY_SUGGEST.equalsIgnoreCase(checkPassCtrl) : STRICT_CONTROL.equalsIgnoreCase(checkPassCtrl);
        HashSet invoiceCodePersonList = Sets.newHashSetWithExpectedSize((int)invoiceEntries.size());
        HashSet invoiceCodeNameList = Sets.newHashSetWithExpectedSize((int)invoiceEntries.size());
        HashSet invoiceCodeTaxList = Sets.newHashSetWithExpectedSize((int)invoiceEntries.size());
        HashSet invoiceCodeNameTaxList = Sets.newHashSetWithExpectedSize((int)invoiceEntries.size());
        HashSet checkNotPassList = Sets.newHashSetWithExpectedSize((int)invoiceEntries.size());
        boolean hasValidatestProp = invoiceEntries.getDynamicObjectType().getProperty("ie_validatest") != null;
        for (DynamicObject invoice2 : invoiceEntries) {
            String invoiceType = invoice2.getString("invoicetype");
            Set<String> vatInvoice = InvoiceTypeUtils.loadVatInvoiceTypes();
            if (!vatInvoice.contains(invoiceType)) continue;
            String invoiceCode = invoice2.getString("invoiceno");
            String personalInvoice = invoice2.getString("personalinvoice");
            if (StringUtils.equals((CharSequence)personalInvoice, (CharSequence)"1")) {
                if (isShowPerson && !NO_CONTROL.equalsIgnoreCase(sameNameCtrl)) {
                    invoiceCodePersonList.add(invoiceCode);
                }
            } else {
                List titleTaxList = config.getTitleTaxList();
                boolean sameName = true;
                if (isShowName) {
                    String buyerName = invoice2.getString("buyerorgname").replaceAll("\\(", "\uff08").replaceAll("\\)", "\uff09").replaceAll(" ", "").replaceAll(String.valueOf('\u00a0'), "").replaceAll(String.valueOf('\u200b'), "").replaceAll(String.valueOf('\u3000'), "");
                    sameName = titleTaxList.stream().anyMatch(t -> StringUtils.equals((CharSequence)buyerName, (CharSequence)t.getFirmName()));
                }
                boolean sameTaxNo = true;
                if (isShowTaxNo) {
                    String buyerTaxNo = invoice2.getString("buyertaxno");
                    sameTaxNo = titleTaxList.stream().anyMatch(t -> StringUtils.equals((CharSequence)buyerTaxNo, (CharSequence)t.getTaxRegNum()));
                }
                if (!sameTaxNo && !sameName) {
                    invoiceCodeNameTaxList.add(invoiceCode);
                } else if (!sameTaxNo) {
                    invoiceCodeTaxList.add(invoiceCode);
                } else if (!sameName) {
                    invoiceCodeNameList.add(invoiceCode);
                }
            }
            if (!hasValidatestProp || !checkNotPassCi || !StringUtils.equals((CharSequence)invoice2.getString("ie_validatest"), (CharSequence)InvoiceVO.CheckStatus.NOT_OK.getValue())) continue;
            checkNotPassList.add(invoiceCode);
        }
        String submitTips = ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"InvoiceUtils_10", (String)"fi-er-business", (Object[])new Object[0]);
        submitTips = String.format(",%s", submitTips);
        if (isTipsBeforeSubmit) {
            submitTips = "";
        }
        if (!invoiceCodeNameTaxList.isEmpty()) {
            String allTips = ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u7684\u62ac\u5934\u7a0e\u53f7\u4e0e\u4f01\u4e1a\u7684\u540d\u79f0\u7a0e\u53f7\u4e0d\u4e00\u81f4%2$s", (String)"InvoiceUtils_16", (String)"fi-er-business", (Object[])new Object[0]);
            resultList.add(String.format(allTips, String.join((CharSequence)"\uff0c", invoiceCodeNameTaxList), submitTips));
        }
        if (!invoiceCodeNameList.isEmpty()) {
            String nameTips = ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u62ac\u5934\u4e0e\u4f01\u4e1a\u540d\u79f0\u4e0d\u4e00\u81f4%2$s", (String)"InvoiceUtils_19", (String)"fi-er-business", (Object[])new Object[0]);
            resultList.add(String.format(nameTips, String.join((CharSequence)"\uff0c", invoiceCodeNameList), submitTips));
        }
        if (!invoiceCodeTaxList.isEmpty()) {
            String taxTips = ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u7a0e\u53f7\u4e0e\u4f01\u4e1a\u7a0e\u53f7\u4e0d\u4e00\u81f4%2$s", (String)"InvoiceUtils_21", (String)"fi-er-business", (Object[])new Object[0]);
            resultList.add(String.format(taxTips, String.join((CharSequence)"\uff0c", invoiceCodeTaxList), submitTips));
        }
        if (!invoiceCodePersonList.isEmpty()) {
            String personTips = ResManager.loadKDString((String)"\u4e2a\u4eba\u53d1\u7968\uff1a%1$s\u62ac\u5934\u4e0e\u4f01\u4e1a\u540d\u79f0\u4e0d\u4e00\u81f4%2$s", (String)"InvoiceUtils_20", (String)"fi-er-business", (Object[])new Object[0]);
            resultList.add(String.format(personTips, String.join((CharSequence)"\uff0c", invoiceCodePersonList), submitTips));
        }
        if (!checkNotPassList.isEmpty()) {
            String checkNotPassTips = ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u67e5\u9a8c\u4e0d\u901a\u8fc7%2$s", (String)"InvoiceUtils_17", (String)"fi-er-business", (Object[])new Object[0]);
            resultList.add(String.format(checkNotPassTips, String.join((CharSequence)"\uff0c", checkNotPassList), submitTips));
        }
        return resultList;
    }

    private static List<DuplicateInvoiceDo> queryDuplicateInvoices(String entityName, String billName, QFilter[] qFilters) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)InvoiceUtils.class.getCanonicalName(), (String)entityName, (String)"billno, invoiceentry.id entryid, invoiceentry.serialno serialno, invoiceentry.invoiceno invoiceno, invoiceentry.invoicecode invoicecode", (QFilter[])qFilters, null);
        ArrayList duplicateInvoiceDos = Lists.newArrayList();
        for (Row row : dataSet) {
            DuplicateInvoiceDo dumplicateInvoiceDO = new DuplicateInvoiceDo();
            dumplicateInvoiceDO.setBillNo(row.getString("billno"));
            dumplicateInvoiceDO.setEntryId(row.getLong("entryid"));
            dumplicateInvoiceDO.setBillName(billName);
            dumplicateInvoiceDO.setInvoiceNo(row.getString("invoiceno"));
            duplicateInvoiceDos.add(dumplicateInvoiceDO);
        }
        return duplicateInvoiceDos;
    }

    public static void outLog(IDataModel model, String entryName, int[] indexs) {
        String billStatus = (String)model.getValue("billstatus");
        if (StringUtils.equals((CharSequence)billStatus, (CharSequence)"A") || StringUtils.equals((CharSequence)billStatus, (CharSequence)"D")) {
            return;
        }
        log.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)new Exception(ResManager.loadKDString((String)"\u975e\u6682\u5b58\u72b6\u6001\u8f93\u51fa\u5220\u9664\u5206\u5f55\u7684\u5806\u6808\u65e5\u5fd7", (String)"InvoiceUtils_3", (String)"fi-er-business", (Object[])new Object[0]))));
        log.info("\u5206\u5f55\u6807\u8bc6\uff1a" + entryName + "\uff0c\u5f85\u5220\u9664\u7684\u5206\u5f55index\uff1a" + SerializationUtils.toJsonString((Object)indexs));
    }

    @Deprecated
    public static void outLogInfo(BeforeDeleteRowEventArgs e, IDataModel model) {
    }

    @Deprecated
    public static void outLogInfo(AfterDeleteRowEventArgs e, IDataModel model) {
    }

    public static void outLogInfo(DynamicObject dataEntity) {
        String entityId = dataEntity.getDataEntityType().getName();
        StringBuilder sb = new StringBuilder();
        if (ErEntityTypeUtils.isDailyReimburseBill((String)entityId) || ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
            DynamicObjectCollection expenseentryentity = dataEntity.getDynamicObjectCollection("expenseentryentity");
            sb.append("the data of before bill calling save operation, detail entries\uff1a");
            sb.append(expenseentryentity.size());
            DynamicObjectCollection invoiceentry = dataEntity.getDynamicObjectCollection("invoiceentry");
            sb.append("\uff0cinvoiceentry\uff1a");
            sb.append(invoiceentry.size());
            DynamicObjectCollection accountentry = dataEntity.getDynamicObjectCollection("accountentry");
            sb.append("\uff0caccountentry\uff1a");
            sb.append(accountentry.size());
        } else if (ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
            DynamicObjectCollection tripentry = dataEntity.getDynamicObjectCollection("tripentry");
            sb.append("the data of before bill calling save operation\uff0ctripentry\uff1a");
            sb.append(tripentry.size());
            StringBuilder sbEntity = new StringBuilder();
            sbEntity.append("the data of before bill calling save operation\uff0ctripentry detail\uff1a");
            for (int i = 0; i < tripentry.size(); ++i) {
                sbEntity.append("index\uff1a");
                sbEntity.append(i);
                sbEntity.append("\uff0c");
                sbEntity.append(((DynamicObject)tripentry.get(0)).getDynamicObjectCollection("entryentity").size());
            }
            log.info(sbEntity.toString());
            DynamicObjectCollection invoiceentry = dataEntity.getDynamicObjectCollection("invoiceentry");
            sb.append("the data of before bill calling save operation\uff0cinvoiceentry\uff1a");
            sb.append(invoiceentry.size());
            DynamicObjectCollection accountentry = dataEntity.getDynamicObjectCollection("accountentry");
            sb.append("the data of before bill calling save operation\uff0caccountentry\uff1a");
            sb.append(accountentry.size());
        }
        log.info(sb.toString());
    }

    @Deprecated
    public static void outLogInfo(Set<Object> pkSet, MainEntityType billEntityType) {
    }

    public static void costChageRefreshItemTaxAmount(IDataModel model, long costCompanyId) {
        String entityId = model.getDataEntity(true).getDynamicObjectType().getName();
        if (ErEntityTypeUtils.isDailyReimburseBill((String)entityId)) {
            InvoiceUtils.costChageRefreshItemTaxAmount(model, costCompanyId, BillEntityType.DailyReimburse);
        } else if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
            InvoiceUtils.costChageRefreshItemTaxAmount(model, costCompanyId, BillEntityType.PublicReimburse);
        } else if (ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
            InvoiceUtils.costChageRefreshItemTaxAmount(model, costCompanyId, BillEntityType.TripReimburse);
        }
        InvoiceUtils.costChangeRefreshInvoiceTaxAmount(model, costCompanyId);
    }

    private static void costChangeRefreshInvoiceTaxAmount(IDataModel model, long costCompanyId) {
        boolean isImportNonDeductionTaxAmount = KingdeeInvoiceCloudConfig.isNonOffsetImportTaxAmout((Long)costCompanyId);
        DynamicObjectCollection invoiceEntries = model.getDataEntity(true).getDynamicObjectCollection("invoiceentry");
        DynamicObjectCollection invoiceItemEntries = model.getDataEntity(true).getDynamicObjectCollection("invoiceitementry");
        if (invoiceEntries.isEmpty() || invoiceItemEntries.isEmpty()) {
            log.info("\u53d1\u7968\u4fe1\u606f\u6216\u53d1\u7968\u660e\u7ec6\u5206\u5f55\u4e3a\u7a7a!");
            return;
        }
        int length = invoiceEntries.size();
        for (int index = 0; index < length; ++index) {
            DynamicObject invoiceEntry = (DynamicObject)invoiceEntries.get(index);
            Long pkValue = (Long)invoiceEntry.getPkValue();
            List relInvoiceItem = invoiceItemEntries.stream().filter(item -> pkValue.compareTo(item.getLong("invoiceheadentryid")) == 0).collect(Collectors.toList());
            DynamicObject invoiceItemEntry = null;
            if (CollectionUtils.isNotEmpty(relInvoiceItem)) {
                invoiceItemEntry = (DynamicObject)relInvoiceItem.get(0);
            }
            if (invoiceItemEntry == null) {
                log.info("fentryid :" + pkValue + " \u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u53d1\u7968\u660e\u7ec6");
                continue;
            }
            boolean invoiceOffset = InvoiceOffsetUtils.isInvoiceItemOffset(invoiceItemEntry);
            if (invoiceOffset) continue;
            String allTaxRate = "";
            BigDecimal invoiceTaxAmount = BigDecimal.ZERO;
            if (isImportNonDeductionTaxAmount) {
                NumberFormat df = DecimalFormat.getPercentInstance();
                df.setMinimumFractionDigits(1);
                Set taxRateSet = relInvoiceItem.stream().map(invoiceItem -> {
                    BigDecimal itemTaxRate = invoiceItem.getBigDecimal("invoiceitemtaxrate");
                    String format = df.format(itemTaxRate == null ? BigDecimal.ZERO : itemTaxRate);
                    return format.replaceAll("\\.*0*%", "");
                }).collect(Collectors.toSet());
                allTaxRate = taxRateSet.stream().collect(Collectors.joining(","));
                invoiceTaxAmount = relInvoiceItem.stream().map(invoiceItem -> invoiceItem.getBigDecimal("invoiceitemtaxamout")).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            model.setValue("alltaxrate", (Object)allTaxRate, index);
            model.setValue("taxamount_invoice", (Object)invoiceTaxAmount, index);
        }
    }

    public static void costChageRefreshItemTaxAmount(IDataModel model, long costCompanyId, BillEntityType type) {
        Map<Long, Set<Long>> ivoiceNonAutoMapItem;
        DynamicObject bill = model.getDataEntity(true);
        Map<Long, Set<Long>> itemAutoMapInvoice = InvoiceUtils.autoMapInvoiceMappingInfo(bill);
        if (!itemAutoMapInvoice.isEmpty()) {
            InvoiceUtils.refreshItem(model, costCompanyId, itemAutoMapInvoice, type);
        }
        if (!(ivoiceNonAutoMapItem = InvoiceUtils.nonAutoMapItemMapingInfo(bill)).isEmpty()) {
            String itemIds;
            HashMap itemsAndInvoices = Maps.newHashMap();
            for (Map.Entry<Long, Set<Long>> entry : ivoiceNonAutoMapItem.entrySet()) {
                if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                itemIds = StringUtils.join((Iterable)entry.getValue(), (String)",");
                List invoices = (List)itemsAndInvoices.get(itemIds);
                if (invoices == null) {
                    invoices = Lists.newArrayList();
                    itemsAndInvoices.put(itemIds, invoices);
                }
                invoices.add(entry.getKey());
            }
            for (Map.Entry<Long, Set<Long>> entry : itemsAndInvoices.entrySet()) {
                itemIds = (String)((Object)entry.getKey());
                ArrayList items = null;
                items = itemIds.contains(",") ? Arrays.stream(itemIds.split(",")).map(v -> Long.parseLong(v)).collect(Collectors.toList()) : Lists.newArrayList((Object[])new Long[]{Long.parseLong(itemIds)});
                InvoiceUtils.refreshTaxAmountShare(model, costCompanyId, (List)((Object)entry.getValue()), items, type);
            }
        }
    }

    public static void refreshItem(IDataModel model, long costCompanyId, Map<Long, Set<Long>> itemMapInvoice, BillEntityType type) {
        DynamicObject bill = model.getDataEntity(true);
        boolean isImportNonDeductionTaxAmout = KingdeeInvoiceCloudConfig.isNonOffsetImportTaxAmout((Long)costCompanyId);
        if (type == BillEntityType.TripReimburse) {
            DynamicObjectCollection tripColl = bill.getDynamicObjectCollection("tripentry");
            int currParentIndex = model.getEntryCurrentRowIndex("tripentry");
            for (int parentIndex = 0; parentIndex < tripColl.size(); ++parentIndex) {
                model.setEntryCurrentRowIndex("tripentry", parentIndex);
                InvoiceUtils.refreshItemTaxAndTaxAmount(bill, (DynamicObject)tripColl.get(parentIndex), type, itemMapInvoice, model, isImportNonDeductionTaxAmout, parentIndex);
            }
            model.setEntryCurrentRowIndex("tripentry", currParentIndex);
        } else {
            InvoiceUtils.refreshItemTaxAndTaxAmount(bill, bill, type, itemMapInvoice, model, isImportNonDeductionTaxAmout, 0);
        }
    }

    private static void refreshItemTaxAndTaxAmount(DynamicObject bill, DynamicObject entryParent, BillEntityType type, Map<Long, Set<Long>> itemMapInvoice, IDataModel model, boolean isImportNonDeductionTaxAmout, int parentIndex) {
        DynamicObjectCollection items = entryParent.getDynamicObjectCollection(type.getItemKey());
        for (int itemIndex = 0; itemIndex < items.size(); ++itemIndex) {
            InvoiceUtils.refreshItemTaxAndTaxAmount(bill, entryParent, type, itemMapInvoice, model, isImportNonDeductionTaxAmout, parentIndex, itemIndex);
        }
    }

    public static void refreshItemTaxAndTaxAmount(DynamicObject bill, DynamicObject entryParent, BillEntityType type, Map<Long, Set<Long>> itemMapInvoice, IDataModel model, boolean isImportNonDeductionTaxAmout, int parentIndex, int itemIndex) {
        DynamicObjectCollection items = entryParent.getDynamicObjectCollection(type.getItemKey());
        DynamicObject item = (DynamicObject)items.get(itemIndex);
        if (item == null) {
            return;
        }
        Set<Long> invoiceHeadIds = itemMapInvoice.get(item.getPkValue());
        if (invoiceHeadIds == null) {
            return;
        }
        BigDecimal invoiceTaxAmout = bill.getDynamicObjectCollection("invoiceitementry").stream().filter(v -> invoiceHeadIds.contains(v.get("invoiceheadentryid"))).map(v -> v.getBigDecimal("invoiceitemtaxamout")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal taxRate = BigDecimal.ZERO;
        Set taxRates = bill.getDynamicObjectCollection("invoiceitementry").stream().filter(v -> invoiceHeadIds.contains(v.get("invoiceheadentryid"))).map(v -> v.getBigDecimal("invoiceitemtaxrate")).collect(Collectors.toSet());
        if (taxRates.size() == 1) {
            taxRate = (BigDecimal)taxRates.iterator().next();
        }
        if (!isImportNonDeductionTaxAmout) {
            Stream offsetInvoiceItem = InvoiceOffsetUtils.getOffsetInvoiceItem((Collection)bill.getDynamicObjectCollection("invoiceitementry"), invoiceHeadIds);
            BigDecimal reInvoiceTaxAmount = offsetInvoiceItem.map(v -> v.getBigDecimal("invoiceitemtaxamout")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            if (invoiceTaxAmout.compareTo(reInvoiceTaxAmount) != 0 || reInvoiceTaxAmount.compareTo(BigDecimal.ZERO) == 0) {
                taxRate = BigDecimal.ZERO;
            }
            invoiceTaxAmout = reInvoiceTaxAmount;
        }
        model.setValue("taxrate", (Object)taxRate.multiply(BigDecimal.valueOf(100L)), itemIndex, parentIndex);
        model.setValue("taxamount", (Object)invoiceTaxAmout, itemIndex, parentIndex);
    }

    public static void refresh(IDataModel model, Long costCompanyId) {
        DynamicObject bill = model.getDataEntity(true);
        boolean isImportNonDeductionTaxAmout = KingdeeInvoiceCloudConfig.isNonOffsetImportTaxAmout((Long)costCompanyId);
        BigDecimal invoiceTaxAmout = bill.getDynamicObjectCollection("invoiceitementry").stream().map(v -> v.getBigDecimal("invoiceitemtaxamout")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal taxRate = BigDecimal.ZERO;
        Set taxRates = bill.getDynamicObjectCollection("invoiceitementry").stream().map(v -> v.getBigDecimal("invoiceitemtaxrate")).collect(Collectors.toSet());
        if (taxRates.size() == 1) {
            taxRate = (BigDecimal)taxRates.iterator().next();
        }
        if (!isImportNonDeductionTaxAmout) {
            BigDecimal reInvoiceTaxAmount = InvoiceOffsetUtils.getOffsetInvoiceItem((Collection)bill.getDynamicObjectCollection("invoiceitementry")).map(v -> v.getBigDecimal("invoiceitemtaxamout")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            if (invoiceTaxAmout.compareTo(reInvoiceTaxAmount) != 0 || reInvoiceTaxAmount.compareTo(BigDecimal.ZERO) == 0) {
                taxRate = BigDecimal.ZERO;
            }
            invoiceTaxAmout = reInvoiceTaxAmount;
        }
        model.setValue("taxrate", (Object)taxRate.multiply(BigDecimal.valueOf(100L)));
        model.setValue("taxamount", (Object)invoiceTaxAmout);
    }

    public static void refreshItemTaxAndTaxAmount(IFormView view, DynamicObject item, Map<Long, Set<Long>> itemMapInvoice, boolean isImportNonDeductionTaxAmout, int parentIndex, int itemIndex) {
        if (item == null) {
            return;
        }
        Set<Long> invoiceHeadIds = itemMapInvoice.get(item.getPkValue());
        if (invoiceHeadIds == null) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObject bill = view.getModel().getDataEntity(true);
        Boolean itemOffset = (Boolean)model.getValue("offset", itemIndex, parentIndex);
        if (itemOffset.booleanValue()) {
            BigDecimal invoiceTaxAmout = bill.getDynamicObjectCollection("invoiceitementry").stream().filter(v -> invoiceHeadIds.contains(v.get("invoiceheadentryid"))).map(v -> v.getBigDecimal("invoiceitemtaxamout")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal taxRate = BigDecimal.ZERO;
            Set taxRates = bill.getDynamicObjectCollection("invoiceitementry").stream().filter(v -> invoiceHeadIds.contains(v.get("invoiceheadentryid"))).map(v -> v.getBigDecimal("invoiceitemtaxrate")).collect(Collectors.toSet());
            IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
            if (parentView != null && parentView.getModel().getProperty("invoiceitementry") != null) {
                DynamicObject headBill = parentView.getModel().getDataEntity(true);
                if (parentView.getModel().getDataEntityType().getProperty("invoiceitementry") != null) {
                    invoiceTaxAmout = invoiceTaxAmout.add(headBill.getDynamicObjectCollection("invoiceitementry").stream().filter(v -> invoiceHeadIds.contains(v.get("invoiceheadentryid"))).map(v -> v.getBigDecimal("invoiceitemtaxamout")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    taxRates.addAll(headBill.getDynamicObjectCollection("invoiceitementry").stream().filter(v -> invoiceHeadIds.contains(v.get("invoiceheadentryid"))).map(v -> v.getBigDecimal("invoiceitemtaxrate")).collect(Collectors.toSet()));
                }
            }
            if (taxRates.size() == 1) {
                taxRate = (BigDecimal)taxRates.iterator().next();
            }
            if (!isImportNonDeductionTaxAmout) {
                BigDecimal reInvoiceTaxAmount = InvoiceOffsetUtils.getOffsetInvoiceItem((Collection)bill.getDynamicObjectCollection("invoiceitementry"), invoiceHeadIds).map(v -> v.getBigDecimal("invoiceitemtaxamout")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                if (parentView != null) {
                    DynamicObject headBill = parentView.getModel().getDataEntity(true);
                    if (parentView.getModel().getDataEntityType().getProperty("invoiceitementry") != null) {
                        reInvoiceTaxAmount = reInvoiceTaxAmount.add(InvoiceOffsetUtils.getOffsetInvoiceItem((Collection)headBill.getDynamicObjectCollection("invoiceitementry"), invoiceHeadIds).map(v -> v.getBigDecimal("invoiceitemtaxamout")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    }
                }
                if (invoiceTaxAmout.compareTo(reInvoiceTaxAmount) != 0 || reInvoiceTaxAmount.compareTo(BigDecimal.ZERO) == 0) {
                    taxRate = BigDecimal.ZERO;
                }
                invoiceTaxAmout = reInvoiceTaxAmount;
            }
            model.setValue("taxrate", (Object)taxRate.multiply(BigDecimal.valueOf(100L)), itemIndex, parentIndex);
            model.setValue("taxamount", (Object)invoiceTaxAmout, itemIndex, parentIndex);
        }
    }

    public static void updateInvoiceLabel(IFormView view) {
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        DynamicObjectCollection invoiceEntryDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
        int invoiceCount = invoiceEntryDOs.stream().mapToInt(invoiceHead -> invoiceHead.getInt("count")).sum();
        BigDecimal invoiceTotalAmount = invoiceEntryDOs.stream().map(invoiceEntryDO -> invoiceEntryDO.getBigDecimal("totalamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        Object company = view.getModel().getValue("company");
        DynamicObject currency = null;
        if (company != null) {
            Long currencyId = SystemParamterUtil.getInvoiceEntryCurrency((Long)ErCommonUtils.getPk(company));
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)currencyId)};
            currency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"sign, amtprecision", (QFilter[])qFilters);
        }
        Integer amtprecision = 4;
        String sign = "\uffe5";
        if (currency != null) {
            sign = currency.getString("sign");
            amtprecision = currency.getInt("amtprecision");
        }
        Label countLab = (Label)view.getControl("lbl_invoicecount");
        Label amountLab = (Label)view.getControl("lbl_totalamount");
        if (countLab != null) {
            countLab.setText(String.valueOf(invoiceCount));
        }
        if (amountLab != null) {
            String formatMoneyByUser = AmountUtils.formatMoneyByUser((Long)RequestContext.get().getCurrUserId(), (String)sign, (int)amtprecision, (BigDecimal)invoiceTotalAmount);
            amountLab.setText(formatMoneyByUser);
        }
    }

    public static void updateIfTaxAmountZero(IDataModel dataModel, BigDecimal taxRate, int rowIndex) {
        boolean zero;
        BigDecimal rowTaxAmount = (BigDecimal)dataModel.getValue("taxamount", rowIndex);
        boolean bl = zero = BigDecimal.ZERO.compareTo(rowTaxAmount) == 0;
        if (zero) {
            dataModel.setValue("taxrate", (Object)taxRate, rowIndex);
        }
    }

    public static void updateTaxWhenItemChange(IFormView view, IDataModel dataModel, BigDecimal itemTaxRate, int rowIndex, int parentIndex) {
        if (dataModel.getProperty("taxrate") == null || dataModel.getProperty("taxamount") == null) {
            return;
        }
        String entityId = view.getEntityId();
        String itemFrom = ItemFrom.Manual.getValue();
        if (dataModel.getProperty("itemfrom") != null) {
            itemFrom = (String)dataModel.getValue("itemfrom", rowIndex, parentIndex);
        }
        if (!StringUtils.equals((CharSequence)itemFrom, (CharSequence)ItemFrom.Manual.getValue())) {
            return;
        }
        boolean isTaxPayer = InvoiceOffsetUtils.deductibleOfTaxPayer((IDataModel)dataModel);
        if (isTaxPayer) {
            BigDecimal taxAmount;
            BigDecimal taxRate;
            if (ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
                taxRate = (BigDecimal)dataModel.getValue("taxrate", rowIndex, parentIndex);
                taxAmount = (BigDecimal)dataModel.getValue("taxamount", rowIndex, parentIndex);
            } else if (ErEntityTypeUtils.isDailyOrPubReimBill((String)entityId)) {
                taxRate = (BigDecimal)dataModel.getValue("taxrate", rowIndex, parentIndex);
                taxAmount = (BigDecimal)dataModel.getValue("taxamount", rowIndex, parentIndex);
            } else {
                taxRate = (BigDecimal)dataModel.getValue("taxrate", rowIndex, parentIndex);
                taxAmount = (BigDecimal)dataModel.getValue("taxamount", rowIndex, parentIndex);
            }
            if (BigDecimal.ZERO.compareTo(taxRate) == 0 && BigDecimal.ZERO.compareTo(taxAmount) == 0) {
                if (ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
                    dataModel.setValue("taxrate", (Object)itemTaxRate, rowIndex, parentIndex);
                } else if (ErEntityTypeUtils.isDailyOrPubReimBill((String)entityId)) {
                    dataModel.setValue("taxrate", (Object)itemTaxRate, rowIndex);
                } else {
                    dataModel.setValue("taxrate", (Object)itemTaxRate, rowIndex);
                }
            }
        } else if (ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
            dataModel.setValue("taxrate", (Object)BigDecimal.ZERO, rowIndex, parentIndex);
        } else if (ErEntityTypeUtils.isDailyOrPubReimBill((String)entityId)) {
            dataModel.setValue("taxrate", (Object)BigDecimal.ZERO, rowIndex);
        } else {
            dataModel.setValue("taxrate", (Object)BigDecimal.ZERO, rowIndex);
        }
    }

    public static void updateOffsetWhenItemChange(IFormView view, IDataModel dataModel, Boolean itemOffset, int rowIndex, int parentIndex) {
        DynamicObject companyObj;
        Boolean offsetOfExpense;
        String entityId = view.getEntityId();
        if (dataModel.getProperty("company") == null) {
            return;
        }
        if (ErEntityTypeUtils.isReimBill((String)entityId)) {
            if (dataModel.getProperty("itemfrom") == null) {
                return;
            }
            boolean isTaxPayer = InvoiceOffsetUtils.deductibleOfTaxPayer((IDataModel)dataModel);
            String itemFrom = (String)dataModel.getValue("itemfrom", rowIndex, parentIndex);
            boolean offset = false;
            if (ItemFrom.Manual.getValue().equals(itemFrom)) {
                DynamicObject companyObj2 = (DynamicObject)dataModel.getValue("company");
                Boolean offsetOfExpense2 = SystemParamterUtil.manuallyaddexpenseoffset((Long)((Long)companyObj2.getPkValue()));
                if (offsetOfExpense2.booleanValue()) {
                    offset = isTaxPayer && itemOffset != false;
                }
            } else if (ItemFrom.InvoiceCloud.getValue().equals(itemFrom)) {
                DynamicObject entryEntity = ErEntityTypeUtils.isTripReimburseBill((String)entityId) ? dataModel.getEntryRowEntity("entryentity", rowIndex, parentIndex) : dataModel.getEntryRowEntity("expenseentryentity", rowIndex, parentIndex);
                Long tripItemEntryId = (Long)entryEntity.getPkValue();
                boolean invoiceOffset = InvoiceOffsetUtils.getExpenseRowMapInvoicesOffset((IDataModel)dataModel, (Long)tripItemEntryId, (IFormView)view);
                offset = isTaxPayer && itemOffset != false && invoiceOffset;
            }
            dataModel.setValue("offset", (Object)offset, rowIndex, parentIndex);
        } else if (ErEntityTypeUtils.isWithholdingBill((String)entityId) && (offsetOfExpense = Boolean.valueOf(SystemParamterUtil.manuallyaddexpenseoffset((Long)((Long)(companyObj = (DynamicObject)dataModel.getValue("company")).getPkValue())))).booleanValue()) {
            dataModel.setValue("offset", (Object)itemOffset, rowIndex, parentIndex);
        }
    }

    public static void changeAutoInvoice(IDataModel model, IFormView view, Long costCompanyId) {
        FieldEdit control;
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)costCompanyId);
        if (model.getProperty("automapinvoice") != null && (control = (FieldEdit)view.getControl("automapinvoice")) != null) {
            BooleanProp property = (BooleanProp)control.getProperty();
            Object defaultValue = property.getDefaultValue();
            model.setValue("automapinvoice", config == null ? Boolean.valueOf(false) : defaultValue);
        }
    }

    public static QueryInvoiceDetailParam buildQueryInvoiceDetailParam(AbstractFormPlugin plugin, DynamicObject costCompany, Collection<String> serialNos) {
        QueryInvoiceDetailParam param = new QueryInvoiceDetailParam();
        DynamicObject dataEntity = plugin.getView().getModel().getDataEntity();
        String entityName = dataEntity.getDataEntityType().getName();
        param.setBillType(entityName);
        param.setEntityId(entityName);
        param.setBillId(String.valueOf(dataEntity.getPkValue()));
        Long invoiceOrgId = ErCommonUtils.getPk(costCompany);
        param.setOrgId(String.valueOf(invoiceOrgId));
        param.setSerialNos(new ArrayList<String>(serialNos));
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)invoiceOrgId);
        if (config == null) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8d39\u7528\u627f\u62c5\u516c\u53f8\u672a\u542f\u7528\u53d1\u7968\u4e91\uff0c\u8bf7\u5148\u542f\u7528\u3002", (String)"AbstractImportInvoicePlugin_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return null;
        }
        String taxRegnum = config.getTaxRegnum();
        String companyName = config.getFirmname();
        List taxNoList = Arrays.stream(taxRegnum.split("=")).collect(Collectors.toList());
        List companyNameList = Arrays.stream(companyName.split("=")).collect(Collectors.toList());
        int companyInfoCount = taxNoList.size() < companyNameList.size() ? taxNoList.size() : companyNameList.size();
        ArrayList companyInfos = Lists.newArrayListWithExpectedSize((int)companyInfoCount);
        for (int i = 0; i < companyInfoCount; ++i) {
            QueryInvoiceDetailParam.CompanyInfo companyInfo = new QueryInvoiceDetailParam.CompanyInfo();
            companyInfo.setTaxNo((String)taxNoList.get(i));
            companyInfo.setName((String)companyNameList.get(i));
            companyInfos.add(companyInfo);
        }
        param.setCompanyInfo((List)companyInfos);
        return param;
    }

    public static List<DynamicObject> getInvoiceFromThis(IDataModel model, Long expenseEntryId) {
        List<Object> splitLine = new ArrayList<DynamicObject>();
        IDataEntityProperty tripEntry = (IDataEntityProperty)model.getDataEntityType().getProperties().get((Object)"entryentity");
        IDataEntityProperty expenseEntry = (IDataEntityProperty)model.getDataEntityType().getProperties().get((Object)"expenseentryentity");
        DynamicObjectCollection expenseEntryCollection = null;
        if (tripEntry != null && "1".equals(model.getValue("billkind"))) {
            expenseEntryCollection = model.getEntryEntity("entryentity");
        } else if (expenseEntry != null) {
            expenseEntryCollection = model.getEntryEntity("expenseentryentity");
        }
        if (expenseEntryCollection != null) {
            splitLine = expenseEntryCollection.stream().filter(entry -> entry.getBoolean("invoicefromparent") && StringUtils.equals((CharSequence)entry.getString("splitline"), (CharSequence)expenseEntryId.toString())).collect(Collectors.toList());
        }
        return splitLine;
    }

    public static void deleteNonAutoInvoice(IDataModel model, Set<Long> expenseEntryId) {
        DynamicObjectCollection nonAutoRelations = model.getEntryEntity("invoiceandexpense");
        int[] collectIndex = nonAutoRelations.stream().filter(dynamicObject -> expenseEntryId.contains(dynamicObject.getLong("expenseentryid"))).map(obj -> obj.getInt("seq")).mapToInt(Integer::intValue).toArray();
        model.beginInit();
        model.deleteEntryRows("invoiceandexpense", collectIndex);
        model.endInit();
    }

    public static void createNonAutoInvoice(IDataModel model, Long expenseEntryId, Set<Long> invoiceHeadIdSet) {
        int[] indexArr = model.batchCreateNewEntryRow("invoiceandexpense", invoiceHeadIdSet.size());
        DynamicObjectCollection invoiceentry = model.getDataEntity(true).getDynamicObjectCollection("invoiceentry");
        HashMap<Object, String> relationMap = new HashMap<Object, String>();
        if (invoiceentry != null && invoiceentry.size() > 0) {
            for (int i = 0; i < invoiceentry.size(); ++i) {
                relationMap.put(((DynamicObject)invoiceentry.get(i)).getPkValue(), ((DynamicObject)invoiceentry.get(i)).getString("serialno"));
            }
        }
        int index = 0;
        model.beginInit();
        for (Long invoiceHeadId : invoiceHeadIdSet) {
            model.setValue("expenseentryid", (Object)expenseEntryId, indexArr[index]);
            model.setValue("invoiceentryid", (Object)invoiceHeadId, indexArr[index]);
            if (relationMap != null && !relationMap.isEmpty() && model.getProperty("invoiceexpserialno") != null && relationMap.get(invoiceHeadId) != null) {
                model.setValue("invoiceexpserialno", relationMap.get(invoiceHeadId), indexArr[index]);
            }
            ++index;
        }
        model.endInit();
    }

    public static Map<Long, Set<Long>> getInvoiceMappingItemRelation(IFormView view, IDataModel model) {
        Map<Long, Set<Long>> relationMap = new HashMap<Long, Set<Long>>();
        IDataEntityProperty autoMapInvoiceProp = (IDataEntityProperty)model.getDataEntityType().getProperties().get((Object)"automapinvoice");
        if (autoMapInvoiceProp == null) {
            return relationMap;
        }
        Boolean autoMapInvoice = (Boolean)model.getValue("automapinvoice");
        relationMap = autoMapInvoice != false ? InvoiceUtils2.autoMapItemMappingInfoCache((IFormView)view, (IDataModel)model, (String)"autoMapItemMappingInfo") : InvoiceUtils2.nonAutoMapItemMappingInfoCache((IFormView)view, (IDataModel)model, (String)"nonAutoMapItemMappingInfo");
        return relationMap;
    }

    @Deprecated
    public static Map<Long, Set<Long>> getParentInvoiceMapping(IFormView view, Map<Long, Set<Long>> invoiceItemMap) {
        return null;
    }

    @Deprecated
    public static Map<Long, Set<Long>> getSplitInvoiceMapping(IDataModel model, Map<Long, Set<Long>> invoiceItemMap, String cacheKey) {
        return null;
    }

    @Deprecated
    public static void clearCacheRelation() {
    }

    public static void updateAutomapinvoiceEnable(IFormView view, String ... fields) {
        if (view.getModel().getProperty("invoiceentry") != null) {
            DynamicObjectCollection invoiceEntrys = view.getModel().getEntryEntity("invoiceentry");
            boolean hasInvoice = invoiceEntrys != null && invoiceEntrys.stream().anyMatch(invoiceEntry -> StringUtils.equals((CharSequence)invoiceEntry.getString("invoicefrom"), (CharSequence)InvoiceFrom.InvoiceCloud.getValue()));
            view.setEnable(Boolean.valueOf(!hasInvoice), fields);
        }
    }

    private static boolean matches(String regex, String str) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        boolean result = matcher.matches();
        if (result) {
            log.info("regex {} \u5339\u914d : {} ", (Object)regex, (Object)matcher.group());
        }
        return result;
    }

    public static void lockCurrency(IFormView view, Set<Long> invoiceCurrencySet) {
        IDataModel model = view.getModel();
        if (invoiceCurrencySet.isEmpty()) {
            return;
        }
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        Long invoiceCurrency = invoiceCurrencySet.iterator().next();
        if (invoiceCurrency.equals(currency.getPkValue()) && invoiceCurrencySet.size() == 1) {
            return;
        }
        if (invoiceCurrencySet.size() >= 1 && model.getProperty("iscurrency") != null) {
            model.setValue("iscurrency", (Object)true);
        }
    }

    public static void toggleAutoMapInvoice(IFormView view, boolean isAutoMapInvoice) {
        view.setVisible(Boolean.valueOf(!isAutoMapInvoice), new String[]{"mapinvoice", "importnotcreateitem", "mapinvoicebyinvoiceno"});
        view.setVisible(Boolean.valueOf(!isAutoMapInvoice), new String[]{"mapinvoiceentry", "mapinvoicebyinvoicenoentr"});
        view.setVisible(Boolean.valueOf(isAutoMapInvoice), new String[]{"merge"});
        InvoiceUtils.showSingleLineImportInvoice(view, isAutoMapInvoice);
    }

    protected static void showSingleLineImportInvoice(IFormView view, Boolean invoiceSwitch) {
        String entryName = view.getEntityId();
        if (ErEntityTypeUtils.isDailyReimburseBill((String)entryName)) {
            boolean isShow = StringUtils.equals((CharSequence)"B", (CharSequence)((String)view.getModel().getValue("specialbill")));
            view.setVisible(Boolean.valueOf(!isShow && invoiceSwitch != false), new String[]{"selectinvoice"});
            view.setVisible(Boolean.valueOf(isShow && invoiceSwitch != false), new String[]{"selectinvoicenomerge1"});
        } else {
            view.setVisible(invoiceSwitch, new String[]{"selectinvoice"});
        }
        view.setVisible(invoiceSwitch, new String[]{"expenseimportinvoice"});
    }

    public static void changeInvoiceCurrency(IFormView view, ChangeData changeData) {
        IDataModel model = view.getModel();
        int rowIndex = changeData.getRowIndex();
        int parentRowIndex = changeData.getParentRowIndex();
        DynamicObject invoiceRow = model.getEntryRowEntity("invoiceentry", rowIndex, parentRowIndex);
        Long invoiceHeadId = (Long)invoiceRow.getPkValue();
        List<DetailExpenseModel> expenseItems = InvoiceUtils.getExpenseItemByInvoiceHeadIds(view, Collections.singleton(invoiceHeadId));
        if (model.getProperty("entrycurrency") != null) {
            if (expenseItems.isEmpty()) {
                return;
            }
            for (DetailExpenseModel expenseItem : expenseItems) {
                model.setValue("entrycurrency", changeData.getNewValue(), expenseItem.getRowIndex(), expenseItem.getParentIndex());
            }
            Set<Long> expenseItemIds = expenseItems.stream().map(item -> (Long)item.getDynamicObject().getPkValue()).collect(Collectors.toSet());
            Set<Long> invoiceIds = InvoiceUtils.getInvoiceIdsOfItems(model, expenseItemIds);
            DynamicObjectCollection invoiceEntry = model.getEntryEntity("invoiceentry");
            for (int index = 0; index < invoiceEntry.size(); ++index) {
                DynamicObject invoiceObj = (DynamicObject)invoiceEntry.get(index);
                if (!invoiceIds.contains(invoiceObj.getPkValue())) continue;
                model.beginInit();
                model.setValue("invoicecurrency", changeData.getNewValue(), index);
                model.endInit();
                view.updateView("invoicecurrency", index);
            }
        }
    }

    public static List<DetailExpenseModel> getExpenseItemByInvoiceHeadIds(IFormView view, Set<Long> invoiceIdsSet) {
        ArrayList<DetailExpenseModel> detailModels;
        block6: {
            boolean autoInvoice;
            IDataModel model;
            block7: {
                block5: {
                    model = view.getModel();
                    autoInvoice = false;
                    if (model.getProperty("automapinvoice") != null) {
                        autoInvoice = (Boolean)model.getValue("automapinvoice");
                    }
                    detailModels = new ArrayList<DetailExpenseModel>();
                    if (!ErEntityTypeUtils.isTripReimburseBill((String)view.getEntityId())) break block5;
                    List<Long> expenseItemIds = autoInvoice ? InvoiceUtils.getAutoItemIdByInvoiceHeadIds(model, invoiceIdsSet, "entryentity") : InvoiceUtils.getNonAutoItemIdByInvoiceHeadIds(model, invoiceIdsSet);
                    DynamicObjectCollection tripEntry = model.getEntryEntity("tripentry");
                    for (int parentIndex = 0; parentIndex < tripEntry.size(); ++parentIndex) {
                        DynamicObjectCollection expenseEntry = ((DynamicObject)tripEntry.get(parentIndex)).getDynamicObjectCollection("entryentity");
                        for (int index = 0; index < expenseEntry.size(); ++index) {
                            DynamicObject dynamicObject = (DynamicObject)expenseEntry.get(index);
                            if (!expenseItemIds.contains(dynamicObject.getPkValue())) continue;
                            DetailExpenseModel expenseModel = new DetailExpenseModel(dynamicObject, index, parentIndex);
                            detailModels.add(expenseModel);
                        }
                    }
                    break block6;
                }
                if (!ErEntityTypeUtils.isReimBill((String)view.getEntityId())) break block7;
                List<Long> expenseItemIds = autoInvoice ? InvoiceUtils.getAutoItemIdByInvoiceHeadIds(model, invoiceIdsSet, "expenseentryentity") : InvoiceUtils.getNonAutoItemIdByInvoiceHeadIds(model, invoiceIdsSet);
                DynamicObjectCollection expenseEntry = model.getEntryEntity("expenseentryentity");
                for (int rowIndex = 0; rowIndex < expenseEntry.size(); ++rowIndex) {
                    DynamicObject dynamicObject = (DynamicObject)expenseEntry.get(rowIndex);
                    if (!expenseItemIds.contains(dynamicObject.getPkValue())) continue;
                    DetailExpenseModel expenseModel = new DetailExpenseModel(dynamicObject, rowIndex, -1);
                    detailModels.add(expenseModel);
                }
                break block6;
            }
            if (!ErEntityTypeUtils.isCheckingpayBill((String)view.getEntityId())) break block6;
            List<Long> expenseItemIds = autoInvoice ? InvoiceUtils.getAutoItemIdByInvoiceHeadIds(model, invoiceIdsSet, "entryentity") : InvoiceUtils.getNonAutoItemIdByInvoiceHeadIds(model, invoiceIdsSet);
            DynamicObjectCollection expenseEntry = model.getEntryEntity("entryentity");
            for (int rowIndex = 0; rowIndex < expenseEntry.size(); ++rowIndex) {
                DynamicObject dynamicObject = (DynamicObject)expenseEntry.get(rowIndex);
                if (!expenseItemIds.contains(dynamicObject.getPkValue())) continue;
                DetailExpenseModel expenseModel = new DetailExpenseModel(dynamicObject, rowIndex, -1);
                detailModels.add(expenseModel);
            }
        }
        return detailModels;
    }

    public static void invoiceDeletePageRule(IFormView view, boolean delete) {
        IPageCache pageCache = view.getPageCache();
        IDataModel model = view.getModel();
        log.info("\u63a7\u5236\u53d1\u7968\u4fe1\u606f\u5206\u5f55\u7684\u5220\u9664\u56fe\u6807\u663e\u793a\u4e0e\u5426:{}", (Object)delete);
        boolean flag = model.getDataEntity(true).getDataEntityType().getProperties().containsKey((Object)"invoiceentry");
        if (!flag) {
            return;
        }
        if (delete) {
            view.setVisible(Boolean.TRUE, new String[]{"lab_done_invoice"});
            view.setVisible(Boolean.FALSE, new String[]{"lab_delete_invoice"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"lab_done_invoice"});
            view.setVisible(Boolean.TRUE, new String[]{"lab_delete_invoice"});
        }
        if ((ErEntityTypeUtils.isDailyReimburseBill((String)view.getEntityId()) || ErEntityTypeUtils.isPublicReimburseBill((String)view.getEntityId())) && model.getEntryRowCount("withholdingentry") > 0) {
            view.setVisible(Boolean.FALSE, new String[]{"lab_done_invoice"});
            view.setVisible(Boolean.FALSE, new String[]{"lab_delete_invoice"});
            delete = false;
        }
        InvoiceUtils.changeDeleteInvoiceStatus(pageCache, delete);
        int invoiceEntrySize = model.getEntryRowCount("invoiceentry");
        log.info("\u63a7\u5236\u53d1\u7968\u4fe1\u606f\u5206\u5f55\u7684\u5220\u9664\u56fe\u6807 invoiceEntrySize {}", (Object)invoiceEntrySize);
        if (0 == invoiceEntrySize) {
            view.setVisible(Boolean.FALSE, new String[]{"lab_delete_invoice"});
            view.setVisible(Boolean.FALSE, new String[]{"lab_done_invoice"});
        }
        if (view.getControl("invoiceentry") instanceof CardEntry) {
            CardEntry invoiceCard = (CardEntry)view.getControl("invoiceentry");
            log.info("\u63a7\u5236\u53d1\u7968\u4fe1\u606f\u5206\u5f55\u7684\u5220\u9664\u56fe\u6807 invoiceCard {}", (Object)invoiceCard);
            if (null != invoiceCard) {
                for (int rowIndex = 0; rowIndex < invoiceEntrySize; ++rowIndex) {
                    invoiceCard.setChildVisible(delete, rowIndex, new String[]{"delinvoiceheadentry"});
                }
                Vector vector = (Vector)view.getControl("vectorap111");
                log.info("\u63a7\u5236\u53d1\u7968\u4fe1\u606f\u5206\u5f55\u7684\u5220\u9664\u56fe\u6807 SHOW_INVOICE_ENTRY {}", (Object)pageCache.get("show_invoice_entry"));
                if (null != pageCache.get("show_invoice_entry")) {
                    vector.setFontClass("kdfont kdfont-zhankai4");
                } else {
                    vector.setFontClass("kdfont kdfont-shouqi7");
                }
                log.info("\u63a7\u5236\u53d1\u7968\u4fe1\u606f\u5206\u5f55\u7684\u5220\u9664\u56fe\u6807 null != this.getPageCache().get(SHOW_INVOICE_ENTRY) {}", (Object)(null != pageCache.get("show_invoice_entry") ? 1 : 0));
                view.setVisible(Boolean.valueOf(null != pageCache.get("show_invoice_entry")), new String[]{"invoiceentry"});
            }
        }
    }

    private static void changeDeleteInvoiceStatus(IPageCache pageCache, boolean status) {
        pageCache.put("is_deleting_invoice", String.valueOf(status));
    }

    public static boolean isDeleting(IFormView view) {
        IPageCache pageCache = view.getPageCache();
        String status = pageCache.get("is_deleting_invoice");
        return Boolean.parseBoolean(status);
    }

    public static void unbindInvoices(IDataModel dataModel, IFormView view, int rowInvoiceEntryIndexs) {
        try {
            DynamicObject dataEntity = dataModel.getDataEntity(true);
            DynamicObject selectedInvoiceEntry = null;
            DynamicObjectCollection expenseList = dataEntity.getDynamicObjectCollection("expenseentryentity");
            DynamicObjectCollection invoiceItemList = dataEntity.getDynamicObjectCollection("invoiceitementry");
            DynamicObjectCollection invoiceEntry = dataEntity.getDynamicObjectCollection("invoiceentry");
            if (dataModel.getProperty("automapinvoice") != null && ((Boolean)dataModel.getValue("automapinvoice")).booleanValue()) {
                Map<Long, List<PropBo>> invoiceItemMap = InvoiceUtils.getAutoMapInvoiceMappingInfoCache(dataEntity, "getAutoMapInvoiceMappingInfoCache");
                ThreadCache.remove((Object)"getAutoMapInvoiceMappingInfoCache");
                if (invoiceItemMap.isEmpty()) {
                    return;
                }
                for (Map.Entry<Long, List<PropBo>> entry : invoiceItemMap.entrySet()) {
                    InvoiceUtils.buildNonAutoInvoice(dataModel, entry.getKey(), entry.getValue());
                }
                if (invoiceItemList != null && invoiceItemList.size() > 0) {
                    for (DynamicObject invoiceItem : invoiceItemList) {
                        invoiceItem.set("itementryid", (Object)0);
                    }
                }
                if (expenseList != null && expenseList.size() > 0) {
                    for (DynamicObject expense : expenseList) {
                        expense.set("splitline", (Object)"");
                        expense.set("invoicefromparent", (Object)false);
                    }
                }
                dataModel.setValue("automapinvoice", (Object)false);
            }
            if (invoiceEntry != null && invoiceEntry.size() - 1 >= rowInvoiceEntryIndexs) {
                selectedInvoiceEntry = (DynamicObject)invoiceEntry.get(rowInvoiceEntryIndexs);
            }
            if (selectedInvoiceEntry != null) {
                dataModel.deleteEntryRow("invoiceentry", rowInvoiceEntryIndexs);
            }
        }
        catch (Exception e) {
            view.showTipNotification(ResManager.loadKDString((String)"\u89e3\u7ed1\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002", (String)"ErLoanBaseBillList_16", (String)"fi-er-formplugin", (Object[])new Object[0]));
            log.error("\u89e3\u7ed1\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return;
        }
    }

    private static Map<Long, List<PropBo>> getAutoMapInvoiceMappingInfoCache(DynamicObject bill, String cacheKey) {
        HashMap<Long, String> invoiceIdAndSerialno = new HashMap<Long, String>();
        DynamicObjectCollection invoiceEntrys = bill.getDynamicObjectCollection("invoiceentry");
        for (DynamicObject dynamicObject : invoiceEntrys) {
            if (invoiceIdAndSerialno.containsKey(dynamicObject.getPkValue())) continue;
            invoiceIdAndSerialno.put((Long)dynamicObject.getPkValue(), dynamicObject.getString("serialno"));
        }
        Map<Long, List<PropBo>> invoiceItemMap = InvoiceUtils.getChangeInvoiceItemCollCache(bill, invoiceIdAndSerialno, cacheKey);
        return invoiceItemMap;
    }

    public static Map<Long, List<PropBo>> getChangeInvoiceItemCollCache(DynamicObject bill, Map<Long, String> invoiceIdAndSerialno, String cacheKey) {
        Long keyId;
        Map invoiceItemMap = (Map)ThreadCache.get((Object)cacheKey);
        if (invoiceItemMap != null) {
            return invoiceItemMap;
        }
        invoiceItemMap = Maps.newHashMap();
        if (bill.containsProperty("invoiceitementry")) {
            DynamicObjectCollection invoiceItemColl = bill.getDynamicObjectCollection("invoiceitementry");
            for (DynamicObject entry : invoiceItemColl) {
                String invoiceitemserialno;
                keyId = entry.getLong("itementryid");
                if (keyId == 0L) continue;
                List valueIds = (List)invoiceItemMap.get(keyId);
                if (valueIds == null || valueIds.size() == 0) {
                    valueIds = Lists.newArrayList();
                    invoiceItemMap.put(keyId, valueIds);
                }
                PropBo propBo = new PropBo();
                Long invoiceheadentryid = entry.getLong("invoiceheadentryid");
                if (invoiceheadentryid != null && invoiceheadentryid != 0L) {
                    propBo.setInvoiceEntryId(invoiceheadentryid);
                }
                if (!StringUtils.isEmpty((CharSequence)(invoiceitemserialno = entry.getString("invoiceitemserialno")))) {
                    propBo.setSerialNo(invoiceitemserialno);
                } else if (invoiceIdAndSerialno != null && !invoiceIdAndSerialno.isEmpty() && !StringUtils.isEmpty((CharSequence)invoiceIdAndSerialno.get(invoiceheadentryid))) {
                    propBo.setSerialNo(invoiceIdAndSerialno.get(invoiceheadentryid));
                }
                valueIds.add(propBo);
            }
        }
        if (bill.containsProperty("expenseentryentity")) {
            DynamicObjectCollection expenseEntrys = bill.getDynamicObjectCollection("expenseentryentity");
            for (DynamicObject expenseEntry : expenseEntrys) {
                keyId = (Long)expenseEntry.getPkValue();
                if (!Boolean.TRUE.equals(expenseEntry.getBoolean("invoicefromparent")) || StringUtils.isBlank((CharSequence)expenseEntry.getString("splitline")) || !StringUtils.isNumeric((CharSequence)expenseEntry.getString("splitline")) || !invoiceItemMap.containsKey(expenseEntry.getLong("splitline"))) continue;
                invoiceItemMap.put(keyId, invoiceItemMap.get(expenseEntry.getLong("splitline")));
            }
        }
        if (invoiceItemMap.isEmpty()) {
            return invoiceItemMap;
        }
        ThreadCache.put((Object)cacheKey, (Object)invoiceItemMap);
        return invoiceItemMap;
    }

    public static void buildMapinfo(IDataModel model, Set<Long> itemIds, List<PropBo> invoiceItemInfo) {
        for (Long expenseEntryId : itemIds) {
            for (PropBo propBo : invoiceItemInfo) {
                int newRowIndex = model.createNewEntryRow("invoiceandexpense");
                model.setValue("expenseentryid", (Object)expenseEntryId, newRowIndex);
                model.setValue("invoiceentryid", (Object)propBo.getInvoiceEntryId(), newRowIndex);
                if (model.getProperty("invoiceexpserialno") == null) continue;
                model.setValue("invoiceexpserialno", (Object)propBo.getSerialNo(), newRowIndex);
            }
        }
    }

    public static void buildNonAutoInvoice(IDataModel model, Long expenseEntryId, List<PropBo> invoiceItemInfo) {
        int[] indexArr = model.batchCreateNewEntryRow("invoiceandexpense", invoiceItemInfo.size());
        int index = 0;
        for (PropBo propBo : invoiceItemInfo) {
            model.setValue("expenseentryid", (Object)expenseEntryId, indexArr[index]);
            model.setValue("invoiceentryid", (Object)propBo.getInvoiceEntryId(), indexArr[index]);
            if (model.getProperty("invoiceexpserialno") != null) {
                model.setValue("invoiceexpserialno", (Object)propBo.getSerialNo(), indexArr[index]);
            }
            ++index;
        }
    }

    public static String unbindInvoiceAefTicket(DynamicObject dataEntity) {
        String res = "ok";
        ArrayList serialNoArray = Lists.newArrayList();
        DynamicObjectCollection invoiceentry = dataEntity.getDynamicObjectCollection("invoiceentry");
        ArrayList serialNoList = Lists.newArrayList();
        for (Object invoice : invoiceentry) {
            if (StringUtils.isEmpty((CharSequence)invoice.getString("serialno")) || serialNoList.contains(invoice.getString("serialno"))) continue;
            serialNoList.add(invoice.getString("serialno"));
        }
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getPkValue(), (String)dataEntity.getDataEntityType().getName(), (String)"id,billno,costcompany,company,noinvoice,invoiceentry.id,invoiceentry.serialno");
        if (bill != null && bill.getDynamicObjectCollection("invoiceentry") != null && bill.getDynamicObjectCollection("invoiceentry").size() > 0) {
            for (DynamicObject invoiceentryObject : bill.getDynamicObjectCollection("invoiceentry")) {
                if (StringUtils.isEmpty((CharSequence)invoiceentryObject.getString("serialno")) || serialNoList.contains(invoiceentryObject.getString("serialno")) || serialNoArray.contains(invoiceentryObject.getString("serialno"))) continue;
                serialNoArray.add(invoiceentryObject.getString("serialno"));
            }
        }
        Long costCompanyId = 0L;
        DynamicObject costCompany = dataEntity.getDynamicObject("costcompany");
        if (costCompany != null) {
            costCompanyId = (Long)costCompany.getPkValue();
        }
        ArrayList expemseIds = Lists.newArrayList();
        expemseIds.add(dataEntity.getPkValue().toString());
        QFilter idFilter = new QFilter("sourcebillid", "=", dataEntity.getPkValue());
        DynamicObjectCollection voucherDaps = QueryServiceHelper.query((String)"ai_daptracker", (String)"billtype, sourcebillid, voucherid", (QFilter[])new QFilter[]{idFilter});
        if (!serialNoList.isEmpty() && voucherDaps != null && voucherDaps.size() > 0) {
            SaveVoucherRequestParam saveRequestParam = new SaveVoucherRequestParam();
            saveRequestParam.setEntityName(dataEntity.getDataEntityType().getName());
            saveRequestParam.setExpenseIdArray((List)expemseIds);
            saveRequestParam.setSerialNoArray((List)serialNoList);
            saveRequestParam.setInvoiceOrgId(costCompanyId);
            for (DynamicObject voucherDap : voucherDaps) {
                QFilter voucherIdFilter = new QFilter("id", "=", (Object)voucherDap.getLong("voucherid"));
                DynamicObject voucher = QueryServiceHelper.queryOne((String)"gl_voucher", (String)"id, billno, period.number, bizdate, bookeddate", (QFilter[])new QFilter[]{voucherIdFilter});
                if (voucher == null) continue;
                SaveVoucherRequestParam.VoucherInfo voucherInfo = new SaveVoucherRequestParam.VoucherInfo();
                voucherInfo.setVouchId(voucherDap.getString("voucherid"));
                voucherInfo.setVouchNo(voucher.getString("billno"));
                voucherInfo.setBusinessDate(voucher.getDate("bizdate"));
                voucherInfo.setPeriod(voucher.getString("period.number"));
                voucherInfo.setAccountDate(voucher.getDate("bookeddate"));
                saveRequestParam.setVoucherInfo(voucherInfo);
                SaveVoucherResp saveVoucherResp = InvoiceService.getInstanceService().saveVoucherToInvoiceCloud(saveRequestParam, null);
                log.info("----\u8c03\u7528\u751f\u6210\u51ed\u8bc1\u63a5\u53e3\u7ed3\u679c----{}", (Object)(saveVoucherResp != null ? saveVoucherResp.getErrcode() : "null"));
                if (saveVoucherResp == null || "0000".equals(saveVoucherResp.getErrcode())) continue;
                res = saveVoucherResp.getErrcode();
                return res;
            }
        }
        if (!serialNoArray.isEmpty() && voucherDaps != null && voucherDaps.size() > 0) {
            DeleteVoucherRequestParam deleteRequestParam = new DeleteVoucherRequestParam();
            deleteRequestParam.setSerialNoArray((List)serialNoArray);
            deleteRequestParam.setEntityName(dataEntity.getDataEntityType().getName());
            deleteRequestParam.setExpenseIdArray((List)expemseIds);
            deleteRequestParam.setInvoiceOrgId(costCompanyId);
            for (DynamicObject voucher : voucherDaps) {
                deleteRequestParam.setVouchId(voucher.getString("voucherid"));
                DeleteVoucherResp deleteVoucherResp = InvoiceService.getInstanceService().deleteVoucherInInvoiceCloud(deleteRequestParam, null);
                log.info("----\u8c03\u7528\u5220\u9664\u51ed\u8bc1\u63a5\u53e3\u7ed3\u679c----{}", (Object)(deleteVoucherResp != null ? deleteVoucherResp.getErrcode() : "null"));
                if (deleteVoucherResp == null || "0000".equals(deleteVoucherResp.getErrcode())) continue;
                res = deleteVoucherResp.getErrcode();
            }
        }
        return res;
    }

    private static /* synthetic */ boolean lambda$refreshTaxAmountShare$52(String m) {
        return StringUtils.isBlank((CharSequence)m);
    }

    private static /* synthetic */ String lambda$refreshTaxAmountShare$51(DynamicObject item) {
        return item.getString("alltaxrate");
    }

    private static /* synthetic */ boolean lambda$refreshTaxAmountShare$50(List invoiceEntryIds, DynamicObject item) {
        return invoiceEntryIds.contains(item.getPkValue());
    }

    static {
        Set<String> invoiceTypes = InvoiceTypeUtils.loadVatInvoiceTypes();
        VATINVOICE = Collections.unmodifiableSet(invoiceTypes);
        HashSet sets = Sets.newHashSet();
        sets.add(LEFTSIGN);
        sets.add(RIGHTSIGN);
        sets.add("\uff08");
        sets.add("\uff09");
        SIGNS = Collections.unmodifiableSet(sets);
        HashSet leftSigns = Sets.newHashSet();
        leftSigns.add(LEFTSIGN);
        leftSigns.add("\uff08");
        LEFTSIGNS = Collections.unmodifiableSet(leftSigns);
        HashSet rightSigns = Sets.newHashSet();
        rightSigns.add(RIGHTSIGN);
        rightSigns.add("\uff09");
        RIGHTSIGNS = Collections.unmodifiableSet(rightSigns);
        log = LogFactory.getLog(InvoiceUtils.class);
        STRICT_CONTROL = CheckLevel.StrictControl.getValue();
        ONLY_SUGGEST = CheckLevel.OnlySuggest.getValue();
        NO_CONTROL = CheckLevel.NoControl.getValue();
    }
}

