/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.constant.ErTripReimburseBillConstant;

public class TripBillTravelerUtils {
    private static final Log logger = LogFactory.getLog(TripBillTravelerUtils.class);

    public static void getF7FilterInfo(DynamicObject company, DynamicObject dept, BasedataEdit travelerF7) {
        travelerF7.addBeforeF7SelectListener(listener -> {
            if (company != null) {
                boolean travelersrelationtripreq = SystemParamterUtil.getBoolParamResult((Long)ErCommonUtils.getPk(company), (String)"travelersrelationtripreq");
                ListShowParameter list = (ListShowParameter)listener.getFormShowParameter();
                IFormView view = travelerF7.getView();
                if (view.getParentView() != null && !"er_tripreimbill_grid".equals(view.getFormShowParameter().getFormId())) {
                    view = view.getParentView();
                }
                if (travelersrelationtripreq && ErEntityTypeUtils.isTripReimburseBill((String)view.getEntityId())) {
                    HashSet<Long> longSet = new HashSet<Long>();
                    if (view.getModel().getProperty("writeoffapply") != null && !view.getModel().getEntryEntity("writeoffapply").isEmpty()) {
                        DynamicObjectCollection writeoffapply = view.getModel().getEntryEntity("writeoffapply");
                        for (Object item : writeoffapply) {
                            DynamicObjectCollection applytravelers = item.getDynamicObjectCollection("applytravelers");
                            for (DynamicObject apply : applytravelers) {
                                longSet.add(ErCommonUtils.getPk(apply.getDynamicObject("fbasedataid")));
                            }
                        }
                    }
                    if (view.getModel().getProperty("clearloanentry") != null && !view.getModel().getEntryEntity("clearloanentry").isEmpty()) {
                        DynamicObject[] reqBills;
                        DynamicObjectCollection clearloanentry = view.getModel().getEntryEntity("clearloanentry");
                        HashSet<Long> applyIdSet = new HashSet<Long>();
                        for (DynamicObject item : clearloanentry) {
                            if (!"er_tripreqbill".equals(item.getString("srcbilltype"))) continue;
                            applyIdSet.add(item.getLong("loanbillid"));
                        }
                        for (DynamicObject reqBill : reqBills = BusinessDataServiceHelper.load((String)"er_tripreqbill", (String)"tripentry.travelers", (QFilter[])new QFilter[]{new QFilter("id", "in", applyIdSet)})) {
                            DynamicObjectCollection tripentry = reqBill.getDynamicObjectCollection("tripentry");
                            if (null == tripentry) continue;
                            for (DynamicObject entry : tripentry) {
                                DynamicObjectCollection travelers = entry.getDynamicObjectCollection("travelers");
                                if (null == travelers) continue;
                                for (DynamicObject traveler : travelers) {
                                    longSet.add(ErCommonUtils.getPk(traveler.getDynamicObject("fbasedataid")));
                                }
                            }
                        }
                    }
                    longSet.remove(null);
                    if (!longSet.isEmpty()) {
                        list.getListFilterParameter().setQFilters(new ArrayList());
                        list.getListFilterParameter().setFilter(new QFilter("id", "in", longSet));
                    }
                }
                int multravelersrange = SystemParamterUtil.getMulTravelersRange((long)ErCommonUtils.getPk(company));
                Long viewType = 1L;
                switch (multravelersrange) {
                    case 1: {
                        List allOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewType, Collections.singletonList(ErCommonUtils.getPk(company)), (boolean)true);
                        list.getListFilterParameter().setFilter(new QFilter("entryentity.dpt.id", "in", (Object)allOrgList).and(new QFilter("enable", "=", (Object)Boolean.TRUE)));
                        break;
                    }
                    case 2: {
                        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
                        List allOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewType, Collections.singletonList(rootOrgId), (boolean)true);
                        list.getListFilterParameter().setFilter(new QFilter("entryentity.dpt.id", "in", (Object)allOrgList).and(new QFilter("enable", "=", (Object)Boolean.TRUE)));
                        break;
                    }
                    default: {
                        list.getListFilterParameter().setFilter(QFilter.of((String)"entryentity.dpt.id=?", (Object[])new Object[]{dept.get("id")}).and(new QFilter("enable", "=", (Object)Boolean.TRUE)));
                    }
                }
                if (multravelersrange == 0 || multravelersrange == 1) {
                    Long id = ErCommonUtils.getPk(dept);
                    if (multravelersrange == 1) {
                        id = ErCommonUtils.getPk(company);
                    }
                    listener.getFormShowParameter().setCustomParam("initRootOrgId", (Object)id);
                    listener.getFormShowParameter().setCustomParam("initOrgId", (Object)id);
                }
                list.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
                logger.info("\u83b7\u53d6\u5f53\u524d\u5355\u636e\u7684\u591a\u51fa\u5dee\u4eba\u9009\u62e9\u8303\u56f4\u53c2\u6570:" + list.getListFilterParameter().getQFilters().toString());
            }
        });
    }

    public static QFilter getTravelerF7QFilter(DynamicObject company, DynamicObject dept) {
        int multravelersrange = SystemParamterUtil.getMulTravelersRange((long)ErCommonUtils.getPk(company));
        QFilter enableQFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter deptQFilter = null;
        Long viewType = 1L;
        switch (multravelersrange) {
            case 1: {
                List allOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewType, Collections.singletonList(ErCommonUtils.getPk(company)), (boolean)true);
                deptQFilter = new QFilter("entryentity.dpt.id", "in", (Object)allOrgList);
                break;
            }
            case 2: {
                long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
                List allOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)viewType, Collections.singletonList(rootOrgId), (boolean)true);
                deptQFilter = new QFilter("entryentity.dpt.id", "in", (Object)allOrgList);
                break;
            }
            default: {
                deptQFilter = QFilter.of((String)"entryentity.dpt.id=?", (Object[])new Object[]{dept.get("id")});
            }
        }
        return deptQFilter.and(enableQFilter);
    }

    public static void initGetTravelerDefaultValue(IDataModel model) {
        Long[] applierIds = new Long[]{ErCommonUtils.getPk(model.getValue("applier"))};
        DynamicObjectCollection tripEntrys = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
        for (int i = 0; i < tripEntrys.size(); ++i) {
            DynamicObject tripEntry = (DynamicObject)tripEntrys.get(i);
            DynamicObjectCollection travelers = tripEntry.getDynamicObjectCollection("travelers");
            travelers.clear();
            model.setValue("travelers", (Object)applierIds, i);
            if (!ErEntityTypeUtils.isTripReimburseBill((String)model.getDataEntityType().getName())) continue;
            DynamicObjectCollection entrys = tripEntry.getDynamicObjectCollection("entryentity");
            for (int j = 0; j < entrys.size(); ++j) {
                DynamicObject detailEntry = (DynamicObject)entrys.get(j);
                String settleType = detailEntry.getString("settlementtype");
                if (ErTripReimburseBillConstant.SettlementType.MonthlySettlement.getValue().equals(settleType)) continue;
                DynamicObjectCollection entryTravelers = detailEntry.getDynamicObjectCollection("trip2travelers");
                entryTravelers.clear();
                model.setValue("trip2travelers", (Object)applierIds, j, i);
            }
        }
    }

    public static boolean needRecoverTravels(Long oldCompanyId, Long newCompanyId) {
        int multravelersrange = SystemParamterUtil.getMulTravelersRange((long)newCompanyId);
        return 0 == multravelersrange || !oldCompanyId.equals(newCompanyId) && 2 != multravelersrange;
    }

    private static Date getShortDate(Date date) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String format = sdf.format(date);
            Date parse = sdf.parse(format);
            return parse;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return date;
        }
    }

    public static int getPlayDays(List<Date> startdateList, List<Date> enddateList, DynamicObjectCollection tripEntrys) {
        if (startdateList == null || enddateList == null) {
            return 0;
        }
        int result = 0;
        if ("true".equals(ErStdConfig.get((String)"tripreqbill_days_distinct"))) {
            List collect = tripEntrys.stream().filter(it -> it.getDate("startdate") != null && it.getDate("enddate") != null).sorted(Comparator.comparing(o -> o.getDate("startdate"))).collect(Collectors.toList());
            Date endDate = null;
            for (DynamicObject item : collect) {
                Date endate = TripBillTravelerUtils.getShortDate(item.getDate("enddate"));
                Date startDate = TripBillTravelerUtils.getShortDate(item.getDate("startdate"));
                if (endDate == null) {
                    result += (int)((endate.getTime() - startDate.getTime()) / 86400000L) + 1;
                    endDate = endate;
                    continue;
                }
                if (startDate.after(endDate)) {
                    result += (int)((endate.getTime() - startDate.getTime()) / 86400000L) + 1;
                    endDate = endate;
                    continue;
                }
                if (startDate.equals(endDate)) {
                    result += (int)((endate.getTime() - startDate.getTime()) / 86400000L);
                    endDate = endate;
                    continue;
                }
                if (!startDate.before(endDate)) continue;
                result += endDate.compareTo(endate) >= 0 ? 0 : (int)((endate.getTime() - endDate.getTime()) / 86400000L);
                endDate = endDate.compareTo(endate) >= 0 ? endDate : endate;
            }
        } else {
            int rowSize = Math.min(startdateList.size(), enddateList.size());
            int index = 0;
            while (index < rowSize) {
                Date start = startdateList.get(index);
                Date end = enddateList.get(index);
                while (index < rowSize - 1 && startdateList.get(index + 1).compareTo(enddateList.get(index)) == 0) {
                    end = enddateList.get(++index);
                }
                ++index;
                result += (int)((end.getTime() - start.getTime()) / 86400000L) + 1;
            }
        }
        return result;
    }
}

