/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.model.ChangeField;
import kd.fi.er.common.EntityTypeEnum;
import kd.fi.er.common.invoice.utils.InvoiceUtils2;
import kd.fi.er.common.model.invoice.ItemInvoiceRelationEnum;
import kd.fi.er.common.model.invoice.bill.BillExpenseInfoFildKeyType;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class OffsetUtils {
    private static final Log log = LogFactory.getLog(OffsetUtils.class);

    @Deprecated
    public static boolean isInvoiceOffsetForDailyReimBill(DynamicObject dataEntity, int expenseItemRowIndex) {
        Long expenseEntryId = (Long)((DynamicObject)dataEntity.getDynamicObjectCollection("expenseentryentity").get(expenseItemRowIndex)).getPkValue();
        Set<Long> invoiceHeadIds = InvoiceUtils.mapInvoiceSet(dataEntity, expenseEntryId);
        boolean invoiceOffset = dataEntity.getDynamicObjectCollection("invoiceentry").stream().filter(invoiceEntry -> invoiceHeadIds.contains(invoiceEntry.getPkValue())).allMatch(invoiceEntry -> invoiceEntry.getBoolean("offset_invoice"));
        return invoiceOffset;
    }

    public static void setInvoiceOffset(ChangeData[] valueSet, DynamicObject dataEntity, IDataModel model, IFormView view) {
        boolean offsetNewValue = (Boolean)valueSet[0].getNewValue();
        int index = valueSet[0].getRowIndex();
        int parentIndex = valueSet[0].getParentRowIndex();
        Set<Long> invoiceHeadIds = OffsetUtils.gainInvoiceCount(dataEntity, index, parentIndex, model, view);
        boolean invoiceOffset = true;
        if (!invoiceHeadIds.isEmpty()) {
            invoiceOffset = InvoiceOffsetUtils.isInvoiceOffset((IDataModel)model, invoiceHeadIds);
        }
        BigDecimal deductibletax = BigDecimal.ZERO;
        if (offsetNewValue && invoiceOffset) {
            deductibletax = (BigDecimal)model.getValue("taxamount", index, parentIndex);
        }
        model.setValue("deductibletax", (Object)deductibletax, index, parentIndex);
        log.info("\u5dee\u65c5/\u8d39\u7528\u660e\u7ec6\u53ef\u62b5\u6263\u4fee\u6539\u8054\u52a8\u53d1\u7968\u62b5\u6263\uff0coffsetNewValue\uff1a " + offsetNewValue + "\uff0c \u62b5\u6263\u7a0e\u989d deductibletax\uff1a" + model.getValue("deductibletax", index));
    }

    public static void setInvoiceOffset(boolean offSet, DynamicObject dataEntity, int rowIndex, int parentIndex, IDataModel model, IFormView view) {
        boolean invoiceCloudDeductible;
        boolean offsetNewValue = offSet;
        Set<Long> invoiceHeadIds = OffsetUtils.gainInvoiceCount(dataEntity, rowIndex, parentIndex, model, view);
        int invoiceCount = invoiceHeadIds.size();
        boolean invoiceOffset = true;
        if (invoiceCount > 0) {
            invoiceOffset = OffsetUtils.isInvoiceOffsetForBill(dataEntity, rowIndex, parentIndex, model, view);
        }
        if (invoiceCloudDeductible = ErStdConfig.getInvoiceCloudDeductible()) {
            invoiceOffset = offsetNewValue;
        }
        boolean amountToDeductibletax = SystemParamterUtil.isAmountToDeductibletax((Long)((Long)((DynamicObject)model.getValue("company")).getPkValue()));
        BigDecimal deductibletax = BigDecimal.ZERO;
        if (offsetNewValue && invoiceOffset) {
            deductibletax = amountToDeductibletax ? (BigDecimal)model.getValue("approvetax", rowIndex, parentIndex) : (BigDecimal)model.getValue("taxamount", rowIndex, parentIndex);
        }
        model.setValue("deductibletax", (Object)deductibletax, rowIndex, parentIndex);
        if (invoiceCloudDeductible) {
            OffsetUtils.changeInvoiceOffsetForReimBill(dataEntity, rowIndex, parentIndex, offsetNewValue, model, view);
        }
    }

    public static void updateDeductibleTax(IFormView view, int index, int parentIndex, boolean needRecalculate, String changeProp) {
        IDataModel model = view.getModel();
        EntityTypeEnum entityType = ErEntityTypeUtils.getEntityType((IFormView)view);
        String billStatus = (String)model.getValue("billstatus");
        boolean isNeedCalBill = ErEntityTypeUtils.isReimBill((EntityTypeEnum)entityType) || EntityTypeEnum.WITHHOLDINGBILL == entityType;
        BigDecimal difClear = ErStdConfig.taxDifferenceClear();
        if (isNeedCalBill && model.getProperty("offset") != null && model.getProperty("deductibletax") != null) {
            Boolean offset = (Boolean)model.getValue("offset", index, parentIndex);
            BigDecimal deductibletax = BigDecimal.ZERO;
            if (("A".equalsIgnoreCase(billStatus) || "D".equalsIgnoreCase(billStatus)) && "offset".equalsIgnoreCase(changeProp)) {
                if (offset.booleanValue()) {
                    deductibletax = (BigDecimal)model.getValue("taxamount", index, parentIndex);
                }
                model.setValue("deductibletax", (Object)deductibletax, index, parentIndex);
                log.info("updateDeductibleTax deductibletax\uff1a" + deductibletax + "index\uff1a" + index + " ,parentIndex\uff1a" + parentIndex + " ,needRecalculate\uff1a" + needRecalculate + " ,changeProp\uff1a" + changeProp);
                return;
            }
            if (offset.booleanValue()) {
                boolean amountToDeductibletax = SystemParamterUtil.isAmountToDeductibletax((Long)((Long)((DynamicObject)model.getValue("company")).getPkValue()));
                BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", index, parentIndex);
                if (needRecalculate) {
                    if (amountToDeductibletax) {
                        DynamicObject entryCurrency;
                        BigDecimal taxRate;
                        BigDecimal airportConstructFee;
                        BigDecimal approveAmount;
                        if (EntityTypeEnum.TRIPREIMBURSEBILL == entityType) {
                            BigDecimal expenseAmount = (BigDecimal)model.getValue("orientryamount", index, parentIndex);
                            approveAmount = model.getProperty("orientryappamount") != null ? (BigDecimal)model.getValue("orientryappamount", index, parentIndex) : (BigDecimal)model.getValue("orientryamount", index, parentIndex);
                            airportConstructFee = (BigDecimal)model.getValue("airportconstructionfee", index, parentIndex);
                            taxRate = (BigDecimal)model.getValue("taxrate", index, parentIndex);
                            taxRate = taxRate.divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_EVEN);
                            entryCurrency = (DynamicObject)model.getValue("entrycurrency", index, parentIndex);
                        } else {
                            BigDecimal expenseAmount = (BigDecimal)model.getValue("expenseamount", index, parentIndex);
                            approveAmount = model.getProperty("expeapproveamount") != null ? (BigDecimal)model.getValue("expeapproveamount", index, parentIndex) : (BigDecimal)model.getValue("expenseamount", index, parentIndex);
                            airportConstructFee = model.getProperty("airportconstructionfee") != null ? (BigDecimal)model.getValue("airportconstructionfee", index, parentIndex) : BigDecimal.ZERO;
                            taxRate = (BigDecimal)model.getValue("taxrate", index, parentIndex);
                            taxRate = taxRate.divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_EVEN);
                            entryCurrency = (DynamicObject)model.getValue("entrycurrency", index, parentIndex);
                        }
                        if (entryCurrency == null) {
                            log.error("error:TripReimburseBill.DETAIL_ENTRYCURRENCY is null, return.");
                            return;
                        }
                        int precision = entryCurrency.getInt("amtprecision");
                        deductibletax = approveAmount.subtract(airportConstructFee).multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), precision, RoundingMode.HALF_EVEN);
                        if (deductibletax.compareTo(taxAmount) > 0) {
                            deductibletax = taxAmount;
                        } else if (taxAmount.subtract(deductibletax).compareTo(difClear) <= 0) {
                            deductibletax = taxAmount;
                        }
                        model.setValue("deductibletax", (Object)deductibletax, index, parentIndex);
                    } else if (StringUtils.equalsIgnoreCase((String)"offset", (String)changeProp)) {
                        deductibletax = taxAmount;
                        model.setValue("deductibletax", (Object)deductibletax, index, parentIndex);
                    }
                } else {
                    deductibletax = taxAmount;
                    model.setValue("deductibletax", (Object)deductibletax, index, parentIndex);
                }
            } else {
                model.setValue("deductibletax", (Object)BigDecimal.ZERO, index, parentIndex);
            }
            log.info("updateDeductibleTax deductibletax\uff1a" + deductibletax + "index\uff1a" + index + " ,parentIndex\uff1a" + parentIndex + " ,needRecalculate\uff1a" + needRecalculate + " ,changeProp\uff1a" + changeProp);
        }
    }

    @Deprecated
    public static void updateOutAmount(ChangeData value, IDataModel model, IFormView view) {
        DynamicObject dataEntity = model.getDataEntity(true);
        int index = value.getRowIndex();
        int parentIndex = value.getParentRowIndex();
        String transferOutTaxFormula = ErStdConfig.get((String)"transferouttax.formula");
        BigDecimal outAmount = BigDecimal.ZERO;
        if (model.getDataEntity(true).getDynamicObjectType().getProperty("tripentry") != null) {
            DynamicObject item = (DynamicObject)((DynamicObject)dataEntity.getDynamicObjectCollection("tripentry").get(parentIndex)).getDynamicObjectCollection("entryentity").get(index);
            boolean offset = item.getBoolean("offset");
            BigDecimal offsetAmount = item.getBigDecimal("deductibletax");
            BigDecimal taxAmount = item.getBigDecimal("taxamount");
            BigDecimal approveTax = item.getBigDecimal("approvetax");
            log.info("\u660e\u7ec6\u62b5\u6263\u7a0e\u989d\u8054\u52a8\u8f6c\u51fa\u91d1\u989d\uff0c\u62b5\u6263\u91d1\u989d\u5927\u4e8e\u7a0e\u989d\u65f6\u81ea\u52a8\u586b\u5145\u4e3a\u7a0e\u989d\u3002 offsetAmount\uff1a " + offsetAmount + "\uff0c taxAmount:" + taxAmount);
            if (offsetAmount.abs().compareTo(taxAmount) > 0) {
                model.beginInit();
                if (offset) {
                    model.setValue("deductibletax", (Object)taxAmount, index, parentIndex);
                }
                model.endInit();
                log.info("update view deductibletax, index {}\uff0c parentIndex {}", (Object)index, (Object)parentIndex);
                view.updateView("deductibletax", index, parentIndex);
            } else {
                outAmount = StringUtils.equalsIgnoreCase((String)transferOutTaxFormula, (String)"1") ? taxAmount.subtract(offsetAmount) : approveTax.subtract(offsetAmount);
            }
            if (BigDecimal.ZERO.compareTo(outAmount) > 0) {
                outAmount = BigDecimal.ZERO;
            }
        } else if (model.getDataEntity(true).getDynamicObjectType().getProperty("expenseentryentity") != null) {
            DynamicObject item = (DynamicObject)dataEntity.getDynamicObjectCollection("expenseentryentity").get(index);
            boolean offset = item.getBoolean("offset");
            BigDecimal offsetAmount = item.getBigDecimal("deductibletax");
            BigDecimal taxAmount = item.getBigDecimal("taxamount");
            BigDecimal approveTax = item.getBigDecimal("approvetax");
            log.info("\u660e\u7ec6\u62b5\u6263\u7a0e\u989d\u8054\u52a8\u8f6c\u51fa\u91d1\u989d\uff0c\u62b5\u6263\u91d1\u989d\u5927\u4e8e\u7a0e\u989d\u65f6\u81ea\u52a8\u586b\u5145\u4e3a\u7a0e\u989d\u3002 offsetAmount\uff1a " + offsetAmount + "\uff0c taxAmount:" + taxAmount);
            if (offsetAmount.abs().compareTo(taxAmount) > 0) {
                model.beginInit();
                if (offset) {
                    model.setValue("deductibletax", (Object)taxAmount, index);
                }
                model.endInit();
                view.updateView("deductibletax", index);
            } else {
                outAmount = StringUtils.equalsIgnoreCase((String)transferOutTaxFormula, (String)"1") ? taxAmount.subtract(offsetAmount) : approveTax.subtract(offsetAmount);
            }
            if (BigDecimal.ZERO.compareTo(outAmount) > 0) {
                outAmount = BigDecimal.ZERO;
            }
        }
        model.setValue("iteminoutamount", (Object)outAmount, index, parentIndex);
    }

    @Deprecated
    public static void updateOutAmount(IDataModel model, IFormView view, int index, int parentIndex) {
        DynamicObject dataEntity = model.getDataEntity(true);
        String transferOutTaxFormula = ErStdConfig.get((String)"transferouttax.formula");
        BigDecimal outAmount = BigDecimal.ZERO;
        if (model.getDataEntity(true).getDynamicObjectType().getProperty("tripentry") != null) {
            DynamicObject item = (DynamicObject)((DynamicObject)dataEntity.getDynamicObjectCollection("tripentry").get(parentIndex)).getDynamicObjectCollection("entryentity").get(index);
            boolean offset = item.getBoolean("offset");
            BigDecimal offsetAmount = item.getBigDecimal("deductibletax");
            BigDecimal taxAmount = item.getBigDecimal("taxamount");
            BigDecimal approveTax = item.getBigDecimal("approvetax");
            log.info("\u5dee\u65c5\u660e\u7ec6\u53ef\u62b5\u6263\u4fee\u6539\u8054\u52a8\u8054\u52a8\u53d1\u7968\u53ef\u62b5\u6263-\u8054\u52a8\u66f4\u65b0\u8fdb\u9879\u8f6c\u51fa\u91d1\u989d\uff0coffsetAmount: " + offsetAmount + "\uff0c taxAmount: " + taxAmount);
            if (offsetAmount.abs().compareTo(taxAmount) > 0) {
                model.beginInit();
                if (offset) {
                    model.setValue("deductibletax", (Object)taxAmount, index, parentIndex);
                }
                model.endInit();
                log.info("update view deductibletax, index {}\uff0c parentIndex {}", (Object)index, (Object)parentIndex);
                view.updateView("deductibletax", index, parentIndex);
            } else {
                outAmount = StringUtils.equalsIgnoreCase((String)transferOutTaxFormula, (String)"1") ? taxAmount.subtract(offsetAmount) : approveTax.subtract(offsetAmount);
            }
            if (BigDecimal.ZERO.compareTo(outAmount) > 0) {
                outAmount = BigDecimal.ZERO;
            }
        } else if (model.getDataEntity(true).getDynamicObjectType().getProperty("expenseentryentity") != null) {
            DynamicObject item = (DynamicObject)dataEntity.getDynamicObjectCollection("expenseentryentity").get(index);
            boolean offset = item.getBoolean("offset");
            BigDecimal offsetAmount = item.getBigDecimal("deductibletax");
            BigDecimal taxAmount = item.getBigDecimal("taxamount");
            BigDecimal approveTax = item.getBigDecimal("approvetax");
            log.info("\u8d39\u7528\u660e\u7ec6\u53ef\u62b5\u6263\u4fee\u6539\u8054\u52a8\u8054\u52a8\u53d1\u7968\u53ef\u62b5\u6263-\u8054\u52a8\u66f4\u65b0\u8fdb\u9879\u8f6c\u51fa\u91d1\u989d\uff0coffsetAmount: " + offsetAmount + "\uff0c taxAmount: " + taxAmount);
            if (offsetAmount.abs().compareTo(taxAmount) > 0) {
                model.beginInit();
                if (offset) {
                    model.setValue("deductibletax", (Object)taxAmount, index);
                }
                model.endInit();
                view.updateView("deductibletax", index);
            } else {
                outAmount = StringUtils.equalsIgnoreCase((String)transferOutTaxFormula, (String)"1") ? taxAmount.subtract(offsetAmount) : approveTax.subtract(offsetAmount);
            }
            if (BigDecimal.ZERO.compareTo(outAmount) > 0) {
                outAmount = BigDecimal.ZERO;
            }
        }
        model.setValue("iteminoutamount", (Object)outAmount, index, parentIndex);
    }

    @Deprecated
    public static void updateInvoiceOffsetAmount(int expenseItemRowIndex, int parentIndex, boolean offset, BigDecimal deductibleTax, IFormView view) {
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        boolean invoiceCloudDeductible = ErStdConfig.getInvoiceCloudDeductible();
        if (!invoiceCloudDeductible) {
            return;
        }
        Long pkValue = OffsetUtils.gainExpenseEntryId(dataEntity, expenseItemRowIndex, parentIndex, model);
        Set<Long> invoiceHeadIds = OffsetUtils.gainInvoiceCount(dataEntity, expenseItemRowIndex, parentIndex, model, view);
        log.info("pkValue" + pkValue + ": " + invoiceHeadIds);
        if (invoiceHeadIds.size() != 1) {
            log.info(pkValue + " \u660e\u7ec6\u5173\u8054\u7684\u53d1\u7968\u884c != 1   ,\u4e0d\u66f4\u65b0");
            return;
        }
        Long invoiceHeadId = (Long)invoiceHeadIds.stream().findFirst().get();
        Set<Long> itemIds = InvoiceUtils.autoMapItemMappingInfo(dataEntity).get(invoiceHeadId);
        if (itemIds == null) {
            itemIds = InvoiceUtils.nonAutoMapItemMapingInfo(dataEntity).get(invoiceHeadId);
        } else {
            itemIds.remove(0L);
            Set<Long> itemOtherIds = InvoiceUtils.nonAutoMapItemMapingInfo(dataEntity).get(invoiceHeadId);
            if (itemOtherIds != null) {
                itemIds.addAll(itemOtherIds);
            }
        }
        if (itemIds == null || itemIds.size() != 1) {
            log.info("\u660e\u7ec6\u884c<1\u4e0d\u66f4\u65b0");
            return;
        }
        boolean isOne2One = OffsetUtils.itemIsOne2One(view, model, invoiceHeadIds);
        DynamicObjectCollection invoiceEntry = dataEntity.getDynamicObjectCollection("invoiceentry");
        for (int i = 0; i < invoiceEntry.size(); ++i) {
            Long invoiceObjID = (Long)((DynamicObject)invoiceEntry.get(i)).getPkValue();
            if (!invoiceHeadIds.contains(invoiceObjID)) continue;
            model.setValue("islinkagedetail", (Object)isOne2One, i);
            model.setValue("offsetamount", (Object)deductibleTax, i);
            log.info("\u8d39\u7528\u62b5\u6263\u7a0e\u989d\u8054\u52a8\u53d1\u7968\u62b5\u6263\u7a0e\u989d\uff0c\u7b2c " + i + " \u884c deductibleTax\uff1a" + deductibleTax + " invoiceOffsetAmount: " + model.getValue("offsetamount", i));
        }
    }

    public static void updateInvoiceOffsetBeforeOpe(IFormView view, IDataModel model) {
        boolean invoiceCloudDeductible = ErStdConfig.getInvoiceCloudDeductible();
        if (!invoiceCloudDeductible) {
            return;
        }
        DynamicObject dataEntity = model.getDataEntity(true);
        DataEntityPropertyCollection propertyColl = dataEntity.getDynamicObjectType().getProperties();
        Map<Long, Boolean> expenseItemOffsetMap = OffsetUtils.tripOrDailyExpenseItemOffset(dataEntity, propertyColl);
        Map<Long, Set<Long>> expenseItemInvoiceMap = OffsetUtils.expenseItemMapInvoice(dataEntity, propertyColl);
        Map<Long, Integer> invocieIndexMap = OffsetUtils.invoiceIdAndIndex(dataEntity, propertyColl);
        OffsetUtils.updateInvoiceEntry(view, model, expenseItemOffsetMap, expenseItemInvoiceMap, invocieIndexMap);
    }

    public static void updateInvoiceEntry(IFormView view, IDataModel model, Map<Long, Boolean> expenseItemOffsetMap, Map<Long, Set<Long>> expenseItemInvoiceMap, Map<Long, Integer> invocieIndexMap) {
        for (Map.Entry<Long, Set<Long>> entry : expenseItemInvoiceMap.entrySet()) {
            Long itemId = entry.getKey();
            Set<Long> invoiceSet = entry.getValue();
            boolean isOne2One = OffsetUtils.itemIsOne2One(view, model, invoiceSet);
            Boolean itemOffset = expenseItemOffsetMap.get(itemId);
            if (itemOffset == null) continue;
            for (Long invoiceId : invoiceSet) {
                Integer invoiceIndex = invocieIndexMap.get(invoiceId);
                if (invoiceIndex == null || !isOne2One) continue;
                model.setValue("islinkagedetail", (Object)isOne2One, invoiceIndex.intValue());
                model.setValue("offset_invoice", (Object)itemOffset, invoiceIndex.intValue());
            }
        }
    }

    public static Map<Long, Integer> invoiceIdAndIndex(DynamicObject dataEntity, DataEntityPropertyCollection propertyColl) {
        HashMap itemIdOfinvoiceId = Maps.newHashMap();
        if (propertyColl.get((Object)"invoiceentry") != null) {
            DynamicObjectCollection invoiceEntry = dataEntity.getDynamicObjectCollection("invoiceentry");
            for (int index = 0; index < invoiceEntry.size(); ++index) {
                DynamicObject invoiceItem = (DynamicObject)invoiceEntry.get(index);
                itemIdOfinvoiceId.put((Long)invoiceItem.getPkValue(), index);
            }
        }
        return itemIdOfinvoiceId;
    }

    public static Map<Long, Set<Long>> expenseItemMapInvoice(DynamicObject dataEntity, DataEntityPropertyCollection propertyColl) {
        HashMap itemIdOfinvoiceId = Maps.newHashMap();
        if (propertyColl.get((Object)"invoiceitementry") != null) {
            DynamicObjectCollection invoiceItemEntry = dataEntity.getDynamicObjectCollection("invoiceitementry");
            invoiceItemEntry.stream().forEach(item -> {
                Long itemId = item.getLong("itementryid");
                Long invoiceId = item.getLong("invoiceheadentryid");
                Set invocieIdSet = (Set)itemIdOfinvoiceId.get(itemId);
                if (invocieIdSet == null) {
                    invocieIdSet = Sets.newHashSet();
                    itemIdOfinvoiceId.put(itemId, invocieIdSet);
                }
                invocieIdSet.add(invoiceId);
            });
        }
        return itemIdOfinvoiceId;
    }

    public static Map<Long, Boolean> tripOrDailyExpenseItemOffset(DynamicObject dataEntity, DataEntityPropertyCollection propertyColl) {
        HashMap entryIDOfOffsetMap = Maps.newHashMap();
        if (propertyColl.get((Object)"tripentry") != null) {
            DynamicObjectCollection tripEntryColl = dataEntity.getDynamicObjectCollection("tripentry");
            for (DynamicObject tripEntry : tripEntryColl) {
                DynamicObjectCollection entryEntityColl = tripEntry.getDynamicObjectCollection("entryentity");
                entryEntityColl.stream().forEach(item -> entryIDOfOffsetMap.put((Long)item.getPkValue(), item.getBoolean("offset")));
            }
        } else if (propertyColl.get((Object)"expenseentryentity") != null) {
            DynamicObjectCollection expenseEntryColl = dataEntity.getDynamicObjectCollection("expenseentryentity");
            expenseEntryColl.stream().forEach(item -> entryIDOfOffsetMap.put((Long)item.getPkValue(), item.getBoolean("offset")));
        }
        return entryIDOfOffsetMap;
    }

    @Deprecated
    public static void updateInvoiceEntry(ChangeData[] valueSet, int rowIndex, IDataModel model) {
    }

    public static boolean isInvoiceOffsetForBill(DynamicObject dataEntity, int expenseItemRowIndex, int parentIndex, IDataModel model, IFormView view) {
        Set<Long> invoiceHeadIds = OffsetUtils.gainInvoiceCount(dataEntity, expenseItemRowIndex, parentIndex, model, view);
        boolean invoiceOffset = dataEntity.getDynamicObjectCollection("invoiceentry").stream().filter(invoiceEntry -> invoiceHeadIds.contains(invoiceEntry.getPkValue())).anyMatch(invoiceEntry -> invoiceEntry.getBoolean("offset_invoice"));
        return invoiceOffset;
    }

    public static void changeInvoiceOffsetForReimBill(DynamicObject dataEntity, int expenseItemRowIndex, int parentIndex, boolean offset, IDataModel model, IFormView view) {
        Set<Long> invoiceHeadIds = OffsetUtils.gainInvoiceCount(dataEntity, expenseItemRowIndex, parentIndex, model, view);
        if (invoiceHeadIds.size() < 1) {
            log.info("\u5f53\u524d\u8d39\u7528\u660e\u7ec6\u5173\u8054\u53d1\u7968\u884c<1\u4e0d\u66f4\u65b0");
            return;
        }
        String entityId = view.getModel().getDataEntityType().getName();
        BillExpenseInfoFildKeyType type = ErEntityTypeUtils.getBillType((String)entityId);
        boolean isOne2One = OffsetUtils.itemIsOne2One(view, model, invoiceHeadIds);
        boolean isN2One = false;
        boolean isOne2N = false;
        if (!isOne2One && !(isN2One = OffsetUtils.itemIsN2One(view, model, invoiceHeadIds))) {
            isOne2N = OffsetUtils.itemIsOne2N(view, model, invoiceHeadIds);
        }
        int invoiceDownCount = model.getEntryRowCount("invoiceentry");
        for (int i = 0; i < invoiceDownCount; ++i) {
            boolean existItemOffset;
            BigDecimal offsetAmount;
            Long invoiceObjID = (Long)((DynamicObject)((DynamicObjectCollection)model.getValue("invoiceentry")).get(i)).getPkValue();
            if (!invoiceHeadIds.contains(invoiceObjID)) continue;
            boolean invoiceOffset = OffsetUtils.isInvoiceOffset(dataEntity, invoiceObjID);
            model.setValue("islinkagedetail", (Object)isOne2One, i);
            if (isOne2One || isN2One) {
                Long invoiceHeadId = (Long)invoiceHeadIds.stream().findFirst().get();
                Set<Long> itemIds = InvoiceUtils.getInvoiceMappingItemRelation(view, model).get(invoiceHeadId);
                Map<String, Object> valueMap = OffsetUtils.getExpenseItemsOffsetInfoMap(model, itemIds, type);
                if (MapUtils.isEmpty(valueMap)) continue;
                model.setValue("offset_invoice", valueMap.get("offset"), i);
                model.setValue("offsetamount", valueMap.get("deductibletax"), i);
                model.setValue("inoutamount", valueMap.get("iteminoutamount"), i);
                continue;
            }
            if (isOne2N) {
                boolean offsetValue = offset && invoiceOffset;
                offsetAmount = offsetValue ? OffsetUtils.invoiceOffsetAmount(dataEntity, invoiceObjID) : BigDecimal.ZERO;
                model.setValue("offset_invoice", (Object)offsetValue, i);
                model.setValue("offsetamount", (Object)offsetAmount, i);
                continue;
            }
            boolean offsetValue = offset ? offset && invoiceOffset : (existItemOffset = OffsetUtils.isExistItemOffset(dataEntity, OffsetUtils.getInvoiceItems(model, invoiceObjID), model, view)) && invoiceOffset;
            offsetAmount = offsetValue ? OffsetUtils.invoiceOffsetAmount(dataEntity, invoiceObjID) : BigDecimal.ZERO;
            model.setValue("offset_invoice", (Object)offsetValue, i);
            model.setValue("offsetamount", (Object)offsetAmount, i);
        }
    }

    private static boolean isInvoiceOffset(DynamicObject bill, Long invoiceHeadId) {
        return InvoiceOffsetUtils.getInvoiceOffset(bill.getDynamicObjectCollection("invoiceitementry").stream().filter(v -> Objects.equals(invoiceHeadId, v.getLong("invoiceheadentryid"))));
    }

    public static boolean isExistItemOffset(DynamicObject bill, Set<Long> itemIds, IDataModel model, IFormView view) {
        Stream<DynamicObject> stream;
        DynamicProperty tripEntries = bill.getDynamicObjectType().getProperty("tripentry");
        if (tripEntries != null) {
            int curTrip = model.getEntryCurrentRowIndex("tripentry");
            DynamicObject tripEntry = (DynamicObject)bill.getDynamicObjectCollection("tripentry").get(curTrip);
            stream = tripEntry.getDynamicObjectCollection("entryentity").stream().filter(v -> itemIds.contains(v.getPkValue()));
        } else {
            stream = bill.getDynamicObjectCollection("expenseentryentity").stream().filter(v -> itemIds.contains(v.getPkValue()));
        }
        return stream.anyMatch(v -> v.getBoolean("offset"));
    }

    public static boolean isExistItemOffset(IDataModel dataModel, Set<Long> itemIds, IDataModel model, IFormView view) {
        Stream<DynamicObject> stream;
        DynamicProperty tripEntries = dataModel.getDataEntity().getDynamicObjectType().getProperty("tripentry");
        if (tripEntries != null) {
            int curTrip = model.getEntryCurrentRowIndex("tripentry");
            DynamicObject tripEntry = (DynamicObject)dataModel.getEntryEntity("tripentry").get(curTrip);
            stream = tripEntry.getDynamicObjectCollection("entryentity").stream().filter(v -> itemIds.contains(v.getPkValue()));
        } else {
            stream = dataModel.getEntryEntity("expenseentryentity").stream().filter(v -> itemIds.contains(v.getPkValue()));
        }
        return stream.anyMatch(v -> v.getBoolean("offset"));
    }

    public static Set<Long> gainInvoiceCount(DynamicObject dataEntity, int expenseItemRowIndex, int parentIndex, IDataModel model, IFormView view) {
        Set ids;
        IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        IDataModel pModel = null;
        if (parentView != null) {
            pModel = parentView.getModel();
        }
        HashSet<Long> expenseIdSet = new HashSet<Long>();
        Long expenseEntryId = OffsetUtils.gainExpenseEntryId(dataEntity, expenseItemRowIndex, parentIndex, model);
        Boolean autoInvoice = true;
        if (model.getProperty("automapinvoice") != null) {
            autoInvoice = (Boolean)model.getValue("automapinvoice");
        } else if (pModel != null && pModel.getProperty("automapinvoice") != null) {
            autoInvoice = (Boolean)pModel.getValue("automapinvoice");
        }
        String parentId = (String)model.getValue("splitline", expenseItemRowIndex, parentIndex);
        expenseIdSet.add(expenseEntryId);
        if (StringUtils.isNotEmpty((String)parentId)) {
            expenseIdSet.add(Long.parseLong(parentId));
        }
        HashSet<Long> invoiceHeadIds = new HashSet();
        if (autoInvoice.booleanValue()) {
            Map autoMapInvoiceMappingInfo = (Map)ThreadCache.get((Object)"autoMapInvoiceMappingInfo");
            if (autoMapInvoiceMappingInfo != null && !autoMapInvoiceMappingInfo.isEmpty()) {
                for (Long l : expenseIdSet) {
                    ids = (Set)autoMapInvoiceMappingInfo.get(l);
                    if (!CollectionUtils.isNotEmpty((Collection)ids)) continue;
                    invoiceHeadIds.addAll(ids);
                }
            } else {
                invoiceHeadIds = model.getEntryEntity("invoiceitementry").stream().filter(invoiceItemEntry -> expenseIdSet.contains(invoiceItemEntry.getLong("itementryid"))).map(invoiceItemEntry -> invoiceItemEntry.getLong("invoiceheadentryid")).collect(Collectors.toSet());
            }
        } else {
            Map nonAutoMapInvoiceMappingInfo = (Map)ThreadCache.get((Object)"nonAutoMapInvoiceMappingInfo");
            if (nonAutoMapInvoiceMappingInfo != null && !nonAutoMapInvoiceMappingInfo.isEmpty()) {
                for (Long l : expenseIdSet) {
                    ids = (Set)nonAutoMapInvoiceMappingInfo.get(l);
                    if (!CollectionUtils.isNotEmpty((Collection)ids)) continue;
                    invoiceHeadIds.addAll(ids);
                }
            } else {
                Set<Long> invoiceHeadIdsForInvoiceAndExpense = OffsetUtils.gainInvoiceCountForInvoiceandExpense(dataEntity, expenseItemRowIndex, parentIndex, model);
                for (Long invoiceHeadId : invoiceHeadIdsForInvoiceAndExpense) {
                    invoiceHeadIds.add(invoiceHeadId);
                }
            }
        }
        if (pModel != null) {
            IDataEntityProperty tripEntry = pModel.getProperty("tripentry");
            IDataEntityProperty invoiceEntryProp = pModel.getProperty("invoiceitementry");
            if (invoiceEntryProp != null) {
                Integer n;
                Integer n2 = n = tripEntry != null ? Integer.valueOf(expenseItemRowIndex) : (Integer)view.getFormShowParameter().getCustomParam("index");
                if (n != null) {
                    if (autoInvoice.booleanValue()) {
                        Set pInvoiceHeadIds = pModel.getDataEntity(true).getDynamicObjectCollection("invoiceitementry").stream().filter(invoiceItemEntry -> expenseIdSet.contains(invoiceItemEntry.getLong("itementryid"))).map(invoiceItemEntry -> invoiceItemEntry.getLong("invoiceheadentryid")).collect(Collectors.toSet());
                        if (pInvoiceHeadIds != null && !pInvoiceHeadIds.isEmpty()) {
                            invoiceHeadIds.addAll(pInvoiceHeadIds);
                        }
                    } else {
                        Set<Long> pInvoiceHeadIdsForInvoiceAndExpense = OffsetUtils.gainInvoiceCountForInvoiceandExpense(pModel.getDataEntity(true), n, parentIndex, pModel);
                        if (pInvoiceHeadIdsForInvoiceAndExpense != null && !pInvoiceHeadIdsForInvoiceAndExpense.isEmpty()) {
                            invoiceHeadIds.addAll(pInvoiceHeadIdsForInvoiceAndExpense);
                        }
                    }
                }
            }
        }
        return invoiceHeadIds;
    }

    public static Set<Long> gainInvoiceCountForInvoiceandExpense(DynamicObject dataEntity, int expenseItemRowIndex, int parentIndex, IDataModel model) {
        Long expenseEntryId = OffsetUtils.gainExpenseEntryId(dataEntity, expenseItemRowIndex, parentIndex, model);
        if (expenseEntryId == null) {
            return Collections.emptySet();
        }
        return model.getEntryEntity("invoiceandexpense").stream().filter(invoiceItemEntry -> Objects.equals(expenseEntryId, invoiceItemEntry.getLong("expenseentryid"))).map(invoiceItemEntry -> invoiceItemEntry.getLong("invoiceentryid")).collect(Collectors.toSet());
    }

    public static BigDecimal invoiceOffsetAmount(DynamicObject dataEntity, Long invoiceHeadId) {
        return InvoiceOffsetUtils.getOffsetInvoiceItem(dataEntity.getDynamicObjectCollection("invoiceitementry").stream().filter(invoiceItemEntry -> Objects.equals(invoiceHeadId, invoiceItemEntry.getLong("invoiceheadentryid")))).map(invoiceItemEntry -> invoiceItemEntry.getBigDecimal("invoiceitemtaxamout")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public static BigDecimal invoiceOffsetAmount(IDataModel dataModel, Long invoiceHeadId) {
        return InvoiceOffsetUtils.getOffsetInvoiceItem(dataModel.getEntryEntity("invoiceitementry").stream().filter(invoiceItemEntry -> Objects.equals(invoiceHeadId, invoiceItemEntry.getLong("invoiceheadentryid")))).map(invoiceItemEntry -> invoiceItemEntry.getBigDecimal("invoiceitemtaxamout")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public static BigDecimal invoiceTaxAmount(IDataModel dataModel, Long invoiceHeadId) {
        return dataModel.getEntryEntity("invoiceitementry").stream().filter(invoiceItemEntry -> Objects.equals(invoiceHeadId, invoiceItemEntry.getLong("invoiceheadentryid"))).map(invoiceItemEntry -> invoiceItemEntry.getBigDecimal("invoiceitemtaxamout")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public static Map<String, Object> getExpenseItemsOffsetInfoMap(IDataModel model, Set<Long> expenseItemIds, BillExpenseInfoFildKeyType type) {
        if (expenseItemIds == null || expenseItemIds.isEmpty()) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> offsetMap = new HashMap<String, Object>();
        boolean offset = false;
        BigDecimal deductibleTax = BigDecimal.ZERO;
        BigDecimal itemInOutAmount = BigDecimal.ZERO;
        if (type == BillExpenseInfoFildKeyType.TripReimburse) {
            DynamicObjectCollection tripEntry = model.getEntryEntity("tripentry");
            for (int tripIndex = 0; tripIndex < tripEntry.size(); ++tripIndex) {
                DynamicObjectCollection entryEntity = ((DynamicObject)tripEntry.get(tripIndex)).getDynamicObjectCollection("entryentity");
                for (int expenseIndex = 0; expenseIndex < entryEntity.size(); ++expenseIndex) {
                    Long parentId;
                    DynamicObject expenseItem = (DynamicObject)entryEntity.get(expenseIndex);
                    Long pkValue = (Long)expenseItem.getPkValue();
                    String splitline = expenseItem.getString("splitline");
                    Long l = parentId = StringUtils.isEmpty((String)splitline) ? null : Long.valueOf(Long.parseLong(splitline));
                    if (!expenseItemIds.contains(pkValue) && !expenseItemIds.contains(parentId)) continue;
                    offset = expenseItem.getBoolean("offset") || offset;
                    deductibleTax = deductibleTax.add(expenseItem.getBigDecimal("deductibletax"));
                    itemInOutAmount = itemInOutAmount.add(expenseItem.getBigDecimal("iteminoutamount"));
                }
            }
        } else {
            DynamicObjectCollection entryEntity = model.getEntryEntity("expenseentryentity");
            for (int expenseIndex = 0; expenseIndex < entryEntity.size(); ++expenseIndex) {
                Long parentId;
                DynamicObject expenseItem = (DynamicObject)entryEntity.get(expenseIndex);
                Long pkValue = (Long)expenseItem.getPkValue();
                String splitline = expenseItem.getString("splitline");
                Long l = parentId = StringUtils.isEmpty((String)splitline) ? null : Long.valueOf(Long.parseLong(splitline));
                if (!expenseItemIds.contains(pkValue) && !expenseItemIds.contains(parentId)) continue;
                offset = expenseItem.getBoolean("offset") || offset;
                deductibleTax = deductibleTax.add(expenseItem.getBigDecimal("deductibletax"));
                itemInOutAmount = itemInOutAmount.add(expenseItem.getBigDecimal("iteminoutamount"));
            }
        }
        offsetMap.put("offset", offset);
        offsetMap.put("deductibletax", deductibleTax);
        offsetMap.put("iteminoutamount", itemInOutAmount);
        return offsetMap;
    }

    public static Long gainExpenseEntryId(DynamicObject dataEntity, int expenseItemRowIndex, int parentIndex, IDataModel model) {
        boolean isTrip;
        boolean bl = isTrip = model.getDataEntity(true).getDynamicObjectType().getProperty("tripentry") != null;
        if (isTrip) {
            DynamicObjectCollection tripEntries = dataEntity.getDynamicObjectCollection("tripentry");
            if (CollectionUtils.isEmpty((Collection)tripEntries)) {
                return null;
            }
            DynamicObject tripEntry = (DynamicObject)tripEntries.get(parentIndex);
            DynamicObjectCollection entryEntity = tripEntry.getDynamicObjectCollection("entryentity");
            if (entryEntity == null || entryEntity.isEmpty()) {
                return null;
            }
            Long expenseEntryId = null;
            if (entryEntity.size() > expenseItemRowIndex) {
                expenseEntryId = (Long)((DynamicObject)entryEntity.get(expenseItemRowIndex)).getPkValue();
            }
            return expenseEntryId;
        }
        Long expenseEntryId = (Long)((DynamicObject)dataEntity.getDynamicObjectCollection("expenseentryentity").get(expenseItemRowIndex)).getPkValue();
        return expenseEntryId;
    }

    @Deprecated
    public static void updateInvoiceOutAmount(int expenseItemRowIndex, int parentIndex, BigDecimal inoutAmount, IFormView view) {
        String entityId;
        BillExpenseInfoFildKeyType type;
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        boolean invoiceCloudDeductible = ErStdConfig.getInvoiceCloudDeductible();
        if (!invoiceCloudDeductible) {
            return;
        }
        boolean deductibleOfTaxPayer = InvoiceOffsetUtils.deductibleOfTaxPayer((IDataModel)view.getModel());
        Set<Long> invoiceHeadIds = OffsetUtils.gainInvoiceCount(dataEntity, expenseItemRowIndex, parentIndex, model, view);
        if (invoiceHeadIds.size() < 1) {
            log.info("\u5f53\u524d\u8d39\u7528\u660e\u7ec6\u672a\u5173\u8054\u53d1\u7968");
            return;
        }
        Long invoiceHeadId = (Long)invoiceHeadIds.stream().findFirst().get();
        Set<Long> itemIds = InvoiceUtils.getInvoiceMappingItemRelation(view, model).get(invoiceHeadId);
        if (itemIds == null || itemIds.size() < 1) {
            log.info("\u53d1\u7968\u672a\u5173\u8054\u660e\u7ec6");
            return;
        }
        boolean isOne2One = OffsetUtils.itemIsOne2One(view, model, invoiceHeadIds);
        boolean isN2One = false;
        if (!isOne2One) {
            isN2One = OffsetUtils.itemIsN2One(view, model, invoiceHeadIds);
        }
        if ((type = ErEntityTypeUtils.getBillType((String)(entityId = view.getModel().getDataEntityType().getName()))) == null) {
            log.info(entityId + "\u672a\u5339\u914d\u5230\u5408\u9002\u7684\u7c7b\u578b,\u4e0d\u8054\u52a8\u53d1\u7968\u4fe1\u606f\u5206\u5f55.");
            return;
        }
        DynamicObjectCollection invoiceEntry = dataEntity.getDynamicObjectCollection("invoiceentry");
        boolean isexportLog = ErStdConfig.isExportLog();
        for (int i = 0; i < invoiceEntry.size(); ++i) {
            Long invoiceObjID = (Long)((DynamicObject)invoiceEntry.get(i)).getPkValue();
            if (!invoiceHeadIds.contains(invoiceObjID)) continue;
            if (isOne2One || isN2One) {
                if (deductibleOfTaxPayer) {
                    Map<String, Object> valueMap = OffsetUtils.getExpenseItemsOffsetInfoMap(model, itemIds, type);
                    if (MapUtils.isEmpty(valueMap)) continue;
                    log.info("1 for 1 updateInvoiceOutAmount deductibleOfTaxPayer true " + valueMap.get("iteminoutamount"));
                    model.setValue("inoutamount", valueMap.get("iteminoutamount"), i);
                } else {
                    log.info("1 for 1 updateInvoiceOutAmount deductibleOfTaxPayer false 0");
                    model.setValue("inoutamount", (Object)BigDecimal.ZERO, i);
                }
            } else {
                BigDecimal taxAmount = ((DynamicObject)invoiceEntry.get(i)).getBigDecimal("taxamount_invoice");
                BigDecimal offsetAmount = ((DynamicObject)invoiceEntry.get(i)).getBigDecimal("offsetamount");
                BigDecimal outAmount = BigDecimal.ZERO;
                if (offsetAmount.compareTo(taxAmount) < 0) {
                    outAmount = taxAmount.subtract(offsetAmount);
                }
                if (deductibleOfTaxPayer) {
                    if (isexportLog) {
                        log.info("updateInvoiceOutAmount deductibleOfTaxPayer true " + inoutAmount);
                    }
                    model.setValue("inoutamount", (Object)outAmount, i);
                } else {
                    if (isexportLog) {
                        log.info("updateInvoiceOutAmount deductibleOfTaxPayer false 0");
                    }
                    model.setValue("inoutamount", (Object)BigDecimal.ZERO, i);
                }
            }
            model.setValue("islinkagedetail", (Object)isOne2One, i);
        }
    }

    public static void updateInvoiceOutReason(int expenseItemRowIndex, int parentIndex, String reasonfortransferout, IFormView view) {
        OffsetUtils.updateInvoice(expenseItemRowIndex, parentIndex, reasonfortransferout, view, "reasonfortransferout");
    }

    public static void updateInvoiceNoDeductionReason(int expenseItemRowIndex, int parentIndex, String itemNoDeductionReason, IFormView view) {
        OffsetUtils.updateInvoice(expenseItemRowIndex, parentIndex, itemNoDeductionReason, view, "nodeductionreason");
    }

    private static void updateInvoice(int expenseItemRowIndex, int parentIndex, String reasonfortransferout, IFormView view, String fieldName) {
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        boolean invoiceCloudDeductible = ErStdConfig.getInvoiceCloudDeductible();
        if (!invoiceCloudDeductible) {
            return;
        }
        Set<Long> invoiceHeadIds = OffsetUtils.gainInvoiceCount(dataEntity, expenseItemRowIndex, parentIndex, model, view);
        if (invoiceHeadIds.size() > 1) {
            return;
        }
        boolean isOne2One = OffsetUtils.itemIsOne2One(view, model, invoiceHeadIds);
        DynamicObjectCollection invoiceEntry = dataEntity.getDynamicObjectCollection("invoiceentry");
        for (int i = 0; i < invoiceEntry.size(); ++i) {
            Long invoiceObjID = (Long)((DynamicObject)invoiceEntry.get(i)).getPkValue();
            if (!invoiceHeadIds.contains(invoiceObjID)) continue;
            model.setValue("islinkagedetail", (Object)isOne2One, i);
            model.setValue(fieldName, (Object)reasonfortransferout, i);
        }
    }

    @Deprecated
    public static void setHeadSumOffsetAmount(IDataModel model) {
        if (model.getProperty("invoiceoffsetamount") != null) {
            BigDecimal invoiceOffsetAmount = model.getDataEntity(true).getDynamicObjectCollection("invoiceentry").stream().map(v -> v.getBigDecimal("offsetamount")).reduce((a1, a2) -> a1.add((BigDecimal)a2)).orElse(BigDecimal.ZERO);
            model.setValue("invoiceOffsetAmount", (Object)invoiceOffsetAmount);
        }
    }

    public static void setWithholdingOffset(IDataModel model, ChangeData[] valueSet) {
        int rowIndex = valueSet[0].getRowIndex();
        boolean offset = (Boolean)valueSet[0].getNewValue();
        if (offset) {
            model.setValue("deductibletax", model.getValue("taxamount", rowIndex), rowIndex);
        } else {
            model.setValue("deductibletax", (Object)BigDecimal.ZERO, rowIndex);
        }
    }

    public static boolean itemIsOne2One(IFormView view, IDataModel model, Set<Long> invoiceHeadIds) {
        boolean isOne2One = false;
        if (invoiceHeadIds.size() == 1) {
            Map mapItemMapping;
            Set itemIds;
            Long invoiceEntryId = (Long)invoiceHeadIds.stream().findFirst().get();
            Boolean autoInvoice = false;
            if (model.getProperty("automapinvoice") != null) {
                autoInvoice = (Boolean)model.getValue("automapinvoice");
            }
            if ((itemIds = (Set)(mapItemMapping = autoInvoice != false && view != null ? InvoiceUtils2.autoMapItemMappingInfoCache((IFormView)view, (IDataModel)model, (String)"autoMapItemMappingInfo") : InvoiceUtils2.nonAutoMapItemMappingInfoCache((IFormView)view, (IDataModel)model, (String)"nonAutoMapItemMappingInfo")).get(invoiceEntryId)) != null && itemIds.size() == 1) {
                isOne2One = true;
            }
        }
        return isOne2One;
    }

    public static boolean itemIsN2One(IFormView view, IDataModel model, Set<Long> invoiceHeadIds) {
        Map mapItemMapping;
        Set itemIds;
        DynamicObject dataEntity = model.getDataEntity(true);
        if (invoiceHeadIds.size() != 1) {
            return false;
        }
        Long invoiceEntryId = (Long)invoiceHeadIds.stream().findFirst().get();
        Boolean autoInvoice = false;
        if (model.getProperty("automapinvoice") != null) {
            autoInvoice = (Boolean)model.getValue("automapinvoice");
        }
        if ((itemIds = (Set)(mapItemMapping = autoInvoice != false && view != null ? InvoiceUtils2.autoMapItemMappingInfoCache((IFormView)view, (IDataModel)model, (String)"autoMapItemMappingInfo") : InvoiceUtils2.nonAutoMapItemMappingInfoCache((IFormView)view, (IDataModel)model, (String)"nonAutoMapItemMappingInfo")).get(invoiceEntryId)) != null && itemIds.size() <= 1) {
            return false;
        }
        Set<Long> invoiceIds = InvoiceUtils.getInvoiceIdsOfItems(dataEntity, (Set<Long>)itemIds);
        return invoiceIds.size() == 1 && invoiceIds.contains(invoiceEntryId);
    }

    public static boolean itemIsOne2N(IFormView view, IDataModel model, Set<Long> invoiceHeadIds) {
        if (invoiceHeadIds.size() <= 1) {
            return false;
        }
        HashSet itemIds = new HashSet();
        Boolean autoInvoice = false;
        if (model.getProperty("automapinvoice") != null) {
            autoInvoice = (Boolean)model.getValue("automapinvoice");
        }
        for (Long invoiceEntryId : invoiceHeadIds) {
            if (autoInvoice.booleanValue() && view != null) {
                Set auto = (Set)InvoiceUtils2.autoMapItemMappingInfoCache((IFormView)view, (IDataModel)model, (String)"autoMapItemMappingInfo").get(invoiceEntryId);
                if (auto == null) continue;
                itemIds.addAll(auto);
                continue;
            }
            Set nonAuto = (Set)InvoiceUtils2.nonAutoMapItemMappingInfoCache((IFormView)view, (IDataModel)model, (String)"nonAutoMapItemMappingInfo").get(invoiceEntryId);
            if (nonAuto == null) continue;
            itemIds.addAll(nonAuto);
        }
        itemIds.remove(0L);
        itemIds.remove(null);
        return itemIds.size() == 1;
    }

    public static ItemInvoiceRelationEnum getItemInvoiceRelation(IFormView view, IDataModel model, Set<Long> invoiceHeadIds) {
        if (OffsetUtils.itemIsOne2One(view, model, invoiceHeadIds)) {
            return ItemInvoiceRelationEnum.IsOneForOne;
        }
        if (OffsetUtils.itemIsOne2N(view, model, invoiceHeadIds)) {
            return ItemInvoiceRelationEnum.IsOneForN;
        }
        if (OffsetUtils.itemIsN2One(view, model, invoiceHeadIds)) {
            return ItemInvoiceRelationEnum.IsNForOne;
        }
        return ItemInvoiceRelationEnum.IsNForN;
    }

    public static Set<Long> getInvoiceItems(IDataModel model, Long invoiceEntryId) {
        DynamicObject dataEntity = model.getDataEntity(true);
        Set<Long> itemIds = InvoiceUtils.autoMapItemMappingInfo(dataEntity).get(invoiceEntryId);
        if (itemIds == null) {
            itemIds = InvoiceUtils.nonAutoMapItemMapingInfo(dataEntity).get(invoiceEntryId);
        } else {
            itemIds.remove(0L);
            Set<Long> itemOtherIds = InvoiceUtils.nonAutoMapItemMapingInfo(dataEntity).get(invoiceEntryId);
            if (itemOtherIds != null) {
                itemIds.addAll(itemOtherIds);
            }
        }
        return itemIds;
    }

    @Deprecated
    public static void calculateOffset(int rowIndex, boolean needRecalculate, IDataModel dataModel, IFormView view) {
        boolean notAllowEdit;
        BigDecimal taxAmount;
        BigDecimal expenseAmount = (BigDecimal)dataModel.getValue("expenseamount", rowIndex);
        BigDecimal expenseTaxrate = (BigDecimal)dataModel.getValue("taxrate", rowIndex);
        expenseTaxrate = expenseTaxrate.divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_EVEN);
        DynamicObject expenseCurrencyDO = (DynamicObject)dataModel.getValue("entrycurrency", rowIndex);
        int precision = expenseCurrencyDO.getInt("amtprecision");
        if (needRecalculate) {
            BigDecimal airportConstructionAmount = (BigDecimal)dataModel.getValue("airportconstructionfee", rowIndex);
            taxAmount = expenseAmount.subtract(airportConstructionAmount).multiply(expenseTaxrate).divide(BigDecimal.ONE.add(expenseTaxrate), precision, RoundingMode.HALF_EVEN);
        } else {
            taxAmount = (BigDecimal)dataModel.getValue("taxamount", rowIndex);
        }
        BigDecimal noTaxAmount = expenseAmount.subtract(taxAmount);
        dataModel.beginInit();
        String itemFrom = (String)dataModel.getValue("itemfrom", rowIndex);
        Boolean automapinvoice = (Boolean)dataModel.getValue("automapinvoice");
        boolean isFromInCloud = StringUtils.equals((String)itemFrom, (String)ItemFrom.InvoiceCloud.getValue());
        boolean bl = notAllowEdit = automapinvoice != false && isFromInCloud && !ErCommonUtils.isAllowEditTaxAndTaxrate(ErCommonUtils.getPk(dataModel.getValue("company")));
        if (!notAllowEdit) {
            dataModel.setValue("taxamount", (Object)taxAmount, rowIndex);
            dataModel.setValue("approvetax", (Object)taxAmount, rowIndex);
            dataModel.setValue("orientryamount", (Object)noTaxAmount, rowIndex);
            if (((Boolean)dataModel.getValue("offset", rowIndex)).booleanValue()) {
                dataModel.setValue("deductibletax", (Object)taxAmount, rowIndex);
            } else {
                dataModel.setValue("deductibletax", (Object)BigDecimal.ZERO, rowIndex);
            }
            if (dataModel.getDataEntity(true).getDynamicObjectCollection("expenseentryentity").getDynamicObjectType().getProperties().get((Object)"iteminoutamount") != null) {
                AmountChangeUtil.updateInOutAmount(dataModel, rowIndex, -1, ChangeField.DEDUCTIBLE_TAX);
            }
            AmountChangeUtil.updatePrice(dataModel, view, "expenseentryentity", "expeapproveamount", rowIndex, -1, "currency", ChangeField.All);
        } else {
            BigDecimal oldtaxAmount = (BigDecimal)dataModel.getValue("taxamount", rowIndex);
            BigDecimal newTaxAmount = expenseAmount.subtract(oldtaxAmount);
            dataModel.setValue("orientryamount", (Object)newTaxAmount, rowIndex);
        }
        if (StringUtils.equals((String)itemFrom, (String)ItemFrom.EntryImport.getValue())) {
            dataModel.setValue("taxamount", (Object)taxAmount, rowIndex);
            dataModel.setValue("orientryamount", (Object)noTaxAmount, rowIndex);
            if (((Boolean)dataModel.getValue("offset", rowIndex)).booleanValue() && expenseTaxrate.compareTo(BigDecimal.ZERO) > 0) {
                dataModel.setValue("deductibletax", (Object)taxAmount, rowIndex);
                if (dataModel.getDataEntityType().getProperties().get((Object)"iteminoutamount") != null) {
                    dataModel.setValue("iteminoutamount", (Object)BigDecimal.ZERO, rowIndex);
                }
                AmountChangeUtil.updatePrice(dataModel, view, "expenseentryentity", "expeapproveamount", rowIndex, -1, "currency", ChangeField.All);
            }
        }
        InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)view, (int)rowIndex, (int)0);
        dataModel.endInit();
        view.updateView("taxamount", rowIndex);
        view.updateView("orientryamount", rowIndex);
        view.updateView("approvetax", rowIndex);
        view.updateView("deductibletax", rowIndex);
        view.updateView("iteminoutamount", rowIndex);
        view.updateView("price", rowIndex);
    }

    @Deprecated
    public static void updatePrice(IDataModel dataModel, IFormView view, int rowIndex) {
        BigDecimal expeApproveAmount = (BigDecimal)dataModel.getValue("expeapproveamount", rowIndex);
        BigDecimal deductibletax = (BigDecimal)dataModel.getValue("deductibletax", rowIndex);
        BigDecimal approveTax = (BigDecimal)dataModel.getValue("approvetax", rowIndex);
        BigDecimal price = AmountChangeUtil.getNoTaxAmount(expeApproveAmount, deductibletax, approveTax);
        OffsetUtils.setPrice(dataModel, view, price, rowIndex);
    }

    @Deprecated
    public static void setPrice(IDataModel dataModel, IFormView view, BigDecimal price, int rowIndex) {
        dataModel.setValue("price", (Object)price, rowIndex);
        OffsetUtils.setCurPrice(dataModel, view, price, rowIndex);
    }

    @Deprecated
    public static void setCurPrice(IDataModel dataModel, IFormView view, BigDecimal price, int rowIndex) {
        IDataEntityProperty curPriceProp = dataModel.getProperty("curprice");
        if (price != null && curPriceProp != null) {
            BigDecimal exchangeRate = (BigDecimal)dataModel.getValue("exchangerate", rowIndex);
            if (exchangeRate == null || exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
                exchangeRate = BigDecimal.ONE;
            }
            String quoteType = StringUtils.isEmpty((String)"expquotetype") || dataModel.getProperty("expquotetype") == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)dataModel.getValue("expquotetype", rowIndex)), (Object)"0");
            BigDecimal curPrice = StringUtils.equals((String)"1", (String)quoteType) ? price.divide(exchangeRate, AmountUtils.getCurrencyPrecision((IDataModel)dataModel, (String)"currency"), RoundingMode.HALF_UP) : price.multiply(exchangeRate).setScale(AmountUtils.getCurrencyPrecision((IDataModel)dataModel, (String)"currency"), RoundingMode.HALF_UP);
            dataModel.setValue("curprice", (Object)curPrice, rowIndex);
            view.updateView("curprice", rowIndex);
        }
    }

    public static boolean checkDeductibletax(BigDecimal taxAmount, BigDecimal deductibletax) {
        return (taxAmount.compareTo(BigDecimal.ZERO) < 0 || taxAmount.subtract(deductibletax).compareTo(BigDecimal.ZERO) >= 0 && deductibletax.compareTo(BigDecimal.ZERO) >= 0) && (taxAmount.compareTo(BigDecimal.ZERO) >= 0 || taxAmount.subtract(deductibletax).compareTo(BigDecimal.ZERO) <= 0 && deductibletax.compareTo(BigDecimal.ZERO) <= 0);
    }
}

