/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.mservice.rptmediate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.card.DepreciationRptQueryServiceHelper;
import kd.fi.fa.business.constants.FaRptMediateBill;
import kd.fi.fa.business.enums.rpt.FaRptSourceBillEnum;

public class FaRptMediateQueryServiceImpl {
    private static final String Algo_key = FaRptMediateQueryServiceImpl.class.getName();
    private static final Log logger = LogFactory.getLog(FaRptMediateQueryServiceImpl.class);
    private static final String DEPRE_API_FIELDS = "id,accumulated_depre_end_1,fid,depreusename,masterid,depreciation_method.name,depreusenumber,assetcat.level,prepare_use_amount,realcard.assetcat,number,bizperiod,realcard,clearperiod,assetnumber,endperiod,basecurrency,year,assetcatname,assetcatnumber,realcard.assetname,original_value_end_1,currencynumber,period.number,depreciation_method,depreciation_amount,assetbook,orgnumber,accountperiod,orgname,currencyname,assetcat.number,org,category,depre_adjust,accumulated_depre_adjust,original_adjust,actual_depreciation,year_depreciation,original_value_end,accumulated_depre_end,depre_reserves_end,net_value_end,net_amount_end,depreciation_rate,summarytype,original_value_begin,accumulated_depre_begin,net_value_begin,depre_reserves_begin,net_amount_begin,period,period_1_number,bef_adjust_depreciation,aft_adjust_depreciation,realcard.sourceflag sourceflag,org.number orgnumber,depreuse.name depreusename,depreuse.number depreusenumber,basecurrency.number currencynumber,basecurrency.name currencyname,realcard.assetcat.number assetcatnumber,realcard.assetcat.name assetcatname,realcard.number assetnumber";
    private static final String RPT_FIELDS = "period,org,orgnumber,orgname,realcard,assetnumber,assetname,assetcat,assetcatnumber,assetcatname,sourcetypecode,sourceflagcode,changetype,originalvalchg,addupdepre,decvalchg,depreuse,depreusename,depreusenumber,currency,currencyname,currencynumber,changemode,changemodename,changemodenumber,sourceid";

    public DataSet getDataSet(Map<String, Object> param) {
        Object orgIdsParam = param.get("orgIds");
        if (orgIdsParam instanceof List) {
            List orgList = (List)param.get("orgIds");
            Long[] array = new Long[orgList.size()];
            for (Object o : orgList) {
                array[orgList.indexOf(o)] = (Long)o;
            }
            param.put("orgIds", array);
        } else if (orgIdsParam instanceof long[]) {
            long[] orgls = (long[])param.get("orgIds");
            Long[] orgIds = new Long[orgls.length];
            for (int i = 0; i < orgls.length; ++i) {
                orgIds[i] = orgls[i];
            }
            param.put("orgIds", orgIds);
        }
        param.put("showExceptZero", Boolean.FALSE);
        param.put("otherFinFields", new String[]{"realcard.sourceflag sourceflagcode", "org.number orgnumber", "depreuse.name depreusename", "depreuse.number depreusenumber", "basecurrency.number currencynumber", "basecurrency.name currencyname", "realcard.assetcat.number assetcatnumber", "realcard.assetcat.name assetcatname", "realcard.number assetnumber"});
        DataSet dataSet1 = this.getDatasetFromDepre(param);
        DataSet dataSet0 = this.getDatasetFromRptMediate(param);
        if (dataSet0 != null) {
            Field field1;
            Field field0 = dataSet0.getRowMeta().getField("changetype");
            if (!DataType.BooleanType.equals((Object)field0.getDataType())) {
                dataSet0 = dataSet0.updateField("changetype", "changetype = 1");
            }
            if (dataSet1 != null && !DataType.BooleanType.equals((Object)(field1 = dataSet1.getRowMeta().getField("changetype")).getDataType())) {
                dataSet1 = dataSet1.updateField("changetype", "changetype = 1");
            }
            dataSet0 = dataSet0.union(dataSet1);
        } else if (dataSet1 != null) {
            dataSet0 = dataSet1;
        } else {
            return null;
        }
        String[] fieldNames1 = dataSet0.copy().getRowMeta().getFieldNames();
        dataSet0 = dataSet0.leftJoin(this.getSourceFlagDataSet()).on("sourceflagcode", "sourceflagcode").select(fieldNames1, "sourceflag".split(",")).finish();
        String[] fieldNames2 = dataSet0.copy().getRowMeta().getFieldNames();
        dataSet0 = dataSet0.leftJoin(this.getSourceTypeDataSet()).on("sourcetypecode", "sourcetypecode").select(fieldNames2, "sourcetype".split(",")).finish();
        Long startPeriodId = (Long)param.get("startPeriodId");
        Long endPeriodId = (Long)param.get("endPeriodId");
        QFilter qFilter = new QFilter("id", "<=", (Object)endPeriodId).and("id", ">=", (Object)startPeriodId);
        DataSet bdPeriod = QueryServiceHelper.queryDataSet((String)Algo_key, (String)"bd_period", (String)"id,number periodnumber,periodyear", (QFilter[])qFilter.toArray(), (String)"id");
        dataSet0 = dataSet0.leftJoin(bdPeriod).on("period", "id").select(dataSet0.getRowMeta().getFieldNames(), new String[]{"periodnumber", "periodyear"}).finish();
        return dataSet0;
    }

    public List<Map<String, Object>> getDataMap(Map<String, Object> param) {
        DataSet dataSet = this.getDataSet(param);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(dataSet.copy().count("org", false));
        String fields = "sourceid,depreuse,currency,period,org,realcard,assetcat,sourceflag,sourceflagcode,sourcetype,sourcetypecode,changetype,originalvalchg,addupdepre,decvalchg,assetnumber,assetname,orgnumber,orgname,depreusename,depreusenumber,currencyname,currencynumber,assetcatname,assetcatnumber,periodyear,periodnumber,changemode,changemodename,changemodenumber";
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            HashMap<String, Object> map = new HashMap<String, Object>(20);
            for (String field : fields.split(",")) {
                Object value = row.get(field);
                if ("changetype".equals(field)) {
                    String addStr = ResManager.loadKDString((String)"\u589e\u52a0", (String)"FaRptMediateQueryServiceImpl_0", (String)"fi-fa-mservice", (Object[])new Object[0]);
                    String dupStr = ResManager.loadKDString((String)"\u51cf\u5c11", (String)"FaRptMediateQueryServiceImpl_1", (String)"fi-fa-mservice", (Object[])new Object[0]);
                    value = value.toString().equals("true") ? addStr : dupStr;
                }
                map.put(field, value);
            }
            result.add(map);
        }
        dataSet.close();
        return result;
    }

    private DataSet getDatasetFromDepre(Map<String, Object> param) {
        Long queryDepreciationUseIdId = (Long)param.get("depreUseId");
        HashSet<String> otherFields = new HashSet<String>(16);
        ReportQueryParam rptParam = this.checkAndInitParam(param, otherFields);
        rptParam.getCustomParam().put("enableSum", "false");
        DataSet dataSet = DepreciationRptQueryServiceHelper.queryFullDepreciationData((String)Algo_key, (ReportQueryParam)rptParam, otherFields);
        String selectFields = queryDepreciationUseIdId + " depreuse,basecurrency currency,period,org,realcard,realcard.assetcat assetcat,\"fa_rpt_depreciation\" sourcetypecode,sourceflagcode,actual_depreciation>0 changetype,0 originalvalchg,actual_depreciation addupdepre,0 decvalchg,assetnumber,realcard.assetname assetname, orgnumber,orgname,depreusename,depreusenumber,currencyname,currencynumber,assetcatnumber,assetcatname,changemode,changemodename,changemodenumber,fid sourceid";
        dataSet = dataSet.addNullField(new String[]{"changemode", "changemodenumber", "changemodename"});
        return dataSet.select(selectFields).select(RPT_FIELDS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataSet getDatasetFromRptMediate(Map<String, Object> param) {
        Long[] orgIds = (Long[])param.get("orgIds");
        Long startPeriodId = (Long)param.get("startPeriodId");
        Long endPeriodId = (Long)param.get("endPeriodId");
        QFilter qFilter = new QFilter("org", "in", (Object)orgIds);
        qFilter.and("period", ">=", (Object)startPeriodId);
        qFilter.and("period", "<=", (Object)endPeriodId);
        StringBuilder fields = new StringBuilder();
        for (String field : FaRptMediateBill.rptMediateFields) {
            fields.append(field).append(",");
        }
        String selectFields = fields.substring(0, fields.length() - 1) + ",realcard.assetname assetname,org.number orgnumber,org.name orgname,depreuse.name depreusename,depreuse.number depreusenumber,currency.name currencyname,currency.number currencynumber,assetcat.number assetcatnumber,assetcat.name assetcatname,changemode.name changemodename,changemode.number changemodenumber";
        selectFields = selectFields.replace("sourcetype", "sourcetype sourcetypecode").replace("sourceflag", "sourceflag sourceflagcode").replace("changetype", "changetype=\"2\" changetype");
        try (DataSet result = QueryServiceHelper.queryDataSet((String)Algo_key, (String)"fa_rpt_mediate", (String)selectFields, (QFilter[])qFilter.toArray(), (String)"id");){
            DataSet dataSet = result.select(RPT_FIELDS);
            return dataSet;
        }
        catch (Exception e) {
            logger.error("query rptmediate data error,{}", (Object)e.getMessage());
            return null;
        }
    }

    private ReportQueryParam checkAndInitParam(Map<String, Object> queryParam, Set<String> otherFinFieldSet) {
        Object otherFinFieldsObj;
        ReportQueryParam rptQueryParam = new ReportQueryParam();
        ArrayList<String> errInfo = new ArrayList<String>(10);
        FilterInfo filterInfo = new FilterInfo();
        rptQueryParam.setFilter(filterInfo);
        Object orgIdObj = queryParam.get("orgIds");
        if (orgIdObj == null) {
            errInfo.add(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570[orgIds]\uff0c\u7c7b\u578b\u4e3aLong[]\u3002", (String)"FaDepreciationRptQueryServiceImpl_0", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else if (!(orgIdObj instanceof Long[])) {
            errInfo.add(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u4f20\u5165\u7c7b\u578b\u4e3aLong[]\u7684\u53c2\u6570[orgIds]\u3002", (String)"FaDepreciationRptQueryServiceImpl_1", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else {
            Object[] orgIds = (Long[])orgIdObj;
            if (orgIds.length == 0) {
                errInfo.add(ResManager.loadKDString((String)"\u53c2\u6570[orgIds]\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaDepreciationRptQueryServiceImpl_2", (String)"fi-fa-mservice", (Object[])new Object[0]));
            } else {
                Map orgMap = BusinessDataServiceHelper.loadFromCache((Object[])orgIds, (String)"bos_org");
                Set existOrgIdSet = orgMap.keySet();
                boolean existOrgNotFind = false;
                for (Object orgId : orgIds) {
                    if (existOrgIdSet.contains(orgId)) continue;
                    errInfo.add(String.format(ResManager.loadKDString((String)"id\u4e3a[%s]\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"FaDepreciationRptQueryServiceImpl_3", (String)"fi-fa-mservice", (Object[])new Object[0]), orgId));
                    existOrgNotFind = true;
                }
                if (!existOrgNotFind) {
                    MainEntityType bosOrgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
                    DynamicObjectCollection orgList = new DynamicObjectCollection((DynamicObjectType)bosOrgType, null);
                    orgList.addAll(orgMap.values());
                    filterInfo.addFilterItem("q_org", (Object)orgList);
                }
            }
        }
        Object depreUseIdObj = queryParam.get("depreUseId");
        if (depreUseIdObj == null) {
            errInfo.add(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570[depreUseId]\uff0c\u7c7b\u578b\u4e3aLong\u3002", (String)"FaDepreciationRptQueryServiceImpl_4", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else if (!(depreUseIdObj instanceof Long)) {
            errInfo.add(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u4f20\u5165\u7c7b\u578b\u4e3aLong\u7684\u53c2\u6570[depreUseId]\u3002", (String)"FaDepreciationRptQueryServiceImpl_5", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else {
            DynamicObject depreUse = BusinessDataServiceHelper.loadSingleFromCache((Object)depreUseIdObj, (String)"fa_depreuse");
            if (depreUse == null) {
                errInfo.add(String.format(ResManager.loadKDString((String)"id\u4e3a[%s]\u7684\u6298\u65e7\u7528\u9014\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"FaDepreciationRptQueryServiceImpl_6", (String)"fi-fa-mservice", (Object[])new Object[0]), depreUseIdObj.toString()));
            } else {
                filterInfo.addFilterItem("depreuse", (Object)depreUse);
            }
        }
        Object startPeriodIdObj = queryParam.get("startPeriodId");
        if (startPeriodIdObj == null) {
            errInfo.add(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570[startPeriodId]\uff0c\u7c7b\u578b\u4e3aLong\u3002", (String)"FaDepreciationRptQueryServiceImpl_7", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else if (!(startPeriodIdObj instanceof Long)) {
            errInfo.add(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u4f20\u5165\u7c7b\u578b\u4e3aLong\u7684\u53c2\u6570[startPeriodId]\u3002", (String)"FaDepreciationRptQueryServiceImpl_8", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else {
            DynamicObject startPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)startPeriodIdObj, (String)"bd_period");
            if (startPeriod == null) {
                errInfo.add(String.format(ResManager.loadKDString((String)"id\u4e3a[%s]\u7684\u4f1a\u8ba1\u671f\u95f4\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"FaDepreciationRptQueryServiceImpl_9", (String)"fi-fa-mservice", (Object[])new Object[0]), startPeriodIdObj.toString()));
            } else {
                filterInfo.addFilterItem("period_start", (Object)startPeriod);
            }
        }
        Object endPeriodIdObj = queryParam.get("endPeriodId");
        if (endPeriodIdObj == null) {
            errInfo.add(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570[endPeriodId]\uff0c\u7c7b\u578b\u4e3aLong\u3002", (String)"FaDepreciationRptQueryServiceImpl_10", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else if (!(endPeriodIdObj instanceof Long)) {
            errInfo.add(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u4f20\u5165\u7c7b\u578b\u4e3aLong\u7684\u53c2\u6570[endPeriodId]\u3002", (String)"FaDepreciationRptQueryServiceImpl_11", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else {
            DynamicObject endPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)endPeriodIdObj, (String)"bd_period");
            if (endPeriod == null) {
                errInfo.add(String.format(ResManager.loadKDString((String)"id\u4e3a[%s]\u7684\u4f1a\u8ba1\u671f\u95f4\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"FaDepreciationRptQueryServiceImpl_9", (String)"fi-fa-mservice", (Object[])new Object[0]), endPeriodIdObj.toString()));
            } else {
                filterInfo.addFilterItem("period_end", (Object)endPeriod);
            }
        }
        Object showExceptZeroObj = queryParam.get("showExceptZero");
        if (showExceptZeroObj == null) {
            errInfo.add(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u53c2\u6570[showExceptZero]\uff0c\u7c7b\u578b\u4e3aBoolean\u3002", (String)"FaDepreciationRptQueryServiceImpl_12", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else if (!(showExceptZeroObj instanceof Boolean)) {
            errInfo.add(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u4f20\u5165\u7c7b\u578b\u4e3aBoolean\u7684\u53c2\u6570[showExceptZero]\u3002", (String)"FaDepreciationRptQueryServiceImpl_13", (String)"fi-fa-mservice", (Object[])new Object[0]));
        } else {
            Boolean showExceptZero = (Boolean)showExceptZeroObj;
            filterInfo.addFilterItem("showexcept0", (Object)showExceptZero);
        }
        Object finCardFilterObj = queryParam.get("finCardFilter");
        if (finCardFilterObj != null) {
            if (!(finCardFilterObj instanceof String)) {
                errInfo.add(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u4f20\u5165\u7c7b\u578b\u4e3aString\u7684\u53c2\u6570[finCardFilter]\u3002", (String)"FaDepreciationRptQueryServiceImpl_14", (String)"fi-fa-mservice", (Object[])new Object[0]));
            } else {
                String finCardFilterStr = (String)finCardFilterObj;
                QFilter finCardFilter = QFilter.of((String)finCardFilterStr, (Object[])new Object[0]);
                HashMap<String, QFilter> commFilter = new HashMap<String, QFilter>(1);
                commFilter.put("fa_card_fin", finCardFilter);
                filterInfo.setCommFilter(commFilter);
            }
        }
        if ((otherFinFieldsObj = queryParam.get("otherFinFields")) != null) {
            if (!(otherFinFieldsObj instanceof String[])) {
                errInfo.add(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u4f20\u5165\u7c7b\u578b\u4e3aString[]\u7684\u53c2\u6570[otherFinFields]\u3002", (String)"FaDepreciationRptQueryServiceImpl_15", (String)"fi-fa-mservice", (Object[])new Object[0]));
            } else {
                String[] otherFinFields = (String[])otherFinFieldsObj;
                otherFinFieldSet.addAll(Arrays.asList(otherFinFields));
            }
        }
        if (!errInfo.isEmpty()) {
            String msg = String.join((CharSequence)"\r\n", errInfo);
            throw new KDBizException(msg);
        }
        return rptQueryParam;
    }

    private DataSet getSourceTypeDataSet() {
        FaRptSourceBillEnum[] values;
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("sourcetypecode", (DataType)DataType.StringType), new Field("sourcetype", (DataType)DataType.StringType)});
        DataSetBuilder dataSetBuilder = Algo.create((String)Algo_key).createDataSetBuilder(rowMeta);
        for (FaRptSourceBillEnum e : values = FaRptSourceBillEnum.values()) {
            Object[] value = new String[]{e.getName(), e.getValue()};
            dataSetBuilder.append(value);
        }
        return dataSetBuilder.build();
    }

    private DataSet getSourceFlagDataSet() {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("sourceflagcode", (DataType)DataType.StringType), new Field("sourceflag", (DataType)DataType.StringType)});
        DataSetBuilder dataSetBuilder = Algo.create((String)Algo_key).createDataSetBuilder(rowMeta);
        String[] codes = "ADD,PURCHASE,INITIAL,IMPORT,DISPATCH,SPLIT,COMBIN,INVENTORYPROFIT,ENGINEERINGTRANS,LEASECONTRACT,INITLEASECONTRACT,DATAASSET,SCAN,INVENTORY".split(",");
        for (int i = 0; i < 14; ++i) {
            Object[] value = new String[]{codes[i], SourceFlagEnum.values()[i].getName()};
            dataSetBuilder.append(value);
        }
        return dataSetBuilder.build();
    }
}

