/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.busyrecord.AbstractBusyRecordServicePlugin;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.business.utils.FaBizCtrSource;
import kd.fi.fa.business.utils.FaBizCtrUtils;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;

public class AbstractBizCtrOperationServicePlugIn
extends AbstractBusyRecordServicePlugin {
    private static final String USEPURPOSE_CLEARAPPLY = "CLEARAPPLY_EXCLUSIVE";

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        MainEntityType entityType = this.billEntityType;
        String curBillentityname = entityType.getName();
        QFilter[] filters = new QFilter[]{new QFilter("billentityname", "=", (Object)curBillentityname), new QFilter("usepurpose", "=", (Object)USEPURPOSE_CLEARAPPLY)};
        DynamicObject oneBizctrBill = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_card_bizctr_billset", (QFilter[])filters);
        boolean isExistsEntity = true;
        if (oneBizctrBill == null) {
            isExistsEntity = false;
        }
        if (!isExistsEntity) {
            return;
        }
        QFilter[] filters2 = new QFilter[]{new QFilter("billentityname", "=", (Object)curBillentityname)};
        DynamicObject metaBillRealcardR = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_meta_bill_realcard_r", (QFilter[])filters2);
        if (metaBillRealcardR == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6[%s]\u6ca1\u6709\u914d\u7f6e\u5355\u636e\u5143\u6570\u636e\u5b9e\u7269\u57fa\u7840\u8d44\u6599\u5bf9\u5e94\u5173\u7cfb", (String)"AbstractBizCtrOperationServicePlugIn_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), curBillentityname));
        }
        String realEntityName = metaBillRealcardR.getString("realentity");
        String realFieldName = metaBillRealcardR.getString("realfield");
        String operationKey = e.getOperationKey();
        HashMap<String, DynamicObject> billId2Bill = null;
        if (operationKey.equalsIgnoreCase("save") || operationKey.equalsIgnoreCase("submit")) {
            DynamicObject[] oldBills;
            DynamicObject[] bills = e.getDataEntities();
            if (bills == null || e.getDataEntities().length == 0) {
                return;
            }
            billId2Bill = new HashMap<String, DynamicObject>(FaUtils.getInitialCapacity43((int)bills.length));
            Object[] pkArray = Stream.of(bills).map(v -> v.getPkValue()).toArray(Object[]::new);
            for (DynamicObject oldBill : oldBills = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)curBillentityname))) {
                billId2Bill.put(oldBill.getPkValue() + ".", oldBill);
            }
        }
        for (DynamicObject bill : e.getDataEntities()) {
            DynamicObject oldBill;
            if ("fa_clearapplybill".equals(curBillentityname) && operationKey.equalsIgnoreCase("audit")) {
                DynamicObject mainBook;
                Date enddate;
                boolean genClearBillByApplyDate = FaBillParamUtils.getBooleanValue(null, null, null, (String)"genclearbill_datetype");
                Date clearDate = bill.getDate("auditdate");
                if (genClearBillByApplyDate) {
                    clearDate = bill.getDate("cleardate");
                }
                if (clearDate.after(enddate = (mainBook = FaBizUtils.getAsstBookByOrg((Long)bill.getLong(Fa.dot((String[])new String[]{"org", "id"})))).getDate("enddate"))) continue;
            }
            if ((operationKey.equalsIgnoreCase("save") || operationKey.equalsIgnoreCase("submit")) && billId2Bill != null && billId2Bill.size() != 0 && (oldBill = (DynamicObject)billId2Bill.get(bill.getPkValue() + ".")) != null) {
                this.updateBizCtrForBillService(curBillentityname, oldBill, true, operationKey, realEntityName, realFieldName);
            }
            this.updateBizCtrForBillService(curBillentityname, bill, false, operationKey, realEntityName, realFieldName);
        }
    }

    private void updateBizCtrForBillService(String curBillentityname, DynamicObject bill, boolean isFromDB, String operationKey, String realEntityName, String realFieldName) {
        boolean isForSaveData;
        Object realCard;
        Long curSourceId = (Long)bill.getPkValue();
        HashSet<Long> rMasterIdSet = new HashSet<Long>(999);
        if ("fa_mergebill".equals(curBillentityname)) {
            for (DynamicObject parentEntry : bill.getDynamicObjectCollection("inentryentity")) {
                if ("1".equals(bill.getString("type")) && null != (realCard = parentEntry.getDynamicObject("inrealcard"))) {
                    rMasterIdSet.add(realCard.getLong("masterid"));
                }
                realCard = parentEntry.getDynamicObjectCollection("outentryentity").iterator();
                while (realCard.hasNext()) {
                    DynamicObject childEntry = (DynamicObject)realCard.next();
                    DynamicObject realCard2 = childEntry.getDynamicObject("outrealcard");
                    if (null == realCard2) continue;
                    rMasterIdSet.add(realCard2.getLong("masterid"));
                }
            }
        } else {
            for (DynamicObject everyRow : bill.getDynamicObjectCollection(realEntityName)) {
                realCard = everyRow.getDynamicObject(realFieldName);
                if (null == realCard) continue;
                rMasterIdSet.add(realCard.getLong("masterid"));
            }
        }
        ArrayList<FaBizCtrSource> fromSourceList = new ArrayList<FaBizCtrSource>(1);
        Long toSourceId = curSourceId;
        String toSourceEntityName = curBillentityname;
        boolean bl = isForSaveData = operationKey.equalsIgnoreCase("save") || operationKey.equalsIgnoreCase("submit");
        if (isFromDB && isForSaveData) {
            fromSourceList.add(new FaBizCtrSource(curSourceId, curBillentityname));
            toSourceId = 0L;
            toSourceEntityName = "NOENTITYNAME";
        } else if (!isFromDB && isForSaveData) {
            fromSourceList.add(new FaBizCtrSource(Long.valueOf(0L), "NOENTITYNAME"));
        } else if (operationKey.equalsIgnoreCase("audit") || operationKey.equalsIgnoreCase("delete")) {
            fromSourceList.add(new FaBizCtrSource(curSourceId, curBillentityname));
            toSourceId = 0L;
            toSourceEntityName = "NOENTITYNAME";
        } else if (operationKey.equalsIgnoreCase("unaudit")) {
            boolean isgenclearbill;
            FaBizCtrSource faBizCtrSource = new FaBizCtrSource(Long.valueOf(0L), "NOENTITYNAME");
            if ("fa_clearapplybill".equals(curBillentityname) && !(isgenclearbill = bill.getBoolean("isgenclearbill"))) {
                faBizCtrSource = new FaBizCtrSource(curSourceId, curBillentityname);
            }
            fromSourceList.add(faBizCtrSource);
        }
        FaBizCtrUtils.batchUpdateBizCtrForBill(rMasterIdSet, fromSourceList, (Long)toSourceId, (String)toSourceEntityName);
    }
}

