/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.MonthClose;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.BillStatus;
import kd.bos.ext.fi.fcm.CheckContext;
import kd.bos.ext.fi.fcm.CheckResult;
import kd.bos.ext.fi.fcm.IClosePeriodCheckPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.enums.lease.LeaseContractBizStatus;
import kd.fi.fa.common.util.Fa;

public class LeaseContractPushCardCheck
implements IClosePeriodCheckPlugin {
    public CheckResult execute(CheckContext context) throws Throwable {
        CheckResult checkResult = new CheckResult();
        checkResult.setMessages(Collections.singletonList(LeaseContractPushCardCheck.buildSuccessMsg()));
        checkResult.setIsSuccess(Boolean.TRUE.booleanValue());
        Long orgId = context.getOrgId();
        Long assetBookPeriodId = context.getPeriodId();
        if (QueryServiceHelper.exists((String)"fa_lease_init", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("startperiod", ">", (Object)assetBookPeriodId)})) {
            return checkResult;
        }
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("isexempt", "=", (Object)Boolean.FALSE), new QFilter("bizstatus", "=", (Object)LeaseContractBizStatus.A.name()), new QFilter("isbak", "=", (Object)Boolean.FALSE), new QFilter("sourcetype", "=", (Object)"A"), new QFilter("leasetermstartdate", "<=", (Object)context.getPeriodEndDate())};
        String field = Fa.comma((String[])new String[]{"id", "status", "assetqtycreate"});
        DynamicObjectCollection data = QueryServiceHelper.query((String)"fa_lease_contract", (String)field, (QFilter[])filters);
        HashSet<Long> ids = new HashSet<Long>(data.size());
        HashSet<Long> trackIds = new HashSet<Long>(data.size());
        for (DynamicObject lease : data) {
            long id = lease.getLong("id");
            String status = lease.getString("status");
            if (!BillStatus.C.name().equals(status)) {
                ids.add(id);
                continue;
            }
            int createQty = lease.getInt("assetqtycreate");
            if (createQty == 1) {
                ids.add(id);
                continue;
            }
            trackIds.add(id);
        }
        if (!trackIds.isEmpty()) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"fa_card_real", (String)"srcbillid", (QFilter[])new QFilter[]{new QFilter("srcbillid", "in", trackIds), new QFilter("mergedcard", "=", (Object)false), new QFilter("billstatus", "=", (Object)BillStatus.C)});
            Set leaseIds = query.stream().map(v -> v.getLong("srcbillid")).collect(Collectors.toSet());
            trackIds.removeAll(leaseIds);
            ids.addAll(trackIds);
        }
        if (!ids.isEmpty()) {
            checkResult.setOnlineViewId("fa_lease_contract");
            QFilter idFilter = new QFilter("id", "in", ids);
            checkResult.setOnlineQueryParams(idFilter.toSerializedString());
            checkResult.setMessages(Collections.singletonList(LeaseContractPushCardCheck.buildFailMsg(ids.size())));
            checkResult.setIsSuccess(Boolean.FALSE.booleanValue());
        }
        return checkResult;
    }

    private static String buildSuccessMsg() {
        return ResManager.loadKDString((String)"\u5408\u540c\u5168\u90e8\u4e0b\u63a8\u5b8c\u6210\u3002", (String)"LeaseContractPushCardCheck_0", (String)"bos-ext-fi", (Object[])new Object[0]);
    }

    private static String buildFailMsg(int count) {
        return ResManager.loadKDString((String)"\u5b58\u5728%s\u5f20\u5408\u540c\u8fd8\u672a\u751f\u6210\u5ba1\u6838\u8d22\u52a1\u5361\u7247\u3002", (String)"LeaseContractPushCardCheck_1", (String)"bos-ext-fi", (Object[])new Object[]{count});
    }
}

